// This file Copyright © Transmission authors and contributors.
// It may be used under the MIT (SPDX: MIT) license.
// License text can be found in the licenses/ folder.

#import "ExpandedPathToPathTransformer.h"

@implementation ExpandedPathToPathTransformer

+ (Class)transformedValueClass
{
    return [NSString class];
}

+ (BOOL)allowsReverseTransformation
{
    return NO;
}

- (id)transformedValue:(id)value
{
    return value == nil ? nil : [NSFileManager.defaultManager displayNameAtPath:value];
}

@end
