# Announce: Rakudo compiler, Release #133 (2020.01)

On behalf of the Rakudo development team, I’m very happy to announce the
January 2020 release of Rakudo #133. Rakudo is an implementation of
the Raku[^1] language.

The source tarball for this release is available from
<https://rakudo.org/files/rakudo>.
Pre-compiled archives will be available shortly.

New in 2020.01:
  + Changes:
    + A big overhaul of role applying rules and behavior or
      submethods, constructors and destructors
      [38c72649][a8f61882][cddcd46a][61d3aef2][27147ed0][cbc4b839]
      [3f7caf57][f242bcfa][cd74a3a7][51055d0e][9369c68e][ad92abc3]
      [00fec7c3][6f0dd1ea][c9ac15cb][cb903667][d89a0c92][a08e1ff5]
      [c674a1d3][0654d3e5][fffb5c9c][232382f8][b47be208][44648fbe]
      [c2d5c20c][48fc44c2][7afffd61][17537ab5][b1e288c3][32e210cd]
      [fc4a5a3b][1e166e41][7a94c4e0][3eb63b3d][a4ad1a8e][526d38d4]
      [9e4087e1][aeb10ef5][c4f1cff0][1f620408][b83e069d][4d69fda5]
      [c7a87053][13ae9298][0fb7a697][86b1ccbd][ca2cb4ab][e843fd20]
      [a92ade48][bdcf3149][93d0575c][23191207][595e0ca3][2c4fa983]
      [b51c1fc5][afcbeb59][eadc1582][548dea5f][1aad3481][4a962e07]
      [0b6a9343][bb2600d9][5d10e91c][139d528b][f2a41613][262b6fc7]
    + Smartmatching typed Arrays against same-typed Positionals now
      returns True (e.g. `Array[Str:D] ~~ Positional[Str:D]`), which
      returned False before [fb55ae29]
    + Class attributes and methods are now prioritized over those from
      roles [f19e2ee5][2fc87db1][4c265c7c][9357eddb][83d26ddd][9f2a2f6a][55b51a24]
    + DateTime class now accepts picosecond precision [9eef0e63]
    + Make default degree for hyper/batch utilize number of CPU cores better
      [9fd29cd2][5def05c9][3f51728d]
    + `$*ARGFILES` special variable now defaults to `$*IN` if no arguments [bde10698]
    + An attempt to use methods `index`, `indiced`, `contains` on a `List`
      now gives a warning [c9b02185]
  + Fixes:
    + Fix repository name lookup on windows [13c5d046]
    + Fix leaking file handles when loading modules [1c467401]
    + Fix Parameter.sigil for anonymous scalar params with default values [8c0a5d6b]
    + Fix raw slurpy onearg parameter handling in Parameter.raku [33993023]
    + Fix construction of Parameter object [68808c54]
    + Fix error when calling Parameter.usage-name on unnamed parameters [81311a20]
    + Fix hang when initializing `Int` with a type object [0e9f96ea]
    + Fix missing dependency information when precompiling large dependency trees [9fa82b80]
    + Fix off-by-one error in Supply.head(limit) [80f60c05]
    + Fix for parameterized roles not found for FQN lookup if applied to a
      parent class [27b3db27]
    + Fix double execution of ENTER block in some cases [d8c7d879]
    + Fixed compile-time subroutine candidate matching when `is rw`
      trait is used on JVM [12d4514a][fae105b0][73d5e74d][d81212b2][5c65a126]
    + Improved error message for invalid Pod6 leading and trailing
      declarator blocks [26f63ff7]
    + Prevented `ASSIGN-POS` method on `Any` from decontainerizing,
      allowing its correct overloading in roles [ed8f5141]
    + Prevent `name` MOP method from returning a `NQPMu` when no name
      is set by returning an empty string instead [dabf83a2]
    + Fixed relocatability of bundled native libraries
      [55b3ed56][0e4f8351]
    + Made `Range.int-bounds(from,to)` always return correct result
      [8c3f2927]
    + Fixed a precompilation bug related to determining class language
      version [15a55801]
    + Fix "expected IO::Handle:D but got IO::Handle" in parallel test
      runs [efadff2a]
    + Fix calling a qualified method from role on JVM backend [5648a4f3]
    + Fix `roundrobin` method, cross and zip operators on a 1-element
      lists [f602c02c][737dd1b1][87de5ee4]
    + Fix MoarVM::Profiler.report [734047a0]
  + Additions:
    + Add `Version` type coercer to `Str` [e3cbd32c]
    + Add `Supply.repeated` method [ff08697a]
    + Add `Supply.decode($encoding)` method [59f6a031]
    + Add `Supply.first` method [ace98531]
    + Add `Supply.collate` method [40797028]
    + Allow Supply.head(*-3) to be synonym of Supply.tail(3) [6d6318d4]
    + Add `Supply.encode($encoding = "utf8")` method [5d6c0b6b]
    + Add `Supply.comb` method [348d54df][3dd9edff][67ec4b2b]
      [1331128f][07dce515][147ce39e][550bf097][a666e736][92d465db]
      [622b20fb][f74e506f][f8724459]
    + Add new `is built` attribute trait
      [e76f8e4d][98abd6a7][e81b0b68][826c3ead][f1f690e0][ada7c365]
      [ecf8a3f4][7bbb76da][8ab53027][3f0dca4f]
    + Add `Supply.split` method
      [cac64caa][4fa60ab5][c16a6484][9b29bcc4][2188f13b]
    + Add `Supply.lines(:nl-in<foo>)` method [c63d8a87]
    + Allow user to retain formatting of Pod6 leading declarator
      blocks (`#|`) using RAKUDO_POD_DECL_BLOCK_USER_FORMAT env var,
      instead of always collapsing them into a single string. The
      latter remains the default behavior [9a4c83af]
    + Made `.perl` (now `.raku`) method call on signature of {...} display `$_`
      variable from outer scope [e7c20386]
    + Add `$*RAKU` variable [a05e169e]
    + `Raku` is now allowed to be used as a language in EVAL
      [1c5d010f][632c0083]
    + Add `:$match` named parameter to `comb` subroutine when called
      on `Cool` object when the `$matcher` argument is a `Regex`
      [dd2f072d][a9cd6404]
    + Add `log2` subroutine, which accepts `Cool` and `Numeric`
      arguments, as well as its method form (`Numeric.log2`)
      [f6254be1]
    + Allowed colon syntax on `$.foo` method, making `$.foo: 42` work
      as well as equivalent `self.foo: 42`
      does [4a1323ed][6abdf27a][0f86e49f]
    + Add `RAKU_EXCEPTIONS_HANDLER` env variable,
      which is not supported as an alias for `PERL6_EXCEPTIONS_HANDLER` [90408d18]
  + Build system:
    + Renamed `PERL6_HOME` env var into `RAKUDO_HOME`, preserving
      backward compatibility. Rakudo `Configure.pl` now accepts
      `--rakudo-home` in addition to `--perl6-home` [7cfdd598]
    + Add `--force-rebuild` command line option. Together with
      `--gen-*` options is causes corresponding components to
      recompile irrelevant to their existence and version
      conformance [15255b0a][2022b9cd][1945b9d2]
    + Fix `set-env.sh` script [0b8ede6c]
    + Fix `raku` symlinks relocability [a00628e0]
    + Prevent silently swallowing errors on submodule update
      [db43d134]
    + Use Visual Studio 2017 in AppVeyor [7ecc5bfd][7ce49472]
    + Various tweaks and small improvements
      [75056dfa][8b7d0651][52a7bab9][d7d9a2f4][470c9b7e]
    + Skip 'make test' on JVM backend [e5627b83]
  + Efficiency:
    + Make `StrDistance.new` about 30% faster [91a324a0]
    + Make `Rational.Str` 10% faster [272b658a]
    + Make `Rational.Str` a few % faster with 20% fewer allocations [73e98a6c]
    + Make `Rational.base` at least 2.5x as fast [97e7cdbd]
    + Make `Array[Int].raku` at least 5% faster [66cf6f81]
    + Make `NumStr.raku` about 60% faster [e262da1d]
    + Make `IntStr.raku` about 2x as fast [2261ef11]
    + Optimize `Pair.raku` [0d96bedc][08aec410]
    + Make `Mu.raku` about 40% faster [585227ee]
    + Optimize `Str.raku` [09e66e50][a4b62fb1]
    + Make `Str.rindex` a few percent faster [7ecc3e84]
    + Make `Str.index` a few percent faster [d5719bbe]
    + Make `Str.contains` a few percent faster [030ed10d]
    + Make `Str.substr-eq` between 1.4x and 2.4x faster [276d0967]
    + Made `Str.chomp` between 10x and 100x faster [b9c0196f]
    + Made `Str.chop(N)` between 3x and 17x faster [b569e112]
    + Made `Str.chop` between 1.8x and 30x faster [f1963623]
    + Made `Str.trim-trailing` up to 2x as fast [657d36f1]
    + Made `Str.trim` between 1.5x and 3x faster [0d0d419f]
    + Made `Str.substr(N)` between 1.5 and 3x faster [4252a8c9]
    + Made `Str.substr(N,M)` about 1.5x faster [908dd251]
    + Made `Str.substr(N, Inf)` about 15% faster [25a29987]
    + Made `Str.trim-leading` between 20x and 90x faster [3941fef0]
    + Made `Str.parse-base` between 7x (with decimal point) and 12x
      (without) faster, decreased its memory pressure
      [74c8017c][3ce92453][9b8ce733]
    + Made `Str.Numeric` a few percent faster and 13x faster for an
      empty string [37474a7a]
    + Made Str.Int a few percent faster [b42957cc]
    + Made DateTime.new(epoch) about 20% faster [9d895914]
    + Made DateTime.new($epoch) about 50% faster [cd321254]
    + Made the decont operator about 20x faster [872cb7c0]
    + Improved efficiency of JIT for `split` subroutine [3e2cfb4d]
    + Fix regression in performance of async socket [4e9487ce]
    + Micro-optimize `set_name` MOP method [88741d94]
    + Make `lazy gather` up to 15% faster [971174f4]
    + Make emit about 30% faster [aea2a36c]
    + Make `take foo` about 20% faster [a91813d0]
    + Make `take-rw foo` about 20% faster [533a2ad9]
    + Make `take foo, bar` about 60% faster [e1aaa83c]
    + Make `take-rw foo, bar` about 60% faster [bed716be]
    + Make Supply.lines a few percent faster [0f4ef3cb]
    + Numerous micro-optimizations [f5583de4]
      [05aff922][488f21a6][9c15d717][6c85e691][60a9ff62][779b0a2e]
      [fc8bfc2e][11a8d57f][392af08b][33266694]
  + Internal:
    + Add mechanism for seeding typename suggestions [b291fc78]
    + Removed SUBSTR-(START|CHARS)-OOR from Rakudo::Internals, they
      are now `Str` private methods [ab99c2dd]
    + Simplify `Str.substr` implementation
      [99a0610a][1a891062][e3426579][f79102fa]
    + Fixed some regressions related to `v6.e.PREVIEW` usage
      [6c251f27][8d03bdff][94b4ca96][466f7de4][65847f71][a59fec7f][755c8030][0d2eb1cb]
    + Reflect Raku renaming on codebase [604ca34a][186c4ce6]
    + Numerous small codebase improvements, including ones related to
      renaming process
      [8f30cc76][fc309419][540162c1][6a129499][1003bb93][68cee0dd]
      [2652d9c5][f9e30a02][ee66a6b1][a04af365][11808277][0e2485a8]
      [e8a9e07f][17d81160][d5a34f19][6bd0dd51][cfb655bc][b1a68be4]
      [74aea829][80cbb3ef][83423ea0][d38cfef3][d406d834][62bd2743]
      [6bf6d347][e4efccc6][6f527cea][b7888d79][7ce79f4d][5f335aa4]
      [9a5579ff][784daae2][add2ec0d][abcf37f2][a51268a1][b9fa673b]
      [3d432429][f06c2426][f1abe9c6][bd2e0c7a][22905592][8c4244f6]
      [829f4ccb][4f48e3a5][27d1c4b5][5d8ef435][ccb92df2][8ad3d244]
      [70f96d9b][276c06d3][d6970e96][3e332a1a][06292bc8][8cfa6590]
      [f08cd00f][7b075188][b1e986c2][0e9792c7][43669806][7925bfd4]
      [82913377][fa355a26][19b820d8][06ae7d61][86a771ac][aafa8ca2]
      [25e6128c][fdffa474][77d8fa37][ed44f60a][666f95c1][56d2b23d]
      [0d81a867][b7870953][37ddd598][87bc1171]


The following people contributed to this release:

Elizabeth Mattijsen, Vadim Belman, Stefan Seifert, Daniel Green, 
Stoned Elipot, Juan Julián Merelo Guervós, Tom Browder, Will "Coke" Coleda, 
Aleks-Daniel Jakimenko-Aleksejev, Patrick Böker, Ben Davies, 
Peter du Marchie van Voorthuysen, Alexander Kiryuhin, threadless-screw, 
Christian Bartolomäus, Paweł Murias, Rod Taylor, Sterling Hanenkamp, 
ZhongnianTao, Bahtiar Gadimov, Richard Hainsworth, Timo Paulssen, 
Tobias Boege, Jan-Olof Hendig, Joelle Maslak, Luis F. Uceta, 
Nguyễn Gia Phong, Nick Logan, Samantha McVey, Vittore F. Scolari, 
alexandrianlibrarian, ven


This release implements 6.c and 6.d versions of the Raku specification.
6.c version of the language is available if you use the `use v6.c`
version pragma, otherwise 6.d is the default.

Upcoming releases in 2020 will include new functionality that is not
part of 6.c or 6.d specifications, available with a lexically scoped
pragma. Our goal is to ensure that anything that is tested as part of
6.c and 6.d specifications will continue to work unchanged. There may
be incremental spec releases this year as well.

If you would like to contribute or find out more information, visit
<https://raku.org>, <https://rakudo.org/how-to-help>, ask on the
<perl6-compiler@perl.org> mailing list, or ask on IRC #raku on freenode.

Additionally, we invite you to make a donation to The Perl Foundation
to sponsor Raku development: <https://donate.perlfoundation.org/>
(put “Raku Core Development Fund” in the ‘Purpose’ text field)

The next release of Rakudo (#134), is tentatively scheduled for 2020-02-22.

A list of the other planned release dates is available in the
“docs/release_guide.pod” file.

The development team appreciates feedback! If you’re using Rakudo, do
get back to us. Questions, comments, suggestions for improvements, cool
discoveries, incredible hacks, or any other feedback – get in touch with
us through (the above-mentioned) mailing list or IRC channel. Enjoy!

Please note that recent releases have known issues running on the JVM.
We are working to get the JVM backend working again but do not yet have
an estimated delivery date.

[^1]: See <https://raku.org/>
