% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objects.R
\name{TopCells}
\alias{TopCells}
\title{Find cells with highest scores for a given dimensional reduction technique}
\usage{
TopCells(object, dim = 1, ncells = 20, balanced = FALSE, ...)
}
\arguments{
\item{object}{DimReduc object}

\item{dim}{Dimension to use}

\item{ncells}{Number of cells to return}

\item{balanced}{Return an equal number of cells with both + and - scores.}

\item{...}{Extra parameters passed to \code{\link{Embeddings}}}
}
\value{
Returns a vector of cells
}
\description{
Return a list of genes with the strongest contribution to a set of components
}
\examples{
data("pbmc_small")
pbmc_small
head(TopCells(object = pbmc_small[["pca"]]))
# Can specify which dimension and how many cells to return
TopCells(object = pbmc_small[["pca"]], dim = 2, ncells = 5)

}
\concept{objects}
