// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::{Display, Window};
use glib::translate::*;
use std::{fmt, mem, ptr};

glib::wrapper! {
    #[doc(alias = "GdkGLContext")]
    pub struct GLContext(Object<ffi::GdkGLContext>);

    match fn {
        type_ => || ffi::gdk_gl_context_get_type(),
    }
}

impl GLContext {
    #[doc(alias = "gdk_gl_context_get_debug_enabled")]
    #[doc(alias = "get_debug_enabled")]
    pub fn is_debug_enabled(&self) -> bool {
        unsafe { from_glib(ffi::gdk_gl_context_get_debug_enabled(self.to_glib_none().0)) }
    }

    #[doc(alias = "gdk_gl_context_get_display")]
    #[doc(alias = "get_display")]
    pub fn display(&self) -> Option<Display> {
        unsafe { from_glib_none(ffi::gdk_gl_context_get_display(self.to_glib_none().0)) }
    }

    #[doc(alias = "gdk_gl_context_get_forward_compatible")]
    #[doc(alias = "get_forward_compatible")]
    pub fn is_forward_compatible(&self) -> bool {
        unsafe {
            from_glib(ffi::gdk_gl_context_get_forward_compatible(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gdk_gl_context_get_required_version")]
    #[doc(alias = "get_required_version")]
    pub fn required_version(&self) -> (i32, i32) {
        unsafe {
            let mut major = mem::MaybeUninit::uninit();
            let mut minor = mem::MaybeUninit::uninit();
            ffi::gdk_gl_context_get_required_version(
                self.to_glib_none().0,
                major.as_mut_ptr(),
                minor.as_mut_ptr(),
            );
            (major.assume_init(), minor.assume_init())
        }
    }

    #[doc(alias = "gdk_gl_context_get_shared_context")]
    #[doc(alias = "get_shared_context")]
    #[must_use]
    pub fn shared_context(&self) -> Option<GLContext> {
        unsafe {
            from_glib_none(ffi::gdk_gl_context_get_shared_context(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gdk_gl_context_get_use_es")]
    #[doc(alias = "get_use_es")]
    pub fn uses_es(&self) -> bool {
        unsafe { from_glib(ffi::gdk_gl_context_get_use_es(self.to_glib_none().0)) }
    }

    #[doc(alias = "gdk_gl_context_get_version")]
    #[doc(alias = "get_version")]
    pub fn version(&self) -> (i32, i32) {
        unsafe {
            let mut major = mem::MaybeUninit::uninit();
            let mut minor = mem::MaybeUninit::uninit();
            ffi::gdk_gl_context_get_version(
                self.to_glib_none().0,
                major.as_mut_ptr(),
                minor.as_mut_ptr(),
            );
            (major.assume_init(), minor.assume_init())
        }
    }

    #[doc(alias = "gdk_gl_context_get_window")]
    #[doc(alias = "get_window")]
    pub fn window(&self) -> Option<Window> {
        unsafe { from_glib_none(ffi::gdk_gl_context_get_window(self.to_glib_none().0)) }
    }

    #[doc(alias = "gdk_gl_context_is_legacy")]
    pub fn is_legacy(&self) -> bool {
        unsafe { from_glib(ffi::gdk_gl_context_is_legacy(self.to_glib_none().0)) }
    }

    #[doc(alias = "gdk_gl_context_make_current")]
    pub fn make_current(&self) {
        unsafe {
            ffi::gdk_gl_context_make_current(self.to_glib_none().0);
        }
    }

    #[doc(alias = "gdk_gl_context_realize")]
    pub fn realize(&self) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let is_ok = ffi::gdk_gl_context_realize(self.to_glib_none().0, &mut error);
            debug_assert_eq!(is_ok == glib::ffi::GFALSE, !error.is_null());
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[doc(alias = "gdk_gl_context_set_debug_enabled")]
    pub fn set_debug_enabled(&self, enabled: bool) {
        unsafe {
            ffi::gdk_gl_context_set_debug_enabled(self.to_glib_none().0, enabled.into_glib());
        }
    }

    #[doc(alias = "gdk_gl_context_set_forward_compatible")]
    pub fn set_forward_compatible(&self, compatible: bool) {
        unsafe {
            ffi::gdk_gl_context_set_forward_compatible(
                self.to_glib_none().0,
                compatible.into_glib(),
            );
        }
    }

    #[doc(alias = "gdk_gl_context_set_required_version")]
    pub fn set_required_version(&self, major: i32, minor: i32) {
        unsafe {
            ffi::gdk_gl_context_set_required_version(self.to_glib_none().0, major, minor);
        }
    }

    #[doc(alias = "gdk_gl_context_set_use_es")]
    pub fn set_use_es(&self, use_es: i32) {
        unsafe {
            ffi::gdk_gl_context_set_use_es(self.to_glib_none().0, use_es);
        }
    }

    #[doc(alias = "gdk_gl_context_clear_current")]
    pub fn clear_current() {
        assert_initialized_main_thread!();
        unsafe {
            ffi::gdk_gl_context_clear_current();
        }
    }

    #[doc(alias = "gdk_gl_context_get_current")]
    #[doc(alias = "get_current")]
    pub fn current() -> Option<GLContext> {
        assert_initialized_main_thread!();
        unsafe { from_glib_none(ffi::gdk_gl_context_get_current()) }
    }
}

impl fmt::Display for GLContext {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("GLContext")
    }
}
