## Usage

To be considered a dotfile, it must be the last filename in the path, like `.gitignore`. Otherwise it's a [dot directory][is-dotdir], like `.git/` and `.github/`.

```js
var isDotfile = require('{%= name %}');
```

**false**

All of the following return `false`:

```js
isDotfile('a/b/c.js');
isDotfile('/.git/foo');
isDotfile('a/b/c/.git/foo');
//=> false
```

**true**

All of the following return `true`:

```js
isDotfile('a/b/.gitignore');
isDotfile('.gitignore');
isDotfile('/.gitignore');
//=> true
```
