// Copyright (c) 2010, Jens Peter Secher <jpsecher@gmail.com>
//
// Permission to use, copy, modify, and/or distribute this software for any
// purpose with or without fee is hereby granted, provided that the above
// copyright notice and this permission notice appear in all copies.
//
// THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
// WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
// ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
// WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
// ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
// OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

// Structure for iterating over a Process' output.

class ProcessOutputIterator
implements Iter<String>
{
	public function new( stream : haxe.io.Input )
	{
		this.stream = stream;
	}

	// Implementation of Iterable<String>;
	public function iterator() : Iterator<String>
	{
		return this;
	}

	// Implementation of Iterator<String>.
	public function next() : String
	{
		return line;
	}

	// Implementation of Iterator<String>.
	public function hasNext() : Bool
	{
		try
		{
			line = stream.readLine();
			return true;
		}
		catch( e : haxe.io.Eof )
		{
			return false;
		}
	}
	
	var stream : haxe.io.Input;

	var line : String;
}
