#include "ds_rr.h"

namespace ADNS {

		DS_RR::DS_RR()
		{
			rr_type = RR_TYPE::DS;
		}

		UInt16 DS_RR::GetKeyTag()
		{
			return KeyTag;
		}

		Void DS_RR::SetKeyTag(UInt16 kt)
		{
			KeyTag = kt;
			UpdateRdata();
			return;
		}
		
		CRYPTO_ALGORITHM DS_RR::GetCryptoAlgorithm()
		{
			return (CRYPTO_ALGORITHM) crypto_algo;
		}

		Void DS_RR::SetCryptoAlgorithm(CRYPTO_ALGORITHM h)
		{
			crypto_algo = h;
			UpdateRdata();
			return;
		}

		Byte DS_RR::GetDigestType()
		{
			return DigestType;
		}

		Void DS_RR::SetDigestType(Byte t)
		{
			DigestType = t;
			UpdateRdata();
			return;
		}

		array<Byte>^ DS_RR::GetDigest()
		{
			array<Byte>^ output;
			
			if (!digest)
				return nullptr;

			output = gcnew array<Byte>(digest->Length);
			digest->CopyTo(output,0);
			return output;
		}

		Void DS_RR::SetDigest(array<Byte>^ d)
		{
			if (!digest)
				digest = gcnew array<Byte>(d->Length);
			else
				digest->Resize(digest,d->Length);

			d->CopyTo(digest,0);
			UpdateRdata();
			return;
		}

		Void DS_RR::UpdateRdata()
		{
			int rdata_len = 0;
			if (digest)
				rdata_len = 4 + digest->Length;
			else
				rdata_len = 4;

			if (!rdata)
				rdata = gcnew array<Byte>(rdata_len);
			else
				rdata->Resize(rdata,rdata_len);

			BitConverter::GetBytes(IPAddress::HostToNetworkOrder((short int) KeyTag))->CopyTo(rdata,0);
			rdata[2] = (Byte) crypto_algo;
			rdata[3] = DigestType;
			if (digest)
				digest->CopyTo(rdata,4);
		}

		String^ PrintByteArray (array<Byte>^ b)
		{
			int i;
			String^ output = gcnew String("");

			for (i = 0; i < b->Length; ++i)
			{
				output +=  String::Format("{0:X2}-",b[i]);
			}

			return output;
		}

		String^ DS_RR::Print()
		{
			String^ output;

			output = PrintHeader();
			output += Enum::GetName(CRYPTO_ALGORITHM::typeid,crypto_algo);
			output += " ";
			output += Convert::ToString(DigestType);
			output += " (";
//			output += Convert::ToBase64String(digest);
			output += PrintByteArray(digest);
			output += ") ; key id = ";
			output += Convert::ToString(KeyTag);
		
			return output;
		}

		bool DS_RR::EqualsSignature(array<Byte>^ b)
		{
			int i = 0;
			
			if ((digest == nullptr) || (b == nullptr))
				return false;

			if (digest->Length != b->Length)
				return false;

			for (i = 0; i < digest->Length; ++i)
			{
				if (digest[i] != b[i])
					return false;
			}
			return true;
		}


		DS_RR^ DS_RR::Clone()
		{
			DS_RR^ newrr = gcnew DS_RR();
			newrr->rr_type = rr_type;
			newrr->owner = owner->Clone();
			newrr->ttl = ttl;
			newrr->rr_class = rr_class;
			newrr->KeyTag = KeyTag;
			newrr->crypto_algo = crypto_algo;
			newrr->DigestType = DigestType;
			newrr->digest = gcnew array<Byte>(digest->Length);
			digest->CopyTo(newrr->digest,0);
			newrr->UpdateRdata();
			return newrr;
		}

		ResourceRecord^ DS_RR::ParseResourceRecord(array<Byte>^ domainname, UInt16 rr_type, UInt16 rr_class, UInt32 ttl, UInt16 rdata_len, array<Byte>^ packet, int rdata_start)
		{
			DS_RR^ dsout;
			array<Byte>^ tmparray;

			dsout = gcnew DS_RR();
			dsout->owner = gcnew DOMAIN_NAME(domainname);
			dsout->rr_class = (RR_CLASS) rr_class;
			dsout->ttl = ttl;
			dsout->SetKeyTag(IPAddress::NetworkToHostOrder((short int) BitConverter::ToUInt16(packet,rdata_start)));
			dsout->SetCryptoAlgorithm((CRYPTO_ALGORITHM) packet[rdata_start + 2]);
			dsout->SetDigestType(packet[rdata_start + 3]);
			tmparray = gcnew array<Byte>(rdata_len - 4);
			packet->Copy(packet,rdata_start + 4,tmparray,0,rdata_len - 4);
			dsout->SetDigest(tmparray);
			return dsout;
		}

	String^ DS_RR::PrintRR(ResourceRecord^ rec)
	{
		return safe_cast<DS_RR^>(rec)->Print();
	}

	ResourceRecord^ DS_RR::CloneRR(ResourceRecord^ rec)
	{
		return safe_cast<DS_RR^>(rec)->Clone();
	}

}