/***********************************************************************
 * This following mashup was put together by Per Vices, starting with a 
 * a file generated by gen_adf4350_regs.py, written by Ettus Research, 
 * and references parts of adf4350.{c,h} from Analog Devices.
 * 
 * (c) 2012 Ettus Research
 * (c) 2012 Analog Devices
 * (c) 2013 Per Vices Corporation
 * Licensed under the GPL v2.
 **********************************************************************/

#ifndef INCLUDED_ADF4351_REGS_HPP
#define INCLUDED_ADF4351_REGS_HPP

/* Specifications */
#define ADF4350_MAX_OUT_FREQ		4400000000ULL /* Hz */
#define ADF4350_MIN_OUT_FREQ		137500000 /* Hz */
#define ADF4351_MIN_OUT_FREQ		34375000 /* Hz */
#define ADF4350_MIN_VCO_FREQ		2200000000ULL /* Hz */
#define ADF4350_MAX_FREQ_45_PRESC	3000000000ULL /* Hz */
#define ADF4350_MIN_INT_DIV_45		23
#define ADF4350_MIN_INT_DIV_89		75
#define ADF4350_MAX_FREQ_PFD		32000000 /* Hz */
#define ADF4350_MAX_BANDSEL_CLK		125000 /* Hz */
#define ADF4350_MAX_FREQ_REFIN		250000000 /* Hz */
#define ADF4350_MAX_MODULUS		4095

#define ADF4350_DESIGN_PFD		31250000 /* Hz */

#include <stdint.h>
#include <math.h>
#include <set>
#include <iostream>
#include <bitset>


class adf4351_regs_t{
public:
    uint16_t frac_12_bit;
    uint16_t int_16_bit;
    uint16_t mod_12_bit;
    uint16_t phase_12_bit;
    enum prescaler_t{
        PRESCALER_4_5 = 0,
        PRESCALER_8_9 = 1
    };
    prescaler_t prescaler;
    enum phase_adj_t{
	PHASE_ADJ_OFF = 0,
	PHASE_ADJ_ON = 1
    };
    phase_adj_t phase_adj;
    enum counter_reset_t{
        COUNTER_RESET_DISABLED = 0,
        COUNTER_RESET_ENABLED = 1
    };
    counter_reset_t counter_reset;
    enum cp_three_state_t{
        CP_THREE_STATE_DISABLED = 0,
        CP_THREE_STATE_ENABLED = 1
    };
    cp_three_state_t cp_three_state;
    enum power_down_t{
        POWER_DOWN_DISABLED = 0,
        POWER_DOWN_ENABLED = 1
    };
    power_down_t power_down;
    enum pd_polarity_t{
        PD_POLARITY_NEGATIVE = 0,
        PD_POLARITY_POSITIVE = 1
    };
    pd_polarity_t pd_polarity;
    enum ldp_t{
        LDP_10NS = 0,
        LDP_6NS = 1
    };
    ldp_t ldp;
    enum ldf_t{
        LDF_FRAC_N = 0,
        LDF_INT_N = 1
    };
    ldf_t ldf;
    enum charge_pump_current_t{
        CHARGE_PUMP_CURRENT_0_31MA = 0,
        CHARGE_PUMP_CURRENT_0_63MA = 1,
        CHARGE_PUMP_CURRENT_0_94MA = 2,
        CHARGE_PUMP_CURRENT_1_25MA = 3,
        CHARGE_PUMP_CURRENT_1_56MA = 4,
        CHARGE_PUMP_CURRENT_1_88MA = 5,
        CHARGE_PUMP_CURRENT_2_19MA = 6,
        CHARGE_PUMP_CURRENT_2_50MA = 7,
        CHARGE_PUMP_CURRENT_2_81MA = 8,
        CHARGE_PUMP_CURRENT_3_13MA = 9,
        CHARGE_PUMP_CURRENT_3_44MA = 10,
        CHARGE_PUMP_CURRENT_3_75MA = 11,
        CHARGE_PUMP_CURRENT_4_07MA = 12,
        CHARGE_PUMP_CURRENT_4_38MA = 13,
        CHARGE_PUMP_CURRENT_4_69MA = 14,
        CHARGE_PUMP_CURRENT_5_00MA = 15
    };
    charge_pump_current_t charge_pump_current;
    enum double_buffer_t{
        DOUBLE_BUFFER_DISABLED = 0,
        DOUBLE_BUFFER_ENABLED = 1
    };
    double_buffer_t double_buffer;
    uint16_t r_counter_10_bit;
    enum reference_divide_by_2_t{
        REFERENCE_DIVIDE_BY_2_DISABLED = 0,
        REFERENCE_DIVIDE_BY_2_ENABLED = 1
    };
    reference_divide_by_2_t reference_divide_by_2;
    enum reference_doubler_t{
        REFERENCE_DOUBLER_DISABLED = 0,
        REFERENCE_DOUBLER_ENABLED = 1
    };
    reference_doubler_t reference_doubler;
    enum muxout_t{
        MUXOUT_3STATE = 0,
        MUXOUT_DVDD = 1,
        MUXOUT_DGND = 2,
        MUXOUT_RDIV = 3,
        MUXOUT_NDIV = 4,
        MUXOUT_ANALOG_LD = 5,
        MUXOUT_DLD = 6,
        MUXOUT_RESERVED = 7
    };
    muxout_t muxout;
    enum low_noise_and_spur_t{
        LOW_NOISE_AND_SPUR_LOW_NOISE = 0,
        LOW_NOISE_AND_SPUR_RESERVED0 = 1,
        LOW_NOISE_AND_SPUR_RESERVED1 = 2,
        LOW_NOISE_AND_SPUR_LOW_SPUR = 3
    };
    low_noise_and_spur_t low_noise_and_spur;
    uint16_t clock_divider_12_bit;
    enum clock_div_mode_t{
        CLOCK_DIV_MODE_CLOCK_DIVIDER_OFF = 0,
        CLOCK_DIV_MODE_FAST_LOCK = 1,
        CLOCK_DIV_MODE_RESYNC_ENABLE = 2,
        CLOCK_DIV_MODE_RESERVED = 3
    };
    clock_div_mode_t clock_div_mode;
    enum cycle_slip_reduction_t{
        CYCLE_SLIP_REDUCTION_DISABLED = 0,
        CYCLE_SLIP_REDUCTION_ENABLED = 1
    };
    cycle_slip_reduction_t cycle_slip_reduction;
    enum output_power_t{
        OUTPUT_POWER_M4DBM = 0,
        OUTPUT_POWER_M1DBM = 1,
        OUTPUT_POWER_2DBM = 2,
        OUTPUT_POWER_5DBM = 3
    };
    output_power_t output_power;
    enum charge_cancel_t{
	CHARGE_CANCEL_DISABLED = 0,
	CHARGE_CANCEL_ENABLED = 1
    };
    enum antibacklash_pulse_t{
	ANTIBACKLASH_PULSE_6NS = 0,
        ANTIBACKLASH_PULSE_3NS = 1
    };
    antibacklash_pulse_t antibacklash_pulse;
    charge_cancel_t charge_cancel;
    enum band_sel_clk_mode_t{
	BAND_SEL_CLK_MODE_LOW = 0,
	BAND_SEL_CLK_MODE_HIGH = 1
    };
    band_sel_clk_mode_t band_sel_clk_mode;
    enum rf_output_enable_t{
        RF_OUTPUT_ENABLE_DISABLED = 0,
        RF_OUTPUT_ENABLE_ENABLED = 1
    };
    rf_output_enable_t rf_output_enable;  
    enum aux_output_power_t{
        AUX_OUTPUT_POWER_M4DBM = 0,
        AUX_OUTPUT_POWER_M1DBM = 1,
        AUX_OUTPUT_POWER_2DBM = 2,
        AUX_OUTPUT_POWER_5DBM = 3
    };
    aux_output_power_t aux_output_power;
    enum aux_output_enable_t{
        AUX_OUTPUT_ENABLE_DISABLED = 0,
        AUX_OUTPUT_ENABLE_ENABLED = 1
    };
    aux_output_enable_t aux_output_enable;
    enum aux_output_select_t{
        AUX_OUTPUT_SELECT_DIVIDED = 0,
        AUX_OUTPUT_SELECT_FUNDAMENTAL = 1
    };
    aux_output_select_t aux_output_select;
    enum mute_till_lock_detect_t{
        MUTE_TILL_LOCK_DETECT_MUTE_DISABLED = 0,
        MUTE_TILL_LOCK_DETECT_MUTE_ENABLED = 1
    };
    mute_till_lock_detect_t mute_till_lock_detect;
    enum vco_power_down_t{
        VCO_POWER_DOWN_VCO_POWERED_UP = 0,
        VCO_POWER_DOWN_VCO_POWERED_DOWN = 1
    };
    vco_power_down_t vco_power_down;
    int8_t band_select_clock_div;
    enum rf_divider_select_t{
        RF_DIVIDER_SELECT_DIV1 = 0,
        RF_DIVIDER_SELECT_DIV2 = 1,
        RF_DIVIDER_SELECT_DIV4 = 2,
        RF_DIVIDER_SELECT_DIV8 = 3,
        RF_DIVIDER_SELECT_DIV16 = 4,
	RF_DIVIDER_SELECT_DIV32 = 5,
	RF_DIVIDER_SELECT_DIV64 = 6
    };
    rf_divider_select_t rf_divider_select; 
    
    enum feedback_select_t{
        FEEDBACK_SELECT_DIVIDED = 0,
        FEEDBACK_SELECT_FUNDAMENTAL = 1
    };
    feedback_select_t feedback_select;
    enum ld_pin_mode_t{
        LD_PIN_MODE_LOW0 = 0,
        LD_PIN_MODE_DLD = 1,
        LD_PIN_MODE_LOW = 2,
        LD_PIN_MODE_HIGH = 3
    };
    ld_pin_mode_t ld_pin_mode;

    //Powers down frequency synthesizer
    void turn_off(){
      power_down = POWER_DOWN_ENABLED;
    };
    
    //Turns on the frequency synthesizer
    void turn_on(){
      power_down = POWER_DOWN_DISABLED;
      cp_three_state = CP_THREE_STATE_DISABLED;
      rf_output_enable = RF_OUTPUT_ENABLE_ENABLED;
    };

  //Output current register contents to stdout.
    void show_regs(){
      for (int i=0;i<=5;i++){
	std::cout << "\tRegister " << i << "=>\t" << std::hex << uint32_t ( get_reg(i) )<< std::endl;
      };
    };
    
    //INITIALIZATION ROUTINE (Initialize in Safe State, lowest power output, outputs disabled, powered down)
    //POWER OFF, OUTPUTS MUTED, LOWEST POWER SETTING.
    adf4351_regs_t(){
        frac_12_bit = 0;
        int_16_bit = 23;
        mod_12_bit = 2;
        phase_12_bit = 1;
        prescaler = PRESCALER_4_5;
	phase_adj = PHASE_ADJ_OFF;
        counter_reset = COUNTER_RESET_DISABLED;
        cp_three_state = CP_THREE_STATE_ENABLED;
        power_down = POWER_DOWN_ENABLED;
        pd_polarity = PD_POLARITY_POSITIVE;
        ldp = LDP_10NS;
        ldf = LDF_FRAC_N;
        charge_pump_current = CHARGE_PUMP_CURRENT_0_31MA;
        double_buffer = DOUBLE_BUFFER_DISABLED;
        r_counter_10_bit = 1;
        reference_divide_by_2 = REFERENCE_DIVIDE_BY_2_DISABLED;
        reference_doubler = REFERENCE_DOUBLER_DISABLED;
        muxout = MUXOUT_3STATE;
        low_noise_and_spur = LOW_NOISE_AND_SPUR_LOW_NOISE;
        clock_divider_12_bit = 0;
        clock_div_mode = CLOCK_DIV_MODE_CLOCK_DIVIDER_OFF;
        cycle_slip_reduction = CYCLE_SLIP_REDUCTION_DISABLED;
	charge_cancel = CHARGE_CANCEL_DISABLED;
	antibacklash_pulse = ANTIBACKLASH_PULSE_6NS;
	band_sel_clk_mode = BAND_SEL_CLK_MODE_LOW;
        output_power = OUTPUT_POWER_M4DBM;
        rf_output_enable = RF_OUTPUT_ENABLE_DISABLED;
        aux_output_power = AUX_OUTPUT_POWER_M4DBM;
        aux_output_enable = AUX_OUTPUT_ENABLE_DISABLED;
        aux_output_select = AUX_OUTPUT_SELECT_DIVIDED;
        mute_till_lock_detect = MUTE_TILL_LOCK_DETECT_MUTE_DISABLED;
        vco_power_down = VCO_POWER_DOWN_VCO_POWERED_DOWN;
        band_select_clock_div = 1;
        rf_divider_select = RF_DIVIDER_SELECT_DIV1;
        feedback_select = FEEDBACK_SELECT_DIVIDED;
        ld_pin_mode = LD_PIN_MODE_DLD;
    }

    enum addr_t{
        ADDR_R0 = 0,
        ADDR_R1 = 1,
        ADDR_R2 = 2,
        ADDR_R3 = 3,
        ADDR_R4 = 4,
        ADDR_R5 = 5
    };
    
    //Generate the registers    
    uint32_t get_reg(int8_t addr){
        int32_t reg = addr & 0x7;
        switch(addr){
        case 0:
            reg |= (uint32_t(frac_12_bit) & 0xfff) << 3;
            reg |= (uint32_t(int_16_bit) & 0xffff) << 15;
            break;
        case 1:
            reg |= (uint32_t(mod_12_bit) & 0xfff) << 3;
            reg |= (uint32_t(phase_12_bit) & 0xfff) << 15;
            reg |= (uint32_t(prescaler) & 0x1) << 27;
            break;
        case 2:
            reg |= (uint32_t(counter_reset) & 0x1) << 3;
            reg |= (uint32_t(cp_three_state) & 0x1) << 4;
            reg |= (uint32_t(power_down) & 0x1) << 5;
            reg |= (uint32_t(pd_polarity) & 0x1) << 6;
            reg |= (uint32_t(ldp) & 0x1) << 7;
            reg |= (uint32_t(ldf) & 0x1) << 8;
            reg |= (uint32_t(charge_pump_current) & 0xf) << 9;
            reg |= (uint32_t(double_buffer) & 0x1) << 13;
            reg |= (uint32_t(r_counter_10_bit) & 0x3ff) << 14;
            reg |= (uint32_t(reference_divide_by_2) & 0x1) << 24;
            reg |= (uint32_t(reference_doubler) & 0x1) << 25;
            reg |= (uint32_t(muxout) & 0x7) << 26;
            reg |= (uint32_t(low_noise_and_spur) & 0x3) << 29;
            break;
        case 3:
            reg |= (uint32_t(clock_divider_12_bit) & 0xfff) << 3;
            reg |= (uint32_t(clock_div_mode) & 0x3) << 15;
            reg |= (uint32_t(cycle_slip_reduction) & 0x1) << 18;
            break;
        case 4:
            reg |= (uint32_t(output_power) & 0x3) << 3;
            reg |= (uint32_t(rf_output_enable) & 0x1) << 5;
            reg |= (uint32_t(aux_output_power) & 0x3) << 6;
            reg |= (uint32_t(aux_output_enable) & 0x1) << 8;
            reg |= (uint32_t(aux_output_select) & 0x1) << 9;
            reg |= (uint32_t(mute_till_lock_detect) & 0x1) << 10;
            reg |= (uint32_t(vco_power_down) & 0x1) << 11;
            reg |= (uint32_t(band_select_clock_div) & 0xff) << 12;
            reg |= (uint32_t(rf_divider_select) & 0x7) << 20;
            reg |= (uint32_t(feedback_select) & 0x1) << 23;
            break;
        case 5:
	    reg |= (uint32_t(3) & 0x3) << 19; 
	    reg |= (uint32_t(0) & 0x1) << 21;
            reg |= (uint32_t(ld_pin_mode) & 0x3) << 22;
            break;
        }
        return reg;
    };
  
    //Set the frequency
    double set_freq(double TargetFreq, double RefIn, int chan_mod = 4095, bool debug = false) {
      //cout << "Target Frequency is: " << (TargetFreq/1e6) << "MHz" << endl;
      
      double actual_freq, pfd_freq;
      //**************************************************************************
      //Set reference oscillator frequency here
      //**************************************************************************
      double ref_freq = RefIn;
      int R=0, BS=0, N=0, FRAC=0, MOD=0;
      int RFdiv = 1;
      int RFreg = 0;

      //Sanity check frequency
      if ( ( TargetFreq < ADF4351_MIN_OUT_FREQ) || (TargetFreq > ADF4350_MAX_OUT_FREQ) ) {
	    std::cerr << "Error Setting Frequency: Valid values limited to [34375000,4400000000]" << std::endl;
	    return 1;
      };
      
      adf4351_regs_t::reference_divide_by_2_t T     = adf4351_regs_t::REFERENCE_DIVIDE_BY_2_DISABLED;
      adf4351_regs_t::reference_doubler_t     D     = adf4351_regs_t::REFERENCE_DOUBLER_DISABLED;

      //Reference doubler for 50% duty cycle
      // if ref_freq < 12.5MHz enable regs.reference_divide_by_2
      if(ref_freq <= 12.5e6) D = adf4351_regs_t::REFERENCE_DOUBLER_ENABLED;

      //increase RF divider until acceptable VCO frequency
      double vco_freq = TargetFreq;
      while (vco_freq < 2.2e9) {
	  vco_freq *= 2;
	  RFdiv *= 2;
	  RFreg++;
      }

      //use 8/9 prescaler for vco_freq > 3 GHz (pg.18 prescaler)
      adf4351_regs_t::prescaler_t prescaler = vco_freq > 3e9 ? adf4351_regs_t::PRESCALER_8_9 : adf4351_regs_t::PRESCALER_4_5;
      int min_int_divider = prescaler == adf4351_regs_t::PRESCALER_4_5 ? 23 : 75; //Min Int divider is 23 for 4/5 and 75 for 8/9
      
      //cout << "Minimum Divider is: " << int(min_int_divider) << endl;
      
      /*
      * The goal here is to loop though possible R dividers,
      * band select clock dividers, N (int) dividers, and FRAC
      * (frac) dividers.
      *
      * Calculate the N and F dividers for each set of values.
      * The loop exists when it meets all of the constraints.
      * The resulting loop values are loaded into the registers.
      *
      * from pg.21
      *
      * f_pfd = f_ref*(1+D)/(R*(1+T))
      * f_vco = (N + (FRAC/MOD))*f_pfd
      *    N = f_vco/f_pfd - FRAC/MOD = f_vco*((R*(T+1))/(f_ref*(1+D))) - FRAC/MOD
      * f_rf = f_vco/RFdiv)
      * f_actual = f_rf
      */
      
      for(R = 1; R <= 1023; R+=1){
	  //PFD input frequency = f_ref/R ... ignoring Reference doubler/divide-by-2 (D & T)
	  pfd_freq = ref_freq*(1+D)/(R*(1+T));

	  //keep the PFD frequency at or below 31.25e6MHz (Loop Filter Bandwidth)
	  if (pfd_freq > ADF4350_DESIGN_PFD) continue;

	  //ignore fractional part of tuning
	  N = int(floor(vco_freq/pfd_freq));

	  //keep N > minimum int divider requirement
	  if (N < min_int_divider) continue;

	  for(BS=1; BS <= 255; BS+=1){
	      //keep the band select frequency at or below 125KHz
	      //constraint on band select clock
	      if (pfd_freq/BS > 125e3) continue;
	      goto done_loop;
	  }
      } done_loop:

      //Fractional-N calculation
      // MOD = 4095; //max fractional accuracy  //DEBUGGING ADF
      MOD = chan_mod;

      FRAC = round( double( ((vco_freq/pfd_freq) - N)*MOD) );
     
      //Reference divide-by-2 for 50% duty cycle
      // if R even, move one divide by 2 to to regs.reference_divide_by_2
      if(R % 2 == 0){
	  T = adf4351_regs_t::REFERENCE_DIVIDE_BY_2_ENABLED;
	  R /= 2;
      }

      //actual frequency calculation
      actual_freq = double((N + (double(FRAC)/double(MOD))) * ref_freq * (1+int(D)) / (R*(1+int(T))) /RFdiv );
      
      frac_12_bit = FRAC;
      int_16_bit = N;
      mod_12_bit = MOD;
      prescaler = prescaler;
      r_counter_10_bit = R;
      reference_divide_by_2 = T;
      reference_doubler = D;
      band_select_clock_div = BS;
      rf_divider_select = (adf4351_regs_t::rf_divider_select_t)(RFreg);
      
      aux_output_power = adf4351_regs_t::AUX_OUTPUT_POWER_M4DBM;
      aux_output_enable = adf4351_regs_t::AUX_OUTPUT_ENABLE_DISABLED;
      aux_output_select = adf4351_regs_t::AUX_OUTPUT_SELECT_DIVIDED;
      
      if (debug == true){
	std::cout
	  << "Synth Param: "
	  << "\tpfd= " << (ref_freq*(1+int(D))/(R*(1+int(T))))
	  << "\toutdiv= " << double(RFdiv) 
	  << "\tfbdiv= " << double(N + double(FRAC)/double(MOD)) 
	  << std::endl

	  << "Registers Set: "
	  << std::dec
	  << "\tR= " << R
	  << "\tBS= " << BS
	  << "\tN= " << N
	  << "\tFRAC= " << FRAC
	  << "\tMOD= " << MOD
	  << "\tT= " << T
	  << "\tD= " << D
	  << "\tRFdiv= " << int(RFdiv)
	  << std::endl
	  
	  << "Calc (MHz):" 
	  << "\tREQ= " << double(TargetFreq/1e6)
	  << "\tACT= " <<  double(actual_freq/1e6)
	  << "\tVCO= " << double(vco_freq/1e6)
	  << "\tPFD= " << double(pfd_freq/1e6)
	  << "\tSPAC= " << double(pfd_freq/BS/1e6)
	  << std::endl
	  
	  << "Actual Frequency is " 
	  << (actual_freq/1e6) 
	  << "MHz" 
	  << std::endl;
	};
      
      return actual_freq;
    };

};




#endif /* INCLUDED_ADF4350_REGS_HPP */
