/*
    Copyright (C) 2017 Volker Krause <vkrause@kde.org>

    Permission is hereby granted, free of charge, to any person obtaining
    a copy of this software and associated documentation files (the
    "Software"), to deal in the Software without restriction, including
    without limitation the rights to use, copy, modify, merge, publish,
    distribute, sublicense, and/or sell copies of the Software, and to
    permit persons to whom the Software is furnished to do so, subject to
    the following conditions:

    The above copyright notice and this permission notice shall be included
    in all copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
    EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
    IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
    CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
    TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
    SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

#include <feedbackconfigwidget.h>
#include <platforminfosource.h>
#include <provider.h>
#include <screeninfosource.h>

#include <QDebug>
#include <QLabel>
#include <QtTest/qtest.h>
#include <QObject>
#include <QSlider>
#include <QStandardPaths>

using namespace KUserFeedback;

class FeedbackConfigTest : public QObject
{
    Q_OBJECT
private slots:
    void initTestCase()
    {
        QStandardPaths::setTestModeEnabled(true);
    }

    void testTelemetrySettings()
    {
        Provider p;
        p.setProductIdentifier(QStringLiteral("org.kde.UserFeedback.UnitTestProduct"));
        p.addDataSource(new ScreenInfoSource);
        p.addDataSource(new PlatformInfoSource);
        p.setTelemetryMode(Provider::NoTelemetry);

        FeedbackConfigWidget w;
        w.setFeedbackProvider(&p);
        w.show();

        auto telemetrySlider = w.findChild<QSlider*>(QLatin1String("telemetrySlider"));
        QVERIFY(telemetrySlider);
        QVERIFY(telemetrySlider->isEnabled());
        QCOMPARE(telemetrySlider->minimum(), 0);
        QCOMPARE(telemetrySlider->maximum(), 2);
        QCOMPARE(telemetrySlider->value(), 0);

        telemetrySlider->setValue(1);
        QCOMPARE(w.telemetryMode(), Provider::BasicSystemInformation);
        QTest::qWait(1);
        QCOMPARE(p.telemetryMode(), Provider::NoTelemetry);
    }

    void testSurveySettings()
    {
        Provider p;
        p.setProductIdentifier(QStringLiteral("org.kde.UserFeedback.UnitTestProduct"));
        p.setSurveyInterval(-1);

        FeedbackConfigWidget w;
        w.setFeedbackProvider(&p);
        w.show();

        auto slider = w.findChild<QSlider*>(QLatin1String("surveySlider"));
        QVERIFY(slider);
        QVERIFY(slider->isEnabled());
        QCOMPARE(slider->minimum(), 0);
        QCOMPARE(slider->maximum(), 2);
        QCOMPARE(slider->value(), 0);

        auto label = w.findChild<QLabel*>(QLatin1String("surveyLabel"));
        QVERIFY(label);
        QVERIFY(!label->text().isEmpty());

        slider->setValue(1);
        QCOMPARE(w.surveyInterval(), 90);
        QTest::qWait(1);
        QCOMPARE(p.surveyInterval(), -1);
        QVERIFY(!label->text().isEmpty());

        slider->setValue(2);
        QCOMPARE(w.surveyInterval(), 0);
        QTest::qWait(1);
        QCOMPARE(p.surveyInterval(), -1);
        QVERIFY(!label->text().isEmpty());
    }
};

QTEST_MAIN(FeedbackConfigTest)

#include "feedbackconfigtest.moc"
