/*
 * Copyright 2010-2019 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license
 * that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.idea.navigation;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("idea/testData/navigation/implementations")
@TestDataPath("$PROJECT_ROOT")
@RunWith(JUnit3RunnerWithInners.class)
public class KotlinGotoImplementationTestGenerated extends AbstractKotlinGotoImplementationTest {
    private void runTest(String testDataFilePath) throws Exception {
        KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
    }

    @TestMetadata("AbstractClassImplementorsWithDeclaration.kt")
    public void testAbstractClassImplementorsWithDeclaration() throws Exception {
        runTest("idea/testData/navigation/implementations/AbstractClassImplementorsWithDeclaration.kt");
    }

    public void testAllFilesPresentInImplementations() throws Exception {
        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/navigation/implementations"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, false);
    }

    @TestMetadata("ClassImplementorsWithDeclaration.kt")
    public void testClassImplementorsWithDeclaration() throws Exception {
        runTest("idea/testData/navigation/implementations/ClassImplementorsWithDeclaration.kt");
    }

    @TestMetadata("ClassNavigation.kt")
    public void testClassNavigation() throws Exception {
        runTest("idea/testData/navigation/implementations/ClassNavigation.kt");
    }

    @TestMetadata("ConstructorPropertyOverriddenNavigation.kt")
    public void testConstructorPropertyOverriddenNavigation() throws Exception {
        runTest("idea/testData/navigation/implementations/ConstructorPropertyOverriddenNavigation.kt");
    }

    @TestMetadata("DefaultImplFunction.kt")
    public void testDefaultImplFunction() throws Exception {
        runTest("idea/testData/navigation/implementations/DefaultImplFunction.kt");
    }

    @TestMetadata("DefaultImplProperty.kt")
    public void testDefaultImplProperty() throws Exception {
        runTest("idea/testData/navigation/implementations/DefaultImplProperty.kt");
    }

    @TestMetadata("DelegatedAndDefaultImplFunction.kt")
    public void testDelegatedAndDefaultImplFunction() throws Exception {
        runTest("idea/testData/navigation/implementations/DelegatedAndDefaultImplFunction.kt");
    }

    @TestMetadata("DelegatedFunction.kt")
    public void testDelegatedFunction() throws Exception {
        runTest("idea/testData/navigation/implementations/DelegatedFunction.kt");
    }

    @TestMetadata("DelegatedProperty.kt")
    public void testDelegatedProperty() throws Exception {
        runTest("idea/testData/navigation/implementations/DelegatedProperty.kt");
    }

    @TestMetadata("EnumEntriesInheritance.kt")
    public void testEnumEntriesInheritance() throws Exception {
        runTest("idea/testData/navigation/implementations/EnumEntriesInheritance.kt");
    }

    @TestMetadata("FakeOverride.kt")
    public void testFakeOverride() throws Exception {
        runTest("idea/testData/navigation/implementations/FakeOverride.kt");
    }

    @TestMetadata("FunctionOverrideNavigation.kt")
    public void testFunctionOverrideNavigation() throws Exception {
        runTest("idea/testData/navigation/implementations/FunctionOverrideNavigation.kt");
    }

    @TestMetadata("GenericDelegatedAndDefaultImplFunction.kt")
    public void testGenericDelegatedAndDefaultImplFunction() throws Exception {
        runTest("idea/testData/navigation/implementations/GenericDelegatedAndDefaultImplFunction.kt");
    }

    @TestMetadata("GenericFakeOverride.kt")
    public void testGenericFakeOverride() throws Exception {
        runTest("idea/testData/navigation/implementations/GenericFakeOverride.kt");
    }

    @TestMetadata("ImplementGenericWithPrimitives.kt")
    public void testImplementGenericWithPrimitives() throws Exception {
        runTest("idea/testData/navigation/implementations/ImplementGenericWithPrimitives.kt");
    }

    @TestMetadata("ImplementsInInlineClass.kt")
    public void testImplementsInInlineClass() throws Exception {
        runTest("idea/testData/navigation/implementations/ImplementsInInlineClass.kt");
    }

    @TestMetadata("ObjectImported.kt")
    public void testObjectImported() throws Exception {
        runTest("idea/testData/navigation/implementations/ObjectImported.kt");
    }

    @TestMetadata("OverridesInEnumEntries.kt")
    public void testOverridesInEnumEntries() throws Exception {
        runTest("idea/testData/navigation/implementations/OverridesInEnumEntries.kt");
    }

    @TestMetadata("OverridesInInlineClass.kt")
    public void testOverridesInInlineClass() throws Exception {
        runTest("idea/testData/navigation/implementations/OverridesInInlineClass.kt");
    }

    @TestMetadata("PropertyOverriddenNavigation.kt")
    public void testPropertyOverriddenNavigation() throws Exception {
        runTest("idea/testData/navigation/implementations/PropertyOverriddenNavigation.kt");
    }

    @TestMetadata("TraitImplementorsWithDeclaration.kt")
    public void testTraitImplementorsWithDeclaration() throws Exception {
        runTest("idea/testData/navigation/implementations/TraitImplementorsWithDeclaration.kt");
    }
}
