/**********************************************************************
 * Copyright (c) by Heiner Jostkleigrewe
 * This program is free software: you can redistribute it and/or modify it under the terms of the 
 * GNU General Public License as published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,  but WITHOUT ANY WARRANTY; without 
 *  even the implied warranty of  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See 
 *  the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this program.  If not, 
 * see <http://www.gnu.org/licenses/>.
 * 
 * heiner@jverein.de
 * www.jverein.de
 **********************************************************************/
package de.jost_net.JVerein.gui.action;

import java.rmi.RemoteException;

import de.jost_net.JVerein.Einstellungen;
import de.jost_net.JVerein.rmi.Felddefinition;
import de.jost_net.JVerein.rmi.Zusatzfelder;
import de.willuhn.datasource.rmi.DBIterator;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.dialogs.YesNoDialog;
import de.willuhn.jameica.gui.parts.TablePart;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;

/**
 * Lschen einer Felddefiniton
 */
public class FelddefinitionDeleteAction implements Action
{

  @Override
  public void handleAction(Object context) throws ApplicationException
  {
    if (context instanceof TablePart)
    {
      TablePart tp = (TablePart) context;
      context = tp.getSelection();
    }
    if (context == null || !(context instanceof Felddefinition))
    {
      throw new ApplicationException("Keine Felddefinition ausgewhlt");
    }
    try
    {
      Felddefinition fd = (Felddefinition) context;
      DBIterator<Zusatzfelder> it = Einstellungen.getDBService()
          .createList(Zusatzfelder.class);
      it.addFilter("felddefinition=?", new Object[] { fd.getID() });
      if (fd.isNewObject())
      {
        return;
      }
      YesNoDialog d = new YesNoDialog(YesNoDialog.POSITION_CENTER);
      d.setTitle("Felddefinition lschen");
      d.setText("Das Feld ist bei " + it.size()
          + " Mitgliedern gespeichert. Wollen Sie diese Felddefinition wirklich lschen?");

      try
      {
        Boolean choice = (Boolean) d.open();
        if (!choice.booleanValue())
        {
          return;
        }
      }
      catch (Exception e)
      {
        Logger.error("Fehler beim Lschen der Felddefinition", e);
        return;
      }
      while (it.hasNext())
      {
        Zusatzfelder zf1 = it.next();
        Zusatzfelder zf2 = (Zusatzfelder) Einstellungen.getDBService()
            .createObject(Zusatzfelder.class, zf1.getID());
        zf2.delete();
      }
      fd.delete();
      GUI.getStatusBar().setSuccessText("Felddefinition gelscht.");
    }
    catch (RemoteException e)
    {
      String fehler = "Fehler beim Lschen der Felddefinition";
      GUI.getStatusBar().setErrorText(fehler);
      Logger.error(fehler, e);
    }
  }
}
