/* Generated by wayland-scanner 1.22.0 */

#ifndef TEXT_INPUT_UNSTABLE_V1_CLIENT_PROTOCOL_H
#define TEXT_INPUT_UNSTABLE_V1_CLIENT_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-client.h"

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * @page page_text_input_unstable_v1 The text_input_unstable_v1 protocol
 * @section page_ifaces_text_input_unstable_v1 Interfaces
 * - @subpage page_iface_zwp_text_input_v1 - text input
 * - @subpage page_iface_zwp_text_input_manager_v1 - text input manager
 * @section page_copyright_text_input_unstable_v1 Copyright
 * <pre>
 *
 * Copyright © 2012, 2013 Intel Corporation
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 * </pre>
 */
struct wl_seat;
struct wl_surface;
struct zwp_text_input_manager_v1;
struct zwp_text_input_v1;

#ifndef ZWP_TEXT_INPUT_V1_INTERFACE
#define ZWP_TEXT_INPUT_V1_INTERFACE
/**
 * @page page_iface_zwp_text_input_v1 zwp_text_input_v1
 * @section page_iface_zwp_text_input_v1_desc Description
 *
 * An object used for text input. Adds support for text input and input
 * methods to applications. A text_input object is created from a
 * wl_text_input_manager and corresponds typically to a text entry in an
 * application.
 *
 * Requests are used to activate/deactivate the text_input object and set
 * state information like surrounding and selected text or the content type.
 * The information about entered text is sent to the text_input object via
 * the pre-edit and commit events. Using this interface removes the need
 * for applications to directly process hardware key events and compose text
 * out of them.
 *
 * Text is generally UTF-8 encoded, indices and lengths are in bytes.
 *
 * Serials are used to synchronize the state between the text input and
 * an input method. New serials are sent by the text input in the
 * commit_state request and are used by the input method to indicate
 * the known text input state in events like preedit_string, commit_string,
 * and keysym. The text input can then ignore events from the input method
 * which are based on an outdated state (for example after a reset).
 *
 * Warning! The protocol described in this file is experimental and
 * backward incompatible changes may be made. Backward compatible changes
 * may be added together with the corresponding interface version bump.
 * Backward incompatible changes are done by bumping the version number in
 * the protocol and interface names and resetting the interface version.
 * Once the protocol is to be declared stable, the 'z' prefix and the
 * version number in the protocol and interface names are removed and the
 * interface version number is reset.
 * @section page_iface_zwp_text_input_v1_api API
 * See @ref iface_zwp_text_input_v1.
 */
/**
 * @defgroup iface_zwp_text_input_v1 The zwp_text_input_v1 interface
 *
 * An object used for text input. Adds support for text input and input
 * methods to applications. A text_input object is created from a
 * wl_text_input_manager and corresponds typically to a text entry in an
 * application.
 *
 * Requests are used to activate/deactivate the text_input object and set
 * state information like surrounding and selected text or the content type.
 * The information about entered text is sent to the text_input object via
 * the pre-edit and commit events. Using this interface removes the need
 * for applications to directly process hardware key events and compose text
 * out of them.
 *
 * Text is generally UTF-8 encoded, indices and lengths are in bytes.
 *
 * Serials are used to synchronize the state between the text input and
 * an input method. New serials are sent by the text input in the
 * commit_state request and are used by the input method to indicate
 * the known text input state in events like preedit_string, commit_string,
 * and keysym. The text input can then ignore events from the input method
 * which are based on an outdated state (for example after a reset).
 *
 * Warning! The protocol described in this file is experimental and
 * backward incompatible changes may be made. Backward compatible changes
 * may be added together with the corresponding interface version bump.
 * Backward incompatible changes are done by bumping the version number in
 * the protocol and interface names and resetting the interface version.
 * Once the protocol is to be declared stable, the 'z' prefix and the
 * version number in the protocol and interface names are removed and the
 * interface version number is reset.
 */
extern const struct wl_interface zwp_text_input_v1_interface;
#endif
#ifndef ZWP_TEXT_INPUT_MANAGER_V1_INTERFACE
#define ZWP_TEXT_INPUT_MANAGER_V1_INTERFACE
/**
 * @page page_iface_zwp_text_input_manager_v1 zwp_text_input_manager_v1
 * @section page_iface_zwp_text_input_manager_v1_desc Description
 *
 * A factory for text_input objects. This object is a global singleton.
 * @section page_iface_zwp_text_input_manager_v1_api API
 * See @ref iface_zwp_text_input_manager_v1.
 */
/**
 * @defgroup iface_zwp_text_input_manager_v1 The zwp_text_input_manager_v1 interface
 *
 * A factory for text_input objects. This object is a global singleton.
 */
extern const struct wl_interface zwp_text_input_manager_v1_interface;
#endif

#ifndef ZWP_TEXT_INPUT_V1_CONTENT_HINT_ENUM
#define ZWP_TEXT_INPUT_V1_CONTENT_HINT_ENUM
/**
 * @ingroup iface_zwp_text_input_v1
 * content hint
 *
 * Content hint is a bitmask to allow to modify the behavior of the text
 * input.
 */
enum zwp_text_input_v1_content_hint {
	/**
	 * no special behaviour
	 */
	ZWP_TEXT_INPUT_V1_CONTENT_HINT_NONE = 0x0,
	/**
	 * auto completion, correction and capitalization
	 */
	ZWP_TEXT_INPUT_V1_CONTENT_HINT_DEFAULT = 0x7,
	/**
	 * hidden and sensitive text
	 */
	ZWP_TEXT_INPUT_V1_CONTENT_HINT_PASSWORD = 0xc0,
	/**
	 * suggest word completions
	 */
	ZWP_TEXT_INPUT_V1_CONTENT_HINT_AUTO_COMPLETION = 0x1,
	/**
	 * suggest word corrections
	 */
	ZWP_TEXT_INPUT_V1_CONTENT_HINT_AUTO_CORRECTION = 0x2,
	/**
	 * switch to uppercase letters at the start of a sentence
	 */
	ZWP_TEXT_INPUT_V1_CONTENT_HINT_AUTO_CAPITALIZATION = 0x4,
	/**
	 * prefer lowercase letters
	 */
	ZWP_TEXT_INPUT_V1_CONTENT_HINT_LOWERCASE = 0x8,
	/**
	 * prefer uppercase letters
	 */
	ZWP_TEXT_INPUT_V1_CONTENT_HINT_UPPERCASE = 0x10,
	/**
	 * prefer casing for titles and headings (can be language dependent)
	 */
	ZWP_TEXT_INPUT_V1_CONTENT_HINT_TITLECASE = 0x20,
	/**
	 * characters should be hidden
	 */
	ZWP_TEXT_INPUT_V1_CONTENT_HINT_HIDDEN_TEXT = 0x40,
	/**
	 * typed text should not be stored
	 */
	ZWP_TEXT_INPUT_V1_CONTENT_HINT_SENSITIVE_DATA = 0x80,
	/**
	 * just latin characters should be entered
	 */
	ZWP_TEXT_INPUT_V1_CONTENT_HINT_LATIN = 0x100,
	/**
	 * the text input is multiline
	 */
	ZWP_TEXT_INPUT_V1_CONTENT_HINT_MULTILINE = 0x200,
};
#endif /* ZWP_TEXT_INPUT_V1_CONTENT_HINT_ENUM */

#ifndef ZWP_TEXT_INPUT_V1_CONTENT_PURPOSE_ENUM
#define ZWP_TEXT_INPUT_V1_CONTENT_PURPOSE_ENUM
/**
 * @ingroup iface_zwp_text_input_v1
 * content purpose
 *
 * The content purpose allows to specify the primary purpose of a text
 * input.
 *
 * This allows an input method to show special purpose input panels with
 * extra characters or to disallow some characters.
 */
enum zwp_text_input_v1_content_purpose {
	/**
	 * default input, allowing all characters
	 */
	ZWP_TEXT_INPUT_V1_CONTENT_PURPOSE_NORMAL = 0,
	/**
	 * allow only alphabetic characters
	 */
	ZWP_TEXT_INPUT_V1_CONTENT_PURPOSE_ALPHA = 1,
	/**
	 * allow only digits
	 */
	ZWP_TEXT_INPUT_V1_CONTENT_PURPOSE_DIGITS = 2,
	/**
	 * input a number (including decimal separator and sign)
	 */
	ZWP_TEXT_INPUT_V1_CONTENT_PURPOSE_NUMBER = 3,
	/**
	 * input a phone number
	 */
	ZWP_TEXT_INPUT_V1_CONTENT_PURPOSE_PHONE = 4,
	/**
	 * input an URL
	 */
	ZWP_TEXT_INPUT_V1_CONTENT_PURPOSE_URL = 5,
	/**
	 * input an email address
	 */
	ZWP_TEXT_INPUT_V1_CONTENT_PURPOSE_EMAIL = 6,
	/**
	 * input a name of a person
	 */
	ZWP_TEXT_INPUT_V1_CONTENT_PURPOSE_NAME = 7,
	/**
	 * input a password (combine with password or sensitive_data hint)
	 */
	ZWP_TEXT_INPUT_V1_CONTENT_PURPOSE_PASSWORD = 8,
	/**
	 * input a date
	 */
	ZWP_TEXT_INPUT_V1_CONTENT_PURPOSE_DATE = 9,
	/**
	 * input a time
	 */
	ZWP_TEXT_INPUT_V1_CONTENT_PURPOSE_TIME = 10,
	/**
	 * input a date and time
	 */
	ZWP_TEXT_INPUT_V1_CONTENT_PURPOSE_DATETIME = 11,
	/**
	 * input for a terminal
	 */
	ZWP_TEXT_INPUT_V1_CONTENT_PURPOSE_TERMINAL = 12,
};
#endif /* ZWP_TEXT_INPUT_V1_CONTENT_PURPOSE_ENUM */

#ifndef ZWP_TEXT_INPUT_V1_PREEDIT_STYLE_ENUM
#define ZWP_TEXT_INPUT_V1_PREEDIT_STYLE_ENUM
enum zwp_text_input_v1_preedit_style {
	/**
	 * default style for composing text
	 */
	ZWP_TEXT_INPUT_V1_PREEDIT_STYLE_DEFAULT = 0,
	/**
	 * style should be the same as in non-composing text
	 */
	ZWP_TEXT_INPUT_V1_PREEDIT_STYLE_NONE = 1,
	ZWP_TEXT_INPUT_V1_PREEDIT_STYLE_ACTIVE = 2,
	ZWP_TEXT_INPUT_V1_PREEDIT_STYLE_INACTIVE = 3,
	ZWP_TEXT_INPUT_V1_PREEDIT_STYLE_HIGHLIGHT = 4,
	ZWP_TEXT_INPUT_V1_PREEDIT_STYLE_UNDERLINE = 5,
	ZWP_TEXT_INPUT_V1_PREEDIT_STYLE_SELECTION = 6,
	ZWP_TEXT_INPUT_V1_PREEDIT_STYLE_INCORRECT = 7,
};
#endif /* ZWP_TEXT_INPUT_V1_PREEDIT_STYLE_ENUM */

#ifndef ZWP_TEXT_INPUT_V1_TEXT_DIRECTION_ENUM
#define ZWP_TEXT_INPUT_V1_TEXT_DIRECTION_ENUM
enum zwp_text_input_v1_text_direction {
	/**
	 * automatic text direction based on text and language
	 */
	ZWP_TEXT_INPUT_V1_TEXT_DIRECTION_AUTO = 0,
	/**
	 * left-to-right
	 */
	ZWP_TEXT_INPUT_V1_TEXT_DIRECTION_LTR = 1,
	/**
	 * right-to-left
	 */
	ZWP_TEXT_INPUT_V1_TEXT_DIRECTION_RTL = 2,
};
#endif /* ZWP_TEXT_INPUT_V1_TEXT_DIRECTION_ENUM */

/**
 * @ingroup iface_zwp_text_input_v1
 * @struct zwp_text_input_v1_listener
 */
struct zwp_text_input_v1_listener {
	/**
	 * enter event
	 *
	 * Notify the text_input object when it received focus. Typically
	 * in response to an activate request.
	 */
	void (*enter)(void *data,
		      struct zwp_text_input_v1 *zwp_text_input_v1,
		      struct wl_surface *surface);
	/**
	 * leave event
	 *
	 * Notify the text_input object when it lost focus. Either in
	 * response to a deactivate request or when the assigned surface
	 * lost focus or was destroyed.
	 */
	void (*leave)(void *data,
		      struct zwp_text_input_v1 *zwp_text_input_v1);
	/**
	 * modifiers map
	 *
	 * Transfer an array of 0-terminated modifier names. The position
	 * in the array is the index of the modifier as used in the
	 * modifiers bitmask in the keysym event.
	 */
	void (*modifiers_map)(void *data,
			      struct zwp_text_input_v1 *zwp_text_input_v1,
			      struct wl_array *map);
	/**
	 * state of the input panel
	 *
	 * Notify when the visibility state of the input panel changed.
	 */
	void (*input_panel_state)(void *data,
				  struct zwp_text_input_v1 *zwp_text_input_v1,
				  uint32_t state);
	/**
	 * pre-edit
	 *
	 * Notify when a new composing text (pre-edit) should be set
	 * around the current cursor position. Any previously set composing
	 * text should be removed.
	 *
	 * The commit text can be used to replace the preedit text on reset
	 * (for example on unfocus).
	 *
	 * The text input should also handle all preedit_style and
	 * preedit_cursor events occurring directly before preedit_string.
	 * @param serial serial of the latest known text input state
	 */
	void (*preedit_string)(void *data,
			       struct zwp_text_input_v1 *zwp_text_input_v1,
			       uint32_t serial,
			       const char *text,
			       const char *commit);
	/**
	 * pre-edit styling
	 *
	 * Sets styling information on composing text. The style is
	 * applied for length bytes from index relative to the beginning of
	 * the composing text (as byte offset). Multiple styles can be
	 * applied to a composing text by sending multiple preedit_styling
	 * events.
	 *
	 * This event is handled as part of a following preedit_string
	 * event.
	 */
	void (*preedit_styling)(void *data,
				struct zwp_text_input_v1 *zwp_text_input_v1,
				uint32_t index,
				uint32_t length,
				uint32_t style);
	/**
	 * pre-edit cursor
	 *
	 * Sets the cursor position inside the composing text (as byte
	 * offset) relative to the start of the composing text. When index
	 * is a negative number no cursor is shown.
	 *
	 * This event is handled as part of a following preedit_string
	 * event.
	 */
	void (*preedit_cursor)(void *data,
			       struct zwp_text_input_v1 *zwp_text_input_v1,
			       int32_t index);
	/**
	 * commit
	 *
	 * Notify when text should be inserted into the editor widget.
	 * The text to commit could be either just a single character after
	 * a key press or the result of some composing (pre-edit). It could
	 * also be an empty text when some text should be removed (see
	 * delete_surrounding_text) or when the input cursor should be
	 * moved (see cursor_position).
	 *
	 * Any previously set composing text should be removed.
	 * @param serial serial of the latest known text input state
	 */
	void (*commit_string)(void *data,
			      struct zwp_text_input_v1 *zwp_text_input_v1,
			      uint32_t serial,
			      const char *text);
	/**
	 * set cursor to new position
	 *
	 * Notify when the cursor or anchor position should be modified.
	 *
	 * This event should be handled as part of a following
	 * commit_string event.
	 */
	void (*cursor_position)(void *data,
				struct zwp_text_input_v1 *zwp_text_input_v1,
				int32_t index,
				int32_t anchor);
	/**
	 * delete surrounding text
	 *
	 * Notify when the text around the current cursor position should
	 * be deleted.
	 *
	 * Index is relative to the current cursor (in bytes). Length is
	 * the length of deleted text (in bytes).
	 *
	 * This event should be handled as part of a following
	 * commit_string event.
	 */
	void (*delete_surrounding_text)(void *data,
					struct zwp_text_input_v1 *zwp_text_input_v1,
					int32_t index,
					uint32_t length);
	/**
	 * keysym
	 *
	 * Notify when a key event was sent. Key events should not be
	 * used for normal text input operations, which should be done with
	 * commit_string, delete_surrounding_text, etc. The key event
	 * follows the wl_keyboard key event convention. Sym is an XKB
	 * keysym, state a wl_keyboard key_state. Modifiers are a mask for
	 * effective modifiers (where the modifier indices are set by the
	 * modifiers_map event)
	 * @param serial serial of the latest known text input state
	 */
	void (*keysym)(void *data,
		       struct zwp_text_input_v1 *zwp_text_input_v1,
		       uint32_t serial,
		       uint32_t time,
		       uint32_t sym,
		       uint32_t state,
		       uint32_t modifiers);
	/**
	 * language
	 *
	 * Sets the language of the input text. The "language" argument
	 * is an RFC-3066 format language tag.
	 * @param serial serial of the latest known text input state
	 */
	void (*language)(void *data,
			 struct zwp_text_input_v1 *zwp_text_input_v1,
			 uint32_t serial,
			 const char *language);
	/**
	 * text direction
	 *
	 * Sets the text direction of input text.
	 *
	 * It is mainly needed for showing an input cursor on the correct
	 * side of the editor when there is no input done yet and making
	 * sure neutral direction text is laid out properly.
	 * @param serial serial of the latest known text input state
	 */
	void (*text_direction)(void *data,
			       struct zwp_text_input_v1 *zwp_text_input_v1,
			       uint32_t serial,
			       uint32_t direction);
};

/**
 * @ingroup iface_zwp_text_input_v1
 */
static inline int
zwp_text_input_v1_add_listener(struct zwp_text_input_v1 *zwp_text_input_v1,
			       const struct zwp_text_input_v1_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) zwp_text_input_v1,
				     (void (**)(void)) listener, data);
}

#define ZWP_TEXT_INPUT_V1_ACTIVATE 0
#define ZWP_TEXT_INPUT_V1_DEACTIVATE 1
#define ZWP_TEXT_INPUT_V1_SHOW_INPUT_PANEL 2
#define ZWP_TEXT_INPUT_V1_HIDE_INPUT_PANEL 3
#define ZWP_TEXT_INPUT_V1_RESET 4
#define ZWP_TEXT_INPUT_V1_SET_SURROUNDING_TEXT 5
#define ZWP_TEXT_INPUT_V1_SET_CONTENT_TYPE 6
#define ZWP_TEXT_INPUT_V1_SET_CURSOR_RECTANGLE 7
#define ZWP_TEXT_INPUT_V1_SET_PREFERRED_LANGUAGE 8
#define ZWP_TEXT_INPUT_V1_COMMIT_STATE 9
#define ZWP_TEXT_INPUT_V1_INVOKE_ACTION 10

/**
 * @ingroup iface_zwp_text_input_v1
 */
#define ZWP_TEXT_INPUT_V1_ENTER_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_text_input_v1
 */
#define ZWP_TEXT_INPUT_V1_LEAVE_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_text_input_v1
 */
#define ZWP_TEXT_INPUT_V1_MODIFIERS_MAP_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_text_input_v1
 */
#define ZWP_TEXT_INPUT_V1_INPUT_PANEL_STATE_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_text_input_v1
 */
#define ZWP_TEXT_INPUT_V1_PREEDIT_STRING_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_text_input_v1
 */
#define ZWP_TEXT_INPUT_V1_PREEDIT_STYLING_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_text_input_v1
 */
#define ZWP_TEXT_INPUT_V1_PREEDIT_CURSOR_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_text_input_v1
 */
#define ZWP_TEXT_INPUT_V1_COMMIT_STRING_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_text_input_v1
 */
#define ZWP_TEXT_INPUT_V1_CURSOR_POSITION_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_text_input_v1
 */
#define ZWP_TEXT_INPUT_V1_DELETE_SURROUNDING_TEXT_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_text_input_v1
 */
#define ZWP_TEXT_INPUT_V1_KEYSYM_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_text_input_v1
 */
#define ZWP_TEXT_INPUT_V1_LANGUAGE_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_text_input_v1
 */
#define ZWP_TEXT_INPUT_V1_TEXT_DIRECTION_SINCE_VERSION 1

/**
 * @ingroup iface_zwp_text_input_v1
 */
#define ZWP_TEXT_INPUT_V1_ACTIVATE_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_text_input_v1
 */
#define ZWP_TEXT_INPUT_V1_DEACTIVATE_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_text_input_v1
 */
#define ZWP_TEXT_INPUT_V1_SHOW_INPUT_PANEL_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_text_input_v1
 */
#define ZWP_TEXT_INPUT_V1_HIDE_INPUT_PANEL_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_text_input_v1
 */
#define ZWP_TEXT_INPUT_V1_RESET_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_text_input_v1
 */
#define ZWP_TEXT_INPUT_V1_SET_SURROUNDING_TEXT_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_text_input_v1
 */
#define ZWP_TEXT_INPUT_V1_SET_CONTENT_TYPE_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_text_input_v1
 */
#define ZWP_TEXT_INPUT_V1_SET_CURSOR_RECTANGLE_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_text_input_v1
 */
#define ZWP_TEXT_INPUT_V1_SET_PREFERRED_LANGUAGE_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_text_input_v1
 */
#define ZWP_TEXT_INPUT_V1_COMMIT_STATE_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_text_input_v1
 */
#define ZWP_TEXT_INPUT_V1_INVOKE_ACTION_SINCE_VERSION 1

/** @ingroup iface_zwp_text_input_v1 */
static inline void
zwp_text_input_v1_set_user_data(struct zwp_text_input_v1 *zwp_text_input_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) zwp_text_input_v1, user_data);
}

/** @ingroup iface_zwp_text_input_v1 */
static inline void *
zwp_text_input_v1_get_user_data(struct zwp_text_input_v1 *zwp_text_input_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) zwp_text_input_v1);
}

static inline uint32_t
zwp_text_input_v1_get_version(struct zwp_text_input_v1 *zwp_text_input_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) zwp_text_input_v1);
}

/** @ingroup iface_zwp_text_input_v1 */
static inline void
zwp_text_input_v1_destroy(struct zwp_text_input_v1 *zwp_text_input_v1)
{
	wl_proxy_destroy((struct wl_proxy *) zwp_text_input_v1);
}

/**
 * @ingroup iface_zwp_text_input_v1
 *
 * Requests the text_input object to be activated (typically when the
 * text entry gets focus).
 *
 * The seat argument is a wl_seat which maintains the focus for this
 * activation. The surface argument is a wl_surface assigned to the
 * text_input object and tracked for focus lost. The enter event
 * is emitted on successful activation.
 */
static inline void
zwp_text_input_v1_activate(struct zwp_text_input_v1 *zwp_text_input_v1, struct wl_seat *seat, struct wl_surface *surface)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zwp_text_input_v1,
			 ZWP_TEXT_INPUT_V1_ACTIVATE, NULL, wl_proxy_get_version((struct wl_proxy *) zwp_text_input_v1), 0, seat, surface);
}

/**
 * @ingroup iface_zwp_text_input_v1
 *
 * Requests the text_input object to be deactivated (typically when the
 * text entry lost focus). The seat argument is a wl_seat which was used
 * for activation.
 */
static inline void
zwp_text_input_v1_deactivate(struct zwp_text_input_v1 *zwp_text_input_v1, struct wl_seat *seat)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zwp_text_input_v1,
			 ZWP_TEXT_INPUT_V1_DEACTIVATE, NULL, wl_proxy_get_version((struct wl_proxy *) zwp_text_input_v1), 0, seat);
}

/**
 * @ingroup iface_zwp_text_input_v1
 *
 * Requests input panels (virtual keyboard) to show.
 */
static inline void
zwp_text_input_v1_show_input_panel(struct zwp_text_input_v1 *zwp_text_input_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zwp_text_input_v1,
			 ZWP_TEXT_INPUT_V1_SHOW_INPUT_PANEL, NULL, wl_proxy_get_version((struct wl_proxy *) zwp_text_input_v1), 0);
}

/**
 * @ingroup iface_zwp_text_input_v1
 *
 * Requests input panels (virtual keyboard) to hide.
 */
static inline void
zwp_text_input_v1_hide_input_panel(struct zwp_text_input_v1 *zwp_text_input_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zwp_text_input_v1,
			 ZWP_TEXT_INPUT_V1_HIDE_INPUT_PANEL, NULL, wl_proxy_get_version((struct wl_proxy *) zwp_text_input_v1), 0);
}

/**
 * @ingroup iface_zwp_text_input_v1
 *
 * Should be called by an editor widget when the input state should be
 * reset, for example after the text was changed outside of the normal
 * input method flow.
 */
static inline void
zwp_text_input_v1_reset(struct zwp_text_input_v1 *zwp_text_input_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zwp_text_input_v1,
			 ZWP_TEXT_INPUT_V1_RESET, NULL, wl_proxy_get_version((struct wl_proxy *) zwp_text_input_v1), 0);
}

/**
 * @ingroup iface_zwp_text_input_v1
 *
 * Sets the plain surrounding text around the input position. Text is
 * UTF-8 encoded. Cursor is the byte offset within the
 * surrounding text. Anchor is the byte offset of the
 * selection anchor within the surrounding text. If there is no selected
 * text anchor, then it is the same as cursor.
 */
static inline void
zwp_text_input_v1_set_surrounding_text(struct zwp_text_input_v1 *zwp_text_input_v1, const char *text, uint32_t cursor, uint32_t anchor)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zwp_text_input_v1,
			 ZWP_TEXT_INPUT_V1_SET_SURROUNDING_TEXT, NULL, wl_proxy_get_version((struct wl_proxy *) zwp_text_input_v1), 0, text, cursor, anchor);
}

/**
 * @ingroup iface_zwp_text_input_v1
 *
 * Sets the content purpose and content hint. While the purpose is the
 * basic purpose of an input field, the hint flags allow to modify some
 * of the behavior.
 *
 * When no content type is explicitly set, a normal content purpose with
 * default hints (auto completion, auto correction, auto capitalization)
 * should be assumed.
 */
static inline void
zwp_text_input_v1_set_content_type(struct zwp_text_input_v1 *zwp_text_input_v1, uint32_t hint, uint32_t purpose)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zwp_text_input_v1,
			 ZWP_TEXT_INPUT_V1_SET_CONTENT_TYPE, NULL, wl_proxy_get_version((struct wl_proxy *) zwp_text_input_v1), 0, hint, purpose);
}

/**
 * @ingroup iface_zwp_text_input_v1
 */
static inline void
zwp_text_input_v1_set_cursor_rectangle(struct zwp_text_input_v1 *zwp_text_input_v1, int32_t x, int32_t y, int32_t width, int32_t height)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zwp_text_input_v1,
			 ZWP_TEXT_INPUT_V1_SET_CURSOR_RECTANGLE, NULL, wl_proxy_get_version((struct wl_proxy *) zwp_text_input_v1), 0, x, y, width, height);
}

/**
 * @ingroup iface_zwp_text_input_v1
 *
 * Sets a specific language. This allows for example a virtual keyboard to
 * show a language specific layout. The "language" argument is an RFC-3066
 * format language tag.
 *
 * It could be used for example in a word processor to indicate the
 * language of the currently edited document or in an instant message
 * application which tracks languages of contacts.
 */
static inline void
zwp_text_input_v1_set_preferred_language(struct zwp_text_input_v1 *zwp_text_input_v1, const char *language)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zwp_text_input_v1,
			 ZWP_TEXT_INPUT_V1_SET_PREFERRED_LANGUAGE, NULL, wl_proxy_get_version((struct wl_proxy *) zwp_text_input_v1), 0, language);
}

/**
 * @ingroup iface_zwp_text_input_v1
 */
static inline void
zwp_text_input_v1_commit_state(struct zwp_text_input_v1 *zwp_text_input_v1, uint32_t serial)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zwp_text_input_v1,
			 ZWP_TEXT_INPUT_V1_COMMIT_STATE, NULL, wl_proxy_get_version((struct wl_proxy *) zwp_text_input_v1), 0, serial);
}

/**
 * @ingroup iface_zwp_text_input_v1
 */
static inline void
zwp_text_input_v1_invoke_action(struct zwp_text_input_v1 *zwp_text_input_v1, uint32_t button, uint32_t index)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zwp_text_input_v1,
			 ZWP_TEXT_INPUT_V1_INVOKE_ACTION, NULL, wl_proxy_get_version((struct wl_proxy *) zwp_text_input_v1), 0, button, index);
}

#define ZWP_TEXT_INPUT_MANAGER_V1_CREATE_TEXT_INPUT 0


/**
 * @ingroup iface_zwp_text_input_manager_v1
 */
#define ZWP_TEXT_INPUT_MANAGER_V1_CREATE_TEXT_INPUT_SINCE_VERSION 1

/** @ingroup iface_zwp_text_input_manager_v1 */
static inline void
zwp_text_input_manager_v1_set_user_data(struct zwp_text_input_manager_v1 *zwp_text_input_manager_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) zwp_text_input_manager_v1, user_data);
}

/** @ingroup iface_zwp_text_input_manager_v1 */
static inline void *
zwp_text_input_manager_v1_get_user_data(struct zwp_text_input_manager_v1 *zwp_text_input_manager_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) zwp_text_input_manager_v1);
}

static inline uint32_t
zwp_text_input_manager_v1_get_version(struct zwp_text_input_manager_v1 *zwp_text_input_manager_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) zwp_text_input_manager_v1);
}

/** @ingroup iface_zwp_text_input_manager_v1 */
static inline void
zwp_text_input_manager_v1_destroy(struct zwp_text_input_manager_v1 *zwp_text_input_manager_v1)
{
	wl_proxy_destroy((struct wl_proxy *) zwp_text_input_manager_v1);
}

/**
 * @ingroup iface_zwp_text_input_manager_v1
 *
 * Creates a new text_input object.
 */
static inline struct zwp_text_input_v1 *
zwp_text_input_manager_v1_create_text_input(struct zwp_text_input_manager_v1 *zwp_text_input_manager_v1)
{
	struct wl_proxy *id;

	id = wl_proxy_marshal_flags((struct wl_proxy *) zwp_text_input_manager_v1,
			 ZWP_TEXT_INPUT_MANAGER_V1_CREATE_TEXT_INPUT, &zwp_text_input_v1_interface, wl_proxy_get_version((struct wl_proxy *) zwp_text_input_manager_v1), 0, NULL);

	return (struct zwp_text_input_v1 *) id;
}

#ifdef  __cplusplus
}
#endif

#endif
