/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	v1 "k8s.io/client-go/kubernetes/typed/core/v1"
	rest "k8s.io/client-go/rest"
	testing "k8s.io/client-go/testing"
)

type FakeCoreV1 struct {
	*testing.Fake
}

func (c *FakeCoreV1) ComponentStatuses() v1.ComponentStatusInterface {
	return newFakeComponentStatuses(c)
}

func (c *FakeCoreV1) ConfigMaps(namespace string) v1.ConfigMapInterface {
	return newFakeConfigMaps(c, namespace)
}

func (c *FakeCoreV1) Endpoints(namespace string) v1.EndpointsInterface {
	return newFakeEndpoints(c, namespace)
}

func (c *FakeCoreV1) Events(namespace string) v1.EventInterface {
	return newFakeEvents(c, namespace)
}

func (c *FakeCoreV1) LimitRanges(namespace string) v1.LimitRangeInterface {
	return newFakeLimitRanges(c, namespace)
}

func (c *FakeCoreV1) Namespaces() v1.NamespaceInterface {
	return newFakeNamespaces(c)
}

func (c *FakeCoreV1) Nodes() v1.NodeInterface {
	return newFakeNodes(c)
}

func (c *FakeCoreV1) PersistentVolumes() v1.PersistentVolumeInterface {
	return newFakePersistentVolumes(c)
}

func (c *FakeCoreV1) PersistentVolumeClaims(namespace string) v1.PersistentVolumeClaimInterface {
	return newFakePersistentVolumeClaims(c, namespace)
}

func (c *FakeCoreV1) Pods(namespace string) v1.PodInterface {
	return newFakePods(c, namespace)
}

func (c *FakeCoreV1) PodTemplates(namespace string) v1.PodTemplateInterface {
	return newFakePodTemplates(c, namespace)
}

func (c *FakeCoreV1) ReplicationControllers(namespace string) v1.ReplicationControllerInterface {
	return newFakeReplicationControllers(c, namespace)
}

func (c *FakeCoreV1) ResourceQuotas(namespace string) v1.ResourceQuotaInterface {
	return newFakeResourceQuotas(c, namespace)
}

func (c *FakeCoreV1) Secrets(namespace string) v1.SecretInterface {
	return newFakeSecrets(c, namespace)
}

func (c *FakeCoreV1) Services(namespace string) v1.ServiceInterface {
	return newFakeServices(c, namespace)
}

func (c *FakeCoreV1) ServiceAccounts(namespace string) v1.ServiceAccountInterface {
	return newFakeServiceAccounts(c, namespace)
}

// RESTClient returns a RESTClient that is used to communicate
// with API server by this client implementation.
func (c *FakeCoreV1) RESTClient() rest.Interface {
	var ret *rest.RESTClient
	return ret
}
