//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armhanaonazure

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// SapMonitorsClient contains the methods for the SapMonitors group.
// Don't use this type directly, use NewSapMonitorsClient() instead.
type SapMonitorsClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewSapMonitorsClient creates a new instance of SapMonitorsClient with the specified values.
//   - subscriptionID - Subscription ID which uniquely identify Microsoft Azure subscription. The subscription ID forms part of
//     the URI for every service call.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewSapMonitorsClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*SapMonitorsClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &SapMonitorsClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// BeginCreate - Creates a SAP monitor for the specified subscription, resource group, and resource name.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2020-02-07-preview
//   - resourceGroupName - Name of the resource group.
//   - sapMonitorName - Name of the SAP monitor resource.
//   - sapMonitorParameter - Request body representing a SAP Monitor
//   - options - SapMonitorsClientBeginCreateOptions contains the optional parameters for the SapMonitorsClient.BeginCreate method.
func (client *SapMonitorsClient) BeginCreate(ctx context.Context, resourceGroupName string, sapMonitorName string, sapMonitorParameter SapMonitor, options *SapMonitorsClientBeginCreateOptions) (*runtime.Poller[SapMonitorsClientCreateResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.create(ctx, resourceGroupName, sapMonitorName, sapMonitorParameter, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[SapMonitorsClientCreateResponse]{
			Tracer: client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[SapMonitorsClientCreateResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// Create - Creates a SAP monitor for the specified subscription, resource group, and resource name.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2020-02-07-preview
func (client *SapMonitorsClient) create(ctx context.Context, resourceGroupName string, sapMonitorName string, sapMonitorParameter SapMonitor, options *SapMonitorsClientBeginCreateOptions) (*http.Response, error) {
	var err error
	const operationName = "SapMonitorsClient.BeginCreate"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createCreateRequest(ctx, resourceGroupName, sapMonitorName, sapMonitorParameter, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusCreated) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// createCreateRequest creates the Create request.
func (client *SapMonitorsClient) createCreateRequest(ctx context.Context, resourceGroupName string, sapMonitorName string, sapMonitorParameter SapMonitor, options *SapMonitorsClientBeginCreateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HanaOnAzure/sapMonitors/{sapMonitorName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if sapMonitorName == "" {
		return nil, errors.New("parameter sapMonitorName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{sapMonitorName}", url.PathEscape(sapMonitorName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-02-07-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, sapMonitorParameter); err != nil {
		return nil, err
	}
	return req, nil
}

// BeginDelete - Deletes a SAP monitor with the specified subscription, resource group, and monitor name.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2020-02-07-preview
//   - resourceGroupName - Name of the resource group.
//   - sapMonitorName - Name of the SAP monitor resource.
//   - options - SapMonitorsClientBeginDeleteOptions contains the optional parameters for the SapMonitorsClient.BeginDelete method.
func (client *SapMonitorsClient) BeginDelete(ctx context.Context, resourceGroupName string, sapMonitorName string, options *SapMonitorsClientBeginDeleteOptions) (*runtime.Poller[SapMonitorsClientDeleteResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.deleteOperation(ctx, resourceGroupName, sapMonitorName, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[SapMonitorsClientDeleteResponse]{
			Tracer: client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[SapMonitorsClientDeleteResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// Delete - Deletes a SAP monitor with the specified subscription, resource group, and monitor name.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2020-02-07-preview
func (client *SapMonitorsClient) deleteOperation(ctx context.Context, resourceGroupName string, sapMonitorName string, options *SapMonitorsClientBeginDeleteOptions) (*http.Response, error) {
	var err error
	const operationName = "SapMonitorsClient.BeginDelete"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteCreateRequest(ctx, resourceGroupName, sapMonitorName, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// deleteCreateRequest creates the Delete request.
func (client *SapMonitorsClient) deleteCreateRequest(ctx context.Context, resourceGroupName string, sapMonitorName string, options *SapMonitorsClientBeginDeleteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HanaOnAzure/sapMonitors/{sapMonitorName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if sapMonitorName == "" {
		return nil, errors.New("parameter sapMonitorName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{sapMonitorName}", url.PathEscape(sapMonitorName))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-02-07-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// Get - Gets properties of a SAP monitor for the specified subscription, resource group, and resource name.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2020-02-07-preview
//   - resourceGroupName - Name of the resource group.
//   - sapMonitorName - Name of the SAP monitor resource.
//   - options - SapMonitorsClientGetOptions contains the optional parameters for the SapMonitorsClient.Get method.
func (client *SapMonitorsClient) Get(ctx context.Context, resourceGroupName string, sapMonitorName string, options *SapMonitorsClientGetOptions) (SapMonitorsClientGetResponse, error) {
	var err error
	const operationName = "SapMonitorsClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, resourceGroupName, sapMonitorName, options)
	if err != nil {
		return SapMonitorsClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return SapMonitorsClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return SapMonitorsClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *SapMonitorsClient) getCreateRequest(ctx context.Context, resourceGroupName string, sapMonitorName string, options *SapMonitorsClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HanaOnAzure/sapMonitors/{sapMonitorName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if sapMonitorName == "" {
		return nil, errors.New("parameter sapMonitorName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{sapMonitorName}", url.PathEscape(sapMonitorName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-02-07-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *SapMonitorsClient) getHandleResponse(resp *http.Response) (SapMonitorsClientGetResponse, error) {
	result := SapMonitorsClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SapMonitor); err != nil {
		return SapMonitorsClientGetResponse{}, err
	}
	return result, nil
}

// NewListPager - Gets a list of SAP monitors in the specified subscription. The operations returns various properties of
// each SAP monitor.
//
// Generated from API version 2020-02-07-preview
//   - options - SapMonitorsClientListOptions contains the optional parameters for the SapMonitorsClient.NewListPager method.
func (client *SapMonitorsClient) NewListPager(options *SapMonitorsClientListOptions) *runtime.Pager[SapMonitorsClientListResponse] {
	return runtime.NewPager(runtime.PagingHandler[SapMonitorsClientListResponse]{
		More: func(page SapMonitorsClientListResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *SapMonitorsClientListResponse) (SapMonitorsClientListResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "SapMonitorsClient.NewListPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listCreateRequest(ctx, options)
			}, nil)
			if err != nil {
				return SapMonitorsClientListResponse{}, err
			}
			return client.listHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listCreateRequest creates the List request.
func (client *SapMonitorsClient) listCreateRequest(ctx context.Context, options *SapMonitorsClientListOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.HanaOnAzure/sapMonitors"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-02-07-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *SapMonitorsClient) listHandleResponse(resp *http.Response) (SapMonitorsClientListResponse, error) {
	result := SapMonitorsClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SapMonitorListResult); err != nil {
		return SapMonitorsClientListResponse{}, err
	}
	return result, nil
}

// Update - Patches the Tags field of a SAP monitor for the specified subscription, resource group, and monitor name.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2020-02-07-preview
//   - resourceGroupName - Name of the resource group.
//   - sapMonitorName - Name of the SAP monitor resource.
//   - tagsParameter - Request body that only contains the new Tags field
//   - options - SapMonitorsClientUpdateOptions contains the optional parameters for the SapMonitorsClient.Update method.
func (client *SapMonitorsClient) Update(ctx context.Context, resourceGroupName string, sapMonitorName string, tagsParameter Tags, options *SapMonitorsClientUpdateOptions) (SapMonitorsClientUpdateResponse, error) {
	var err error
	const operationName = "SapMonitorsClient.Update"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.updateCreateRequest(ctx, resourceGroupName, sapMonitorName, tagsParameter, options)
	if err != nil {
		return SapMonitorsClientUpdateResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return SapMonitorsClientUpdateResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return SapMonitorsClientUpdateResponse{}, err
	}
	resp, err := client.updateHandleResponse(httpResp)
	return resp, err
}

// updateCreateRequest creates the Update request.
func (client *SapMonitorsClient) updateCreateRequest(ctx context.Context, resourceGroupName string, sapMonitorName string, tagsParameter Tags, options *SapMonitorsClientUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HanaOnAzure/sapMonitors/{sapMonitorName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if sapMonitorName == "" {
		return nil, errors.New("parameter sapMonitorName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{sapMonitorName}", url.PathEscape(sapMonitorName))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-02-07-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, tagsParameter); err != nil {
		return nil, err
	}
	return req, nil
}

// updateHandleResponse handles the Update response.
func (client *SapMonitorsClient) updateHandleResponse(resp *http.Response) (SapMonitorsClientUpdateResponse, error) {
	result := SapMonitorsClientUpdateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SapMonitor); err != nil {
		return SapMonitorsClientUpdateResponse{}, err
	}
	return result, nil
}
