//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"strings"
	"sync"
)

// ServerFactory is a fake server for instances of the armconsumption.ClientFactory type.
type ServerFactory struct {
	AggregatedCostServer                   AggregatedCostServer
	BalancesServer                         BalancesServer
	BudgetsServer                          BudgetsServer
	ChargesServer                          ChargesServer
	CreditsServer                          CreditsServer
	EventsServer                           EventsServer
	LotsServer                             LotsServer
	MarketplacesServer                     MarketplacesServer
	OperationsServer                       OperationsServer
	PriceSheetServer                       PriceSheetServer
	ReservationRecommendationDetailsServer ReservationRecommendationDetailsServer
	ReservationRecommendationsServer       ReservationRecommendationsServer
	ReservationTransactionsServer          ReservationTransactionsServer
	ReservationsDetailsServer              ReservationsDetailsServer
	ReservationsSummariesServer            ReservationsSummariesServer
	TagsServer                             TagsServer
	UsageDetailsServer                     UsageDetailsServer
}

// NewServerFactoryTransport creates a new instance of ServerFactoryTransport with the provided implementation.
// The returned ServerFactoryTransport instance is connected to an instance of armconsumption.ClientFactory via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewServerFactoryTransport(srv *ServerFactory) *ServerFactoryTransport {
	return &ServerFactoryTransport{
		srv: srv,
	}
}

// ServerFactoryTransport connects instances of armconsumption.ClientFactory to instances of ServerFactory.
// Don't use this type directly, use NewServerFactoryTransport instead.
type ServerFactoryTransport struct {
	srv                                      *ServerFactory
	trMu                                     sync.Mutex
	trAggregatedCostServer                   *AggregatedCostServerTransport
	trBalancesServer                         *BalancesServerTransport
	trBudgetsServer                          *BudgetsServerTransport
	trChargesServer                          *ChargesServerTransport
	trCreditsServer                          *CreditsServerTransport
	trEventsServer                           *EventsServerTransport
	trLotsServer                             *LotsServerTransport
	trMarketplacesServer                     *MarketplacesServerTransport
	trOperationsServer                       *OperationsServerTransport
	trPriceSheetServer                       *PriceSheetServerTransport
	trReservationRecommendationDetailsServer *ReservationRecommendationDetailsServerTransport
	trReservationRecommendationsServer       *ReservationRecommendationsServerTransport
	trReservationTransactionsServer          *ReservationTransactionsServerTransport
	trReservationsDetailsServer              *ReservationsDetailsServerTransport
	trReservationsSummariesServer            *ReservationsSummariesServerTransport
	trTagsServer                             *TagsServerTransport
	trUsageDetailsServer                     *UsageDetailsServerTransport
}

// Do implements the policy.Transporter interface for ServerFactoryTransport.
func (s *ServerFactoryTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	client := method[:strings.Index(method, ".")]
	var resp *http.Response
	var err error

	switch client {
	case "AggregatedCostClient":
		initServer(s, &s.trAggregatedCostServer, func() *AggregatedCostServerTransport {
			return NewAggregatedCostServerTransport(&s.srv.AggregatedCostServer)
		})
		resp, err = s.trAggregatedCostServer.Do(req)
	case "BalancesClient":
		initServer(s, &s.trBalancesServer, func() *BalancesServerTransport { return NewBalancesServerTransport(&s.srv.BalancesServer) })
		resp, err = s.trBalancesServer.Do(req)
	case "BudgetsClient":
		initServer(s, &s.trBudgetsServer, func() *BudgetsServerTransport { return NewBudgetsServerTransport(&s.srv.BudgetsServer) })
		resp, err = s.trBudgetsServer.Do(req)
	case "ChargesClient":
		initServer(s, &s.trChargesServer, func() *ChargesServerTransport { return NewChargesServerTransport(&s.srv.ChargesServer) })
		resp, err = s.trChargesServer.Do(req)
	case "CreditsClient":
		initServer(s, &s.trCreditsServer, func() *CreditsServerTransport { return NewCreditsServerTransport(&s.srv.CreditsServer) })
		resp, err = s.trCreditsServer.Do(req)
	case "EventsClient":
		initServer(s, &s.trEventsServer, func() *EventsServerTransport { return NewEventsServerTransport(&s.srv.EventsServer) })
		resp, err = s.trEventsServer.Do(req)
	case "LotsClient":
		initServer(s, &s.trLotsServer, func() *LotsServerTransport { return NewLotsServerTransport(&s.srv.LotsServer) })
		resp, err = s.trLotsServer.Do(req)
	case "MarketplacesClient":
		initServer(s, &s.trMarketplacesServer, func() *MarketplacesServerTransport { return NewMarketplacesServerTransport(&s.srv.MarketplacesServer) })
		resp, err = s.trMarketplacesServer.Do(req)
	case "OperationsClient":
		initServer(s, &s.trOperationsServer, func() *OperationsServerTransport { return NewOperationsServerTransport(&s.srv.OperationsServer) })
		resp, err = s.trOperationsServer.Do(req)
	case "PriceSheetClient":
		initServer(s, &s.trPriceSheetServer, func() *PriceSheetServerTransport { return NewPriceSheetServerTransport(&s.srv.PriceSheetServer) })
		resp, err = s.trPriceSheetServer.Do(req)
	case "ReservationRecommendationDetailsClient":
		initServer(s, &s.trReservationRecommendationDetailsServer, func() *ReservationRecommendationDetailsServerTransport {
			return NewReservationRecommendationDetailsServerTransport(&s.srv.ReservationRecommendationDetailsServer)
		})
		resp, err = s.trReservationRecommendationDetailsServer.Do(req)
	case "ReservationRecommendationsClient":
		initServer(s, &s.trReservationRecommendationsServer, func() *ReservationRecommendationsServerTransport {
			return NewReservationRecommendationsServerTransport(&s.srv.ReservationRecommendationsServer)
		})
		resp, err = s.trReservationRecommendationsServer.Do(req)
	case "ReservationTransactionsClient":
		initServer(s, &s.trReservationTransactionsServer, func() *ReservationTransactionsServerTransport {
			return NewReservationTransactionsServerTransport(&s.srv.ReservationTransactionsServer)
		})
		resp, err = s.trReservationTransactionsServer.Do(req)
	case "ReservationsDetailsClient":
		initServer(s, &s.trReservationsDetailsServer, func() *ReservationsDetailsServerTransport {
			return NewReservationsDetailsServerTransport(&s.srv.ReservationsDetailsServer)
		})
		resp, err = s.trReservationsDetailsServer.Do(req)
	case "ReservationsSummariesClient":
		initServer(s, &s.trReservationsSummariesServer, func() *ReservationsSummariesServerTransport {
			return NewReservationsSummariesServerTransport(&s.srv.ReservationsSummariesServer)
		})
		resp, err = s.trReservationsSummariesServer.Do(req)
	case "TagsClient":
		initServer(s, &s.trTagsServer, func() *TagsServerTransport { return NewTagsServerTransport(&s.srv.TagsServer) })
		resp, err = s.trTagsServer.Do(req)
	case "UsageDetailsClient":
		initServer(s, &s.trUsageDetailsServer, func() *UsageDetailsServerTransport { return NewUsageDetailsServerTransport(&s.srv.UsageDetailsServer) })
		resp, err = s.trUsageDetailsServer.Do(req)
	default:
		err = fmt.Errorf("unhandled client %s", client)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func initServer[T any](s *ServerFactoryTransport, dst **T, src func() *T) {
	s.trMu.Lock()
	if *dst == nil {
		*dst = src()
	}
	s.trMu.Unlock()
}
