//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armcompute

type AccessLevel string

const (
	AccessLevelNone  AccessLevel = "None"
	AccessLevelRead  AccessLevel = "Read"
	AccessLevelWrite AccessLevel = "Write"
)

// PossibleAccessLevelValues returns the possible values for the AccessLevel const type.
func PossibleAccessLevelValues() []AccessLevel {
	return []AccessLevel{
		AccessLevelNone,
		AccessLevelRead,
		AccessLevelWrite,
	}
}

// AvailabilitySetSKUTypes - Specifies the sku of an Availability Set. Use 'Aligned' for virtual machines with managed disks
// and 'Classic' for virtual machines with unmanaged disks. Default value is 'Classic'.
type AvailabilitySetSKUTypes string

const (
	AvailabilitySetSKUTypesAligned AvailabilitySetSKUTypes = "Aligned"
	AvailabilitySetSKUTypesClassic AvailabilitySetSKUTypes = "Classic"
)

// PossibleAvailabilitySetSKUTypesValues returns the possible values for the AvailabilitySetSKUTypes const type.
func PossibleAvailabilitySetSKUTypesValues() []AvailabilitySetSKUTypes {
	return []AvailabilitySetSKUTypes{
		AvailabilitySetSKUTypesAligned,
		AvailabilitySetSKUTypesClassic,
	}
}

// CachingTypes - Specifies the caching requirements.
// Possible values are:
// None
// ReadOnly
// ReadWrite
// Default: None for Standard storage. ReadOnly for Premium storage
type CachingTypes string

const (
	CachingTypesNone      CachingTypes = "None"
	CachingTypesReadOnly  CachingTypes = "ReadOnly"
	CachingTypesReadWrite CachingTypes = "ReadWrite"
)

// PossibleCachingTypesValues returns the possible values for the CachingTypes const type.
func PossibleCachingTypesValues() []CachingTypes {
	return []CachingTypes{
		CachingTypesNone,
		CachingTypesReadOnly,
		CachingTypesReadWrite,
	}
}

// DedicatedHostLicenseTypes - Specifies the software license type that will be applied to the VMs deployed on the dedicated
// host.
// Possible values are:
// None
// WindowsServerHybrid
// WindowsServerPerpetual
// Default: None
type DedicatedHostLicenseTypes string

const (
	DedicatedHostLicenseTypesNone                   DedicatedHostLicenseTypes = "None"
	DedicatedHostLicenseTypesWindowsServerHybrid    DedicatedHostLicenseTypes = "Windows_Server_Hybrid"
	DedicatedHostLicenseTypesWindowsServerPerpetual DedicatedHostLicenseTypes = "Windows_Server_Perpetual"
)

// PossibleDedicatedHostLicenseTypesValues returns the possible values for the DedicatedHostLicenseTypes const type.
func PossibleDedicatedHostLicenseTypesValues() []DedicatedHostLicenseTypes {
	return []DedicatedHostLicenseTypes{
		DedicatedHostLicenseTypesNone,
		DedicatedHostLicenseTypesWindowsServerHybrid,
		DedicatedHostLicenseTypesWindowsServerPerpetual,
	}
}

// DiffDiskOptions - Specifies the ephemeral disk option for operating system disk.
type DiffDiskOptions string

const (
	DiffDiskOptionsLocal DiffDiskOptions = "Local"
)

// PossibleDiffDiskOptionsValues returns the possible values for the DiffDiskOptions const type.
func PossibleDiffDiskOptionsValues() []DiffDiskOptions {
	return []DiffDiskOptions{
		DiffDiskOptionsLocal,
	}
}

// DiffDiskPlacement - Specifies the ephemeral disk placement for operating system disk. This property can be used by user
// in the request to choose the location i.e, cache disk or resource disk space for Ephemeral OS disk
// provisioning. For more information on Ephemeral OS disk size requirements, please refer Ephemeral OS disk size requirements
// for Windows VM at
// https://docs.microsoft.com/en-us/azure/virtual-machines/windows/ephemeral-os-disks#size-requirements and Linux VM at
// https://docs.microsoft.com/en-us/azure/virtual-machines/linux/ephemeral-os-disks#size-requirements
type DiffDiskPlacement string

const (
	DiffDiskPlacementCacheDisk    DiffDiskPlacement = "CacheDisk"
	DiffDiskPlacementResourceDisk DiffDiskPlacement = "ResourceDisk"
)

// PossibleDiffDiskPlacementValues returns the possible values for the DiffDiskPlacement const type.
func PossibleDiffDiskPlacementValues() []DiffDiskPlacement {
	return []DiffDiskPlacement{
		DiffDiskPlacementCacheDisk,
		DiffDiskPlacementResourceDisk,
	}
}

// DiskCreateOption - This enumerates the possible sources of a disk's creation.
type DiskCreateOption string

const (
	// DiskCreateOptionAttach - Disk will be attached to a VM.
	DiskCreateOptionAttach DiskCreateOption = "Attach"
	// DiskCreateOptionCopy - Create a new disk or snapshot by copying from a disk or snapshot specified by the given sourceResourceId.
	DiskCreateOptionCopy DiskCreateOption = "Copy"
	// DiskCreateOptionEmpty - Create an empty data disk of a size given by diskSizeGB.
	DiskCreateOptionEmpty DiskCreateOption = "Empty"
	// DiskCreateOptionFromImage - Create a new disk from a platform image specified by the given imageReference.
	DiskCreateOptionFromImage DiskCreateOption = "FromImage"
	// DiskCreateOptionImport - Create a disk by importing from a blob specified by a sourceUri in a storage account specified
	// by storageAccountId.
	DiskCreateOptionImport DiskCreateOption = "Import"
	// DiskCreateOptionRestore - Create a new disk by copying from a backup recovery point.
	DiskCreateOptionRestore DiskCreateOption = "Restore"
	// DiskCreateOptionUpload - Create a new disk by obtaining a write token and using it to directly upload the contents of the
	// disk.
	DiskCreateOptionUpload DiskCreateOption = "Upload"
)

// PossibleDiskCreateOptionValues returns the possible values for the DiskCreateOption const type.
func PossibleDiskCreateOptionValues() []DiskCreateOption {
	return []DiskCreateOption{
		DiskCreateOptionAttach,
		DiskCreateOptionCopy,
		DiskCreateOptionEmpty,
		DiskCreateOptionFromImage,
		DiskCreateOptionImport,
		DiskCreateOptionRestore,
		DiskCreateOptionUpload,
	}
}

// DiskCreateOptionTypes - Specifies how the virtual machine should be created.
// Possible values are:
// Attach \u2013 This value is used when you are using a specialized disk to create the virtual machine.
// FromImage \u2013 This value is used when you are using an image to create the virtual machine. If you are using a platform
// image, you also use the imageReference element described above. If you are
// using a marketplace image, you also use the plan element previously described.
type DiskCreateOptionTypes string

const (
	DiskCreateOptionTypesAttach    DiskCreateOptionTypes = "Attach"
	DiskCreateOptionTypesEmpty     DiskCreateOptionTypes = "Empty"
	DiskCreateOptionTypesFromImage DiskCreateOptionTypes = "FromImage"
)

// PossibleDiskCreateOptionTypesValues returns the possible values for the DiskCreateOptionTypes const type.
func PossibleDiskCreateOptionTypesValues() []DiskCreateOptionTypes {
	return []DiskCreateOptionTypes{
		DiskCreateOptionTypesAttach,
		DiskCreateOptionTypesEmpty,
		DiskCreateOptionTypesFromImage,
	}
}

// DiskEncryptionSetIdentityType - The type of Managed Identity used by the DiskEncryptionSet. Only SystemAssigned is supported.
type DiskEncryptionSetIdentityType string

const (
	DiskEncryptionSetIdentityTypeSystemAssigned DiskEncryptionSetIdentityType = "SystemAssigned"
)

// PossibleDiskEncryptionSetIdentityTypeValues returns the possible values for the DiskEncryptionSetIdentityType const type.
func PossibleDiskEncryptionSetIdentityTypeValues() []DiskEncryptionSetIdentityType {
	return []DiskEncryptionSetIdentityType{
		DiskEncryptionSetIdentityTypeSystemAssigned,
	}
}

// DiskState - The state of the disk.
type DiskState string

const (
	// DiskStateActiveSAS - The disk currently has an Active SAS Uri associated with it.
	DiskStateActiveSAS DiskState = "ActiveSAS"
	// DiskStateActiveUpload - A disk is created for upload and a write token has been issued for uploading to it.
	DiskStateActiveUpload DiskState = "ActiveUpload"
	// DiskStateAttached - The disk is currently mounted to a running VM.
	DiskStateAttached DiskState = "Attached"
	// DiskStateReadyToUpload - A disk is ready to be created by upload by requesting a write token.
	DiskStateReadyToUpload DiskState = "ReadyToUpload"
	// DiskStateReserved - The disk is mounted to a stopped-deallocated VM
	DiskStateReserved DiskState = "Reserved"
	// DiskStateUnattached - The disk is not being used and can be attached to a VM.
	DiskStateUnattached DiskState = "Unattached"
)

// PossibleDiskStateValues returns the possible values for the DiskState const type.
func PossibleDiskStateValues() []DiskState {
	return []DiskState{
		DiskStateActiveSAS,
		DiskStateActiveUpload,
		DiskStateAttached,
		DiskStateReadyToUpload,
		DiskStateReserved,
		DiskStateUnattached,
	}
}

// DiskStorageAccountTypes - The sku name.
type DiskStorageAccountTypes string

const (
	// DiskStorageAccountTypesPremiumLRS - Premium SSD locally redundant storage. Best for production and performance sensitive
	// workloads.
	DiskStorageAccountTypesPremiumLRS DiskStorageAccountTypes = "Premium_LRS"
	// DiskStorageAccountTypesStandardLRS - Standard HDD locally redundant storage. Best for backup, non-critical, and infrequent
	// access.
	DiskStorageAccountTypesStandardLRS DiskStorageAccountTypes = "Standard_LRS"
	// DiskStorageAccountTypesStandardSSDLRS - Standard SSD locally redundant storage. Best for web servers, lightly used enterprise
	// applications and dev/test.
	DiskStorageAccountTypesStandardSSDLRS DiskStorageAccountTypes = "StandardSSD_LRS"
	// DiskStorageAccountTypesUltraSSDLRS - Ultra SSD locally redundant storage. Best for IO-intensive workloads such as SAP HANA,
	// top tier databases (for example, SQL, Oracle), and other transaction-heavy workloads.
	DiskStorageAccountTypesUltraSSDLRS DiskStorageAccountTypes = "UltraSSD_LRS"
)

// PossibleDiskStorageAccountTypesValues returns the possible values for the DiskStorageAccountTypes const type.
func PossibleDiskStorageAccountTypesValues() []DiskStorageAccountTypes {
	return []DiskStorageAccountTypes{
		DiskStorageAccountTypesPremiumLRS,
		DiskStorageAccountTypesStandardLRS,
		DiskStorageAccountTypesStandardSSDLRS,
		DiskStorageAccountTypesUltraSSDLRS,
	}
}

// EncryptionType - The type of key used to encrypt the data of the disk.
type EncryptionType string

const (
	// EncryptionTypeEncryptionAtRestWithCustomerKey - Disk is encrypted with Customer managed key at rest.
	EncryptionTypeEncryptionAtRestWithCustomerKey EncryptionType = "EncryptionAtRestWithCustomerKey"
	// EncryptionTypeEncryptionAtRestWithPlatformKey - Disk is encrypted with XStore managed key at rest. It is the default encryption
	// type.
	EncryptionTypeEncryptionAtRestWithPlatformKey EncryptionType = "EncryptionAtRestWithPlatformKey"
)

// PossibleEncryptionTypeValues returns the possible values for the EncryptionType const type.
func PossibleEncryptionTypeValues() []EncryptionType {
	return []EncryptionType{
		EncryptionTypeEncryptionAtRestWithCustomerKey,
		EncryptionTypeEncryptionAtRestWithPlatformKey,
	}
}

// HyperVGeneration - The hypervisor generation of the Virtual Machine. Applicable to OS disks only.
type HyperVGeneration string

const (
	HyperVGenerationV1 HyperVGeneration = "V1"
	HyperVGenerationV2 HyperVGeneration = "V2"
)

// PossibleHyperVGenerationValues returns the possible values for the HyperVGeneration const type.
func PossibleHyperVGenerationValues() []HyperVGeneration {
	return []HyperVGeneration{
		HyperVGenerationV1,
		HyperVGenerationV2,
	}
}

// HyperVGenerationType - Specifies the HyperVGeneration Type associated with a resource
type HyperVGenerationType string

const (
	HyperVGenerationTypeV1 HyperVGenerationType = "V1"
	HyperVGenerationTypeV2 HyperVGenerationType = "V2"
)

// PossibleHyperVGenerationTypeValues returns the possible values for the HyperVGenerationType const type.
func PossibleHyperVGenerationTypeValues() []HyperVGenerationType {
	return []HyperVGenerationType{
		HyperVGenerationTypeV1,
		HyperVGenerationTypeV2,
	}
}

// HyperVGenerationTypes - Specifies the HyperVGeneration Type
type HyperVGenerationTypes string

const (
	HyperVGenerationTypesV1 HyperVGenerationTypes = "V1"
	HyperVGenerationTypesV2 HyperVGenerationTypes = "V2"
)

// PossibleHyperVGenerationTypesValues returns the possible values for the HyperVGenerationTypes const type.
func PossibleHyperVGenerationTypesValues() []HyperVGenerationTypes {
	return []HyperVGenerationTypes{
		HyperVGenerationTypesV1,
		HyperVGenerationTypesV2,
	}
}

// IPVersion - Available from Api-Version 2017-03-30 onwards, it represents whether the specific ipconfiguration is IPv4 or
// IPv6. Default is taken as IPv4. Possible values are: 'IPv4' and 'IPv6'.
type IPVersion string

const (
	IPVersionIPv4 IPVersion = "IPv4"
	IPVersionIPv6 IPVersion = "IPv6"
)

// PossibleIPVersionValues returns the possible values for the IPVersion const type.
func PossibleIPVersionValues() []IPVersion {
	return []IPVersion{
		IPVersionIPv4,
		IPVersionIPv6,
	}
}

// InGuestPatchMode - Specifies the mode of in-guest patching to IaaS virtual machine.
// Possible values are:
// Manual - You control the application of patches to a virtual machine. You do this by applying patches manually inside the
// VM. In this mode, automatic updates are disabled; the property
// WindowsConfiguration.enableAutomaticUpdates must be false
// AutomaticByOS - The virtual machine will automatically be updated by the OS. The property WindowsConfiguration.enableAutomaticUpdates
// must be true.
// AutomaticByPlatform - the virtual machine will automatically updated by the platform. The properties provisionVMAgent and
// WindowsConfiguration.enableAutomaticUpdates must be true
type InGuestPatchMode string

const (
	InGuestPatchModeAutomaticByOS       InGuestPatchMode = "AutomaticByOS"
	InGuestPatchModeAutomaticByPlatform InGuestPatchMode = "AutomaticByPlatform"
	InGuestPatchModeManual              InGuestPatchMode = "Manual"
)

// PossibleInGuestPatchModeValues returns the possible values for the InGuestPatchMode const type.
func PossibleInGuestPatchModeValues() []InGuestPatchMode {
	return []InGuestPatchMode{
		InGuestPatchModeAutomaticByOS,
		InGuestPatchModeAutomaticByPlatform,
		InGuestPatchModeManual,
	}
}

// IntervalInMins - Interval value in minutes used to create LogAnalytics call rate logs.
type IntervalInMins string

const (
	IntervalInMinsThreeMins  IntervalInMins = "ThreeMins"
	IntervalInMinsFiveMins   IntervalInMins = "FiveMins"
	IntervalInMinsThirtyMins IntervalInMins = "ThirtyMins"
	IntervalInMinsSixtyMins  IntervalInMins = "SixtyMins"
)

// PossibleIntervalInMinsValues returns the possible values for the IntervalInMins const type.
func PossibleIntervalInMinsValues() []IntervalInMins {
	return []IntervalInMins{
		IntervalInMinsThreeMins,
		IntervalInMinsFiveMins,
		IntervalInMinsThirtyMins,
		IntervalInMinsSixtyMins,
	}
}

// MaintenanceOperationResultCodeTypes - The Last Maintenance Operation Result Code.
type MaintenanceOperationResultCodeTypes string

const (
	MaintenanceOperationResultCodeTypesNone                 MaintenanceOperationResultCodeTypes = "None"
	MaintenanceOperationResultCodeTypesRetryLater           MaintenanceOperationResultCodeTypes = "RetryLater"
	MaintenanceOperationResultCodeTypesMaintenanceAborted   MaintenanceOperationResultCodeTypes = "MaintenanceAborted"
	MaintenanceOperationResultCodeTypesMaintenanceCompleted MaintenanceOperationResultCodeTypes = "MaintenanceCompleted"
)

// PossibleMaintenanceOperationResultCodeTypesValues returns the possible values for the MaintenanceOperationResultCodeTypes const type.
func PossibleMaintenanceOperationResultCodeTypesValues() []MaintenanceOperationResultCodeTypes {
	return []MaintenanceOperationResultCodeTypes{
		MaintenanceOperationResultCodeTypesNone,
		MaintenanceOperationResultCodeTypesRetryLater,
		MaintenanceOperationResultCodeTypesMaintenanceAborted,
		MaintenanceOperationResultCodeTypesMaintenanceCompleted,
	}
}

// OperatingSystemStateTypes - The OS State.
type OperatingSystemStateTypes string

const (
	// OperatingSystemStateTypesGeneralized - Generalized image. Needs to be provisioned during deployment time.
	OperatingSystemStateTypesGeneralized OperatingSystemStateTypes = "Generalized"
	// OperatingSystemStateTypesSpecialized - Specialized image. Contains already provisioned OS Disk.
	OperatingSystemStateTypesSpecialized OperatingSystemStateTypes = "Specialized"
)

// PossibleOperatingSystemStateTypesValues returns the possible values for the OperatingSystemStateTypes const type.
func PossibleOperatingSystemStateTypesValues() []OperatingSystemStateTypes {
	return []OperatingSystemStateTypes{
		OperatingSystemStateTypesGeneralized,
		OperatingSystemStateTypesSpecialized,
	}
}

// OperatingSystemTypes - The Operating System type.
type OperatingSystemTypes string

const (
	OperatingSystemTypesWindows OperatingSystemTypes = "Windows"
	OperatingSystemTypesLinux   OperatingSystemTypes = "Linux"
)

// PossibleOperatingSystemTypesValues returns the possible values for the OperatingSystemTypes const type.
func PossibleOperatingSystemTypesValues() []OperatingSystemTypes {
	return []OperatingSystemTypes{
		OperatingSystemTypesWindows,
		OperatingSystemTypesLinux,
	}
}

// OrchestrationServiceNames - The name of the service.
type OrchestrationServiceNames string

const (
	OrchestrationServiceNamesAutomaticRepairs OrchestrationServiceNames = "AutomaticRepairs"
)

// PossibleOrchestrationServiceNamesValues returns the possible values for the OrchestrationServiceNames const type.
func PossibleOrchestrationServiceNamesValues() []OrchestrationServiceNames {
	return []OrchestrationServiceNames{
		OrchestrationServiceNamesAutomaticRepairs,
	}
}

// OrchestrationServiceState - The current state of the service.
type OrchestrationServiceState string

const (
	OrchestrationServiceStateNotRunning OrchestrationServiceState = "NotRunning"
	OrchestrationServiceStateRunning    OrchestrationServiceState = "Running"
	OrchestrationServiceStateSuspended  OrchestrationServiceState = "Suspended"
)

// PossibleOrchestrationServiceStateValues returns the possible values for the OrchestrationServiceState const type.
func PossibleOrchestrationServiceStateValues() []OrchestrationServiceState {
	return []OrchestrationServiceState{
		OrchestrationServiceStateNotRunning,
		OrchestrationServiceStateRunning,
		OrchestrationServiceStateSuspended,
	}
}

// OrchestrationServiceStateAction - The action to be performed.
type OrchestrationServiceStateAction string

const (
	OrchestrationServiceStateActionResume  OrchestrationServiceStateAction = "Resume"
	OrchestrationServiceStateActionSuspend OrchestrationServiceStateAction = "Suspend"
)

// PossibleOrchestrationServiceStateActionValues returns the possible values for the OrchestrationServiceStateAction const type.
func PossibleOrchestrationServiceStateActionValues() []OrchestrationServiceStateAction {
	return []OrchestrationServiceStateAction{
		OrchestrationServiceStateActionResume,
		OrchestrationServiceStateActionSuspend,
	}
}

// PatchAssessmentState - Describes the outcome of an install operation for a given patch.
type PatchAssessmentState string

const (
	PatchAssessmentStateAvailable   PatchAssessmentState = "Available"
	PatchAssessmentStateExcluded    PatchAssessmentState = "Excluded"
	PatchAssessmentStateFailed      PatchAssessmentState = "Failed"
	PatchAssessmentStateInstalled   PatchAssessmentState = "Installed"
	PatchAssessmentStateNotSelected PatchAssessmentState = "NotSelected"
	PatchAssessmentStatePending     PatchAssessmentState = "Pending"
)

// PossiblePatchAssessmentStateValues returns the possible values for the PatchAssessmentState const type.
func PossiblePatchAssessmentStateValues() []PatchAssessmentState {
	return []PatchAssessmentState{
		PatchAssessmentStateAvailable,
		PatchAssessmentStateExcluded,
		PatchAssessmentStateFailed,
		PatchAssessmentStateInstalled,
		PatchAssessmentStateNotSelected,
		PatchAssessmentStatePending,
	}
}

// PatchOperationStatus - The overall success or failure status of the operation. It remains "InProgress" until the operation
// completes. At that point it will become "Failed", "Succeeded", or "CompletedWithWarnings."
type PatchOperationStatus string

const (
	PatchOperationStatusCompletedWithWarnings PatchOperationStatus = "CompletedWithWarnings"
	PatchOperationStatusFailed                PatchOperationStatus = "Failed"
	PatchOperationStatusInProgress            PatchOperationStatus = "InProgress"
	PatchOperationStatusSucceeded             PatchOperationStatus = "Succeeded"
)

// PossiblePatchOperationStatusValues returns the possible values for the PatchOperationStatus const type.
func PossiblePatchOperationStatusValues() []PatchOperationStatus {
	return []PatchOperationStatus{
		PatchOperationStatusCompletedWithWarnings,
		PatchOperationStatusFailed,
		PatchOperationStatusInProgress,
		PatchOperationStatusSucceeded,
	}
}

// ProtocolTypes - Specifies the protocol of WinRM listener.
// Possible values are:
// http
// https
type ProtocolTypes string

const (
	ProtocolTypesHTTP  ProtocolTypes = "Http"
	ProtocolTypesHTTPS ProtocolTypes = "Https"
)

// PossibleProtocolTypesValues returns the possible values for the ProtocolTypes const type.
func PossibleProtocolTypesValues() []ProtocolTypes {
	return []ProtocolTypes{
		ProtocolTypesHTTP,
		ProtocolTypesHTTPS,
	}
}

// ProximityPlacementGroupType - Specifies the type of the proximity placement group.
// Possible values are:
// Standard : Co-locate resources within an Azure region or Availability Zone.
// Ultra : For future use.
type ProximityPlacementGroupType string

const (
	ProximityPlacementGroupTypeStandard ProximityPlacementGroupType = "Standard"
	ProximityPlacementGroupTypeUltra    ProximityPlacementGroupType = "Ultra"
)

// PossibleProximityPlacementGroupTypeValues returns the possible values for the ProximityPlacementGroupType const type.
func PossibleProximityPlacementGroupTypeValues() []ProximityPlacementGroupType {
	return []ProximityPlacementGroupType{
		ProximityPlacementGroupTypeStandard,
		ProximityPlacementGroupTypeUltra,
	}
}

// RebootStatus - The reboot status of the machine after the patch operation. It will be in "NotNeeded" status if reboot is
// not needed after the patch operation. "Required" will be the status once the patch is applied
// and machine is required to reboot. "Started" will be the reboot status when the machine has started to reboot. "Failed"
// will be the status if the machine is failed to reboot. "Completed" will be the
// status once the machine is rebooted successfully
type RebootStatus string

const (
	RebootStatusCompleted RebootStatus = "Completed"
	RebootStatusFailed    RebootStatus = "Failed"
	RebootStatusNotNeeded RebootStatus = "NotNeeded"
	RebootStatusRequired  RebootStatus = "Required"
	RebootStatusStarted   RebootStatus = "Started"
)

// PossibleRebootStatusValues returns the possible values for the RebootStatus const type.
func PossibleRebootStatusValues() []RebootStatus {
	return []RebootStatus{
		RebootStatusCompleted,
		RebootStatusFailed,
		RebootStatusNotNeeded,
		RebootStatusRequired,
		RebootStatusStarted,
	}
}

// ResourceIdentityType - The type of identity used for the virtual machine. The type 'SystemAssigned, UserAssigned' includes
// both an implicitly created identity and a set of user assigned identities. The type 'None' will
// remove any identities from the virtual machine.
type ResourceIdentityType string

const (
	ResourceIdentityTypeSystemAssigned             ResourceIdentityType = "SystemAssigned"
	ResourceIdentityTypeUserAssigned               ResourceIdentityType = "UserAssigned"
	ResourceIdentityTypeSystemAssignedUserAssigned ResourceIdentityType = "SystemAssigned, UserAssigned"
	ResourceIdentityTypeNone                       ResourceIdentityType = "None"
)

// PossibleResourceIdentityTypeValues returns the possible values for the ResourceIdentityType const type.
func PossibleResourceIdentityTypeValues() []ResourceIdentityType {
	return []ResourceIdentityType{
		ResourceIdentityTypeSystemAssigned,
		ResourceIdentityTypeUserAssigned,
		ResourceIdentityTypeSystemAssignedUserAssigned,
		ResourceIdentityTypeNone,
	}
}

// RollingUpgradeActionType - The last action performed on the rolling upgrade.
type RollingUpgradeActionType string

const (
	RollingUpgradeActionTypeStart  RollingUpgradeActionType = "Start"
	RollingUpgradeActionTypeCancel RollingUpgradeActionType = "Cancel"
)

// PossibleRollingUpgradeActionTypeValues returns the possible values for the RollingUpgradeActionType const type.
func PossibleRollingUpgradeActionTypeValues() []RollingUpgradeActionType {
	return []RollingUpgradeActionType{
		RollingUpgradeActionTypeStart,
		RollingUpgradeActionTypeCancel,
	}
}

// RollingUpgradeStatusCode - Code indicating the current status of the upgrade.
type RollingUpgradeStatusCode string

const (
	RollingUpgradeStatusCodeRollingForward RollingUpgradeStatusCode = "RollingForward"
	RollingUpgradeStatusCodeCancelled      RollingUpgradeStatusCode = "Cancelled"
	RollingUpgradeStatusCodeCompleted      RollingUpgradeStatusCode = "Completed"
	RollingUpgradeStatusCodeFaulted        RollingUpgradeStatusCode = "Faulted"
)

// PossibleRollingUpgradeStatusCodeValues returns the possible values for the RollingUpgradeStatusCode const type.
func PossibleRollingUpgradeStatusCodeValues() []RollingUpgradeStatusCode {
	return []RollingUpgradeStatusCode{
		RollingUpgradeStatusCodeRollingForward,
		RollingUpgradeStatusCodeCancelled,
		RollingUpgradeStatusCodeCompleted,
		RollingUpgradeStatusCodeFaulted,
	}
}

// SettingNames - Specifies the name of the setting to which the content applies. Possible values are: FirstLogonCommands
// and AutoLogon.
type SettingNames string

const (
	SettingNamesAutoLogon          SettingNames = "AutoLogon"
	SettingNamesFirstLogonCommands SettingNames = "FirstLogonCommands"
)

// PossibleSettingNamesValues returns the possible values for the SettingNames const type.
func PossibleSettingNamesValues() []SettingNames {
	return []SettingNames{
		SettingNamesAutoLogon,
		SettingNamesFirstLogonCommands,
	}
}

// SnapshotStorageAccountTypes - The sku name.
type SnapshotStorageAccountTypes string

const (
	// SnapshotStorageAccountTypesPremiumLRS - Premium SSD locally redundant storage
	SnapshotStorageAccountTypesPremiumLRS SnapshotStorageAccountTypes = "Premium_LRS"
	// SnapshotStorageAccountTypesStandardLRS - Standard HDD locally redundant storage
	SnapshotStorageAccountTypesStandardLRS SnapshotStorageAccountTypes = "Standard_LRS"
	// SnapshotStorageAccountTypesStandardZRS - Standard zone redundant storage
	SnapshotStorageAccountTypesStandardZRS SnapshotStorageAccountTypes = "Standard_ZRS"
)

// PossibleSnapshotStorageAccountTypesValues returns the possible values for the SnapshotStorageAccountTypes const type.
func PossibleSnapshotStorageAccountTypesValues() []SnapshotStorageAccountTypes {
	return []SnapshotStorageAccountTypes{
		SnapshotStorageAccountTypesPremiumLRS,
		SnapshotStorageAccountTypesStandardLRS,
		SnapshotStorageAccountTypesStandardZRS,
	}
}

// SoftwareUpdateRebootBehavior - Describes the reboot requirements of the patch.
type SoftwareUpdateRebootBehavior string

const (
	SoftwareUpdateRebootBehaviorAlwaysRequiresReboot SoftwareUpdateRebootBehavior = "AlwaysRequiresReboot"
	SoftwareUpdateRebootBehaviorCanRequestReboot     SoftwareUpdateRebootBehavior = "CanRequestReboot"
	SoftwareUpdateRebootBehaviorNeverReboots         SoftwareUpdateRebootBehavior = "NeverReboots"
)

// PossibleSoftwareUpdateRebootBehaviorValues returns the possible values for the SoftwareUpdateRebootBehavior const type.
func PossibleSoftwareUpdateRebootBehaviorValues() []SoftwareUpdateRebootBehavior {
	return []SoftwareUpdateRebootBehavior{
		SoftwareUpdateRebootBehaviorAlwaysRequiresReboot,
		SoftwareUpdateRebootBehaviorCanRequestReboot,
		SoftwareUpdateRebootBehaviorNeverReboots,
	}
}

// StatusLevelTypes - The level code.
type StatusLevelTypes string

const (
	StatusLevelTypesInfo    StatusLevelTypes = "Info"
	StatusLevelTypesWarning StatusLevelTypes = "Warning"
	StatusLevelTypesError   StatusLevelTypes = "Error"
)

// PossibleStatusLevelTypesValues returns the possible values for the StatusLevelTypes const type.
func PossibleStatusLevelTypesValues() []StatusLevelTypes {
	return []StatusLevelTypes{
		StatusLevelTypesInfo,
		StatusLevelTypesWarning,
		StatusLevelTypesError,
	}
}

// StorageAccountTypes - Specifies the storage account type for the managed disk. NOTE: UltraSSDLRS can only be used with
// data disks. It cannot be used with OS Disk. StandardLRS uses Standard HDD. StandardSSDLRS uses Standard
// SSD. PremiumLRS uses Premium SSD. UltraSSD_LRS uses Ultra disk. For more information regarding disks supported for Windows
// Virtual Machines, refer to
// https://docs.microsoft.com/en-us/azure/virtual-machines/windows/disks-types and, for Linux Virtual Machines, refer to https://docs.microsoft.com/en-us/azure/virtual-machines/linux/disks-types
type StorageAccountTypes string

const (
	StorageAccountTypesPremiumLRS     StorageAccountTypes = "Premium_LRS"
	StorageAccountTypesStandardLRS    StorageAccountTypes = "Standard_LRS"
	StorageAccountTypesStandardSSDLRS StorageAccountTypes = "StandardSSD_LRS"
	StorageAccountTypesUltraSSDLRS    StorageAccountTypes = "UltraSSD_LRS"
)

// PossibleStorageAccountTypesValues returns the possible values for the StorageAccountTypes const type.
func PossibleStorageAccountTypesValues() []StorageAccountTypes {
	return []StorageAccountTypes{
		StorageAccountTypesPremiumLRS,
		StorageAccountTypesStandardLRS,
		StorageAccountTypesStandardSSDLRS,
		StorageAccountTypesUltraSSDLRS,
	}
}

// UpgradeMode - Specifies the mode of an upgrade to virtual machines in the scale set.
// Possible values are:
// Manual - You control the application of updates to virtual machines in the scale set. You do this by using the manualUpgrade
// action.
// Automatic - All virtual machines in the scale set are automatically updated at the same time.
type UpgradeMode string

const (
	UpgradeModeAutomatic UpgradeMode = "Automatic"
	UpgradeModeManual    UpgradeMode = "Manual"
	UpgradeModeRolling   UpgradeMode = "Rolling"
)

// PossibleUpgradeModeValues returns the possible values for the UpgradeMode const type.
func PossibleUpgradeModeValues() []UpgradeMode {
	return []UpgradeMode{
		UpgradeModeAutomatic,
		UpgradeModeManual,
		UpgradeModeRolling,
	}
}

// UpgradeOperationInvoker - Invoker of the Upgrade Operation
type UpgradeOperationInvoker string

const (
	UpgradeOperationInvokerUnknown  UpgradeOperationInvoker = "Unknown"
	UpgradeOperationInvokerUser     UpgradeOperationInvoker = "User"
	UpgradeOperationInvokerPlatform UpgradeOperationInvoker = "Platform"
)

// PossibleUpgradeOperationInvokerValues returns the possible values for the UpgradeOperationInvoker const type.
func PossibleUpgradeOperationInvokerValues() []UpgradeOperationInvoker {
	return []UpgradeOperationInvoker{
		UpgradeOperationInvokerUnknown,
		UpgradeOperationInvokerUser,
		UpgradeOperationInvokerPlatform,
	}
}

// UpgradeState - Code indicating the current status of the upgrade.
type UpgradeState string

const (
	UpgradeStateRollingForward UpgradeState = "RollingForward"
	UpgradeStateCancelled      UpgradeState = "Cancelled"
	UpgradeStateCompleted      UpgradeState = "Completed"
	UpgradeStateFaulted        UpgradeState = "Faulted"
)

// PossibleUpgradeStateValues returns the possible values for the UpgradeState const type.
func PossibleUpgradeStateValues() []UpgradeState {
	return []UpgradeState{
		UpgradeStateRollingForward,
		UpgradeStateCancelled,
		UpgradeStateCompleted,
		UpgradeStateFaulted,
	}
}

// VMDiskTypes - VM disk types which are disallowed.
type VMDiskTypes string

const (
	VMDiskTypesNone      VMDiskTypes = "None"
	VMDiskTypesUnmanaged VMDiskTypes = "Unmanaged"
)

// PossibleVMDiskTypesValues returns the possible values for the VMDiskTypes const type.
func PossibleVMDiskTypesValues() []VMDiskTypes {
	return []VMDiskTypes{
		VMDiskTypesNone,
		VMDiskTypesUnmanaged,
	}
}

// VirtualMachineEvictionPolicyTypes - Specifies the eviction policy for the Azure Spot VM/VMSS
type VirtualMachineEvictionPolicyTypes string

const (
	VirtualMachineEvictionPolicyTypesDeallocate VirtualMachineEvictionPolicyTypes = "Deallocate"
	VirtualMachineEvictionPolicyTypesDelete     VirtualMachineEvictionPolicyTypes = "Delete"
)

// PossibleVirtualMachineEvictionPolicyTypesValues returns the possible values for the VirtualMachineEvictionPolicyTypes const type.
func PossibleVirtualMachineEvictionPolicyTypesValues() []VirtualMachineEvictionPolicyTypes {
	return []VirtualMachineEvictionPolicyTypes{
		VirtualMachineEvictionPolicyTypesDeallocate,
		VirtualMachineEvictionPolicyTypesDelete,
	}
}

// VirtualMachinePriorityTypes - Specifies the priority for a standalone virtual machine or the virtual machines in the scale
// set.
// 'Low' enum will be deprecated in the future, please use 'Spot' as the enum to deploy Azure Spot VM/VMSS.
type VirtualMachinePriorityTypes string

const (
	VirtualMachinePriorityTypesLow     VirtualMachinePriorityTypes = "Low"
	VirtualMachinePriorityTypesRegular VirtualMachinePriorityTypes = "Regular"
	VirtualMachinePriorityTypesSpot    VirtualMachinePriorityTypes = "Spot"
)

// PossibleVirtualMachinePriorityTypesValues returns the possible values for the VirtualMachinePriorityTypes const type.
func PossibleVirtualMachinePriorityTypesValues() []VirtualMachinePriorityTypes {
	return []VirtualMachinePriorityTypes{
		VirtualMachinePriorityTypesLow,
		VirtualMachinePriorityTypesRegular,
		VirtualMachinePriorityTypesSpot,
	}
}

// VirtualMachineScaleSetSKUScaleType - The scale type applicable to the sku.
type VirtualMachineScaleSetSKUScaleType string

const (
	VirtualMachineScaleSetSKUScaleTypeAutomatic VirtualMachineScaleSetSKUScaleType = "Automatic"
	VirtualMachineScaleSetSKUScaleTypeNone      VirtualMachineScaleSetSKUScaleType = "None"
)

// PossibleVirtualMachineScaleSetSKUScaleTypeValues returns the possible values for the VirtualMachineScaleSetSKUScaleType const type.
func PossibleVirtualMachineScaleSetSKUScaleTypeValues() []VirtualMachineScaleSetSKUScaleType {
	return []VirtualMachineScaleSetSKUScaleType{
		VirtualMachineScaleSetSKUScaleTypeAutomatic,
		VirtualMachineScaleSetSKUScaleTypeNone,
	}
}

type VirtualMachineScaleSetScaleInRules string

const (
	VirtualMachineScaleSetScaleInRulesDefault  VirtualMachineScaleSetScaleInRules = "Default"
	VirtualMachineScaleSetScaleInRulesNewestVM VirtualMachineScaleSetScaleInRules = "NewestVM"
	VirtualMachineScaleSetScaleInRulesOldestVM VirtualMachineScaleSetScaleInRules = "OldestVM"
)

// PossibleVirtualMachineScaleSetScaleInRulesValues returns the possible values for the VirtualMachineScaleSetScaleInRules const type.
func PossibleVirtualMachineScaleSetScaleInRulesValues() []VirtualMachineScaleSetScaleInRules {
	return []VirtualMachineScaleSetScaleInRules{
		VirtualMachineScaleSetScaleInRulesDefault,
		VirtualMachineScaleSetScaleInRulesNewestVM,
		VirtualMachineScaleSetScaleInRulesOldestVM,
	}
}

// VirtualMachineSizeTypes - Specifies the size of the virtual machine. For more information about virtual machine sizes,
// see Sizes for virtual machines [https://docs.microsoft.com/en-us/azure/virtual-machines/sizes].
// The available VM sizes depend on region and availability set. For a list of available sizes use these APIs:
// List all available virtual machine sizes in an availability set [https://docs.microsoft.com/rest/api/compute/availabilitysets/listavailablesizes]
// List all available virtual machine sizes in a region [https://docs.microsoft.com/en-us/rest/api/compute/resourceskus/list]
// List all available virtual machine sizes for resizing [https://docs.microsoft.com/rest/api/compute/virtualmachines/listavailablesizes].
// This list of sizes is no longer updated and the VirtualMachineSizeTypes string constants will be removed from the subsequent
// REST API specification. Use List all available virtual machine sizes in a
// region [https://docs.microsoft.com/en-us/rest/api/compute/resourceskus/list] to get the latest sizes.
type VirtualMachineSizeTypes string

const (
	VirtualMachineSizeTypesBasicA0          VirtualMachineSizeTypes = "Basic_A0"
	VirtualMachineSizeTypesBasicA1          VirtualMachineSizeTypes = "Basic_A1"
	VirtualMachineSizeTypesBasicA2          VirtualMachineSizeTypes = "Basic_A2"
	VirtualMachineSizeTypesBasicA3          VirtualMachineSizeTypes = "Basic_A3"
	VirtualMachineSizeTypesBasicA4          VirtualMachineSizeTypes = "Basic_A4"
	VirtualMachineSizeTypesStandardA0       VirtualMachineSizeTypes = "Standard_A0"
	VirtualMachineSizeTypesStandardA1       VirtualMachineSizeTypes = "Standard_A1"
	VirtualMachineSizeTypesStandardA10      VirtualMachineSizeTypes = "Standard_A10"
	VirtualMachineSizeTypesStandardA11      VirtualMachineSizeTypes = "Standard_A11"
	VirtualMachineSizeTypesStandardA1V2     VirtualMachineSizeTypes = "Standard_A1_v2"
	VirtualMachineSizeTypesStandardA2       VirtualMachineSizeTypes = "Standard_A2"
	VirtualMachineSizeTypesStandardA2MV2    VirtualMachineSizeTypes = "Standard_A2m_v2"
	VirtualMachineSizeTypesStandardA2V2     VirtualMachineSizeTypes = "Standard_A2_v2"
	VirtualMachineSizeTypesStandardA3       VirtualMachineSizeTypes = "Standard_A3"
	VirtualMachineSizeTypesStandardA4       VirtualMachineSizeTypes = "Standard_A4"
	VirtualMachineSizeTypesStandardA4MV2    VirtualMachineSizeTypes = "Standard_A4m_v2"
	VirtualMachineSizeTypesStandardA4V2     VirtualMachineSizeTypes = "Standard_A4_v2"
	VirtualMachineSizeTypesStandardA5       VirtualMachineSizeTypes = "Standard_A5"
	VirtualMachineSizeTypesStandardA6       VirtualMachineSizeTypes = "Standard_A6"
	VirtualMachineSizeTypesStandardA7       VirtualMachineSizeTypes = "Standard_A7"
	VirtualMachineSizeTypesStandardA8       VirtualMachineSizeTypes = "Standard_A8"
	VirtualMachineSizeTypesStandardA8MV2    VirtualMachineSizeTypes = "Standard_A8m_v2"
	VirtualMachineSizeTypesStandardA8V2     VirtualMachineSizeTypes = "Standard_A8_v2"
	VirtualMachineSizeTypesStandardA9       VirtualMachineSizeTypes = "Standard_A9"
	VirtualMachineSizeTypesStandardB1Ms     VirtualMachineSizeTypes = "Standard_B1ms"
	VirtualMachineSizeTypesStandardB1S      VirtualMachineSizeTypes = "Standard_B1s"
	VirtualMachineSizeTypesStandardB2Ms     VirtualMachineSizeTypes = "Standard_B2ms"
	VirtualMachineSizeTypesStandardB2S      VirtualMachineSizeTypes = "Standard_B2s"
	VirtualMachineSizeTypesStandardB4Ms     VirtualMachineSizeTypes = "Standard_B4ms"
	VirtualMachineSizeTypesStandardB8Ms     VirtualMachineSizeTypes = "Standard_B8ms"
	VirtualMachineSizeTypesStandardD1       VirtualMachineSizeTypes = "Standard_D1"
	VirtualMachineSizeTypesStandardD11      VirtualMachineSizeTypes = "Standard_D11"
	VirtualMachineSizeTypesStandardD11V2    VirtualMachineSizeTypes = "Standard_D11_v2"
	VirtualMachineSizeTypesStandardD12      VirtualMachineSizeTypes = "Standard_D12"
	VirtualMachineSizeTypesStandardD12V2    VirtualMachineSizeTypes = "Standard_D12_v2"
	VirtualMachineSizeTypesStandardD13      VirtualMachineSizeTypes = "Standard_D13"
	VirtualMachineSizeTypesStandardD13V2    VirtualMachineSizeTypes = "Standard_D13_v2"
	VirtualMachineSizeTypesStandardD14      VirtualMachineSizeTypes = "Standard_D14"
	VirtualMachineSizeTypesStandardD14V2    VirtualMachineSizeTypes = "Standard_D14_v2"
	VirtualMachineSizeTypesStandardD15V2    VirtualMachineSizeTypes = "Standard_D15_v2"
	VirtualMachineSizeTypesStandardD16SV3   VirtualMachineSizeTypes = "Standard_D16s_v3"
	VirtualMachineSizeTypesStandardD16V3    VirtualMachineSizeTypes = "Standard_D16_v3"
	VirtualMachineSizeTypesStandardD1V2     VirtualMachineSizeTypes = "Standard_D1_v2"
	VirtualMachineSizeTypesStandardD2       VirtualMachineSizeTypes = "Standard_D2"
	VirtualMachineSizeTypesStandardD2SV3    VirtualMachineSizeTypes = "Standard_D2s_v3"
	VirtualMachineSizeTypesStandardD2V2     VirtualMachineSizeTypes = "Standard_D2_v2"
	VirtualMachineSizeTypesStandardD2V3     VirtualMachineSizeTypes = "Standard_D2_v3"
	VirtualMachineSizeTypesStandardD3       VirtualMachineSizeTypes = "Standard_D3"
	VirtualMachineSizeTypesStandardD32SV3   VirtualMachineSizeTypes = "Standard_D32s_v3"
	VirtualMachineSizeTypesStandardD32V3    VirtualMachineSizeTypes = "Standard_D32_v3"
	VirtualMachineSizeTypesStandardD3V2     VirtualMachineSizeTypes = "Standard_D3_v2"
	VirtualMachineSizeTypesStandardD4       VirtualMachineSizeTypes = "Standard_D4"
	VirtualMachineSizeTypesStandardD4SV3    VirtualMachineSizeTypes = "Standard_D4s_v3"
	VirtualMachineSizeTypesStandardD4V2     VirtualMachineSizeTypes = "Standard_D4_v2"
	VirtualMachineSizeTypesStandardD4V3     VirtualMachineSizeTypes = "Standard_D4_v3"
	VirtualMachineSizeTypesStandardD5V2     VirtualMachineSizeTypes = "Standard_D5_v2"
	VirtualMachineSizeTypesStandardD64SV3   VirtualMachineSizeTypes = "Standard_D64s_v3"
	VirtualMachineSizeTypesStandardD64V3    VirtualMachineSizeTypes = "Standard_D64_v3"
	VirtualMachineSizeTypesStandardD8SV3    VirtualMachineSizeTypes = "Standard_D8s_v3"
	VirtualMachineSizeTypesStandardD8V3     VirtualMachineSizeTypes = "Standard_D8_v3"
	VirtualMachineSizeTypesStandardDS1      VirtualMachineSizeTypes = "Standard_DS1"
	VirtualMachineSizeTypesStandardDS11     VirtualMachineSizeTypes = "Standard_DS11"
	VirtualMachineSizeTypesStandardDS11V2   VirtualMachineSizeTypes = "Standard_DS11_v2"
	VirtualMachineSizeTypesStandardDS12     VirtualMachineSizeTypes = "Standard_DS12"
	VirtualMachineSizeTypesStandardDS12V2   VirtualMachineSizeTypes = "Standard_DS12_v2"
	VirtualMachineSizeTypesStandardDS13     VirtualMachineSizeTypes = "Standard_DS13"
	VirtualMachineSizeTypesStandardDS132V2  VirtualMachineSizeTypes = "Standard_DS13-2_v2"
	VirtualMachineSizeTypesStandardDS134V2  VirtualMachineSizeTypes = "Standard_DS13-4_v2"
	VirtualMachineSizeTypesStandardDS13V2   VirtualMachineSizeTypes = "Standard_DS13_v2"
	VirtualMachineSizeTypesStandardDS14     VirtualMachineSizeTypes = "Standard_DS14"
	VirtualMachineSizeTypesStandardDS144V2  VirtualMachineSizeTypes = "Standard_DS14-4_v2"
	VirtualMachineSizeTypesStandardDS148V2  VirtualMachineSizeTypes = "Standard_DS14-8_v2"
	VirtualMachineSizeTypesStandardDS14V2   VirtualMachineSizeTypes = "Standard_DS14_v2"
	VirtualMachineSizeTypesStandardDS15V2   VirtualMachineSizeTypes = "Standard_DS15_v2"
	VirtualMachineSizeTypesStandardDS1V2    VirtualMachineSizeTypes = "Standard_DS1_v2"
	VirtualMachineSizeTypesStandardDS2      VirtualMachineSizeTypes = "Standard_DS2"
	VirtualMachineSizeTypesStandardDS2V2    VirtualMachineSizeTypes = "Standard_DS2_v2"
	VirtualMachineSizeTypesStandardDS3      VirtualMachineSizeTypes = "Standard_DS3"
	VirtualMachineSizeTypesStandardDS3V2    VirtualMachineSizeTypes = "Standard_DS3_v2"
	VirtualMachineSizeTypesStandardDS4      VirtualMachineSizeTypes = "Standard_DS4"
	VirtualMachineSizeTypesStandardDS4V2    VirtualMachineSizeTypes = "Standard_DS4_v2"
	VirtualMachineSizeTypesStandardDS5V2    VirtualMachineSizeTypes = "Standard_DS5_v2"
	VirtualMachineSizeTypesStandardE16SV3   VirtualMachineSizeTypes = "Standard_E16s_v3"
	VirtualMachineSizeTypesStandardE16V3    VirtualMachineSizeTypes = "Standard_E16_v3"
	VirtualMachineSizeTypesStandardE2SV3    VirtualMachineSizeTypes = "Standard_E2s_v3"
	VirtualMachineSizeTypesStandardE2V3     VirtualMachineSizeTypes = "Standard_E2_v3"
	VirtualMachineSizeTypesStandardE3216V3  VirtualMachineSizeTypes = "Standard_E32-16_v3"
	VirtualMachineSizeTypesStandardE328SV3  VirtualMachineSizeTypes = "Standard_E32-8s_v3"
	VirtualMachineSizeTypesStandardE32SV3   VirtualMachineSizeTypes = "Standard_E32s_v3"
	VirtualMachineSizeTypesStandardE32V3    VirtualMachineSizeTypes = "Standard_E32_v3"
	VirtualMachineSizeTypesStandardE4SV3    VirtualMachineSizeTypes = "Standard_E4s_v3"
	VirtualMachineSizeTypesStandardE4V3     VirtualMachineSizeTypes = "Standard_E4_v3"
	VirtualMachineSizeTypesStandardE6416SV3 VirtualMachineSizeTypes = "Standard_E64-16s_v3"
	VirtualMachineSizeTypesStandardE6432SV3 VirtualMachineSizeTypes = "Standard_E64-32s_v3"
	VirtualMachineSizeTypesStandardE64SV3   VirtualMachineSizeTypes = "Standard_E64s_v3"
	VirtualMachineSizeTypesStandardE64V3    VirtualMachineSizeTypes = "Standard_E64_v3"
	VirtualMachineSizeTypesStandardE8SV3    VirtualMachineSizeTypes = "Standard_E8s_v3"
	VirtualMachineSizeTypesStandardE8V3     VirtualMachineSizeTypes = "Standard_E8_v3"
	VirtualMachineSizeTypesStandardF1       VirtualMachineSizeTypes = "Standard_F1"
	VirtualMachineSizeTypesStandardF16      VirtualMachineSizeTypes = "Standard_F16"
	VirtualMachineSizeTypesStandardF16S     VirtualMachineSizeTypes = "Standard_F16s"
	VirtualMachineSizeTypesStandardF16SV2   VirtualMachineSizeTypes = "Standard_F16s_v2"
	VirtualMachineSizeTypesStandardF1S      VirtualMachineSizeTypes = "Standard_F1s"
	VirtualMachineSizeTypesStandardF2       VirtualMachineSizeTypes = "Standard_F2"
	VirtualMachineSizeTypesStandardF2S      VirtualMachineSizeTypes = "Standard_F2s"
	VirtualMachineSizeTypesStandardF2SV2    VirtualMachineSizeTypes = "Standard_F2s_v2"
	VirtualMachineSizeTypesStandardF32SV2   VirtualMachineSizeTypes = "Standard_F32s_v2"
	VirtualMachineSizeTypesStandardF4       VirtualMachineSizeTypes = "Standard_F4"
	VirtualMachineSizeTypesStandardF4S      VirtualMachineSizeTypes = "Standard_F4s"
	VirtualMachineSizeTypesStandardF4SV2    VirtualMachineSizeTypes = "Standard_F4s_v2"
	VirtualMachineSizeTypesStandardF64SV2   VirtualMachineSizeTypes = "Standard_F64s_v2"
	VirtualMachineSizeTypesStandardF72SV2   VirtualMachineSizeTypes = "Standard_F72s_v2"
	VirtualMachineSizeTypesStandardF8       VirtualMachineSizeTypes = "Standard_F8"
	VirtualMachineSizeTypesStandardF8S      VirtualMachineSizeTypes = "Standard_F8s"
	VirtualMachineSizeTypesStandardF8SV2    VirtualMachineSizeTypes = "Standard_F8s_v2"
	VirtualMachineSizeTypesStandardG1       VirtualMachineSizeTypes = "Standard_G1"
	VirtualMachineSizeTypesStandardG2       VirtualMachineSizeTypes = "Standard_G2"
	VirtualMachineSizeTypesStandardG3       VirtualMachineSizeTypes = "Standard_G3"
	VirtualMachineSizeTypesStandardG4       VirtualMachineSizeTypes = "Standard_G4"
	VirtualMachineSizeTypesStandardG5       VirtualMachineSizeTypes = "Standard_G5"
	VirtualMachineSizeTypesStandardGS1      VirtualMachineSizeTypes = "Standard_GS1"
	VirtualMachineSizeTypesStandardGS2      VirtualMachineSizeTypes = "Standard_GS2"
	VirtualMachineSizeTypesStandardGS3      VirtualMachineSizeTypes = "Standard_GS3"
	VirtualMachineSizeTypesStandardGS4      VirtualMachineSizeTypes = "Standard_GS4"
	VirtualMachineSizeTypesStandardGS44     VirtualMachineSizeTypes = "Standard_GS4-4"
	VirtualMachineSizeTypesStandardGS48     VirtualMachineSizeTypes = "Standard_GS4-8"
	VirtualMachineSizeTypesStandardGS5      VirtualMachineSizeTypes = "Standard_GS5"
	VirtualMachineSizeTypesStandardGS516    VirtualMachineSizeTypes = "Standard_GS5-16"
	VirtualMachineSizeTypesStandardGS58     VirtualMachineSizeTypes = "Standard_GS5-8"
	VirtualMachineSizeTypesStandardH16      VirtualMachineSizeTypes = "Standard_H16"
	VirtualMachineSizeTypesStandardH16M     VirtualMachineSizeTypes = "Standard_H16m"
	VirtualMachineSizeTypesStandardH16Mr    VirtualMachineSizeTypes = "Standard_H16mr"
	VirtualMachineSizeTypesStandardH16R     VirtualMachineSizeTypes = "Standard_H16r"
	VirtualMachineSizeTypesStandardH8       VirtualMachineSizeTypes = "Standard_H8"
	VirtualMachineSizeTypesStandardH8M      VirtualMachineSizeTypes = "Standard_H8m"
	VirtualMachineSizeTypesStandardL16S     VirtualMachineSizeTypes = "Standard_L16s"
	VirtualMachineSizeTypesStandardL32S     VirtualMachineSizeTypes = "Standard_L32s"
	VirtualMachineSizeTypesStandardL4S      VirtualMachineSizeTypes = "Standard_L4s"
	VirtualMachineSizeTypesStandardL8S      VirtualMachineSizeTypes = "Standard_L8s"
	VirtualMachineSizeTypesStandardM12832Ms VirtualMachineSizeTypes = "Standard_M128-32ms"
	VirtualMachineSizeTypesStandardM12864Ms VirtualMachineSizeTypes = "Standard_M128-64ms"
	VirtualMachineSizeTypesStandardM128Ms   VirtualMachineSizeTypes = "Standard_M128ms"
	VirtualMachineSizeTypesStandardM128S    VirtualMachineSizeTypes = "Standard_M128s"
	VirtualMachineSizeTypesStandardM6416Ms  VirtualMachineSizeTypes = "Standard_M64-16ms"
	VirtualMachineSizeTypesStandardM6432Ms  VirtualMachineSizeTypes = "Standard_M64-32ms"
	VirtualMachineSizeTypesStandardM64Ms    VirtualMachineSizeTypes = "Standard_M64ms"
	VirtualMachineSizeTypesStandardM64S     VirtualMachineSizeTypes = "Standard_M64s"
	VirtualMachineSizeTypesStandardNC12     VirtualMachineSizeTypes = "Standard_NC12"
	VirtualMachineSizeTypesStandardNC12SV2  VirtualMachineSizeTypes = "Standard_NC12s_v2"
	VirtualMachineSizeTypesStandardNC12SV3  VirtualMachineSizeTypes = "Standard_NC12s_v3"
	VirtualMachineSizeTypesStandardNC24     VirtualMachineSizeTypes = "Standard_NC24"
	VirtualMachineSizeTypesStandardNC24R    VirtualMachineSizeTypes = "Standard_NC24r"
	VirtualMachineSizeTypesStandardNC24RsV2 VirtualMachineSizeTypes = "Standard_NC24rs_v2"
	VirtualMachineSizeTypesStandardNC24RsV3 VirtualMachineSizeTypes = "Standard_NC24rs_v3"
	VirtualMachineSizeTypesStandardNC24SV2  VirtualMachineSizeTypes = "Standard_NC24s_v2"
	VirtualMachineSizeTypesStandardNC24SV3  VirtualMachineSizeTypes = "Standard_NC24s_v3"
	VirtualMachineSizeTypesStandardNC6      VirtualMachineSizeTypes = "Standard_NC6"
	VirtualMachineSizeTypesStandardNC6SV2   VirtualMachineSizeTypes = "Standard_NC6s_v2"
	VirtualMachineSizeTypesStandardNC6SV3   VirtualMachineSizeTypes = "Standard_NC6s_v3"
	VirtualMachineSizeTypesStandardND12S    VirtualMachineSizeTypes = "Standard_ND12s"
	VirtualMachineSizeTypesStandardND24Rs   VirtualMachineSizeTypes = "Standard_ND24rs"
	VirtualMachineSizeTypesStandardND24S    VirtualMachineSizeTypes = "Standard_ND24s"
	VirtualMachineSizeTypesStandardND6S     VirtualMachineSizeTypes = "Standard_ND6s"
	VirtualMachineSizeTypesStandardNV12     VirtualMachineSizeTypes = "Standard_NV12"
	VirtualMachineSizeTypesStandardNV24     VirtualMachineSizeTypes = "Standard_NV24"
	VirtualMachineSizeTypesStandardNV6      VirtualMachineSizeTypes = "Standard_NV6"
)

// PossibleVirtualMachineSizeTypesValues returns the possible values for the VirtualMachineSizeTypes const type.
func PossibleVirtualMachineSizeTypesValues() []VirtualMachineSizeTypes {
	return []VirtualMachineSizeTypes{
		VirtualMachineSizeTypesBasicA0,
		VirtualMachineSizeTypesBasicA1,
		VirtualMachineSizeTypesBasicA2,
		VirtualMachineSizeTypesBasicA3,
		VirtualMachineSizeTypesBasicA4,
		VirtualMachineSizeTypesStandardA0,
		VirtualMachineSizeTypesStandardA1,
		VirtualMachineSizeTypesStandardA10,
		VirtualMachineSizeTypesStandardA11,
		VirtualMachineSizeTypesStandardA1V2,
		VirtualMachineSizeTypesStandardA2,
		VirtualMachineSizeTypesStandardA2MV2,
		VirtualMachineSizeTypesStandardA2V2,
		VirtualMachineSizeTypesStandardA3,
		VirtualMachineSizeTypesStandardA4,
		VirtualMachineSizeTypesStandardA4MV2,
		VirtualMachineSizeTypesStandardA4V2,
		VirtualMachineSizeTypesStandardA5,
		VirtualMachineSizeTypesStandardA6,
		VirtualMachineSizeTypesStandardA7,
		VirtualMachineSizeTypesStandardA8,
		VirtualMachineSizeTypesStandardA8MV2,
		VirtualMachineSizeTypesStandardA8V2,
		VirtualMachineSizeTypesStandardA9,
		VirtualMachineSizeTypesStandardB1Ms,
		VirtualMachineSizeTypesStandardB1S,
		VirtualMachineSizeTypesStandardB2Ms,
		VirtualMachineSizeTypesStandardB2S,
		VirtualMachineSizeTypesStandardB4Ms,
		VirtualMachineSizeTypesStandardB8Ms,
		VirtualMachineSizeTypesStandardD1,
		VirtualMachineSizeTypesStandardD11,
		VirtualMachineSizeTypesStandardD11V2,
		VirtualMachineSizeTypesStandardD12,
		VirtualMachineSizeTypesStandardD12V2,
		VirtualMachineSizeTypesStandardD13,
		VirtualMachineSizeTypesStandardD13V2,
		VirtualMachineSizeTypesStandardD14,
		VirtualMachineSizeTypesStandardD14V2,
		VirtualMachineSizeTypesStandardD15V2,
		VirtualMachineSizeTypesStandardD16SV3,
		VirtualMachineSizeTypesStandardD16V3,
		VirtualMachineSizeTypesStandardD1V2,
		VirtualMachineSizeTypesStandardD2,
		VirtualMachineSizeTypesStandardD2SV3,
		VirtualMachineSizeTypesStandardD2V2,
		VirtualMachineSizeTypesStandardD2V3,
		VirtualMachineSizeTypesStandardD3,
		VirtualMachineSizeTypesStandardD32SV3,
		VirtualMachineSizeTypesStandardD32V3,
		VirtualMachineSizeTypesStandardD3V2,
		VirtualMachineSizeTypesStandardD4,
		VirtualMachineSizeTypesStandardD4SV3,
		VirtualMachineSizeTypesStandardD4V2,
		VirtualMachineSizeTypesStandardD4V3,
		VirtualMachineSizeTypesStandardD5V2,
		VirtualMachineSizeTypesStandardD64SV3,
		VirtualMachineSizeTypesStandardD64V3,
		VirtualMachineSizeTypesStandardD8SV3,
		VirtualMachineSizeTypesStandardD8V3,
		VirtualMachineSizeTypesStandardDS1,
		VirtualMachineSizeTypesStandardDS11,
		VirtualMachineSizeTypesStandardDS11V2,
		VirtualMachineSizeTypesStandardDS12,
		VirtualMachineSizeTypesStandardDS12V2,
		VirtualMachineSizeTypesStandardDS13,
		VirtualMachineSizeTypesStandardDS132V2,
		VirtualMachineSizeTypesStandardDS134V2,
		VirtualMachineSizeTypesStandardDS13V2,
		VirtualMachineSizeTypesStandardDS14,
		VirtualMachineSizeTypesStandardDS144V2,
		VirtualMachineSizeTypesStandardDS148V2,
		VirtualMachineSizeTypesStandardDS14V2,
		VirtualMachineSizeTypesStandardDS15V2,
		VirtualMachineSizeTypesStandardDS1V2,
		VirtualMachineSizeTypesStandardDS2,
		VirtualMachineSizeTypesStandardDS2V2,
		VirtualMachineSizeTypesStandardDS3,
		VirtualMachineSizeTypesStandardDS3V2,
		VirtualMachineSizeTypesStandardDS4,
		VirtualMachineSizeTypesStandardDS4V2,
		VirtualMachineSizeTypesStandardDS5V2,
		VirtualMachineSizeTypesStandardE16SV3,
		VirtualMachineSizeTypesStandardE16V3,
		VirtualMachineSizeTypesStandardE2SV3,
		VirtualMachineSizeTypesStandardE2V3,
		VirtualMachineSizeTypesStandardE3216V3,
		VirtualMachineSizeTypesStandardE328SV3,
		VirtualMachineSizeTypesStandardE32SV3,
		VirtualMachineSizeTypesStandardE32V3,
		VirtualMachineSizeTypesStandardE4SV3,
		VirtualMachineSizeTypesStandardE4V3,
		VirtualMachineSizeTypesStandardE6416SV3,
		VirtualMachineSizeTypesStandardE6432SV3,
		VirtualMachineSizeTypesStandardE64SV3,
		VirtualMachineSizeTypesStandardE64V3,
		VirtualMachineSizeTypesStandardE8SV3,
		VirtualMachineSizeTypesStandardE8V3,
		VirtualMachineSizeTypesStandardF1,
		VirtualMachineSizeTypesStandardF16,
		VirtualMachineSizeTypesStandardF16S,
		VirtualMachineSizeTypesStandardF16SV2,
		VirtualMachineSizeTypesStandardF1S,
		VirtualMachineSizeTypesStandardF2,
		VirtualMachineSizeTypesStandardF2S,
		VirtualMachineSizeTypesStandardF2SV2,
		VirtualMachineSizeTypesStandardF32SV2,
		VirtualMachineSizeTypesStandardF4,
		VirtualMachineSizeTypesStandardF4S,
		VirtualMachineSizeTypesStandardF4SV2,
		VirtualMachineSizeTypesStandardF64SV2,
		VirtualMachineSizeTypesStandardF72SV2,
		VirtualMachineSizeTypesStandardF8,
		VirtualMachineSizeTypesStandardF8S,
		VirtualMachineSizeTypesStandardF8SV2,
		VirtualMachineSizeTypesStandardG1,
		VirtualMachineSizeTypesStandardG2,
		VirtualMachineSizeTypesStandardG3,
		VirtualMachineSizeTypesStandardG4,
		VirtualMachineSizeTypesStandardG5,
		VirtualMachineSizeTypesStandardGS1,
		VirtualMachineSizeTypesStandardGS2,
		VirtualMachineSizeTypesStandardGS3,
		VirtualMachineSizeTypesStandardGS4,
		VirtualMachineSizeTypesStandardGS44,
		VirtualMachineSizeTypesStandardGS48,
		VirtualMachineSizeTypesStandardGS5,
		VirtualMachineSizeTypesStandardGS516,
		VirtualMachineSizeTypesStandardGS58,
		VirtualMachineSizeTypesStandardH16,
		VirtualMachineSizeTypesStandardH16M,
		VirtualMachineSizeTypesStandardH16Mr,
		VirtualMachineSizeTypesStandardH16R,
		VirtualMachineSizeTypesStandardH8,
		VirtualMachineSizeTypesStandardH8M,
		VirtualMachineSizeTypesStandardL16S,
		VirtualMachineSizeTypesStandardL32S,
		VirtualMachineSizeTypesStandardL4S,
		VirtualMachineSizeTypesStandardL8S,
		VirtualMachineSizeTypesStandardM12832Ms,
		VirtualMachineSizeTypesStandardM12864Ms,
		VirtualMachineSizeTypesStandardM128Ms,
		VirtualMachineSizeTypesStandardM128S,
		VirtualMachineSizeTypesStandardM6416Ms,
		VirtualMachineSizeTypesStandardM6432Ms,
		VirtualMachineSizeTypesStandardM64Ms,
		VirtualMachineSizeTypesStandardM64S,
		VirtualMachineSizeTypesStandardNC12,
		VirtualMachineSizeTypesStandardNC12SV2,
		VirtualMachineSizeTypesStandardNC12SV3,
		VirtualMachineSizeTypesStandardNC24,
		VirtualMachineSizeTypesStandardNC24R,
		VirtualMachineSizeTypesStandardNC24RsV2,
		VirtualMachineSizeTypesStandardNC24RsV3,
		VirtualMachineSizeTypesStandardNC24SV2,
		VirtualMachineSizeTypesStandardNC24SV3,
		VirtualMachineSizeTypesStandardNC6,
		VirtualMachineSizeTypesStandardNC6SV2,
		VirtualMachineSizeTypesStandardNC6SV3,
		VirtualMachineSizeTypesStandardND12S,
		VirtualMachineSizeTypesStandardND24Rs,
		VirtualMachineSizeTypesStandardND24S,
		VirtualMachineSizeTypesStandardND6S,
		VirtualMachineSizeTypesStandardNV12,
		VirtualMachineSizeTypesStandardNV24,
		VirtualMachineSizeTypesStandardNV6,
	}
}
