// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package kinesis

import (
	"bytes"
	"fmt"
	"io"
	"sync"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awserr"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/client"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/eventstream"
	"github.com/aws/aws-sdk-go/private/protocol/eventstream/eventstreamapi"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
	"github.com/aws/aws-sdk-go/private/protocol/rest"
)

const opAddTagsToStream = "AddTagsToStream"

// AddTagsToStreamRequest generates a "aws/request.Request" representing the
// client's request for the AddTagsToStream operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AddTagsToStream for more information on using the AddTagsToStream
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AddTagsToStreamRequest method.
//	req, resp := client.AddTagsToStreamRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/AddTagsToStream
func (c *Kinesis) AddTagsToStreamRequest(input *AddTagsToStreamInput) (req *request.Request, output *AddTagsToStreamOutput) {
	op := &request.Operation{
		Name:       opAddTagsToStream,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddTagsToStreamInput{}
	}

	output = &AddTagsToStreamOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AddTagsToStream API operation for Amazon Kinesis.
//
// Adds or updates tags for the specified Kinesis data stream. You can assign
// up to 50 tags to a data stream.
//
// When invoking this API, you must use either the StreamARN or the StreamName
// parameter, or both. It is recommended that you use the StreamARN input parameter
// when you invoke this API.
//
// If tags have already been assigned to the stream, AddTagsToStream overwrites
// any existing tags that correspond to the specified tag keys.
//
// AddTagsToStream has a limit of five transactions per second per account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis's
// API operation AddTagsToStream for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The requested resource could not be found. The stream might not be specified
//     correctly.
//
//   - ResourceInUseException
//     The resource is not available for this operation. For successful operation,
//     the resource must be in the ACTIVE state.
//
//   - InvalidArgumentException
//     A specified parameter exceeds its restrictions, is not supported, or can't
//     be used. For more information, see the returned message.
//
//   - LimitExceededException
//     The requested resource exceeds the maximum number allowed, or the number
//     of concurrent stream requests exceeds the maximum number allowed.
//
//   - AccessDeniedException
//     Specifies that you do not have the permissions required to perform this operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/AddTagsToStream
func (c *Kinesis) AddTagsToStream(input *AddTagsToStreamInput) (*AddTagsToStreamOutput, error) {
	req, out := c.AddTagsToStreamRequest(input)
	return out, req.Send()
}

// AddTagsToStreamWithContext is the same as AddTagsToStream with the addition of
// the ability to pass a context and additional request options.
//
// See AddTagsToStream for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kinesis) AddTagsToStreamWithContext(ctx aws.Context, input *AddTagsToStreamInput, opts ...request.Option) (*AddTagsToStreamOutput, error) {
	req, out := c.AddTagsToStreamRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateStream = "CreateStream"

// CreateStreamRequest generates a "aws/request.Request" representing the
// client's request for the CreateStream operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateStream for more information on using the CreateStream
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateStreamRequest method.
//	req, resp := client.CreateStreamRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/CreateStream
func (c *Kinesis) CreateStreamRequest(input *CreateStreamInput) (req *request.Request, output *CreateStreamOutput) {
	op := &request.Operation{
		Name:       opCreateStream,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateStreamInput{}
	}

	output = &CreateStreamOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateStream API operation for Amazon Kinesis.
//
// Creates a Kinesis data stream. A stream captures and transports data records
// that are continuously emitted from different data sources or producers. Scale-out
// within a stream is explicitly supported by means of shards, which are uniquely
// identified groups of data records in a stream.
//
// You can create your data stream using either on-demand or provisioned capacity
// mode. Data streams with an on-demand mode require no capacity planning and
// automatically scale to handle gigabytes of write and read throughput per
// minute. With the on-demand mode, Kinesis Data Streams automatically manages
// the shards in order to provide the necessary throughput. For the data streams
// with a provisioned mode, you must specify the number of shards for the data
// stream. Each shard can support reads up to five transactions per second,
// up to a maximum data read total of 2 MiB per second. Each shard can support
// writes up to 1,000 records per second, up to a maximum data write total of
// 1 MiB per second. If the amount of data input increases or decreases, you
// can add or remove shards.
//
// The stream name identifies the stream. The name is scoped to the Amazon Web
// Services account used by the application. It is also scoped by Amazon Web
// Services Region. That is, two streams in two different accounts can have
// the same name, and two streams in the same account, but in two different
// Regions, can have the same name.
//
// CreateStream is an asynchronous operation. Upon receiving a CreateStream
// request, Kinesis Data Streams immediately returns and sets the stream status
// to CREATING. After the stream is created, Kinesis Data Streams sets the stream
// status to ACTIVE. You should perform read and write operations only on an
// ACTIVE stream.
//
// You receive a LimitExceededException when making a CreateStream request when
// you try to do one of the following:
//
//   - Have more than five streams in the CREATING state at any point in time.
//
//   - Create more shards than are authorized for your account.
//
// For the default shard limit for an Amazon Web Services account, see Amazon
// Kinesis Data Streams Limits (https://docs.aws.amazon.com/kinesis/latest/dev/service-sizes-and-limits.html)
// in the Amazon Kinesis Data Streams Developer Guide. To increase this limit,
// contact Amazon Web Services Support (https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html).
//
// You can use DescribeStreamSummary to check the stream status, which is returned
// in StreamStatus.
//
// CreateStream has a limit of five transactions per second per account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis's
// API operation CreateStream for usage and error information.
//
// Returned Error Types:
//
//   - ResourceInUseException
//     The resource is not available for this operation. For successful operation,
//     the resource must be in the ACTIVE state.
//
//   - LimitExceededException
//     The requested resource exceeds the maximum number allowed, or the number
//     of concurrent stream requests exceeds the maximum number allowed.
//
//   - InvalidArgumentException
//     A specified parameter exceeds its restrictions, is not supported, or can't
//     be used. For more information, see the returned message.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/CreateStream
func (c *Kinesis) CreateStream(input *CreateStreamInput) (*CreateStreamOutput, error) {
	req, out := c.CreateStreamRequest(input)
	return out, req.Send()
}

// CreateStreamWithContext is the same as CreateStream with the addition of
// the ability to pass a context and additional request options.
//
// See CreateStream for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kinesis) CreateStreamWithContext(ctx aws.Context, input *CreateStreamInput, opts ...request.Option) (*CreateStreamOutput, error) {
	req, out := c.CreateStreamRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDecreaseStreamRetentionPeriod = "DecreaseStreamRetentionPeriod"

// DecreaseStreamRetentionPeriodRequest generates a "aws/request.Request" representing the
// client's request for the DecreaseStreamRetentionPeriod operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DecreaseStreamRetentionPeriod for more information on using the DecreaseStreamRetentionPeriod
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DecreaseStreamRetentionPeriodRequest method.
//	req, resp := client.DecreaseStreamRetentionPeriodRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/DecreaseStreamRetentionPeriod
func (c *Kinesis) DecreaseStreamRetentionPeriodRequest(input *DecreaseStreamRetentionPeriodInput) (req *request.Request, output *DecreaseStreamRetentionPeriodOutput) {
	op := &request.Operation{
		Name:       opDecreaseStreamRetentionPeriod,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DecreaseStreamRetentionPeriodInput{}
	}

	output = &DecreaseStreamRetentionPeriodOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DecreaseStreamRetentionPeriod API operation for Amazon Kinesis.
//
// Decreases the Kinesis data stream's retention period, which is the length
// of time data records are accessible after they are added to the stream. The
// minimum value of a stream's retention period is 24 hours.
//
// When invoking this API, you must use either the StreamARN or the StreamName
// parameter, or both. It is recommended that you use the StreamARN input parameter
// when you invoke this API.
//
// This operation may result in lost data. For example, if the stream's retention
// period is 48 hours and is decreased to 24 hours, any data already in the
// stream that is older than 24 hours is inaccessible.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis's
// API operation DecreaseStreamRetentionPeriod for usage and error information.
//
// Returned Error Types:
//
//   - ResourceInUseException
//     The resource is not available for this operation. For successful operation,
//     the resource must be in the ACTIVE state.
//
//   - ResourceNotFoundException
//     The requested resource could not be found. The stream might not be specified
//     correctly.
//
//   - LimitExceededException
//     The requested resource exceeds the maximum number allowed, or the number
//     of concurrent stream requests exceeds the maximum number allowed.
//
//   - InvalidArgumentException
//     A specified parameter exceeds its restrictions, is not supported, or can't
//     be used. For more information, see the returned message.
//
//   - AccessDeniedException
//     Specifies that you do not have the permissions required to perform this operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/DecreaseStreamRetentionPeriod
func (c *Kinesis) DecreaseStreamRetentionPeriod(input *DecreaseStreamRetentionPeriodInput) (*DecreaseStreamRetentionPeriodOutput, error) {
	req, out := c.DecreaseStreamRetentionPeriodRequest(input)
	return out, req.Send()
}

// DecreaseStreamRetentionPeriodWithContext is the same as DecreaseStreamRetentionPeriod with the addition of
// the ability to pass a context and additional request options.
//
// See DecreaseStreamRetentionPeriod for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kinesis) DecreaseStreamRetentionPeriodWithContext(ctx aws.Context, input *DecreaseStreamRetentionPeriodInput, opts ...request.Option) (*DecreaseStreamRetentionPeriodOutput, error) {
	req, out := c.DecreaseStreamRetentionPeriodRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteResourcePolicy = "DeleteResourcePolicy"

// DeleteResourcePolicyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteResourcePolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteResourcePolicy for more information on using the DeleteResourcePolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteResourcePolicyRequest method.
//	req, resp := client.DeleteResourcePolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/DeleteResourcePolicy
func (c *Kinesis) DeleteResourcePolicyRequest(input *DeleteResourcePolicyInput) (req *request.Request, output *DeleteResourcePolicyOutput) {
	op := &request.Operation{
		Name:       opDeleteResourcePolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteResourcePolicyInput{}
	}

	output = &DeleteResourcePolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteResourcePolicy API operation for Amazon Kinesis.
//
// Delete a policy for the specified data stream or consumer. Request patterns
// can be one of the following:
//
//   - Data stream pattern: arn:aws.*:kinesis:.*:\d{12}:.*stream/\S+
//
//   - Consumer pattern: ^(arn):aws.*:kinesis:.*:\d{12}:.*stream\/[a-zA-Z0-9_.-]+\/consumer\/[a-zA-Z0-9_.-]+:[0-9]+
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis's
// API operation DeleteResourcePolicy for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     Specifies that you do not have the permissions required to perform this operation.
//
//   - ResourceNotFoundException
//     The requested resource could not be found. The stream might not be specified
//     correctly.
//
//   - LimitExceededException
//     The requested resource exceeds the maximum number allowed, or the number
//     of concurrent stream requests exceeds the maximum number allowed.
//
//   - InvalidArgumentException
//     A specified parameter exceeds its restrictions, is not supported, or can't
//     be used. For more information, see the returned message.
//
//   - ResourceInUseException
//     The resource is not available for this operation. For successful operation,
//     the resource must be in the ACTIVE state.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/DeleteResourcePolicy
func (c *Kinesis) DeleteResourcePolicy(input *DeleteResourcePolicyInput) (*DeleteResourcePolicyOutput, error) {
	req, out := c.DeleteResourcePolicyRequest(input)
	return out, req.Send()
}

// DeleteResourcePolicyWithContext is the same as DeleteResourcePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteResourcePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kinesis) DeleteResourcePolicyWithContext(ctx aws.Context, input *DeleteResourcePolicyInput, opts ...request.Option) (*DeleteResourcePolicyOutput, error) {
	req, out := c.DeleteResourcePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteStream = "DeleteStream"

// DeleteStreamRequest generates a "aws/request.Request" representing the
// client's request for the DeleteStream operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteStream for more information on using the DeleteStream
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteStreamRequest method.
//	req, resp := client.DeleteStreamRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/DeleteStream
func (c *Kinesis) DeleteStreamRequest(input *DeleteStreamInput) (req *request.Request, output *DeleteStreamOutput) {
	op := &request.Operation{
		Name:       opDeleteStream,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteStreamInput{}
	}

	output = &DeleteStreamOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteStream API operation for Amazon Kinesis.
//
// Deletes a Kinesis data stream and all its shards and data. You must shut
// down any applications that are operating on the stream before you delete
// the stream. If an application attempts to operate on a deleted stream, it
// receives the exception ResourceNotFoundException.
//
// When invoking this API, you must use either the StreamARN or the StreamName
// parameter, or both. It is recommended that you use the StreamARN input parameter
// when you invoke this API.
//
// If the stream is in the ACTIVE state, you can delete it. After a DeleteStream
// request, the specified stream is in the DELETING state until Kinesis Data
// Streams completes the deletion.
//
// Note: Kinesis Data Streams might continue to accept data read and write operations,
// such as PutRecord, PutRecords, and GetRecords, on a stream in the DELETING
// state until the stream deletion is complete.
//
// When you delete a stream, any shards in that stream are also deleted, and
// any tags are dissociated from the stream.
//
// You can use the DescribeStreamSummary operation to check the state of the
// stream, which is returned in StreamStatus.
//
// DeleteStream has a limit of five transactions per second per account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis's
// API operation DeleteStream for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The requested resource could not be found. The stream might not be specified
//     correctly.
//
//   - LimitExceededException
//     The requested resource exceeds the maximum number allowed, or the number
//     of concurrent stream requests exceeds the maximum number allowed.
//
//   - ResourceInUseException
//     The resource is not available for this operation. For successful operation,
//     the resource must be in the ACTIVE state.
//
//   - InvalidArgumentException
//     A specified parameter exceeds its restrictions, is not supported, or can't
//     be used. For more information, see the returned message.
//
//   - AccessDeniedException
//     Specifies that you do not have the permissions required to perform this operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/DeleteStream
func (c *Kinesis) DeleteStream(input *DeleteStreamInput) (*DeleteStreamOutput, error) {
	req, out := c.DeleteStreamRequest(input)
	return out, req.Send()
}

// DeleteStreamWithContext is the same as DeleteStream with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteStream for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kinesis) DeleteStreamWithContext(ctx aws.Context, input *DeleteStreamInput, opts ...request.Option) (*DeleteStreamOutput, error) {
	req, out := c.DeleteStreamRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeregisterStreamConsumer = "DeregisterStreamConsumer"

// DeregisterStreamConsumerRequest generates a "aws/request.Request" representing the
// client's request for the DeregisterStreamConsumer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeregisterStreamConsumer for more information on using the DeregisterStreamConsumer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeregisterStreamConsumerRequest method.
//	req, resp := client.DeregisterStreamConsumerRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/DeregisterStreamConsumer
func (c *Kinesis) DeregisterStreamConsumerRequest(input *DeregisterStreamConsumerInput) (req *request.Request, output *DeregisterStreamConsumerOutput) {
	op := &request.Operation{
		Name:       opDeregisterStreamConsumer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeregisterStreamConsumerInput{}
	}

	output = &DeregisterStreamConsumerOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeregisterStreamConsumer API operation for Amazon Kinesis.
//
// To deregister a consumer, provide its ARN. Alternatively, you can provide
// the ARN of the data stream and the name you gave the consumer when you registered
// it. You may also provide all three parameters, as long as they don't conflict
// with each other. If you don't know the name or ARN of the consumer that you
// want to deregister, you can use the ListStreamConsumers operation to get
// a list of the descriptions of all the consumers that are currently registered
// with a given data stream. The description of a consumer contains its name
// and ARN.
//
// This operation has a limit of five transactions per second per stream.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis's
// API operation DeregisterStreamConsumer for usage and error information.
//
// Returned Error Types:
//
//   - LimitExceededException
//     The requested resource exceeds the maximum number allowed, or the number
//     of concurrent stream requests exceeds the maximum number allowed.
//
//   - ResourceNotFoundException
//     The requested resource could not be found. The stream might not be specified
//     correctly.
//
//   - InvalidArgumentException
//     A specified parameter exceeds its restrictions, is not supported, or can't
//     be used. For more information, see the returned message.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/DeregisterStreamConsumer
func (c *Kinesis) DeregisterStreamConsumer(input *DeregisterStreamConsumerInput) (*DeregisterStreamConsumerOutput, error) {
	req, out := c.DeregisterStreamConsumerRequest(input)
	return out, req.Send()
}

// DeregisterStreamConsumerWithContext is the same as DeregisterStreamConsumer with the addition of
// the ability to pass a context and additional request options.
//
// See DeregisterStreamConsumer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kinesis) DeregisterStreamConsumerWithContext(ctx aws.Context, input *DeregisterStreamConsumerInput, opts ...request.Option) (*DeregisterStreamConsumerOutput, error) {
	req, out := c.DeregisterStreamConsumerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeLimits = "DescribeLimits"

// DescribeLimitsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeLimits operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeLimits for more information on using the DescribeLimits
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeLimitsRequest method.
//	req, resp := client.DescribeLimitsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/DescribeLimits
func (c *Kinesis) DescribeLimitsRequest(input *DescribeLimitsInput) (req *request.Request, output *DescribeLimitsOutput) {
	op := &request.Operation{
		Name:       opDescribeLimits,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeLimitsInput{}
	}

	output = &DescribeLimitsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeLimits API operation for Amazon Kinesis.
//
// Describes the shard limits and usage for the account.
//
// If you update your account limits, the old limits might be returned for a
// few minutes.
//
// This operation has a limit of one transaction per second per account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis's
// API operation DescribeLimits for usage and error information.
//
// Returned Error Types:
//   - LimitExceededException
//     The requested resource exceeds the maximum number allowed, or the number
//     of concurrent stream requests exceeds the maximum number allowed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/DescribeLimits
func (c *Kinesis) DescribeLimits(input *DescribeLimitsInput) (*DescribeLimitsOutput, error) {
	req, out := c.DescribeLimitsRequest(input)
	return out, req.Send()
}

// DescribeLimitsWithContext is the same as DescribeLimits with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeLimits for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kinesis) DescribeLimitsWithContext(ctx aws.Context, input *DescribeLimitsInput, opts ...request.Option) (*DescribeLimitsOutput, error) {
	req, out := c.DescribeLimitsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeStream = "DescribeStream"

// DescribeStreamRequest generates a "aws/request.Request" representing the
// client's request for the DescribeStream operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeStream for more information on using the DescribeStream
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeStreamRequest method.
//	req, resp := client.DescribeStreamRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/DescribeStream
func (c *Kinesis) DescribeStreamRequest(input *DescribeStreamInput) (req *request.Request, output *DescribeStreamOutput) {
	op := &request.Operation{
		Name:       opDescribeStream,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"ExclusiveStartShardId"},
			OutputTokens:    []string{"StreamDescription.Shards[-1].ShardId"},
			LimitToken:      "Limit",
			TruncationToken: "StreamDescription.HasMoreShards",
		},
	}

	if input == nil {
		input = &DescribeStreamInput{}
	}

	output = &DescribeStreamOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeStream API operation for Amazon Kinesis.
//
// Describes the specified Kinesis data stream.
//
// This API has been revised. It's highly recommended that you use the DescribeStreamSummary
// API to get a summarized description of the specified Kinesis data stream
// and the ListShards API to list the shards in a specified data stream and
// obtain information about each shard.
//
// When invoking this API, you must use either the StreamARN or the StreamName
// parameter, or both. It is recommended that you use the StreamARN input parameter
// when you invoke this API.
//
// The information returned includes the stream name, Amazon Resource Name (ARN),
// creation time, enhanced metric configuration, and shard map. The shard map
// is an array of shard objects. For each shard object, there is the hash key
// and sequence number ranges that the shard spans, and the IDs of any earlier
// shards that played in a role in creating the shard. Every record ingested
// in the stream is identified by a sequence number, which is assigned when
// the record is put into the stream.
//
// You can limit the number of shards returned by each call. For more information,
// see Retrieving Shards from a Stream (https://docs.aws.amazon.com/kinesis/latest/dev/kinesis-using-sdk-java-retrieve-shards.html)
// in the Amazon Kinesis Data Streams Developer Guide.
//
// There are no guarantees about the chronological order shards returned. To
// process shards in chronological order, use the ID of the parent shard to
// track the lineage to the oldest shard.
//
// This operation has a limit of 10 transactions per second per account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis's
// API operation DescribeStream for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The requested resource could not be found. The stream might not be specified
//     correctly.
//
//   - LimitExceededException
//     The requested resource exceeds the maximum number allowed, or the number
//     of concurrent stream requests exceeds the maximum number allowed.
//
//   - InvalidArgumentException
//     A specified parameter exceeds its restrictions, is not supported, or can't
//     be used. For more information, see the returned message.
//
//   - AccessDeniedException
//     Specifies that you do not have the permissions required to perform this operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/DescribeStream
func (c *Kinesis) DescribeStream(input *DescribeStreamInput) (*DescribeStreamOutput, error) {
	req, out := c.DescribeStreamRequest(input)
	return out, req.Send()
}

// DescribeStreamWithContext is the same as DescribeStream with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeStream for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kinesis) DescribeStreamWithContext(ctx aws.Context, input *DescribeStreamInput, opts ...request.Option) (*DescribeStreamOutput, error) {
	req, out := c.DescribeStreamRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeStreamPages iterates over the pages of a DescribeStream operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeStream method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeStream operation.
//	pageNum := 0
//	err := client.DescribeStreamPages(params,
//	    func(page *kinesis.DescribeStreamOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Kinesis) DescribeStreamPages(input *DescribeStreamInput, fn func(*DescribeStreamOutput, bool) bool) error {
	return c.DescribeStreamPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeStreamPagesWithContext same as DescribeStreamPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kinesis) DescribeStreamPagesWithContext(ctx aws.Context, input *DescribeStreamInput, fn func(*DescribeStreamOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeStreamInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeStreamRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeStreamOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeStreamConsumer = "DescribeStreamConsumer"

// DescribeStreamConsumerRequest generates a "aws/request.Request" representing the
// client's request for the DescribeStreamConsumer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeStreamConsumer for more information on using the DescribeStreamConsumer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeStreamConsumerRequest method.
//	req, resp := client.DescribeStreamConsumerRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/DescribeStreamConsumer
func (c *Kinesis) DescribeStreamConsumerRequest(input *DescribeStreamConsumerInput) (req *request.Request, output *DescribeStreamConsumerOutput) {
	op := &request.Operation{
		Name:       opDescribeStreamConsumer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeStreamConsumerInput{}
	}

	output = &DescribeStreamConsumerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeStreamConsumer API operation for Amazon Kinesis.
//
// To get the description of a registered consumer, provide the ARN of the consumer.
// Alternatively, you can provide the ARN of the data stream and the name you
// gave the consumer when you registered it. You may also provide all three
// parameters, as long as they don't conflict with each other. If you don't
// know the name or ARN of the consumer that you want to describe, you can use
// the ListStreamConsumers operation to get a list of the descriptions of all
// the consumers that are currently registered with a given data stream.
//
// This operation has a limit of 20 transactions per second per stream.
//
// When making a cross-account call with DescribeStreamConsumer, make sure to
// provide the ARN of the consumer.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis's
// API operation DescribeStreamConsumer for usage and error information.
//
// Returned Error Types:
//
//   - LimitExceededException
//     The requested resource exceeds the maximum number allowed, or the number
//     of concurrent stream requests exceeds the maximum number allowed.
//
//   - ResourceNotFoundException
//     The requested resource could not be found. The stream might not be specified
//     correctly.
//
//   - InvalidArgumentException
//     A specified parameter exceeds its restrictions, is not supported, or can't
//     be used. For more information, see the returned message.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/DescribeStreamConsumer
func (c *Kinesis) DescribeStreamConsumer(input *DescribeStreamConsumerInput) (*DescribeStreamConsumerOutput, error) {
	req, out := c.DescribeStreamConsumerRequest(input)
	return out, req.Send()
}

// DescribeStreamConsumerWithContext is the same as DescribeStreamConsumer with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeStreamConsumer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kinesis) DescribeStreamConsumerWithContext(ctx aws.Context, input *DescribeStreamConsumerInput, opts ...request.Option) (*DescribeStreamConsumerOutput, error) {
	req, out := c.DescribeStreamConsumerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeStreamSummary = "DescribeStreamSummary"

// DescribeStreamSummaryRequest generates a "aws/request.Request" representing the
// client's request for the DescribeStreamSummary operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeStreamSummary for more information on using the DescribeStreamSummary
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeStreamSummaryRequest method.
//	req, resp := client.DescribeStreamSummaryRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/DescribeStreamSummary
func (c *Kinesis) DescribeStreamSummaryRequest(input *DescribeStreamSummaryInput) (req *request.Request, output *DescribeStreamSummaryOutput) {
	op := &request.Operation{
		Name:       opDescribeStreamSummary,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeStreamSummaryInput{}
	}

	output = &DescribeStreamSummaryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeStreamSummary API operation for Amazon Kinesis.
//
// Provides a summarized description of the specified Kinesis data stream without
// the shard list.
//
// When invoking this API, you must use either the StreamARN or the StreamName
// parameter, or both. It is recommended that you use the StreamARN input parameter
// when you invoke this API.
//
// The information returned includes the stream name, Amazon Resource Name (ARN),
// status, record retention period, approximate creation time, monitoring, encryption
// details, and open shard count.
//
// DescribeStreamSummary has a limit of 20 transactions per second per account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis's
// API operation DescribeStreamSummary for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The requested resource could not be found. The stream might not be specified
//     correctly.
//
//   - LimitExceededException
//     The requested resource exceeds the maximum number allowed, or the number
//     of concurrent stream requests exceeds the maximum number allowed.
//
//   - InvalidArgumentException
//     A specified parameter exceeds its restrictions, is not supported, or can't
//     be used. For more information, see the returned message.
//
//   - AccessDeniedException
//     Specifies that you do not have the permissions required to perform this operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/DescribeStreamSummary
func (c *Kinesis) DescribeStreamSummary(input *DescribeStreamSummaryInput) (*DescribeStreamSummaryOutput, error) {
	req, out := c.DescribeStreamSummaryRequest(input)
	return out, req.Send()
}

// DescribeStreamSummaryWithContext is the same as DescribeStreamSummary with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeStreamSummary for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kinesis) DescribeStreamSummaryWithContext(ctx aws.Context, input *DescribeStreamSummaryInput, opts ...request.Option) (*DescribeStreamSummaryOutput, error) {
	req, out := c.DescribeStreamSummaryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisableEnhancedMonitoring = "DisableEnhancedMonitoring"

// DisableEnhancedMonitoringRequest generates a "aws/request.Request" representing the
// client's request for the DisableEnhancedMonitoring operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisableEnhancedMonitoring for more information on using the DisableEnhancedMonitoring
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DisableEnhancedMonitoringRequest method.
//	req, resp := client.DisableEnhancedMonitoringRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/DisableEnhancedMonitoring
func (c *Kinesis) DisableEnhancedMonitoringRequest(input *DisableEnhancedMonitoringInput) (req *request.Request, output *EnhancedMonitoringOutput) {
	op := &request.Operation{
		Name:       opDisableEnhancedMonitoring,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisableEnhancedMonitoringInput{}
	}

	output = &EnhancedMonitoringOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DisableEnhancedMonitoring API operation for Amazon Kinesis.
//
// Disables enhanced monitoring.
//
// When invoking this API, you must use either the StreamARN or the StreamName
// parameter, or both. It is recommended that you use the StreamARN input parameter
// when you invoke this API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis's
// API operation DisableEnhancedMonitoring for usage and error information.
//
// Returned Error Types:
//
//   - InvalidArgumentException
//     A specified parameter exceeds its restrictions, is not supported, or can't
//     be used. For more information, see the returned message.
//
//   - LimitExceededException
//     The requested resource exceeds the maximum number allowed, or the number
//     of concurrent stream requests exceeds the maximum number allowed.
//
//   - ResourceInUseException
//     The resource is not available for this operation. For successful operation,
//     the resource must be in the ACTIVE state.
//
//   - ResourceNotFoundException
//     The requested resource could not be found. The stream might not be specified
//     correctly.
//
//   - AccessDeniedException
//     Specifies that you do not have the permissions required to perform this operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/DisableEnhancedMonitoring
func (c *Kinesis) DisableEnhancedMonitoring(input *DisableEnhancedMonitoringInput) (*EnhancedMonitoringOutput, error) {
	req, out := c.DisableEnhancedMonitoringRequest(input)
	return out, req.Send()
}

// DisableEnhancedMonitoringWithContext is the same as DisableEnhancedMonitoring with the addition of
// the ability to pass a context and additional request options.
//
// See DisableEnhancedMonitoring for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kinesis) DisableEnhancedMonitoringWithContext(ctx aws.Context, input *DisableEnhancedMonitoringInput, opts ...request.Option) (*EnhancedMonitoringOutput, error) {
	req, out := c.DisableEnhancedMonitoringRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opEnableEnhancedMonitoring = "EnableEnhancedMonitoring"

// EnableEnhancedMonitoringRequest generates a "aws/request.Request" representing the
// client's request for the EnableEnhancedMonitoring operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See EnableEnhancedMonitoring for more information on using the EnableEnhancedMonitoring
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the EnableEnhancedMonitoringRequest method.
//	req, resp := client.EnableEnhancedMonitoringRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/EnableEnhancedMonitoring
func (c *Kinesis) EnableEnhancedMonitoringRequest(input *EnableEnhancedMonitoringInput) (req *request.Request, output *EnhancedMonitoringOutput) {
	op := &request.Operation{
		Name:       opEnableEnhancedMonitoring,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &EnableEnhancedMonitoringInput{}
	}

	output = &EnhancedMonitoringOutput{}
	req = c.newRequest(op, input, output)
	return
}

// EnableEnhancedMonitoring API operation for Amazon Kinesis.
//
// Enables enhanced Kinesis data stream monitoring for shard-level metrics.
//
// When invoking this API, you must use either the StreamARN or the StreamName
// parameter, or both. It is recommended that you use the StreamARN input parameter
// when you invoke this API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis's
// API operation EnableEnhancedMonitoring for usage and error information.
//
// Returned Error Types:
//
//   - InvalidArgumentException
//     A specified parameter exceeds its restrictions, is not supported, or can't
//     be used. For more information, see the returned message.
//
//   - LimitExceededException
//     The requested resource exceeds the maximum number allowed, or the number
//     of concurrent stream requests exceeds the maximum number allowed.
//
//   - ResourceInUseException
//     The resource is not available for this operation. For successful operation,
//     the resource must be in the ACTIVE state.
//
//   - ResourceNotFoundException
//     The requested resource could not be found. The stream might not be specified
//     correctly.
//
//   - AccessDeniedException
//     Specifies that you do not have the permissions required to perform this operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/EnableEnhancedMonitoring
func (c *Kinesis) EnableEnhancedMonitoring(input *EnableEnhancedMonitoringInput) (*EnhancedMonitoringOutput, error) {
	req, out := c.EnableEnhancedMonitoringRequest(input)
	return out, req.Send()
}

// EnableEnhancedMonitoringWithContext is the same as EnableEnhancedMonitoring with the addition of
// the ability to pass a context and additional request options.
//
// See EnableEnhancedMonitoring for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kinesis) EnableEnhancedMonitoringWithContext(ctx aws.Context, input *EnableEnhancedMonitoringInput, opts ...request.Option) (*EnhancedMonitoringOutput, error) {
	req, out := c.EnableEnhancedMonitoringRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRecords = "GetRecords"

// GetRecordsRequest generates a "aws/request.Request" representing the
// client's request for the GetRecords operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRecords for more information on using the GetRecords
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetRecordsRequest method.
//	req, resp := client.GetRecordsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/GetRecords
func (c *Kinesis) GetRecordsRequest(input *GetRecordsInput) (req *request.Request, output *GetRecordsOutput) {
	op := &request.Operation{
		Name:       opGetRecords,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetRecordsInput{}
	}

	output = &GetRecordsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRecords API operation for Amazon Kinesis.
//
// Gets data records from a Kinesis data stream's shard.
//
// When invoking this API, you must use either the StreamARN or the StreamName
// parameter, or both. It is recommended that you use the StreamARN input parameter
// when you invoke this API.
//
// Specify a shard iterator using the ShardIterator parameter. The shard iterator
// specifies the position in the shard from which you want to start reading
// data records sequentially. If there are no records available in the portion
// of the shard that the iterator points to, GetRecords returns an empty list.
// It might take multiple calls to get to a portion of the shard that contains
// records.
//
// You can scale by provisioning multiple shards per stream while considering
// service limits (for more information, see Amazon Kinesis Data Streams Limits
// (https://docs.aws.amazon.com/kinesis/latest/dev/service-sizes-and-limits.html)
// in the Amazon Kinesis Data Streams Developer Guide). Your application should
// have one thread per shard, each reading continuously from its stream. To
// read from a stream continually, call GetRecords in a loop. Use GetShardIterator
// to get the shard iterator to specify in the first GetRecords call. GetRecords
// returns a new shard iterator in NextShardIterator. Specify the shard iterator
// returned in NextShardIterator in subsequent calls to GetRecords. If the shard
// has been closed, the shard iterator can't return more data and GetRecords
// returns null in NextShardIterator. You can terminate the loop when the shard
// is closed, or when the shard iterator reaches the record with the sequence
// number or other attribute that marks it as the last record to process.
//
// Each data record can be up to 1 MiB in size, and each shard can read up to
// 2 MiB per second. You can ensure that your calls don't exceed the maximum
// supported size or throughput by using the Limit parameter to specify the
// maximum number of records that GetRecords can return. Consider your average
// record size when determining this limit. The maximum number of records that
// can be returned per call is 10,000.
//
// The size of the data returned by GetRecords varies depending on the utilization
// of the shard. It is recommended that consumer applications retrieve records
// via the GetRecords command using the 5 TPS limit to remain caught up. Retrieving
// records less frequently can lead to consumer applications falling behind.
// The maximum size of data that GetRecords can return is 10 MiB. If a call
// returns this amount of data, subsequent calls made within the next 5 seconds
// throw ProvisionedThroughputExceededException. If there is insufficient provisioned
// throughput on the stream, subsequent calls made within the next 1 second
// throw ProvisionedThroughputExceededException. GetRecords doesn't return any
// data when it throws an exception. For this reason, we recommend that you
// wait 1 second between calls to GetRecords. However, it's possible that the
// application will get exceptions for longer than 1 second.
//
// To detect whether the application is falling behind in processing, you can
// use the MillisBehindLatest response attribute. You can also monitor the stream
// using CloudWatch metrics and other mechanisms (see Monitoring (https://docs.aws.amazon.com/kinesis/latest/dev/monitoring.html)
// in the Amazon Kinesis Data Streams Developer Guide).
//
// Each Amazon Kinesis record includes a value, ApproximateArrivalTimestamp,
// that is set when a stream successfully receives and stores a record. This
// is commonly referred to as a server-side time stamp, whereas a client-side
// time stamp is set when a data producer creates or sends the record to a stream
// (a data producer is any data source putting data records into a stream, for
// example with PutRecords). The time stamp has millisecond precision. There
// are no guarantees about the time stamp accuracy, or that the time stamp is
// always increasing. For example, records in a shard or across a stream might
// have time stamps that are out of order.
//
// This operation has a limit of five transactions per second per shard.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis's
// API operation GetRecords for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The requested resource could not be found. The stream might not be specified
//     correctly.
//
//   - InvalidArgumentException
//     A specified parameter exceeds its restrictions, is not supported, or can't
//     be used. For more information, see the returned message.
//
//   - ProvisionedThroughputExceededException
//     The request rate for the stream is too high, or the requested data is too
//     large for the available throughput. Reduce the frequency or size of your
//     requests. For more information, see Streams Limits (https://docs.aws.amazon.com/kinesis/latest/dev/service-sizes-and-limits.html)
//     in the Amazon Kinesis Data Streams Developer Guide, and Error Retries and
//     Exponential Backoff in Amazon Web Services (https://docs.aws.amazon.com/general/latest/gr/api-retries.html)
//     in the Amazon Web Services General Reference.
//
//   - ExpiredIteratorException
//     The provided iterator exceeds the maximum age allowed.
//
//   - KMSDisabledException
//     The request was rejected because the specified customer master key (CMK)
//     isn't enabled.
//
//   - KMSInvalidStateException
//     The request was rejected because the state of the specified resource isn't
//     valid for this request. For more information, see How Key State Affects Use
//     of a Customer Master Key (https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
//     in the Amazon Web Services Key Management Service Developer Guide.
//
//   - KMSAccessDeniedException
//     The ciphertext references a key that doesn't exist or that you don't have
//     access to.
//
//   - KMSNotFoundException
//     The request was rejected because the specified entity or resource can't be
//     found.
//
//   - KMSOptInRequired
//     The Amazon Web Services access key ID needs a subscription for the service.
//
//   - KMSThrottlingException
//     The request was denied due to request throttling. For more information about
//     throttling, see Limits (https://docs.aws.amazon.com/kms/latest/developerguide/limits.html#requests-per-second)
//     in the Amazon Web Services Key Management Service Developer Guide.
//
//   - AccessDeniedException
//     Specifies that you do not have the permissions required to perform this operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/GetRecords
func (c *Kinesis) GetRecords(input *GetRecordsInput) (*GetRecordsOutput, error) {
	req, out := c.GetRecordsRequest(input)
	return out, req.Send()
}

// GetRecordsWithContext is the same as GetRecords with the addition of
// the ability to pass a context and additional request options.
//
// See GetRecords for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kinesis) GetRecordsWithContext(ctx aws.Context, input *GetRecordsInput, opts ...request.Option) (*GetRecordsOutput, error) {
	req, out := c.GetRecordsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetResourcePolicy = "GetResourcePolicy"

// GetResourcePolicyRequest generates a "aws/request.Request" representing the
// client's request for the GetResourcePolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetResourcePolicy for more information on using the GetResourcePolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetResourcePolicyRequest method.
//	req, resp := client.GetResourcePolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/GetResourcePolicy
func (c *Kinesis) GetResourcePolicyRequest(input *GetResourcePolicyInput) (req *request.Request, output *GetResourcePolicyOutput) {
	op := &request.Operation{
		Name:       opGetResourcePolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetResourcePolicyInput{}
	}

	output = &GetResourcePolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetResourcePolicy API operation for Amazon Kinesis.
//
// Returns a policy attached to the specified data stream or consumer. Request
// patterns can be one of the following:
//
//   - Data stream pattern: arn:aws.*:kinesis:.*:\d{12}:.*stream/\S+
//
//   - Consumer pattern: ^(arn):aws.*:kinesis:.*:\d{12}:.*stream\/[a-zA-Z0-9_.-]+\/consumer\/[a-zA-Z0-9_.-]+:[0-9]+
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis's
// API operation GetResourcePolicy for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     Specifies that you do not have the permissions required to perform this operation.
//
//   - ResourceNotFoundException
//     The requested resource could not be found. The stream might not be specified
//     correctly.
//
//   - LimitExceededException
//     The requested resource exceeds the maximum number allowed, or the number
//     of concurrent stream requests exceeds the maximum number allowed.
//
//   - InvalidArgumentException
//     A specified parameter exceeds its restrictions, is not supported, or can't
//     be used. For more information, see the returned message.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/GetResourcePolicy
func (c *Kinesis) GetResourcePolicy(input *GetResourcePolicyInput) (*GetResourcePolicyOutput, error) {
	req, out := c.GetResourcePolicyRequest(input)
	return out, req.Send()
}

// GetResourcePolicyWithContext is the same as GetResourcePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See GetResourcePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kinesis) GetResourcePolicyWithContext(ctx aws.Context, input *GetResourcePolicyInput, opts ...request.Option) (*GetResourcePolicyOutput, error) {
	req, out := c.GetResourcePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetShardIterator = "GetShardIterator"

// GetShardIteratorRequest generates a "aws/request.Request" representing the
// client's request for the GetShardIterator operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetShardIterator for more information on using the GetShardIterator
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetShardIteratorRequest method.
//	req, resp := client.GetShardIteratorRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/GetShardIterator
func (c *Kinesis) GetShardIteratorRequest(input *GetShardIteratorInput) (req *request.Request, output *GetShardIteratorOutput) {
	op := &request.Operation{
		Name:       opGetShardIterator,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetShardIteratorInput{}
	}

	output = &GetShardIteratorOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetShardIterator API operation for Amazon Kinesis.
//
// Gets an Amazon Kinesis shard iterator. A shard iterator expires 5 minutes
// after it is returned to the requester.
//
// When invoking this API, you must use either the StreamARN or the StreamName
// parameter, or both. It is recommended that you use the StreamARN input parameter
// when you invoke this API.
//
// A shard iterator specifies the shard position from which to start reading
// data records sequentially. The position is specified using the sequence number
// of a data record in a shard. A sequence number is the identifier associated
// with every record ingested in the stream, and is assigned when a record is
// put into the stream. Each stream has one or more shards.
//
// You must specify the shard iterator type. For example, you can set the ShardIteratorType
// parameter to read exactly from the position denoted by a specific sequence
// number by using the AT_SEQUENCE_NUMBER shard iterator type. Alternatively,
// the parameter can read right after the sequence number by using the AFTER_SEQUENCE_NUMBER
// shard iterator type, using sequence numbers returned by earlier calls to
// PutRecord, PutRecords, GetRecords, or DescribeStream. In the request, you
// can specify the shard iterator type AT_TIMESTAMP to read records from an
// arbitrary point in time, TRIM_HORIZON to cause ShardIterator to point to
// the last untrimmed record in the shard in the system (the oldest data record
// in the shard), or LATEST so that you always read the most recent data in
// the shard.
//
// When you read repeatedly from a stream, use a GetShardIterator request to
// get the first shard iterator for use in your first GetRecords request and
// for subsequent reads use the shard iterator returned by the GetRecords request
// in NextShardIterator. A new shard iterator is returned by every GetRecords
// request in NextShardIterator, which you use in the ShardIterator parameter
// of the next GetRecords request.
//
// If a GetShardIterator request is made too often, you receive a ProvisionedThroughputExceededException.
// For more information about throughput limits, see GetRecords, and Streams
// Limits (https://docs.aws.amazon.com/kinesis/latest/dev/service-sizes-and-limits.html)
// in the Amazon Kinesis Data Streams Developer Guide.
//
// If the shard is closed, GetShardIterator returns a valid iterator for the
// last sequence number of the shard. A shard can be closed as a result of using
// SplitShard or MergeShards.
//
// GetShardIterator has a limit of five transactions per second per account
// per open shard.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis's
// API operation GetShardIterator for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The requested resource could not be found. The stream might not be specified
//     correctly.
//
//   - InvalidArgumentException
//     A specified parameter exceeds its restrictions, is not supported, or can't
//     be used. For more information, see the returned message.
//
//   - ProvisionedThroughputExceededException
//     The request rate for the stream is too high, or the requested data is too
//     large for the available throughput. Reduce the frequency or size of your
//     requests. For more information, see Streams Limits (https://docs.aws.amazon.com/kinesis/latest/dev/service-sizes-and-limits.html)
//     in the Amazon Kinesis Data Streams Developer Guide, and Error Retries and
//     Exponential Backoff in Amazon Web Services (https://docs.aws.amazon.com/general/latest/gr/api-retries.html)
//     in the Amazon Web Services General Reference.
//
//   - AccessDeniedException
//     Specifies that you do not have the permissions required to perform this operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/GetShardIterator
func (c *Kinesis) GetShardIterator(input *GetShardIteratorInput) (*GetShardIteratorOutput, error) {
	req, out := c.GetShardIteratorRequest(input)
	return out, req.Send()
}

// GetShardIteratorWithContext is the same as GetShardIterator with the addition of
// the ability to pass a context and additional request options.
//
// See GetShardIterator for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kinesis) GetShardIteratorWithContext(ctx aws.Context, input *GetShardIteratorInput, opts ...request.Option) (*GetShardIteratorOutput, error) {
	req, out := c.GetShardIteratorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opIncreaseStreamRetentionPeriod = "IncreaseStreamRetentionPeriod"

// IncreaseStreamRetentionPeriodRequest generates a "aws/request.Request" representing the
// client's request for the IncreaseStreamRetentionPeriod operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See IncreaseStreamRetentionPeriod for more information on using the IncreaseStreamRetentionPeriod
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the IncreaseStreamRetentionPeriodRequest method.
//	req, resp := client.IncreaseStreamRetentionPeriodRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/IncreaseStreamRetentionPeriod
func (c *Kinesis) IncreaseStreamRetentionPeriodRequest(input *IncreaseStreamRetentionPeriodInput) (req *request.Request, output *IncreaseStreamRetentionPeriodOutput) {
	op := &request.Operation{
		Name:       opIncreaseStreamRetentionPeriod,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &IncreaseStreamRetentionPeriodInput{}
	}

	output = &IncreaseStreamRetentionPeriodOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// IncreaseStreamRetentionPeriod API operation for Amazon Kinesis.
//
// Increases the Kinesis data stream's retention period, which is the length
// of time data records are accessible after they are added to the stream. The
// maximum value of a stream's retention period is 8760 hours (365 days).
//
// When invoking this API, you must use either the StreamARN or the StreamName
// parameter, or both. It is recommended that you use the StreamARN input parameter
// when you invoke this API.
//
// If you choose a longer stream retention period, this operation increases
// the time period during which records that have not yet expired are accessible.
// However, it does not make previous, expired data (older than the stream's
// previous retention period) accessible after the operation has been called.
// For example, if a stream's retention period is set to 24 hours and is increased
// to 168 hours, any data that is older than 24 hours remains inaccessible to
// consumer applications.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis's
// API operation IncreaseStreamRetentionPeriod for usage and error information.
//
// Returned Error Types:
//
//   - ResourceInUseException
//     The resource is not available for this operation. For successful operation,
//     the resource must be in the ACTIVE state.
//
//   - ResourceNotFoundException
//     The requested resource could not be found. The stream might not be specified
//     correctly.
//
//   - LimitExceededException
//     The requested resource exceeds the maximum number allowed, or the number
//     of concurrent stream requests exceeds the maximum number allowed.
//
//   - InvalidArgumentException
//     A specified parameter exceeds its restrictions, is not supported, or can't
//     be used. For more information, see the returned message.
//
//   - AccessDeniedException
//     Specifies that you do not have the permissions required to perform this operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/IncreaseStreamRetentionPeriod
func (c *Kinesis) IncreaseStreamRetentionPeriod(input *IncreaseStreamRetentionPeriodInput) (*IncreaseStreamRetentionPeriodOutput, error) {
	req, out := c.IncreaseStreamRetentionPeriodRequest(input)
	return out, req.Send()
}

// IncreaseStreamRetentionPeriodWithContext is the same as IncreaseStreamRetentionPeriod with the addition of
// the ability to pass a context and additional request options.
//
// See IncreaseStreamRetentionPeriod for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kinesis) IncreaseStreamRetentionPeriodWithContext(ctx aws.Context, input *IncreaseStreamRetentionPeriodInput, opts ...request.Option) (*IncreaseStreamRetentionPeriodOutput, error) {
	req, out := c.IncreaseStreamRetentionPeriodRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListShards = "ListShards"

// ListShardsRequest generates a "aws/request.Request" representing the
// client's request for the ListShards operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListShards for more information on using the ListShards
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListShardsRequest method.
//	req, resp := client.ListShardsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/ListShards
func (c *Kinesis) ListShardsRequest(input *ListShardsInput) (req *request.Request, output *ListShardsOutput) {
	op := &request.Operation{
		Name:       opListShards,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListShardsInput{}
	}

	output = &ListShardsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListShards API operation for Amazon Kinesis.
//
// Lists the shards in a stream and provides information about each shard. This
// operation has a limit of 1000 transactions per second per data stream.
//
// When invoking this API, you must use either the StreamARN or the StreamName
// parameter, or both. It is recommended that you use the StreamARN input parameter
// when you invoke this API.
//
// This action does not list expired shards. For information about expired shards,
// see Data Routing, Data Persistence, and Shard State after a Reshard (https://docs.aws.amazon.com/streams/latest/dev/kinesis-using-sdk-java-after-resharding.html#kinesis-using-sdk-java-resharding-data-routing).
//
// This API is a new operation that is used by the Amazon Kinesis Client Library
// (KCL). If you have a fine-grained IAM policy that only allows specific operations,
// you must update your policy to allow calls to this API. For more information,
// see Controlling Access to Amazon Kinesis Data Streams Resources Using IAM
// (https://docs.aws.amazon.com/streams/latest/dev/controlling-access.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis's
// API operation ListShards for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The requested resource could not be found. The stream might not be specified
//     correctly.
//
//   - InvalidArgumentException
//     A specified parameter exceeds its restrictions, is not supported, or can't
//     be used. For more information, see the returned message.
//
//   - LimitExceededException
//     The requested resource exceeds the maximum number allowed, or the number
//     of concurrent stream requests exceeds the maximum number allowed.
//
//   - ExpiredNextTokenException
//     The pagination token passed to the operation is expired.
//
//   - ResourceInUseException
//     The resource is not available for this operation. For successful operation,
//     the resource must be in the ACTIVE state.
//
//   - AccessDeniedException
//     Specifies that you do not have the permissions required to perform this operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/ListShards
func (c *Kinesis) ListShards(input *ListShardsInput) (*ListShardsOutput, error) {
	req, out := c.ListShardsRequest(input)
	return out, req.Send()
}

// ListShardsWithContext is the same as ListShards with the addition of
// the ability to pass a context and additional request options.
//
// See ListShards for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kinesis) ListShardsWithContext(ctx aws.Context, input *ListShardsInput, opts ...request.Option) (*ListShardsOutput, error) {
	req, out := c.ListShardsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListStreamConsumers = "ListStreamConsumers"

// ListStreamConsumersRequest generates a "aws/request.Request" representing the
// client's request for the ListStreamConsumers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListStreamConsumers for more information on using the ListStreamConsumers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListStreamConsumersRequest method.
//	req, resp := client.ListStreamConsumersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/ListStreamConsumers
func (c *Kinesis) ListStreamConsumersRequest(input *ListStreamConsumersInput) (req *request.Request, output *ListStreamConsumersOutput) {
	op := &request.Operation{
		Name:       opListStreamConsumers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListStreamConsumersInput{}
	}

	output = &ListStreamConsumersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListStreamConsumers API operation for Amazon Kinesis.
//
// Lists the consumers registered to receive data from a stream using enhanced
// fan-out, and provides information about each consumer.
//
// This operation has a limit of 5 transactions per second per stream.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis's
// API operation ListStreamConsumers for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The requested resource could not be found. The stream might not be specified
//     correctly.
//
//   - InvalidArgumentException
//     A specified parameter exceeds its restrictions, is not supported, or can't
//     be used. For more information, see the returned message.
//
//   - LimitExceededException
//     The requested resource exceeds the maximum number allowed, or the number
//     of concurrent stream requests exceeds the maximum number allowed.
//
//   - ExpiredNextTokenException
//     The pagination token passed to the operation is expired.
//
//   - ResourceInUseException
//     The resource is not available for this operation. For successful operation,
//     the resource must be in the ACTIVE state.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/ListStreamConsumers
func (c *Kinesis) ListStreamConsumers(input *ListStreamConsumersInput) (*ListStreamConsumersOutput, error) {
	req, out := c.ListStreamConsumersRequest(input)
	return out, req.Send()
}

// ListStreamConsumersWithContext is the same as ListStreamConsumers with the addition of
// the ability to pass a context and additional request options.
//
// See ListStreamConsumers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kinesis) ListStreamConsumersWithContext(ctx aws.Context, input *ListStreamConsumersInput, opts ...request.Option) (*ListStreamConsumersOutput, error) {
	req, out := c.ListStreamConsumersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListStreamConsumersPages iterates over the pages of a ListStreamConsumers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListStreamConsumers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListStreamConsumers operation.
//	pageNum := 0
//	err := client.ListStreamConsumersPages(params,
//	    func(page *kinesis.ListStreamConsumersOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Kinesis) ListStreamConsumersPages(input *ListStreamConsumersInput, fn func(*ListStreamConsumersOutput, bool) bool) error {
	return c.ListStreamConsumersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListStreamConsumersPagesWithContext same as ListStreamConsumersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kinesis) ListStreamConsumersPagesWithContext(ctx aws.Context, input *ListStreamConsumersInput, fn func(*ListStreamConsumersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListStreamConsumersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListStreamConsumersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListStreamConsumersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListStreams = "ListStreams"

// ListStreamsRequest generates a "aws/request.Request" representing the
// client's request for the ListStreams operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListStreams for more information on using the ListStreams
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListStreamsRequest method.
//	req, resp := client.ListStreamsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/ListStreams
func (c *Kinesis) ListStreamsRequest(input *ListStreamsInput) (req *request.Request, output *ListStreamsOutput) {
	op := &request.Operation{
		Name:       opListStreams,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "Limit",
			TruncationToken: "HasMoreStreams",
		},
	}

	if input == nil {
		input = &ListStreamsInput{}
	}

	output = &ListStreamsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListStreams API operation for Amazon Kinesis.
//
// Lists your Kinesis data streams.
//
// The number of streams may be too large to return from a single call to ListStreams.
// You can limit the number of returned streams using the Limit parameter. If
// you do not specify a value for the Limit parameter, Kinesis Data Streams
// uses the default limit, which is currently 100.
//
// You can detect if there are more streams available to list by using the HasMoreStreams
// flag from the returned output. If there are more streams available, you can
// request more streams by using the name of the last stream returned by the
// ListStreams request in the ExclusiveStartStreamName parameter in a subsequent
// request to ListStreams. The group of stream names returned by the subsequent
// request is then added to the list. You can continue this process until all
// the stream names have been collected in the list.
//
// ListStreams has a limit of five transactions per second per account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis's
// API operation ListStreams for usage and error information.
//
// Returned Error Types:
//
//   - LimitExceededException
//     The requested resource exceeds the maximum number allowed, or the number
//     of concurrent stream requests exceeds the maximum number allowed.
//
//   - ExpiredNextTokenException
//     The pagination token passed to the operation is expired.
//
//   - InvalidArgumentException
//     A specified parameter exceeds its restrictions, is not supported, or can't
//     be used. For more information, see the returned message.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/ListStreams
func (c *Kinesis) ListStreams(input *ListStreamsInput) (*ListStreamsOutput, error) {
	req, out := c.ListStreamsRequest(input)
	return out, req.Send()
}

// ListStreamsWithContext is the same as ListStreams with the addition of
// the ability to pass a context and additional request options.
//
// See ListStreams for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kinesis) ListStreamsWithContext(ctx aws.Context, input *ListStreamsInput, opts ...request.Option) (*ListStreamsOutput, error) {
	req, out := c.ListStreamsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListStreamsPages iterates over the pages of a ListStreams operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListStreams method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListStreams operation.
//	pageNum := 0
//	err := client.ListStreamsPages(params,
//	    func(page *kinesis.ListStreamsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Kinesis) ListStreamsPages(input *ListStreamsInput, fn func(*ListStreamsOutput, bool) bool) error {
	return c.ListStreamsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListStreamsPagesWithContext same as ListStreamsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kinesis) ListStreamsPagesWithContext(ctx aws.Context, input *ListStreamsInput, fn func(*ListStreamsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListStreamsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListStreamsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListStreamsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForStream = "ListTagsForStream"

// ListTagsForStreamRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForStream operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForStream for more information on using the ListTagsForStream
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForStreamRequest method.
//	req, resp := client.ListTagsForStreamRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/ListTagsForStream
func (c *Kinesis) ListTagsForStreamRequest(input *ListTagsForStreamInput) (req *request.Request, output *ListTagsForStreamOutput) {
	op := &request.Operation{
		Name:       opListTagsForStream,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagsForStreamInput{}
	}

	output = &ListTagsForStreamOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForStream API operation for Amazon Kinesis.
//
// Lists the tags for the specified Kinesis data stream. This operation has
// a limit of five transactions per second per account.
//
// When invoking this API, you must use either the StreamARN or the StreamName
// parameter, or both. It is recommended that you use the StreamARN input parameter
// when you invoke this API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis's
// API operation ListTagsForStream for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The requested resource could not be found. The stream might not be specified
//     correctly.
//
//   - InvalidArgumentException
//     A specified parameter exceeds its restrictions, is not supported, or can't
//     be used. For more information, see the returned message.
//
//   - LimitExceededException
//     The requested resource exceeds the maximum number allowed, or the number
//     of concurrent stream requests exceeds the maximum number allowed.
//
//   - AccessDeniedException
//     Specifies that you do not have the permissions required to perform this operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/ListTagsForStream
func (c *Kinesis) ListTagsForStream(input *ListTagsForStreamInput) (*ListTagsForStreamOutput, error) {
	req, out := c.ListTagsForStreamRequest(input)
	return out, req.Send()
}

// ListTagsForStreamWithContext is the same as ListTagsForStream with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForStream for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kinesis) ListTagsForStreamWithContext(ctx aws.Context, input *ListTagsForStreamInput, opts ...request.Option) (*ListTagsForStreamOutput, error) {
	req, out := c.ListTagsForStreamRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opMergeShards = "MergeShards"

// MergeShardsRequest generates a "aws/request.Request" representing the
// client's request for the MergeShards operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See MergeShards for more information on using the MergeShards
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the MergeShardsRequest method.
//	req, resp := client.MergeShardsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/MergeShards
func (c *Kinesis) MergeShardsRequest(input *MergeShardsInput) (req *request.Request, output *MergeShardsOutput) {
	op := &request.Operation{
		Name:       opMergeShards,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &MergeShardsInput{}
	}

	output = &MergeShardsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// MergeShards API operation for Amazon Kinesis.
//
// Merges two adjacent shards in a Kinesis data stream and combines them into
// a single shard to reduce the stream's capacity to ingest and transport data.
// This API is only supported for the data streams with the provisioned capacity
// mode. Two shards are considered adjacent if the union of the hash key ranges
// for the two shards form a contiguous set with no gaps. For example, if you
// have two shards, one with a hash key range of 276...381 and the other with
// a hash key range of 382...454, then you could merge these two shards into
// a single shard that would have a hash key range of 276...454. After the merge,
// the single child shard receives data for all hash key values covered by the
// two parent shards.
//
// When invoking this API, you must use either the StreamARN or the StreamName
// parameter, or both. It is recommended that you use the StreamARN input parameter
// when you invoke this API.
//
// MergeShards is called when there is a need to reduce the overall capacity
// of a stream because of excess capacity that is not being used. You must specify
// the shard to be merged and the adjacent shard for a stream. For more information
// about merging shards, see Merge Two Shards (https://docs.aws.amazon.com/kinesis/latest/dev/kinesis-using-sdk-java-resharding-merge.html)
// in the Amazon Kinesis Data Streams Developer Guide.
//
// If the stream is in the ACTIVE state, you can call MergeShards. If a stream
// is in the CREATING, UPDATING, or DELETING state, MergeShards returns a ResourceInUseException.
// If the specified stream does not exist, MergeShards returns a ResourceNotFoundException.
//
// You can use DescribeStreamSummary to check the state of the stream, which
// is returned in StreamStatus.
//
// MergeShards is an asynchronous operation. Upon receiving a MergeShards request,
// Amazon Kinesis Data Streams immediately returns a response and sets the StreamStatus
// to UPDATING. After the operation is completed, Kinesis Data Streams sets
// the StreamStatus to ACTIVE. Read and write operations continue to work while
// the stream is in the UPDATING state.
//
// You use DescribeStreamSummary and the ListShards APIs to determine the shard
// IDs that are specified in the MergeShards request.
//
// If you try to operate on too many streams in parallel using CreateStream,
// DeleteStream, MergeShards, or SplitShard, you receive a LimitExceededException.
//
// MergeShards has a limit of five transactions per second per account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis's
// API operation MergeShards for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The requested resource could not be found. The stream might not be specified
//     correctly.
//
//   - ResourceInUseException
//     The resource is not available for this operation. For successful operation,
//     the resource must be in the ACTIVE state.
//
//   - InvalidArgumentException
//     A specified parameter exceeds its restrictions, is not supported, or can't
//     be used. For more information, see the returned message.
//
//   - LimitExceededException
//     The requested resource exceeds the maximum number allowed, or the number
//     of concurrent stream requests exceeds the maximum number allowed.
//
//   - ValidationException
//     Specifies that you tried to invoke this API for a data stream with the on-demand
//     capacity mode. This API is only supported for data streams with the provisioned
//     capacity mode.
//
//   - AccessDeniedException
//     Specifies that you do not have the permissions required to perform this operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/MergeShards
func (c *Kinesis) MergeShards(input *MergeShardsInput) (*MergeShardsOutput, error) {
	req, out := c.MergeShardsRequest(input)
	return out, req.Send()
}

// MergeShardsWithContext is the same as MergeShards with the addition of
// the ability to pass a context and additional request options.
//
// See MergeShards for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kinesis) MergeShardsWithContext(ctx aws.Context, input *MergeShardsInput, opts ...request.Option) (*MergeShardsOutput, error) {
	req, out := c.MergeShardsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutRecord = "PutRecord"

// PutRecordRequest generates a "aws/request.Request" representing the
// client's request for the PutRecord operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutRecord for more information on using the PutRecord
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutRecordRequest method.
//	req, resp := client.PutRecordRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/PutRecord
func (c *Kinesis) PutRecordRequest(input *PutRecordInput) (req *request.Request, output *PutRecordOutput) {
	op := &request.Operation{
		Name:       opPutRecord,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutRecordInput{}
	}

	output = &PutRecordOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutRecord API operation for Amazon Kinesis.
//
// Writes a single data record into an Amazon Kinesis data stream. Call PutRecord
// to send data into the stream for real-time ingestion and subsequent processing,
// one record at a time. Each shard can support writes up to 1,000 records per
// second, up to a maximum data write total of 1 MiB per second.
//
// When invoking this API, you must use either the StreamARN or the StreamName
// parameter, or both. It is recommended that you use the StreamARN input parameter
// when you invoke this API.
//
// You must specify the name of the stream that captures, stores, and transports
// the data; a partition key; and the data blob itself.
//
// The data blob can be any type of data; for example, a segment from a log
// file, geographic/location data, website clickstream data, and so on.
//
// The partition key is used by Kinesis Data Streams to distribute data across
// shards. Kinesis Data Streams segregates the data records that belong to a
// stream into multiple shards, using the partition key associated with each
// data record to determine the shard to which a given data record belongs.
//
// Partition keys are Unicode strings, with a maximum length limit of 256 characters
// for each key. An MD5 hash function is used to map partition keys to 128-bit
// integer values and to map associated data records to shards using the hash
// key ranges of the shards. You can override hashing the partition key to determine
// the shard by explicitly specifying a hash value using the ExplicitHashKey
// parameter. For more information, see Adding Data to a Stream (https://docs.aws.amazon.com/kinesis/latest/dev/developing-producers-with-sdk.html#kinesis-using-sdk-java-add-data-to-stream)
// in the Amazon Kinesis Data Streams Developer Guide.
//
// PutRecord returns the shard ID of where the data record was placed and the
// sequence number that was assigned to the data record.
//
// Sequence numbers increase over time and are specific to a shard within a
// stream, not across all shards within a stream. To guarantee strictly increasing
// ordering, write serially to a shard and use the SequenceNumberForOrdering
// parameter. For more information, see Adding Data to a Stream (https://docs.aws.amazon.com/kinesis/latest/dev/developing-producers-with-sdk.html#kinesis-using-sdk-java-add-data-to-stream)
// in the Amazon Kinesis Data Streams Developer Guide.
//
// After you write a record to a stream, you cannot modify that record or its
// order within the stream.
//
// If a PutRecord request cannot be processed because of insufficient provisioned
// throughput on the shard involved in the request, PutRecord throws ProvisionedThroughputExceededException.
//
// By default, data records are accessible for 24 hours from the time that they
// are added to a stream. You can use IncreaseStreamRetentionPeriod or DecreaseStreamRetentionPeriod
// to modify this retention period.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis's
// API operation PutRecord for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The requested resource could not be found. The stream might not be specified
//     correctly.
//
//   - InvalidArgumentException
//     A specified parameter exceeds its restrictions, is not supported, or can't
//     be used. For more information, see the returned message.
//
//   - ProvisionedThroughputExceededException
//     The request rate for the stream is too high, or the requested data is too
//     large for the available throughput. Reduce the frequency or size of your
//     requests. For more information, see Streams Limits (https://docs.aws.amazon.com/kinesis/latest/dev/service-sizes-and-limits.html)
//     in the Amazon Kinesis Data Streams Developer Guide, and Error Retries and
//     Exponential Backoff in Amazon Web Services (https://docs.aws.amazon.com/general/latest/gr/api-retries.html)
//     in the Amazon Web Services General Reference.
//
//   - KMSDisabledException
//     The request was rejected because the specified customer master key (CMK)
//     isn't enabled.
//
//   - KMSInvalidStateException
//     The request was rejected because the state of the specified resource isn't
//     valid for this request. For more information, see How Key State Affects Use
//     of a Customer Master Key (https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
//     in the Amazon Web Services Key Management Service Developer Guide.
//
//   - KMSAccessDeniedException
//     The ciphertext references a key that doesn't exist or that you don't have
//     access to.
//
//   - KMSNotFoundException
//     The request was rejected because the specified entity or resource can't be
//     found.
//
//   - KMSOptInRequired
//     The Amazon Web Services access key ID needs a subscription for the service.
//
//   - KMSThrottlingException
//     The request was denied due to request throttling. For more information about
//     throttling, see Limits (https://docs.aws.amazon.com/kms/latest/developerguide/limits.html#requests-per-second)
//     in the Amazon Web Services Key Management Service Developer Guide.
//
//   - AccessDeniedException
//     Specifies that you do not have the permissions required to perform this operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/PutRecord
func (c *Kinesis) PutRecord(input *PutRecordInput) (*PutRecordOutput, error) {
	req, out := c.PutRecordRequest(input)
	return out, req.Send()
}

// PutRecordWithContext is the same as PutRecord with the addition of
// the ability to pass a context and additional request options.
//
// See PutRecord for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kinesis) PutRecordWithContext(ctx aws.Context, input *PutRecordInput, opts ...request.Option) (*PutRecordOutput, error) {
	req, out := c.PutRecordRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutRecords = "PutRecords"

// PutRecordsRequest generates a "aws/request.Request" representing the
// client's request for the PutRecords operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutRecords for more information on using the PutRecords
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutRecordsRequest method.
//	req, resp := client.PutRecordsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/PutRecords
func (c *Kinesis) PutRecordsRequest(input *PutRecordsInput) (req *request.Request, output *PutRecordsOutput) {
	op := &request.Operation{
		Name:       opPutRecords,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutRecordsInput{}
	}

	output = &PutRecordsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutRecords API operation for Amazon Kinesis.
//
// Writes multiple data records into a Kinesis data stream in a single call
// (also referred to as a PutRecords request). Use this operation to send data
// into the stream for data ingestion and processing.
//
// When invoking this API, you must use either the StreamARN or the StreamName
// parameter, or both. It is recommended that you use the StreamARN input parameter
// when you invoke this API.
//
// Each PutRecords request can support up to 500 records. Each record in the
// request can be as large as 1 MiB, up to a limit of 5 MiB for the entire request,
// including partition keys. Each shard can support writes up to 1,000 records
// per second, up to a maximum data write total of 1 MiB per second.
//
// You must specify the name of the stream that captures, stores, and transports
// the data; and an array of request Records, with each record in the array
// requiring a partition key and data blob. The record size limit applies to
// the total size of the partition key and data blob.
//
// The data blob can be any type of data; for example, a segment from a log
// file, geographic/location data, website clickstream data, and so on.
//
// The partition key is used by Kinesis Data Streams as input to a hash function
// that maps the partition key and associated data to a specific shard. An MD5
// hash function is used to map partition keys to 128-bit integer values and
// to map associated data records to shards. As a result of this hashing mechanism,
// all data records with the same partition key map to the same shard within
// the stream. For more information, see Adding Data to a Stream (https://docs.aws.amazon.com/kinesis/latest/dev/developing-producers-with-sdk.html#kinesis-using-sdk-java-add-data-to-stream)
// in the Amazon Kinesis Data Streams Developer Guide.
//
// Each record in the Records array may include an optional parameter, ExplicitHashKey,
// which overrides the partition key to shard mapping. This parameter allows
// a data producer to determine explicitly the shard where the record is stored.
// For more information, see Adding Multiple Records with PutRecords (https://docs.aws.amazon.com/kinesis/latest/dev/developing-producers-with-sdk.html#kinesis-using-sdk-java-putrecords)
// in the Amazon Kinesis Data Streams Developer Guide.
//
// The PutRecords response includes an array of response Records. Each record
// in the response array directly correlates with a record in the request array
// using natural ordering, from the top to the bottom of the request and response.
// The response Records array always includes the same number of records as
// the request array.
//
// The response Records array includes both successfully and unsuccessfully
// processed records. Kinesis Data Streams attempts to process all records in
// each PutRecords request. A single record failure does not stop the processing
// of subsequent records. As a result, PutRecords doesn't guarantee the ordering
// of records. If you need to read records in the same order they are written
// to the stream, use PutRecord instead of PutRecords, and write to the same
// shard.
//
// A successfully processed record includes ShardId and SequenceNumber values.
// The ShardId parameter identifies the shard in the stream where the record
// is stored. The SequenceNumber parameter is an identifier assigned to the
// put record, unique to all records in the stream.
//
// An unsuccessfully processed record includes ErrorCode and ErrorMessage values.
// ErrorCode reflects the type of error and can be one of the following values:
// ProvisionedThroughputExceededException or InternalFailure. ErrorMessage provides
// more detailed information about the ProvisionedThroughputExceededException
// exception including the account ID, stream name, and shard ID of the record
// that was throttled. For more information about partially successful responses,
// see Adding Multiple Records with PutRecords (https://docs.aws.amazon.com/kinesis/latest/dev/kinesis-using-sdk-java-add-data-to-stream.html#kinesis-using-sdk-java-putrecords)
// in the Amazon Kinesis Data Streams Developer Guide.
//
// After you write a record to a stream, you cannot modify that record or its
// order within the stream.
//
// By default, data records are accessible for 24 hours from the time that they
// are added to a stream. You can use IncreaseStreamRetentionPeriod or DecreaseStreamRetentionPeriod
// to modify this retention period.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis's
// API operation PutRecords for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The requested resource could not be found. The stream might not be specified
//     correctly.
//
//   - InvalidArgumentException
//     A specified parameter exceeds its restrictions, is not supported, or can't
//     be used. For more information, see the returned message.
//
//   - ProvisionedThroughputExceededException
//     The request rate for the stream is too high, or the requested data is too
//     large for the available throughput. Reduce the frequency or size of your
//     requests. For more information, see Streams Limits (https://docs.aws.amazon.com/kinesis/latest/dev/service-sizes-and-limits.html)
//     in the Amazon Kinesis Data Streams Developer Guide, and Error Retries and
//     Exponential Backoff in Amazon Web Services (https://docs.aws.amazon.com/general/latest/gr/api-retries.html)
//     in the Amazon Web Services General Reference.
//
//   - KMSDisabledException
//     The request was rejected because the specified customer master key (CMK)
//     isn't enabled.
//
//   - KMSInvalidStateException
//     The request was rejected because the state of the specified resource isn't
//     valid for this request. For more information, see How Key State Affects Use
//     of a Customer Master Key (https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
//     in the Amazon Web Services Key Management Service Developer Guide.
//
//   - KMSAccessDeniedException
//     The ciphertext references a key that doesn't exist or that you don't have
//     access to.
//
//   - KMSNotFoundException
//     The request was rejected because the specified entity or resource can't be
//     found.
//
//   - KMSOptInRequired
//     The Amazon Web Services access key ID needs a subscription for the service.
//
//   - KMSThrottlingException
//     The request was denied due to request throttling. For more information about
//     throttling, see Limits (https://docs.aws.amazon.com/kms/latest/developerguide/limits.html#requests-per-second)
//     in the Amazon Web Services Key Management Service Developer Guide.
//
//   - AccessDeniedException
//     Specifies that you do not have the permissions required to perform this operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/PutRecords
func (c *Kinesis) PutRecords(input *PutRecordsInput) (*PutRecordsOutput, error) {
	req, out := c.PutRecordsRequest(input)
	return out, req.Send()
}

// PutRecordsWithContext is the same as PutRecords with the addition of
// the ability to pass a context and additional request options.
//
// See PutRecords for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kinesis) PutRecordsWithContext(ctx aws.Context, input *PutRecordsInput, opts ...request.Option) (*PutRecordsOutput, error) {
	req, out := c.PutRecordsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutResourcePolicy = "PutResourcePolicy"

// PutResourcePolicyRequest generates a "aws/request.Request" representing the
// client's request for the PutResourcePolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutResourcePolicy for more information on using the PutResourcePolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutResourcePolicyRequest method.
//	req, resp := client.PutResourcePolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/PutResourcePolicy
func (c *Kinesis) PutResourcePolicyRequest(input *PutResourcePolicyInput) (req *request.Request, output *PutResourcePolicyOutput) {
	op := &request.Operation{
		Name:       opPutResourcePolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutResourcePolicyInput{}
	}

	output = &PutResourcePolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutResourcePolicy API operation for Amazon Kinesis.
//
// Attaches a resource-based policy to a data stream or registered consumer.
// If you are using an identity other than the root user of the Amazon Web Services
// account that owns the resource, the calling identity must have the PutResourcePolicy
// permissions on the specified Kinesis Data Streams resource and belong to
// the owner's account in order to use this operation. If you don't have PutResourcePolicy
// permissions, Amazon Kinesis Data Streams returns a 403 Access Denied error.
// If you receive a ResourceNotFoundException, check to see if you passed a
// valid stream or consumer resource.
//
// Request patterns can be one of the following:
//
//   - Data stream pattern: arn:aws.*:kinesis:.*:\d{12}:.*stream/\S+
//
//   - Consumer pattern: ^(arn):aws.*:kinesis:.*:\d{12}:.*stream\/[a-zA-Z0-9_.-]+\/consumer\/[a-zA-Z0-9_.-]+:[0-9]+
//
// For more information, see Controlling Access to Amazon Kinesis Data Streams
// Resources Using IAM (https://docs.aws.amazon.com/streams/latest/dev/controlling-access.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis's
// API operation PutResourcePolicy for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     Specifies that you do not have the permissions required to perform this operation.
//
//   - ResourceNotFoundException
//     The requested resource could not be found. The stream might not be specified
//     correctly.
//
//   - LimitExceededException
//     The requested resource exceeds the maximum number allowed, or the number
//     of concurrent stream requests exceeds the maximum number allowed.
//
//   - InvalidArgumentException
//     A specified parameter exceeds its restrictions, is not supported, or can't
//     be used. For more information, see the returned message.
//
//   - ResourceInUseException
//     The resource is not available for this operation. For successful operation,
//     the resource must be in the ACTIVE state.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/PutResourcePolicy
func (c *Kinesis) PutResourcePolicy(input *PutResourcePolicyInput) (*PutResourcePolicyOutput, error) {
	req, out := c.PutResourcePolicyRequest(input)
	return out, req.Send()
}

// PutResourcePolicyWithContext is the same as PutResourcePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See PutResourcePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kinesis) PutResourcePolicyWithContext(ctx aws.Context, input *PutResourcePolicyInput, opts ...request.Option) (*PutResourcePolicyOutput, error) {
	req, out := c.PutResourcePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRegisterStreamConsumer = "RegisterStreamConsumer"

// RegisterStreamConsumerRequest generates a "aws/request.Request" representing the
// client's request for the RegisterStreamConsumer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RegisterStreamConsumer for more information on using the RegisterStreamConsumer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RegisterStreamConsumerRequest method.
//	req, resp := client.RegisterStreamConsumerRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/RegisterStreamConsumer
func (c *Kinesis) RegisterStreamConsumerRequest(input *RegisterStreamConsumerInput) (req *request.Request, output *RegisterStreamConsumerOutput) {
	op := &request.Operation{
		Name:       opRegisterStreamConsumer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RegisterStreamConsumerInput{}
	}

	output = &RegisterStreamConsumerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RegisterStreamConsumer API operation for Amazon Kinesis.
//
// Registers a consumer with a Kinesis data stream. When you use this operation,
// the consumer you register can then call SubscribeToShard to receive data
// from the stream using enhanced fan-out, at a rate of up to 2 MiB per second
// for every shard you subscribe to. This rate is unaffected by the total number
// of consumers that read from the same stream.
//
// You can register up to 20 consumers per stream. A given consumer can only
// be registered with one stream at a time.
//
// For an example of how to use this operations, see Enhanced Fan-Out Using
// the Kinesis Data Streams API (/streams/latest/dev/building-enhanced-consumers-api.html).
//
// The use of this operation has a limit of five transactions per second per
// account. Also, only 5 consumers can be created simultaneously. In other words,
// you cannot have more than 5 consumers in a CREATING status at the same time.
// Registering a 6th consumer while there are 5 in a CREATING status results
// in a LimitExceededException.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis's
// API operation RegisterStreamConsumer for usage and error information.
//
// Returned Error Types:
//
//   - InvalidArgumentException
//     A specified parameter exceeds its restrictions, is not supported, or can't
//     be used. For more information, see the returned message.
//
//   - LimitExceededException
//     The requested resource exceeds the maximum number allowed, or the number
//     of concurrent stream requests exceeds the maximum number allowed.
//
//   - ResourceInUseException
//     The resource is not available for this operation. For successful operation,
//     the resource must be in the ACTIVE state.
//
//   - ResourceNotFoundException
//     The requested resource could not be found. The stream might not be specified
//     correctly.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/RegisterStreamConsumer
func (c *Kinesis) RegisterStreamConsumer(input *RegisterStreamConsumerInput) (*RegisterStreamConsumerOutput, error) {
	req, out := c.RegisterStreamConsumerRequest(input)
	return out, req.Send()
}

// RegisterStreamConsumerWithContext is the same as RegisterStreamConsumer with the addition of
// the ability to pass a context and additional request options.
//
// See RegisterStreamConsumer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kinesis) RegisterStreamConsumerWithContext(ctx aws.Context, input *RegisterStreamConsumerInput, opts ...request.Option) (*RegisterStreamConsumerOutput, error) {
	req, out := c.RegisterStreamConsumerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRemoveTagsFromStream = "RemoveTagsFromStream"

// RemoveTagsFromStreamRequest generates a "aws/request.Request" representing the
// client's request for the RemoveTagsFromStream operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RemoveTagsFromStream for more information on using the RemoveTagsFromStream
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RemoveTagsFromStreamRequest method.
//	req, resp := client.RemoveTagsFromStreamRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/RemoveTagsFromStream
func (c *Kinesis) RemoveTagsFromStreamRequest(input *RemoveTagsFromStreamInput) (req *request.Request, output *RemoveTagsFromStreamOutput) {
	op := &request.Operation{
		Name:       opRemoveTagsFromStream,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RemoveTagsFromStreamInput{}
	}

	output = &RemoveTagsFromStreamOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RemoveTagsFromStream API operation for Amazon Kinesis.
//
// Removes tags from the specified Kinesis data stream. Removed tags are deleted
// and cannot be recovered after this operation successfully completes.
//
// When invoking this API, you must use either the StreamARN or the StreamName
// parameter, or both. It is recommended that you use the StreamARN input parameter
// when you invoke this API.
//
// If you specify a tag that does not exist, it is ignored.
//
// RemoveTagsFromStream has a limit of five transactions per second per account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis's
// API operation RemoveTagsFromStream for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The requested resource could not be found. The stream might not be specified
//     correctly.
//
//   - ResourceInUseException
//     The resource is not available for this operation. For successful operation,
//     the resource must be in the ACTIVE state.
//
//   - InvalidArgumentException
//     A specified parameter exceeds its restrictions, is not supported, or can't
//     be used. For more information, see the returned message.
//
//   - LimitExceededException
//     The requested resource exceeds the maximum number allowed, or the number
//     of concurrent stream requests exceeds the maximum number allowed.
//
//   - AccessDeniedException
//     Specifies that you do not have the permissions required to perform this operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/RemoveTagsFromStream
func (c *Kinesis) RemoveTagsFromStream(input *RemoveTagsFromStreamInput) (*RemoveTagsFromStreamOutput, error) {
	req, out := c.RemoveTagsFromStreamRequest(input)
	return out, req.Send()
}

// RemoveTagsFromStreamWithContext is the same as RemoveTagsFromStream with the addition of
// the ability to pass a context and additional request options.
//
// See RemoveTagsFromStream for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kinesis) RemoveTagsFromStreamWithContext(ctx aws.Context, input *RemoveTagsFromStreamInput, opts ...request.Option) (*RemoveTagsFromStreamOutput, error) {
	req, out := c.RemoveTagsFromStreamRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSplitShard = "SplitShard"

// SplitShardRequest generates a "aws/request.Request" representing the
// client's request for the SplitShard operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SplitShard for more information on using the SplitShard
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the SplitShardRequest method.
//	req, resp := client.SplitShardRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/SplitShard
func (c *Kinesis) SplitShardRequest(input *SplitShardInput) (req *request.Request, output *SplitShardOutput) {
	op := &request.Operation{
		Name:       opSplitShard,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SplitShardInput{}
	}

	output = &SplitShardOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// SplitShard API operation for Amazon Kinesis.
//
// Splits a shard into two new shards in the Kinesis data stream, to increase
// the stream's capacity to ingest and transport data. SplitShard is called
// when there is a need to increase the overall capacity of a stream because
// of an expected increase in the volume of data records being ingested. This
// API is only supported for the data streams with the provisioned capacity
// mode.
//
// When invoking this API, you must use either the StreamARN or the StreamName
// parameter, or both. It is recommended that you use the StreamARN input parameter
// when you invoke this API.
//
// You can also use SplitShard when a shard appears to be approaching its maximum
// utilization; for example, the producers sending data into the specific shard
// are suddenly sending more than previously anticipated. You can also call
// SplitShard to increase stream capacity, so that more Kinesis Data Streams
// applications can simultaneously read data from the stream for real-time processing.
//
// You must specify the shard to be split and the new hash key, which is the
// position in the shard where the shard gets split in two. In many cases, the
// new hash key might be the average of the beginning and ending hash key, but
// it can be any hash key value in the range being mapped into the shard. For
// more information, see Split a Shard (https://docs.aws.amazon.com/kinesis/latest/dev/kinesis-using-sdk-java-resharding-split.html)
// in the Amazon Kinesis Data Streams Developer Guide.
//
// You can use DescribeStreamSummary and the ListShards APIs to determine the
// shard ID and hash key values for the ShardToSplit and NewStartingHashKey
// parameters that are specified in the SplitShard request.
//
// SplitShard is an asynchronous operation. Upon receiving a SplitShard request,
// Kinesis Data Streams immediately returns a response and sets the stream status
// to UPDATING. After the operation is completed, Kinesis Data Streams sets
// the stream status to ACTIVE. Read and write operations continue to work while
// the stream is in the UPDATING state.
//
// You can use DescribeStreamSummary to check the status of the stream, which
// is returned in StreamStatus. If the stream is in the ACTIVE state, you can
// call SplitShard.
//
// If the specified stream does not exist, DescribeStreamSummary returns a ResourceNotFoundException.
// If you try to create more shards than are authorized for your account, you
// receive a LimitExceededException.
//
// For the default shard limit for an Amazon Web Services account, see Kinesis
// Data Streams Limits (https://docs.aws.amazon.com/kinesis/latest/dev/service-sizes-and-limits.html)
// in the Amazon Kinesis Data Streams Developer Guide. To increase this limit,
// contact Amazon Web Services Support (https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html).
//
// If you try to operate on too many streams simultaneously using CreateStream,
// DeleteStream, MergeShards, and/or SplitShard, you receive a LimitExceededException.
//
// SplitShard has a limit of five transactions per second per account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis's
// API operation SplitShard for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The requested resource could not be found. The stream might not be specified
//     correctly.
//
//   - ResourceInUseException
//     The resource is not available for this operation. For successful operation,
//     the resource must be in the ACTIVE state.
//
//   - InvalidArgumentException
//     A specified parameter exceeds its restrictions, is not supported, or can't
//     be used. For more information, see the returned message.
//
//   - LimitExceededException
//     The requested resource exceeds the maximum number allowed, or the number
//     of concurrent stream requests exceeds the maximum number allowed.
//
//   - ValidationException
//     Specifies that you tried to invoke this API for a data stream with the on-demand
//     capacity mode. This API is only supported for data streams with the provisioned
//     capacity mode.
//
//   - AccessDeniedException
//     Specifies that you do not have the permissions required to perform this operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/SplitShard
func (c *Kinesis) SplitShard(input *SplitShardInput) (*SplitShardOutput, error) {
	req, out := c.SplitShardRequest(input)
	return out, req.Send()
}

// SplitShardWithContext is the same as SplitShard with the addition of
// the ability to pass a context and additional request options.
//
// See SplitShard for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kinesis) SplitShardWithContext(ctx aws.Context, input *SplitShardInput, opts ...request.Option) (*SplitShardOutput, error) {
	req, out := c.SplitShardRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartStreamEncryption = "StartStreamEncryption"

// StartStreamEncryptionRequest generates a "aws/request.Request" representing the
// client's request for the StartStreamEncryption operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartStreamEncryption for more information on using the StartStreamEncryption
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartStreamEncryptionRequest method.
//	req, resp := client.StartStreamEncryptionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/StartStreamEncryption
func (c *Kinesis) StartStreamEncryptionRequest(input *StartStreamEncryptionInput) (req *request.Request, output *StartStreamEncryptionOutput) {
	op := &request.Operation{
		Name:       opStartStreamEncryption,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartStreamEncryptionInput{}
	}

	output = &StartStreamEncryptionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StartStreamEncryption API operation for Amazon Kinesis.
//
// Enables or updates server-side encryption using an Amazon Web Services KMS
// key for a specified stream.
//
// When invoking this API, you must use either the StreamARN or the StreamName
// parameter, or both. It is recommended that you use the StreamARN input parameter
// when you invoke this API.
//
// Starting encryption is an asynchronous operation. Upon receiving the request,
// Kinesis Data Streams returns immediately and sets the status of the stream
// to UPDATING. After the update is complete, Kinesis Data Streams sets the
// status of the stream back to ACTIVE. Updating or applying encryption normally
// takes a few seconds to complete, but it can take minutes. You can continue
// to read and write data to your stream while its status is UPDATING. Once
// the status of the stream is ACTIVE, encryption begins for records written
// to the stream.
//
// API Limits: You can successfully apply a new Amazon Web Services KMS key
// for server-side encryption 25 times in a rolling 24-hour period.
//
// Note: It can take up to 5 seconds after the stream is in an ACTIVE status
// before all records written to the stream are encrypted. After you enable
// encryption, you can verify that encryption is applied by inspecting the API
// response from PutRecord or PutRecords.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis's
// API operation StartStreamEncryption for usage and error information.
//
// Returned Error Types:
//
//   - InvalidArgumentException
//     A specified parameter exceeds its restrictions, is not supported, or can't
//     be used. For more information, see the returned message.
//
//   - LimitExceededException
//     The requested resource exceeds the maximum number allowed, or the number
//     of concurrent stream requests exceeds the maximum number allowed.
//
//   - ResourceInUseException
//     The resource is not available for this operation. For successful operation,
//     the resource must be in the ACTIVE state.
//
//   - ResourceNotFoundException
//     The requested resource could not be found. The stream might not be specified
//     correctly.
//
//   - KMSDisabledException
//     The request was rejected because the specified customer master key (CMK)
//     isn't enabled.
//
//   - KMSInvalidStateException
//     The request was rejected because the state of the specified resource isn't
//     valid for this request. For more information, see How Key State Affects Use
//     of a Customer Master Key (https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
//     in the Amazon Web Services Key Management Service Developer Guide.
//
//   - KMSAccessDeniedException
//     The ciphertext references a key that doesn't exist or that you don't have
//     access to.
//
//   - KMSNotFoundException
//     The request was rejected because the specified entity or resource can't be
//     found.
//
//   - KMSOptInRequired
//     The Amazon Web Services access key ID needs a subscription for the service.
//
//   - KMSThrottlingException
//     The request was denied due to request throttling. For more information about
//     throttling, see Limits (https://docs.aws.amazon.com/kms/latest/developerguide/limits.html#requests-per-second)
//     in the Amazon Web Services Key Management Service Developer Guide.
//
//   - AccessDeniedException
//     Specifies that you do not have the permissions required to perform this operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/StartStreamEncryption
func (c *Kinesis) StartStreamEncryption(input *StartStreamEncryptionInput) (*StartStreamEncryptionOutput, error) {
	req, out := c.StartStreamEncryptionRequest(input)
	return out, req.Send()
}

// StartStreamEncryptionWithContext is the same as StartStreamEncryption with the addition of
// the ability to pass a context and additional request options.
//
// See StartStreamEncryption for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kinesis) StartStreamEncryptionWithContext(ctx aws.Context, input *StartStreamEncryptionInput, opts ...request.Option) (*StartStreamEncryptionOutput, error) {
	req, out := c.StartStreamEncryptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopStreamEncryption = "StopStreamEncryption"

// StopStreamEncryptionRequest generates a "aws/request.Request" representing the
// client's request for the StopStreamEncryption operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopStreamEncryption for more information on using the StopStreamEncryption
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StopStreamEncryptionRequest method.
//	req, resp := client.StopStreamEncryptionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/StopStreamEncryption
func (c *Kinesis) StopStreamEncryptionRequest(input *StopStreamEncryptionInput) (req *request.Request, output *StopStreamEncryptionOutput) {
	op := &request.Operation{
		Name:       opStopStreamEncryption,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopStreamEncryptionInput{}
	}

	output = &StopStreamEncryptionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StopStreamEncryption API operation for Amazon Kinesis.
//
// Disables server-side encryption for a specified stream.
//
// When invoking this API, you must use either the StreamARN or the StreamName
// parameter, or both. It is recommended that you use the StreamARN input parameter
// when you invoke this API.
//
// Stopping encryption is an asynchronous operation. Upon receiving the request,
// Kinesis Data Streams returns immediately and sets the status of the stream
// to UPDATING. After the update is complete, Kinesis Data Streams sets the
// status of the stream back to ACTIVE. Stopping encryption normally takes a
// few seconds to complete, but it can take minutes. You can continue to read
// and write data to your stream while its status is UPDATING. Once the status
// of the stream is ACTIVE, records written to the stream are no longer encrypted
// by Kinesis Data Streams.
//
// API Limits: You can successfully disable server-side encryption 25 times
// in a rolling 24-hour period.
//
// Note: It can take up to 5 seconds after the stream is in an ACTIVE status
// before all records written to the stream are no longer subject to encryption.
// After you disabled encryption, you can verify that encryption is not applied
// by inspecting the API response from PutRecord or PutRecords.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis's
// API operation StopStreamEncryption for usage and error information.
//
// Returned Error Types:
//
//   - InvalidArgumentException
//     A specified parameter exceeds its restrictions, is not supported, or can't
//     be used. For more information, see the returned message.
//
//   - LimitExceededException
//     The requested resource exceeds the maximum number allowed, or the number
//     of concurrent stream requests exceeds the maximum number allowed.
//
//   - ResourceInUseException
//     The resource is not available for this operation. For successful operation,
//     the resource must be in the ACTIVE state.
//
//   - ResourceNotFoundException
//     The requested resource could not be found. The stream might not be specified
//     correctly.
//
//   - AccessDeniedException
//     Specifies that you do not have the permissions required to perform this operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/StopStreamEncryption
func (c *Kinesis) StopStreamEncryption(input *StopStreamEncryptionInput) (*StopStreamEncryptionOutput, error) {
	req, out := c.StopStreamEncryptionRequest(input)
	return out, req.Send()
}

// StopStreamEncryptionWithContext is the same as StopStreamEncryption with the addition of
// the ability to pass a context and additional request options.
//
// See StopStreamEncryption for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kinesis) StopStreamEncryptionWithContext(ctx aws.Context, input *StopStreamEncryptionInput, opts ...request.Option) (*StopStreamEncryptionOutput, error) {
	req, out := c.StopStreamEncryptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSubscribeToShard = "SubscribeToShard"

// SubscribeToShardRequest generates a "aws/request.Request" representing the
// client's request for the SubscribeToShard operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SubscribeToShard for more information on using the SubscribeToShard
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the SubscribeToShardRequest method.
//	req, resp := client.SubscribeToShardRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/SubscribeToShard
func (c *Kinesis) SubscribeToShardRequest(input *SubscribeToShardInput) (req *request.Request, output *SubscribeToShardOutput) {
	op := &request.Operation{
		Name:       opSubscribeToShard,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SubscribeToShardInput{}
	}

	output = &SubscribeToShardOutput{}
	req = c.newRequest(op, input, output)

	es := NewSubscribeToShardEventStream()
	req.Handlers.Unmarshal.PushBack(es.setStreamCloser)
	output.EventStream = es

	req.Handlers.Send.Swap(client.LogHTTPResponseHandler.Name, client.LogHTTPResponseHeaderHandler)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, rest.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBack(es.runOutputStream)
	es.output = output
	req.Handlers.Unmarshal.PushBack(es.recvInitialEvent)
	req.Handlers.Unmarshal.PushBack(es.runOnStreamPartClose)
	return
}

// SubscribeToShard API operation for Amazon Kinesis.
//
// This operation establishes an HTTP/2 connection between the consumer you
// specify in the ConsumerARN parameter and the shard you specify in the ShardId
// parameter. After the connection is successfully established, Kinesis Data
// Streams pushes records from the shard to the consumer over this connection.
// Before you call this operation, call RegisterStreamConsumer to register the
// consumer with Kinesis Data Streams.
//
// When the SubscribeToShard call succeeds, your consumer starts receiving events
// of type SubscribeToShardEvent over the HTTP/2 connection for up to 5 minutes,
// after which time you need to call SubscribeToShard again to renew the subscription
// if you want to continue to receive records.
//
// You can make one call to SubscribeToShard per second per registered consumer
// per shard. For example, if you have a 4000 shard stream and two registered
// stream consumers, you can make one SubscribeToShard request per second for
// each combination of shard and registered consumer, allowing you to subscribe
// both consumers to all 4000 shards in one second.
//
// If you call SubscribeToShard again with the same ConsumerARN and ShardId
// within 5 seconds of a successful call, you'll get a ResourceInUseException.
// If you call SubscribeToShard 5 seconds or more after a successful call, the
// second call takes over the subscription and the previous connection expires
// or fails with a ResourceInUseException.
//
// For an example of how to use this operations, see Enhanced Fan-Out Using
// the Kinesis Data Streams API (/streams/latest/dev/building-enhanced-consumers-api.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis's
// API operation SubscribeToShard for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The requested resource could not be found. The stream might not be specified
//     correctly.
//
//   - InvalidArgumentException
//     A specified parameter exceeds its restrictions, is not supported, or can't
//     be used. For more information, see the returned message.
//
//   - ResourceInUseException
//     The resource is not available for this operation. For successful operation,
//     the resource must be in the ACTIVE state.
//
//   - LimitExceededException
//     The requested resource exceeds the maximum number allowed, or the number
//     of concurrent stream requests exceeds the maximum number allowed.
//
//   - AccessDeniedException
//     Specifies that you do not have the permissions required to perform this operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/SubscribeToShard
func (c *Kinesis) SubscribeToShard(input *SubscribeToShardInput) (*SubscribeToShardOutput, error) {
	req, out := c.SubscribeToShardRequest(input)
	return out, req.Send()
}

// SubscribeToShardWithContext is the same as SubscribeToShard with the addition of
// the ability to pass a context and additional request options.
//
// See SubscribeToShard for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kinesis) SubscribeToShardWithContext(ctx aws.Context, input *SubscribeToShardInput, opts ...request.Option) (*SubscribeToShardOutput, error) {
	req, out := c.SubscribeToShardRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

var _ awserr.Error
var _ time.Time

// SubscribeToShardEventStream provides the event stream handling for the SubscribeToShard.
//
// For testing and mocking the event stream this type should be initialized via
// the NewSubscribeToShardEventStream constructor function. Using the functional options
// to pass in nested mock behavior.
type SubscribeToShardEventStream struct {

	// Reader is the EventStream reader for the SubscribeToShardEventStream
	// events. This value is automatically set by the SDK when the API call is made
	// Use this member when unit testing your code with the SDK to mock out the
	// EventStream Reader.
	//
	// Must not be nil.
	Reader SubscribeToShardEventStreamReader

	outputReader io.ReadCloser
	output       *SubscribeToShardOutput

	// StreamCloser is the io.Closer for the EventStream connection. For HTTP
	// EventStream this is the response Body. The stream will be closed when
	// the Close method of the EventStream is called.
	StreamCloser io.Closer

	done      chan struct{}
	closeOnce sync.Once
	err       *eventstreamapi.OnceError
}

// NewSubscribeToShardEventStream initializes an SubscribeToShardEventStream.
// This function should only be used for testing and mocking the SubscribeToShardEventStream
// stream within your application.
//
// The Reader member must be set before reading events from the stream.
//
// The StreamCloser member should be set to the underlying io.Closer,
// (e.g. http.Response.Body), that will be closed when the stream Close method
// is called.
//
//	es := NewSubscribeToShardEventStream(func(o *SubscribeToShardEventStream){
//	    es.Reader = myMockStreamReader
//	    es.StreamCloser = myMockStreamCloser
//	})
func NewSubscribeToShardEventStream(opts ...func(*SubscribeToShardEventStream)) *SubscribeToShardEventStream {
	es := &SubscribeToShardEventStream{
		done: make(chan struct{}),
		err:  eventstreamapi.NewOnceError(),
	}

	for _, fn := range opts {
		fn(es)
	}

	return es
}

func (es *SubscribeToShardEventStream) setStreamCloser(r *request.Request) {
	es.StreamCloser = r.HTTPResponse.Body
}

func (es *SubscribeToShardEventStream) runOnStreamPartClose(r *request.Request) {
	if es.done == nil {
		return
	}
	go es.waitStreamPartClose()

}

func (es *SubscribeToShardEventStream) waitStreamPartClose() {
	var outputErrCh <-chan struct{}
	if v, ok := es.Reader.(interface{ ErrorSet() <-chan struct{} }); ok {
		outputErrCh = v.ErrorSet()
	}
	var outputClosedCh <-chan struct{}
	if v, ok := es.Reader.(interface{ Closed() <-chan struct{} }); ok {
		outputClosedCh = v.Closed()
	}

	select {
	case <-es.done:
	case <-outputErrCh:
		es.err.SetError(es.Reader.Err())
		es.Close()
	case <-outputClosedCh:
		if err := es.Reader.Err(); err != nil {
			es.err.SetError(es.Reader.Err())
		}
		es.Close()
	}
}

type eventTypeForSubscribeToShardEventStreamOutputEvent struct {
	unmarshalerForEvent func(string) (eventstreamapi.Unmarshaler, error)
	output              *SubscribeToShardOutput
}

func (e eventTypeForSubscribeToShardEventStreamOutputEvent) UnmarshalerForEventName(eventType string) (eventstreamapi.Unmarshaler, error) {
	if eventType == "initial-response" {
		return e.output, nil
	}
	return e.unmarshalerForEvent(eventType)
}

// Events returns a channel to read events from.
//
// These events are:
//
//   - SubscribeToShardEvent
//   - SubscribeToShardEventStreamUnknownEvent
func (es *SubscribeToShardEventStream) Events() <-chan SubscribeToShardEventStreamEvent {
	return es.Reader.Events()
}

func (es *SubscribeToShardEventStream) runOutputStream(r *request.Request) {
	var opts []func(*eventstream.Decoder)
	if r.Config.Logger != nil && r.Config.LogLevel.Matches(aws.LogDebugWithEventStreamBody) {
		opts = append(opts, eventstream.DecodeWithLogger(r.Config.Logger))
	}

	unmarshalerForEvent := unmarshalerForSubscribeToShardEventStreamEvent{
		metadata: protocol.ResponseMetadata{
			StatusCode: r.HTTPResponse.StatusCode,
			RequestID:  r.RequestID,
		},
	}.UnmarshalerForEventName
	unmarshalerForEvent = eventTypeForSubscribeToShardEventStreamOutputEvent{
		unmarshalerForEvent: unmarshalerForEvent,
		output:              es.output,
	}.UnmarshalerForEventName

	decoder := eventstream.NewDecoder(r.HTTPResponse.Body, opts...)
	eventReader := eventstreamapi.NewEventReader(decoder,
		protocol.HandlerPayloadUnmarshal{
			Unmarshalers: r.Handlers.UnmarshalStream,
		},
		unmarshalerForEvent,
	)

	es.outputReader = r.HTTPResponse.Body
	es.Reader = newReadSubscribeToShardEventStream(eventReader)
}
func (es *SubscribeToShardEventStream) recvInitialEvent(r *request.Request) {
	// Wait for the initial response event, which must be the first
	// event to be received from the API.
	select {
	case event, ok := <-es.Events():
		if !ok {
			return
		}

		v, ok := event.(*SubscribeToShardOutput)
		if !ok || v == nil {
			r.Error = awserr.New(
				request.ErrCodeSerialization,
				fmt.Sprintf("invalid event, %T, expect %T, %v",
					event, (*SubscribeToShardOutput)(nil), v),
				nil,
			)
			return
		}

		*es.output = *v
		es.output.EventStream = es
	}
}

// Close closes the stream. This will also cause the stream to be closed.
// Close must be called when done using the stream API. Not calling Close
// may result in resource leaks.
//
// You can use the closing of the Reader's Events channel to terminate your
// application's read from the API's stream.
func (es *SubscribeToShardEventStream) Close() (err error) {
	es.closeOnce.Do(es.safeClose)
	return es.Err()
}

func (es *SubscribeToShardEventStream) safeClose() {
	if es.done != nil {
		close(es.done)
	}

	es.Reader.Close()
	if es.outputReader != nil {
		es.outputReader.Close()
	}

	es.StreamCloser.Close()
}

// Err returns any error that occurred while reading or writing EventStream
// Events from the service API's response. Returns nil if there were no errors.
func (es *SubscribeToShardEventStream) Err() error {
	if err := es.err.Err(); err != nil {
		return err
	}
	if err := es.Reader.Err(); err != nil {
		return err
	}

	return nil
}

const opUpdateShardCount = "UpdateShardCount"

// UpdateShardCountRequest generates a "aws/request.Request" representing the
// client's request for the UpdateShardCount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateShardCount for more information on using the UpdateShardCount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateShardCountRequest method.
//	req, resp := client.UpdateShardCountRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/UpdateShardCount
func (c *Kinesis) UpdateShardCountRequest(input *UpdateShardCountInput) (req *request.Request, output *UpdateShardCountOutput) {
	op := &request.Operation{
		Name:       opUpdateShardCount,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateShardCountInput{}
	}

	output = &UpdateShardCountOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateShardCount API operation for Amazon Kinesis.
//
// Updates the shard count of the specified stream to the specified number of
// shards. This API is only supported for the data streams with the provisioned
// capacity mode.
//
// When invoking this API, you must use either the StreamARN or the StreamName
// parameter, or both. It is recommended that you use the StreamARN input parameter
// when you invoke this API.
//
// Updating the shard count is an asynchronous operation. Upon receiving the
// request, Kinesis Data Streams returns immediately and sets the status of
// the stream to UPDATING. After the update is complete, Kinesis Data Streams
// sets the status of the stream back to ACTIVE. Depending on the size of the
// stream, the scaling action could take a few minutes to complete. You can
// continue to read and write data to your stream while its status is UPDATING.
//
// To update the shard count, Kinesis Data Streams performs splits or merges
// on individual shards. This can cause short-lived shards to be created, in
// addition to the final shards. These short-lived shards count towards your
// total shard limit for your account in the Region.
//
// When using this operation, we recommend that you specify a target shard count
// that is a multiple of 25% (25%, 50%, 75%, 100%). You can specify any target
// value within your shard limit. However, if you specify a target that isn't
// a multiple of 25%, the scaling action might take longer to complete.
//
// This operation has the following default limits. By default, you cannot do
// the following:
//
//   - Scale more than ten times per rolling 24-hour period per stream
//
//   - Scale up to more than double your current shard count for a stream
//
//   - Scale down below half your current shard count for a stream
//
//   - Scale up to more than 10000 shards in a stream
//
//   - Scale a stream with more than 10000 shards down unless the result is
//     less than 10000 shards
//
//   - Scale up to more than the shard limit for your account
//
//   - Make over 10 TPS. TPS over 10 will trigger the LimitExceededException
//
// For the default limits for an Amazon Web Services account, see Streams Limits
// (https://docs.aws.amazon.com/kinesis/latest/dev/service-sizes-and-limits.html)
// in the Amazon Kinesis Data Streams Developer Guide. To request an increase
// in the call rate limit, the shard limit for this API, or your overall shard
// limit, use the limits form (https://console.aws.amazon.com/support/v1#/case/create?issueType=service-limit-increase&limitType=service-code-kinesis).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis's
// API operation UpdateShardCount for usage and error information.
//
// Returned Error Types:
//
//   - InvalidArgumentException
//     A specified parameter exceeds its restrictions, is not supported, or can't
//     be used. For more information, see the returned message.
//
//   - LimitExceededException
//     The requested resource exceeds the maximum number allowed, or the number
//     of concurrent stream requests exceeds the maximum number allowed.
//
//   - ResourceInUseException
//     The resource is not available for this operation. For successful operation,
//     the resource must be in the ACTIVE state.
//
//   - ResourceNotFoundException
//     The requested resource could not be found. The stream might not be specified
//     correctly.
//
//   - ValidationException
//     Specifies that you tried to invoke this API for a data stream with the on-demand
//     capacity mode. This API is only supported for data streams with the provisioned
//     capacity mode.
//
//   - AccessDeniedException
//     Specifies that you do not have the permissions required to perform this operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/UpdateShardCount
func (c *Kinesis) UpdateShardCount(input *UpdateShardCountInput) (*UpdateShardCountOutput, error) {
	req, out := c.UpdateShardCountRequest(input)
	return out, req.Send()
}

// UpdateShardCountWithContext is the same as UpdateShardCount with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateShardCount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kinesis) UpdateShardCountWithContext(ctx aws.Context, input *UpdateShardCountInput, opts ...request.Option) (*UpdateShardCountOutput, error) {
	req, out := c.UpdateShardCountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateStreamMode = "UpdateStreamMode"

// UpdateStreamModeRequest generates a "aws/request.Request" representing the
// client's request for the UpdateStreamMode operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateStreamMode for more information on using the UpdateStreamMode
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateStreamModeRequest method.
//	req, resp := client.UpdateStreamModeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/UpdateStreamMode
func (c *Kinesis) UpdateStreamModeRequest(input *UpdateStreamModeInput) (req *request.Request, output *UpdateStreamModeOutput) {
	op := &request.Operation{
		Name:       opUpdateStreamMode,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateStreamModeInput{}
	}

	output = &UpdateStreamModeOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateStreamMode API operation for Amazon Kinesis.
//
// Updates the capacity mode of the data stream. Currently, in Kinesis Data
// Streams, you can choose between an on-demand capacity mode and a provisioned
// capacity mode for your data stream.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis's
// API operation UpdateStreamMode for usage and error information.
//
// Returned Error Types:
//
//   - InvalidArgumentException
//     A specified parameter exceeds its restrictions, is not supported, or can't
//     be used. For more information, see the returned message.
//
//   - LimitExceededException
//     The requested resource exceeds the maximum number allowed, or the number
//     of concurrent stream requests exceeds the maximum number allowed.
//
//   - ResourceInUseException
//     The resource is not available for this operation. For successful operation,
//     the resource must be in the ACTIVE state.
//
//   - ResourceNotFoundException
//     The requested resource could not be found. The stream might not be specified
//     correctly.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/UpdateStreamMode
func (c *Kinesis) UpdateStreamMode(input *UpdateStreamModeInput) (*UpdateStreamModeOutput, error) {
	req, out := c.UpdateStreamModeRequest(input)
	return out, req.Send()
}

// UpdateStreamModeWithContext is the same as UpdateStreamMode with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateStreamMode for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kinesis) UpdateStreamModeWithContext(ctx aws.Context, input *UpdateStreamModeInput, opts ...request.Option) (*UpdateStreamModeOutput, error) {
	req, out := c.UpdateStreamModeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Specifies that you do not have the permissions required to perform this operation.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Represents the input for AddTagsToStream.
type AddTagsToStreamInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the stream.
	StreamARN *string `min:"1" type:"string"`

	// The name of the stream.
	StreamName *string `min:"1" type:"string"`

	// A set of up to 10 key-value pairs to use to create the tags.
	//
	// Tags is a required field
	Tags map[string]*string `min:"1" type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddTagsToStreamInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddTagsToStreamInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddTagsToStreamInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddTagsToStreamInput"}
	if s.StreamARN != nil && len(*s.StreamARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StreamARN", 1))
	}
	if s.StreamName != nil && len(*s.StreamName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StreamName", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStreamARN sets the StreamARN field's value.
func (s *AddTagsToStreamInput) SetStreamARN(v string) *AddTagsToStreamInput {
	s.StreamARN = &v
	return s
}

// SetStreamName sets the StreamName field's value.
func (s *AddTagsToStreamInput) SetStreamName(v string) *AddTagsToStreamInput {
	s.StreamName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *AddTagsToStreamInput) SetTags(v map[string]*string) *AddTagsToStreamInput {
	s.Tags = v
	return s
}

type AddTagsToStreamOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddTagsToStreamOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddTagsToStreamOutput) GoString() string {
	return s.String()
}

// Output parameter of the GetRecords API. The existing child shard of the current
// shard.
type ChildShard struct {
	_ struct{} `type:"structure"`

	// The range of possible hash key values for the shard, which is a set of ordered
	// contiguous positive integers.
	//
	// HashKeyRange is a required field
	HashKeyRange *HashKeyRange `type:"structure" required:"true"`

	// The current shard that is the parent of the existing child shard.
	//
	// ParentShards is a required field
	ParentShards []*string `type:"list" required:"true"`

	// The shard ID of the existing child shard of the current shard.
	//
	// ShardId is a required field
	ShardId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChildShard) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChildShard) GoString() string {
	return s.String()
}

// SetHashKeyRange sets the HashKeyRange field's value.
func (s *ChildShard) SetHashKeyRange(v *HashKeyRange) *ChildShard {
	s.HashKeyRange = v
	return s
}

// SetParentShards sets the ParentShards field's value.
func (s *ChildShard) SetParentShards(v []*string) *ChildShard {
	s.ParentShards = v
	return s
}

// SetShardId sets the ShardId field's value.
func (s *ChildShard) SetShardId(v string) *ChildShard {
	s.ShardId = &v
	return s
}

// An object that represents the details of the consumer you registered. This
// type of object is returned by RegisterStreamConsumer.
type Consumer struct {
	_ struct{} `type:"structure"`

	// When you register a consumer, Kinesis Data Streams generates an ARN for it.
	// You need this ARN to be able to call SubscribeToShard.
	//
	// If you delete a consumer and then create a new one with the same name, it
	// won't have the same ARN. That's because consumer ARNs contain the creation
	// timestamp. This is important to keep in mind if you have IAM policies that
	// reference consumer ARNs.
	//
	// ConsumerARN is a required field
	ConsumerARN *string `min:"1" type:"string" required:"true"`

	// ConsumerCreationTimestamp is a required field
	ConsumerCreationTimestamp *time.Time `type:"timestamp" required:"true"`

	// The name of the consumer is something you choose when you register the consumer.
	//
	// ConsumerName is a required field
	ConsumerName *string `min:"1" type:"string" required:"true"`

	// A consumer can't read data while in the CREATING or DELETING states.
	//
	// ConsumerStatus is a required field
	ConsumerStatus *string `type:"string" required:"true" enum:"ConsumerStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Consumer) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Consumer) GoString() string {
	return s.String()
}

// SetConsumerARN sets the ConsumerARN field's value.
func (s *Consumer) SetConsumerARN(v string) *Consumer {
	s.ConsumerARN = &v
	return s
}

// SetConsumerCreationTimestamp sets the ConsumerCreationTimestamp field's value.
func (s *Consumer) SetConsumerCreationTimestamp(v time.Time) *Consumer {
	s.ConsumerCreationTimestamp = &v
	return s
}

// SetConsumerName sets the ConsumerName field's value.
func (s *Consumer) SetConsumerName(v string) *Consumer {
	s.ConsumerName = &v
	return s
}

// SetConsumerStatus sets the ConsumerStatus field's value.
func (s *Consumer) SetConsumerStatus(v string) *Consumer {
	s.ConsumerStatus = &v
	return s
}

// An object that represents the details of a registered consumer. This type
// of object is returned by DescribeStreamConsumer.
type ConsumerDescription struct {
	_ struct{} `type:"structure"`

	// When you register a consumer, Kinesis Data Streams generates an ARN for it.
	// You need this ARN to be able to call SubscribeToShard.
	//
	// If you delete a consumer and then create a new one with the same name, it
	// won't have the same ARN. That's because consumer ARNs contain the creation
	// timestamp. This is important to keep in mind if you have IAM policies that
	// reference consumer ARNs.
	//
	// ConsumerARN is a required field
	ConsumerARN *string `min:"1" type:"string" required:"true"`

	// ConsumerCreationTimestamp is a required field
	ConsumerCreationTimestamp *time.Time `type:"timestamp" required:"true"`

	// The name of the consumer is something you choose when you register the consumer.
	//
	// ConsumerName is a required field
	ConsumerName *string `min:"1" type:"string" required:"true"`

	// A consumer can't read data while in the CREATING or DELETING states.
	//
	// ConsumerStatus is a required field
	ConsumerStatus *string `type:"string" required:"true" enum:"ConsumerStatus"`

	// The ARN of the stream with which you registered the consumer.
	//
	// StreamARN is a required field
	StreamARN *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConsumerDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConsumerDescription) GoString() string {
	return s.String()
}

// SetConsumerARN sets the ConsumerARN field's value.
func (s *ConsumerDescription) SetConsumerARN(v string) *ConsumerDescription {
	s.ConsumerARN = &v
	return s
}

// SetConsumerCreationTimestamp sets the ConsumerCreationTimestamp field's value.
func (s *ConsumerDescription) SetConsumerCreationTimestamp(v time.Time) *ConsumerDescription {
	s.ConsumerCreationTimestamp = &v
	return s
}

// SetConsumerName sets the ConsumerName field's value.
func (s *ConsumerDescription) SetConsumerName(v string) *ConsumerDescription {
	s.ConsumerName = &v
	return s
}

// SetConsumerStatus sets the ConsumerStatus field's value.
func (s *ConsumerDescription) SetConsumerStatus(v string) *ConsumerDescription {
	s.ConsumerStatus = &v
	return s
}

// SetStreamARN sets the StreamARN field's value.
func (s *ConsumerDescription) SetStreamARN(v string) *ConsumerDescription {
	s.StreamARN = &v
	return s
}

// Represents the input for CreateStream.
type CreateStreamInput struct {
	_ struct{} `type:"structure"`

	// The number of shards that the stream will use. The throughput of the stream
	// is a function of the number of shards; more shards are required for greater
	// provisioned throughput.
	ShardCount *int64 `min:"1" type:"integer"`

	// Indicates the capacity mode of the data stream. Currently, in Kinesis Data
	// Streams, you can choose between an on-demand capacity mode and a provisioned
	// capacity mode for your data streams.
	StreamModeDetails *StreamModeDetails `type:"structure"`

	// A name to identify the stream. The stream name is scoped to the Amazon Web
	// Services account used by the application that creates the stream. It is also
	// scoped by Amazon Web Services Region. That is, two streams in two different
	// Amazon Web Services accounts can have the same name. Two streams in the same
	// Amazon Web Services account but in two different Regions can also have the
	// same name.
	//
	// StreamName is a required field
	StreamName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateStreamInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateStreamInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateStreamInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateStreamInput"}
	if s.ShardCount != nil && *s.ShardCount < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ShardCount", 1))
	}
	if s.StreamName == nil {
		invalidParams.Add(request.NewErrParamRequired("StreamName"))
	}
	if s.StreamName != nil && len(*s.StreamName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StreamName", 1))
	}
	if s.StreamModeDetails != nil {
		if err := s.StreamModeDetails.Validate(); err != nil {
			invalidParams.AddNested("StreamModeDetails", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetShardCount sets the ShardCount field's value.
func (s *CreateStreamInput) SetShardCount(v int64) *CreateStreamInput {
	s.ShardCount = &v
	return s
}

// SetStreamModeDetails sets the StreamModeDetails field's value.
func (s *CreateStreamInput) SetStreamModeDetails(v *StreamModeDetails) *CreateStreamInput {
	s.StreamModeDetails = v
	return s
}

// SetStreamName sets the StreamName field's value.
func (s *CreateStreamInput) SetStreamName(v string) *CreateStreamInput {
	s.StreamName = &v
	return s
}

type CreateStreamOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateStreamOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateStreamOutput) GoString() string {
	return s.String()
}

// Represents the input for DecreaseStreamRetentionPeriod.
type DecreaseStreamRetentionPeriodInput struct {
	_ struct{} `type:"structure"`

	// The new retention period of the stream, in hours. Must be less than the current
	// retention period.
	//
	// RetentionPeriodHours is a required field
	RetentionPeriodHours *int64 `type:"integer" required:"true"`

	// The ARN of the stream.
	StreamARN *string `min:"1" type:"string"`

	// The name of the stream to modify.
	StreamName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DecreaseStreamRetentionPeriodInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DecreaseStreamRetentionPeriodInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DecreaseStreamRetentionPeriodInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DecreaseStreamRetentionPeriodInput"}
	if s.RetentionPeriodHours == nil {
		invalidParams.Add(request.NewErrParamRequired("RetentionPeriodHours"))
	}
	if s.StreamARN != nil && len(*s.StreamARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StreamARN", 1))
	}
	if s.StreamName != nil && len(*s.StreamName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StreamName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRetentionPeriodHours sets the RetentionPeriodHours field's value.
func (s *DecreaseStreamRetentionPeriodInput) SetRetentionPeriodHours(v int64) *DecreaseStreamRetentionPeriodInput {
	s.RetentionPeriodHours = &v
	return s
}

// SetStreamARN sets the StreamARN field's value.
func (s *DecreaseStreamRetentionPeriodInput) SetStreamARN(v string) *DecreaseStreamRetentionPeriodInput {
	s.StreamARN = &v
	return s
}

// SetStreamName sets the StreamName field's value.
func (s *DecreaseStreamRetentionPeriodInput) SetStreamName(v string) *DecreaseStreamRetentionPeriodInput {
	s.StreamName = &v
	return s
}

type DecreaseStreamRetentionPeriodOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DecreaseStreamRetentionPeriodOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DecreaseStreamRetentionPeriodOutput) GoString() string {
	return s.String()
}

type DeleteResourcePolicyInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the data stream or consumer.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResourcePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResourcePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteResourcePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteResourcePolicyInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *DeleteResourcePolicyInput) SetResourceARN(v string) *DeleteResourcePolicyInput {
	s.ResourceARN = &v
	return s
}

type DeleteResourcePolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResourcePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResourcePolicyOutput) GoString() string {
	return s.String()
}

// Represents the input for DeleteStream.
type DeleteStreamInput struct {
	_ struct{} `type:"structure"`

	// If this parameter is unset (null) or if you set it to false, and the stream
	// has registered consumers, the call to DeleteStream fails with a ResourceInUseException.
	EnforceConsumerDeletion *bool `type:"boolean"`

	// The ARN of the stream.
	StreamARN *string `min:"1" type:"string"`

	// The name of the stream to delete.
	StreamName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteStreamInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteStreamInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteStreamInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteStreamInput"}
	if s.StreamARN != nil && len(*s.StreamARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StreamARN", 1))
	}
	if s.StreamName != nil && len(*s.StreamName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StreamName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnforceConsumerDeletion sets the EnforceConsumerDeletion field's value.
func (s *DeleteStreamInput) SetEnforceConsumerDeletion(v bool) *DeleteStreamInput {
	s.EnforceConsumerDeletion = &v
	return s
}

// SetStreamARN sets the StreamARN field's value.
func (s *DeleteStreamInput) SetStreamARN(v string) *DeleteStreamInput {
	s.StreamARN = &v
	return s
}

// SetStreamName sets the StreamName field's value.
func (s *DeleteStreamInput) SetStreamName(v string) *DeleteStreamInput {
	s.StreamName = &v
	return s
}

type DeleteStreamOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteStreamOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteStreamOutput) GoString() string {
	return s.String()
}

type DeregisterStreamConsumerInput struct {
	_ struct{} `type:"structure"`

	// The ARN returned by Kinesis Data Streams when you registered the consumer.
	// If you don't know the ARN of the consumer that you want to deregister, you
	// can use the ListStreamConsumers operation to get a list of the descriptions
	// of all the consumers that are currently registered with a given data stream.
	// The description of a consumer contains its ARN.
	ConsumerARN *string `min:"1" type:"string"`

	// The name that you gave to the consumer.
	ConsumerName *string `min:"1" type:"string"`

	// The ARN of the Kinesis data stream that the consumer is registered with.
	// For more information, see Amazon Resource Names (ARNs) and Amazon Web Services
	// Service Namespaces (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-kinesis-streams).
	StreamARN *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeregisterStreamConsumerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeregisterStreamConsumerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeregisterStreamConsumerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeregisterStreamConsumerInput"}
	if s.ConsumerARN != nil && len(*s.ConsumerARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConsumerARN", 1))
	}
	if s.ConsumerName != nil && len(*s.ConsumerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConsumerName", 1))
	}
	if s.StreamARN != nil && len(*s.StreamARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StreamARN", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConsumerARN sets the ConsumerARN field's value.
func (s *DeregisterStreamConsumerInput) SetConsumerARN(v string) *DeregisterStreamConsumerInput {
	s.ConsumerARN = &v
	return s
}

// SetConsumerName sets the ConsumerName field's value.
func (s *DeregisterStreamConsumerInput) SetConsumerName(v string) *DeregisterStreamConsumerInput {
	s.ConsumerName = &v
	return s
}

// SetStreamARN sets the StreamARN field's value.
func (s *DeregisterStreamConsumerInput) SetStreamARN(v string) *DeregisterStreamConsumerInput {
	s.StreamARN = &v
	return s
}

type DeregisterStreamConsumerOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeregisterStreamConsumerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeregisterStreamConsumerOutput) GoString() string {
	return s.String()
}

type DescribeLimitsInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLimitsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLimitsInput) GoString() string {
	return s.String()
}

type DescribeLimitsOutput struct {
	_ struct{} `type:"structure"`

	// Indicates the number of data streams with the on-demand capacity mode.
	//
	// OnDemandStreamCount is a required field
	OnDemandStreamCount *int64 `type:"integer" required:"true"`

	// The maximum number of data streams with the on-demand capacity mode.
	//
	// OnDemandStreamCountLimit is a required field
	OnDemandStreamCountLimit *int64 `type:"integer" required:"true"`

	// The number of open shards.
	//
	// OpenShardCount is a required field
	OpenShardCount *int64 `type:"integer" required:"true"`

	// The maximum number of shards.
	//
	// ShardLimit is a required field
	ShardLimit *int64 `type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLimitsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLimitsOutput) GoString() string {
	return s.String()
}

// SetOnDemandStreamCount sets the OnDemandStreamCount field's value.
func (s *DescribeLimitsOutput) SetOnDemandStreamCount(v int64) *DescribeLimitsOutput {
	s.OnDemandStreamCount = &v
	return s
}

// SetOnDemandStreamCountLimit sets the OnDemandStreamCountLimit field's value.
func (s *DescribeLimitsOutput) SetOnDemandStreamCountLimit(v int64) *DescribeLimitsOutput {
	s.OnDemandStreamCountLimit = &v
	return s
}

// SetOpenShardCount sets the OpenShardCount field's value.
func (s *DescribeLimitsOutput) SetOpenShardCount(v int64) *DescribeLimitsOutput {
	s.OpenShardCount = &v
	return s
}

// SetShardLimit sets the ShardLimit field's value.
func (s *DescribeLimitsOutput) SetShardLimit(v int64) *DescribeLimitsOutput {
	s.ShardLimit = &v
	return s
}

type DescribeStreamConsumerInput struct {
	_ struct{} `type:"structure"`

	// The ARN returned by Kinesis Data Streams when you registered the consumer.
	ConsumerARN *string `min:"1" type:"string"`

	// The name that you gave to the consumer.
	ConsumerName *string `min:"1" type:"string"`

	// The ARN of the Kinesis data stream that the consumer is registered with.
	// For more information, see Amazon Resource Names (ARNs) and Amazon Web Services
	// Service Namespaces (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-kinesis-streams).
	StreamARN *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeStreamConsumerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeStreamConsumerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeStreamConsumerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeStreamConsumerInput"}
	if s.ConsumerARN != nil && len(*s.ConsumerARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConsumerARN", 1))
	}
	if s.ConsumerName != nil && len(*s.ConsumerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConsumerName", 1))
	}
	if s.StreamARN != nil && len(*s.StreamARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StreamARN", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConsumerARN sets the ConsumerARN field's value.
func (s *DescribeStreamConsumerInput) SetConsumerARN(v string) *DescribeStreamConsumerInput {
	s.ConsumerARN = &v
	return s
}

// SetConsumerName sets the ConsumerName field's value.
func (s *DescribeStreamConsumerInput) SetConsumerName(v string) *DescribeStreamConsumerInput {
	s.ConsumerName = &v
	return s
}

// SetStreamARN sets the StreamARN field's value.
func (s *DescribeStreamConsumerInput) SetStreamARN(v string) *DescribeStreamConsumerInput {
	s.StreamARN = &v
	return s
}

type DescribeStreamConsumerOutput struct {
	_ struct{} `type:"structure"`

	// An object that represents the details of the consumer.
	//
	// ConsumerDescription is a required field
	ConsumerDescription *ConsumerDescription `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeStreamConsumerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeStreamConsumerOutput) GoString() string {
	return s.String()
}

// SetConsumerDescription sets the ConsumerDescription field's value.
func (s *DescribeStreamConsumerOutput) SetConsumerDescription(v *ConsumerDescription) *DescribeStreamConsumerOutput {
	s.ConsumerDescription = v
	return s
}

// Represents the input for DescribeStream.
type DescribeStreamInput struct {
	_ struct{} `type:"structure"`

	// The shard ID of the shard to start with.
	//
	// Specify this parameter to indicate that you want to describe the stream starting
	// with the shard whose ID immediately follows ExclusiveStartShardId.
	//
	// If you don't specify this parameter, the default behavior for DescribeStream
	// is to describe the stream starting with the first shard in the stream.
	ExclusiveStartShardId *string `min:"1" type:"string"`

	// The maximum number of shards to return in a single call. The default value
	// is 100. If you specify a value greater than 100, at most 100 results are
	// returned.
	Limit *int64 `min:"1" type:"integer"`

	// The ARN of the stream.
	StreamARN *string `min:"1" type:"string"`

	// The name of the stream to describe.
	StreamName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeStreamInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeStreamInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeStreamInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeStreamInput"}
	if s.ExclusiveStartShardId != nil && len(*s.ExclusiveStartShardId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ExclusiveStartShardId", 1))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.StreamARN != nil && len(*s.StreamARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StreamARN", 1))
	}
	if s.StreamName != nil && len(*s.StreamName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StreamName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExclusiveStartShardId sets the ExclusiveStartShardId field's value.
func (s *DescribeStreamInput) SetExclusiveStartShardId(v string) *DescribeStreamInput {
	s.ExclusiveStartShardId = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *DescribeStreamInput) SetLimit(v int64) *DescribeStreamInput {
	s.Limit = &v
	return s
}

// SetStreamARN sets the StreamARN field's value.
func (s *DescribeStreamInput) SetStreamARN(v string) *DescribeStreamInput {
	s.StreamARN = &v
	return s
}

// SetStreamName sets the StreamName field's value.
func (s *DescribeStreamInput) SetStreamName(v string) *DescribeStreamInput {
	s.StreamName = &v
	return s
}

// Represents the output for DescribeStream.
type DescribeStreamOutput struct {
	_ struct{} `type:"structure"`

	// The current status of the stream, the stream Amazon Resource Name (ARN),
	// an array of shard objects that comprise the stream, and whether there are
	// more shards available.
	//
	// StreamDescription is a required field
	StreamDescription *StreamDescription `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeStreamOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeStreamOutput) GoString() string {
	return s.String()
}

// SetStreamDescription sets the StreamDescription field's value.
func (s *DescribeStreamOutput) SetStreamDescription(v *StreamDescription) *DescribeStreamOutput {
	s.StreamDescription = v
	return s
}

type DescribeStreamSummaryInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the stream.
	StreamARN *string `min:"1" type:"string"`

	// The name of the stream to describe.
	StreamName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeStreamSummaryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeStreamSummaryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeStreamSummaryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeStreamSummaryInput"}
	if s.StreamARN != nil && len(*s.StreamARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StreamARN", 1))
	}
	if s.StreamName != nil && len(*s.StreamName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StreamName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStreamARN sets the StreamARN field's value.
func (s *DescribeStreamSummaryInput) SetStreamARN(v string) *DescribeStreamSummaryInput {
	s.StreamARN = &v
	return s
}

// SetStreamName sets the StreamName field's value.
func (s *DescribeStreamSummaryInput) SetStreamName(v string) *DescribeStreamSummaryInput {
	s.StreamName = &v
	return s
}

type DescribeStreamSummaryOutput struct {
	_ struct{} `type:"structure"`

	// A StreamDescriptionSummary containing information about the stream.
	//
	// StreamDescriptionSummary is a required field
	StreamDescriptionSummary *StreamDescriptionSummary `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeStreamSummaryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeStreamSummaryOutput) GoString() string {
	return s.String()
}

// SetStreamDescriptionSummary sets the StreamDescriptionSummary field's value.
func (s *DescribeStreamSummaryOutput) SetStreamDescriptionSummary(v *StreamDescriptionSummary) *DescribeStreamSummaryOutput {
	s.StreamDescriptionSummary = v
	return s
}

// Represents the input for DisableEnhancedMonitoring.
type DisableEnhancedMonitoringInput struct {
	_ struct{} `type:"structure"`

	// List of shard-level metrics to disable.
	//
	// The following are the valid shard-level metrics. The value "ALL" disables
	// every metric.
	//
	//    * IncomingBytes
	//
	//    * IncomingRecords
	//
	//    * OutgoingBytes
	//
	//    * OutgoingRecords
	//
	//    * WriteProvisionedThroughputExceeded
	//
	//    * ReadProvisionedThroughputExceeded
	//
	//    * IteratorAgeMilliseconds
	//
	//    * ALL
	//
	// For more information, see Monitoring the Amazon Kinesis Data Streams Service
	// with Amazon CloudWatch (https://docs.aws.amazon.com/kinesis/latest/dev/monitoring-with-cloudwatch.html)
	// in the Amazon Kinesis Data Streams Developer Guide.
	//
	// ShardLevelMetrics is a required field
	ShardLevelMetrics []*string `min:"1" type:"list" required:"true" enum:"MetricsName"`

	// The ARN of the stream.
	StreamARN *string `min:"1" type:"string"`

	// The name of the Kinesis data stream for which to disable enhanced monitoring.
	StreamName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisableEnhancedMonitoringInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisableEnhancedMonitoringInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisableEnhancedMonitoringInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisableEnhancedMonitoringInput"}
	if s.ShardLevelMetrics == nil {
		invalidParams.Add(request.NewErrParamRequired("ShardLevelMetrics"))
	}
	if s.ShardLevelMetrics != nil && len(s.ShardLevelMetrics) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ShardLevelMetrics", 1))
	}
	if s.StreamARN != nil && len(*s.StreamARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StreamARN", 1))
	}
	if s.StreamName != nil && len(*s.StreamName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StreamName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetShardLevelMetrics sets the ShardLevelMetrics field's value.
func (s *DisableEnhancedMonitoringInput) SetShardLevelMetrics(v []*string) *DisableEnhancedMonitoringInput {
	s.ShardLevelMetrics = v
	return s
}

// SetStreamARN sets the StreamARN field's value.
func (s *DisableEnhancedMonitoringInput) SetStreamARN(v string) *DisableEnhancedMonitoringInput {
	s.StreamARN = &v
	return s
}

// SetStreamName sets the StreamName field's value.
func (s *DisableEnhancedMonitoringInput) SetStreamName(v string) *DisableEnhancedMonitoringInput {
	s.StreamName = &v
	return s
}

// Represents the input for EnableEnhancedMonitoring.
type EnableEnhancedMonitoringInput struct {
	_ struct{} `type:"structure"`

	// List of shard-level metrics to enable.
	//
	// The following are the valid shard-level metrics. The value "ALL" enables
	// every metric.
	//
	//    * IncomingBytes
	//
	//    * IncomingRecords
	//
	//    * OutgoingBytes
	//
	//    * OutgoingRecords
	//
	//    * WriteProvisionedThroughputExceeded
	//
	//    * ReadProvisionedThroughputExceeded
	//
	//    * IteratorAgeMilliseconds
	//
	//    * ALL
	//
	// For more information, see Monitoring the Amazon Kinesis Data Streams Service
	// with Amazon CloudWatch (https://docs.aws.amazon.com/kinesis/latest/dev/monitoring-with-cloudwatch.html)
	// in the Amazon Kinesis Data Streams Developer Guide.
	//
	// ShardLevelMetrics is a required field
	ShardLevelMetrics []*string `min:"1" type:"list" required:"true" enum:"MetricsName"`

	// The ARN of the stream.
	StreamARN *string `min:"1" type:"string"`

	// The name of the stream for which to enable enhanced monitoring.
	StreamName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnableEnhancedMonitoringInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnableEnhancedMonitoringInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EnableEnhancedMonitoringInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EnableEnhancedMonitoringInput"}
	if s.ShardLevelMetrics == nil {
		invalidParams.Add(request.NewErrParamRequired("ShardLevelMetrics"))
	}
	if s.ShardLevelMetrics != nil && len(s.ShardLevelMetrics) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ShardLevelMetrics", 1))
	}
	if s.StreamARN != nil && len(*s.StreamARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StreamARN", 1))
	}
	if s.StreamName != nil && len(*s.StreamName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StreamName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetShardLevelMetrics sets the ShardLevelMetrics field's value.
func (s *EnableEnhancedMonitoringInput) SetShardLevelMetrics(v []*string) *EnableEnhancedMonitoringInput {
	s.ShardLevelMetrics = v
	return s
}

// SetStreamARN sets the StreamARN field's value.
func (s *EnableEnhancedMonitoringInput) SetStreamARN(v string) *EnableEnhancedMonitoringInput {
	s.StreamARN = &v
	return s
}

// SetStreamName sets the StreamName field's value.
func (s *EnableEnhancedMonitoringInput) SetStreamName(v string) *EnableEnhancedMonitoringInput {
	s.StreamName = &v
	return s
}

// Represents enhanced metrics types.
type EnhancedMetrics struct {
	_ struct{} `type:"structure"`

	// List of shard-level metrics.
	//
	// The following are the valid shard-level metrics. The value "ALL" enhances
	// every metric.
	//
	//    * IncomingBytes
	//
	//    * IncomingRecords
	//
	//    * OutgoingBytes
	//
	//    * OutgoingRecords
	//
	//    * WriteProvisionedThroughputExceeded
	//
	//    * ReadProvisionedThroughputExceeded
	//
	//    * IteratorAgeMilliseconds
	//
	//    * ALL
	//
	// For more information, see Monitoring the Amazon Kinesis Data Streams Service
	// with Amazon CloudWatch (https://docs.aws.amazon.com/kinesis/latest/dev/monitoring-with-cloudwatch.html)
	// in the Amazon Kinesis Data Streams Developer Guide.
	ShardLevelMetrics []*string `min:"1" type:"list" enum:"MetricsName"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnhancedMetrics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnhancedMetrics) GoString() string {
	return s.String()
}

// SetShardLevelMetrics sets the ShardLevelMetrics field's value.
func (s *EnhancedMetrics) SetShardLevelMetrics(v []*string) *EnhancedMetrics {
	s.ShardLevelMetrics = v
	return s
}

// Represents the output for EnableEnhancedMonitoring and DisableEnhancedMonitoring.
type EnhancedMonitoringOutput struct {
	_ struct{} `type:"structure"`

	// Represents the current state of the metrics that are in the enhanced state
	// before the operation.
	CurrentShardLevelMetrics []*string `min:"1" type:"list" enum:"MetricsName"`

	// Represents the list of all the metrics that would be in the enhanced state
	// after the operation.
	DesiredShardLevelMetrics []*string `min:"1" type:"list" enum:"MetricsName"`

	// The ARN of the stream.
	StreamARN *string `min:"1" type:"string"`

	// The name of the Kinesis data stream.
	StreamName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnhancedMonitoringOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnhancedMonitoringOutput) GoString() string {
	return s.String()
}

// SetCurrentShardLevelMetrics sets the CurrentShardLevelMetrics field's value.
func (s *EnhancedMonitoringOutput) SetCurrentShardLevelMetrics(v []*string) *EnhancedMonitoringOutput {
	s.CurrentShardLevelMetrics = v
	return s
}

// SetDesiredShardLevelMetrics sets the DesiredShardLevelMetrics field's value.
func (s *EnhancedMonitoringOutput) SetDesiredShardLevelMetrics(v []*string) *EnhancedMonitoringOutput {
	s.DesiredShardLevelMetrics = v
	return s
}

// SetStreamARN sets the StreamARN field's value.
func (s *EnhancedMonitoringOutput) SetStreamARN(v string) *EnhancedMonitoringOutput {
	s.StreamARN = &v
	return s
}

// SetStreamName sets the StreamName field's value.
func (s *EnhancedMonitoringOutput) SetStreamName(v string) *EnhancedMonitoringOutput {
	s.StreamName = &v
	return s
}

// The provided iterator exceeds the maximum age allowed.
type ExpiredIteratorException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A message that provides information about the error.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExpiredIteratorException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExpiredIteratorException) GoString() string {
	return s.String()
}

func newErrorExpiredIteratorException(v protocol.ResponseMetadata) error {
	return &ExpiredIteratorException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ExpiredIteratorException) Code() string {
	return "ExpiredIteratorException"
}

// Message returns the exception's message.
func (s *ExpiredIteratorException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ExpiredIteratorException) OrigErr() error {
	return nil
}

func (s *ExpiredIteratorException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ExpiredIteratorException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ExpiredIteratorException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The pagination token passed to the operation is expired.
type ExpiredNextTokenException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExpiredNextTokenException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExpiredNextTokenException) GoString() string {
	return s.String()
}

func newErrorExpiredNextTokenException(v protocol.ResponseMetadata) error {
	return &ExpiredNextTokenException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ExpiredNextTokenException) Code() string {
	return "ExpiredNextTokenException"
}

// Message returns the exception's message.
func (s *ExpiredNextTokenException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ExpiredNextTokenException) OrigErr() error {
	return nil
}

func (s *ExpiredNextTokenException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ExpiredNextTokenException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ExpiredNextTokenException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Represents the input for GetRecords.
type GetRecordsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of records to return. Specify a value of up to 10,000.
	// If you specify a value that is greater than 10,000, GetRecords throws InvalidArgumentException.
	// The default value is 10,000.
	Limit *int64 `min:"1" type:"integer"`

	// The position in the shard from which you want to start sequentially reading
	// data records. A shard iterator specifies this position using the sequence
	// number of a data record in the shard.
	//
	// ShardIterator is a required field
	ShardIterator *string `min:"1" type:"string" required:"true"`

	// The ARN of the stream.
	StreamARN *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRecordsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRecordsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRecordsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetRecordsInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.ShardIterator == nil {
		invalidParams.Add(request.NewErrParamRequired("ShardIterator"))
	}
	if s.ShardIterator != nil && len(*s.ShardIterator) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ShardIterator", 1))
	}
	if s.StreamARN != nil && len(*s.StreamARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StreamARN", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *GetRecordsInput) SetLimit(v int64) *GetRecordsInput {
	s.Limit = &v
	return s
}

// SetShardIterator sets the ShardIterator field's value.
func (s *GetRecordsInput) SetShardIterator(v string) *GetRecordsInput {
	s.ShardIterator = &v
	return s
}

// SetStreamARN sets the StreamARN field's value.
func (s *GetRecordsInput) SetStreamARN(v string) *GetRecordsInput {
	s.StreamARN = &v
	return s
}

// Represents the output for GetRecords.
type GetRecordsOutput struct {
	_ struct{} `type:"structure"`

	// The list of the current shard's child shards, returned in the GetRecords
	// API's response only when the end of the current shard is reached.
	ChildShards []*ChildShard `type:"list"`

	// The number of milliseconds the GetRecords response is from the tip of the
	// stream, indicating how far behind current time the consumer is. A value of
	// zero indicates that record processing is caught up, and there are no new
	// records to process at this moment.
	MillisBehindLatest *int64 `type:"long"`

	// The next position in the shard from which to start sequentially reading data
	// records. If set to null, the shard has been closed and the requested iterator
	// does not return any more data.
	NextShardIterator *string `min:"1" type:"string"`

	// The data records retrieved from the shard.
	//
	// Records is a required field
	Records []*Record `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRecordsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRecordsOutput) GoString() string {
	return s.String()
}

// SetChildShards sets the ChildShards field's value.
func (s *GetRecordsOutput) SetChildShards(v []*ChildShard) *GetRecordsOutput {
	s.ChildShards = v
	return s
}

// SetMillisBehindLatest sets the MillisBehindLatest field's value.
func (s *GetRecordsOutput) SetMillisBehindLatest(v int64) *GetRecordsOutput {
	s.MillisBehindLatest = &v
	return s
}

// SetNextShardIterator sets the NextShardIterator field's value.
func (s *GetRecordsOutput) SetNextShardIterator(v string) *GetRecordsOutput {
	s.NextShardIterator = &v
	return s
}

// SetRecords sets the Records field's value.
func (s *GetRecordsOutput) SetRecords(v []*Record) *GetRecordsOutput {
	s.Records = v
	return s
}

type GetResourcePolicyInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the data stream or consumer.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourcePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourcePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetResourcePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetResourcePolicyInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *GetResourcePolicyInput) SetResourceARN(v string) *GetResourcePolicyInput {
	s.ResourceARN = &v
	return s
}

type GetResourcePolicyOutput struct {
	_ struct{} `type:"structure"`

	// Details of the resource policy. This is formatted as a JSON string.
	//
	// Policy is a required field
	Policy *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourcePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourcePolicyOutput) GoString() string {
	return s.String()
}

// SetPolicy sets the Policy field's value.
func (s *GetResourcePolicyOutput) SetPolicy(v string) *GetResourcePolicyOutput {
	s.Policy = &v
	return s
}

// Represents the input for GetShardIterator.
type GetShardIteratorInput struct {
	_ struct{} `type:"structure"`

	// The shard ID of the Kinesis Data Streams shard to get the iterator for.
	//
	// ShardId is a required field
	ShardId *string `min:"1" type:"string" required:"true"`

	// Determines how the shard iterator is used to start reading data records from
	// the shard.
	//
	// The following are the valid Amazon Kinesis shard iterator types:
	//
	//    * AT_SEQUENCE_NUMBER - Start reading from the position denoted by a specific
	//    sequence number, provided in the value StartingSequenceNumber.
	//
	//    * AFTER_SEQUENCE_NUMBER - Start reading right after the position denoted
	//    by a specific sequence number, provided in the value StartingSequenceNumber.
	//
	//    * AT_TIMESTAMP - Start reading from the position denoted by a specific
	//    time stamp, provided in the value Timestamp.
	//
	//    * TRIM_HORIZON - Start reading at the last untrimmed record in the shard
	//    in the system, which is the oldest data record in the shard.
	//
	//    * LATEST - Start reading just after the most recent record in the shard,
	//    so that you always read the most recent data in the shard.
	//
	// ShardIteratorType is a required field
	ShardIteratorType *string `type:"string" required:"true" enum:"ShardIteratorType"`

	// The sequence number of the data record in the shard from which to start reading.
	// Used with shard iterator type AT_SEQUENCE_NUMBER and AFTER_SEQUENCE_NUMBER.
	StartingSequenceNumber *string `type:"string"`

	// The ARN of the stream.
	StreamARN *string `min:"1" type:"string"`

	// The name of the Amazon Kinesis data stream.
	StreamName *string `min:"1" type:"string"`

	// The time stamp of the data record from which to start reading. Used with
	// shard iterator type AT_TIMESTAMP. A time stamp is the Unix epoch date with
	// precision in milliseconds. For example, 2016-04-04T19:58:46.480-00:00 or
	// 1459799926.480. If a record with this exact time stamp does not exist, the
	// iterator returned is for the next (later) record. If the time stamp is older
	// than the current trim horizon, the iterator returned is for the oldest untrimmed
	// data record (TRIM_HORIZON).
	Timestamp *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetShardIteratorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetShardIteratorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetShardIteratorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetShardIteratorInput"}
	if s.ShardId == nil {
		invalidParams.Add(request.NewErrParamRequired("ShardId"))
	}
	if s.ShardId != nil && len(*s.ShardId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ShardId", 1))
	}
	if s.ShardIteratorType == nil {
		invalidParams.Add(request.NewErrParamRequired("ShardIteratorType"))
	}
	if s.StreamARN != nil && len(*s.StreamARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StreamARN", 1))
	}
	if s.StreamName != nil && len(*s.StreamName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StreamName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetShardId sets the ShardId field's value.
func (s *GetShardIteratorInput) SetShardId(v string) *GetShardIteratorInput {
	s.ShardId = &v
	return s
}

// SetShardIteratorType sets the ShardIteratorType field's value.
func (s *GetShardIteratorInput) SetShardIteratorType(v string) *GetShardIteratorInput {
	s.ShardIteratorType = &v
	return s
}

// SetStartingSequenceNumber sets the StartingSequenceNumber field's value.
func (s *GetShardIteratorInput) SetStartingSequenceNumber(v string) *GetShardIteratorInput {
	s.StartingSequenceNumber = &v
	return s
}

// SetStreamARN sets the StreamARN field's value.
func (s *GetShardIteratorInput) SetStreamARN(v string) *GetShardIteratorInput {
	s.StreamARN = &v
	return s
}

// SetStreamName sets the StreamName field's value.
func (s *GetShardIteratorInput) SetStreamName(v string) *GetShardIteratorInput {
	s.StreamName = &v
	return s
}

// SetTimestamp sets the Timestamp field's value.
func (s *GetShardIteratorInput) SetTimestamp(v time.Time) *GetShardIteratorInput {
	s.Timestamp = &v
	return s
}

// Represents the output for GetShardIterator.
type GetShardIteratorOutput struct {
	_ struct{} `type:"structure"`

	// The position in the shard from which to start reading data records sequentially.
	// A shard iterator specifies this position using the sequence number of a data
	// record in a shard.
	ShardIterator *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetShardIteratorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetShardIteratorOutput) GoString() string {
	return s.String()
}

// SetShardIterator sets the ShardIterator field's value.
func (s *GetShardIteratorOutput) SetShardIterator(v string) *GetShardIteratorOutput {
	s.ShardIterator = &v
	return s
}

// The range of possible hash key values for the shard, which is a set of ordered
// contiguous positive integers.
type HashKeyRange struct {
	_ struct{} `type:"structure"`

	// The ending hash key of the hash key range.
	//
	// EndingHashKey is a required field
	EndingHashKey *string `type:"string" required:"true"`

	// The starting hash key of the hash key range.
	//
	// StartingHashKey is a required field
	StartingHashKey *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HashKeyRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HashKeyRange) GoString() string {
	return s.String()
}

// SetEndingHashKey sets the EndingHashKey field's value.
func (s *HashKeyRange) SetEndingHashKey(v string) *HashKeyRange {
	s.EndingHashKey = &v
	return s
}

// SetStartingHashKey sets the StartingHashKey field's value.
func (s *HashKeyRange) SetStartingHashKey(v string) *HashKeyRange {
	s.StartingHashKey = &v
	return s
}

// Represents the input for IncreaseStreamRetentionPeriod.
type IncreaseStreamRetentionPeriodInput struct {
	_ struct{} `type:"structure"`

	// The new retention period of the stream, in hours. Must be more than the current
	// retention period.
	//
	// RetentionPeriodHours is a required field
	RetentionPeriodHours *int64 `type:"integer" required:"true"`

	// The ARN of the stream.
	StreamARN *string `min:"1" type:"string"`

	// The name of the stream to modify.
	StreamName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IncreaseStreamRetentionPeriodInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IncreaseStreamRetentionPeriodInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IncreaseStreamRetentionPeriodInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "IncreaseStreamRetentionPeriodInput"}
	if s.RetentionPeriodHours == nil {
		invalidParams.Add(request.NewErrParamRequired("RetentionPeriodHours"))
	}
	if s.StreamARN != nil && len(*s.StreamARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StreamARN", 1))
	}
	if s.StreamName != nil && len(*s.StreamName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StreamName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRetentionPeriodHours sets the RetentionPeriodHours field's value.
func (s *IncreaseStreamRetentionPeriodInput) SetRetentionPeriodHours(v int64) *IncreaseStreamRetentionPeriodInput {
	s.RetentionPeriodHours = &v
	return s
}

// SetStreamARN sets the StreamARN field's value.
func (s *IncreaseStreamRetentionPeriodInput) SetStreamARN(v string) *IncreaseStreamRetentionPeriodInput {
	s.StreamARN = &v
	return s
}

// SetStreamName sets the StreamName field's value.
func (s *IncreaseStreamRetentionPeriodInput) SetStreamName(v string) *IncreaseStreamRetentionPeriodInput {
	s.StreamName = &v
	return s
}

type IncreaseStreamRetentionPeriodOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IncreaseStreamRetentionPeriodOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IncreaseStreamRetentionPeriodOutput) GoString() string {
	return s.String()
}

// The processing of the request failed because of an unknown error, exception,
// or failure.
type InternalFailureException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalFailureException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalFailureException) GoString() string {
	return s.String()
}

// The InternalFailureException is and event in the SubscribeToShardEventStream group of events.
func (s *InternalFailureException) eventSubscribeToShardEventStream() {}

// UnmarshalEvent unmarshals the EventStream Message into the InternalFailureException value.
// This method is only used internally within the SDK's EventStream handling.
func (s *InternalFailureException) UnmarshalEvent(
	payloadUnmarshaler protocol.PayloadUnmarshaler,
	msg eventstream.Message,
) error {
	if err := payloadUnmarshaler.UnmarshalPayload(
		bytes.NewReader(msg.Payload), s,
	); err != nil {
		return err
	}
	return nil
}

// MarshalEvent marshals the type into an stream event value. This method
// should only used internally within the SDK's EventStream handling.
func (s *InternalFailureException) MarshalEvent(pm protocol.PayloadMarshaler) (msg eventstream.Message, err error) {
	msg.Headers.Set(eventstreamapi.MessageTypeHeader, eventstream.StringValue(eventstreamapi.ExceptionMessageType))
	var buf bytes.Buffer
	if err = pm.MarshalPayload(&buf, s); err != nil {
		return eventstream.Message{}, err
	}
	msg.Payload = buf.Bytes()
	return msg, err
}

func newErrorInternalFailureException(v protocol.ResponseMetadata) error {
	return &InternalFailureException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalFailureException) Code() string {
	return "InternalFailureException"
}

// Message returns the exception's message.
func (s *InternalFailureException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalFailureException) OrigErr() error {
	return nil
}

func (s *InternalFailureException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalFailureException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalFailureException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A specified parameter exceeds its restrictions, is not supported, or can't
// be used. For more information, see the returned message.
type InvalidArgumentException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A message that provides information about the error.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidArgumentException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidArgumentException) GoString() string {
	return s.String()
}

func newErrorInvalidArgumentException(v protocol.ResponseMetadata) error {
	return &InvalidArgumentException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidArgumentException) Code() string {
	return "InvalidArgumentException"
}

// Message returns the exception's message.
func (s *InvalidArgumentException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidArgumentException) OrigErr() error {
	return nil
}

func (s *InvalidArgumentException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidArgumentException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidArgumentException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The ciphertext references a key that doesn't exist or that you don't have
// access to.
type KMSAccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A message that provides information about the error.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KMSAccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KMSAccessDeniedException) GoString() string {
	return s.String()
}

// The KMSAccessDeniedException is and event in the SubscribeToShardEventStream group of events.
func (s *KMSAccessDeniedException) eventSubscribeToShardEventStream() {}

// UnmarshalEvent unmarshals the EventStream Message into the KMSAccessDeniedException value.
// This method is only used internally within the SDK's EventStream handling.
func (s *KMSAccessDeniedException) UnmarshalEvent(
	payloadUnmarshaler protocol.PayloadUnmarshaler,
	msg eventstream.Message,
) error {
	if err := payloadUnmarshaler.UnmarshalPayload(
		bytes.NewReader(msg.Payload), s,
	); err != nil {
		return err
	}
	return nil
}

// MarshalEvent marshals the type into an stream event value. This method
// should only used internally within the SDK's EventStream handling.
func (s *KMSAccessDeniedException) MarshalEvent(pm protocol.PayloadMarshaler) (msg eventstream.Message, err error) {
	msg.Headers.Set(eventstreamapi.MessageTypeHeader, eventstream.StringValue(eventstreamapi.ExceptionMessageType))
	var buf bytes.Buffer
	if err = pm.MarshalPayload(&buf, s); err != nil {
		return eventstream.Message{}, err
	}
	msg.Payload = buf.Bytes()
	return msg, err
}

func newErrorKMSAccessDeniedException(v protocol.ResponseMetadata) error {
	return &KMSAccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *KMSAccessDeniedException) Code() string {
	return "KMSAccessDeniedException"
}

// Message returns the exception's message.
func (s *KMSAccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *KMSAccessDeniedException) OrigErr() error {
	return nil
}

func (s *KMSAccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *KMSAccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *KMSAccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request was rejected because the specified customer master key (CMK)
// isn't enabled.
type KMSDisabledException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A message that provides information about the error.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KMSDisabledException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KMSDisabledException) GoString() string {
	return s.String()
}

// The KMSDisabledException is and event in the SubscribeToShardEventStream group of events.
func (s *KMSDisabledException) eventSubscribeToShardEventStream() {}

// UnmarshalEvent unmarshals the EventStream Message into the KMSDisabledException value.
// This method is only used internally within the SDK's EventStream handling.
func (s *KMSDisabledException) UnmarshalEvent(
	payloadUnmarshaler protocol.PayloadUnmarshaler,
	msg eventstream.Message,
) error {
	if err := payloadUnmarshaler.UnmarshalPayload(
		bytes.NewReader(msg.Payload), s,
	); err != nil {
		return err
	}
	return nil
}

// MarshalEvent marshals the type into an stream event value. This method
// should only used internally within the SDK's EventStream handling.
func (s *KMSDisabledException) MarshalEvent(pm protocol.PayloadMarshaler) (msg eventstream.Message, err error) {
	msg.Headers.Set(eventstreamapi.MessageTypeHeader, eventstream.StringValue(eventstreamapi.ExceptionMessageType))
	var buf bytes.Buffer
	if err = pm.MarshalPayload(&buf, s); err != nil {
		return eventstream.Message{}, err
	}
	msg.Payload = buf.Bytes()
	return msg, err
}

func newErrorKMSDisabledException(v protocol.ResponseMetadata) error {
	return &KMSDisabledException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *KMSDisabledException) Code() string {
	return "KMSDisabledException"
}

// Message returns the exception's message.
func (s *KMSDisabledException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *KMSDisabledException) OrigErr() error {
	return nil
}

func (s *KMSDisabledException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *KMSDisabledException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *KMSDisabledException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request was rejected because the state of the specified resource isn't
// valid for this request. For more information, see How Key State Affects Use
// of a Customer Master Key (https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
// in the Amazon Web Services Key Management Service Developer Guide.
type KMSInvalidStateException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A message that provides information about the error.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KMSInvalidStateException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KMSInvalidStateException) GoString() string {
	return s.String()
}

// The KMSInvalidStateException is and event in the SubscribeToShardEventStream group of events.
func (s *KMSInvalidStateException) eventSubscribeToShardEventStream() {}

// UnmarshalEvent unmarshals the EventStream Message into the KMSInvalidStateException value.
// This method is only used internally within the SDK's EventStream handling.
func (s *KMSInvalidStateException) UnmarshalEvent(
	payloadUnmarshaler protocol.PayloadUnmarshaler,
	msg eventstream.Message,
) error {
	if err := payloadUnmarshaler.UnmarshalPayload(
		bytes.NewReader(msg.Payload), s,
	); err != nil {
		return err
	}
	return nil
}

// MarshalEvent marshals the type into an stream event value. This method
// should only used internally within the SDK's EventStream handling.
func (s *KMSInvalidStateException) MarshalEvent(pm protocol.PayloadMarshaler) (msg eventstream.Message, err error) {
	msg.Headers.Set(eventstreamapi.MessageTypeHeader, eventstream.StringValue(eventstreamapi.ExceptionMessageType))
	var buf bytes.Buffer
	if err = pm.MarshalPayload(&buf, s); err != nil {
		return eventstream.Message{}, err
	}
	msg.Payload = buf.Bytes()
	return msg, err
}

func newErrorKMSInvalidStateException(v protocol.ResponseMetadata) error {
	return &KMSInvalidStateException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *KMSInvalidStateException) Code() string {
	return "KMSInvalidStateException"
}

// Message returns the exception's message.
func (s *KMSInvalidStateException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *KMSInvalidStateException) OrigErr() error {
	return nil
}

func (s *KMSInvalidStateException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *KMSInvalidStateException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *KMSInvalidStateException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request was rejected because the specified entity or resource can't be
// found.
type KMSNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A message that provides information about the error.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KMSNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KMSNotFoundException) GoString() string {
	return s.String()
}

// The KMSNotFoundException is and event in the SubscribeToShardEventStream group of events.
func (s *KMSNotFoundException) eventSubscribeToShardEventStream() {}

// UnmarshalEvent unmarshals the EventStream Message into the KMSNotFoundException value.
// This method is only used internally within the SDK's EventStream handling.
func (s *KMSNotFoundException) UnmarshalEvent(
	payloadUnmarshaler protocol.PayloadUnmarshaler,
	msg eventstream.Message,
) error {
	if err := payloadUnmarshaler.UnmarshalPayload(
		bytes.NewReader(msg.Payload), s,
	); err != nil {
		return err
	}
	return nil
}

// MarshalEvent marshals the type into an stream event value. This method
// should only used internally within the SDK's EventStream handling.
func (s *KMSNotFoundException) MarshalEvent(pm protocol.PayloadMarshaler) (msg eventstream.Message, err error) {
	msg.Headers.Set(eventstreamapi.MessageTypeHeader, eventstream.StringValue(eventstreamapi.ExceptionMessageType))
	var buf bytes.Buffer
	if err = pm.MarshalPayload(&buf, s); err != nil {
		return eventstream.Message{}, err
	}
	msg.Payload = buf.Bytes()
	return msg, err
}

func newErrorKMSNotFoundException(v protocol.ResponseMetadata) error {
	return &KMSNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *KMSNotFoundException) Code() string {
	return "KMSNotFoundException"
}

// Message returns the exception's message.
func (s *KMSNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *KMSNotFoundException) OrigErr() error {
	return nil
}

func (s *KMSNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *KMSNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *KMSNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The Amazon Web Services access key ID needs a subscription for the service.
type KMSOptInRequired struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A message that provides information about the error.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KMSOptInRequired) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KMSOptInRequired) GoString() string {
	return s.String()
}

// The KMSOptInRequired is and event in the SubscribeToShardEventStream group of events.
func (s *KMSOptInRequired) eventSubscribeToShardEventStream() {}

// UnmarshalEvent unmarshals the EventStream Message into the KMSOptInRequired value.
// This method is only used internally within the SDK's EventStream handling.
func (s *KMSOptInRequired) UnmarshalEvent(
	payloadUnmarshaler protocol.PayloadUnmarshaler,
	msg eventstream.Message,
) error {
	if err := payloadUnmarshaler.UnmarshalPayload(
		bytes.NewReader(msg.Payload), s,
	); err != nil {
		return err
	}
	return nil
}

// MarshalEvent marshals the type into an stream event value. This method
// should only used internally within the SDK's EventStream handling.
func (s *KMSOptInRequired) MarshalEvent(pm protocol.PayloadMarshaler) (msg eventstream.Message, err error) {
	msg.Headers.Set(eventstreamapi.MessageTypeHeader, eventstream.StringValue(eventstreamapi.ExceptionMessageType))
	var buf bytes.Buffer
	if err = pm.MarshalPayload(&buf, s); err != nil {
		return eventstream.Message{}, err
	}
	msg.Payload = buf.Bytes()
	return msg, err
}

func newErrorKMSOptInRequired(v protocol.ResponseMetadata) error {
	return &KMSOptInRequired{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *KMSOptInRequired) Code() string {
	return "KMSOptInRequired"
}

// Message returns the exception's message.
func (s *KMSOptInRequired) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *KMSOptInRequired) OrigErr() error {
	return nil
}

func (s *KMSOptInRequired) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *KMSOptInRequired) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *KMSOptInRequired) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request was denied due to request throttling. For more information about
// throttling, see Limits (https://docs.aws.amazon.com/kms/latest/developerguide/limits.html#requests-per-second)
// in the Amazon Web Services Key Management Service Developer Guide.
type KMSThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A message that provides information about the error.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KMSThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KMSThrottlingException) GoString() string {
	return s.String()
}

// The KMSThrottlingException is and event in the SubscribeToShardEventStream group of events.
func (s *KMSThrottlingException) eventSubscribeToShardEventStream() {}

// UnmarshalEvent unmarshals the EventStream Message into the KMSThrottlingException value.
// This method is only used internally within the SDK's EventStream handling.
func (s *KMSThrottlingException) UnmarshalEvent(
	payloadUnmarshaler protocol.PayloadUnmarshaler,
	msg eventstream.Message,
) error {
	if err := payloadUnmarshaler.UnmarshalPayload(
		bytes.NewReader(msg.Payload), s,
	); err != nil {
		return err
	}
	return nil
}

// MarshalEvent marshals the type into an stream event value. This method
// should only used internally within the SDK's EventStream handling.
func (s *KMSThrottlingException) MarshalEvent(pm protocol.PayloadMarshaler) (msg eventstream.Message, err error) {
	msg.Headers.Set(eventstreamapi.MessageTypeHeader, eventstream.StringValue(eventstreamapi.ExceptionMessageType))
	var buf bytes.Buffer
	if err = pm.MarshalPayload(&buf, s); err != nil {
		return eventstream.Message{}, err
	}
	msg.Payload = buf.Bytes()
	return msg, err
}

func newErrorKMSThrottlingException(v protocol.ResponseMetadata) error {
	return &KMSThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *KMSThrottlingException) Code() string {
	return "KMSThrottlingException"
}

// Message returns the exception's message.
func (s *KMSThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *KMSThrottlingException) OrigErr() error {
	return nil
}

func (s *KMSThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *KMSThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *KMSThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The requested resource exceeds the maximum number allowed, or the number
// of concurrent stream requests exceeds the maximum number allowed.
type LimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A message that provides information about the error.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) GoString() string {
	return s.String()
}

func newErrorLimitExceededException(v protocol.ResponseMetadata) error {
	return &LimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *LimitExceededException) Code() string {
	return "LimitExceededException"
}

// Message returns the exception's message.
func (s *LimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *LimitExceededException) OrigErr() error {
	return nil
}

func (s *LimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *LimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *LimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListShardsInput struct {
	_ struct{} `type:"structure"`

	// Specify this parameter to indicate that you want to list the shards starting
	// with the shard whose ID immediately follows ExclusiveStartShardId.
	//
	// If you don't specify this parameter, the default behavior is for ListShards
	// to list the shards starting with the first one in the stream.
	//
	// You cannot specify this parameter if you specify NextToken.
	ExclusiveStartShardId *string `min:"1" type:"string"`

	// The maximum number of shards to return in a single call to ListShards. The
	// maximum number of shards to return in a single call. The default value is
	// 1000. If you specify a value greater than 1000, at most 1000 results are
	// returned.
	//
	// When the number of shards to be listed is greater than the value of MaxResults,
	// the response contains a NextToken value that you can use in a subsequent
	// call to ListShards to list the next set of shards.
	MaxResults *int64 `min:"1" type:"integer"`

	// When the number of shards in the data stream is greater than the default
	// value for the MaxResults parameter, or if you explicitly specify a value
	// for MaxResults that is less than the number of shards in the data stream,
	// the response includes a pagination token named NextToken. You can specify
	// this NextToken value in a subsequent call to ListShards to list the next
	// set of shards.
	//
	// Don't specify StreamName or StreamCreationTimestamp if you specify NextToken
	// because the latter unambiguously identifies the stream.
	//
	// You can optionally specify a value for the MaxResults parameter when you
	// specify NextToken. If you specify a MaxResults value that is less than the
	// number of shards that the operation returns if you don't specify MaxResults,
	// the response will contain a new NextToken value. You can use the new NextToken
	// value in a subsequent call to the ListShards operation.
	//
	// Tokens expire after 300 seconds. When you obtain a value for NextToken in
	// the response to a call to ListShards, you have 300 seconds to use that value.
	// If you specify an expired token in a call to ListShards, you get ExpiredNextTokenException.
	NextToken *string `min:"1" type:"string"`

	// Enables you to filter out the response of the ListShards API. You can only
	// specify one filter at a time.
	//
	// If you use the ShardFilter parameter when invoking the ListShards API, the
	// Type is the required property and must be specified. If you specify the AT_TRIM_HORIZON,
	// FROM_TRIM_HORIZON, or AT_LATEST types, you do not need to specify either
	// the ShardId or the Timestamp optional properties.
	//
	// If you specify the AFTER_SHARD_ID type, you must also provide the value for
	// the optional ShardId property. The ShardId property is identical in fuctionality
	// to the ExclusiveStartShardId parameter of the ListShards API. When ShardId
	// property is specified, the response includes the shards starting with the
	// shard whose ID immediately follows the ShardId that you provided.
	//
	// If you specify the AT_TIMESTAMP or FROM_TIMESTAMP_ID type, you must also
	// provide the value for the optional Timestamp property. If you specify the
	// AT_TIMESTAMP type, then all shards that were open at the provided timestamp
	// are returned. If you specify the FROM_TIMESTAMP type, then all shards starting
	// from the provided timestamp to TIP are returned.
	ShardFilter *ShardFilter `type:"structure"`

	// The ARN of the stream.
	StreamARN *string `min:"1" type:"string"`

	// Specify this input parameter to distinguish data streams that have the same
	// name. For example, if you create a data stream and then delete it, and you
	// later create another data stream with the same name, you can use this input
	// parameter to specify which of the two streams you want to list the shards
	// for.
	//
	// You cannot specify this parameter if you specify the NextToken parameter.
	StreamCreationTimestamp *time.Time `type:"timestamp"`

	// The name of the data stream whose shards you want to list.
	//
	// You cannot specify this parameter if you specify the NextToken parameter.
	StreamName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListShardsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListShardsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListShardsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListShardsInput"}
	if s.ExclusiveStartShardId != nil && len(*s.ExclusiveStartShardId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ExclusiveStartShardId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.StreamARN != nil && len(*s.StreamARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StreamARN", 1))
	}
	if s.StreamName != nil && len(*s.StreamName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StreamName", 1))
	}
	if s.ShardFilter != nil {
		if err := s.ShardFilter.Validate(); err != nil {
			invalidParams.AddNested("ShardFilter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExclusiveStartShardId sets the ExclusiveStartShardId field's value.
func (s *ListShardsInput) SetExclusiveStartShardId(v string) *ListShardsInput {
	s.ExclusiveStartShardId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListShardsInput) SetMaxResults(v int64) *ListShardsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListShardsInput) SetNextToken(v string) *ListShardsInput {
	s.NextToken = &v
	return s
}

// SetShardFilter sets the ShardFilter field's value.
func (s *ListShardsInput) SetShardFilter(v *ShardFilter) *ListShardsInput {
	s.ShardFilter = v
	return s
}

// SetStreamARN sets the StreamARN field's value.
func (s *ListShardsInput) SetStreamARN(v string) *ListShardsInput {
	s.StreamARN = &v
	return s
}

// SetStreamCreationTimestamp sets the StreamCreationTimestamp field's value.
func (s *ListShardsInput) SetStreamCreationTimestamp(v time.Time) *ListShardsInput {
	s.StreamCreationTimestamp = &v
	return s
}

// SetStreamName sets the StreamName field's value.
func (s *ListShardsInput) SetStreamName(v string) *ListShardsInput {
	s.StreamName = &v
	return s
}

type ListShardsOutput struct {
	_ struct{} `type:"structure"`

	// When the number of shards in the data stream is greater than the default
	// value for the MaxResults parameter, or if you explicitly specify a value
	// for MaxResults that is less than the number of shards in the data stream,
	// the response includes a pagination token named NextToken. You can specify
	// this NextToken value in a subsequent call to ListShards to list the next
	// set of shards. For more information about the use of this pagination token
	// when calling the ListShards operation, see ListShardsInput$NextToken.
	//
	// Tokens expire after 300 seconds. When you obtain a value for NextToken in
	// the response to a call to ListShards, you have 300 seconds to use that value.
	// If you specify an expired token in a call to ListShards, you get ExpiredNextTokenException.
	NextToken *string `min:"1" type:"string"`

	// An array of JSON objects. Each object represents one shard and specifies
	// the IDs of the shard, the shard's parent, and the shard that's adjacent to
	// the shard's parent. Each object also contains the starting and ending hash
	// keys and the starting and ending sequence numbers for the shard.
	Shards []*Shard `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListShardsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListShardsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListShardsOutput) SetNextToken(v string) *ListShardsOutput {
	s.NextToken = &v
	return s
}

// SetShards sets the Shards field's value.
func (s *ListShardsOutput) SetShards(v []*Shard) *ListShardsOutput {
	s.Shards = v
	return s
}

type ListStreamConsumersInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of consumers that you want a single call of ListStreamConsumers
	// to return. The default value is 100. If you specify a value greater than
	// 100, at most 100 results are returned.
	MaxResults *int64 `min:"1" type:"integer"`

	// When the number of consumers that are registered with the data stream is
	// greater than the default value for the MaxResults parameter, or if you explicitly
	// specify a value for MaxResults that is less than the number of consumers
	// that are registered with the data stream, the response includes a pagination
	// token named NextToken. You can specify this NextToken value in a subsequent
	// call to ListStreamConsumers to list the next set of registered consumers.
	//
	// Don't specify StreamName or StreamCreationTimestamp if you specify NextToken
	// because the latter unambiguously identifies the stream.
	//
	// You can optionally specify a value for the MaxResults parameter when you
	// specify NextToken. If you specify a MaxResults value that is less than the
	// number of consumers that the operation returns if you don't specify MaxResults,
	// the response will contain a new NextToken value. You can use the new NextToken
	// value in a subsequent call to the ListStreamConsumers operation to list the
	// next set of consumers.
	//
	// Tokens expire after 300 seconds. When you obtain a value for NextToken in
	// the response to a call to ListStreamConsumers, you have 300 seconds to use
	// that value. If you specify an expired token in a call to ListStreamConsumers,
	// you get ExpiredNextTokenException.
	NextToken *string `min:"1" type:"string"`

	// The ARN of the Kinesis data stream for which you want to list the registered
	// consumers. For more information, see Amazon Resource Names (ARNs) and Amazon
	// Web Services Service Namespaces (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-kinesis-streams).
	//
	// StreamARN is a required field
	StreamARN *string `min:"1" type:"string" required:"true"`

	// Specify this input parameter to distinguish data streams that have the same
	// name. For example, if you create a data stream and then delete it, and you
	// later create another data stream with the same name, you can use this input
	// parameter to specify which of the two streams you want to list the consumers
	// for.
	//
	// You can't specify this parameter if you specify the NextToken parameter.
	StreamCreationTimestamp *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStreamConsumersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStreamConsumersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListStreamConsumersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListStreamConsumersInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.StreamARN == nil {
		invalidParams.Add(request.NewErrParamRequired("StreamARN"))
	}
	if s.StreamARN != nil && len(*s.StreamARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StreamARN", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListStreamConsumersInput) SetMaxResults(v int64) *ListStreamConsumersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListStreamConsumersInput) SetNextToken(v string) *ListStreamConsumersInput {
	s.NextToken = &v
	return s
}

// SetStreamARN sets the StreamARN field's value.
func (s *ListStreamConsumersInput) SetStreamARN(v string) *ListStreamConsumersInput {
	s.StreamARN = &v
	return s
}

// SetStreamCreationTimestamp sets the StreamCreationTimestamp field's value.
func (s *ListStreamConsumersInput) SetStreamCreationTimestamp(v time.Time) *ListStreamConsumersInput {
	s.StreamCreationTimestamp = &v
	return s
}

type ListStreamConsumersOutput struct {
	_ struct{} `type:"structure"`

	// An array of JSON objects. Each object represents one registered consumer.
	Consumers []*Consumer `type:"list"`

	// When the number of consumers that are registered with the data stream is
	// greater than the default value for the MaxResults parameter, or if you explicitly
	// specify a value for MaxResults that is less than the number of registered
	// consumers, the response includes a pagination token named NextToken. You
	// can specify this NextToken value in a subsequent call to ListStreamConsumers
	// to list the next set of registered consumers. For more information about
	// the use of this pagination token when calling the ListStreamConsumers operation,
	// see ListStreamConsumersInput$NextToken.
	//
	// Tokens expire after 300 seconds. When you obtain a value for NextToken in
	// the response to a call to ListStreamConsumers, you have 300 seconds to use
	// that value. If you specify an expired token in a call to ListStreamConsumers,
	// you get ExpiredNextTokenException.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStreamConsumersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStreamConsumersOutput) GoString() string {
	return s.String()
}

// SetConsumers sets the Consumers field's value.
func (s *ListStreamConsumersOutput) SetConsumers(v []*Consumer) *ListStreamConsumersOutput {
	s.Consumers = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListStreamConsumersOutput) SetNextToken(v string) *ListStreamConsumersOutput {
	s.NextToken = &v
	return s
}

// Represents the input for ListStreams.
type ListStreamsInput struct {
	_ struct{} `type:"structure"`

	// The name of the stream to start the list with.
	ExclusiveStartStreamName *string `min:"1" type:"string"`

	// The maximum number of streams to list. The default value is 100. If you specify
	// a value greater than 100, at most 100 results are returned.
	Limit *int64 `min:"1" type:"integer"`

	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStreamsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStreamsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListStreamsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListStreamsInput"}
	if s.ExclusiveStartStreamName != nil && len(*s.ExclusiveStartStreamName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ExclusiveStartStreamName", 1))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExclusiveStartStreamName sets the ExclusiveStartStreamName field's value.
func (s *ListStreamsInput) SetExclusiveStartStreamName(v string) *ListStreamsInput {
	s.ExclusiveStartStreamName = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *ListStreamsInput) SetLimit(v int64) *ListStreamsInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListStreamsInput) SetNextToken(v string) *ListStreamsInput {
	s.NextToken = &v
	return s
}

// Represents the output for ListStreams.
type ListStreamsOutput struct {
	_ struct{} `type:"structure"`

	// If set to true, there are more streams available to list.
	//
	// HasMoreStreams is a required field
	HasMoreStreams *bool `type:"boolean" required:"true"`

	NextToken *string `min:"1" type:"string"`

	// The names of the streams that are associated with the Amazon Web Services
	// account making the ListStreams request.
	//
	// StreamNames is a required field
	StreamNames []*string `type:"list" required:"true"`

	StreamSummaries []*StreamSummary `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStreamsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStreamsOutput) GoString() string {
	return s.String()
}

// SetHasMoreStreams sets the HasMoreStreams field's value.
func (s *ListStreamsOutput) SetHasMoreStreams(v bool) *ListStreamsOutput {
	s.HasMoreStreams = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListStreamsOutput) SetNextToken(v string) *ListStreamsOutput {
	s.NextToken = &v
	return s
}

// SetStreamNames sets the StreamNames field's value.
func (s *ListStreamsOutput) SetStreamNames(v []*string) *ListStreamsOutput {
	s.StreamNames = v
	return s
}

// SetStreamSummaries sets the StreamSummaries field's value.
func (s *ListStreamsOutput) SetStreamSummaries(v []*StreamSummary) *ListStreamsOutput {
	s.StreamSummaries = v
	return s
}

// Represents the input for ListTagsForStream.
type ListTagsForStreamInput struct {
	_ struct{} `type:"structure"`

	// The key to use as the starting point for the list of tags. If this parameter
	// is set, ListTagsForStream gets all tags that occur after ExclusiveStartTagKey.
	ExclusiveStartTagKey *string `min:"1" type:"string"`

	// The number of tags to return. If this number is less than the total number
	// of tags associated with the stream, HasMoreTags is set to true. To list additional
	// tags, set ExclusiveStartTagKey to the last key in the response.
	Limit *int64 `min:"1" type:"integer"`

	// The ARN of the stream.
	StreamARN *string `min:"1" type:"string"`

	// The name of the stream.
	StreamName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForStreamInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForStreamInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForStreamInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForStreamInput"}
	if s.ExclusiveStartTagKey != nil && len(*s.ExclusiveStartTagKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ExclusiveStartTagKey", 1))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.StreamARN != nil && len(*s.StreamARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StreamARN", 1))
	}
	if s.StreamName != nil && len(*s.StreamName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StreamName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExclusiveStartTagKey sets the ExclusiveStartTagKey field's value.
func (s *ListTagsForStreamInput) SetExclusiveStartTagKey(v string) *ListTagsForStreamInput {
	s.ExclusiveStartTagKey = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *ListTagsForStreamInput) SetLimit(v int64) *ListTagsForStreamInput {
	s.Limit = &v
	return s
}

// SetStreamARN sets the StreamARN field's value.
func (s *ListTagsForStreamInput) SetStreamARN(v string) *ListTagsForStreamInput {
	s.StreamARN = &v
	return s
}

// SetStreamName sets the StreamName field's value.
func (s *ListTagsForStreamInput) SetStreamName(v string) *ListTagsForStreamInput {
	s.StreamName = &v
	return s
}

// Represents the output for ListTagsForStream.
type ListTagsForStreamOutput struct {
	_ struct{} `type:"structure"`

	// If set to true, more tags are available. To request additional tags, set
	// ExclusiveStartTagKey to the key of the last tag returned.
	//
	// HasMoreTags is a required field
	HasMoreTags *bool `type:"boolean" required:"true"`

	// A list of tags associated with StreamName, starting with the first tag after
	// ExclusiveStartTagKey and up to the specified Limit.
	//
	// Tags is a required field
	Tags []*Tag `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForStreamOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForStreamOutput) GoString() string {
	return s.String()
}

// SetHasMoreTags sets the HasMoreTags field's value.
func (s *ListTagsForStreamOutput) SetHasMoreTags(v bool) *ListTagsForStreamOutput {
	s.HasMoreTags = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ListTagsForStreamOutput) SetTags(v []*Tag) *ListTagsForStreamOutput {
	s.Tags = v
	return s
}

// Represents the input for MergeShards.
type MergeShardsInput struct {
	_ struct{} `type:"structure"`

	// The shard ID of the adjacent shard for the merge.
	//
	// AdjacentShardToMerge is a required field
	AdjacentShardToMerge *string `min:"1" type:"string" required:"true"`

	// The shard ID of the shard to combine with the adjacent shard for the merge.
	//
	// ShardToMerge is a required field
	ShardToMerge *string `min:"1" type:"string" required:"true"`

	// The ARN of the stream.
	StreamARN *string `min:"1" type:"string"`

	// The name of the stream for the merge.
	StreamName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MergeShardsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MergeShardsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MergeShardsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MergeShardsInput"}
	if s.AdjacentShardToMerge == nil {
		invalidParams.Add(request.NewErrParamRequired("AdjacentShardToMerge"))
	}
	if s.AdjacentShardToMerge != nil && len(*s.AdjacentShardToMerge) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AdjacentShardToMerge", 1))
	}
	if s.ShardToMerge == nil {
		invalidParams.Add(request.NewErrParamRequired("ShardToMerge"))
	}
	if s.ShardToMerge != nil && len(*s.ShardToMerge) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ShardToMerge", 1))
	}
	if s.StreamARN != nil && len(*s.StreamARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StreamARN", 1))
	}
	if s.StreamName != nil && len(*s.StreamName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StreamName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAdjacentShardToMerge sets the AdjacentShardToMerge field's value.
func (s *MergeShardsInput) SetAdjacentShardToMerge(v string) *MergeShardsInput {
	s.AdjacentShardToMerge = &v
	return s
}

// SetShardToMerge sets the ShardToMerge field's value.
func (s *MergeShardsInput) SetShardToMerge(v string) *MergeShardsInput {
	s.ShardToMerge = &v
	return s
}

// SetStreamARN sets the StreamARN field's value.
func (s *MergeShardsInput) SetStreamARN(v string) *MergeShardsInput {
	s.StreamARN = &v
	return s
}

// SetStreamName sets the StreamName field's value.
func (s *MergeShardsInput) SetStreamName(v string) *MergeShardsInput {
	s.StreamName = &v
	return s
}

type MergeShardsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MergeShardsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MergeShardsOutput) GoString() string {
	return s.String()
}

// The request rate for the stream is too high, or the requested data is too
// large for the available throughput. Reduce the frequency or size of your
// requests. For more information, see Streams Limits (https://docs.aws.amazon.com/kinesis/latest/dev/service-sizes-and-limits.html)
// in the Amazon Kinesis Data Streams Developer Guide, and Error Retries and
// Exponential Backoff in Amazon Web Services (https://docs.aws.amazon.com/general/latest/gr/api-retries.html)
// in the Amazon Web Services General Reference.
type ProvisionedThroughputExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A message that provides information about the error.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProvisionedThroughputExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProvisionedThroughputExceededException) GoString() string {
	return s.String()
}

func newErrorProvisionedThroughputExceededException(v protocol.ResponseMetadata) error {
	return &ProvisionedThroughputExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ProvisionedThroughputExceededException) Code() string {
	return "ProvisionedThroughputExceededException"
}

// Message returns the exception's message.
func (s *ProvisionedThroughputExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ProvisionedThroughputExceededException) OrigErr() error {
	return nil
}

func (s *ProvisionedThroughputExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ProvisionedThroughputExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ProvisionedThroughputExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Represents the input for PutRecord.
type PutRecordInput struct {
	_ struct{} `type:"structure"`

	// The data blob to put into the record, which is base64-encoded when the blob
	// is serialized. When the data blob (the payload before base64-encoding) is
	// added to the partition key size, the total size must not exceed the maximum
	// record size (1 MiB).
	// Data is automatically base64 encoded/decoded by the SDK.
	//
	// Data is a required field
	Data []byte `type:"blob" required:"true"`

	// The hash value used to explicitly determine the shard the data record is
	// assigned to by overriding the partition key hash.
	ExplicitHashKey *string `type:"string"`

	// Determines which shard in the stream the data record is assigned to. Partition
	// keys are Unicode strings with a maximum length limit of 256 characters for
	// each key. Amazon Kinesis Data Streams uses the partition key as input to
	// a hash function that maps the partition key and associated data to a specific
	// shard. Specifically, an MD5 hash function is used to map partition keys to
	// 128-bit integer values and to map associated data records to shards. As a
	// result of this hashing mechanism, all data records with the same partition
	// key map to the same shard within the stream.
	//
	// PartitionKey is a required field
	PartitionKey *string `min:"1" type:"string" required:"true"`

	// Guarantees strictly increasing sequence numbers, for puts from the same client
	// and to the same partition key. Usage: set the SequenceNumberForOrdering of
	// record n to the sequence number of record n-1 (as returned in the result
	// when putting record n-1). If this parameter is not set, records are coarsely
	// ordered based on arrival time.
	SequenceNumberForOrdering *string `type:"string"`

	// The ARN of the stream.
	StreamARN *string `min:"1" type:"string"`

	// The name of the stream to put the data record into.
	StreamName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutRecordInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutRecordInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutRecordInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutRecordInput"}
	if s.Data == nil {
		invalidParams.Add(request.NewErrParamRequired("Data"))
	}
	if s.PartitionKey == nil {
		invalidParams.Add(request.NewErrParamRequired("PartitionKey"))
	}
	if s.PartitionKey != nil && len(*s.PartitionKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PartitionKey", 1))
	}
	if s.StreamARN != nil && len(*s.StreamARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StreamARN", 1))
	}
	if s.StreamName != nil && len(*s.StreamName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StreamName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetData sets the Data field's value.
func (s *PutRecordInput) SetData(v []byte) *PutRecordInput {
	s.Data = v
	return s
}

// SetExplicitHashKey sets the ExplicitHashKey field's value.
func (s *PutRecordInput) SetExplicitHashKey(v string) *PutRecordInput {
	s.ExplicitHashKey = &v
	return s
}

// SetPartitionKey sets the PartitionKey field's value.
func (s *PutRecordInput) SetPartitionKey(v string) *PutRecordInput {
	s.PartitionKey = &v
	return s
}

// SetSequenceNumberForOrdering sets the SequenceNumberForOrdering field's value.
func (s *PutRecordInput) SetSequenceNumberForOrdering(v string) *PutRecordInput {
	s.SequenceNumberForOrdering = &v
	return s
}

// SetStreamARN sets the StreamARN field's value.
func (s *PutRecordInput) SetStreamARN(v string) *PutRecordInput {
	s.StreamARN = &v
	return s
}

// SetStreamName sets the StreamName field's value.
func (s *PutRecordInput) SetStreamName(v string) *PutRecordInput {
	s.StreamName = &v
	return s
}

// Represents the output for PutRecord.
type PutRecordOutput struct {
	_ struct{} `type:"structure"`

	// The encryption type to use on the record. This parameter can be one of the
	// following values:
	//
	//    * NONE: Do not encrypt the records in the stream.
	//
	//    * KMS: Use server-side encryption on the records in the stream using a
	//    customer-managed Amazon Web Services KMS key.
	EncryptionType *string `type:"string" enum:"EncryptionType"`

	// The sequence number identifier that was assigned to the put data record.
	// The sequence number for the record is unique across all records in the stream.
	// A sequence number is the identifier associated with every record put into
	// the stream.
	//
	// SequenceNumber is a required field
	SequenceNumber *string `type:"string" required:"true"`

	// The shard ID of the shard where the data record was placed.
	//
	// ShardId is a required field
	ShardId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutRecordOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutRecordOutput) GoString() string {
	return s.String()
}

// SetEncryptionType sets the EncryptionType field's value.
func (s *PutRecordOutput) SetEncryptionType(v string) *PutRecordOutput {
	s.EncryptionType = &v
	return s
}

// SetSequenceNumber sets the SequenceNumber field's value.
func (s *PutRecordOutput) SetSequenceNumber(v string) *PutRecordOutput {
	s.SequenceNumber = &v
	return s
}

// SetShardId sets the ShardId field's value.
func (s *PutRecordOutput) SetShardId(v string) *PutRecordOutput {
	s.ShardId = &v
	return s
}

// A PutRecords request.
type PutRecordsInput struct {
	_ struct{} `type:"structure"`

	// The records associated with the request.
	//
	// Records is a required field
	Records []*PutRecordsRequestEntry `min:"1" type:"list" required:"true"`

	// The ARN of the stream.
	StreamARN *string `min:"1" type:"string"`

	// The stream name associated with the request.
	StreamName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutRecordsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutRecordsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutRecordsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutRecordsInput"}
	if s.Records == nil {
		invalidParams.Add(request.NewErrParamRequired("Records"))
	}
	if s.Records != nil && len(s.Records) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Records", 1))
	}
	if s.StreamARN != nil && len(*s.StreamARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StreamARN", 1))
	}
	if s.StreamName != nil && len(*s.StreamName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StreamName", 1))
	}
	if s.Records != nil {
		for i, v := range s.Records {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Records", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRecords sets the Records field's value.
func (s *PutRecordsInput) SetRecords(v []*PutRecordsRequestEntry) *PutRecordsInput {
	s.Records = v
	return s
}

// SetStreamARN sets the StreamARN field's value.
func (s *PutRecordsInput) SetStreamARN(v string) *PutRecordsInput {
	s.StreamARN = &v
	return s
}

// SetStreamName sets the StreamName field's value.
func (s *PutRecordsInput) SetStreamName(v string) *PutRecordsInput {
	s.StreamName = &v
	return s
}

// PutRecords results.
type PutRecordsOutput struct {
	_ struct{} `type:"structure"`

	// The encryption type used on the records. This parameter can be one of the
	// following values:
	//
	//    * NONE: Do not encrypt the records.
	//
	//    * KMS: Use server-side encryption on the records using a customer-managed
	//    Amazon Web Services KMS key.
	EncryptionType *string `type:"string" enum:"EncryptionType"`

	// The number of unsuccessfully processed records in a PutRecords request.
	FailedRecordCount *int64 `min:"1" type:"integer"`

	// An array of successfully and unsuccessfully processed record results. A record
	// that is successfully added to a stream includes SequenceNumber and ShardId
	// in the result. A record that fails to be added to a stream includes ErrorCode
	// and ErrorMessage in the result.
	//
	// Records is a required field
	Records []*PutRecordsResultEntry `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutRecordsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutRecordsOutput) GoString() string {
	return s.String()
}

// SetEncryptionType sets the EncryptionType field's value.
func (s *PutRecordsOutput) SetEncryptionType(v string) *PutRecordsOutput {
	s.EncryptionType = &v
	return s
}

// SetFailedRecordCount sets the FailedRecordCount field's value.
func (s *PutRecordsOutput) SetFailedRecordCount(v int64) *PutRecordsOutput {
	s.FailedRecordCount = &v
	return s
}

// SetRecords sets the Records field's value.
func (s *PutRecordsOutput) SetRecords(v []*PutRecordsResultEntry) *PutRecordsOutput {
	s.Records = v
	return s
}

// Represents the output for PutRecords.
type PutRecordsRequestEntry struct {
	_ struct{} `type:"structure"`

	// The data blob to put into the record, which is base64-encoded when the blob
	// is serialized. When the data blob (the payload before base64-encoding) is
	// added to the partition key size, the total size must not exceed the maximum
	// record size (1 MiB).
	// Data is automatically base64 encoded/decoded by the SDK.
	//
	// Data is a required field
	Data []byte `type:"blob" required:"true"`

	// The hash value used to determine explicitly the shard that the data record
	// is assigned to by overriding the partition key hash.
	ExplicitHashKey *string `type:"string"`

	// Determines which shard in the stream the data record is assigned to. Partition
	// keys are Unicode strings with a maximum length limit of 256 characters for
	// each key. Amazon Kinesis Data Streams uses the partition key as input to
	// a hash function that maps the partition key and associated data to a specific
	// shard. Specifically, an MD5 hash function is used to map partition keys to
	// 128-bit integer values and to map associated data records to shards. As a
	// result of this hashing mechanism, all data records with the same partition
	// key map to the same shard within the stream.
	//
	// PartitionKey is a required field
	PartitionKey *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutRecordsRequestEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutRecordsRequestEntry) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutRecordsRequestEntry) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutRecordsRequestEntry"}
	if s.Data == nil {
		invalidParams.Add(request.NewErrParamRequired("Data"))
	}
	if s.PartitionKey == nil {
		invalidParams.Add(request.NewErrParamRequired("PartitionKey"))
	}
	if s.PartitionKey != nil && len(*s.PartitionKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PartitionKey", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetData sets the Data field's value.
func (s *PutRecordsRequestEntry) SetData(v []byte) *PutRecordsRequestEntry {
	s.Data = v
	return s
}

// SetExplicitHashKey sets the ExplicitHashKey field's value.
func (s *PutRecordsRequestEntry) SetExplicitHashKey(v string) *PutRecordsRequestEntry {
	s.ExplicitHashKey = &v
	return s
}

// SetPartitionKey sets the PartitionKey field's value.
func (s *PutRecordsRequestEntry) SetPartitionKey(v string) *PutRecordsRequestEntry {
	s.PartitionKey = &v
	return s
}

// Represents the result of an individual record from a PutRecords request.
// A record that is successfully added to a stream includes SequenceNumber and
// ShardId in the result. A record that fails to be added to the stream includes
// ErrorCode and ErrorMessage in the result.
type PutRecordsResultEntry struct {
	_ struct{} `type:"structure"`

	// The error code for an individual record result. ErrorCodes can be either
	// ProvisionedThroughputExceededException or InternalFailure.
	ErrorCode *string `type:"string"`

	// The error message for an individual record result. An ErrorCode value of
	// ProvisionedThroughputExceededException has an error message that includes
	// the account ID, stream name, and shard ID. An ErrorCode value of InternalFailure
	// has the error message "Internal Service Failure".
	ErrorMessage *string `type:"string"`

	// The sequence number for an individual record result.
	SequenceNumber *string `type:"string"`

	// The shard ID for an individual record result.
	ShardId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutRecordsResultEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutRecordsResultEntry) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *PutRecordsResultEntry) SetErrorCode(v string) *PutRecordsResultEntry {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *PutRecordsResultEntry) SetErrorMessage(v string) *PutRecordsResultEntry {
	s.ErrorMessage = &v
	return s
}

// SetSequenceNumber sets the SequenceNumber field's value.
func (s *PutRecordsResultEntry) SetSequenceNumber(v string) *PutRecordsResultEntry {
	s.SequenceNumber = &v
	return s
}

// SetShardId sets the ShardId field's value.
func (s *PutRecordsResultEntry) SetShardId(v string) *PutRecordsResultEntry {
	s.ShardId = &v
	return s
}

type PutResourcePolicyInput struct {
	_ struct{} `type:"structure"`

	// Details of the resource policy. It must include the identity of the principal
	// and the actions allowed on this resource. This is formatted as a JSON string.
	//
	// Policy is a required field
	Policy *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the data stream or consumer.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutResourcePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutResourcePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutResourcePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutResourcePolicyInput"}
	if s.Policy == nil {
		invalidParams.Add(request.NewErrParamRequired("Policy"))
	}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicy sets the Policy field's value.
func (s *PutResourcePolicyInput) SetPolicy(v string) *PutResourcePolicyInput {
	s.Policy = &v
	return s
}

// SetResourceARN sets the ResourceARN field's value.
func (s *PutResourcePolicyInput) SetResourceARN(v string) *PutResourcePolicyInput {
	s.ResourceARN = &v
	return s
}

type PutResourcePolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutResourcePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutResourcePolicyOutput) GoString() string {
	return s.String()
}

// The unit of data of the Kinesis data stream, which is composed of a sequence
// number, a partition key, and a data blob.
type Record struct {
	_ struct{} `type:"structure"`

	// The approximate time that the record was inserted into the stream.
	ApproximateArrivalTimestamp *time.Time `type:"timestamp"`

	// The data blob. The data in the blob is both opaque and immutable to Kinesis
	// Data Streams, which does not inspect, interpret, or change the data in the
	// blob in any way. When the data blob (the payload before base64-encoding)
	// is added to the partition key size, the total size must not exceed the maximum
	// record size (1 MiB).
	// Data is automatically base64 encoded/decoded by the SDK.
	//
	// Data is a required field
	Data []byte `type:"blob" required:"true"`

	// The encryption type used on the record. This parameter can be one of the
	// following values:
	//
	//    * NONE: Do not encrypt the records in the stream.
	//
	//    * KMS: Use server-side encryption on the records in the stream using a
	//    customer-managed Amazon Web Services KMS key.
	EncryptionType *string `type:"string" enum:"EncryptionType"`

	// Identifies which shard in the stream the data record is assigned to.
	//
	// PartitionKey is a required field
	PartitionKey *string `min:"1" type:"string" required:"true"`

	// The unique identifier of the record within its shard.
	//
	// SequenceNumber is a required field
	SequenceNumber *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Record) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Record) GoString() string {
	return s.String()
}

// SetApproximateArrivalTimestamp sets the ApproximateArrivalTimestamp field's value.
func (s *Record) SetApproximateArrivalTimestamp(v time.Time) *Record {
	s.ApproximateArrivalTimestamp = &v
	return s
}

// SetData sets the Data field's value.
func (s *Record) SetData(v []byte) *Record {
	s.Data = v
	return s
}

// SetEncryptionType sets the EncryptionType field's value.
func (s *Record) SetEncryptionType(v string) *Record {
	s.EncryptionType = &v
	return s
}

// SetPartitionKey sets the PartitionKey field's value.
func (s *Record) SetPartitionKey(v string) *Record {
	s.PartitionKey = &v
	return s
}

// SetSequenceNumber sets the SequenceNumber field's value.
func (s *Record) SetSequenceNumber(v string) *Record {
	s.SequenceNumber = &v
	return s
}

type RegisterStreamConsumerInput struct {
	_ struct{} `type:"structure"`

	// For a given Kinesis data stream, each consumer must have a unique name. However,
	// consumer names don't have to be unique across data streams.
	//
	// ConsumerName is a required field
	ConsumerName *string `min:"1" type:"string" required:"true"`

	// The ARN of the Kinesis data stream that you want to register the consumer
	// with. For more info, see Amazon Resource Names (ARNs) and Amazon Web Services
	// Service Namespaces (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-kinesis-streams).
	//
	// StreamARN is a required field
	StreamARN *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegisterStreamConsumerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegisterStreamConsumerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RegisterStreamConsumerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RegisterStreamConsumerInput"}
	if s.ConsumerName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConsumerName"))
	}
	if s.ConsumerName != nil && len(*s.ConsumerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConsumerName", 1))
	}
	if s.StreamARN == nil {
		invalidParams.Add(request.NewErrParamRequired("StreamARN"))
	}
	if s.StreamARN != nil && len(*s.StreamARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StreamARN", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConsumerName sets the ConsumerName field's value.
func (s *RegisterStreamConsumerInput) SetConsumerName(v string) *RegisterStreamConsumerInput {
	s.ConsumerName = &v
	return s
}

// SetStreamARN sets the StreamARN field's value.
func (s *RegisterStreamConsumerInput) SetStreamARN(v string) *RegisterStreamConsumerInput {
	s.StreamARN = &v
	return s
}

type RegisterStreamConsumerOutput struct {
	_ struct{} `type:"structure"`

	// An object that represents the details of the consumer you registered. When
	// you register a consumer, it gets an ARN that is generated by Kinesis Data
	// Streams.
	//
	// Consumer is a required field
	Consumer *Consumer `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegisterStreamConsumerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegisterStreamConsumerOutput) GoString() string {
	return s.String()
}

// SetConsumer sets the Consumer field's value.
func (s *RegisterStreamConsumerOutput) SetConsumer(v *Consumer) *RegisterStreamConsumerOutput {
	s.Consumer = v
	return s
}

// Represents the input for RemoveTagsFromStream.
type RemoveTagsFromStreamInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the stream.
	StreamARN *string `min:"1" type:"string"`

	// The name of the stream.
	StreamName *string `min:"1" type:"string"`

	// A list of tag keys. Each corresponding tag is removed from the stream.
	//
	// TagKeys is a required field
	TagKeys []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoveTagsFromStreamInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoveTagsFromStreamInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveTagsFromStreamInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RemoveTagsFromStreamInput"}
	if s.StreamARN != nil && len(*s.StreamARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StreamARN", 1))
	}
	if s.StreamName != nil && len(*s.StreamName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StreamName", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}
	if s.TagKeys != nil && len(s.TagKeys) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagKeys", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStreamARN sets the StreamARN field's value.
func (s *RemoveTagsFromStreamInput) SetStreamARN(v string) *RemoveTagsFromStreamInput {
	s.StreamARN = &v
	return s
}

// SetStreamName sets the StreamName field's value.
func (s *RemoveTagsFromStreamInput) SetStreamName(v string) *RemoveTagsFromStreamInput {
	s.StreamName = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *RemoveTagsFromStreamInput) SetTagKeys(v []*string) *RemoveTagsFromStreamInput {
	s.TagKeys = v
	return s
}

type RemoveTagsFromStreamOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoveTagsFromStreamOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoveTagsFromStreamOutput) GoString() string {
	return s.String()
}

// The resource is not available for this operation. For successful operation,
// the resource must be in the ACTIVE state.
type ResourceInUseException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A message that provides information about the error.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceInUseException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceInUseException) GoString() string {
	return s.String()
}

// The ResourceInUseException is and event in the SubscribeToShardEventStream group of events.
func (s *ResourceInUseException) eventSubscribeToShardEventStream() {}

// UnmarshalEvent unmarshals the EventStream Message into the ResourceInUseException value.
// This method is only used internally within the SDK's EventStream handling.
func (s *ResourceInUseException) UnmarshalEvent(
	payloadUnmarshaler protocol.PayloadUnmarshaler,
	msg eventstream.Message,
) error {
	if err := payloadUnmarshaler.UnmarshalPayload(
		bytes.NewReader(msg.Payload), s,
	); err != nil {
		return err
	}
	return nil
}

// MarshalEvent marshals the type into an stream event value. This method
// should only used internally within the SDK's EventStream handling.
func (s *ResourceInUseException) MarshalEvent(pm protocol.PayloadMarshaler) (msg eventstream.Message, err error) {
	msg.Headers.Set(eventstreamapi.MessageTypeHeader, eventstream.StringValue(eventstreamapi.ExceptionMessageType))
	var buf bytes.Buffer
	if err = pm.MarshalPayload(&buf, s); err != nil {
		return eventstream.Message{}, err
	}
	msg.Payload = buf.Bytes()
	return msg, err
}

func newErrorResourceInUseException(v protocol.ResponseMetadata) error {
	return &ResourceInUseException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceInUseException) Code() string {
	return "ResourceInUseException"
}

// Message returns the exception's message.
func (s *ResourceInUseException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceInUseException) OrigErr() error {
	return nil
}

func (s *ResourceInUseException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceInUseException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceInUseException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The requested resource could not be found. The stream might not be specified
// correctly.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A message that provides information about the error.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

// The ResourceNotFoundException is and event in the SubscribeToShardEventStream group of events.
func (s *ResourceNotFoundException) eventSubscribeToShardEventStream() {}

// UnmarshalEvent unmarshals the EventStream Message into the ResourceNotFoundException value.
// This method is only used internally within the SDK's EventStream handling.
func (s *ResourceNotFoundException) UnmarshalEvent(
	payloadUnmarshaler protocol.PayloadUnmarshaler,
	msg eventstream.Message,
) error {
	if err := payloadUnmarshaler.UnmarshalPayload(
		bytes.NewReader(msg.Payload), s,
	); err != nil {
		return err
	}
	return nil
}

// MarshalEvent marshals the type into an stream event value. This method
// should only used internally within the SDK's EventStream handling.
func (s *ResourceNotFoundException) MarshalEvent(pm protocol.PayloadMarshaler) (msg eventstream.Message, err error) {
	msg.Headers.Set(eventstreamapi.MessageTypeHeader, eventstream.StringValue(eventstreamapi.ExceptionMessageType))
	var buf bytes.Buffer
	if err = pm.MarshalPayload(&buf, s); err != nil {
		return eventstream.Message{}, err
	}
	msg.Payload = buf.Bytes()
	return msg, err
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The range of possible sequence numbers for the shard.
type SequenceNumberRange struct {
	_ struct{} `type:"structure"`

	// The ending sequence number for the range. Shards that are in the OPEN state
	// have an ending sequence number of null.
	EndingSequenceNumber *string `type:"string"`

	// The starting sequence number for the range.
	//
	// StartingSequenceNumber is a required field
	StartingSequenceNumber *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SequenceNumberRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SequenceNumberRange) GoString() string {
	return s.String()
}

// SetEndingSequenceNumber sets the EndingSequenceNumber field's value.
func (s *SequenceNumberRange) SetEndingSequenceNumber(v string) *SequenceNumberRange {
	s.EndingSequenceNumber = &v
	return s
}

// SetStartingSequenceNumber sets the StartingSequenceNumber field's value.
func (s *SequenceNumberRange) SetStartingSequenceNumber(v string) *SequenceNumberRange {
	s.StartingSequenceNumber = &v
	return s
}

// A uniquely identified group of data records in a Kinesis data stream.
type Shard struct {
	_ struct{} `type:"structure"`

	// The shard ID of the shard adjacent to the shard's parent.
	AdjacentParentShardId *string `min:"1" type:"string"`

	// The range of possible hash key values for the shard, which is a set of ordered
	// contiguous positive integers.
	//
	// HashKeyRange is a required field
	HashKeyRange *HashKeyRange `type:"structure" required:"true"`

	// The shard ID of the shard's parent.
	ParentShardId *string `min:"1" type:"string"`

	// The range of possible sequence numbers for the shard.
	//
	// SequenceNumberRange is a required field
	SequenceNumberRange *SequenceNumberRange `type:"structure" required:"true"`

	// The unique identifier of the shard within the stream.
	//
	// ShardId is a required field
	ShardId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Shard) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Shard) GoString() string {
	return s.String()
}

// SetAdjacentParentShardId sets the AdjacentParentShardId field's value.
func (s *Shard) SetAdjacentParentShardId(v string) *Shard {
	s.AdjacentParentShardId = &v
	return s
}

// SetHashKeyRange sets the HashKeyRange field's value.
func (s *Shard) SetHashKeyRange(v *HashKeyRange) *Shard {
	s.HashKeyRange = v
	return s
}

// SetParentShardId sets the ParentShardId field's value.
func (s *Shard) SetParentShardId(v string) *Shard {
	s.ParentShardId = &v
	return s
}

// SetSequenceNumberRange sets the SequenceNumberRange field's value.
func (s *Shard) SetSequenceNumberRange(v *SequenceNumberRange) *Shard {
	s.SequenceNumberRange = v
	return s
}

// SetShardId sets the ShardId field's value.
func (s *Shard) SetShardId(v string) *Shard {
	s.ShardId = &v
	return s
}

// The request parameter used to filter out the response of the ListShards API.
type ShardFilter struct {
	_ struct{} `type:"structure"`

	// The exclusive start shardID speified in the ShardFilter parameter. This property
	// can only be used if the AFTER_SHARD_ID shard type is specified.
	ShardId *string `min:"1" type:"string"`

	// The timestamps specified in the ShardFilter parameter. A timestamp is a Unix
	// epoch date with precision in milliseconds. For example, 2016-04-04T19:58:46.480-00:00
	// or 1459799926.480. This property can only be used if FROM_TIMESTAMP or AT_TIMESTAMP
	// shard types are specified.
	Timestamp *time.Time `type:"timestamp"`

	// The shard type specified in the ShardFilter parameter. This is a required
	// property of the ShardFilter parameter.
	//
	// You can specify the following valid values:
	//
	//    * AFTER_SHARD_ID - the response includes all the shards, starting with
	//    the shard whose ID immediately follows the ShardId that you provided.
	//
	//    * AT_TRIM_HORIZON - the response includes all the shards that were open
	//    at TRIM_HORIZON.
	//
	//    * FROM_TRIM_HORIZON - (default), the response includes all the shards
	//    within the retention period of the data stream (trim to tip).
	//
	//    * AT_LATEST - the response includes only the currently open shards of
	//    the data stream.
	//
	//    * AT_TIMESTAMP - the response includes all shards whose start timestamp
	//    is less than or equal to the given timestamp and end timestamp is greater
	//    than or equal to the given timestamp or still open.
	//
	//    * FROM_TIMESTAMP - the response incldues all closed shards whose end timestamp
	//    is greater than or equal to the given timestamp and also all open shards.
	//    Corrected to TRIM_HORIZON of the data stream if FROM_TIMESTAMP is less
	//    than the TRIM_HORIZON value.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"ShardFilterType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ShardFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ShardFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ShardFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ShardFilter"}
	if s.ShardId != nil && len(*s.ShardId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ShardId", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetShardId sets the ShardId field's value.
func (s *ShardFilter) SetShardId(v string) *ShardFilter {
	s.ShardId = &v
	return s
}

// SetTimestamp sets the Timestamp field's value.
func (s *ShardFilter) SetTimestamp(v time.Time) *ShardFilter {
	s.Timestamp = &v
	return s
}

// SetType sets the Type field's value.
func (s *ShardFilter) SetType(v string) *ShardFilter {
	s.Type = &v
	return s
}

// Represents the input for SplitShard.
type SplitShardInput struct {
	_ struct{} `type:"structure"`

	// A hash key value for the starting hash key of one of the child shards created
	// by the split. The hash key range for a given shard constitutes a set of ordered
	// contiguous positive integers. The value for NewStartingHashKey must be in
	// the range of hash keys being mapped into the shard. The NewStartingHashKey
	// hash key value and all higher hash key values in hash key range are distributed
	// to one of the child shards. All the lower hash key values in the range are
	// distributed to the other child shard.
	//
	// NewStartingHashKey is a required field
	NewStartingHashKey *string `type:"string" required:"true"`

	// The shard ID of the shard to split.
	//
	// ShardToSplit is a required field
	ShardToSplit *string `min:"1" type:"string" required:"true"`

	// The ARN of the stream.
	StreamARN *string `min:"1" type:"string"`

	// The name of the stream for the shard split.
	StreamName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SplitShardInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SplitShardInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SplitShardInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SplitShardInput"}
	if s.NewStartingHashKey == nil {
		invalidParams.Add(request.NewErrParamRequired("NewStartingHashKey"))
	}
	if s.ShardToSplit == nil {
		invalidParams.Add(request.NewErrParamRequired("ShardToSplit"))
	}
	if s.ShardToSplit != nil && len(*s.ShardToSplit) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ShardToSplit", 1))
	}
	if s.StreamARN != nil && len(*s.StreamARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StreamARN", 1))
	}
	if s.StreamName != nil && len(*s.StreamName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StreamName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNewStartingHashKey sets the NewStartingHashKey field's value.
func (s *SplitShardInput) SetNewStartingHashKey(v string) *SplitShardInput {
	s.NewStartingHashKey = &v
	return s
}

// SetShardToSplit sets the ShardToSplit field's value.
func (s *SplitShardInput) SetShardToSplit(v string) *SplitShardInput {
	s.ShardToSplit = &v
	return s
}

// SetStreamARN sets the StreamARN field's value.
func (s *SplitShardInput) SetStreamARN(v string) *SplitShardInput {
	s.StreamARN = &v
	return s
}

// SetStreamName sets the StreamName field's value.
func (s *SplitShardInput) SetStreamName(v string) *SplitShardInput {
	s.StreamName = &v
	return s
}

type SplitShardOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SplitShardOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SplitShardOutput) GoString() string {
	return s.String()
}

type StartStreamEncryptionInput struct {
	_ struct{} `type:"structure"`

	// The encryption type to use. The only valid value is KMS.
	//
	// EncryptionType is a required field
	EncryptionType *string `type:"string" required:"true" enum:"EncryptionType"`

	// The GUID for the customer-managed Amazon Web Services KMS key to use for
	// encryption. This value can be a globally unique identifier, a fully specified
	// Amazon Resource Name (ARN) to either an alias or a key, or an alias name
	// prefixed by "alias/".You can also use a master key owned by Kinesis Data
	// Streams by specifying the alias aws/kinesis.
	//
	//    * Key ARN example: arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012
	//
	//    * Alias ARN example: arn:aws:kms:us-east-1:123456789012:alias/MyAliasName
	//
	//    * Globally unique key ID example: 12345678-1234-1234-1234-123456789012
	//
	//    * Alias name example: alias/MyAliasName
	//
	//    * Master key owned by Kinesis Data Streams: alias/aws/kinesis
	//
	// KeyId is a required field
	KeyId *string `min:"1" type:"string" required:"true"`

	// The ARN of the stream.
	StreamARN *string `min:"1" type:"string"`

	// The name of the stream for which to start encrypting records.
	StreamName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartStreamEncryptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartStreamEncryptionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartStreamEncryptionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartStreamEncryptionInput"}
	if s.EncryptionType == nil {
		invalidParams.Add(request.NewErrParamRequired("EncryptionType"))
	}
	if s.KeyId == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyId"))
	}
	if s.KeyId != nil && len(*s.KeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyId", 1))
	}
	if s.StreamARN != nil && len(*s.StreamARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StreamARN", 1))
	}
	if s.StreamName != nil && len(*s.StreamName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StreamName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEncryptionType sets the EncryptionType field's value.
func (s *StartStreamEncryptionInput) SetEncryptionType(v string) *StartStreamEncryptionInput {
	s.EncryptionType = &v
	return s
}

// SetKeyId sets the KeyId field's value.
func (s *StartStreamEncryptionInput) SetKeyId(v string) *StartStreamEncryptionInput {
	s.KeyId = &v
	return s
}

// SetStreamARN sets the StreamARN field's value.
func (s *StartStreamEncryptionInput) SetStreamARN(v string) *StartStreamEncryptionInput {
	s.StreamARN = &v
	return s
}

// SetStreamName sets the StreamName field's value.
func (s *StartStreamEncryptionInput) SetStreamName(v string) *StartStreamEncryptionInput {
	s.StreamName = &v
	return s
}

type StartStreamEncryptionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartStreamEncryptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartStreamEncryptionOutput) GoString() string {
	return s.String()
}

// The starting position in the data stream from which to start streaming.
type StartingPosition struct {
	_ struct{} `type:"structure"`

	// The sequence number of the data record in the shard from which to start streaming.
	// To specify a sequence number, set StartingPosition to AT_SEQUENCE_NUMBER
	// or AFTER_SEQUENCE_NUMBER.
	SequenceNumber *string `type:"string"`

	// The time stamp of the data record from which to start reading. To specify
	// a time stamp, set StartingPosition to Type AT_TIMESTAMP. A time stamp is
	// the Unix epoch date with precision in milliseconds. For example, 2016-04-04T19:58:46.480-00:00
	// or 1459799926.480. If a record with this exact time stamp does not exist,
	// records will be streamed from the next (later) record. If the time stamp
	// is older than the current trim horizon, records will be streamed from the
	// oldest untrimmed data record (TRIM_HORIZON).
	Timestamp *time.Time `type:"timestamp"`

	// You can set the starting position to one of the following values:
	//
	// AT_SEQUENCE_NUMBER: Start streaming from the position denoted by the sequence
	// number specified in the SequenceNumber field.
	//
	// AFTER_SEQUENCE_NUMBER: Start streaming right after the position denoted by
	// the sequence number specified in the SequenceNumber field.
	//
	// AT_TIMESTAMP: Start streaming from the position denoted by the time stamp
	// specified in the Timestamp field.
	//
	// TRIM_HORIZON: Start streaming at the last untrimmed record in the shard,
	// which is the oldest data record in the shard.
	//
	// LATEST: Start streaming just after the most recent record in the shard, so
	// that you always read the most recent data in the shard.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"ShardIteratorType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartingPosition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartingPosition) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartingPosition) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartingPosition"}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSequenceNumber sets the SequenceNumber field's value.
func (s *StartingPosition) SetSequenceNumber(v string) *StartingPosition {
	s.SequenceNumber = &v
	return s
}

// SetTimestamp sets the Timestamp field's value.
func (s *StartingPosition) SetTimestamp(v time.Time) *StartingPosition {
	s.Timestamp = &v
	return s
}

// SetType sets the Type field's value.
func (s *StartingPosition) SetType(v string) *StartingPosition {
	s.Type = &v
	return s
}

type StopStreamEncryptionInput struct {
	_ struct{} `type:"structure"`

	// The encryption type. The only valid value is KMS.
	//
	// EncryptionType is a required field
	EncryptionType *string `type:"string" required:"true" enum:"EncryptionType"`

	// The GUID for the customer-managed Amazon Web Services KMS key to use for
	// encryption. This value can be a globally unique identifier, a fully specified
	// Amazon Resource Name (ARN) to either an alias or a key, or an alias name
	// prefixed by "alias/".You can also use a master key owned by Kinesis Data
	// Streams by specifying the alias aws/kinesis.
	//
	//    * Key ARN example: arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012
	//
	//    * Alias ARN example: arn:aws:kms:us-east-1:123456789012:alias/MyAliasName
	//
	//    * Globally unique key ID example: 12345678-1234-1234-1234-123456789012
	//
	//    * Alias name example: alias/MyAliasName
	//
	//    * Master key owned by Kinesis Data Streams: alias/aws/kinesis
	//
	// KeyId is a required field
	KeyId *string `min:"1" type:"string" required:"true"`

	// The ARN of the stream.
	StreamARN *string `min:"1" type:"string"`

	// The name of the stream on which to stop encrypting records.
	StreamName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopStreamEncryptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopStreamEncryptionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopStreamEncryptionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopStreamEncryptionInput"}
	if s.EncryptionType == nil {
		invalidParams.Add(request.NewErrParamRequired("EncryptionType"))
	}
	if s.KeyId == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyId"))
	}
	if s.KeyId != nil && len(*s.KeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyId", 1))
	}
	if s.StreamARN != nil && len(*s.StreamARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StreamARN", 1))
	}
	if s.StreamName != nil && len(*s.StreamName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StreamName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEncryptionType sets the EncryptionType field's value.
func (s *StopStreamEncryptionInput) SetEncryptionType(v string) *StopStreamEncryptionInput {
	s.EncryptionType = &v
	return s
}

// SetKeyId sets the KeyId field's value.
func (s *StopStreamEncryptionInput) SetKeyId(v string) *StopStreamEncryptionInput {
	s.KeyId = &v
	return s
}

// SetStreamARN sets the StreamARN field's value.
func (s *StopStreamEncryptionInput) SetStreamARN(v string) *StopStreamEncryptionInput {
	s.StreamARN = &v
	return s
}

// SetStreamName sets the StreamName field's value.
func (s *StopStreamEncryptionInput) SetStreamName(v string) *StopStreamEncryptionInput {
	s.StreamName = &v
	return s
}

type StopStreamEncryptionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopStreamEncryptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopStreamEncryptionOutput) GoString() string {
	return s.String()
}

// Represents the output for DescribeStream.
type StreamDescription struct {
	_ struct{} `type:"structure"`

	// The server-side encryption type used on the stream. This parameter can be
	// one of the following values:
	//
	//    * NONE: Do not encrypt the records in the stream.
	//
	//    * KMS: Use server-side encryption on the records in the stream using a
	//    customer-managed Amazon Web Services KMS key.
	EncryptionType *string `type:"string" enum:"EncryptionType"`

	// Represents the current enhanced monitoring settings of the stream.
	//
	// EnhancedMonitoring is a required field
	EnhancedMonitoring []*EnhancedMetrics `type:"list" required:"true"`

	// If set to true, more shards in the stream are available to describe.
	//
	// HasMoreShards is a required field
	HasMoreShards *bool `type:"boolean" required:"true"`

	// The GUID for the customer-managed Amazon Web Services KMS key to use for
	// encryption. This value can be a globally unique identifier, a fully specified
	// ARN to either an alias or a key, or an alias name prefixed by "alias/".You
	// can also use a master key owned by Kinesis Data Streams by specifying the
	// alias aws/kinesis.
	//
	//    * Key ARN example: arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012
	//
	//    * Alias ARN example: arn:aws:kms:us-east-1:123456789012:alias/MyAliasName
	//
	//    * Globally unique key ID example: 12345678-1234-1234-1234-123456789012
	//
	//    * Alias name example: alias/MyAliasName
	//
	//    * Master key owned by Kinesis Data Streams: alias/aws/kinesis
	KeyId *string `min:"1" type:"string"`

	// The current retention period, in hours. Minimum value of 24. Maximum value
	// of 168.
	//
	// RetentionPeriodHours is a required field
	RetentionPeriodHours *int64 `type:"integer" required:"true"`

	// The shards that comprise the stream.
	//
	// Shards is a required field
	Shards []*Shard `type:"list" required:"true"`

	// The Amazon Resource Name (ARN) for the stream being described.
	//
	// StreamARN is a required field
	StreamARN *string `min:"1" type:"string" required:"true"`

	// The approximate time that the stream was created.
	//
	// StreamCreationTimestamp is a required field
	StreamCreationTimestamp *time.Time `type:"timestamp" required:"true"`

	// Specifies the capacity mode to which you want to set your data stream. Currently,
	// in Kinesis Data Streams, you can choose between an on-demand capacity mode
	// and a provisioned capacity mode for your data streams.
	StreamModeDetails *StreamModeDetails `type:"structure"`

	// The name of the stream being described.
	//
	// StreamName is a required field
	StreamName *string `min:"1" type:"string" required:"true"`

	// The current status of the stream being described. The stream status is one
	// of the following states:
	//
	//    * CREATING - The stream is being created. Kinesis Data Streams immediately
	//    returns and sets StreamStatus to CREATING.
	//
	//    * DELETING - The stream is being deleted. The specified stream is in the
	//    DELETING state until Kinesis Data Streams completes the deletion.
	//
	//    * ACTIVE - The stream exists and is ready for read and write operations
	//    or deletion. You should perform read and write operations only on an ACTIVE
	//    stream.
	//
	//    * UPDATING - Shards in the stream are being merged or split. Read and
	//    write operations continue to work while the stream is in the UPDATING
	//    state.
	//
	// StreamStatus is a required field
	StreamStatus *string `type:"string" required:"true" enum:"StreamStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StreamDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StreamDescription) GoString() string {
	return s.String()
}

// SetEncryptionType sets the EncryptionType field's value.
func (s *StreamDescription) SetEncryptionType(v string) *StreamDescription {
	s.EncryptionType = &v
	return s
}

// SetEnhancedMonitoring sets the EnhancedMonitoring field's value.
func (s *StreamDescription) SetEnhancedMonitoring(v []*EnhancedMetrics) *StreamDescription {
	s.EnhancedMonitoring = v
	return s
}

// SetHasMoreShards sets the HasMoreShards field's value.
func (s *StreamDescription) SetHasMoreShards(v bool) *StreamDescription {
	s.HasMoreShards = &v
	return s
}

// SetKeyId sets the KeyId field's value.
func (s *StreamDescription) SetKeyId(v string) *StreamDescription {
	s.KeyId = &v
	return s
}

// SetRetentionPeriodHours sets the RetentionPeriodHours field's value.
func (s *StreamDescription) SetRetentionPeriodHours(v int64) *StreamDescription {
	s.RetentionPeriodHours = &v
	return s
}

// SetShards sets the Shards field's value.
func (s *StreamDescription) SetShards(v []*Shard) *StreamDescription {
	s.Shards = v
	return s
}

// SetStreamARN sets the StreamARN field's value.
func (s *StreamDescription) SetStreamARN(v string) *StreamDescription {
	s.StreamARN = &v
	return s
}

// SetStreamCreationTimestamp sets the StreamCreationTimestamp field's value.
func (s *StreamDescription) SetStreamCreationTimestamp(v time.Time) *StreamDescription {
	s.StreamCreationTimestamp = &v
	return s
}

// SetStreamModeDetails sets the StreamModeDetails field's value.
func (s *StreamDescription) SetStreamModeDetails(v *StreamModeDetails) *StreamDescription {
	s.StreamModeDetails = v
	return s
}

// SetStreamName sets the StreamName field's value.
func (s *StreamDescription) SetStreamName(v string) *StreamDescription {
	s.StreamName = &v
	return s
}

// SetStreamStatus sets the StreamStatus field's value.
func (s *StreamDescription) SetStreamStatus(v string) *StreamDescription {
	s.StreamStatus = &v
	return s
}

// Represents the output for DescribeStreamSummary
type StreamDescriptionSummary struct {
	_ struct{} `type:"structure"`

	// The number of enhanced fan-out consumers registered with the stream.
	ConsumerCount *int64 `type:"integer"`

	// The encryption type used. This value is one of the following:
	//
	//    * KMS
	//
	//    * NONE
	EncryptionType *string `type:"string" enum:"EncryptionType"`

	// Represents the current enhanced monitoring settings of the stream.
	//
	// EnhancedMonitoring is a required field
	EnhancedMonitoring []*EnhancedMetrics `type:"list" required:"true"`

	// The GUID for the customer-managed Amazon Web Services KMS key to use for
	// encryption. This value can be a globally unique identifier, a fully specified
	// ARN to either an alias or a key, or an alias name prefixed by "alias/".You
	// can also use a master key owned by Kinesis Data Streams by specifying the
	// alias aws/kinesis.
	//
	//    * Key ARN example: arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012
	//
	//    * Alias ARN example: arn:aws:kms:us-east-1:123456789012:alias/MyAliasName
	//
	//    * Globally unique key ID example: 12345678-1234-1234-1234-123456789012
	//
	//    * Alias name example: alias/MyAliasName
	//
	//    * Master key owned by Kinesis Data Streams: alias/aws/kinesis
	KeyId *string `min:"1" type:"string"`

	// The number of open shards in the stream.
	//
	// OpenShardCount is a required field
	OpenShardCount *int64 `type:"integer" required:"true"`

	// The current retention period, in hours.
	//
	// RetentionPeriodHours is a required field
	RetentionPeriodHours *int64 `type:"integer" required:"true"`

	// The Amazon Resource Name (ARN) for the stream being described.
	//
	// StreamARN is a required field
	StreamARN *string `min:"1" type:"string" required:"true"`

	// The approximate time that the stream was created.
	//
	// StreamCreationTimestamp is a required field
	StreamCreationTimestamp *time.Time `type:"timestamp" required:"true"`

	// Specifies the capacity mode to which you want to set your data stream. Currently,
	// in Kinesis Data Streams, you can choose between an on-demand ycapacity mode
	// and a provisioned capacity mode for your data streams.
	StreamModeDetails *StreamModeDetails `type:"structure"`

	// The name of the stream being described.
	//
	// StreamName is a required field
	StreamName *string `min:"1" type:"string" required:"true"`

	// The current status of the stream being described. The stream status is one
	// of the following states:
	//
	//    * CREATING - The stream is being created. Kinesis Data Streams immediately
	//    returns and sets StreamStatus to CREATING.
	//
	//    * DELETING - The stream is being deleted. The specified stream is in the
	//    DELETING state until Kinesis Data Streams completes the deletion.
	//
	//    * ACTIVE - The stream exists and is ready for read and write operations
	//    or deletion. You should perform read and write operations only on an ACTIVE
	//    stream.
	//
	//    * UPDATING - Shards in the stream are being merged or split. Read and
	//    write operations continue to work while the stream is in the UPDATING
	//    state.
	//
	// StreamStatus is a required field
	StreamStatus *string `type:"string" required:"true" enum:"StreamStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StreamDescriptionSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StreamDescriptionSummary) GoString() string {
	return s.String()
}

// SetConsumerCount sets the ConsumerCount field's value.
func (s *StreamDescriptionSummary) SetConsumerCount(v int64) *StreamDescriptionSummary {
	s.ConsumerCount = &v
	return s
}

// SetEncryptionType sets the EncryptionType field's value.
func (s *StreamDescriptionSummary) SetEncryptionType(v string) *StreamDescriptionSummary {
	s.EncryptionType = &v
	return s
}

// SetEnhancedMonitoring sets the EnhancedMonitoring field's value.
func (s *StreamDescriptionSummary) SetEnhancedMonitoring(v []*EnhancedMetrics) *StreamDescriptionSummary {
	s.EnhancedMonitoring = v
	return s
}

// SetKeyId sets the KeyId field's value.
func (s *StreamDescriptionSummary) SetKeyId(v string) *StreamDescriptionSummary {
	s.KeyId = &v
	return s
}

// SetOpenShardCount sets the OpenShardCount field's value.
func (s *StreamDescriptionSummary) SetOpenShardCount(v int64) *StreamDescriptionSummary {
	s.OpenShardCount = &v
	return s
}

// SetRetentionPeriodHours sets the RetentionPeriodHours field's value.
func (s *StreamDescriptionSummary) SetRetentionPeriodHours(v int64) *StreamDescriptionSummary {
	s.RetentionPeriodHours = &v
	return s
}

// SetStreamARN sets the StreamARN field's value.
func (s *StreamDescriptionSummary) SetStreamARN(v string) *StreamDescriptionSummary {
	s.StreamARN = &v
	return s
}

// SetStreamCreationTimestamp sets the StreamCreationTimestamp field's value.
func (s *StreamDescriptionSummary) SetStreamCreationTimestamp(v time.Time) *StreamDescriptionSummary {
	s.StreamCreationTimestamp = &v
	return s
}

// SetStreamModeDetails sets the StreamModeDetails field's value.
func (s *StreamDescriptionSummary) SetStreamModeDetails(v *StreamModeDetails) *StreamDescriptionSummary {
	s.StreamModeDetails = v
	return s
}

// SetStreamName sets the StreamName field's value.
func (s *StreamDescriptionSummary) SetStreamName(v string) *StreamDescriptionSummary {
	s.StreamName = &v
	return s
}

// SetStreamStatus sets the StreamStatus field's value.
func (s *StreamDescriptionSummary) SetStreamStatus(v string) *StreamDescriptionSummary {
	s.StreamStatus = &v
	return s
}

// Specifies the capacity mode to which you want to set your data stream. Currently,
// in Kinesis Data Streams, you can choose between an on-demand capacity mode
// and a provisioned capacity mode for your data streams.
type StreamModeDetails struct {
	_ struct{} `type:"structure"`

	// Specifies the capacity mode to which you want to set your data stream. Currently,
	// in Kinesis Data Streams, you can choose between an on-demand capacity mode
	// and a provisioned capacity mode for your data streams.
	//
	// StreamMode is a required field
	StreamMode *string `type:"string" required:"true" enum:"StreamMode"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StreamModeDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StreamModeDetails) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StreamModeDetails) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StreamModeDetails"}
	if s.StreamMode == nil {
		invalidParams.Add(request.NewErrParamRequired("StreamMode"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStreamMode sets the StreamMode field's value.
func (s *StreamModeDetails) SetStreamMode(v string) *StreamModeDetails {
	s.StreamMode = &v
	return s
}

// The summary of a stream.
type StreamSummary struct {
	_ struct{} `type:"structure"`

	// The ARN of the stream.
	//
	// StreamARN is a required field
	StreamARN *string `min:"1" type:"string" required:"true"`

	// The timestamp at which the stream was created.
	StreamCreationTimestamp *time.Time `type:"timestamp"`

	// Specifies the capacity mode to which you want to set your data stream. Currently,
	// in Kinesis Data Streams, you can choose between an on-demand capacity mode
	// and a provisioned capacity mode for your data streams.
	StreamModeDetails *StreamModeDetails `type:"structure"`

	// The name of a stream.
	//
	// StreamName is a required field
	StreamName *string `min:"1" type:"string" required:"true"`

	// The status of the stream.
	//
	// StreamStatus is a required field
	StreamStatus *string `type:"string" required:"true" enum:"StreamStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StreamSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StreamSummary) GoString() string {
	return s.String()
}

// SetStreamARN sets the StreamARN field's value.
func (s *StreamSummary) SetStreamARN(v string) *StreamSummary {
	s.StreamARN = &v
	return s
}

// SetStreamCreationTimestamp sets the StreamCreationTimestamp field's value.
func (s *StreamSummary) SetStreamCreationTimestamp(v time.Time) *StreamSummary {
	s.StreamCreationTimestamp = &v
	return s
}

// SetStreamModeDetails sets the StreamModeDetails field's value.
func (s *StreamSummary) SetStreamModeDetails(v *StreamModeDetails) *StreamSummary {
	s.StreamModeDetails = v
	return s
}

// SetStreamName sets the StreamName field's value.
func (s *StreamSummary) SetStreamName(v string) *StreamSummary {
	s.StreamName = &v
	return s
}

// SetStreamStatus sets the StreamStatus field's value.
func (s *StreamSummary) SetStreamStatus(v string) *StreamSummary {
	s.StreamStatus = &v
	return s
}

// After you call SubscribeToShard, Kinesis Data Streams sends events of this
// type over an HTTP/2 connection to your consumer.
type SubscribeToShardEvent struct {
	_ struct{} `type:"structure"`

	// The list of the child shards of the current shard, returned only at the end
	// of the current shard.
	ChildShards []*ChildShard `type:"list"`

	// Use this as SequenceNumber in the next call to SubscribeToShard, with StartingPosition
	// set to AT_SEQUENCE_NUMBER or AFTER_SEQUENCE_NUMBER. Use ContinuationSequenceNumber
	// for checkpointing because it captures your shard progress even when no data
	// is written to the shard.
	//
	// ContinuationSequenceNumber is a required field
	ContinuationSequenceNumber *string `type:"string" required:"true"`

	// The number of milliseconds the read records are from the tip of the stream,
	// indicating how far behind current time the consumer is. A value of zero indicates
	// that record processing is caught up, and there are no new records to process
	// at this moment.
	//
	// MillisBehindLatest is a required field
	MillisBehindLatest *int64 `type:"long" required:"true"`

	// Records is a required field
	Records []*Record `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SubscribeToShardEvent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SubscribeToShardEvent) GoString() string {
	return s.String()
}

// SetChildShards sets the ChildShards field's value.
func (s *SubscribeToShardEvent) SetChildShards(v []*ChildShard) *SubscribeToShardEvent {
	s.ChildShards = v
	return s
}

// SetContinuationSequenceNumber sets the ContinuationSequenceNumber field's value.
func (s *SubscribeToShardEvent) SetContinuationSequenceNumber(v string) *SubscribeToShardEvent {
	s.ContinuationSequenceNumber = &v
	return s
}

// SetMillisBehindLatest sets the MillisBehindLatest field's value.
func (s *SubscribeToShardEvent) SetMillisBehindLatest(v int64) *SubscribeToShardEvent {
	s.MillisBehindLatest = &v
	return s
}

// SetRecords sets the Records field's value.
func (s *SubscribeToShardEvent) SetRecords(v []*Record) *SubscribeToShardEvent {
	s.Records = v
	return s
}

// The SubscribeToShardEvent is and event in the SubscribeToShardEventStream group of events.
func (s *SubscribeToShardEvent) eventSubscribeToShardEventStream() {}

// UnmarshalEvent unmarshals the EventStream Message into the SubscribeToShardEvent value.
// This method is only used internally within the SDK's EventStream handling.
func (s *SubscribeToShardEvent) UnmarshalEvent(
	payloadUnmarshaler protocol.PayloadUnmarshaler,
	msg eventstream.Message,
) error {
	if err := payloadUnmarshaler.UnmarshalPayload(
		bytes.NewReader(msg.Payload), s,
	); err != nil {
		return err
	}
	return nil
}

// MarshalEvent marshals the type into an stream event value. This method
// should only used internally within the SDK's EventStream handling.
func (s *SubscribeToShardEvent) MarshalEvent(pm protocol.PayloadMarshaler) (msg eventstream.Message, err error) {
	msg.Headers.Set(eventstreamapi.MessageTypeHeader, eventstream.StringValue(eventstreamapi.EventMessageType))
	var buf bytes.Buffer
	if err = pm.MarshalPayload(&buf, s); err != nil {
		return eventstream.Message{}, err
	}
	msg.Payload = buf.Bytes()
	return msg, err
}

// SubscribeToShardEventStreamEvent groups together all EventStream
// events writes for SubscribeToShardEventStream.
//
// These events are:
//
//   - SubscribeToShardEvent
type SubscribeToShardEventStreamEvent interface {
	eventSubscribeToShardEventStream()
	eventstreamapi.Marshaler
	eventstreamapi.Unmarshaler
}

// SubscribeToShardEventStreamReader provides the interface for reading to the stream. The
// default implementation for this interface will be SubscribeToShardEventStreamData.
//
// The reader's Close method must allow multiple concurrent calls.
//
// These events are:
//
//   - SubscribeToShardEvent
//   - SubscribeToShardEventStreamUnknownEvent
type SubscribeToShardEventStreamReader interface {
	// Returns a channel of events as they are read from the event stream.
	Events() <-chan SubscribeToShardEventStreamEvent

	// Close will stop the reader reading events from the stream.
	Close() error

	// Returns any error that has occurred while reading from the event stream.
	Err() error
}

type readSubscribeToShardEventStream struct {
	eventReader *eventstreamapi.EventReader
	stream      chan SubscribeToShardEventStreamEvent
	err         *eventstreamapi.OnceError

	done      chan struct{}
	closeOnce sync.Once
}

func newReadSubscribeToShardEventStream(eventReader *eventstreamapi.EventReader) *readSubscribeToShardEventStream {
	r := &readSubscribeToShardEventStream{
		eventReader: eventReader,
		stream:      make(chan SubscribeToShardEventStreamEvent),
		done:        make(chan struct{}),
		err:         eventstreamapi.NewOnceError(),
	}
	go r.readEventStream()

	return r
}

// Close will close the underlying event stream reader.
func (r *readSubscribeToShardEventStream) Close() error {
	r.closeOnce.Do(r.safeClose)
	return r.Err()
}

func (r *readSubscribeToShardEventStream) ErrorSet() <-chan struct{} {
	return r.err.ErrorSet()
}

func (r *readSubscribeToShardEventStream) Closed() <-chan struct{} {
	return r.done
}

func (r *readSubscribeToShardEventStream) safeClose() {
	close(r.done)
}

func (r *readSubscribeToShardEventStream) Err() error {
	return r.err.Err()
}

func (r *readSubscribeToShardEventStream) Events() <-chan SubscribeToShardEventStreamEvent {
	return r.stream
}

func (r *readSubscribeToShardEventStream) readEventStream() {
	defer r.Close()
	defer close(r.stream)

	for {
		event, err := r.eventReader.ReadEvent()
		if err != nil {
			if err == io.EOF {
				return
			}
			select {
			case <-r.done:
				// If closed already ignore the error
				return
			default:
			}
			if _, ok := err.(*eventstreamapi.UnknownMessageTypeError); ok {
				continue
			}
			r.err.SetError(err)
			return
		}

		select {
		case r.stream <- event.(SubscribeToShardEventStreamEvent):
		case <-r.done:
			return
		}
	}
}

type unmarshalerForSubscribeToShardEventStreamEvent struct {
	metadata protocol.ResponseMetadata
}

func (u unmarshalerForSubscribeToShardEventStreamEvent) UnmarshalerForEventName(eventType string) (eventstreamapi.Unmarshaler, error) {
	switch eventType {
	case "SubscribeToShardEvent":
		return &SubscribeToShardEvent{}, nil
	case "InternalFailureException":
		return newErrorInternalFailureException(u.metadata).(eventstreamapi.Unmarshaler), nil
	case "KMSAccessDeniedException":
		return newErrorKMSAccessDeniedException(u.metadata).(eventstreamapi.Unmarshaler), nil
	case "KMSDisabledException":
		return newErrorKMSDisabledException(u.metadata).(eventstreamapi.Unmarshaler), nil
	case "KMSInvalidStateException":
		return newErrorKMSInvalidStateException(u.metadata).(eventstreamapi.Unmarshaler), nil
	case "KMSNotFoundException":
		return newErrorKMSNotFoundException(u.metadata).(eventstreamapi.Unmarshaler), nil
	case "KMSOptInRequired":
		return newErrorKMSOptInRequired(u.metadata).(eventstreamapi.Unmarshaler), nil
	case "KMSThrottlingException":
		return newErrorKMSThrottlingException(u.metadata).(eventstreamapi.Unmarshaler), nil
	case "ResourceInUseException":
		return newErrorResourceInUseException(u.metadata).(eventstreamapi.Unmarshaler), nil
	case "ResourceNotFoundException":
		return newErrorResourceNotFoundException(u.metadata).(eventstreamapi.Unmarshaler), nil
	default:
		return &SubscribeToShardEventStreamUnknownEvent{Type: eventType}, nil
	}
}

// SubscribeToShardEventStreamUnknownEvent provides a failsafe event for the
// SubscribeToShardEventStream group of events when an unknown event is received.
type SubscribeToShardEventStreamUnknownEvent struct {
	Type    string
	Message eventstream.Message
}

// The SubscribeToShardEventStreamUnknownEvent is and event in the SubscribeToShardEventStream
// group of events.
func (s *SubscribeToShardEventStreamUnknownEvent) eventSubscribeToShardEventStream() {}

// MarshalEvent marshals the type into an stream event value. This method
// should only used internally within the SDK's EventStream handling.
func (e *SubscribeToShardEventStreamUnknownEvent) MarshalEvent(pm protocol.PayloadMarshaler) (
	msg eventstream.Message, err error,
) {
	return e.Message.Clone(), nil
}

// UnmarshalEvent unmarshals the EventStream Message into the SubscribeToShardEventStreamData value.
// This method is only used internally within the SDK's EventStream handling.
func (e *SubscribeToShardEventStreamUnknownEvent) UnmarshalEvent(
	payloadUnmarshaler protocol.PayloadUnmarshaler,
	msg eventstream.Message,
) error {
	e.Message = msg.Clone()
	return nil
}

type SubscribeToShardInput struct {
	_ struct{} `type:"structure"`

	// For this parameter, use the value you obtained when you called RegisterStreamConsumer.
	//
	// ConsumerARN is a required field
	ConsumerARN *string `min:"1" type:"string" required:"true"`

	// The ID of the shard you want to subscribe to. To see a list of all the shards
	// for a given stream, use ListShards.
	//
	// ShardId is a required field
	ShardId *string `min:"1" type:"string" required:"true"`

	// The starting position in the data stream from which to start streaming.
	//
	// StartingPosition is a required field
	StartingPosition *StartingPosition `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SubscribeToShardInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SubscribeToShardInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SubscribeToShardInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SubscribeToShardInput"}
	if s.ConsumerARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ConsumerARN"))
	}
	if s.ConsumerARN != nil && len(*s.ConsumerARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConsumerARN", 1))
	}
	if s.ShardId == nil {
		invalidParams.Add(request.NewErrParamRequired("ShardId"))
	}
	if s.ShardId != nil && len(*s.ShardId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ShardId", 1))
	}
	if s.StartingPosition == nil {
		invalidParams.Add(request.NewErrParamRequired("StartingPosition"))
	}
	if s.StartingPosition != nil {
		if err := s.StartingPosition.Validate(); err != nil {
			invalidParams.AddNested("StartingPosition", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConsumerARN sets the ConsumerARN field's value.
func (s *SubscribeToShardInput) SetConsumerARN(v string) *SubscribeToShardInput {
	s.ConsumerARN = &v
	return s
}

// SetShardId sets the ShardId field's value.
func (s *SubscribeToShardInput) SetShardId(v string) *SubscribeToShardInput {
	s.ShardId = &v
	return s
}

// SetStartingPosition sets the StartingPosition field's value.
func (s *SubscribeToShardInput) SetStartingPosition(v *StartingPosition) *SubscribeToShardInput {
	s.StartingPosition = v
	return s
}

type SubscribeToShardOutput struct {
	_ struct{} `type:"structure"`

	EventStream *SubscribeToShardEventStream
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SubscribeToShardOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SubscribeToShardOutput) GoString() string {
	return s.String()
}

func (s *SubscribeToShardOutput) SetEventStream(v *SubscribeToShardEventStream) *SubscribeToShardOutput {
	s.EventStream = v
	return s
}
func (s *SubscribeToShardOutput) GetEventStream() *SubscribeToShardEventStream {
	return s.EventStream
}

// GetStream returns the type to interact with the event stream.
func (s *SubscribeToShardOutput) GetStream() *SubscribeToShardEventStream {
	return s.EventStream
}

// The SubscribeToShardOutput is and event in the SubscribeToShardEventStream group of events.
func (s *SubscribeToShardOutput) eventSubscribeToShardEventStream() {}

// UnmarshalEvent unmarshals the EventStream Message into the SubscribeToShardOutput value.
// This method is only used internally within the SDK's EventStream handling.
func (s *SubscribeToShardOutput) UnmarshalEvent(
	payloadUnmarshaler protocol.PayloadUnmarshaler,
	msg eventstream.Message,
) error {
	if err := payloadUnmarshaler.UnmarshalPayload(
		bytes.NewReader(msg.Payload), s,
	); err != nil {
		return err
	}
	return nil
}

// MarshalEvent marshals the type into an stream event value. This method
// should only used internally within the SDK's EventStream handling.
func (s *SubscribeToShardOutput) MarshalEvent(pm protocol.PayloadMarshaler) (msg eventstream.Message, err error) {
	msg.Headers.Set(eventstreamapi.MessageTypeHeader, eventstream.StringValue(eventstreamapi.EventMessageType))
	var buf bytes.Buffer
	if err = pm.MarshalPayload(&buf, s); err != nil {
		return eventstream.Message{}, err
	}
	msg.Payload = buf.Bytes()
	return msg, err
}

// Metadata assigned to the stream, consisting of a key-value pair.
type Tag struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the tag. Maximum length: 128 characters. Valid characters:
	// Unicode letters, digits, white space, _ . / = + - % @
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// An optional string, typically used to describe or define the tag. Maximum
	// length: 256 characters. Valid characters: Unicode letters, digits, white
	// space, _ . / = + - % @
	Value *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type UpdateShardCountInput struct {
	_ struct{} `type:"structure"`

	// The scaling type. Uniform scaling creates shards of equal size.
	//
	// ScalingType is a required field
	ScalingType *string `type:"string" required:"true" enum:"ScalingType"`

	// The ARN of the stream.
	StreamARN *string `min:"1" type:"string"`

	// The name of the stream.
	StreamName *string `min:"1" type:"string"`

	// The new number of shards. This value has the following default limits. By
	// default, you cannot do the following:
	//
	//    * Set this value to more than double your current shard count for a stream.
	//
	//    * Set this value below half your current shard count for a stream.
	//
	//    * Set this value to more than 10000 shards in a stream (the default limit
	//    for shard count per stream is 10000 per account per region), unless you
	//    request a limit increase.
	//
	//    * Scale a stream with more than 10000 shards down unless you set this
	//    value to less than 10000 shards.
	//
	// TargetShardCount is a required field
	TargetShardCount *int64 `min:"1" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateShardCountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateShardCountInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateShardCountInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateShardCountInput"}
	if s.ScalingType == nil {
		invalidParams.Add(request.NewErrParamRequired("ScalingType"))
	}
	if s.StreamARN != nil && len(*s.StreamARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StreamARN", 1))
	}
	if s.StreamName != nil && len(*s.StreamName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StreamName", 1))
	}
	if s.TargetShardCount == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetShardCount"))
	}
	if s.TargetShardCount != nil && *s.TargetShardCount < 1 {
		invalidParams.Add(request.NewErrParamMinValue("TargetShardCount", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetScalingType sets the ScalingType field's value.
func (s *UpdateShardCountInput) SetScalingType(v string) *UpdateShardCountInput {
	s.ScalingType = &v
	return s
}

// SetStreamARN sets the StreamARN field's value.
func (s *UpdateShardCountInput) SetStreamARN(v string) *UpdateShardCountInput {
	s.StreamARN = &v
	return s
}

// SetStreamName sets the StreamName field's value.
func (s *UpdateShardCountInput) SetStreamName(v string) *UpdateShardCountInput {
	s.StreamName = &v
	return s
}

// SetTargetShardCount sets the TargetShardCount field's value.
func (s *UpdateShardCountInput) SetTargetShardCount(v int64) *UpdateShardCountInput {
	s.TargetShardCount = &v
	return s
}

type UpdateShardCountOutput struct {
	_ struct{} `type:"structure"`

	// The current number of shards.
	CurrentShardCount *int64 `min:"1" type:"integer"`

	// The ARN of the stream.
	StreamARN *string `min:"1" type:"string"`

	// The name of the stream.
	StreamName *string `min:"1" type:"string"`

	// The updated number of shards.
	TargetShardCount *int64 `min:"1" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateShardCountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateShardCountOutput) GoString() string {
	return s.String()
}

// SetCurrentShardCount sets the CurrentShardCount field's value.
func (s *UpdateShardCountOutput) SetCurrentShardCount(v int64) *UpdateShardCountOutput {
	s.CurrentShardCount = &v
	return s
}

// SetStreamARN sets the StreamARN field's value.
func (s *UpdateShardCountOutput) SetStreamARN(v string) *UpdateShardCountOutput {
	s.StreamARN = &v
	return s
}

// SetStreamName sets the StreamName field's value.
func (s *UpdateShardCountOutput) SetStreamName(v string) *UpdateShardCountOutput {
	s.StreamName = &v
	return s
}

// SetTargetShardCount sets the TargetShardCount field's value.
func (s *UpdateShardCountOutput) SetTargetShardCount(v int64) *UpdateShardCountOutput {
	s.TargetShardCount = &v
	return s
}

type UpdateStreamModeInput struct {
	_ struct{} `type:"structure"`

	// Specifies the ARN of the data stream whose capacity mode you want to update.
	//
	// StreamARN is a required field
	StreamARN *string `min:"1" type:"string" required:"true"`

	// Specifies the capacity mode to which you want to set your data stream. Currently,
	// in Kinesis Data Streams, you can choose between an on-demand capacity mode
	// and a provisioned capacity mode for your data streams.
	//
	// StreamModeDetails is a required field
	StreamModeDetails *StreamModeDetails `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateStreamModeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateStreamModeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateStreamModeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateStreamModeInput"}
	if s.StreamARN == nil {
		invalidParams.Add(request.NewErrParamRequired("StreamARN"))
	}
	if s.StreamARN != nil && len(*s.StreamARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StreamARN", 1))
	}
	if s.StreamModeDetails == nil {
		invalidParams.Add(request.NewErrParamRequired("StreamModeDetails"))
	}
	if s.StreamModeDetails != nil {
		if err := s.StreamModeDetails.Validate(); err != nil {
			invalidParams.AddNested("StreamModeDetails", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStreamARN sets the StreamARN field's value.
func (s *UpdateStreamModeInput) SetStreamARN(v string) *UpdateStreamModeInput {
	s.StreamARN = &v
	return s
}

// SetStreamModeDetails sets the StreamModeDetails field's value.
func (s *UpdateStreamModeInput) SetStreamModeDetails(v *StreamModeDetails) *UpdateStreamModeInput {
	s.StreamModeDetails = v
	return s
}

type UpdateStreamModeOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateStreamModeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateStreamModeOutput) GoString() string {
	return s.String()
}

// Specifies that you tried to invoke this API for a data stream with the on-demand
// capacity mode. This API is only supported for data streams with the provisioned
// capacity mode.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

const (
	// ConsumerStatusCreating is a ConsumerStatus enum value
	ConsumerStatusCreating = "CREATING"

	// ConsumerStatusDeleting is a ConsumerStatus enum value
	ConsumerStatusDeleting = "DELETING"

	// ConsumerStatusActive is a ConsumerStatus enum value
	ConsumerStatusActive = "ACTIVE"
)

// ConsumerStatus_Values returns all elements of the ConsumerStatus enum
func ConsumerStatus_Values() []string {
	return []string{
		ConsumerStatusCreating,
		ConsumerStatusDeleting,
		ConsumerStatusActive,
	}
}

const (
	// EncryptionTypeNone is a EncryptionType enum value
	EncryptionTypeNone = "NONE"

	// EncryptionTypeKms is a EncryptionType enum value
	EncryptionTypeKms = "KMS"
)

// EncryptionType_Values returns all elements of the EncryptionType enum
func EncryptionType_Values() []string {
	return []string{
		EncryptionTypeNone,
		EncryptionTypeKms,
	}
}

const (
	// MetricsNameIncomingBytes is a MetricsName enum value
	MetricsNameIncomingBytes = "IncomingBytes"

	// MetricsNameIncomingRecords is a MetricsName enum value
	MetricsNameIncomingRecords = "IncomingRecords"

	// MetricsNameOutgoingBytes is a MetricsName enum value
	MetricsNameOutgoingBytes = "OutgoingBytes"

	// MetricsNameOutgoingRecords is a MetricsName enum value
	MetricsNameOutgoingRecords = "OutgoingRecords"

	// MetricsNameWriteProvisionedThroughputExceeded is a MetricsName enum value
	MetricsNameWriteProvisionedThroughputExceeded = "WriteProvisionedThroughputExceeded"

	// MetricsNameReadProvisionedThroughputExceeded is a MetricsName enum value
	MetricsNameReadProvisionedThroughputExceeded = "ReadProvisionedThroughputExceeded"

	// MetricsNameIteratorAgeMilliseconds is a MetricsName enum value
	MetricsNameIteratorAgeMilliseconds = "IteratorAgeMilliseconds"

	// MetricsNameAll is a MetricsName enum value
	MetricsNameAll = "ALL"
)

// MetricsName_Values returns all elements of the MetricsName enum
func MetricsName_Values() []string {
	return []string{
		MetricsNameIncomingBytes,
		MetricsNameIncomingRecords,
		MetricsNameOutgoingBytes,
		MetricsNameOutgoingRecords,
		MetricsNameWriteProvisionedThroughputExceeded,
		MetricsNameReadProvisionedThroughputExceeded,
		MetricsNameIteratorAgeMilliseconds,
		MetricsNameAll,
	}
}

const (
	// ScalingTypeUniformScaling is a ScalingType enum value
	ScalingTypeUniformScaling = "UNIFORM_SCALING"
)

// ScalingType_Values returns all elements of the ScalingType enum
func ScalingType_Values() []string {
	return []string{
		ScalingTypeUniformScaling,
	}
}

const (
	// ShardFilterTypeAfterShardId is a ShardFilterType enum value
	ShardFilterTypeAfterShardId = "AFTER_SHARD_ID"

	// ShardFilterTypeAtTrimHorizon is a ShardFilterType enum value
	ShardFilterTypeAtTrimHorizon = "AT_TRIM_HORIZON"

	// ShardFilterTypeFromTrimHorizon is a ShardFilterType enum value
	ShardFilterTypeFromTrimHorizon = "FROM_TRIM_HORIZON"

	// ShardFilterTypeAtLatest is a ShardFilterType enum value
	ShardFilterTypeAtLatest = "AT_LATEST"

	// ShardFilterTypeAtTimestamp is a ShardFilterType enum value
	ShardFilterTypeAtTimestamp = "AT_TIMESTAMP"

	// ShardFilterTypeFromTimestamp is a ShardFilterType enum value
	ShardFilterTypeFromTimestamp = "FROM_TIMESTAMP"
)

// ShardFilterType_Values returns all elements of the ShardFilterType enum
func ShardFilterType_Values() []string {
	return []string{
		ShardFilterTypeAfterShardId,
		ShardFilterTypeAtTrimHorizon,
		ShardFilterTypeFromTrimHorizon,
		ShardFilterTypeAtLatest,
		ShardFilterTypeAtTimestamp,
		ShardFilterTypeFromTimestamp,
	}
}

const (
	// ShardIteratorTypeAtSequenceNumber is a ShardIteratorType enum value
	ShardIteratorTypeAtSequenceNumber = "AT_SEQUENCE_NUMBER"

	// ShardIteratorTypeAfterSequenceNumber is a ShardIteratorType enum value
	ShardIteratorTypeAfterSequenceNumber = "AFTER_SEQUENCE_NUMBER"

	// ShardIteratorTypeTrimHorizon is a ShardIteratorType enum value
	ShardIteratorTypeTrimHorizon = "TRIM_HORIZON"

	// ShardIteratorTypeLatest is a ShardIteratorType enum value
	ShardIteratorTypeLatest = "LATEST"

	// ShardIteratorTypeAtTimestamp is a ShardIteratorType enum value
	ShardIteratorTypeAtTimestamp = "AT_TIMESTAMP"
)

// ShardIteratorType_Values returns all elements of the ShardIteratorType enum
func ShardIteratorType_Values() []string {
	return []string{
		ShardIteratorTypeAtSequenceNumber,
		ShardIteratorTypeAfterSequenceNumber,
		ShardIteratorTypeTrimHorizon,
		ShardIteratorTypeLatest,
		ShardIteratorTypeAtTimestamp,
	}
}

const (
	// StreamModeProvisioned is a StreamMode enum value
	StreamModeProvisioned = "PROVISIONED"

	// StreamModeOnDemand is a StreamMode enum value
	StreamModeOnDemand = "ON_DEMAND"
)

// StreamMode_Values returns all elements of the StreamMode enum
func StreamMode_Values() []string {
	return []string{
		StreamModeProvisioned,
		StreamModeOnDemand,
	}
}

const (
	// StreamStatusCreating is a StreamStatus enum value
	StreamStatusCreating = "CREATING"

	// StreamStatusDeleting is a StreamStatus enum value
	StreamStatusDeleting = "DELETING"

	// StreamStatusActive is a StreamStatus enum value
	StreamStatusActive = "ACTIVE"

	// StreamStatusUpdating is a StreamStatus enum value
	StreamStatusUpdating = "UPDATING"
)

// StreamStatus_Values returns all elements of the StreamStatus enum
func StreamStatus_Values() []string {
	return []string{
		StreamStatusCreating,
		StreamStatusDeleting,
		StreamStatusActive,
		StreamStatusUpdating,
	}
}
