// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package s3control

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/internal/s3shared/arn"
	"github.com/aws/aws-sdk-go/private/checksum"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restxml"
)

const opCreateAccessPoint = "CreateAccessPoint"

// CreateAccessPointRequest generates a "aws/request.Request" representing the
// client's request for the CreateAccessPoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAccessPoint for more information on using the CreateAccessPoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateAccessPointRequest method.
//    req, resp := client.CreateAccessPointRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/CreateAccessPoint
func (c *S3Control) CreateAccessPointRequest(input *CreateAccessPointInput) (req *request.Request, output *CreateAccessPointOutput) {
	op := &request.Operation{
		Name:       opCreateAccessPoint,
		HTTPMethod: "PUT",
		HTTPPath:   "/v20180820/accesspoint/{name}",
	}

	if input == nil {
		input = &CreateAccessPointInput{}
	}

	output = &CreateAccessPointOutput{}
	req = c.newRequest(op, input, output)
	// update account id or check if provided input for account id member matches
	// the account id present in ARN
	req.Handlers.Validate.PushFrontNamed(updateAccountIDWithARNHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// CreateAccessPoint API operation for AWS S3 Control.
//
// Creates an access point and associates it with the specified bucket. For
// more information, see Managing Data Access with Amazon S3 Access Points (https://docs.aws.amazon.com/AmazonS3/latest/dev/access-points.html)
// in the Amazon Simple Storage Service Developer Guide.
//
// Using this action with Amazon S3 on Outposts
//
// This action:
//
//    * Requires a virtual private cloud (VPC) configuration as S3 on Outposts
//    only supports VPC style access points.
//
//    * Does not support ACL on S3 on Outposts buckets.
//
//    * Does not support Public Access on S3 on Outposts buckets.
//
//    * Does not support object lock for S3 on Outposts buckets.
//
// For more information, see Using Amazon S3 on Outposts (AmazonS3/latest/dev/S3onOutposts.html)
// in the Amazon Simple Storage Service Developer Guide .
//
// All Amazon S3 on Outposts REST API requests for this action require an additional
// parameter of x-amz-outpost-id to be passed with the request and an S3 on
// Outposts endpoint hostname prefix instead of s3-control. For an example of
// the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts
// endpoint hostname prefix and the x-amz-outpost-id derived using the access
// point ARN, see the Examples (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateAccessPoint.html#API_control_CreateAccessPoint_Examples)
// section.
//
// The following actions are related to CreateAccessPoint:
//
//    * GetAccessPoint (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPoint.html)
//
//    * DeleteAccessPoint (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPoint.html)
//
//    * ListAccessPoints (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListAccessPoints.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation CreateAccessPoint for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/CreateAccessPoint
func (c *S3Control) CreateAccessPoint(input *CreateAccessPointInput) (*CreateAccessPointOutput, error) {
	req, out := c.CreateAccessPointRequest(input)
	return out, req.Send()
}

// CreateAccessPointWithContext is the same as CreateAccessPoint with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAccessPoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) CreateAccessPointWithContext(ctx aws.Context, input *CreateAccessPointInput, opts ...request.Option) (*CreateAccessPointOutput, error) {
	req, out := c.CreateAccessPointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateBucket = "CreateBucket"

// CreateBucketRequest generates a "aws/request.Request" representing the
// client's request for the CreateBucket operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateBucket for more information on using the CreateBucket
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateBucketRequest method.
//    req, resp := client.CreateBucketRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/CreateBucket
func (c *S3Control) CreateBucketRequest(input *CreateBucketInput) (req *request.Request, output *CreateBucketOutput) {
	op := &request.Operation{
		Name:       opCreateBucket,
		HTTPMethod: "PUT",
		HTTPPath:   "/v20180820/bucket/{name}",
	}

	if input == nil {
		input = &CreateBucketInput{}
	}

	output = &CreateBucketOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(request.NamedHandler{
		Name: "contentMd5Handler",
		Fn:   checksum.AddBodyContentMD5Handler,
	})
	return
}

// CreateBucket API operation for AWS S3 Control.
//
//
// This API operation creates an Amazon S3 on Outposts bucket. To create an
// S3 bucket, see Create Bucket (https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucket.html)
// in the Amazon Simple Storage Service API.
//
// Creates a new Outposts bucket. By creating the bucket, you become the bucket
// owner. To create an Outposts bucket, you must have S3 on Outposts. For more
// information, see Using Amazon S3 on Outposts (https://docs.aws.amazon.com/AmazonS3/latest/dev/S3onOutposts.html)
// in Amazon Simple Storage Service Developer Guide.
//
// Not every string is an acceptable bucket name. For information on bucket
// naming restrictions, see Working with Amazon S3 Buckets (https://docs.aws.amazon.com/AmazonS3/latest/dev/BucketRestrictions.html#bucketnamingrules).
//
// S3 on Outposts buckets do not support
//
//    * ACLs. Instead, configure access point policies to manage access to buckets.
//
//    * Public access.
//
//    * Object Lock
//
//    * Bucket Location constraint
//
// For an example of the request syntax for Amazon S3 on Outposts that uses
// the S3 on Outposts endpoint hostname prefix and x-amz-outpost-id in your
// API request, see the Examples (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateBucket.html#API_control_CreateBucket_Examples)
// section.
//
// The following actions are related to CreateBucket for Amazon S3 on Outposts:
//
//    * PutObject (https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObject.html)
//
//    * GetBucket (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucket.html)
//
//    * DeleteBucket (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucket.html)
//
//    * CreateAccessPoint (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateAccessPoint.html)
//
//    * PutAccessPointPolicy (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutAccessPointPolicy.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation CreateBucket for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBucketAlreadyExists "BucketAlreadyExists"
//   The requested Outposts bucket name is not available. The bucket namespace
//   is shared by all users of the AWS Outposts in this Region. Select a different
//   name and try again.
//
//   * ErrCodeBucketAlreadyOwnedByYou "BucketAlreadyOwnedByYou"
//   The Outposts bucket you tried to create already exists, and you own it.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/CreateBucket
func (c *S3Control) CreateBucket(input *CreateBucketInput) (*CreateBucketOutput, error) {
	req, out := c.CreateBucketRequest(input)
	return out, req.Send()
}

// CreateBucketWithContext is the same as CreateBucket with the addition of
// the ability to pass a context and additional request options.
//
// See CreateBucket for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) CreateBucketWithContext(ctx aws.Context, input *CreateBucketInput, opts ...request.Option) (*CreateBucketOutput, error) {
	req, out := c.CreateBucketRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateJob = "CreateJob"

// CreateJobRequest generates a "aws/request.Request" representing the
// client's request for the CreateJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateJob for more information on using the CreateJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateJobRequest method.
//    req, resp := client.CreateJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/CreateJob
func (c *S3Control) CreateJobRequest(input *CreateJobInput) (req *request.Request, output *CreateJobOutput) {
	op := &request.Operation{
		Name:       opCreateJob,
		HTTPMethod: "POST",
		HTTPPath:   "/v20180820/jobs",
	}

	if input == nil {
		input = &CreateJobInput{}
	}

	output = &CreateJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// CreateJob API operation for AWS S3 Control.
//
// S3 Batch Operations performs large-scale Batch Operations on Amazon S3 objects.
// Batch Operations can run a single operation or action on lists of Amazon
// S3 objects that you specify. For more information, see S3 Batch Operations
// (https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-basics.html) in
// the Amazon Simple Storage Service Developer Guide.
//
// This operation creates an S3 Batch Operations job.
//
// Related actions include:
//
//    * DescribeJob (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DescribeJob.html)
//
//    * ListJobs (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListJobs.html)
//
//    * UpdateJobPriority (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_UpdateJobPriority.html)
//
//    * UpdateJobStatus (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_UpdateJobStatus.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation CreateJob for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
//   * ErrCodeBadRequestException "BadRequestException"
//
//   * ErrCodeIdempotencyException "IdempotencyException"
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/CreateJob
func (c *S3Control) CreateJob(input *CreateJobInput) (*CreateJobOutput, error) {
	req, out := c.CreateJobRequest(input)
	return out, req.Send()
}

// CreateJobWithContext is the same as CreateJob with the addition of
// the ability to pass a context and additional request options.
//
// See CreateJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) CreateJobWithContext(ctx aws.Context, input *CreateJobInput, opts ...request.Option) (*CreateJobOutput, error) {
	req, out := c.CreateJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAccessPoint = "DeleteAccessPoint"

// DeleteAccessPointRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAccessPoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAccessPoint for more information on using the DeleteAccessPoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteAccessPointRequest method.
//    req, resp := client.DeleteAccessPointRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DeleteAccessPoint
func (c *S3Control) DeleteAccessPointRequest(input *DeleteAccessPointInput) (req *request.Request, output *DeleteAccessPointOutput) {
	op := &request.Operation{
		Name:       opDeleteAccessPoint,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v20180820/accesspoint/{name}",
	}

	if input == nil {
		input = &DeleteAccessPointInput{}
	}

	output = &DeleteAccessPointOutput{}
	req = c.newRequest(op, input, output)
	// update account id or check if provided input for account id member matches
	// the account id present in ARN
	req.Handlers.Validate.PushFrontNamed(updateAccountIDWithARNHandler)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DeleteAccessPoint API operation for AWS S3 Control.
//
// Deletes the specified access point.
//
// All Amazon S3 on Outposts REST API requests for this action require an additional
// parameter of x-amz-outpost-id to be passed with the request and an S3 on
// Outposts endpoint hostname prefix instead of s3-control. For an example of
// the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts
// endpoint hostname prefix and the x-amz-outpost-id derived using the access
// point ARN, see the Examples (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPoint.html#API_control_DeleteAccessPoint_Examples)
// section.
//
// The following actions are related to DeleteAccessPoint:
//
//    * CreateAccessPoint (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateAccessPoint.html)
//
//    * GetAccessPoint (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPoint.html)
//
//    * ListAccessPoints (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListAccessPoints.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation DeleteAccessPoint for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DeleteAccessPoint
func (c *S3Control) DeleteAccessPoint(input *DeleteAccessPointInput) (*DeleteAccessPointOutput, error) {
	req, out := c.DeleteAccessPointRequest(input)
	return out, req.Send()
}

// DeleteAccessPointWithContext is the same as DeleteAccessPoint with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAccessPoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) DeleteAccessPointWithContext(ctx aws.Context, input *DeleteAccessPointInput, opts ...request.Option) (*DeleteAccessPointOutput, error) {
	req, out := c.DeleteAccessPointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAccessPointPolicy = "DeleteAccessPointPolicy"

// DeleteAccessPointPolicyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAccessPointPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAccessPointPolicy for more information on using the DeleteAccessPointPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteAccessPointPolicyRequest method.
//    req, resp := client.DeleteAccessPointPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DeleteAccessPointPolicy
func (c *S3Control) DeleteAccessPointPolicyRequest(input *DeleteAccessPointPolicyInput) (req *request.Request, output *DeleteAccessPointPolicyOutput) {
	op := &request.Operation{
		Name:       opDeleteAccessPointPolicy,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v20180820/accesspoint/{name}/policy",
	}

	if input == nil {
		input = &DeleteAccessPointPolicyInput{}
	}

	output = &DeleteAccessPointPolicyOutput{}
	req = c.newRequest(op, input, output)
	// update account id or check if provided input for account id member matches
	// the account id present in ARN
	req.Handlers.Validate.PushFrontNamed(updateAccountIDWithARNHandler)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DeleteAccessPointPolicy API operation for AWS S3 Control.
//
// Deletes the access point policy for the specified access point.
//
// All Amazon S3 on Outposts REST API requests for this action require an additional
// parameter of x-amz-outpost-id to be passed with the request and an S3 on
// Outposts endpoint hostname prefix instead of s3-control. For an example of
// the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts
// endpoint hostname prefix and the x-amz-outpost-id derived using the access
// point ARN, see the Examples (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPointPolicy.html#API_control_DeleteAccessPointPolicy_Examples)
// section.
//
// The following actions are related to DeleteAccessPointPolicy:
//
//    * PutAccessPointPolicy (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutAccessPointPolicy.html)
//
//    * GetAccessPointPolicy (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPointPolicy.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation DeleteAccessPointPolicy for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DeleteAccessPointPolicy
func (c *S3Control) DeleteAccessPointPolicy(input *DeleteAccessPointPolicyInput) (*DeleteAccessPointPolicyOutput, error) {
	req, out := c.DeleteAccessPointPolicyRequest(input)
	return out, req.Send()
}

// DeleteAccessPointPolicyWithContext is the same as DeleteAccessPointPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAccessPointPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) DeleteAccessPointPolicyWithContext(ctx aws.Context, input *DeleteAccessPointPolicyInput, opts ...request.Option) (*DeleteAccessPointPolicyOutput, error) {
	req, out := c.DeleteAccessPointPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteBucket = "DeleteBucket"

// DeleteBucketRequest generates a "aws/request.Request" representing the
// client's request for the DeleteBucket operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteBucket for more information on using the DeleteBucket
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteBucketRequest method.
//    req, resp := client.DeleteBucketRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DeleteBucket
func (c *S3Control) DeleteBucketRequest(input *DeleteBucketInput) (req *request.Request, output *DeleteBucketOutput) {
	op := &request.Operation{
		Name:       opDeleteBucket,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v20180820/bucket/{name}",
	}

	if input == nil {
		input = &DeleteBucketInput{}
	}

	output = &DeleteBucketOutput{}
	req = c.newRequest(op, input, output)
	// update account id or check if provided input for account id member matches
	// the account id present in ARN
	req.Handlers.Validate.PushFrontNamed(updateAccountIDWithARNHandler)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DeleteBucket API operation for AWS S3 Control.
//
//
// This API operation deletes an Amazon S3 on Outposts bucket. To delete an
// S3 bucket, see DeleteBucket (https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucket.html)
// in the Amazon Simple Storage Service API.
//
// Deletes the Amazon S3 on Outposts bucket. All objects (including all object
// versions and delete markers) in the bucket must be deleted before the bucket
// itself can be deleted. For more information, see Using Amazon S3 on Outposts
// (https://docs.aws.amazon.com/AmazonS3/latest/dev/S3onOutposts.html) in Amazon
// Simple Storage Service Developer Guide.
//
// All Amazon S3 on Outposts REST API requests for this action require an additional
// parameter of x-amz-outpost-id to be passed with the request and an S3 on
// Outposts endpoint hostname prefix instead of s3-control. For an example of
// the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts
// endpoint hostname prefix and the x-amz-outpost-id derived using the access
// point ARN, see the Examples (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucket.html#API_control_DeleteBucket_Examples)
// section.
//
// Related Resources
//
//    * CreateBucket (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateBucket.html)
//
//    * GetBucket (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucket.html)
//
//    * DeleteObject (https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteObject.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation DeleteBucket for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DeleteBucket
func (c *S3Control) DeleteBucket(input *DeleteBucketInput) (*DeleteBucketOutput, error) {
	req, out := c.DeleteBucketRequest(input)
	return out, req.Send()
}

// DeleteBucketWithContext is the same as DeleteBucket with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteBucket for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) DeleteBucketWithContext(ctx aws.Context, input *DeleteBucketInput, opts ...request.Option) (*DeleteBucketOutput, error) {
	req, out := c.DeleteBucketRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteBucketLifecycleConfiguration = "DeleteBucketLifecycleConfiguration"

// DeleteBucketLifecycleConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteBucketLifecycleConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteBucketLifecycleConfiguration for more information on using the DeleteBucketLifecycleConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteBucketLifecycleConfigurationRequest method.
//    req, resp := client.DeleteBucketLifecycleConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DeleteBucketLifecycleConfiguration
func (c *S3Control) DeleteBucketLifecycleConfigurationRequest(input *DeleteBucketLifecycleConfigurationInput) (req *request.Request, output *DeleteBucketLifecycleConfigurationOutput) {
	op := &request.Operation{
		Name:       opDeleteBucketLifecycleConfiguration,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v20180820/bucket/{name}/lifecycleconfiguration",
	}

	if input == nil {
		input = &DeleteBucketLifecycleConfigurationInput{}
	}

	output = &DeleteBucketLifecycleConfigurationOutput{}
	req = c.newRequest(op, input, output)
	// update account id or check if provided input for account id member matches
	// the account id present in ARN
	req.Handlers.Validate.PushFrontNamed(updateAccountIDWithARNHandler)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DeleteBucketLifecycleConfiguration API operation for AWS S3 Control.
//
//
// This API action deletes an Amazon S3 on Outposts bucket's lifecycle configuration.
// To delete an S3 bucket's lifecycle configuration, see DeleteBucketLifecycle
// (https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketLifecycle.html)
// in the Amazon Simple Storage Service API.
//
// Deletes the lifecycle configuration from the specified Outposts bucket. Amazon
// S3 on Outposts removes all the lifecycle configuration rules in the lifecycle
// subresource associated with the bucket. Your objects never expire, and Amazon
// S3 on Outposts no longer automatically deletes any objects on the basis of
// rules contained in the deleted lifecycle configuration. For more information,
// see Using Amazon S3 on Outposts (https://docs.aws.amazon.com/AmazonS3/latest/dev/S3onOutposts.html)
// in Amazon Simple Storage Service Developer Guide.
//
// To use this operation, you must have permission to perform the s3-outposts:DeleteLifecycleConfiguration
// action. By default, the bucket owner has this permission and the Outposts
// bucket owner can grant this permission to others.
//
// All Amazon S3 on Outposts REST API requests for this action require an additional
// parameter of x-amz-outpost-id to be passed with the request and an S3 on
// Outposts endpoint hostname prefix instead of s3-control. For an example of
// the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts
// endpoint hostname prefix and the x-amz-outpost-id derived using the access
// point ARN, see the Examples (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucketLifecycleConfiguration.html#API_control_DeleteBucketLifecycleConfiguration_Examples)
// section.
//
// For more information about object expiration, see Elements to Describe Lifecycle
// Actions (https://docs.aws.amazon.com/AmazonS3/latest/dev/intro-lifecycle-rules.html#intro-lifecycle-rules-actions).
//
// Related actions include:
//
//    * PutBucketLifecycleConfiguration (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketLifecycleConfiguration.html)
//
//    * GetBucketLifecycleConfiguration (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketLifecycleConfiguration.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation DeleteBucketLifecycleConfiguration for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DeleteBucketLifecycleConfiguration
func (c *S3Control) DeleteBucketLifecycleConfiguration(input *DeleteBucketLifecycleConfigurationInput) (*DeleteBucketLifecycleConfigurationOutput, error) {
	req, out := c.DeleteBucketLifecycleConfigurationRequest(input)
	return out, req.Send()
}

// DeleteBucketLifecycleConfigurationWithContext is the same as DeleteBucketLifecycleConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteBucketLifecycleConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) DeleteBucketLifecycleConfigurationWithContext(ctx aws.Context, input *DeleteBucketLifecycleConfigurationInput, opts ...request.Option) (*DeleteBucketLifecycleConfigurationOutput, error) {
	req, out := c.DeleteBucketLifecycleConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteBucketPolicy = "DeleteBucketPolicy"

// DeleteBucketPolicyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteBucketPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteBucketPolicy for more information on using the DeleteBucketPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteBucketPolicyRequest method.
//    req, resp := client.DeleteBucketPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DeleteBucketPolicy
func (c *S3Control) DeleteBucketPolicyRequest(input *DeleteBucketPolicyInput) (req *request.Request, output *DeleteBucketPolicyOutput) {
	op := &request.Operation{
		Name:       opDeleteBucketPolicy,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v20180820/bucket/{name}/policy",
	}

	if input == nil {
		input = &DeleteBucketPolicyInput{}
	}

	output = &DeleteBucketPolicyOutput{}
	req = c.newRequest(op, input, output)
	// update account id or check if provided input for account id member matches
	// the account id present in ARN
	req.Handlers.Validate.PushFrontNamed(updateAccountIDWithARNHandler)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DeleteBucketPolicy API operation for AWS S3 Control.
//
//
// This API operation deletes an Amazon S3 on Outposts bucket policy. To delete
// an S3 bucket policy, see DeleteBucketPolicy (https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketPolicy.html)
// in the Amazon Simple Storage Service API.
//
// This implementation of the DELETE operation uses the policy subresource to
// delete the policy of a specified Amazon S3 on Outposts bucket. If you are
// using an identity other than the root user of the AWS account that owns the
// bucket, the calling identity must have the s3-outposts:DeleteBucketPolicy
// permissions on the specified Outposts bucket and belong to the bucket owner's
// account to use this operation. For more information, see Using Amazon S3
// on Outposts (https://docs.aws.amazon.com/AmazonS3/latest/dev/S3onOutposts.html)
// in Amazon Simple Storage Service Developer Guide.
//
// If you don't have DeleteBucketPolicy permissions, Amazon S3 returns a 403
// Access Denied error. If you have the correct permissions, but you're not
// using an identity that belongs to the bucket owner's account, Amazon S3 returns
// a 405 Method Not Allowed error.
//
// As a security precaution, the root user of the AWS account that owns a bucket
// can always use this operation, even if the policy explicitly denies the root
// user the ability to perform this action.
//
// For more information about bucket policies, see Using Bucket Policies and
// User Policies (https://docs.aws.amazon.com/AmazonS3/latest/dev/using-iam-policies.html).
//
// All Amazon S3 on Outposts REST API requests for this action require an additional
// parameter of x-amz-outpost-id to be passed with the request and an S3 on
// Outposts endpoint hostname prefix instead of s3-control. For an example of
// the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts
// endpoint hostname prefix and the x-amz-outpost-id derived using the access
// point ARN, see the Examples (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucketPolicy.html#API_control_DeleteBucketPolicy_Examples)
// section.
//
// The following actions are related to DeleteBucketPolicy:
//
//    * GetBucketPolicy (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketPolicy.html)
//
//    * PutBucketPolicy (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketPolicy.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation DeleteBucketPolicy for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DeleteBucketPolicy
func (c *S3Control) DeleteBucketPolicy(input *DeleteBucketPolicyInput) (*DeleteBucketPolicyOutput, error) {
	req, out := c.DeleteBucketPolicyRequest(input)
	return out, req.Send()
}

// DeleteBucketPolicyWithContext is the same as DeleteBucketPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteBucketPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) DeleteBucketPolicyWithContext(ctx aws.Context, input *DeleteBucketPolicyInput, opts ...request.Option) (*DeleteBucketPolicyOutput, error) {
	req, out := c.DeleteBucketPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteBucketTagging = "DeleteBucketTagging"

// DeleteBucketTaggingRequest generates a "aws/request.Request" representing the
// client's request for the DeleteBucketTagging operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteBucketTagging for more information on using the DeleteBucketTagging
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteBucketTaggingRequest method.
//    req, resp := client.DeleteBucketTaggingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DeleteBucketTagging
func (c *S3Control) DeleteBucketTaggingRequest(input *DeleteBucketTaggingInput) (req *request.Request, output *DeleteBucketTaggingOutput) {
	op := &request.Operation{
		Name:       opDeleteBucketTagging,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v20180820/bucket/{name}/tagging",
	}

	if input == nil {
		input = &DeleteBucketTaggingInput{}
	}

	output = &DeleteBucketTaggingOutput{}
	req = c.newRequest(op, input, output)
	// update account id or check if provided input for account id member matches
	// the account id present in ARN
	req.Handlers.Validate.PushFrontNamed(updateAccountIDWithARNHandler)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DeleteBucketTagging API operation for AWS S3 Control.
//
//
// This operation deletes an Amazon S3 on Outposts bucket's tags. To delete
// an S3 bucket tags, see DeleteBucketTagging (https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketTagging.html)
// in the Amazon Simple Storage Service API.
//
// Deletes the tags from the Outposts bucket. For more information, see Using
// Amazon S3 on Outposts (https://docs.aws.amazon.com/AmazonS3/latest/dev/S3onOutposts.html)
// in Amazon Simple Storage Service Developer Guide.
//
// To use this operation, you must have permission to perform the PutBucketTagging
// action. By default, the bucket owner has this permission and can grant this
// permission to others.
//
// All Amazon S3 on Outposts REST API requests for this action require an additional
// parameter of x-amz-outpost-id to be passed with the request and an S3 on
// Outposts endpoint hostname prefix instead of s3-control. For an example of
// the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts
// endpoint hostname prefix and the x-amz-outpost-id derived using the access
// point ARN, see the Examples (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucketTagging.html#API_control_DeleteBucketTagging_Examples)
// section.
//
// The following actions are related to DeleteBucketTagging:
//
//    * GetBucketTagging (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketTagging.html)
//
//    * PutBucketTagging (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketTagging.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation DeleteBucketTagging for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DeleteBucketTagging
func (c *S3Control) DeleteBucketTagging(input *DeleteBucketTaggingInput) (*DeleteBucketTaggingOutput, error) {
	req, out := c.DeleteBucketTaggingRequest(input)
	return out, req.Send()
}

// DeleteBucketTaggingWithContext is the same as DeleteBucketTagging with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteBucketTagging for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) DeleteBucketTaggingWithContext(ctx aws.Context, input *DeleteBucketTaggingInput, opts ...request.Option) (*DeleteBucketTaggingOutput, error) {
	req, out := c.DeleteBucketTaggingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteJobTagging = "DeleteJobTagging"

// DeleteJobTaggingRequest generates a "aws/request.Request" representing the
// client's request for the DeleteJobTagging operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteJobTagging for more information on using the DeleteJobTagging
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteJobTaggingRequest method.
//    req, resp := client.DeleteJobTaggingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DeleteJobTagging
func (c *S3Control) DeleteJobTaggingRequest(input *DeleteJobTaggingInput) (req *request.Request, output *DeleteJobTaggingOutput) {
	op := &request.Operation{
		Name:       opDeleteJobTagging,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v20180820/jobs/{id}/tagging",
	}

	if input == nil {
		input = &DeleteJobTaggingInput{}
	}

	output = &DeleteJobTaggingOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DeleteJobTagging API operation for AWS S3 Control.
//
// Removes the entire tag set from the specified S3 Batch Operations job. To
// use this operation, you must have permission to perform the s3:DeleteJobTagging
// action. For more information, see Controlling access and labeling jobs using
// tags (https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-managing-jobs.html#batch-ops-job-tags)
// in the Amazon Simple Storage Service Developer Guide.
//
// Related actions include:
//
//    * CreateJob (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateJob.html)
//
//    * GetJobTagging (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetJobTagging.html)
//
//    * PutJobTagging (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutJobTagging.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation DeleteJobTagging for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
//   * ErrCodeNotFoundException "NotFoundException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DeleteJobTagging
func (c *S3Control) DeleteJobTagging(input *DeleteJobTaggingInput) (*DeleteJobTaggingOutput, error) {
	req, out := c.DeleteJobTaggingRequest(input)
	return out, req.Send()
}

// DeleteJobTaggingWithContext is the same as DeleteJobTagging with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteJobTagging for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) DeleteJobTaggingWithContext(ctx aws.Context, input *DeleteJobTaggingInput, opts ...request.Option) (*DeleteJobTaggingOutput, error) {
	req, out := c.DeleteJobTaggingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeletePublicAccessBlock = "DeletePublicAccessBlock"

// DeletePublicAccessBlockRequest generates a "aws/request.Request" representing the
// client's request for the DeletePublicAccessBlock operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeletePublicAccessBlock for more information on using the DeletePublicAccessBlock
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeletePublicAccessBlockRequest method.
//    req, resp := client.DeletePublicAccessBlockRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DeletePublicAccessBlock
func (c *S3Control) DeletePublicAccessBlockRequest(input *DeletePublicAccessBlockInput) (req *request.Request, output *DeletePublicAccessBlockOutput) {
	op := &request.Operation{
		Name:       opDeletePublicAccessBlock,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v20180820/configuration/publicAccessBlock",
	}

	if input == nil {
		input = &DeletePublicAccessBlockInput{}
	}

	output = &DeletePublicAccessBlockOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DeletePublicAccessBlock API operation for AWS S3 Control.
//
// Removes the PublicAccessBlock configuration for an AWS account. For more
// information, see Using Amazon S3 block public access (https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html).
//
// Related actions include:
//
//    * GetPublicAccessBlock (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetPublicAccessBlock.html)
//
//    * PutPublicAccessBlock (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutPublicAccessBlock.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation DeletePublicAccessBlock for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DeletePublicAccessBlock
func (c *S3Control) DeletePublicAccessBlock(input *DeletePublicAccessBlockInput) (*DeletePublicAccessBlockOutput, error) {
	req, out := c.DeletePublicAccessBlockRequest(input)
	return out, req.Send()
}

// DeletePublicAccessBlockWithContext is the same as DeletePublicAccessBlock with the addition of
// the ability to pass a context and additional request options.
//
// See DeletePublicAccessBlock for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) DeletePublicAccessBlockWithContext(ctx aws.Context, input *DeletePublicAccessBlockInput, opts ...request.Option) (*DeletePublicAccessBlockOutput, error) {
	req, out := c.DeletePublicAccessBlockRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteStorageLensConfiguration = "DeleteStorageLensConfiguration"

// DeleteStorageLensConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteStorageLensConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteStorageLensConfiguration for more information on using the DeleteStorageLensConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteStorageLensConfigurationRequest method.
//    req, resp := client.DeleteStorageLensConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DeleteStorageLensConfiguration
func (c *S3Control) DeleteStorageLensConfigurationRequest(input *DeleteStorageLensConfigurationInput) (req *request.Request, output *DeleteStorageLensConfigurationOutput) {
	op := &request.Operation{
		Name:       opDeleteStorageLensConfiguration,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v20180820/storagelens/{storagelensid}",
	}

	if input == nil {
		input = &DeleteStorageLensConfigurationInput{}
	}

	output = &DeleteStorageLensConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DeleteStorageLensConfiguration API operation for AWS S3 Control.
//
// Deletes the Amazon S3 Storage Lens configuration. For more information about
// S3 Storage Lens, see Working with Amazon S3 Storage Lens (https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens.html)
// in the Amazon Simple Storage Service Developer Guide.
//
// To use this action, you must have permission to perform the s3:DeleteStorageLensConfiguration
// action. For more information, see Setting permissions to use Amazon S3 Storage
// Lens (https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens_iam_permissions.html)
// in the Amazon Simple Storage Service Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation DeleteStorageLensConfiguration for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DeleteStorageLensConfiguration
func (c *S3Control) DeleteStorageLensConfiguration(input *DeleteStorageLensConfigurationInput) (*DeleteStorageLensConfigurationOutput, error) {
	req, out := c.DeleteStorageLensConfigurationRequest(input)
	return out, req.Send()
}

// DeleteStorageLensConfigurationWithContext is the same as DeleteStorageLensConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteStorageLensConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) DeleteStorageLensConfigurationWithContext(ctx aws.Context, input *DeleteStorageLensConfigurationInput, opts ...request.Option) (*DeleteStorageLensConfigurationOutput, error) {
	req, out := c.DeleteStorageLensConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteStorageLensConfigurationTagging = "DeleteStorageLensConfigurationTagging"

// DeleteStorageLensConfigurationTaggingRequest generates a "aws/request.Request" representing the
// client's request for the DeleteStorageLensConfigurationTagging operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteStorageLensConfigurationTagging for more information on using the DeleteStorageLensConfigurationTagging
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteStorageLensConfigurationTaggingRequest method.
//    req, resp := client.DeleteStorageLensConfigurationTaggingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DeleteStorageLensConfigurationTagging
func (c *S3Control) DeleteStorageLensConfigurationTaggingRequest(input *DeleteStorageLensConfigurationTaggingInput) (req *request.Request, output *DeleteStorageLensConfigurationTaggingOutput) {
	op := &request.Operation{
		Name:       opDeleteStorageLensConfigurationTagging,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v20180820/storagelens/{storagelensid}/tagging",
	}

	if input == nil {
		input = &DeleteStorageLensConfigurationTaggingInput{}
	}

	output = &DeleteStorageLensConfigurationTaggingOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DeleteStorageLensConfigurationTagging API operation for AWS S3 Control.
//
// Deletes the Amazon S3 Storage Lens configuration tags. For more information
// about S3 Storage Lens, see Working with Amazon S3 Storage Lens (https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens.html)
// in the Amazon Simple Storage Service Developer Guide.
//
// To use this action, you must have permission to perform the s3:DeleteStorageLensConfigurationTagging
// action. For more information, see Setting permissions to use Amazon S3 Storage
// Lens (https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens_iam_permissions.html)
// in the Amazon Simple Storage Service Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation DeleteStorageLensConfigurationTagging for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DeleteStorageLensConfigurationTagging
func (c *S3Control) DeleteStorageLensConfigurationTagging(input *DeleteStorageLensConfigurationTaggingInput) (*DeleteStorageLensConfigurationTaggingOutput, error) {
	req, out := c.DeleteStorageLensConfigurationTaggingRequest(input)
	return out, req.Send()
}

// DeleteStorageLensConfigurationTaggingWithContext is the same as DeleteStorageLensConfigurationTagging with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteStorageLensConfigurationTagging for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) DeleteStorageLensConfigurationTaggingWithContext(ctx aws.Context, input *DeleteStorageLensConfigurationTaggingInput, opts ...request.Option) (*DeleteStorageLensConfigurationTaggingOutput, error) {
	req, out := c.DeleteStorageLensConfigurationTaggingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeJob = "DescribeJob"

// DescribeJobRequest generates a "aws/request.Request" representing the
// client's request for the DescribeJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeJob for more information on using the DescribeJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeJobRequest method.
//    req, resp := client.DescribeJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DescribeJob
func (c *S3Control) DescribeJobRequest(input *DescribeJobInput) (req *request.Request, output *DescribeJobOutput) {
	op := &request.Operation{
		Name:       opDescribeJob,
		HTTPMethod: "GET",
		HTTPPath:   "/v20180820/jobs/{id}",
	}

	if input == nil {
		input = &DescribeJobInput{}
	}

	output = &DescribeJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DescribeJob API operation for AWS S3 Control.
//
// Retrieves the configuration parameters and status for a Batch Operations
// job. For more information, see S3 Batch Operations (https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-basics.html)
// in the Amazon Simple Storage Service Developer Guide.
//
// Related actions include:
//
//    * CreateJob (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateJob.html)
//
//    * ListJobs (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListJobs.html)
//
//    * UpdateJobPriority (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_UpdateJobPriority.html)
//
//    * UpdateJobStatus (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_UpdateJobStatus.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation DescribeJob for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
//   * ErrCodeNotFoundException "NotFoundException"
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DescribeJob
func (c *S3Control) DescribeJob(input *DescribeJobInput) (*DescribeJobOutput, error) {
	req, out := c.DescribeJobRequest(input)
	return out, req.Send()
}

// DescribeJobWithContext is the same as DescribeJob with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) DescribeJobWithContext(ctx aws.Context, input *DescribeJobInput, opts ...request.Option) (*DescribeJobOutput, error) {
	req, out := c.DescribeJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAccessPoint = "GetAccessPoint"

// GetAccessPointRequest generates a "aws/request.Request" representing the
// client's request for the GetAccessPoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAccessPoint for more information on using the GetAccessPoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetAccessPointRequest method.
//    req, resp := client.GetAccessPointRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetAccessPoint
func (c *S3Control) GetAccessPointRequest(input *GetAccessPointInput) (req *request.Request, output *GetAccessPointOutput) {
	op := &request.Operation{
		Name:       opGetAccessPoint,
		HTTPMethod: "GET",
		HTTPPath:   "/v20180820/accesspoint/{name}",
	}

	if input == nil {
		input = &GetAccessPointInput{}
	}

	output = &GetAccessPointOutput{}
	req = c.newRequest(op, input, output)
	// update account id or check if provided input for account id member matches
	// the account id present in ARN
	req.Handlers.Validate.PushFrontNamed(updateAccountIDWithARNHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetAccessPoint API operation for AWS S3 Control.
//
// Returns configuration information about the specified access point.
//
// All Amazon S3 on Outposts REST API requests for this action require an additional
// parameter of x-amz-outpost-id to be passed with the request and an S3 on
// Outposts endpoint hostname prefix instead of s3-control. For an example of
// the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts
// endpoint hostname prefix and the x-amz-outpost-id derived using the access
// point ARN, see the Examples (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPoint.html#API_control_GetAccessPoint_Examples)
// section.
//
// The following actions are related to GetAccessPoint:
//
//    * CreateAccessPoint (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateAccessPoint.html)
//
//    * DeleteAccessPoint (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPoint.html)
//
//    * ListAccessPoints (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListAccessPoints.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation GetAccessPoint for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetAccessPoint
func (c *S3Control) GetAccessPoint(input *GetAccessPointInput) (*GetAccessPointOutput, error) {
	req, out := c.GetAccessPointRequest(input)
	return out, req.Send()
}

// GetAccessPointWithContext is the same as GetAccessPoint with the addition of
// the ability to pass a context and additional request options.
//
// See GetAccessPoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) GetAccessPointWithContext(ctx aws.Context, input *GetAccessPointInput, opts ...request.Option) (*GetAccessPointOutput, error) {
	req, out := c.GetAccessPointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAccessPointPolicy = "GetAccessPointPolicy"

// GetAccessPointPolicyRequest generates a "aws/request.Request" representing the
// client's request for the GetAccessPointPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAccessPointPolicy for more information on using the GetAccessPointPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetAccessPointPolicyRequest method.
//    req, resp := client.GetAccessPointPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetAccessPointPolicy
func (c *S3Control) GetAccessPointPolicyRequest(input *GetAccessPointPolicyInput) (req *request.Request, output *GetAccessPointPolicyOutput) {
	op := &request.Operation{
		Name:       opGetAccessPointPolicy,
		HTTPMethod: "GET",
		HTTPPath:   "/v20180820/accesspoint/{name}/policy",
	}

	if input == nil {
		input = &GetAccessPointPolicyInput{}
	}

	output = &GetAccessPointPolicyOutput{}
	req = c.newRequest(op, input, output)
	// update account id or check if provided input for account id member matches
	// the account id present in ARN
	req.Handlers.Validate.PushFrontNamed(updateAccountIDWithARNHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetAccessPointPolicy API operation for AWS S3 Control.
//
// Returns the access point policy associated with the specified access point.
//
// The following actions are related to GetAccessPointPolicy:
//
//    * PutAccessPointPolicy (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutAccessPointPolicy.html)
//
//    * DeleteAccessPointPolicy (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPointPolicy.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation GetAccessPointPolicy for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetAccessPointPolicy
func (c *S3Control) GetAccessPointPolicy(input *GetAccessPointPolicyInput) (*GetAccessPointPolicyOutput, error) {
	req, out := c.GetAccessPointPolicyRequest(input)
	return out, req.Send()
}

// GetAccessPointPolicyWithContext is the same as GetAccessPointPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See GetAccessPointPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) GetAccessPointPolicyWithContext(ctx aws.Context, input *GetAccessPointPolicyInput, opts ...request.Option) (*GetAccessPointPolicyOutput, error) {
	req, out := c.GetAccessPointPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAccessPointPolicyStatus = "GetAccessPointPolicyStatus"

// GetAccessPointPolicyStatusRequest generates a "aws/request.Request" representing the
// client's request for the GetAccessPointPolicyStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAccessPointPolicyStatus for more information on using the GetAccessPointPolicyStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetAccessPointPolicyStatusRequest method.
//    req, resp := client.GetAccessPointPolicyStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetAccessPointPolicyStatus
func (c *S3Control) GetAccessPointPolicyStatusRequest(input *GetAccessPointPolicyStatusInput) (req *request.Request, output *GetAccessPointPolicyStatusOutput) {
	op := &request.Operation{
		Name:       opGetAccessPointPolicyStatus,
		HTTPMethod: "GET",
		HTTPPath:   "/v20180820/accesspoint/{name}/policyStatus",
	}

	if input == nil {
		input = &GetAccessPointPolicyStatusInput{}
	}

	output = &GetAccessPointPolicyStatusOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetAccessPointPolicyStatus API operation for AWS S3 Control.
//
// Indicates whether the specified access point currently has a policy that
// allows public access. For more information about public access through access
// points, see Managing Data Access with Amazon S3 Access Points (https://docs.aws.amazon.com/AmazonS3/latest/dev/access-points.html)
// in the Amazon Simple Storage Service Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation GetAccessPointPolicyStatus for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetAccessPointPolicyStatus
func (c *S3Control) GetAccessPointPolicyStatus(input *GetAccessPointPolicyStatusInput) (*GetAccessPointPolicyStatusOutput, error) {
	req, out := c.GetAccessPointPolicyStatusRequest(input)
	return out, req.Send()
}

// GetAccessPointPolicyStatusWithContext is the same as GetAccessPointPolicyStatus with the addition of
// the ability to pass a context and additional request options.
//
// See GetAccessPointPolicyStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) GetAccessPointPolicyStatusWithContext(ctx aws.Context, input *GetAccessPointPolicyStatusInput, opts ...request.Option) (*GetAccessPointPolicyStatusOutput, error) {
	req, out := c.GetAccessPointPolicyStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBucket = "GetBucket"

// GetBucketRequest generates a "aws/request.Request" representing the
// client's request for the GetBucket operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBucket for more information on using the GetBucket
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetBucketRequest method.
//    req, resp := client.GetBucketRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetBucket
func (c *S3Control) GetBucketRequest(input *GetBucketInput) (req *request.Request, output *GetBucketOutput) {
	op := &request.Operation{
		Name:       opGetBucket,
		HTTPMethod: "GET",
		HTTPPath:   "/v20180820/bucket/{name}",
	}

	if input == nil {
		input = &GetBucketInput{}
	}

	output = &GetBucketOutput{}
	req = c.newRequest(op, input, output)
	// update account id or check if provided input for account id member matches
	// the account id present in ARN
	req.Handlers.Validate.PushFrontNamed(updateAccountIDWithARNHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetBucket API operation for AWS S3 Control.
//
// Gets an Amazon S3 on Outposts bucket. For more information, see Using Amazon
// S3 on Outposts (https://docs.aws.amazon.com/AmazonS3/latest/dev/S3onOutposts.html)
// in the Amazon Simple Storage Service Developer Guide.
//
// If you are using an identity other than the root user of the AWS account
// that owns the bucket, the calling identity must have the s3-outposts:GetBucket
// permissions on the specified bucket and belong to the bucket owner's account
// in order to use this operation. Only users from Outposts bucket owner account
// with the right permissions can perform actions on an Outposts bucket.
//
// If you don't have s3-outposts:GetBucket permissions or you're not using an
// identity that belongs to the bucket owner's account, Amazon S3 returns a
// 403 Access Denied error.
//
// The following actions are related to GetBucket for Amazon S3 on Outposts:
//
// All Amazon S3 on Outposts REST API requests for this action require an additional
// parameter of x-amz-outpost-id to be passed with the request and an S3 on
// Outposts endpoint hostname prefix instead of s3-control. For an example of
// the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts
// endpoint hostname prefix and the x-amz-outpost-id derived using the access
// point ARN, see the Examples (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucket.html#API_control_GetBucket_Examples)
// section.
//
//    * PutObject (https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObject.html)
//
//    * CreateBucket (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateBucket.html)
//
//    * DeleteBucket (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucket.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation GetBucket for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetBucket
func (c *S3Control) GetBucket(input *GetBucketInput) (*GetBucketOutput, error) {
	req, out := c.GetBucketRequest(input)
	return out, req.Send()
}

// GetBucketWithContext is the same as GetBucket with the addition of
// the ability to pass a context and additional request options.
//
// See GetBucket for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) GetBucketWithContext(ctx aws.Context, input *GetBucketInput, opts ...request.Option) (*GetBucketOutput, error) {
	req, out := c.GetBucketRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBucketLifecycleConfiguration = "GetBucketLifecycleConfiguration"

// GetBucketLifecycleConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the GetBucketLifecycleConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBucketLifecycleConfiguration for more information on using the GetBucketLifecycleConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetBucketLifecycleConfigurationRequest method.
//    req, resp := client.GetBucketLifecycleConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetBucketLifecycleConfiguration
func (c *S3Control) GetBucketLifecycleConfigurationRequest(input *GetBucketLifecycleConfigurationInput) (req *request.Request, output *GetBucketLifecycleConfigurationOutput) {
	op := &request.Operation{
		Name:       opGetBucketLifecycleConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/v20180820/bucket/{name}/lifecycleconfiguration",
	}

	if input == nil {
		input = &GetBucketLifecycleConfigurationInput{}
	}

	output = &GetBucketLifecycleConfigurationOutput{}
	req = c.newRequest(op, input, output)
	// update account id or check if provided input for account id member matches
	// the account id present in ARN
	req.Handlers.Validate.PushFrontNamed(updateAccountIDWithARNHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetBucketLifecycleConfiguration API operation for AWS S3 Control.
//
//
// This operation gets an Amazon S3 on Outposts bucket's lifecycle configuration.
// To get an S3 bucket's lifecycle configuration, see GetBucketLifecycleConfiguration
// (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketLifecycleConfiguration.html)
// in the Amazon Simple Storage Service API.
//
// Returns the lifecycle configuration information set on the Outposts bucket.
// For more information, see Using Amazon S3 on Outposts (https://docs.aws.amazon.com/AmazonS3/latest/dev/S3onOutposts.html)
// and for information about lifecycle configuration, see Object Lifecycle Management
// (https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html)
// in Amazon Simple Storage Service Developer Guide.
//
// To use this operation, you must have permission to perform the s3-outposts:GetLifecycleConfiguration
// action. The Outposts bucket owner has this permission, by default. The bucket
// owner can grant this permission to others. For more information about permissions,
// see Permissions Related to Bucket Subresource Operations (https://docs.aws.amazon.com/AmazonS3/latest/dev/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources)
// and Managing Access Permissions to Your Amazon S3 Resources (https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html).
//
// All Amazon S3 on Outposts REST API requests for this action require an additional
// parameter of x-amz-outpost-id to be passed with the request and an S3 on
// Outposts endpoint hostname prefix instead of s3-control. For an example of
// the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts
// endpoint hostname prefix and the x-amz-outpost-id derived using the access
// point ARN, see the Examples (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketLifecycleConfiguration.html#API_control_GetBucketLifecycleConfiguration_Examples)
// section.
//
// GetBucketLifecycleConfiguration has the following special error:
//
//    * Error code: NoSuchLifecycleConfiguration Description: The lifecycle
//    configuration does not exist. HTTP Status Code: 404 Not Found SOAP Fault
//    Code Prefix: Client
//
// The following actions are related to GetBucketLifecycleConfiguration:
//
//    * PutBucketLifecycleConfiguration (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketLifecycleConfiguration.html)
//
//    * DeleteBucketLifecycleConfiguration (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucketLifecycleConfiguration.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation GetBucketLifecycleConfiguration for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetBucketLifecycleConfiguration
func (c *S3Control) GetBucketLifecycleConfiguration(input *GetBucketLifecycleConfigurationInput) (*GetBucketLifecycleConfigurationOutput, error) {
	req, out := c.GetBucketLifecycleConfigurationRequest(input)
	return out, req.Send()
}

// GetBucketLifecycleConfigurationWithContext is the same as GetBucketLifecycleConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See GetBucketLifecycleConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) GetBucketLifecycleConfigurationWithContext(ctx aws.Context, input *GetBucketLifecycleConfigurationInput, opts ...request.Option) (*GetBucketLifecycleConfigurationOutput, error) {
	req, out := c.GetBucketLifecycleConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBucketPolicy = "GetBucketPolicy"

// GetBucketPolicyRequest generates a "aws/request.Request" representing the
// client's request for the GetBucketPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBucketPolicy for more information on using the GetBucketPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetBucketPolicyRequest method.
//    req, resp := client.GetBucketPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetBucketPolicy
func (c *S3Control) GetBucketPolicyRequest(input *GetBucketPolicyInput) (req *request.Request, output *GetBucketPolicyOutput) {
	op := &request.Operation{
		Name:       opGetBucketPolicy,
		HTTPMethod: "GET",
		HTTPPath:   "/v20180820/bucket/{name}/policy",
	}

	if input == nil {
		input = &GetBucketPolicyInput{}
	}

	output = &GetBucketPolicyOutput{}
	req = c.newRequest(op, input, output)
	// update account id or check if provided input for account id member matches
	// the account id present in ARN
	req.Handlers.Validate.PushFrontNamed(updateAccountIDWithARNHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetBucketPolicy API operation for AWS S3 Control.
//
//
// This action gets a bucket policy for an Amazon S3 on Outposts bucket. To
// get a policy for an S3 bucket, see GetBucketPolicy (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketPolicy.html)
// in the Amazon Simple Storage Service API.
//
// Returns the policy of a specified Outposts bucket. For more information,
// see Using Amazon S3 on Outposts (https://docs.aws.amazon.com/AmazonS3/latest/dev/S3onOutposts.html)
// in the Amazon Simple Storage Service Developer Guide.
//
// If you are using an identity other than the root user of the AWS account
// that owns the bucket, the calling identity must have the GetBucketPolicy
// permissions on the specified bucket and belong to the bucket owner's account
// in order to use this operation.
//
// Only users from Outposts bucket owner account with the right permissions
// can perform actions on an Outposts bucket. If you don't have s3-outposts:GetBucketPolicy
// permissions or you're not using an identity that belongs to the bucket owner's
// account, Amazon S3 returns a 403 Access Denied error.
//
// As a security precaution, the root user of the AWS account that owns a bucket
// can always use this operation, even if the policy explicitly denies the root
// user the ability to perform this action.
//
// For more information about bucket policies, see Using Bucket Policies and
// User Policies (https://docs.aws.amazon.com/AmazonS3/latest/dev/using-iam-policies.html).
//
// All Amazon S3 on Outposts REST API requests for this action require an additional
// parameter of x-amz-outpost-id to be passed with the request and an S3 on
// Outposts endpoint hostname prefix instead of s3-control. For an example of
// the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts
// endpoint hostname prefix and the x-amz-outpost-id derived using the access
// point ARN, see the Examples (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketPolicy.html#API_control_GetBucketPolicy_Examples)
// section.
//
// The following actions are related to GetBucketPolicy:
//
//    * GetObject (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html)
//
//    * PutBucketPolicy (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketPolicy.html)
//
//    * DeleteBucketPolicy (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucketPolicy.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation GetBucketPolicy for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetBucketPolicy
func (c *S3Control) GetBucketPolicy(input *GetBucketPolicyInput) (*GetBucketPolicyOutput, error) {
	req, out := c.GetBucketPolicyRequest(input)
	return out, req.Send()
}

// GetBucketPolicyWithContext is the same as GetBucketPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See GetBucketPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) GetBucketPolicyWithContext(ctx aws.Context, input *GetBucketPolicyInput, opts ...request.Option) (*GetBucketPolicyOutput, error) {
	req, out := c.GetBucketPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBucketTagging = "GetBucketTagging"

// GetBucketTaggingRequest generates a "aws/request.Request" representing the
// client's request for the GetBucketTagging operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBucketTagging for more information on using the GetBucketTagging
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetBucketTaggingRequest method.
//    req, resp := client.GetBucketTaggingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetBucketTagging
func (c *S3Control) GetBucketTaggingRequest(input *GetBucketTaggingInput) (req *request.Request, output *GetBucketTaggingOutput) {
	op := &request.Operation{
		Name:       opGetBucketTagging,
		HTTPMethod: "GET",
		HTTPPath:   "/v20180820/bucket/{name}/tagging",
	}

	if input == nil {
		input = &GetBucketTaggingInput{}
	}

	output = &GetBucketTaggingOutput{}
	req = c.newRequest(op, input, output)
	// update account id or check if provided input for account id member matches
	// the account id present in ARN
	req.Handlers.Validate.PushFrontNamed(updateAccountIDWithARNHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetBucketTagging API operation for AWS S3 Control.
//
//
// This operation gets an Amazon S3 on Outposts bucket's tags. To get an S3
// bucket tags, see GetBucketTagging (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketTagging.html)
// in the Amazon Simple Storage Service API.
//
// Returns the tag set associated with the Outposts bucket. For more information,
// see Using Amazon S3 on Outposts (https://docs.aws.amazon.com/AmazonS3/latest/dev/S3onOutposts.html)
// in the Amazon Simple Storage Service Developer Guide.
//
// To use this operation, you must have permission to perform the GetBucketTagging
// action. By default, the bucket owner has this permission and can grant this
// permission to others.
//
// GetBucketTagging has the following special error:
//
//    * Error code: NoSuchTagSetError Description: There is no tag set associated
//    with the bucket.
//
// All Amazon S3 on Outposts REST API requests for this action require an additional
// parameter of x-amz-outpost-id to be passed with the request and an S3 on
// Outposts endpoint hostname prefix instead of s3-control. For an example of
// the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts
// endpoint hostname prefix and the x-amz-outpost-id derived using the access
// point ARN, see the Examples (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketTagging.html#API_control_GetBucketTagging_Examples)
// section.
//
// The following actions are related to GetBucketTagging:
//
//    * PutBucketTagging (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketTagging.html)
//
//    * DeleteBucketTagging (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucketTagging.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation GetBucketTagging for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetBucketTagging
func (c *S3Control) GetBucketTagging(input *GetBucketTaggingInput) (*GetBucketTaggingOutput, error) {
	req, out := c.GetBucketTaggingRequest(input)
	return out, req.Send()
}

// GetBucketTaggingWithContext is the same as GetBucketTagging with the addition of
// the ability to pass a context and additional request options.
//
// See GetBucketTagging for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) GetBucketTaggingWithContext(ctx aws.Context, input *GetBucketTaggingInput, opts ...request.Option) (*GetBucketTaggingOutput, error) {
	req, out := c.GetBucketTaggingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetJobTagging = "GetJobTagging"

// GetJobTaggingRequest generates a "aws/request.Request" representing the
// client's request for the GetJobTagging operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetJobTagging for more information on using the GetJobTagging
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetJobTaggingRequest method.
//    req, resp := client.GetJobTaggingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetJobTagging
func (c *S3Control) GetJobTaggingRequest(input *GetJobTaggingInput) (req *request.Request, output *GetJobTaggingOutput) {
	op := &request.Operation{
		Name:       opGetJobTagging,
		HTTPMethod: "GET",
		HTTPPath:   "/v20180820/jobs/{id}/tagging",
	}

	if input == nil {
		input = &GetJobTaggingInput{}
	}

	output = &GetJobTaggingOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetJobTagging API operation for AWS S3 Control.
//
// Returns the tags on an S3 Batch Operations job. To use this operation, you
// must have permission to perform the s3:GetJobTagging action. For more information,
// see Controlling access and labeling jobs using tags (https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-managing-jobs.html#batch-ops-job-tags)
// in the Amazon Simple Storage Service Developer Guide.
//
// Related actions include:
//
//    * CreateJob (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateJob.html)
//
//    * PutJobTagging (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutJobTagging.html)
//
//    * DeleteJobTagging (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteJobTagging.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation GetJobTagging for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
//   * ErrCodeNotFoundException "NotFoundException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetJobTagging
func (c *S3Control) GetJobTagging(input *GetJobTaggingInput) (*GetJobTaggingOutput, error) {
	req, out := c.GetJobTaggingRequest(input)
	return out, req.Send()
}

// GetJobTaggingWithContext is the same as GetJobTagging with the addition of
// the ability to pass a context and additional request options.
//
// See GetJobTagging for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) GetJobTaggingWithContext(ctx aws.Context, input *GetJobTaggingInput, opts ...request.Option) (*GetJobTaggingOutput, error) {
	req, out := c.GetJobTaggingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetPublicAccessBlock = "GetPublicAccessBlock"

// GetPublicAccessBlockRequest generates a "aws/request.Request" representing the
// client's request for the GetPublicAccessBlock operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetPublicAccessBlock for more information on using the GetPublicAccessBlock
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetPublicAccessBlockRequest method.
//    req, resp := client.GetPublicAccessBlockRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetPublicAccessBlock
func (c *S3Control) GetPublicAccessBlockRequest(input *GetPublicAccessBlockInput) (req *request.Request, output *GetPublicAccessBlockOutput) {
	op := &request.Operation{
		Name:       opGetPublicAccessBlock,
		HTTPMethod: "GET",
		HTTPPath:   "/v20180820/configuration/publicAccessBlock",
	}

	if input == nil {
		input = &GetPublicAccessBlockInput{}
	}

	output = &GetPublicAccessBlockOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetPublicAccessBlock API operation for AWS S3 Control.
//
// Retrieves the PublicAccessBlock configuration for an AWS account. For more
// information, see Using Amazon S3 block public access (https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html).
//
// Related actions include:
//
//    * DeletePublicAccessBlock (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeletePublicAccessBlock.html)
//
//    * PutPublicAccessBlock (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutPublicAccessBlock.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation GetPublicAccessBlock for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchPublicAccessBlockConfiguration "NoSuchPublicAccessBlockConfiguration"
//   Amazon S3 throws this exception if you make a GetPublicAccessBlock request
//   against an account that doesn't have a PublicAccessBlockConfiguration set.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetPublicAccessBlock
func (c *S3Control) GetPublicAccessBlock(input *GetPublicAccessBlockInput) (*GetPublicAccessBlockOutput, error) {
	req, out := c.GetPublicAccessBlockRequest(input)
	return out, req.Send()
}

// GetPublicAccessBlockWithContext is the same as GetPublicAccessBlock with the addition of
// the ability to pass a context and additional request options.
//
// See GetPublicAccessBlock for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) GetPublicAccessBlockWithContext(ctx aws.Context, input *GetPublicAccessBlockInput, opts ...request.Option) (*GetPublicAccessBlockOutput, error) {
	req, out := c.GetPublicAccessBlockRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetStorageLensConfiguration = "GetStorageLensConfiguration"

// GetStorageLensConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the GetStorageLensConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetStorageLensConfiguration for more information on using the GetStorageLensConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetStorageLensConfigurationRequest method.
//    req, resp := client.GetStorageLensConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetStorageLensConfiguration
func (c *S3Control) GetStorageLensConfigurationRequest(input *GetStorageLensConfigurationInput) (req *request.Request, output *GetStorageLensConfigurationOutput) {
	op := &request.Operation{
		Name:       opGetStorageLensConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/v20180820/storagelens/{storagelensid}",
	}

	if input == nil {
		input = &GetStorageLensConfigurationInput{}
	}

	output = &GetStorageLensConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetStorageLensConfiguration API operation for AWS S3 Control.
//
// Gets the Amazon S3 Storage Lens configuration. For more information, see
// Working with Amazon S3 Storage Lens (https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens.html)
// in the Amazon Simple Storage Service Developer Guide.
//
// To use this action, you must have permission to perform the s3:GetStorageLensConfiguration
// action. For more information, see Setting permissions to use Amazon S3 Storage
// Lens (https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens_iam_permissions.html)
// in the Amazon Simple Storage Service Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation GetStorageLensConfiguration for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetStorageLensConfiguration
func (c *S3Control) GetStorageLensConfiguration(input *GetStorageLensConfigurationInput) (*GetStorageLensConfigurationOutput, error) {
	req, out := c.GetStorageLensConfigurationRequest(input)
	return out, req.Send()
}

// GetStorageLensConfigurationWithContext is the same as GetStorageLensConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See GetStorageLensConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) GetStorageLensConfigurationWithContext(ctx aws.Context, input *GetStorageLensConfigurationInput, opts ...request.Option) (*GetStorageLensConfigurationOutput, error) {
	req, out := c.GetStorageLensConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetStorageLensConfigurationTagging = "GetStorageLensConfigurationTagging"

// GetStorageLensConfigurationTaggingRequest generates a "aws/request.Request" representing the
// client's request for the GetStorageLensConfigurationTagging operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetStorageLensConfigurationTagging for more information on using the GetStorageLensConfigurationTagging
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetStorageLensConfigurationTaggingRequest method.
//    req, resp := client.GetStorageLensConfigurationTaggingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetStorageLensConfigurationTagging
func (c *S3Control) GetStorageLensConfigurationTaggingRequest(input *GetStorageLensConfigurationTaggingInput) (req *request.Request, output *GetStorageLensConfigurationTaggingOutput) {
	op := &request.Operation{
		Name:       opGetStorageLensConfigurationTagging,
		HTTPMethod: "GET",
		HTTPPath:   "/v20180820/storagelens/{storagelensid}/tagging",
	}

	if input == nil {
		input = &GetStorageLensConfigurationTaggingInput{}
	}

	output = &GetStorageLensConfigurationTaggingOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetStorageLensConfigurationTagging API operation for AWS S3 Control.
//
// Gets the tags of Amazon S3 Storage Lens configuration. For more information
// about S3 Storage Lens, see Working with Amazon S3 Storage Lens (https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens.html)
// in the Amazon Simple Storage Service Developer Guide.
//
// To use this action, you must have permission to perform the s3:GetStorageLensConfigurationTagging
// action. For more information, see Setting permissions to use Amazon S3 Storage
// Lens (https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens_iam_permissions.html)
// in the Amazon Simple Storage Service Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation GetStorageLensConfigurationTagging for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetStorageLensConfigurationTagging
func (c *S3Control) GetStorageLensConfigurationTagging(input *GetStorageLensConfigurationTaggingInput) (*GetStorageLensConfigurationTaggingOutput, error) {
	req, out := c.GetStorageLensConfigurationTaggingRequest(input)
	return out, req.Send()
}

// GetStorageLensConfigurationTaggingWithContext is the same as GetStorageLensConfigurationTagging with the addition of
// the ability to pass a context and additional request options.
//
// See GetStorageLensConfigurationTagging for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) GetStorageLensConfigurationTaggingWithContext(ctx aws.Context, input *GetStorageLensConfigurationTaggingInput, opts ...request.Option) (*GetStorageLensConfigurationTaggingOutput, error) {
	req, out := c.GetStorageLensConfigurationTaggingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAccessPoints = "ListAccessPoints"

// ListAccessPointsRequest generates a "aws/request.Request" representing the
// client's request for the ListAccessPoints operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAccessPoints for more information on using the ListAccessPoints
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAccessPointsRequest method.
//    req, resp := client.ListAccessPointsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/ListAccessPoints
func (c *S3Control) ListAccessPointsRequest(input *ListAccessPointsInput) (req *request.Request, output *ListAccessPointsOutput) {
	op := &request.Operation{
		Name:       opListAccessPoints,
		HTTPMethod: "GET",
		HTTPPath:   "/v20180820/accesspoint",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAccessPointsInput{}
	}

	output = &ListAccessPointsOutput{}
	req = c.newRequest(op, input, output)
	// update account id or check if provided input for account id member matches
	// the account id present in ARN
	req.Handlers.Validate.PushFrontNamed(updateAccountIDWithARNHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListAccessPoints API operation for AWS S3 Control.
//
// Returns a list of the access points currently associated with the specified
// bucket. You can retrieve up to 1000 access points per call. If the specified
// bucket has more than 1,000 access points (or the number specified in maxResults,
// whichever is less), the response will include a continuation token that you
// can use to list the additional access points.
//
// All Amazon S3 on Outposts REST API requests for this action require an additional
// parameter of x-amz-outpost-id to be passed with the request and an S3 on
// Outposts endpoint hostname prefix instead of s3-control. For an example of
// the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts
// endpoint hostname prefix and the x-amz-outpost-id derived using the access
// point ARN, see the Examples (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPoint.html#API_control_GetAccessPoint_Examples)
// section.
//
// The following actions are related to ListAccessPoints:
//
//    * CreateAccessPoint (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateAccessPoint.html)
//
//    * DeleteAccessPoint (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPoint.html)
//
//    * GetAccessPoint (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPoint.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation ListAccessPoints for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/ListAccessPoints
func (c *S3Control) ListAccessPoints(input *ListAccessPointsInput) (*ListAccessPointsOutput, error) {
	req, out := c.ListAccessPointsRequest(input)
	return out, req.Send()
}

// ListAccessPointsWithContext is the same as ListAccessPoints with the addition of
// the ability to pass a context and additional request options.
//
// See ListAccessPoints for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) ListAccessPointsWithContext(ctx aws.Context, input *ListAccessPointsInput, opts ...request.Option) (*ListAccessPointsOutput, error) {
	req, out := c.ListAccessPointsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAccessPointsPages iterates over the pages of a ListAccessPoints operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAccessPoints method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListAccessPoints operation.
//    pageNum := 0
//    err := client.ListAccessPointsPages(params,
//        func(page *s3control.ListAccessPointsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *S3Control) ListAccessPointsPages(input *ListAccessPointsInput, fn func(*ListAccessPointsOutput, bool) bool) error {
	return c.ListAccessPointsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAccessPointsPagesWithContext same as ListAccessPointsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) ListAccessPointsPagesWithContext(ctx aws.Context, input *ListAccessPointsInput, fn func(*ListAccessPointsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAccessPointsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAccessPointsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAccessPointsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListJobs = "ListJobs"

// ListJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListJobs for more information on using the ListJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListJobsRequest method.
//    req, resp := client.ListJobsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/ListJobs
func (c *S3Control) ListJobsRequest(input *ListJobsInput) (req *request.Request, output *ListJobsOutput) {
	op := &request.Operation{
		Name:       opListJobs,
		HTTPMethod: "GET",
		HTTPPath:   "/v20180820/jobs",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListJobsInput{}
	}

	output = &ListJobsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListJobs API operation for AWS S3 Control.
//
// Lists current S3 Batch Operations jobs and jobs that have ended within the
// last 30 days for the AWS account making the request. For more information,
// see S3 Batch Operations (https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-basics.html)
// in the Amazon Simple Storage Service Developer Guide.
//
// Related actions include:
//
//    * CreateJob (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateJob.html)
//
//    * DescribeJob (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DescribeJob.html)
//
//    * UpdateJobPriority (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_UpdateJobPriority.html)
//
//    * UpdateJobStatus (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_UpdateJobStatus.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation ListJobs for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/ListJobs
func (c *S3Control) ListJobs(input *ListJobsInput) (*ListJobsOutput, error) {
	req, out := c.ListJobsRequest(input)
	return out, req.Send()
}

// ListJobsWithContext is the same as ListJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) ListJobsWithContext(ctx aws.Context, input *ListJobsInput, opts ...request.Option) (*ListJobsOutput, error) {
	req, out := c.ListJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListJobsPages iterates over the pages of a ListJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListJobs operation.
//    pageNum := 0
//    err := client.ListJobsPages(params,
//        func(page *s3control.ListJobsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *S3Control) ListJobsPages(input *ListJobsInput, fn func(*ListJobsOutput, bool) bool) error {
	return c.ListJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListJobsPagesWithContext same as ListJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) ListJobsPagesWithContext(ctx aws.Context, input *ListJobsInput, fn func(*ListJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListRegionalBuckets = "ListRegionalBuckets"

// ListRegionalBucketsRequest generates a "aws/request.Request" representing the
// client's request for the ListRegionalBuckets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRegionalBuckets for more information on using the ListRegionalBuckets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListRegionalBucketsRequest method.
//    req, resp := client.ListRegionalBucketsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/ListRegionalBuckets
func (c *S3Control) ListRegionalBucketsRequest(input *ListRegionalBucketsInput) (req *request.Request, output *ListRegionalBucketsOutput) {
	op := &request.Operation{
		Name:       opListRegionalBuckets,
		HTTPMethod: "GET",
		HTTPPath:   "/v20180820/bucket",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRegionalBucketsInput{}
	}

	output = &ListRegionalBucketsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListRegionalBuckets API operation for AWS S3 Control.
//
// Returns a list of all Outposts buckets in an Outpost that are owned by the
// authenticated sender of the request. For more information, see Using Amazon
// S3 on Outposts (https://docs.aws.amazon.com/AmazonS3/latest/dev/S3onOutposts.html)
// in the Amazon Simple Storage Service Developer Guide.
//
// For an example of the request syntax for Amazon S3 on Outposts that uses
// the S3 on Outposts endpoint hostname prefix and x-amz-outpost-id in your
// request, see the Examples (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListRegionalBuckets.html#API_control_ListRegionalBuckets_Examples)
// section.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation ListRegionalBuckets for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/ListRegionalBuckets
func (c *S3Control) ListRegionalBuckets(input *ListRegionalBucketsInput) (*ListRegionalBucketsOutput, error) {
	req, out := c.ListRegionalBucketsRequest(input)
	return out, req.Send()
}

// ListRegionalBucketsWithContext is the same as ListRegionalBuckets with the addition of
// the ability to pass a context and additional request options.
//
// See ListRegionalBuckets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) ListRegionalBucketsWithContext(ctx aws.Context, input *ListRegionalBucketsInput, opts ...request.Option) (*ListRegionalBucketsOutput, error) {
	req, out := c.ListRegionalBucketsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListRegionalBucketsPages iterates over the pages of a ListRegionalBuckets operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListRegionalBuckets method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListRegionalBuckets operation.
//    pageNum := 0
//    err := client.ListRegionalBucketsPages(params,
//        func(page *s3control.ListRegionalBucketsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *S3Control) ListRegionalBucketsPages(input *ListRegionalBucketsInput, fn func(*ListRegionalBucketsOutput, bool) bool) error {
	return c.ListRegionalBucketsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListRegionalBucketsPagesWithContext same as ListRegionalBucketsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) ListRegionalBucketsPagesWithContext(ctx aws.Context, input *ListRegionalBucketsInput, fn func(*ListRegionalBucketsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListRegionalBucketsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListRegionalBucketsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListRegionalBucketsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListStorageLensConfigurations = "ListStorageLensConfigurations"

// ListStorageLensConfigurationsRequest generates a "aws/request.Request" representing the
// client's request for the ListStorageLensConfigurations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListStorageLensConfigurations for more information on using the ListStorageLensConfigurations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListStorageLensConfigurationsRequest method.
//    req, resp := client.ListStorageLensConfigurationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/ListStorageLensConfigurations
func (c *S3Control) ListStorageLensConfigurationsRequest(input *ListStorageLensConfigurationsInput) (req *request.Request, output *ListStorageLensConfigurationsOutput) {
	op := &request.Operation{
		Name:       opListStorageLensConfigurations,
		HTTPMethod: "GET",
		HTTPPath:   "/v20180820/storagelens",
	}

	if input == nil {
		input = &ListStorageLensConfigurationsInput{}
	}

	output = &ListStorageLensConfigurationsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListStorageLensConfigurations API operation for AWS S3 Control.
//
// Gets a list of Amazon S3 Storage Lens configurations. For more information
// about S3 Storage Lens, see Working with Amazon S3 Storage Lens (https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens.html)
// in the Amazon Simple Storage Service Developer Guide.
//
// To use this action, you must have permission to perform the s3:ListStorageLensConfigurations
// action. For more information, see Setting permissions to use Amazon S3 Storage
// Lens (https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens_iam_permissions.html)
// in the Amazon Simple Storage Service Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation ListStorageLensConfigurations for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/ListStorageLensConfigurations
func (c *S3Control) ListStorageLensConfigurations(input *ListStorageLensConfigurationsInput) (*ListStorageLensConfigurationsOutput, error) {
	req, out := c.ListStorageLensConfigurationsRequest(input)
	return out, req.Send()
}

// ListStorageLensConfigurationsWithContext is the same as ListStorageLensConfigurations with the addition of
// the ability to pass a context and additional request options.
//
// See ListStorageLensConfigurations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) ListStorageLensConfigurationsWithContext(ctx aws.Context, input *ListStorageLensConfigurationsInput, opts ...request.Option) (*ListStorageLensConfigurationsOutput, error) {
	req, out := c.ListStorageLensConfigurationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutAccessPointPolicy = "PutAccessPointPolicy"

// PutAccessPointPolicyRequest generates a "aws/request.Request" representing the
// client's request for the PutAccessPointPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutAccessPointPolicy for more information on using the PutAccessPointPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutAccessPointPolicyRequest method.
//    req, resp := client.PutAccessPointPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/PutAccessPointPolicy
func (c *S3Control) PutAccessPointPolicyRequest(input *PutAccessPointPolicyInput) (req *request.Request, output *PutAccessPointPolicyOutput) {
	op := &request.Operation{
		Name:       opPutAccessPointPolicy,
		HTTPMethod: "PUT",
		HTTPPath:   "/v20180820/accesspoint/{name}/policy",
	}

	if input == nil {
		input = &PutAccessPointPolicyInput{}
	}

	output = &PutAccessPointPolicyOutput{}
	req = c.newRequest(op, input, output)
	// update account id or check if provided input for account id member matches
	// the account id present in ARN
	req.Handlers.Validate.PushFrontNamed(updateAccountIDWithARNHandler)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// PutAccessPointPolicy API operation for AWS S3 Control.
//
// Associates an access policy with the specified access point. Each access
// point can have only one policy, so a request made to this API replaces any
// existing policy associated with the specified access point.
//
// All Amazon S3 on Outposts REST API requests for this action require an additional
// parameter of x-amz-outpost-id to be passed with the request and an S3 on
// Outposts endpoint hostname prefix instead of s3-control. For an example of
// the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts
// endpoint hostname prefix and the x-amz-outpost-id derived using the access
// point ARN, see the Examples (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutAccessPointPolicy.html#API_control_PutAccessPointPolicy_Examples)
// section.
//
// The following actions are related to PutAccessPointPolicy:
//
//    * GetAccessPointPolicy (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPointPolicy.html)
//
//    * DeleteAccessPointPolicy (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPointPolicy.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation PutAccessPointPolicy for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/PutAccessPointPolicy
func (c *S3Control) PutAccessPointPolicy(input *PutAccessPointPolicyInput) (*PutAccessPointPolicyOutput, error) {
	req, out := c.PutAccessPointPolicyRequest(input)
	return out, req.Send()
}

// PutAccessPointPolicyWithContext is the same as PutAccessPointPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See PutAccessPointPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) PutAccessPointPolicyWithContext(ctx aws.Context, input *PutAccessPointPolicyInput, opts ...request.Option) (*PutAccessPointPolicyOutput, error) {
	req, out := c.PutAccessPointPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutBucketLifecycleConfiguration = "PutBucketLifecycleConfiguration"

// PutBucketLifecycleConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the PutBucketLifecycleConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutBucketLifecycleConfiguration for more information on using the PutBucketLifecycleConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutBucketLifecycleConfigurationRequest method.
//    req, resp := client.PutBucketLifecycleConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/PutBucketLifecycleConfiguration
func (c *S3Control) PutBucketLifecycleConfigurationRequest(input *PutBucketLifecycleConfigurationInput) (req *request.Request, output *PutBucketLifecycleConfigurationOutput) {
	op := &request.Operation{
		Name:       opPutBucketLifecycleConfiguration,
		HTTPMethod: "PUT",
		HTTPPath:   "/v20180820/bucket/{name}/lifecycleconfiguration",
	}

	if input == nil {
		input = &PutBucketLifecycleConfigurationInput{}
	}

	output = &PutBucketLifecycleConfigurationOutput{}
	req = c.newRequest(op, input, output)
	// update account id or check if provided input for account id member matches
	// the account id present in ARN
	req.Handlers.Validate.PushFrontNamed(updateAccountIDWithARNHandler)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	req.Handlers.Build.PushBackNamed(request.NamedHandler{
		Name: "contentMd5Handler",
		Fn:   checksum.AddBodyContentMD5Handler,
	})
	return
}

// PutBucketLifecycleConfiguration API operation for AWS S3 Control.
//
//
// This action puts a lifecycle configuration to an Amazon S3 on Outposts bucket.
// To put a lifecycle configuration to an S3 bucket, see PutBucketLifecycleConfiguration
// (https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketLifecycleConfiguration.html)
// in the Amazon Simple Storage Service API.
//
// Creates a new lifecycle configuration for the Outposts bucket or replaces
// an existing lifecycle configuration. Outposts buckets only support lifecycle
// configurations that delete/expire objects after a certain period of time
// and abort incomplete multipart uploads. For more information, see Managing
// Lifecycle Permissions for Amazon S3 on Outposts (https://docs.aws.amazon.com/AmazonS3/latest/dev/S3onOutposts.html).
//
// All Amazon S3 on Outposts REST API requests for this action require an additional
// parameter of x-amz-outpost-id to be passed with the request and an S3 on
// Outposts endpoint hostname prefix instead of s3-control. For an example of
// the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts
// endpoint hostname prefix and the x-amz-outpost-id derived using the access
// point ARN, see the Examples (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketLifecycleConfiguration.html#API_control_PutBucketLifecycleConfiguration_Examples)
// section.
//
// The following actions are related to PutBucketLifecycleConfiguration:
//
//    * GetBucketLifecycleConfiguration (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketLifecycleConfiguration.html)
//
//    * DeleteBucketLifecycleConfiguration (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucketLifecycleConfiguration.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation PutBucketLifecycleConfiguration for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/PutBucketLifecycleConfiguration
func (c *S3Control) PutBucketLifecycleConfiguration(input *PutBucketLifecycleConfigurationInput) (*PutBucketLifecycleConfigurationOutput, error) {
	req, out := c.PutBucketLifecycleConfigurationRequest(input)
	return out, req.Send()
}

// PutBucketLifecycleConfigurationWithContext is the same as PutBucketLifecycleConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See PutBucketLifecycleConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) PutBucketLifecycleConfigurationWithContext(ctx aws.Context, input *PutBucketLifecycleConfigurationInput, opts ...request.Option) (*PutBucketLifecycleConfigurationOutput, error) {
	req, out := c.PutBucketLifecycleConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutBucketPolicy = "PutBucketPolicy"

// PutBucketPolicyRequest generates a "aws/request.Request" representing the
// client's request for the PutBucketPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutBucketPolicy for more information on using the PutBucketPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutBucketPolicyRequest method.
//    req, resp := client.PutBucketPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/PutBucketPolicy
func (c *S3Control) PutBucketPolicyRequest(input *PutBucketPolicyInput) (req *request.Request, output *PutBucketPolicyOutput) {
	op := &request.Operation{
		Name:       opPutBucketPolicy,
		HTTPMethod: "PUT",
		HTTPPath:   "/v20180820/bucket/{name}/policy",
	}

	if input == nil {
		input = &PutBucketPolicyInput{}
	}

	output = &PutBucketPolicyOutput{}
	req = c.newRequest(op, input, output)
	// update account id or check if provided input for account id member matches
	// the account id present in ARN
	req.Handlers.Validate.PushFrontNamed(updateAccountIDWithARNHandler)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	req.Handlers.Build.PushBackNamed(request.NamedHandler{
		Name: "contentMd5Handler",
		Fn:   checksum.AddBodyContentMD5Handler,
	})
	return
}

// PutBucketPolicy API operation for AWS S3 Control.
//
//
// This action puts a bucket policy to an Amazon S3 on Outposts bucket. To put
// a policy on an S3 bucket, see PutBucketPolicy (https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketPolicy.html)
// in the Amazon Simple Storage Service API.
//
// Applies an Amazon S3 bucket policy to an Outposts bucket. For more information,
// see Using Amazon S3 on Outposts (https://docs.aws.amazon.com/AmazonS3/latest/dev/S3onOutposts.html)
// in the Amazon Simple Storage Service Developer Guide.
//
// If you are using an identity other than the root user of the AWS account
// that owns the Outposts bucket, the calling identity must have the PutBucketPolicy
// permissions on the specified Outposts bucket and belong to the bucket owner's
// account in order to use this operation.
//
// If you don't have PutBucketPolicy permissions, Amazon S3 returns a 403 Access
// Denied error. If you have the correct permissions, but you're not using an
// identity that belongs to the bucket owner's account, Amazon S3 returns a
// 405 Method Not Allowed error.
//
// As a security precaution, the root user of the AWS account that owns a bucket
// can always use this operation, even if the policy explicitly denies the root
// user the ability to perform this action.
//
// For more information about bucket policies, see Using Bucket Policies and
// User Policies (https://docs.aws.amazon.com/AmazonS3/latest/dev/using-iam-policies.html).
//
// All Amazon S3 on Outposts REST API requests for this action require an additional
// parameter of x-amz-outpost-id to be passed with the request and an S3 on
// Outposts endpoint hostname prefix instead of s3-control. For an example of
// the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts
// endpoint hostname prefix and the x-amz-outpost-id derived using the access
// point ARN, see the Examples (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketPolicy.html#API_control_PutBucketPolicy_Examples)
// section.
//
// The following actions are related to PutBucketPolicy:
//
//    * GetBucketPolicy (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketPolicy.html)
//
//    * DeleteBucketPolicy (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucketPolicy.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation PutBucketPolicy for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/PutBucketPolicy
func (c *S3Control) PutBucketPolicy(input *PutBucketPolicyInput) (*PutBucketPolicyOutput, error) {
	req, out := c.PutBucketPolicyRequest(input)
	return out, req.Send()
}

// PutBucketPolicyWithContext is the same as PutBucketPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See PutBucketPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) PutBucketPolicyWithContext(ctx aws.Context, input *PutBucketPolicyInput, opts ...request.Option) (*PutBucketPolicyOutput, error) {
	req, out := c.PutBucketPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutBucketTagging = "PutBucketTagging"

// PutBucketTaggingRequest generates a "aws/request.Request" representing the
// client's request for the PutBucketTagging operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutBucketTagging for more information on using the PutBucketTagging
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutBucketTaggingRequest method.
//    req, resp := client.PutBucketTaggingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/PutBucketTagging
func (c *S3Control) PutBucketTaggingRequest(input *PutBucketTaggingInput) (req *request.Request, output *PutBucketTaggingOutput) {
	op := &request.Operation{
		Name:       opPutBucketTagging,
		HTTPMethod: "PUT",
		HTTPPath:   "/v20180820/bucket/{name}/tagging",
	}

	if input == nil {
		input = &PutBucketTaggingInput{}
	}

	output = &PutBucketTaggingOutput{}
	req = c.newRequest(op, input, output)
	// update account id or check if provided input for account id member matches
	// the account id present in ARN
	req.Handlers.Validate.PushFrontNamed(updateAccountIDWithARNHandler)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	req.Handlers.Build.PushBackNamed(request.NamedHandler{
		Name: "contentMd5Handler",
		Fn:   checksum.AddBodyContentMD5Handler,
	})
	return
}

// PutBucketTagging API operation for AWS S3 Control.
//
//
// This action puts tags on an Amazon S3 on Outposts bucket. To put tags on
// an S3 bucket, see PutBucketTagging (https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketTagging.html)
// in the Amazon Simple Storage Service API.
//
// Sets the tags for an Outposts bucket. For more information, see Using Amazon
// S3 on Outposts (https://docs.aws.amazon.com/AmazonS3/latest/dev/S3onOutposts.html)
// in the Amazon Simple Storage Service Developer Guide.
//
// Use tags to organize your AWS bill to reflect your own cost structure. To
// do this, sign up to get your AWS account bill with tag key values included.
// Then, to see the cost of combined resources, organize your billing information
// according to resources with the same tag key values. For example, you can
// tag several resources with a specific application name, and then organize
// your billing information to see the total cost of that application across
// several services. For more information, see Cost Allocation and Tagging (https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html).
//
// Within a bucket, if you add a tag that has the same key as an existing tag,
// the new value overwrites the old value. For more information, see Using Cost
// Allocation in Amazon S3 Bucket Tags (https://docs.aws.amazon.com/AmazonS3/latest/dev/CostAllocTagging.html).
//
// To use this operation, you must have permissions to perform the s3-outposts:PutBucketTagging
// action. The Outposts bucket owner has this permission by default and can
// grant this permission to others. For more information about permissions,
// see Permissions Related to Bucket Subresource Operations (https://docs.aws.amazon.com/AmazonS3/latest/dev/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources)
// and Managing Access Permissions to Your Amazon S3 Resources (https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html).
//
// PutBucketTagging has the following special errors:
//
//    * Error code: InvalidTagError Description: The tag provided was not a
//    valid tag. This error can occur if the tag did not pass input validation.
//    For information about tag restrictions, see User-Defined Tag Restrictions
//    (https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/allocation-tag-restrictions.html)
//    and AWS-Generated Cost Allocation Tag Restrictions (https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/aws-tag-restrictions.html).
//
//    * Error code: MalformedXMLError Description: The XML provided does not
//    match the schema.
//
//    * Error code: OperationAbortedError Description: A conflicting conditional
//    operation is currently in progress against this resource. Try again.
//
//    * Error code: InternalError Description: The service was unable to apply
//    the provided tag to the bucket.
//
// All Amazon S3 on Outposts REST API requests for this action require an additional
// parameter of x-amz-outpost-id to be passed with the request and an S3 on
// Outposts endpoint hostname prefix instead of s3-control. For an example of
// the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts
// endpoint hostname prefix and the x-amz-outpost-id derived using the access
// point ARN, see the Examples (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketTagging.html#API_control_PutBucketTagging_Examples)
// section.
//
// The following actions are related to PutBucketTagging:
//
//    * GetBucketTagging (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketTagging.html)
//
//    * DeleteBucketTagging (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucketTagging.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation PutBucketTagging for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/PutBucketTagging
func (c *S3Control) PutBucketTagging(input *PutBucketTaggingInput) (*PutBucketTaggingOutput, error) {
	req, out := c.PutBucketTaggingRequest(input)
	return out, req.Send()
}

// PutBucketTaggingWithContext is the same as PutBucketTagging with the addition of
// the ability to pass a context and additional request options.
//
// See PutBucketTagging for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) PutBucketTaggingWithContext(ctx aws.Context, input *PutBucketTaggingInput, opts ...request.Option) (*PutBucketTaggingOutput, error) {
	req, out := c.PutBucketTaggingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutJobTagging = "PutJobTagging"

// PutJobTaggingRequest generates a "aws/request.Request" representing the
// client's request for the PutJobTagging operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutJobTagging for more information on using the PutJobTagging
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutJobTaggingRequest method.
//    req, resp := client.PutJobTaggingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/PutJobTagging
func (c *S3Control) PutJobTaggingRequest(input *PutJobTaggingInput) (req *request.Request, output *PutJobTaggingOutput) {
	op := &request.Operation{
		Name:       opPutJobTagging,
		HTTPMethod: "PUT",
		HTTPPath:   "/v20180820/jobs/{id}/tagging",
	}

	if input == nil {
		input = &PutJobTaggingInput{}
	}

	output = &PutJobTaggingOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// PutJobTagging API operation for AWS S3 Control.
//
// Sets the supplied tag-set on an S3 Batch Operations job.
//
// A tag is a key-value pair. You can associate S3 Batch Operations tags with
// any job by sending a PUT request against the tagging subresource that is
// associated with the job. To modify the existing tag set, you can either replace
// the existing tag set entirely, or make changes within the existing tag set
// by retrieving the existing tag set using GetJobTagging (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetJobTagging.html),
// modify that tag set, and use this action to replace the tag set with the
// one you modified. For more information, see Controlling access and labeling
// jobs using tags (https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-managing-jobs.html#batch-ops-job-tags)
// in the Amazon Simple Storage Service Developer Guide.
//
//    * If you send this request with an empty tag set, Amazon S3 deletes the
//    existing tag set on the Batch Operations job. If you use this method,
//    you are charged for a Tier 1 Request (PUT). For more information, see
//    Amazon S3 pricing (http://aws.amazon.com/s3/pricing/).
//
//    * For deleting existing tags for your Batch Operations job, a DeleteJobTagging
//    (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteJobTagging.html)
//    request is preferred because it achieves the same result without incurring
//    charges.
//
//    * A few things to consider about using tags: Amazon S3 limits the maximum
//    number of tags to 50 tags per job. You can associate up to 50 tags with
//    a job as long as they have unique tag keys. A tag key can be up to 128
//    Unicode characters in length, and tag values can be up to 256 Unicode
//    characters in length. The key and values are case sensitive. For tagging-related
//    restrictions related to characters and encodings, see User-Defined Tag
//    Restrictions (https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/allocation-tag-restrictions.html)
//    in the AWS Billing and Cost Management User Guide.
//
// To use this operation, you must have permission to perform the s3:PutJobTagging
// action.
//
// Related actions include:
//
//    * CreatJob (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateJob.html)
//
//    * GetJobTagging (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetJobTagging.html)
//
//    * DeleteJobTagging (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteJobTagging.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation PutJobTagging for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
//   * ErrCodeNotFoundException "NotFoundException"
//
//   * ErrCodeTooManyTagsException "TooManyTagsException"
//   Amazon S3 throws this exception if you have too many tags in your tag set.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/PutJobTagging
func (c *S3Control) PutJobTagging(input *PutJobTaggingInput) (*PutJobTaggingOutput, error) {
	req, out := c.PutJobTaggingRequest(input)
	return out, req.Send()
}

// PutJobTaggingWithContext is the same as PutJobTagging with the addition of
// the ability to pass a context and additional request options.
//
// See PutJobTagging for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) PutJobTaggingWithContext(ctx aws.Context, input *PutJobTaggingInput, opts ...request.Option) (*PutJobTaggingOutput, error) {
	req, out := c.PutJobTaggingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutPublicAccessBlock = "PutPublicAccessBlock"

// PutPublicAccessBlockRequest generates a "aws/request.Request" representing the
// client's request for the PutPublicAccessBlock operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutPublicAccessBlock for more information on using the PutPublicAccessBlock
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutPublicAccessBlockRequest method.
//    req, resp := client.PutPublicAccessBlockRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/PutPublicAccessBlock
func (c *S3Control) PutPublicAccessBlockRequest(input *PutPublicAccessBlockInput) (req *request.Request, output *PutPublicAccessBlockOutput) {
	op := &request.Operation{
		Name:       opPutPublicAccessBlock,
		HTTPMethod: "PUT",
		HTTPPath:   "/v20180820/configuration/publicAccessBlock",
	}

	if input == nil {
		input = &PutPublicAccessBlockInput{}
	}

	output = &PutPublicAccessBlockOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// PutPublicAccessBlock API operation for AWS S3 Control.
//
// Creates or modifies the PublicAccessBlock configuration for an AWS account.
// For more information, see Using Amazon S3 block public access (https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html).
//
// Related actions include:
//
//    * GetPublicAccessBlock (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetPublicAccessBlock.html)
//
//    * DeletePublicAccessBlock (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeletePublicAccessBlock.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation PutPublicAccessBlock for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/PutPublicAccessBlock
func (c *S3Control) PutPublicAccessBlock(input *PutPublicAccessBlockInput) (*PutPublicAccessBlockOutput, error) {
	req, out := c.PutPublicAccessBlockRequest(input)
	return out, req.Send()
}

// PutPublicAccessBlockWithContext is the same as PutPublicAccessBlock with the addition of
// the ability to pass a context and additional request options.
//
// See PutPublicAccessBlock for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) PutPublicAccessBlockWithContext(ctx aws.Context, input *PutPublicAccessBlockInput, opts ...request.Option) (*PutPublicAccessBlockOutput, error) {
	req, out := c.PutPublicAccessBlockRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutStorageLensConfiguration = "PutStorageLensConfiguration"

// PutStorageLensConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the PutStorageLensConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutStorageLensConfiguration for more information on using the PutStorageLensConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutStorageLensConfigurationRequest method.
//    req, resp := client.PutStorageLensConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/PutStorageLensConfiguration
func (c *S3Control) PutStorageLensConfigurationRequest(input *PutStorageLensConfigurationInput) (req *request.Request, output *PutStorageLensConfigurationOutput) {
	op := &request.Operation{
		Name:       opPutStorageLensConfiguration,
		HTTPMethod: "PUT",
		HTTPPath:   "/v20180820/storagelens/{storagelensid}",
	}

	if input == nil {
		input = &PutStorageLensConfigurationInput{}
	}

	output = &PutStorageLensConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// PutStorageLensConfiguration API operation for AWS S3 Control.
//
// Puts an Amazon S3 Storage Lens configuration. For more information about
// S3 Storage Lens, see Working with Amazon S3 Storage Lens (https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens.html)
// in the Amazon Simple Storage Service Developer Guide.
//
// To use this action, you must have permission to perform the s3:PutStorageLensConfiguration
// action. For more information, see Setting permissions to use Amazon S3 Storage
// Lens (https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens_iam_permissions.html)
// in the Amazon Simple Storage Service Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation PutStorageLensConfiguration for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/PutStorageLensConfiguration
func (c *S3Control) PutStorageLensConfiguration(input *PutStorageLensConfigurationInput) (*PutStorageLensConfigurationOutput, error) {
	req, out := c.PutStorageLensConfigurationRequest(input)
	return out, req.Send()
}

// PutStorageLensConfigurationWithContext is the same as PutStorageLensConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See PutStorageLensConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) PutStorageLensConfigurationWithContext(ctx aws.Context, input *PutStorageLensConfigurationInput, opts ...request.Option) (*PutStorageLensConfigurationOutput, error) {
	req, out := c.PutStorageLensConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutStorageLensConfigurationTagging = "PutStorageLensConfigurationTagging"

// PutStorageLensConfigurationTaggingRequest generates a "aws/request.Request" representing the
// client's request for the PutStorageLensConfigurationTagging operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutStorageLensConfigurationTagging for more information on using the PutStorageLensConfigurationTagging
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutStorageLensConfigurationTaggingRequest method.
//    req, resp := client.PutStorageLensConfigurationTaggingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/PutStorageLensConfigurationTagging
func (c *S3Control) PutStorageLensConfigurationTaggingRequest(input *PutStorageLensConfigurationTaggingInput) (req *request.Request, output *PutStorageLensConfigurationTaggingOutput) {
	op := &request.Operation{
		Name:       opPutStorageLensConfigurationTagging,
		HTTPMethod: "PUT",
		HTTPPath:   "/v20180820/storagelens/{storagelensid}/tagging",
	}

	if input == nil {
		input = &PutStorageLensConfigurationTaggingInput{}
	}

	output = &PutStorageLensConfigurationTaggingOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// PutStorageLensConfigurationTagging API operation for AWS S3 Control.
//
// Put or replace tags on an existing Amazon S3 Storage Lens configuration.
// For more information about S3 Storage Lens, see Working with Amazon S3 Storage
// Lens (https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens.html)
// in the Amazon Simple Storage Service Developer Guide.
//
// To use this action, you must have permission to perform the s3:PutStorageLensConfigurationTagging
// action. For more information, see Setting permissions to use Amazon S3 Storage
// Lens (https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens_iam_permissions.html)
// in the Amazon Simple Storage Service Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation PutStorageLensConfigurationTagging for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/PutStorageLensConfigurationTagging
func (c *S3Control) PutStorageLensConfigurationTagging(input *PutStorageLensConfigurationTaggingInput) (*PutStorageLensConfigurationTaggingOutput, error) {
	req, out := c.PutStorageLensConfigurationTaggingRequest(input)
	return out, req.Send()
}

// PutStorageLensConfigurationTaggingWithContext is the same as PutStorageLensConfigurationTagging with the addition of
// the ability to pass a context and additional request options.
//
// See PutStorageLensConfigurationTagging for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) PutStorageLensConfigurationTaggingWithContext(ctx aws.Context, input *PutStorageLensConfigurationTaggingInput, opts ...request.Option) (*PutStorageLensConfigurationTaggingOutput, error) {
	req, out := c.PutStorageLensConfigurationTaggingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateJobPriority = "UpdateJobPriority"

// UpdateJobPriorityRequest generates a "aws/request.Request" representing the
// client's request for the UpdateJobPriority operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateJobPriority for more information on using the UpdateJobPriority
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateJobPriorityRequest method.
//    req, resp := client.UpdateJobPriorityRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/UpdateJobPriority
func (c *S3Control) UpdateJobPriorityRequest(input *UpdateJobPriorityInput) (req *request.Request, output *UpdateJobPriorityOutput) {
	op := &request.Operation{
		Name:       opUpdateJobPriority,
		HTTPMethod: "POST",
		HTTPPath:   "/v20180820/jobs/{id}/priority",
	}

	if input == nil {
		input = &UpdateJobPriorityInput{}
	}

	output = &UpdateJobPriorityOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// UpdateJobPriority API operation for AWS S3 Control.
//
// Updates an existing S3 Batch Operations job's priority. For more information,
// see S3 Batch Operations (https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-basics.html)
// in the Amazon Simple Storage Service Developer Guide.
//
// Related actions include:
//
//    * CreateJob (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateJob.html)
//
//    * ListJobs (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListJobs.html)
//
//    * DescribeJob (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DescribeJob.html)
//
//    * UpdateJobStatus (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_UpdateJobStatus.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation UpdateJobPriority for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
//   * ErrCodeNotFoundException "NotFoundException"
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/UpdateJobPriority
func (c *S3Control) UpdateJobPriority(input *UpdateJobPriorityInput) (*UpdateJobPriorityOutput, error) {
	req, out := c.UpdateJobPriorityRequest(input)
	return out, req.Send()
}

// UpdateJobPriorityWithContext is the same as UpdateJobPriority with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateJobPriority for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) UpdateJobPriorityWithContext(ctx aws.Context, input *UpdateJobPriorityInput, opts ...request.Option) (*UpdateJobPriorityOutput, error) {
	req, out := c.UpdateJobPriorityRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateJobStatus = "UpdateJobStatus"

// UpdateJobStatusRequest generates a "aws/request.Request" representing the
// client's request for the UpdateJobStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateJobStatus for more information on using the UpdateJobStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateJobStatusRequest method.
//    req, resp := client.UpdateJobStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/UpdateJobStatus
func (c *S3Control) UpdateJobStatusRequest(input *UpdateJobStatusInput) (req *request.Request, output *UpdateJobStatusOutput) {
	op := &request.Operation{
		Name:       opUpdateJobStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/v20180820/jobs/{id}/status",
	}

	if input == nil {
		input = &UpdateJobStatusInput{}
	}

	output = &UpdateJobStatusOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// UpdateJobStatus API operation for AWS S3 Control.
//
// Updates the status for the specified job. Use this operation to confirm that
// you want to run a job or to cancel an existing job. For more information,
// see S3 Batch Operations (https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-basics.html)
// in the Amazon Simple Storage Service Developer Guide.
//
// Related actions include:
//
//    * CreateJob (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateJob.html)
//
//    * ListJobs (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListJobs.html)
//
//    * DescribeJob (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DescribeJob.html)
//
//    * UpdateJobStatus (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_UpdateJobStatus.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation UpdateJobStatus for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
//   * ErrCodeNotFoundException "NotFoundException"
//
//   * ErrCodeJobStatusException "JobStatusException"
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/UpdateJobStatus
func (c *S3Control) UpdateJobStatus(input *UpdateJobStatusInput) (*UpdateJobStatusOutput, error) {
	req, out := c.UpdateJobStatusRequest(input)
	return out, req.Send()
}

// UpdateJobStatusWithContext is the same as UpdateJobStatus with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateJobStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) UpdateJobStatusWithContext(ctx aws.Context, input *UpdateJobStatusInput, opts ...request.Option) (*UpdateJobStatusOutput, error) {
	req, out := c.UpdateJobStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// The container for abort incomplete multipart upload
type AbortIncompleteMultipartUpload struct {
	_ struct{} `type:"structure"`

	// Specifies the number of days after which Amazon S3 aborts an incomplete multipart
	// upload to the Outposts bucket.
	DaysAfterInitiation *int64 `type:"integer"`
}

// String returns the string representation
func (s AbortIncompleteMultipartUpload) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AbortIncompleteMultipartUpload) GoString() string {
	return s.String()
}

// SetDaysAfterInitiation sets the DaysAfterInitiation field's value.
func (s *AbortIncompleteMultipartUpload) SetDaysAfterInitiation(v int64) *AbortIncompleteMultipartUpload {
	s.DaysAfterInitiation = &v
	return s
}

// An access point used to access a bucket.
type AccessPoint struct {
	_ struct{} `type:"structure"`

	// The ARN for the access point.
	AccessPointArn *string `min:"4" type:"string"`

	// The name of the bucket associated with this access point.
	//
	// Bucket is a required field
	Bucket *string `min:"3" type:"string" required:"true"`

	// The name of this access point.
	//
	// Name is a required field
	Name *string `min:"3" type:"string" required:"true"`

	// Indicates whether this access point allows access from the public internet.
	// If VpcConfiguration is specified for this access point, then NetworkOrigin
	// is VPC, and the access point doesn't allow access from the public internet.
	// Otherwise, NetworkOrigin is Internet, and the access point allows access
	// from the public internet, subject to the access point and bucket access policies.
	//
	// NetworkOrigin is a required field
	NetworkOrigin *string `type:"string" required:"true" enum:"NetworkOrigin"`

	// The virtual private cloud (VPC) configuration for this access point, if one
	// exists.
	VpcConfiguration *VpcConfiguration `type:"structure"`
}

// String returns the string representation
func (s AccessPoint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccessPoint) GoString() string {
	return s.String()
}

// SetAccessPointArn sets the AccessPointArn field's value.
func (s *AccessPoint) SetAccessPointArn(v string) *AccessPoint {
	s.AccessPointArn = &v
	return s
}

// SetBucket sets the Bucket field's value.
func (s *AccessPoint) SetBucket(v string) *AccessPoint {
	s.Bucket = &v
	return s
}

// SetName sets the Name field's value.
func (s *AccessPoint) SetName(v string) *AccessPoint {
	s.Name = &v
	return s
}

// SetNetworkOrigin sets the NetworkOrigin field's value.
func (s *AccessPoint) SetNetworkOrigin(v string) *AccessPoint {
	s.NetworkOrigin = &v
	return s
}

// SetVpcConfiguration sets the VpcConfiguration field's value.
func (s *AccessPoint) SetVpcConfiguration(v *VpcConfiguration) *AccessPoint {
	s.VpcConfiguration = v
	return s
}

// A container for the account level Amazon S3 Storage Lens configuration.
type AccountLevel struct {
	_ struct{} `type:"structure"`

	// A container for the S3 Storage Lens activity metrics.
	ActivityMetrics *ActivityMetrics `type:"structure"`

	// A container for the S3 Storage Lens bucket-level configuration.
	//
	// BucketLevel is a required field
	BucketLevel *BucketLevel `type:"structure" required:"true"`
}

// String returns the string representation
func (s AccountLevel) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccountLevel) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AccountLevel) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AccountLevel"}
	if s.BucketLevel == nil {
		invalidParams.Add(request.NewErrParamRequired("BucketLevel"))
	}
	if s.BucketLevel != nil {
		if err := s.BucketLevel.Validate(); err != nil {
			invalidParams.AddNested("BucketLevel", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActivityMetrics sets the ActivityMetrics field's value.
func (s *AccountLevel) SetActivityMetrics(v *ActivityMetrics) *AccountLevel {
	s.ActivityMetrics = v
	return s
}

// SetBucketLevel sets the BucketLevel field's value.
func (s *AccountLevel) SetBucketLevel(v *BucketLevel) *AccountLevel {
	s.BucketLevel = v
	return s
}

// A container for the activity metrics.
type ActivityMetrics struct {
	_ struct{} `type:"structure"`

	// A container for whether the activity metrics are enabled.
	IsEnabled *bool `type:"boolean"`
}

// String returns the string representation
func (s ActivityMetrics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ActivityMetrics) GoString() string {
	return s.String()
}

// SetIsEnabled sets the IsEnabled field's value.
func (s *ActivityMetrics) SetIsEnabled(v bool) *ActivityMetrics {
	s.IsEnabled = &v
	return s
}

// A container for the bucket-level configuration.
type BucketLevel struct {
	_ struct{} `type:"structure"`

	// A container for the bucket-level activity metrics for Amazon S3 Storage Lens
	ActivityMetrics *ActivityMetrics `type:"structure"`

	// A container for the bucket-level prefix-level metrics for S3 Storage Lens
	PrefixLevel *PrefixLevel `type:"structure"`
}

// String returns the string representation
func (s BucketLevel) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BucketLevel) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BucketLevel) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BucketLevel"}
	if s.PrefixLevel != nil {
		if err := s.PrefixLevel.Validate(); err != nil {
			invalidParams.AddNested("PrefixLevel", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActivityMetrics sets the ActivityMetrics field's value.
func (s *BucketLevel) SetActivityMetrics(v *ActivityMetrics) *BucketLevel {
	s.ActivityMetrics = v
	return s
}

// SetPrefixLevel sets the PrefixLevel field's value.
func (s *BucketLevel) SetPrefixLevel(v *PrefixLevel) *BucketLevel {
	s.PrefixLevel = v
	return s
}

type CreateAccessPointInput struct {
	_ struct{} `locationName:"CreateAccessPointRequest" type:"structure" xmlURI:"http://awss3control.amazonaws.com/doc/2018-08-20/"`

	// The AWS account ID for the owner of the bucket for which you want to create
	// an access point.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// The name of the bucket that you want to associate this access point with.
	//
	// For using this parameter with Amazon S3 on Outposts with the REST API, you
	// must specify the name and the x-amz-outpost-id as well.
	//
	// For using this parameter with S3 on Outposts with the AWS SDK and CLI, you
	// must specify the ARN of the bucket accessed in the format arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/bucket/<my-bucket-name>.
	// For example, to access the bucket reports through outpost my-outpost owned
	// by account 123456789012 in Region us-west-2, use the URL encoding of arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports.
	// The value must be URL encoded.
	//
	// Bucket is a required field
	Bucket *string `min:"3" type:"string" required:"true"`

	// The name you want to assign to this access point.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"3" type:"string" required:"true"`

	// The PublicAccessBlock configuration that you want to apply to this Amazon
	// S3 account. You can enable the configuration options in any combination.
	// For more information about when Amazon S3 considers a bucket or object public,
	// see The Meaning of "Public" (https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status)
	// in the Amazon Simple Storage Service Developer Guide.
	//
	// This is not supported for Amazon S3 on Outposts.
	PublicAccessBlockConfiguration *PublicAccessBlockConfiguration `type:"structure"`

	// If you include this field, Amazon S3 restricts access to this access point
	// to requests from the specified virtual private cloud (VPC).
	//
	// This is required for creating an access point for Amazon S3 on Outposts buckets.
	VpcConfiguration *VpcConfiguration `type:"structure"`
}

// String returns the string representation
func (s CreateAccessPointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAccessPointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAccessPointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAccessPointInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 3))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 3))
	}
	if s.VpcConfiguration != nil {
		if err := s.VpcConfiguration.Validate(); err != nil {
			invalidParams.AddNested("VpcConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *CreateAccessPointInput) SetAccountId(v string) *CreateAccessPointInput {
	s.AccountId = &v
	return s
}

// SetBucket sets the Bucket field's value.
func (s *CreateAccessPointInput) SetBucket(v string) *CreateAccessPointInput {
	s.Bucket = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateAccessPointInput) SetName(v string) *CreateAccessPointInput {
	s.Name = &v
	return s
}

// SetPublicAccessBlockConfiguration sets the PublicAccessBlockConfiguration field's value.
func (s *CreateAccessPointInput) SetPublicAccessBlockConfiguration(v *PublicAccessBlockConfiguration) *CreateAccessPointInput {
	s.PublicAccessBlockConfiguration = v
	return s
}

// SetVpcConfiguration sets the VpcConfiguration field's value.
func (s *CreateAccessPointInput) SetVpcConfiguration(v *VpcConfiguration) *CreateAccessPointInput {
	s.VpcConfiguration = v
	return s
}

func (s *CreateAccessPointInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

func (s *CreateAccessPointInput) getEndpointARN() (arn.Resource, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	return parseEndpointARN(*s.Bucket)
}

func (s *CreateAccessPointInput) hasEndpointARN() bool {
	if s.Bucket == nil {
		return false
	}
	return arn.IsARN(*s.Bucket)
}

// updateArnableField updates the value of the input field that
// takes an ARN as an input. This method is useful to backfill
// the parsed resource name from ARN into the input member.
// It returns a pointer to a modified copy of input and an error.
// Note that original input is not modified.
func (s CreateAccessPointInput) updateArnableField(v string) (interface{}, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	s.Bucket = aws.String(v)
	return &s, nil
}

// updateAccountID returns a pointer to a modified copy of input,
// if account id is not provided, we update the account id in modified input
// if account id is provided, but doesn't match with the one in ARN, we throw an error
// if account id is not updated, we return nil. Note that original input is not modified.
func (s CreateAccessPointInput) updateAccountID(accountId string) (interface{}, error) {
	if s.AccountId == nil {
		s.AccountId = aws.String(accountId)
		return &s, nil
	} else if *s.AccountId != accountId {
		return &s, fmt.Errorf("Account ID mismatch, the Account ID cannot be specified in an ARN and in the accountId field")
	}
	return nil, nil
}

type CreateAccessPointOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the access point.
	//
	// This is only supported by Amazon S3 on Outposts.
	AccessPointArn *string `min:"4" type:"string"`
}

// String returns the string representation
func (s CreateAccessPointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAccessPointOutput) GoString() string {
	return s.String()
}

// SetAccessPointArn sets the AccessPointArn field's value.
func (s *CreateAccessPointOutput) SetAccessPointArn(v string) *CreateAccessPointOutput {
	s.AccessPointArn = &v
	return s
}

// The container for the bucket configuration.
//
// This is not supported by Amazon S3 on Outposts buckets.
type CreateBucketConfiguration struct {
	_ struct{} `type:"structure"`

	// Specifies the Region where the bucket will be created. If you are creating
	// a bucket on the US East (N. Virginia) Region (us-east-1), you do not need
	// to specify the location.
	//
	// This is not supported by Amazon S3 on Outposts buckets.
	LocationConstraint *string `type:"string" enum:"BucketLocationConstraint"`
}

// String returns the string representation
func (s CreateBucketConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateBucketConfiguration) GoString() string {
	return s.String()
}

// SetLocationConstraint sets the LocationConstraint field's value.
func (s *CreateBucketConfiguration) SetLocationConstraint(v string) *CreateBucketConfiguration {
	s.LocationConstraint = &v
	return s
}

type CreateBucketInput struct {
	_ struct{} `locationName:"CreateBucketRequest" type:"structure" payload:"CreateBucketConfiguration"`

	// The canned ACL to apply to the bucket.
	//
	// This is not supported by Amazon S3 on Outposts buckets.
	ACL *string `location:"header" locationName:"x-amz-acl" type:"string" enum:"BucketCannedACL"`

	// The name of the bucket.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"name" min:"3" type:"string" required:"true"`

	// The configuration information for the bucket.
	//
	// This is not supported by Amazon S3 on Outposts buckets.
	CreateBucketConfiguration *CreateBucketConfiguration `locationName:"CreateBucketConfiguration" type:"structure" xmlURI:"http://awss3control.amazonaws.com/doc/2018-08-20/"`

	// Allows grantee the read, write, read ACP, and write ACP permissions on the
	// bucket.
	//
	// This is not supported by Amazon S3 on Outposts buckets.
	GrantFullControl *string `location:"header" locationName:"x-amz-grant-full-control" type:"string"`

	// Allows grantee to list the objects in the bucket.
	//
	// This is not supported by Amazon S3 on Outposts buckets.
	GrantRead *string `location:"header" locationName:"x-amz-grant-read" type:"string"`

	// Allows grantee to read the bucket ACL.
	//
	// This is not supported by Amazon S3 on Outposts buckets.
	GrantReadACP *string `location:"header" locationName:"x-amz-grant-read-acp" type:"string"`

	// Allows grantee to create, overwrite, and delete any object in the bucket.
	//
	// This is not supported by Amazon S3 on Outposts buckets.
	GrantWrite *string `location:"header" locationName:"x-amz-grant-write" type:"string"`

	// Allows grantee to write the ACL for the applicable bucket.
	//
	// This is not supported by Amazon S3 on Outposts buckets.
	GrantWriteACP *string `location:"header" locationName:"x-amz-grant-write-acp" type:"string"`

	// Specifies whether you want S3 Object Lock to be enabled for the new bucket.
	//
	// This is not supported by Amazon S3 on Outposts buckets.
	ObjectLockEnabledForBucket *bool `location:"header" locationName:"x-amz-bucket-object-lock-enabled" type:"boolean"`

	// The ID of the Outposts where the bucket is being created.
	//
	// This is required by Amazon S3 on Outposts buckets.
	OutpostId *string `location:"header" locationName:"x-amz-outpost-id" min:"1" type:"string"`
}

// String returns the string representation
func (s CreateBucketInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateBucketInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateBucketInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateBucketInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 3))
	}
	if s.OutpostId != nil && len(*s.OutpostId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OutpostId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetACL sets the ACL field's value.
func (s *CreateBucketInput) SetACL(v string) *CreateBucketInput {
	s.ACL = &v
	return s
}

// SetBucket sets the Bucket field's value.
func (s *CreateBucketInput) SetBucket(v string) *CreateBucketInput {
	s.Bucket = &v
	return s
}

// SetCreateBucketConfiguration sets the CreateBucketConfiguration field's value.
func (s *CreateBucketInput) SetCreateBucketConfiguration(v *CreateBucketConfiguration) *CreateBucketInput {
	s.CreateBucketConfiguration = v
	return s
}

// SetGrantFullControl sets the GrantFullControl field's value.
func (s *CreateBucketInput) SetGrantFullControl(v string) *CreateBucketInput {
	s.GrantFullControl = &v
	return s
}

// SetGrantRead sets the GrantRead field's value.
func (s *CreateBucketInput) SetGrantRead(v string) *CreateBucketInput {
	s.GrantRead = &v
	return s
}

// SetGrantReadACP sets the GrantReadACP field's value.
func (s *CreateBucketInput) SetGrantReadACP(v string) *CreateBucketInput {
	s.GrantReadACP = &v
	return s
}

// SetGrantWrite sets the GrantWrite field's value.
func (s *CreateBucketInput) SetGrantWrite(v string) *CreateBucketInput {
	s.GrantWrite = &v
	return s
}

// SetGrantWriteACP sets the GrantWriteACP field's value.
func (s *CreateBucketInput) SetGrantWriteACP(v string) *CreateBucketInput {
	s.GrantWriteACP = &v
	return s
}

// SetObjectLockEnabledForBucket sets the ObjectLockEnabledForBucket field's value.
func (s *CreateBucketInput) SetObjectLockEnabledForBucket(v bool) *CreateBucketInput {
	s.ObjectLockEnabledForBucket = &v
	return s
}

// SetOutpostId sets the OutpostId field's value.
func (s *CreateBucketInput) SetOutpostId(v string) *CreateBucketInput {
	s.OutpostId = &v
	return s
}

func (s *CreateBucketInput) getOutpostID() (string, error) {
	if s.OutpostId == nil {
		return "", fmt.Errorf("member OutpostId is nil")
	}
	return *s.OutpostId, nil
}

func (s *CreateBucketInput) hasOutpostID() bool {
	if s.OutpostId == nil {
		return false
	}
	return true
}

type CreateBucketOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the bucket.
	//
	// For using this parameter with Amazon S3 on Outposts with the REST API, you
	// must specify the name and the x-amz-outpost-id as well.
	//
	// For using this parameter with S3 on Outposts with the AWS SDK and CLI, you
	// must specify the ARN of the bucket accessed in the format arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/bucket/<my-bucket-name>.
	// For example, to access the bucket reports through outpost my-outpost owned
	// by account 123456789012 in Region us-west-2, use the URL encoding of arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports.
	// The value must be URL encoded.
	BucketArn *string `min:"4" type:"string"`

	// The location of the bucket.
	Location *string `location:"header" locationName:"Location" type:"string"`
}

// String returns the string representation
func (s CreateBucketOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateBucketOutput) GoString() string {
	return s.String()
}

// SetBucketArn sets the BucketArn field's value.
func (s *CreateBucketOutput) SetBucketArn(v string) *CreateBucketOutput {
	s.BucketArn = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *CreateBucketOutput) SetLocation(v string) *CreateBucketOutput {
	s.Location = &v
	return s
}

type CreateJobInput struct {
	_ struct{} `locationName:"CreateJobRequest" type:"structure" xmlURI:"http://awss3control.amazonaws.com/doc/2018-08-20/"`

	// The AWS account ID that creates the job.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// An idempotency token to ensure that you don't accidentally submit the same
	// request twice. You can use any string up to the maximum length.
	ClientRequestToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// Indicates whether confirmation is required before Amazon S3 runs the job.
	// Confirmation is only required for jobs created through the Amazon S3 console.
	ConfirmationRequired *bool `type:"boolean"`

	// A description for this job. You can use any string within the permitted length.
	// Descriptions don't need to be unique and can be used for multiple jobs.
	Description *string `min:"1" type:"string"`

	// Configuration parameters for the manifest.
	//
	// Manifest is a required field
	Manifest *JobManifest `type:"structure" required:"true"`

	// The operation that you want this job to perform on every object listed in
	// the manifest. For more information about the available operations, see Operations
	// (https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-operations.html)
	// in the Amazon Simple Storage Service Developer Guide.
	//
	// Operation is a required field
	Operation *JobOperation `type:"structure" required:"true"`

	// The numerical priority for this job. Higher numbers indicate higher priority.
	//
	// Priority is a required field
	Priority *int64 `type:"integer" required:"true"`

	// Configuration parameters for the optional job-completion report.
	//
	// Report is a required field
	Report *JobReport `type:"structure" required:"true"`

	// The Amazon Resource Name (ARN) for the AWS Identity and Access Management
	// (IAM) role that Batch Operations will use to run this job's operation on
	// every object in the manifest.
	//
	// RoleArn is a required field
	RoleArn *string `min:"1" type:"string" required:"true"`

	// A set of tags to associate with the S3 Batch Operations job. This is an optional
	// parameter.
	Tags []*S3Tag `type:"list"`
}

// String returns the string representation
func (s CreateJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateJobInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Manifest == nil {
		invalidParams.Add(request.NewErrParamRequired("Manifest"))
	}
	if s.Operation == nil {
		invalidParams.Add(request.NewErrParamRequired("Operation"))
	}
	if s.Priority == nil {
		invalidParams.Add(request.NewErrParamRequired("Priority"))
	}
	if s.Report == nil {
		invalidParams.Add(request.NewErrParamRequired("Report"))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 1))
	}
	if s.Manifest != nil {
		if err := s.Manifest.Validate(); err != nil {
			invalidParams.AddNested("Manifest", err.(request.ErrInvalidParams))
		}
	}
	if s.Operation != nil {
		if err := s.Operation.Validate(); err != nil {
			invalidParams.AddNested("Operation", err.(request.ErrInvalidParams))
		}
	}
	if s.Report != nil {
		if err := s.Report.Validate(); err != nil {
			invalidParams.AddNested("Report", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *CreateJobInput) SetAccountId(v string) *CreateJobInput {
	s.AccountId = &v
	return s
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateJobInput) SetClientRequestToken(v string) *CreateJobInput {
	s.ClientRequestToken = &v
	return s
}

// SetConfirmationRequired sets the ConfirmationRequired field's value.
func (s *CreateJobInput) SetConfirmationRequired(v bool) *CreateJobInput {
	s.ConfirmationRequired = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateJobInput) SetDescription(v string) *CreateJobInput {
	s.Description = &v
	return s
}

// SetManifest sets the Manifest field's value.
func (s *CreateJobInput) SetManifest(v *JobManifest) *CreateJobInput {
	s.Manifest = v
	return s
}

// SetOperation sets the Operation field's value.
func (s *CreateJobInput) SetOperation(v *JobOperation) *CreateJobInput {
	s.Operation = v
	return s
}

// SetPriority sets the Priority field's value.
func (s *CreateJobInput) SetPriority(v int64) *CreateJobInput {
	s.Priority = &v
	return s
}

// SetReport sets the Report field's value.
func (s *CreateJobInput) SetReport(v *JobReport) *CreateJobInput {
	s.Report = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreateJobInput) SetRoleArn(v string) *CreateJobInput {
	s.RoleArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateJobInput) SetTags(v []*S3Tag) *CreateJobInput {
	s.Tags = v
	return s
}

func (s *CreateJobInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

type CreateJobOutput struct {
	_ struct{} `type:"structure"`

	// The ID for this job. Amazon S3 generates this ID automatically and returns
	// it after a successful Create Job request.
	JobId *string `min:"5" type:"string"`
}

// String returns the string representation
func (s CreateJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateJobOutput) GoString() string {
	return s.String()
}

// SetJobId sets the JobId field's value.
func (s *CreateJobOutput) SetJobId(v string) *CreateJobOutput {
	s.JobId = &v
	return s
}

type DeleteAccessPointInput struct {
	_ struct{} `locationName:"DeleteAccessPointRequest" type:"structure"`

	// The account ID for the account that owns the specified access point.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// The name of the access point you want to delete.
	//
	// For using this parameter with Amazon S3 on Outposts with the REST API, you
	// must specify the name and the x-amz-outpost-id as well.
	//
	// For using this parameter with S3 on Outposts with the AWS SDK and CLI, you
	// must specify the ARN of the access point accessed in the format arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/accesspoint/<my-accesspoint-name>.
	// For example, to access the access point reports-ap through outpost my-outpost
	// owned by account 123456789012 in Region us-west-2, use the URL encoding of
	// arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/accesspoint/reports-ap.
	// The value must be URL encoded.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteAccessPointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAccessPointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAccessPointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAccessPointInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *DeleteAccessPointInput) SetAccountId(v string) *DeleteAccessPointInput {
	s.AccountId = &v
	return s
}

// SetName sets the Name field's value.
func (s *DeleteAccessPointInput) SetName(v string) *DeleteAccessPointInput {
	s.Name = &v
	return s
}

func (s *DeleteAccessPointInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

func (s *DeleteAccessPointInput) getEndpointARN() (arn.Resource, error) {
	if s.Name == nil {
		return nil, fmt.Errorf("member Name is nil")
	}
	return parseEndpointARN(*s.Name)
}

func (s *DeleteAccessPointInput) hasEndpointARN() bool {
	if s.Name == nil {
		return false
	}
	return arn.IsARN(*s.Name)
}

// updateArnableField updates the value of the input field that
// takes an ARN as an input. This method is useful to backfill
// the parsed resource name from ARN into the input member.
// It returns a pointer to a modified copy of input and an error.
// Note that original input is not modified.
func (s DeleteAccessPointInput) updateArnableField(v string) (interface{}, error) {
	if s.Name == nil {
		return nil, fmt.Errorf("member Name is nil")
	}
	s.Name = aws.String(v)
	return &s, nil
}

// updateAccountID returns a pointer to a modified copy of input,
// if account id is not provided, we update the account id in modified input
// if account id is provided, but doesn't match with the one in ARN, we throw an error
// if account id is not updated, we return nil. Note that original input is not modified.
func (s DeleteAccessPointInput) updateAccountID(accountId string) (interface{}, error) {
	if s.AccountId == nil {
		s.AccountId = aws.String(accountId)
		return &s, nil
	} else if *s.AccountId != accountId {
		return &s, fmt.Errorf("Account ID mismatch, the Account ID cannot be specified in an ARN and in the accountId field")
	}
	return nil, nil
}

type DeleteAccessPointOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteAccessPointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAccessPointOutput) GoString() string {
	return s.String()
}

type DeleteAccessPointPolicyInput struct {
	_ struct{} `locationName:"DeleteAccessPointPolicyRequest" type:"structure"`

	// The account ID for the account that owns the specified access point.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// The name of the access point whose policy you want to delete.
	//
	// For using this parameter with Amazon S3 on Outposts with the REST API, you
	// must specify the name and the x-amz-outpost-id as well.
	//
	// For using this parameter with S3 on Outposts with the AWS SDK and CLI, you
	// must specify the ARN of the access point accessed in the format arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/accesspoint/<my-accesspoint-name>.
	// For example, to access the access point reports-ap through outpost my-outpost
	// owned by account 123456789012 in Region us-west-2, use the URL encoding of
	// arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/accesspoint/reports-ap.
	// The value must be URL encoded.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteAccessPointPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAccessPointPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAccessPointPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAccessPointPolicyInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *DeleteAccessPointPolicyInput) SetAccountId(v string) *DeleteAccessPointPolicyInput {
	s.AccountId = &v
	return s
}

// SetName sets the Name field's value.
func (s *DeleteAccessPointPolicyInput) SetName(v string) *DeleteAccessPointPolicyInput {
	s.Name = &v
	return s
}

func (s *DeleteAccessPointPolicyInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

func (s *DeleteAccessPointPolicyInput) getEndpointARN() (arn.Resource, error) {
	if s.Name == nil {
		return nil, fmt.Errorf("member Name is nil")
	}
	return parseEndpointARN(*s.Name)
}

func (s *DeleteAccessPointPolicyInput) hasEndpointARN() bool {
	if s.Name == nil {
		return false
	}
	return arn.IsARN(*s.Name)
}

// updateArnableField updates the value of the input field that
// takes an ARN as an input. This method is useful to backfill
// the parsed resource name from ARN into the input member.
// It returns a pointer to a modified copy of input and an error.
// Note that original input is not modified.
func (s DeleteAccessPointPolicyInput) updateArnableField(v string) (interface{}, error) {
	if s.Name == nil {
		return nil, fmt.Errorf("member Name is nil")
	}
	s.Name = aws.String(v)
	return &s, nil
}

// updateAccountID returns a pointer to a modified copy of input,
// if account id is not provided, we update the account id in modified input
// if account id is provided, but doesn't match with the one in ARN, we throw an error
// if account id is not updated, we return nil. Note that original input is not modified.
func (s DeleteAccessPointPolicyInput) updateAccountID(accountId string) (interface{}, error) {
	if s.AccountId == nil {
		s.AccountId = aws.String(accountId)
		return &s, nil
	} else if *s.AccountId != accountId {
		return &s, fmt.Errorf("Account ID mismatch, the Account ID cannot be specified in an ARN and in the accountId field")
	}
	return nil, nil
}

type DeleteAccessPointPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteAccessPointPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAccessPointPolicyOutput) GoString() string {
	return s.String()
}

type DeleteBucketInput struct {
	_ struct{} `locationName:"DeleteBucketRequest" type:"structure"`

	// The account ID that owns the Outposts bucket.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// Specifies the bucket being deleted.
	//
	// For using this parameter with Amazon S3 on Outposts with the REST API, you
	// must specify the name and the x-amz-outpost-id as well.
	//
	// For using this parameter with S3 on Outposts with the AWS SDK and CLI, you
	// must specify the ARN of the bucket accessed in the format arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/bucket/<my-bucket-name>.
	// For example, to access the bucket reports through outpost my-outpost owned
	// by account 123456789012 in Region us-west-2, use the URL encoding of arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports.
	// The value must be URL encoded.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"name" min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteBucketInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBucketInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBucketInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteBucketInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *DeleteBucketInput) SetAccountId(v string) *DeleteBucketInput {
	s.AccountId = &v
	return s
}

// SetBucket sets the Bucket field's value.
func (s *DeleteBucketInput) SetBucket(v string) *DeleteBucketInput {
	s.Bucket = &v
	return s
}

func (s *DeleteBucketInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

func (s *DeleteBucketInput) getEndpointARN() (arn.Resource, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	return parseEndpointARN(*s.Bucket)
}

func (s *DeleteBucketInput) hasEndpointARN() bool {
	if s.Bucket == nil {
		return false
	}
	return arn.IsARN(*s.Bucket)
}

// updateArnableField updates the value of the input field that
// takes an ARN as an input. This method is useful to backfill
// the parsed resource name from ARN into the input member.
// It returns a pointer to a modified copy of input and an error.
// Note that original input is not modified.
func (s DeleteBucketInput) updateArnableField(v string) (interface{}, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	s.Bucket = aws.String(v)
	return &s, nil
}

// updateAccountID returns a pointer to a modified copy of input,
// if account id is not provided, we update the account id in modified input
// if account id is provided, but doesn't match with the one in ARN, we throw an error
// if account id is not updated, we return nil. Note that original input is not modified.
func (s DeleteBucketInput) updateAccountID(accountId string) (interface{}, error) {
	if s.AccountId == nil {
		s.AccountId = aws.String(accountId)
		return &s, nil
	} else if *s.AccountId != accountId {
		return &s, fmt.Errorf("Account ID mismatch, the Account ID cannot be specified in an ARN and in the accountId field")
	}
	return nil, nil
}

type DeleteBucketLifecycleConfigurationInput struct {
	_ struct{} `locationName:"DeleteBucketLifecycleConfigurationRequest" type:"structure"`

	// The account ID of the lifecycle configuration to delete.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// Specifies the bucket.
	//
	// For using this parameter with Amazon S3 on Outposts with the REST API, you
	// must specify the name and the x-amz-outpost-id as well.
	//
	// For using this parameter with S3 on Outposts with the AWS SDK and CLI, you
	// must specify the ARN of the bucket accessed in the format arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/bucket/<my-bucket-name>.
	// For example, to access the bucket reports through outpost my-outpost owned
	// by account 123456789012 in Region us-west-2, use the URL encoding of arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports.
	// The value must be URL encoded.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"name" min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteBucketLifecycleConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBucketLifecycleConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBucketLifecycleConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteBucketLifecycleConfigurationInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *DeleteBucketLifecycleConfigurationInput) SetAccountId(v string) *DeleteBucketLifecycleConfigurationInput {
	s.AccountId = &v
	return s
}

// SetBucket sets the Bucket field's value.
func (s *DeleteBucketLifecycleConfigurationInput) SetBucket(v string) *DeleteBucketLifecycleConfigurationInput {
	s.Bucket = &v
	return s
}

func (s *DeleteBucketLifecycleConfigurationInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

func (s *DeleteBucketLifecycleConfigurationInput) getEndpointARN() (arn.Resource, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	return parseEndpointARN(*s.Bucket)
}

func (s *DeleteBucketLifecycleConfigurationInput) hasEndpointARN() bool {
	if s.Bucket == nil {
		return false
	}
	return arn.IsARN(*s.Bucket)
}

// updateArnableField updates the value of the input field that
// takes an ARN as an input. This method is useful to backfill
// the parsed resource name from ARN into the input member.
// It returns a pointer to a modified copy of input and an error.
// Note that original input is not modified.
func (s DeleteBucketLifecycleConfigurationInput) updateArnableField(v string) (interface{}, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	s.Bucket = aws.String(v)
	return &s, nil
}

// updateAccountID returns a pointer to a modified copy of input,
// if account id is not provided, we update the account id in modified input
// if account id is provided, but doesn't match with the one in ARN, we throw an error
// if account id is not updated, we return nil. Note that original input is not modified.
func (s DeleteBucketLifecycleConfigurationInput) updateAccountID(accountId string) (interface{}, error) {
	if s.AccountId == nil {
		s.AccountId = aws.String(accountId)
		return &s, nil
	} else if *s.AccountId != accountId {
		return &s, fmt.Errorf("Account ID mismatch, the Account ID cannot be specified in an ARN and in the accountId field")
	}
	return nil, nil
}

type DeleteBucketLifecycleConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteBucketLifecycleConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBucketLifecycleConfigurationOutput) GoString() string {
	return s.String()
}

type DeleteBucketOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteBucketOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBucketOutput) GoString() string {
	return s.String()
}

type DeleteBucketPolicyInput struct {
	_ struct{} `locationName:"DeleteBucketPolicyRequest" type:"structure"`

	// The account ID of the Outposts bucket.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// Specifies the bucket.
	//
	// For using this parameter with Amazon S3 on Outposts with the REST API, you
	// must specify the name and the x-amz-outpost-id as well.
	//
	// For using this parameter with S3 on Outposts with the AWS SDK and CLI, you
	// must specify the ARN of the bucket accessed in the format arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/bucket/<my-bucket-name>.
	// For example, to access the bucket reports through outpost my-outpost owned
	// by account 123456789012 in Region us-west-2, use the URL encoding of arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports.
	// The value must be URL encoded.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"name" min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteBucketPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBucketPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBucketPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteBucketPolicyInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *DeleteBucketPolicyInput) SetAccountId(v string) *DeleteBucketPolicyInput {
	s.AccountId = &v
	return s
}

// SetBucket sets the Bucket field's value.
func (s *DeleteBucketPolicyInput) SetBucket(v string) *DeleteBucketPolicyInput {
	s.Bucket = &v
	return s
}

func (s *DeleteBucketPolicyInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

func (s *DeleteBucketPolicyInput) getEndpointARN() (arn.Resource, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	return parseEndpointARN(*s.Bucket)
}

func (s *DeleteBucketPolicyInput) hasEndpointARN() bool {
	if s.Bucket == nil {
		return false
	}
	return arn.IsARN(*s.Bucket)
}

// updateArnableField updates the value of the input field that
// takes an ARN as an input. This method is useful to backfill
// the parsed resource name from ARN into the input member.
// It returns a pointer to a modified copy of input and an error.
// Note that original input is not modified.
func (s DeleteBucketPolicyInput) updateArnableField(v string) (interface{}, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	s.Bucket = aws.String(v)
	return &s, nil
}

// updateAccountID returns a pointer to a modified copy of input,
// if account id is not provided, we update the account id in modified input
// if account id is provided, but doesn't match with the one in ARN, we throw an error
// if account id is not updated, we return nil. Note that original input is not modified.
func (s DeleteBucketPolicyInput) updateAccountID(accountId string) (interface{}, error) {
	if s.AccountId == nil {
		s.AccountId = aws.String(accountId)
		return &s, nil
	} else if *s.AccountId != accountId {
		return &s, fmt.Errorf("Account ID mismatch, the Account ID cannot be specified in an ARN and in the accountId field")
	}
	return nil, nil
}

type DeleteBucketPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteBucketPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBucketPolicyOutput) GoString() string {
	return s.String()
}

type DeleteBucketTaggingInput struct {
	_ struct{} `locationName:"DeleteBucketTaggingRequest" type:"structure"`

	// The AWS account ID of the Outposts bucket tag set to be removed.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// The bucket ARN that has the tag set to be removed.
	//
	// For using this parameter with Amazon S3 on Outposts with the REST API, you
	// must specify the name and the x-amz-outpost-id as well.
	//
	// For using this parameter with S3 on Outposts with the AWS SDK and CLI, you
	// must specify the ARN of the bucket accessed in the format arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/bucket/<my-bucket-name>.
	// For example, to access the bucket reports through outpost my-outpost owned
	// by account 123456789012 in Region us-west-2, use the URL encoding of arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports.
	// The value must be URL encoded.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"name" min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteBucketTaggingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBucketTaggingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBucketTaggingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteBucketTaggingInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *DeleteBucketTaggingInput) SetAccountId(v string) *DeleteBucketTaggingInput {
	s.AccountId = &v
	return s
}

// SetBucket sets the Bucket field's value.
func (s *DeleteBucketTaggingInput) SetBucket(v string) *DeleteBucketTaggingInput {
	s.Bucket = &v
	return s
}

func (s *DeleteBucketTaggingInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

func (s *DeleteBucketTaggingInput) getEndpointARN() (arn.Resource, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	return parseEndpointARN(*s.Bucket)
}

func (s *DeleteBucketTaggingInput) hasEndpointARN() bool {
	if s.Bucket == nil {
		return false
	}
	return arn.IsARN(*s.Bucket)
}

// updateArnableField updates the value of the input field that
// takes an ARN as an input. This method is useful to backfill
// the parsed resource name from ARN into the input member.
// It returns a pointer to a modified copy of input and an error.
// Note that original input is not modified.
func (s DeleteBucketTaggingInput) updateArnableField(v string) (interface{}, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	s.Bucket = aws.String(v)
	return &s, nil
}

// updateAccountID returns a pointer to a modified copy of input,
// if account id is not provided, we update the account id in modified input
// if account id is provided, but doesn't match with the one in ARN, we throw an error
// if account id is not updated, we return nil. Note that original input is not modified.
func (s DeleteBucketTaggingInput) updateAccountID(accountId string) (interface{}, error) {
	if s.AccountId == nil {
		s.AccountId = aws.String(accountId)
		return &s, nil
	} else if *s.AccountId != accountId {
		return &s, fmt.Errorf("Account ID mismatch, the Account ID cannot be specified in an ARN and in the accountId field")
	}
	return nil, nil
}

type DeleteBucketTaggingOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteBucketTaggingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBucketTaggingOutput) GoString() string {
	return s.String()
}

type DeleteJobTaggingInput struct {
	_ struct{} `locationName:"DeleteJobTaggingRequest" type:"structure"`

	// The AWS account ID associated with the S3 Batch Operations job.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// The ID for the S3 Batch Operations job whose tags you want to delete.
	//
	// JobId is a required field
	JobId *string `location:"uri" locationName:"id" min:"5" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteJobTaggingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteJobTaggingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteJobTaggingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteJobTaggingInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *DeleteJobTaggingInput) SetAccountId(v string) *DeleteJobTaggingInput {
	s.AccountId = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *DeleteJobTaggingInput) SetJobId(v string) *DeleteJobTaggingInput {
	s.JobId = &v
	return s
}

func (s *DeleteJobTaggingInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

type DeleteJobTaggingOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteJobTaggingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteJobTaggingOutput) GoString() string {
	return s.String()
}

type DeletePublicAccessBlockInput struct {
	_ struct{} `locationName:"DeletePublicAccessBlockRequest" type:"structure"`

	// The account ID for the AWS account whose PublicAccessBlock configuration
	// you want to remove.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeletePublicAccessBlockInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletePublicAccessBlockInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePublicAccessBlockInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeletePublicAccessBlockInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *DeletePublicAccessBlockInput) SetAccountId(v string) *DeletePublicAccessBlockInput {
	s.AccountId = &v
	return s
}

func (s *DeletePublicAccessBlockInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

type DeletePublicAccessBlockOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeletePublicAccessBlockOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletePublicAccessBlockOutput) GoString() string {
	return s.String()
}

type DeleteStorageLensConfigurationInput struct {
	_ struct{} `locationName:"DeleteStorageLensConfigurationRequest" type:"structure"`

	// The account ID of the requester.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// The ID of the S3 Storage Lens configuration.
	//
	// ConfigId is a required field
	ConfigId *string `location:"uri" locationName:"storagelensid" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteStorageLensConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteStorageLensConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteStorageLensConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteStorageLensConfigurationInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.ConfigId == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigId"))
	}
	if s.ConfigId != nil && len(*s.ConfigId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *DeleteStorageLensConfigurationInput) SetAccountId(v string) *DeleteStorageLensConfigurationInput {
	s.AccountId = &v
	return s
}

// SetConfigId sets the ConfigId field's value.
func (s *DeleteStorageLensConfigurationInput) SetConfigId(v string) *DeleteStorageLensConfigurationInput {
	s.ConfigId = &v
	return s
}

func (s *DeleteStorageLensConfigurationInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

type DeleteStorageLensConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteStorageLensConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteStorageLensConfigurationOutput) GoString() string {
	return s.String()
}

type DeleteStorageLensConfigurationTaggingInput struct {
	_ struct{} `locationName:"DeleteStorageLensConfigurationTaggingRequest" type:"structure"`

	// The account ID of the requester.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// The ID of the S3 Storage Lens configuration.
	//
	// ConfigId is a required field
	ConfigId *string `location:"uri" locationName:"storagelensid" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteStorageLensConfigurationTaggingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteStorageLensConfigurationTaggingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteStorageLensConfigurationTaggingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteStorageLensConfigurationTaggingInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.ConfigId == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigId"))
	}
	if s.ConfigId != nil && len(*s.ConfigId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *DeleteStorageLensConfigurationTaggingInput) SetAccountId(v string) *DeleteStorageLensConfigurationTaggingInput {
	s.AccountId = &v
	return s
}

// SetConfigId sets the ConfigId field's value.
func (s *DeleteStorageLensConfigurationTaggingInput) SetConfigId(v string) *DeleteStorageLensConfigurationTaggingInput {
	s.ConfigId = &v
	return s
}

func (s *DeleteStorageLensConfigurationTaggingInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

type DeleteStorageLensConfigurationTaggingOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteStorageLensConfigurationTaggingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteStorageLensConfigurationTaggingOutput) GoString() string {
	return s.String()
}

type DescribeJobInput struct {
	_ struct{} `locationName:"DescribeJobRequest" type:"structure"`

	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// The ID for the job whose information you want to retrieve.
	//
	// JobId is a required field
	JobId *string `location:"uri" locationName:"id" min:"5" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeJobInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *DescribeJobInput) SetAccountId(v string) *DescribeJobInput {
	s.AccountId = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *DescribeJobInput) SetJobId(v string) *DescribeJobInput {
	s.JobId = &v
	return s
}

func (s *DescribeJobInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

type DescribeJobOutput struct {
	_ struct{} `type:"structure"`

	// Contains the configuration parameters and status for the job specified in
	// the Describe Job request.
	Job *JobDescriptor `type:"structure"`
}

// String returns the string representation
func (s DescribeJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeJobOutput) GoString() string {
	return s.String()
}

// SetJob sets the Job field's value.
func (s *DescribeJobOutput) SetJob(v *JobDescriptor) *DescribeJobOutput {
	s.Job = v
	return s
}

// A container for what Amazon S3 Storage Lens will exclude.
type Exclude struct {
	_ struct{} `type:"structure"`

	// A container for the S3 Storage Lens bucket excludes.
	Buckets []*string `locationNameList:"Arn" type:"list"`

	// A container for the S3 Storage Lens Region excludes.
	Regions []*string `locationNameList:"Region" type:"list"`
}

// String returns the string representation
func (s Exclude) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Exclude) GoString() string {
	return s.String()
}

// SetBuckets sets the Buckets field's value.
func (s *Exclude) SetBuckets(v []*string) *Exclude {
	s.Buckets = v
	return s
}

// SetRegions sets the Regions field's value.
func (s *Exclude) SetRegions(v []*string) *Exclude {
	s.Regions = v
	return s
}

type GetAccessPointInput struct {
	_ struct{} `locationName:"GetAccessPointRequest" type:"structure"`

	// The account ID for the account that owns the specified access point.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// The name of the access point whose configuration information you want to
	// retrieve.
	//
	// For using this parameter with Amazon S3 on Outposts with the REST API, you
	// must specify the name and the x-amz-outpost-id as well.
	//
	// For using this parameter with S3 on Outposts with the AWS SDK and CLI, you
	// must specify the ARN of the access point accessed in the format arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/accesspoint/<my-accesspoint-name>.
	// For example, to access the access point reports-ap through outpost my-outpost
	// owned by account 123456789012 in Region us-west-2, use the URL encoding of
	// arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/accesspoint/reports-ap.
	// The value must be URL encoded.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s GetAccessPointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAccessPointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAccessPointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAccessPointInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *GetAccessPointInput) SetAccountId(v string) *GetAccessPointInput {
	s.AccountId = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetAccessPointInput) SetName(v string) *GetAccessPointInput {
	s.Name = &v
	return s
}

func (s *GetAccessPointInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

func (s *GetAccessPointInput) getEndpointARN() (arn.Resource, error) {
	if s.Name == nil {
		return nil, fmt.Errorf("member Name is nil")
	}
	return parseEndpointARN(*s.Name)
}

func (s *GetAccessPointInput) hasEndpointARN() bool {
	if s.Name == nil {
		return false
	}
	return arn.IsARN(*s.Name)
}

// updateArnableField updates the value of the input field that
// takes an ARN as an input. This method is useful to backfill
// the parsed resource name from ARN into the input member.
// It returns a pointer to a modified copy of input and an error.
// Note that original input is not modified.
func (s GetAccessPointInput) updateArnableField(v string) (interface{}, error) {
	if s.Name == nil {
		return nil, fmt.Errorf("member Name is nil")
	}
	s.Name = aws.String(v)
	return &s, nil
}

// updateAccountID returns a pointer to a modified copy of input,
// if account id is not provided, we update the account id in modified input
// if account id is provided, but doesn't match with the one in ARN, we throw an error
// if account id is not updated, we return nil. Note that original input is not modified.
func (s GetAccessPointInput) updateAccountID(accountId string) (interface{}, error) {
	if s.AccountId == nil {
		s.AccountId = aws.String(accountId)
		return &s, nil
	} else if *s.AccountId != accountId {
		return &s, fmt.Errorf("Account ID mismatch, the Account ID cannot be specified in an ARN and in the accountId field")
	}
	return nil, nil
}

type GetAccessPointOutput struct {
	_ struct{} `type:"structure"`

	// The name of the bucket associated with the specified access point.
	Bucket *string `min:"3" type:"string"`

	// The date and time when the specified access point was created.
	CreationDate *time.Time `type:"timestamp"`

	// The name of the specified access point.
	Name *string `min:"3" type:"string"`

	// Indicates whether this access point allows access from the public internet.
	// If VpcConfiguration is specified for this access point, then NetworkOrigin
	// is VPC, and the access point doesn't allow access from the public internet.
	// Otherwise, NetworkOrigin is Internet, and the access point allows access
	// from the public internet, subject to the access point and bucket access policies.
	//
	// This will always be true for an Amazon S3 on Outposts access point
	NetworkOrigin *string `type:"string" enum:"NetworkOrigin"`

	// The PublicAccessBlock configuration that you want to apply to this Amazon
	// S3 account. You can enable the configuration options in any combination.
	// For more information about when Amazon S3 considers a bucket or object public,
	// see The Meaning of "Public" (https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status)
	// in the Amazon Simple Storage Service Developer Guide.
	//
	// This is not supported for Amazon S3 on Outposts.
	PublicAccessBlockConfiguration *PublicAccessBlockConfiguration `type:"structure"`

	// Contains the virtual private cloud (VPC) configuration for the specified
	// access point.
	VpcConfiguration *VpcConfiguration `type:"structure"`
}

// String returns the string representation
func (s GetAccessPointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAccessPointOutput) GoString() string {
	return s.String()
}

// SetBucket sets the Bucket field's value.
func (s *GetAccessPointOutput) SetBucket(v string) *GetAccessPointOutput {
	s.Bucket = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *GetAccessPointOutput) SetCreationDate(v time.Time) *GetAccessPointOutput {
	s.CreationDate = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetAccessPointOutput) SetName(v string) *GetAccessPointOutput {
	s.Name = &v
	return s
}

// SetNetworkOrigin sets the NetworkOrigin field's value.
func (s *GetAccessPointOutput) SetNetworkOrigin(v string) *GetAccessPointOutput {
	s.NetworkOrigin = &v
	return s
}

// SetPublicAccessBlockConfiguration sets the PublicAccessBlockConfiguration field's value.
func (s *GetAccessPointOutput) SetPublicAccessBlockConfiguration(v *PublicAccessBlockConfiguration) *GetAccessPointOutput {
	s.PublicAccessBlockConfiguration = v
	return s
}

// SetVpcConfiguration sets the VpcConfiguration field's value.
func (s *GetAccessPointOutput) SetVpcConfiguration(v *VpcConfiguration) *GetAccessPointOutput {
	s.VpcConfiguration = v
	return s
}

type GetAccessPointPolicyInput struct {
	_ struct{} `locationName:"GetAccessPointPolicyRequest" type:"structure"`

	// The account ID for the account that owns the specified access point.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// The name of the access point whose policy you want to retrieve.
	//
	// For using this parameter with Amazon S3 on Outposts with the REST API, you
	// must specify the name and the x-amz-outpost-id as well.
	//
	// For using this parameter with S3 on Outposts with the AWS SDK and CLI, you
	// must specify the ARN of the access point accessed in the format arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/accesspoint/<my-accesspoint-name>.
	// For example, to access the access point reports-ap through outpost my-outpost
	// owned by account 123456789012 in Region us-west-2, use the URL encoding of
	// arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/accesspoint/reports-ap.
	// The value must be URL encoded.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s GetAccessPointPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAccessPointPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAccessPointPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAccessPointPolicyInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *GetAccessPointPolicyInput) SetAccountId(v string) *GetAccessPointPolicyInput {
	s.AccountId = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetAccessPointPolicyInput) SetName(v string) *GetAccessPointPolicyInput {
	s.Name = &v
	return s
}

func (s *GetAccessPointPolicyInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

func (s *GetAccessPointPolicyInput) getEndpointARN() (arn.Resource, error) {
	if s.Name == nil {
		return nil, fmt.Errorf("member Name is nil")
	}
	return parseEndpointARN(*s.Name)
}

func (s *GetAccessPointPolicyInput) hasEndpointARN() bool {
	if s.Name == nil {
		return false
	}
	return arn.IsARN(*s.Name)
}

// updateArnableField updates the value of the input field that
// takes an ARN as an input. This method is useful to backfill
// the parsed resource name from ARN into the input member.
// It returns a pointer to a modified copy of input and an error.
// Note that original input is not modified.
func (s GetAccessPointPolicyInput) updateArnableField(v string) (interface{}, error) {
	if s.Name == nil {
		return nil, fmt.Errorf("member Name is nil")
	}
	s.Name = aws.String(v)
	return &s, nil
}

// updateAccountID returns a pointer to a modified copy of input,
// if account id is not provided, we update the account id in modified input
// if account id is provided, but doesn't match with the one in ARN, we throw an error
// if account id is not updated, we return nil. Note that original input is not modified.
func (s GetAccessPointPolicyInput) updateAccountID(accountId string) (interface{}, error) {
	if s.AccountId == nil {
		s.AccountId = aws.String(accountId)
		return &s, nil
	} else if *s.AccountId != accountId {
		return &s, fmt.Errorf("Account ID mismatch, the Account ID cannot be specified in an ARN and in the accountId field")
	}
	return nil, nil
}

type GetAccessPointPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The access point policy associated with the specified access point.
	Policy *string `type:"string"`
}

// String returns the string representation
func (s GetAccessPointPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAccessPointPolicyOutput) GoString() string {
	return s.String()
}

// SetPolicy sets the Policy field's value.
func (s *GetAccessPointPolicyOutput) SetPolicy(v string) *GetAccessPointPolicyOutput {
	s.Policy = &v
	return s
}

type GetAccessPointPolicyStatusInput struct {
	_ struct{} `locationName:"GetAccessPointPolicyStatusRequest" type:"structure"`

	// The account ID for the account that owns the specified access point.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// The name of the access point whose policy status you want to retrieve.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s GetAccessPointPolicyStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAccessPointPolicyStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAccessPointPolicyStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAccessPointPolicyStatusInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *GetAccessPointPolicyStatusInput) SetAccountId(v string) *GetAccessPointPolicyStatusInput {
	s.AccountId = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetAccessPointPolicyStatusInput) SetName(v string) *GetAccessPointPolicyStatusInput {
	s.Name = &v
	return s
}

func (s *GetAccessPointPolicyStatusInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

type GetAccessPointPolicyStatusOutput struct {
	_ struct{} `type:"structure"`

	// Indicates the current policy status of the specified access point.
	PolicyStatus *PolicyStatus `type:"structure"`
}

// String returns the string representation
func (s GetAccessPointPolicyStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAccessPointPolicyStatusOutput) GoString() string {
	return s.String()
}

// SetPolicyStatus sets the PolicyStatus field's value.
func (s *GetAccessPointPolicyStatusOutput) SetPolicyStatus(v *PolicyStatus) *GetAccessPointPolicyStatusOutput {
	s.PolicyStatus = v
	return s
}

type GetBucketInput struct {
	_ struct{} `locationName:"GetBucketRequest" type:"structure"`

	// The AWS account ID of the Outposts bucket.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// Specifies the bucket.
	//
	// For using this parameter with Amazon S3 on Outposts with the REST API, you
	// must specify the name and the x-amz-outpost-id as well.
	//
	// For using this parameter with S3 on Outposts with the AWS SDK and CLI, you
	// must specify the ARN of the bucket accessed in the format arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/bucket/<my-bucket-name>.
	// For example, to access the bucket reports through outpost my-outpost owned
	// by account 123456789012 in Region us-west-2, use the URL encoding of arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports.
	// The value must be URL encoded.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"name" min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s GetBucketInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBucketInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBucketInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *GetBucketInput) SetAccountId(v string) *GetBucketInput {
	s.AccountId = &v
	return s
}

// SetBucket sets the Bucket field's value.
func (s *GetBucketInput) SetBucket(v string) *GetBucketInput {
	s.Bucket = &v
	return s
}

func (s *GetBucketInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

func (s *GetBucketInput) getEndpointARN() (arn.Resource, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	return parseEndpointARN(*s.Bucket)
}

func (s *GetBucketInput) hasEndpointARN() bool {
	if s.Bucket == nil {
		return false
	}
	return arn.IsARN(*s.Bucket)
}

// updateArnableField updates the value of the input field that
// takes an ARN as an input. This method is useful to backfill
// the parsed resource name from ARN into the input member.
// It returns a pointer to a modified copy of input and an error.
// Note that original input is not modified.
func (s GetBucketInput) updateArnableField(v string) (interface{}, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	s.Bucket = aws.String(v)
	return &s, nil
}

// updateAccountID returns a pointer to a modified copy of input,
// if account id is not provided, we update the account id in modified input
// if account id is provided, but doesn't match with the one in ARN, we throw an error
// if account id is not updated, we return nil. Note that original input is not modified.
func (s GetBucketInput) updateAccountID(accountId string) (interface{}, error) {
	if s.AccountId == nil {
		s.AccountId = aws.String(accountId)
		return &s, nil
	} else if *s.AccountId != accountId {
		return &s, fmt.Errorf("Account ID mismatch, the Account ID cannot be specified in an ARN and in the accountId field")
	}
	return nil, nil
}

type GetBucketLifecycleConfigurationInput struct {
	_ struct{} `locationName:"GetBucketLifecycleConfigurationRequest" type:"structure"`

	// The AWS account ID of the Outposts bucket.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the bucket.
	//
	// For using this parameter with Amazon S3 on Outposts with the REST API, you
	// must specify the name and the x-amz-outpost-id as well.
	//
	// For using this parameter with S3 on Outposts with the AWS SDK and CLI, you
	// must specify the ARN of the bucket accessed in the format arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/bucket/<my-bucket-name>.
	// For example, to access the bucket reports through outpost my-outpost owned
	// by account 123456789012 in Region us-west-2, use the URL encoding of arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports.
	// The value must be URL encoded.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"name" min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s GetBucketLifecycleConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketLifecycleConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBucketLifecycleConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBucketLifecycleConfigurationInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *GetBucketLifecycleConfigurationInput) SetAccountId(v string) *GetBucketLifecycleConfigurationInput {
	s.AccountId = &v
	return s
}

// SetBucket sets the Bucket field's value.
func (s *GetBucketLifecycleConfigurationInput) SetBucket(v string) *GetBucketLifecycleConfigurationInput {
	s.Bucket = &v
	return s
}

func (s *GetBucketLifecycleConfigurationInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

func (s *GetBucketLifecycleConfigurationInput) getEndpointARN() (arn.Resource, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	return parseEndpointARN(*s.Bucket)
}

func (s *GetBucketLifecycleConfigurationInput) hasEndpointARN() bool {
	if s.Bucket == nil {
		return false
	}
	return arn.IsARN(*s.Bucket)
}

// updateArnableField updates the value of the input field that
// takes an ARN as an input. This method is useful to backfill
// the parsed resource name from ARN into the input member.
// It returns a pointer to a modified copy of input and an error.
// Note that original input is not modified.
func (s GetBucketLifecycleConfigurationInput) updateArnableField(v string) (interface{}, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	s.Bucket = aws.String(v)
	return &s, nil
}

// updateAccountID returns a pointer to a modified copy of input,
// if account id is not provided, we update the account id in modified input
// if account id is provided, but doesn't match with the one in ARN, we throw an error
// if account id is not updated, we return nil. Note that original input is not modified.
func (s GetBucketLifecycleConfigurationInput) updateAccountID(accountId string) (interface{}, error) {
	if s.AccountId == nil {
		s.AccountId = aws.String(accountId)
		return &s, nil
	} else if *s.AccountId != accountId {
		return &s, fmt.Errorf("Account ID mismatch, the Account ID cannot be specified in an ARN and in the accountId field")
	}
	return nil, nil
}

type GetBucketLifecycleConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// Container for the lifecycle rule of the Outposts bucket.
	Rules []*LifecycleRule `locationNameList:"Rule" type:"list"`
}

// String returns the string representation
func (s GetBucketLifecycleConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketLifecycleConfigurationOutput) GoString() string {
	return s.String()
}

// SetRules sets the Rules field's value.
func (s *GetBucketLifecycleConfigurationOutput) SetRules(v []*LifecycleRule) *GetBucketLifecycleConfigurationOutput {
	s.Rules = v
	return s
}

type GetBucketOutput struct {
	_ struct{} `type:"structure"`

	// The Outposts bucket requested.
	Bucket *string `min:"3" type:"string"`

	// The creation date of the Outposts bucket.
	CreationDate *time.Time `type:"timestamp"`

	PublicAccessBlockEnabled *bool `type:"boolean"`
}

// String returns the string representation
func (s GetBucketOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketOutput) GoString() string {
	return s.String()
}

// SetBucket sets the Bucket field's value.
func (s *GetBucketOutput) SetBucket(v string) *GetBucketOutput {
	s.Bucket = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *GetBucketOutput) SetCreationDate(v time.Time) *GetBucketOutput {
	s.CreationDate = &v
	return s
}

// SetPublicAccessBlockEnabled sets the PublicAccessBlockEnabled field's value.
func (s *GetBucketOutput) SetPublicAccessBlockEnabled(v bool) *GetBucketOutput {
	s.PublicAccessBlockEnabled = &v
	return s
}

type GetBucketPolicyInput struct {
	_ struct{} `locationName:"GetBucketPolicyRequest" type:"structure"`

	// The AWS account ID of the Outposts bucket.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// Specifies the bucket.
	//
	// For using this parameter with Amazon S3 on Outposts with the REST API, you
	// must specify the name and the x-amz-outpost-id as well.
	//
	// For using this parameter with S3 on Outposts with the AWS SDK and CLI, you
	// must specify the ARN of the bucket accessed in the format arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/bucket/<my-bucket-name>.
	// For example, to access the bucket reports through outpost my-outpost owned
	// by account 123456789012 in Region us-west-2, use the URL encoding of arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports.
	// The value must be URL encoded.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"name" min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s GetBucketPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBucketPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBucketPolicyInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *GetBucketPolicyInput) SetAccountId(v string) *GetBucketPolicyInput {
	s.AccountId = &v
	return s
}

// SetBucket sets the Bucket field's value.
func (s *GetBucketPolicyInput) SetBucket(v string) *GetBucketPolicyInput {
	s.Bucket = &v
	return s
}

func (s *GetBucketPolicyInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

func (s *GetBucketPolicyInput) getEndpointARN() (arn.Resource, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	return parseEndpointARN(*s.Bucket)
}

func (s *GetBucketPolicyInput) hasEndpointARN() bool {
	if s.Bucket == nil {
		return false
	}
	return arn.IsARN(*s.Bucket)
}

// updateArnableField updates the value of the input field that
// takes an ARN as an input. This method is useful to backfill
// the parsed resource name from ARN into the input member.
// It returns a pointer to a modified copy of input and an error.
// Note that original input is not modified.
func (s GetBucketPolicyInput) updateArnableField(v string) (interface{}, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	s.Bucket = aws.String(v)
	return &s, nil
}

// updateAccountID returns a pointer to a modified copy of input,
// if account id is not provided, we update the account id in modified input
// if account id is provided, but doesn't match with the one in ARN, we throw an error
// if account id is not updated, we return nil. Note that original input is not modified.
func (s GetBucketPolicyInput) updateAccountID(accountId string) (interface{}, error) {
	if s.AccountId == nil {
		s.AccountId = aws.String(accountId)
		return &s, nil
	} else if *s.AccountId != accountId {
		return &s, fmt.Errorf("Account ID mismatch, the Account ID cannot be specified in an ARN and in the accountId field")
	}
	return nil, nil
}

type GetBucketPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The policy of the Outposts bucket.
	Policy *string `type:"string"`
}

// String returns the string representation
func (s GetBucketPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketPolicyOutput) GoString() string {
	return s.String()
}

// SetPolicy sets the Policy field's value.
func (s *GetBucketPolicyOutput) SetPolicy(v string) *GetBucketPolicyOutput {
	s.Policy = &v
	return s
}

type GetBucketTaggingInput struct {
	_ struct{} `locationName:"GetBucketTaggingRequest" type:"structure"`

	// The AWS account ID of the Outposts bucket.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// Specifies the bucket.
	//
	// For using this parameter with Amazon S3 on Outposts with the REST API, you
	// must specify the name and the x-amz-outpost-id as well.
	//
	// For using this parameter with S3 on Outposts with the AWS SDK and CLI, you
	// must specify the ARN of the bucket accessed in the format arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/bucket/<my-bucket-name>.
	// For example, to access the bucket reports through outpost my-outpost owned
	// by account 123456789012 in Region us-west-2, use the URL encoding of arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports.
	// The value must be URL encoded.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"name" min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s GetBucketTaggingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketTaggingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBucketTaggingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBucketTaggingInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *GetBucketTaggingInput) SetAccountId(v string) *GetBucketTaggingInput {
	s.AccountId = &v
	return s
}

// SetBucket sets the Bucket field's value.
func (s *GetBucketTaggingInput) SetBucket(v string) *GetBucketTaggingInput {
	s.Bucket = &v
	return s
}

func (s *GetBucketTaggingInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

func (s *GetBucketTaggingInput) getEndpointARN() (arn.Resource, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	return parseEndpointARN(*s.Bucket)
}

func (s *GetBucketTaggingInput) hasEndpointARN() bool {
	if s.Bucket == nil {
		return false
	}
	return arn.IsARN(*s.Bucket)
}

// updateArnableField updates the value of the input field that
// takes an ARN as an input. This method is useful to backfill
// the parsed resource name from ARN into the input member.
// It returns a pointer to a modified copy of input and an error.
// Note that original input is not modified.
func (s GetBucketTaggingInput) updateArnableField(v string) (interface{}, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	s.Bucket = aws.String(v)
	return &s, nil
}

// updateAccountID returns a pointer to a modified copy of input,
// if account id is not provided, we update the account id in modified input
// if account id is provided, but doesn't match with the one in ARN, we throw an error
// if account id is not updated, we return nil. Note that original input is not modified.
func (s GetBucketTaggingInput) updateAccountID(accountId string) (interface{}, error) {
	if s.AccountId == nil {
		s.AccountId = aws.String(accountId)
		return &s, nil
	} else if *s.AccountId != accountId {
		return &s, fmt.Errorf("Account ID mismatch, the Account ID cannot be specified in an ARN and in the accountId field")
	}
	return nil, nil
}

type GetBucketTaggingOutput struct {
	_ struct{} `type:"structure"`

	// The tags set of the Outposts bucket.
	//
	// TagSet is a required field
	TagSet []*S3Tag `type:"list" required:"true"`
}

// String returns the string representation
func (s GetBucketTaggingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketTaggingOutput) GoString() string {
	return s.String()
}

// SetTagSet sets the TagSet field's value.
func (s *GetBucketTaggingOutput) SetTagSet(v []*S3Tag) *GetBucketTaggingOutput {
	s.TagSet = v
	return s
}

type GetJobTaggingInput struct {
	_ struct{} `locationName:"GetJobTaggingRequest" type:"structure"`

	// The AWS account ID associated with the S3 Batch Operations job.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// The ID for the S3 Batch Operations job whose tags you want to retrieve.
	//
	// JobId is a required field
	JobId *string `location:"uri" locationName:"id" min:"5" type:"string" required:"true"`
}

// String returns the string representation
func (s GetJobTaggingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetJobTaggingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetJobTaggingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetJobTaggingInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *GetJobTaggingInput) SetAccountId(v string) *GetJobTaggingInput {
	s.AccountId = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *GetJobTaggingInput) SetJobId(v string) *GetJobTaggingInput {
	s.JobId = &v
	return s
}

func (s *GetJobTaggingInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

type GetJobTaggingOutput struct {
	_ struct{} `type:"structure"`

	// The set of tags associated with the S3 Batch Operations job.
	Tags []*S3Tag `type:"list"`
}

// String returns the string representation
func (s GetJobTaggingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetJobTaggingOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *GetJobTaggingOutput) SetTags(v []*S3Tag) *GetJobTaggingOutput {
	s.Tags = v
	return s
}

type GetPublicAccessBlockInput struct {
	_ struct{} `locationName:"GetPublicAccessBlockRequest" type:"structure"`

	// The account ID for the AWS account whose PublicAccessBlock configuration
	// you want to retrieve.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetPublicAccessBlockInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPublicAccessBlockInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetPublicAccessBlockInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetPublicAccessBlockInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *GetPublicAccessBlockInput) SetAccountId(v string) *GetPublicAccessBlockInput {
	s.AccountId = &v
	return s
}

func (s *GetPublicAccessBlockInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

type GetPublicAccessBlockOutput struct {
	_ struct{} `type:"structure" payload:"PublicAccessBlockConfiguration"`

	// The PublicAccessBlock configuration currently in effect for this AWS account.
	PublicAccessBlockConfiguration *PublicAccessBlockConfiguration `type:"structure"`
}

// String returns the string representation
func (s GetPublicAccessBlockOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPublicAccessBlockOutput) GoString() string {
	return s.String()
}

// SetPublicAccessBlockConfiguration sets the PublicAccessBlockConfiguration field's value.
func (s *GetPublicAccessBlockOutput) SetPublicAccessBlockConfiguration(v *PublicAccessBlockConfiguration) *GetPublicAccessBlockOutput {
	s.PublicAccessBlockConfiguration = v
	return s
}

type GetStorageLensConfigurationInput struct {
	_ struct{} `locationName:"GetStorageLensConfigurationRequest" type:"structure"`

	// The account ID of the requester.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// The ID of the Amazon S3 Storage Lens configuration.
	//
	// ConfigId is a required field
	ConfigId *string `location:"uri" locationName:"storagelensid" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetStorageLensConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetStorageLensConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetStorageLensConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetStorageLensConfigurationInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.ConfigId == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigId"))
	}
	if s.ConfigId != nil && len(*s.ConfigId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *GetStorageLensConfigurationInput) SetAccountId(v string) *GetStorageLensConfigurationInput {
	s.AccountId = &v
	return s
}

// SetConfigId sets the ConfigId field's value.
func (s *GetStorageLensConfigurationInput) SetConfigId(v string) *GetStorageLensConfigurationInput {
	s.ConfigId = &v
	return s
}

func (s *GetStorageLensConfigurationInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

type GetStorageLensConfigurationOutput struct {
	_ struct{} `type:"structure" payload:"StorageLensConfiguration"`

	// The S3 Storage Lens configuration requested.
	StorageLensConfiguration *StorageLensConfiguration `type:"structure"`
}

// String returns the string representation
func (s GetStorageLensConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetStorageLensConfigurationOutput) GoString() string {
	return s.String()
}

// SetStorageLensConfiguration sets the StorageLensConfiguration field's value.
func (s *GetStorageLensConfigurationOutput) SetStorageLensConfiguration(v *StorageLensConfiguration) *GetStorageLensConfigurationOutput {
	s.StorageLensConfiguration = v
	return s
}

type GetStorageLensConfigurationTaggingInput struct {
	_ struct{} `locationName:"GetStorageLensConfigurationTaggingRequest" type:"structure"`

	// The account ID of the requester.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// The ID of the Amazon S3 Storage Lens configuration.
	//
	// ConfigId is a required field
	ConfigId *string `location:"uri" locationName:"storagelensid" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetStorageLensConfigurationTaggingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetStorageLensConfigurationTaggingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetStorageLensConfigurationTaggingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetStorageLensConfigurationTaggingInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.ConfigId == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigId"))
	}
	if s.ConfigId != nil && len(*s.ConfigId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *GetStorageLensConfigurationTaggingInput) SetAccountId(v string) *GetStorageLensConfigurationTaggingInput {
	s.AccountId = &v
	return s
}

// SetConfigId sets the ConfigId field's value.
func (s *GetStorageLensConfigurationTaggingInput) SetConfigId(v string) *GetStorageLensConfigurationTaggingInput {
	s.ConfigId = &v
	return s
}

func (s *GetStorageLensConfigurationTaggingInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

type GetStorageLensConfigurationTaggingOutput struct {
	_ struct{} `type:"structure"`

	// The tags of S3 Storage Lens configuration requested.
	Tags []*StorageLensTag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s GetStorageLensConfigurationTaggingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetStorageLensConfigurationTaggingOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *GetStorageLensConfigurationTaggingOutput) SetTags(v []*StorageLensTag) *GetStorageLensConfigurationTaggingOutput {
	s.Tags = v
	return s
}

// A container for what Amazon S3 Storage Lens configuration includes.
type Include struct {
	_ struct{} `type:"structure"`

	// A container for the S3 Storage Lens bucket includes.
	Buckets []*string `locationNameList:"Arn" type:"list"`

	// A container for the S3 Storage Lens Region includes.
	Regions []*string `locationNameList:"Region" type:"list"`
}

// String returns the string representation
func (s Include) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Include) GoString() string {
	return s.String()
}

// SetBuckets sets the Buckets field's value.
func (s *Include) SetBuckets(v []*string) *Include {
	s.Buckets = v
	return s
}

// SetRegions sets the Regions field's value.
func (s *Include) SetRegions(v []*string) *Include {
	s.Regions = v
	return s
}

// A container element for the job configuration and status information returned
// by a Describe Job request.
type JobDescriptor struct {
	_ struct{} `type:"structure"`

	// Indicates whether confirmation is required before Amazon S3 begins running
	// the specified job. Confirmation is required only for jobs created through
	// the Amazon S3 console.
	ConfirmationRequired *bool `type:"boolean"`

	// A timestamp indicating when this job was created.
	CreationTime *time.Time `type:"timestamp"`

	// The description for this job, if one was provided in this job's Create Job
	// request.
	Description *string `min:"1" type:"string"`

	// If the specified job failed, this field contains information describing the
	// failure.
	FailureReasons []*JobFailure `type:"list"`

	// The Amazon Resource Name (ARN) for this job.
	JobArn *string `min:"1" type:"string"`

	// The ID for the specified job.
	JobId *string `min:"5" type:"string"`

	// The configuration information for the specified job's manifest object.
	Manifest *JobManifest `type:"structure"`

	// The operation that the specified job is configured to run on the objects
	// listed in the manifest.
	Operation *JobOperation `type:"structure"`

	// The priority of the specified job.
	Priority *int64 `type:"integer"`

	// Describes the total number of tasks that the specified job has run, the number
	// of tasks that succeeded, and the number of tasks that failed.
	ProgressSummary *JobProgressSummary `type:"structure"`

	// Contains the configuration information for the job-completion report if you
	// requested one in the Create Job request.
	Report *JobReport `type:"structure"`

	// The Amazon Resource Name (ARN) for the AWS Identity and Access Management
	// (IAM) role assigned to run the tasks for this job.
	RoleArn *string `min:"1" type:"string"`

	// The current status of the specified job.
	Status *string `type:"string" enum:"JobStatus"`

	// The reason for updating the job.
	StatusUpdateReason *string `min:"1" type:"string"`

	// The reason why the specified job was suspended. A job is only suspended if
	// you create it through the Amazon S3 console. When you create the job, it
	// enters the Suspended state to await confirmation before running. After you
	// confirm the job, it automatically exits the Suspended state.
	SuspendedCause *string `min:"1" type:"string"`

	// The timestamp when this job was suspended, if it has been suspended.
	SuspendedDate *time.Time `type:"timestamp"`

	// A timestamp indicating when this job terminated. A job's termination date
	// is the date and time when it succeeded, failed, or was canceled.
	TerminationDate *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s JobDescriptor) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s JobDescriptor) GoString() string {
	return s.String()
}

// SetConfirmationRequired sets the ConfirmationRequired field's value.
func (s *JobDescriptor) SetConfirmationRequired(v bool) *JobDescriptor {
	s.ConfirmationRequired = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *JobDescriptor) SetCreationTime(v time.Time) *JobDescriptor {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *JobDescriptor) SetDescription(v string) *JobDescriptor {
	s.Description = &v
	return s
}

// SetFailureReasons sets the FailureReasons field's value.
func (s *JobDescriptor) SetFailureReasons(v []*JobFailure) *JobDescriptor {
	s.FailureReasons = v
	return s
}

// SetJobArn sets the JobArn field's value.
func (s *JobDescriptor) SetJobArn(v string) *JobDescriptor {
	s.JobArn = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *JobDescriptor) SetJobId(v string) *JobDescriptor {
	s.JobId = &v
	return s
}

// SetManifest sets the Manifest field's value.
func (s *JobDescriptor) SetManifest(v *JobManifest) *JobDescriptor {
	s.Manifest = v
	return s
}

// SetOperation sets the Operation field's value.
func (s *JobDescriptor) SetOperation(v *JobOperation) *JobDescriptor {
	s.Operation = v
	return s
}

// SetPriority sets the Priority field's value.
func (s *JobDescriptor) SetPriority(v int64) *JobDescriptor {
	s.Priority = &v
	return s
}

// SetProgressSummary sets the ProgressSummary field's value.
func (s *JobDescriptor) SetProgressSummary(v *JobProgressSummary) *JobDescriptor {
	s.ProgressSummary = v
	return s
}

// SetReport sets the Report field's value.
func (s *JobDescriptor) SetReport(v *JobReport) *JobDescriptor {
	s.Report = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *JobDescriptor) SetRoleArn(v string) *JobDescriptor {
	s.RoleArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *JobDescriptor) SetStatus(v string) *JobDescriptor {
	s.Status = &v
	return s
}

// SetStatusUpdateReason sets the StatusUpdateReason field's value.
func (s *JobDescriptor) SetStatusUpdateReason(v string) *JobDescriptor {
	s.StatusUpdateReason = &v
	return s
}

// SetSuspendedCause sets the SuspendedCause field's value.
func (s *JobDescriptor) SetSuspendedCause(v string) *JobDescriptor {
	s.SuspendedCause = &v
	return s
}

// SetSuspendedDate sets the SuspendedDate field's value.
func (s *JobDescriptor) SetSuspendedDate(v time.Time) *JobDescriptor {
	s.SuspendedDate = &v
	return s
}

// SetTerminationDate sets the TerminationDate field's value.
func (s *JobDescriptor) SetTerminationDate(v time.Time) *JobDescriptor {
	s.TerminationDate = &v
	return s
}

// If this job failed, this element indicates why the job failed.
type JobFailure struct {
	_ struct{} `type:"structure"`

	// The failure code, if any, for the specified job.
	FailureCode *string `min:"1" type:"string"`

	// The failure reason, if any, for the specified job.
	FailureReason *string `min:"1" type:"string"`
}

// String returns the string representation
func (s JobFailure) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s JobFailure) GoString() string {
	return s.String()
}

// SetFailureCode sets the FailureCode field's value.
func (s *JobFailure) SetFailureCode(v string) *JobFailure {
	s.FailureCode = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *JobFailure) SetFailureReason(v string) *JobFailure {
	s.FailureReason = &v
	return s
}

// Contains the configuration and status information for a single job retrieved
// as part of a job list.
type JobListDescriptor struct {
	_ struct{} `type:"structure"`

	// A timestamp indicating when the specified job was created.
	CreationTime *time.Time `type:"timestamp"`

	// The user-specified description that was included in the specified job's Create
	// Job request.
	Description *string `min:"1" type:"string"`

	// The ID for the specified job.
	JobId *string `min:"5" type:"string"`

	// The operation that the specified job is configured to run on every object
	// listed in the manifest.
	Operation *string `type:"string" enum:"OperationName"`

	// The current priority for the specified job.
	Priority *int64 `type:"integer"`

	// Describes the total number of tasks that the specified job has run, the number
	// of tasks that succeeded, and the number of tasks that failed.
	ProgressSummary *JobProgressSummary `type:"structure"`

	// The specified job's current status.
	Status *string `type:"string" enum:"JobStatus"`

	// A timestamp indicating when the specified job terminated. A job's termination
	// date is the date and time when it succeeded, failed, or was canceled.
	TerminationDate *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s JobListDescriptor) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s JobListDescriptor) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *JobListDescriptor) SetCreationTime(v time.Time) *JobListDescriptor {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *JobListDescriptor) SetDescription(v string) *JobListDescriptor {
	s.Description = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *JobListDescriptor) SetJobId(v string) *JobListDescriptor {
	s.JobId = &v
	return s
}

// SetOperation sets the Operation field's value.
func (s *JobListDescriptor) SetOperation(v string) *JobListDescriptor {
	s.Operation = &v
	return s
}

// SetPriority sets the Priority field's value.
func (s *JobListDescriptor) SetPriority(v int64) *JobListDescriptor {
	s.Priority = &v
	return s
}

// SetProgressSummary sets the ProgressSummary field's value.
func (s *JobListDescriptor) SetProgressSummary(v *JobProgressSummary) *JobListDescriptor {
	s.ProgressSummary = v
	return s
}

// SetStatus sets the Status field's value.
func (s *JobListDescriptor) SetStatus(v string) *JobListDescriptor {
	s.Status = &v
	return s
}

// SetTerminationDate sets the TerminationDate field's value.
func (s *JobListDescriptor) SetTerminationDate(v time.Time) *JobListDescriptor {
	s.TerminationDate = &v
	return s
}

// Contains the configuration information for a job's manifest.
type JobManifest struct {
	_ struct{} `type:"structure"`

	// Contains the information required to locate the specified job's manifest.
	//
	// Location is a required field
	Location *JobManifestLocation `type:"structure" required:"true"`

	// Describes the format of the specified job's manifest. If the manifest is
	// in CSV format, also describes the columns contained within the manifest.
	//
	// Spec is a required field
	Spec *JobManifestSpec `type:"structure" required:"true"`
}

// String returns the string representation
func (s JobManifest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s JobManifest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *JobManifest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "JobManifest"}
	if s.Location == nil {
		invalidParams.Add(request.NewErrParamRequired("Location"))
	}
	if s.Spec == nil {
		invalidParams.Add(request.NewErrParamRequired("Spec"))
	}
	if s.Location != nil {
		if err := s.Location.Validate(); err != nil {
			invalidParams.AddNested("Location", err.(request.ErrInvalidParams))
		}
	}
	if s.Spec != nil {
		if err := s.Spec.Validate(); err != nil {
			invalidParams.AddNested("Spec", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLocation sets the Location field's value.
func (s *JobManifest) SetLocation(v *JobManifestLocation) *JobManifest {
	s.Location = v
	return s
}

// SetSpec sets the Spec field's value.
func (s *JobManifest) SetSpec(v *JobManifestSpec) *JobManifest {
	s.Spec = v
	return s
}

// Contains the information required to locate a manifest object.
type JobManifestLocation struct {
	_ struct{} `type:"structure"`

	// The ETag for the specified manifest object.
	//
	// ETag is a required field
	ETag *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) for a manifest object.
	//
	// ObjectArn is a required field
	ObjectArn *string `min:"1" type:"string" required:"true"`

	// The optional version ID to identify a specific version of the manifest object.
	ObjectVersionId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s JobManifestLocation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s JobManifestLocation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *JobManifestLocation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "JobManifestLocation"}
	if s.ETag == nil {
		invalidParams.Add(request.NewErrParamRequired("ETag"))
	}
	if s.ETag != nil && len(*s.ETag) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ETag", 1))
	}
	if s.ObjectArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ObjectArn"))
	}
	if s.ObjectArn != nil && len(*s.ObjectArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ObjectArn", 1))
	}
	if s.ObjectVersionId != nil && len(*s.ObjectVersionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ObjectVersionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetETag sets the ETag field's value.
func (s *JobManifestLocation) SetETag(v string) *JobManifestLocation {
	s.ETag = &v
	return s
}

// SetObjectArn sets the ObjectArn field's value.
func (s *JobManifestLocation) SetObjectArn(v string) *JobManifestLocation {
	s.ObjectArn = &v
	return s
}

// SetObjectVersionId sets the ObjectVersionId field's value.
func (s *JobManifestLocation) SetObjectVersionId(v string) *JobManifestLocation {
	s.ObjectVersionId = &v
	return s
}

// Describes the format of a manifest. If the manifest is in CSV format, also
// describes the columns contained within the manifest.
type JobManifestSpec struct {
	_ struct{} `type:"structure"`

	// If the specified manifest object is in the S3BatchOperations_CSV_20180820
	// format, this element describes which columns contain the required data.
	Fields []*string `type:"list"`

	// Indicates which of the available formats the specified manifest uses.
	//
	// Format is a required field
	Format *string `type:"string" required:"true" enum:"JobManifestFormat"`
}

// String returns the string representation
func (s JobManifestSpec) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s JobManifestSpec) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *JobManifestSpec) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "JobManifestSpec"}
	if s.Format == nil {
		invalidParams.Add(request.NewErrParamRequired("Format"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFields sets the Fields field's value.
func (s *JobManifestSpec) SetFields(v []*string) *JobManifestSpec {
	s.Fields = v
	return s
}

// SetFormat sets the Format field's value.
func (s *JobManifestSpec) SetFormat(v string) *JobManifestSpec {
	s.Format = &v
	return s
}

// The operation that you want this job to perform on every object listed in
// the manifest. For more information about the available operations, see Operations
// (https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-operations.html)
// in the Amazon Simple Storage Service Developer Guide.
type JobOperation struct {
	_ struct{} `type:"structure"`

	// Directs the specified job to invoke an AWS Lambda function on every object
	// in the manifest.
	LambdaInvoke *LambdaInvokeOperation `type:"structure"`

	// Directs the specified job to initiate restore requests for every archived
	// object in the manifest.
	S3InitiateRestoreObject *S3InitiateRestoreObjectOperation `type:"structure"`

	// Directs the specified job to run a PUT Object acl call on every object in
	// the manifest.
	S3PutObjectAcl *S3SetObjectAclOperation `type:"structure"`

	// Directs the specified job to run a PUT Copy object call on every object in
	// the manifest.
	S3PutObjectCopy *S3CopyObjectOperation `type:"structure"`

	// Contains the configuration for an S3 Object Lock legal hold operation that
	// an S3 Batch Operations job passes every object to the underlying PutObjectLegalHold
	// API. For more information, see Using S3 Object Lock legal hold with S3 Batch
	// Operations (https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-legal-hold.html)
	// in the Amazon Simple Storage Service Developer Guide.
	S3PutObjectLegalHold *S3SetObjectLegalHoldOperation `type:"structure"`

	// Contains the configuration parameters for the Object Lock retention action
	// for an S3 Batch Operations job. Batch Operations passes every object to the
	// underlying PutObjectRetention API. For more information, see Using S3 Object
	// Lock retention with S3 Batch Operations (https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-retention-date.html)
	// in the Amazon Simple Storage Service Developer Guide.
	S3PutObjectRetention *S3SetObjectRetentionOperation `type:"structure"`

	// Directs the specified job to run a PUT Object tagging call on every object
	// in the manifest.
	S3PutObjectTagging *S3SetObjectTaggingOperation `type:"structure"`
}

// String returns the string representation
func (s JobOperation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s JobOperation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *JobOperation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "JobOperation"}
	if s.LambdaInvoke != nil {
		if err := s.LambdaInvoke.Validate(); err != nil {
			invalidParams.AddNested("LambdaInvoke", err.(request.ErrInvalidParams))
		}
	}
	if s.S3PutObjectAcl != nil {
		if err := s.S3PutObjectAcl.Validate(); err != nil {
			invalidParams.AddNested("S3PutObjectAcl", err.(request.ErrInvalidParams))
		}
	}
	if s.S3PutObjectCopy != nil {
		if err := s.S3PutObjectCopy.Validate(); err != nil {
			invalidParams.AddNested("S3PutObjectCopy", err.(request.ErrInvalidParams))
		}
	}
	if s.S3PutObjectLegalHold != nil {
		if err := s.S3PutObjectLegalHold.Validate(); err != nil {
			invalidParams.AddNested("S3PutObjectLegalHold", err.(request.ErrInvalidParams))
		}
	}
	if s.S3PutObjectRetention != nil {
		if err := s.S3PutObjectRetention.Validate(); err != nil {
			invalidParams.AddNested("S3PutObjectRetention", err.(request.ErrInvalidParams))
		}
	}
	if s.S3PutObjectTagging != nil {
		if err := s.S3PutObjectTagging.Validate(); err != nil {
			invalidParams.AddNested("S3PutObjectTagging", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLambdaInvoke sets the LambdaInvoke field's value.
func (s *JobOperation) SetLambdaInvoke(v *LambdaInvokeOperation) *JobOperation {
	s.LambdaInvoke = v
	return s
}

// SetS3InitiateRestoreObject sets the S3InitiateRestoreObject field's value.
func (s *JobOperation) SetS3InitiateRestoreObject(v *S3InitiateRestoreObjectOperation) *JobOperation {
	s.S3InitiateRestoreObject = v
	return s
}

// SetS3PutObjectAcl sets the S3PutObjectAcl field's value.
func (s *JobOperation) SetS3PutObjectAcl(v *S3SetObjectAclOperation) *JobOperation {
	s.S3PutObjectAcl = v
	return s
}

// SetS3PutObjectCopy sets the S3PutObjectCopy field's value.
func (s *JobOperation) SetS3PutObjectCopy(v *S3CopyObjectOperation) *JobOperation {
	s.S3PutObjectCopy = v
	return s
}

// SetS3PutObjectLegalHold sets the S3PutObjectLegalHold field's value.
func (s *JobOperation) SetS3PutObjectLegalHold(v *S3SetObjectLegalHoldOperation) *JobOperation {
	s.S3PutObjectLegalHold = v
	return s
}

// SetS3PutObjectRetention sets the S3PutObjectRetention field's value.
func (s *JobOperation) SetS3PutObjectRetention(v *S3SetObjectRetentionOperation) *JobOperation {
	s.S3PutObjectRetention = v
	return s
}

// SetS3PutObjectTagging sets the S3PutObjectTagging field's value.
func (s *JobOperation) SetS3PutObjectTagging(v *S3SetObjectTaggingOperation) *JobOperation {
	s.S3PutObjectTagging = v
	return s
}

// Describes the total number of tasks that the specified job has started, the
// number of tasks that succeeded, and the number of tasks that failed.
type JobProgressSummary struct {
	_ struct{} `type:"structure"`

	NumberOfTasksFailed *int64 `type:"long"`

	NumberOfTasksSucceeded *int64 `type:"long"`

	TotalNumberOfTasks *int64 `type:"long"`
}

// String returns the string representation
func (s JobProgressSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s JobProgressSummary) GoString() string {
	return s.String()
}

// SetNumberOfTasksFailed sets the NumberOfTasksFailed field's value.
func (s *JobProgressSummary) SetNumberOfTasksFailed(v int64) *JobProgressSummary {
	s.NumberOfTasksFailed = &v
	return s
}

// SetNumberOfTasksSucceeded sets the NumberOfTasksSucceeded field's value.
func (s *JobProgressSummary) SetNumberOfTasksSucceeded(v int64) *JobProgressSummary {
	s.NumberOfTasksSucceeded = &v
	return s
}

// SetTotalNumberOfTasks sets the TotalNumberOfTasks field's value.
func (s *JobProgressSummary) SetTotalNumberOfTasks(v int64) *JobProgressSummary {
	s.TotalNumberOfTasks = &v
	return s
}

// Contains the configuration parameters for a job-completion report.
type JobReport struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the bucket where specified job-completion
	// report will be stored.
	Bucket *string `min:"1" type:"string"`

	// Indicates whether the specified job will generate a job-completion report.
	//
	// Enabled is a required field
	Enabled *bool `type:"boolean" required:"true"`

	// The format of the specified job-completion report.
	Format *string `type:"string" enum:"JobReportFormat"`

	// An optional prefix to describe where in the specified bucket the job-completion
	// report will be stored. Amazon S3 stores the job-completion report at <prefix>/job-<job-id>/report.json.
	Prefix *string `min:"1" type:"string"`

	// Indicates whether the job-completion report will include details of all tasks
	// or only failed tasks.
	ReportScope *string `type:"string" enum:"JobReportScope"`
}

// String returns the string representation
func (s JobReport) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s JobReport) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *JobReport) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "JobReport"}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}
	if s.Enabled == nil {
		invalidParams.Add(request.NewErrParamRequired("Enabled"))
	}
	if s.Prefix != nil && len(*s.Prefix) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Prefix", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *JobReport) SetBucket(v string) *JobReport {
	s.Bucket = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *JobReport) SetEnabled(v bool) *JobReport {
	s.Enabled = &v
	return s
}

// SetFormat sets the Format field's value.
func (s *JobReport) SetFormat(v string) *JobReport {
	s.Format = &v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *JobReport) SetPrefix(v string) *JobReport {
	s.Prefix = &v
	return s
}

// SetReportScope sets the ReportScope field's value.
func (s *JobReport) SetReportScope(v string) *JobReport {
	s.ReportScope = &v
	return s
}

// Contains the configuration parameters for a Lambda Invoke operation.
type LambdaInvokeOperation struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the AWS Lambda function that the specified
	// job will invoke on every object in the manifest.
	FunctionArn *string `min:"1" type:"string"`
}

// String returns the string representation
func (s LambdaInvokeOperation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LambdaInvokeOperation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LambdaInvokeOperation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LambdaInvokeOperation"}
	if s.FunctionArn != nil && len(*s.FunctionArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFunctionArn sets the FunctionArn field's value.
func (s *LambdaInvokeOperation) SetFunctionArn(v string) *LambdaInvokeOperation {
	s.FunctionArn = &v
	return s
}

// The container for the Outposts bucket lifecycle configuration.
type LifecycleConfiguration struct {
	_ struct{} `type:"structure"`

	// A lifecycle rule for individual objects in an Outposts bucket.
	Rules []*LifecycleRule `locationNameList:"Rule" type:"list"`
}

// String returns the string representation
func (s LifecycleConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LifecycleConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LifecycleConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LifecycleConfiguration"}
	if s.Rules != nil {
		for i, v := range s.Rules {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Rules", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRules sets the Rules field's value.
func (s *LifecycleConfiguration) SetRules(v []*LifecycleRule) *LifecycleConfiguration {
	s.Rules = v
	return s
}

// The container of the Outposts bucket lifecycle expiration.
type LifecycleExpiration struct {
	_ struct{} `type:"structure"`

	// Indicates at what date the object is to be deleted. Should be in GMT ISO
	// 8601 format.
	Date *time.Time `type:"timestamp"`

	// Indicates the lifetime, in days, of the objects that are subject to the rule.
	// The value must be a non-zero positive integer.
	Days *int64 `type:"integer"`

	// Indicates whether Amazon S3 will remove a delete marker with no noncurrent
	// versions. If set to true, the delete marker will be expired. If set to false,
	// the policy takes no action. This cannot be specified with Days or Date in
	// a Lifecycle Expiration Policy.
	ExpiredObjectDeleteMarker *bool `type:"boolean"`
}

// String returns the string representation
func (s LifecycleExpiration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LifecycleExpiration) GoString() string {
	return s.String()
}

// SetDate sets the Date field's value.
func (s *LifecycleExpiration) SetDate(v time.Time) *LifecycleExpiration {
	s.Date = &v
	return s
}

// SetDays sets the Days field's value.
func (s *LifecycleExpiration) SetDays(v int64) *LifecycleExpiration {
	s.Days = &v
	return s
}

// SetExpiredObjectDeleteMarker sets the ExpiredObjectDeleteMarker field's value.
func (s *LifecycleExpiration) SetExpiredObjectDeleteMarker(v bool) *LifecycleExpiration {
	s.ExpiredObjectDeleteMarker = &v
	return s
}

// The container for the Outposts bucket lifecycle rule.
type LifecycleRule struct {
	_ struct{} `type:"structure"`

	// Specifies the days since the initiation of an incomplete multipart upload
	// that Amazon S3 waits before permanently removing all parts of the upload.
	// For more information, see Aborting Incomplete Multipart Uploads Using a Bucket
	// Lifecycle Policy (https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuoverview.html#mpu-abort-incomplete-mpu-lifecycle-config)
	// in the Amazon Simple Storage Service Developer Guide.
	AbortIncompleteMultipartUpload *AbortIncompleteMultipartUpload `type:"structure"`

	// Specifies the expiration for the lifecycle of the object in the form of date,
	// days and, whether the object has a delete marker.
	Expiration *LifecycleExpiration `type:"structure"`

	// The container for the filter of lifecycle rule.
	Filter *LifecycleRuleFilter `type:"structure"`

	// Unique identifier for the rule. The value cannot be longer than 255 characters.
	ID *string `type:"string"`

	// The noncurrent version expiration of the lifecycle rule.
	//
	// This is not supported by Amazon S3 on Outposts buckets.
	NoncurrentVersionExpiration *NoncurrentVersionExpiration `type:"structure"`

	// Specifies the transition rule for the lifecycle rule that describes when
	// noncurrent objects transition to a specific storage class. If your bucket
	// is versioning-enabled (or versioning is suspended), you can set this action
	// to request that Amazon S3 transition noncurrent object versions to a specific
	// storage class at a set period in the object's lifetime.
	//
	// This is not supported by Amazon S3 on Outposts buckets.
	NoncurrentVersionTransitions []*NoncurrentVersionTransition `locationNameList:"NoncurrentVersionTransition" type:"list"`

	// If 'Enabled', the rule is currently being applied. If 'Disabled', the rule
	// is not currently being applied.
	//
	// Status is a required field
	Status *string `type:"string" required:"true" enum:"ExpirationStatus"`

	// Specifies when an Amazon S3 object transitions to a specified storage class.
	//
	// This is not supported by Amazon S3 on Outposts buckets.
	Transitions []*Transition `locationNameList:"Transition" type:"list"`
}

// String returns the string representation
func (s LifecycleRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LifecycleRule) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LifecycleRule) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LifecycleRule"}
	if s.Status == nil {
		invalidParams.Add(request.NewErrParamRequired("Status"))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAbortIncompleteMultipartUpload sets the AbortIncompleteMultipartUpload field's value.
func (s *LifecycleRule) SetAbortIncompleteMultipartUpload(v *AbortIncompleteMultipartUpload) *LifecycleRule {
	s.AbortIncompleteMultipartUpload = v
	return s
}

// SetExpiration sets the Expiration field's value.
func (s *LifecycleRule) SetExpiration(v *LifecycleExpiration) *LifecycleRule {
	s.Expiration = v
	return s
}

// SetFilter sets the Filter field's value.
func (s *LifecycleRule) SetFilter(v *LifecycleRuleFilter) *LifecycleRule {
	s.Filter = v
	return s
}

// SetID sets the ID field's value.
func (s *LifecycleRule) SetID(v string) *LifecycleRule {
	s.ID = &v
	return s
}

// SetNoncurrentVersionExpiration sets the NoncurrentVersionExpiration field's value.
func (s *LifecycleRule) SetNoncurrentVersionExpiration(v *NoncurrentVersionExpiration) *LifecycleRule {
	s.NoncurrentVersionExpiration = v
	return s
}

// SetNoncurrentVersionTransitions sets the NoncurrentVersionTransitions field's value.
func (s *LifecycleRule) SetNoncurrentVersionTransitions(v []*NoncurrentVersionTransition) *LifecycleRule {
	s.NoncurrentVersionTransitions = v
	return s
}

// SetStatus sets the Status field's value.
func (s *LifecycleRule) SetStatus(v string) *LifecycleRule {
	s.Status = &v
	return s
}

// SetTransitions sets the Transitions field's value.
func (s *LifecycleRule) SetTransitions(v []*Transition) *LifecycleRule {
	s.Transitions = v
	return s
}

// The container for the Outposts bucket lifecycle rule and operator.
type LifecycleRuleAndOperator struct {
	_ struct{} `type:"structure"`

	// Prefix identifying one or more objects to which the rule applies.
	Prefix *string `type:"string"`

	// All of these tags must exist in the object's tag set in order for the rule
	// to apply.
	Tags []*S3Tag `type:"list"`
}

// String returns the string representation
func (s LifecycleRuleAndOperator) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LifecycleRuleAndOperator) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LifecycleRuleAndOperator) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LifecycleRuleAndOperator"}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPrefix sets the Prefix field's value.
func (s *LifecycleRuleAndOperator) SetPrefix(v string) *LifecycleRuleAndOperator {
	s.Prefix = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *LifecycleRuleAndOperator) SetTags(v []*S3Tag) *LifecycleRuleAndOperator {
	s.Tags = v
	return s
}

// The container for the filter of the lifecycle rule.
type LifecycleRuleFilter struct {
	_ struct{} `type:"structure"`

	// The container for the AND condition for the lifecycle rule.
	And *LifecycleRuleAndOperator `type:"structure"`

	// Prefix identifying one or more objects to which the rule applies.
	Prefix *string `type:"string"`

	Tag *S3Tag `type:"structure"`
}

// String returns the string representation
func (s LifecycleRuleFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LifecycleRuleFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LifecycleRuleFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LifecycleRuleFilter"}
	if s.And != nil {
		if err := s.And.Validate(); err != nil {
			invalidParams.AddNested("And", err.(request.ErrInvalidParams))
		}
	}
	if s.Tag != nil {
		if err := s.Tag.Validate(); err != nil {
			invalidParams.AddNested("Tag", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnd sets the And field's value.
func (s *LifecycleRuleFilter) SetAnd(v *LifecycleRuleAndOperator) *LifecycleRuleFilter {
	s.And = v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *LifecycleRuleFilter) SetPrefix(v string) *LifecycleRuleFilter {
	s.Prefix = &v
	return s
}

// SetTag sets the Tag field's value.
func (s *LifecycleRuleFilter) SetTag(v *S3Tag) *LifecycleRuleFilter {
	s.Tag = v
	return s
}

type ListAccessPointsInput struct {
	_ struct{} `locationName:"ListAccessPointsRequest" type:"structure"`

	// The AWS account ID for owner of the bucket whose access points you want to
	// list.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// The name of the bucket whose associated access points you want to list.
	//
	// For using this parameter with Amazon S3 on Outposts with the REST API, you
	// must specify the name and the x-amz-outpost-id as well.
	//
	// For using this parameter with S3 on Outposts with the AWS SDK and CLI, you
	// must specify the ARN of the bucket accessed in the format arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/bucket/<my-bucket-name>.
	// For example, to access the bucket reports through outpost my-outpost owned
	// by account 123456789012 in Region us-west-2, use the URL encoding of arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports.
	// The value must be URL encoded.
	Bucket *string `location:"querystring" locationName:"bucket" min:"3" type:"string"`

	// The maximum number of access points that you want to include in the list.
	// If the specified bucket has more than this number of access points, then
	// the response will include a continuation token in the NextToken field that
	// you can use to retrieve the next page of access points.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// A continuation token. If a previous call to ListAccessPoints returned a continuation
	// token in the NextToken field, then providing that value here causes Amazon
	// S3 to retrieve the next page of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s ListAccessPointsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAccessPointsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAccessPointsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAccessPointsInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.Bucket != nil && len(*s.Bucket) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 3))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *ListAccessPointsInput) SetAccountId(v string) *ListAccessPointsInput {
	s.AccountId = &v
	return s
}

// SetBucket sets the Bucket field's value.
func (s *ListAccessPointsInput) SetBucket(v string) *ListAccessPointsInput {
	s.Bucket = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAccessPointsInput) SetMaxResults(v int64) *ListAccessPointsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAccessPointsInput) SetNextToken(v string) *ListAccessPointsInput {
	s.NextToken = &v
	return s
}

func (s *ListAccessPointsInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

func (s *ListAccessPointsInput) getEndpointARN() (arn.Resource, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	return parseEndpointARN(*s.Bucket)
}

func (s *ListAccessPointsInput) hasEndpointARN() bool {
	if s.Bucket == nil {
		return false
	}
	return arn.IsARN(*s.Bucket)
}

// updateArnableField updates the value of the input field that
// takes an ARN as an input. This method is useful to backfill
// the parsed resource name from ARN into the input member.
// It returns a pointer to a modified copy of input and an error.
// Note that original input is not modified.
func (s ListAccessPointsInput) updateArnableField(v string) (interface{}, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	s.Bucket = aws.String(v)
	return &s, nil
}

// updateAccountID returns a pointer to a modified copy of input,
// if account id is not provided, we update the account id in modified input
// if account id is provided, but doesn't match with the one in ARN, we throw an error
// if account id is not updated, we return nil. Note that original input is not modified.
func (s ListAccessPointsInput) updateAccountID(accountId string) (interface{}, error) {
	if s.AccountId == nil {
		s.AccountId = aws.String(accountId)
		return &s, nil
	} else if *s.AccountId != accountId {
		return &s, fmt.Errorf("Account ID mismatch, the Account ID cannot be specified in an ARN and in the accountId field")
	}
	return nil, nil
}

type ListAccessPointsOutput struct {
	_ struct{} `type:"structure"`

	// Contains identification and configuration information for one or more access
	// points associated with the specified bucket.
	AccessPointList []*AccessPoint `locationNameList:"AccessPoint" type:"list"`

	// If the specified bucket has more access points than can be returned in one
	// call to this API, this field contains a continuation token that you can provide
	// in subsequent calls to this API to retrieve additional access points.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListAccessPointsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAccessPointsOutput) GoString() string {
	return s.String()
}

// SetAccessPointList sets the AccessPointList field's value.
func (s *ListAccessPointsOutput) SetAccessPointList(v []*AccessPoint) *ListAccessPointsOutput {
	s.AccessPointList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAccessPointsOutput) SetNextToken(v string) *ListAccessPointsOutput {
	s.NextToken = &v
	return s
}

type ListJobsInput struct {
	_ struct{} `locationName:"ListJobsRequest" type:"structure"`

	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// The List Jobs request returns jobs that match the statuses listed in this
	// element.
	JobStatuses []*string `location:"querystring" locationName:"jobStatuses" type:"list"`

	// The maximum number of jobs that Amazon S3 will include in the List Jobs response.
	// If there are more jobs than this number, the response will include a pagination
	// token in the NextToken field to enable you to retrieve the next page of results.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// A pagination token to request the next page of results. Use the token that
	// Amazon S3 returned in the NextToken element of the ListJobsResult from the
	// previous List Jobs request.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s ListJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListJobsInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *ListJobsInput) SetAccountId(v string) *ListJobsInput {
	s.AccountId = &v
	return s
}

// SetJobStatuses sets the JobStatuses field's value.
func (s *ListJobsInput) SetJobStatuses(v []*string) *ListJobsInput {
	s.JobStatuses = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListJobsInput) SetMaxResults(v int64) *ListJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListJobsInput) SetNextToken(v string) *ListJobsInput {
	s.NextToken = &v
	return s
}

func (s *ListJobsInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

type ListJobsOutput struct {
	_ struct{} `type:"structure"`

	// The list of current jobs and jobs that have ended within the last 30 days.
	Jobs []*JobListDescriptor `type:"list"`

	// If the List Jobs request produced more than the maximum number of results,
	// you can pass this value into a subsequent List Jobs request in order to retrieve
	// the next page of results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListJobsOutput) GoString() string {
	return s.String()
}

// SetJobs sets the Jobs field's value.
func (s *ListJobsOutput) SetJobs(v []*JobListDescriptor) *ListJobsOutput {
	s.Jobs = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListJobsOutput) SetNextToken(v string) *ListJobsOutput {
	s.NextToken = &v
	return s
}

type ListRegionalBucketsInput struct {
	_ struct{} `locationName:"ListRegionalBucketsRequest" type:"structure"`

	// The AWS account ID of the Outposts bucket.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`

	// The ID of the AWS Outposts.
	//
	// This is required by Amazon S3 on Outposts buckets.
	OutpostId *string `location:"header" locationName:"x-amz-outpost-id" min:"1" type:"string"`
}

// String returns the string representation
func (s ListRegionalBucketsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRegionalBucketsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRegionalBucketsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRegionalBucketsInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.OutpostId != nil && len(*s.OutpostId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OutpostId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *ListRegionalBucketsInput) SetAccountId(v string) *ListRegionalBucketsInput {
	s.AccountId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListRegionalBucketsInput) SetMaxResults(v int64) *ListRegionalBucketsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListRegionalBucketsInput) SetNextToken(v string) *ListRegionalBucketsInput {
	s.NextToken = &v
	return s
}

// SetOutpostId sets the OutpostId field's value.
func (s *ListRegionalBucketsInput) SetOutpostId(v string) *ListRegionalBucketsInput {
	s.OutpostId = &v
	return s
}

func (s *ListRegionalBucketsInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

func (s *ListRegionalBucketsInput) getOutpostID() (string, error) {
	if s.OutpostId == nil {
		return "", fmt.Errorf("member OutpostId is nil")
	}
	return *s.OutpostId, nil
}

func (s *ListRegionalBucketsInput) hasOutpostID() bool {
	if s.OutpostId == nil {
		return false
	}
	return true
}

type ListRegionalBucketsOutput struct {
	_ struct{} `type:"structure"`

	// NextToken is sent when isTruncated is true, which means there are more buckets
	// that can be listed. The next list requests to Amazon S3 can be continued
	// with this NextToken. NextToken is obfuscated and is not a real key.
	NextToken *string `min:"1" type:"string"`

	RegionalBucketList []*RegionalBucket `locationNameList:"RegionalBucket" type:"list"`
}

// String returns the string representation
func (s ListRegionalBucketsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRegionalBucketsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListRegionalBucketsOutput) SetNextToken(v string) *ListRegionalBucketsOutput {
	s.NextToken = &v
	return s
}

// SetRegionalBucketList sets the RegionalBucketList field's value.
func (s *ListRegionalBucketsOutput) SetRegionalBucketList(v []*RegionalBucket) *ListRegionalBucketsOutput {
	s.RegionalBucketList = v
	return s
}

// Part of ListStorageLensConfigurationResult. Each entry includes the description
// of the S3 Storage Lens configuration, its home Region, whether it is enabled,
// its Amazon Resource Name (ARN), and config ID.
type ListStorageLensConfigurationEntry struct {
	_ struct{} `type:"structure"`

	// A container for the S3 Storage Lens home Region. Your metrics data is stored
	// and retained in your designated S3 Storage Lens home Region.
	//
	// HomeRegion is a required field
	HomeRegion *string `min:"5" type:"string" required:"true"`

	// A container for the S3 Storage Lens configuration ID.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`

	// A container for whether the S3 Storage Lens configuration is enabled. This
	// property is required.
	IsEnabled *bool `type:"boolean"`

	// The ARN of the S3 Storage Lens configuration. This property is read-only.
	//
	// StorageLensArn is a required field
	StorageLensArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListStorageLensConfigurationEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListStorageLensConfigurationEntry) GoString() string {
	return s.String()
}

// SetHomeRegion sets the HomeRegion field's value.
func (s *ListStorageLensConfigurationEntry) SetHomeRegion(v string) *ListStorageLensConfigurationEntry {
	s.HomeRegion = &v
	return s
}

// SetId sets the Id field's value.
func (s *ListStorageLensConfigurationEntry) SetId(v string) *ListStorageLensConfigurationEntry {
	s.Id = &v
	return s
}

// SetIsEnabled sets the IsEnabled field's value.
func (s *ListStorageLensConfigurationEntry) SetIsEnabled(v bool) *ListStorageLensConfigurationEntry {
	s.IsEnabled = &v
	return s
}

// SetStorageLensArn sets the StorageLensArn field's value.
func (s *ListStorageLensConfigurationEntry) SetStorageLensArn(v string) *ListStorageLensConfigurationEntry {
	s.StorageLensArn = &v
	return s
}

type ListStorageLensConfigurationsInput struct {
	_ struct{} `locationName:"ListStorageLensConfigurationsRequest" type:"structure"`

	// The account ID of the requester.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// A pagination token to request the next page of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListStorageLensConfigurationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListStorageLensConfigurationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListStorageLensConfigurationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListStorageLensConfigurationsInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *ListStorageLensConfigurationsInput) SetAccountId(v string) *ListStorageLensConfigurationsInput {
	s.AccountId = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListStorageLensConfigurationsInput) SetNextToken(v string) *ListStorageLensConfigurationsInput {
	s.NextToken = &v
	return s
}

func (s *ListStorageLensConfigurationsInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

type ListStorageLensConfigurationsOutput struct {
	_ struct{} `type:"structure"`

	// If the request produced more than the maximum number of S3 Storage Lens configuration
	// results, you can pass this value into a subsequent request to retrieve the
	// next page of results.
	NextToken *string `type:"string"`

	// A list of S3 Storage Lens configurations.
	StorageLensConfigurationList []*ListStorageLensConfigurationEntry `locationNameList:"StorageLensConfiguration" type:"list" flattened:"true"`
}

// String returns the string representation
func (s ListStorageLensConfigurationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListStorageLensConfigurationsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListStorageLensConfigurationsOutput) SetNextToken(v string) *ListStorageLensConfigurationsOutput {
	s.NextToken = &v
	return s
}

// SetStorageLensConfigurationList sets the StorageLensConfigurationList field's value.
func (s *ListStorageLensConfigurationsOutput) SetStorageLensConfigurationList(v []*ListStorageLensConfigurationEntry) *ListStorageLensConfigurationsOutput {
	s.StorageLensConfigurationList = v
	return s
}

// The container of the noncurrent version expiration.
type NoncurrentVersionExpiration struct {
	_ struct{} `type:"structure"`

	// Specifies the number of days an object is noncurrent before Amazon S3 can
	// perform the associated action. For information about the noncurrent days
	// calculations, see How Amazon S3 Calculates When an Object Became Noncurrent
	// (https://docs.aws.amazon.com/AmazonS3/latest/dev/intro-lifecycle-rules.html#non-current-days-calculations)
	// in the Amazon Simple Storage Service Developer Guide.
	NoncurrentDays *int64 `type:"integer"`
}

// String returns the string representation
func (s NoncurrentVersionExpiration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NoncurrentVersionExpiration) GoString() string {
	return s.String()
}

// SetNoncurrentDays sets the NoncurrentDays field's value.
func (s *NoncurrentVersionExpiration) SetNoncurrentDays(v int64) *NoncurrentVersionExpiration {
	s.NoncurrentDays = &v
	return s
}

// The container for the noncurrent version transition.
type NoncurrentVersionTransition struct {
	_ struct{} `type:"structure"`

	// Specifies the number of days an object is noncurrent before Amazon S3 can
	// perform the associated action. For information about the noncurrent days
	// calculations, see How Amazon S3 Calculates How Long an Object Has Been Noncurrent
	// (https://docs.aws.amazon.com/AmazonS3/latest/dev/intro-lifecycle-rules.html#non-current-days-calculations)
	// in the Amazon Simple Storage Service Developer Guide.
	NoncurrentDays *int64 `type:"integer"`

	// The class of storage used to store the object.
	StorageClass *string `type:"string" enum:"TransitionStorageClass"`
}

// String returns the string representation
func (s NoncurrentVersionTransition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NoncurrentVersionTransition) GoString() string {
	return s.String()
}

// SetNoncurrentDays sets the NoncurrentDays field's value.
func (s *NoncurrentVersionTransition) SetNoncurrentDays(v int64) *NoncurrentVersionTransition {
	s.NoncurrentDays = &v
	return s
}

// SetStorageClass sets the StorageClass field's value.
func (s *NoncurrentVersionTransition) SetStorageClass(v string) *NoncurrentVersionTransition {
	s.StorageClass = &v
	return s
}

// Indicates whether this access point policy is public. For more information
// about how Amazon S3 evaluates policies to determine whether they are public,
// see The Meaning of "Public" (https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status)
// in the Amazon Simple Storage Service Developer Guide.
type PolicyStatus struct {
	_ struct{} `type:"structure"`

	IsPublic *bool `locationName:"IsPublic" type:"boolean"`
}

// String returns the string representation
func (s PolicyStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PolicyStatus) GoString() string {
	return s.String()
}

// SetIsPublic sets the IsPublic field's value.
func (s *PolicyStatus) SetIsPublic(v bool) *PolicyStatus {
	s.IsPublic = &v
	return s
}

// A container for the prefix-level configuration.
type PrefixLevel struct {
	_ struct{} `type:"structure"`

	// A container for the prefix-level storage metrics for S3 Storage Lens.
	//
	// StorageMetrics is a required field
	StorageMetrics *PrefixLevelStorageMetrics `type:"structure" required:"true"`
}

// String returns the string representation
func (s PrefixLevel) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PrefixLevel) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PrefixLevel) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PrefixLevel"}
	if s.StorageMetrics == nil {
		invalidParams.Add(request.NewErrParamRequired("StorageMetrics"))
	}
	if s.StorageMetrics != nil {
		if err := s.StorageMetrics.Validate(); err != nil {
			invalidParams.AddNested("StorageMetrics", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStorageMetrics sets the StorageMetrics field's value.
func (s *PrefixLevel) SetStorageMetrics(v *PrefixLevelStorageMetrics) *PrefixLevel {
	s.StorageMetrics = v
	return s
}

// A container for the prefix-level storage metrics for S3 Storage Lens.
type PrefixLevelStorageMetrics struct {
	_ struct{} `type:"structure"`

	// A container for whether prefix-level storage metrics are enabled.
	IsEnabled *bool `type:"boolean"`

	SelectionCriteria *SelectionCriteria `type:"structure"`
}

// String returns the string representation
func (s PrefixLevelStorageMetrics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PrefixLevelStorageMetrics) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PrefixLevelStorageMetrics) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PrefixLevelStorageMetrics"}
	if s.SelectionCriteria != nil {
		if err := s.SelectionCriteria.Validate(); err != nil {
			invalidParams.AddNested("SelectionCriteria", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIsEnabled sets the IsEnabled field's value.
func (s *PrefixLevelStorageMetrics) SetIsEnabled(v bool) *PrefixLevelStorageMetrics {
	s.IsEnabled = &v
	return s
}

// SetSelectionCriteria sets the SelectionCriteria field's value.
func (s *PrefixLevelStorageMetrics) SetSelectionCriteria(v *SelectionCriteria) *PrefixLevelStorageMetrics {
	s.SelectionCriteria = v
	return s
}

// The PublicAccessBlock configuration that you want to apply to this Amazon
// S3 account. You can enable the configuration options in any combination.
// For more information about when Amazon S3 considers a bucket or object public,
// see The Meaning of "Public" (https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status)
// in the Amazon Simple Storage Service Developer Guide.
//
// This is not supported for Amazon S3 on Outposts.
type PublicAccessBlockConfiguration struct {
	_ struct{} `type:"structure"`

	// Specifies whether Amazon S3 should block public access control lists (ACLs)
	// for buckets in this account. Setting this element to TRUE causes the following
	// behavior:
	//
	//    * PUT Bucket acl and PUT Object acl calls fail if the specified ACL is
	//    public.
	//
	//    * PUT Object calls fail if the request includes a public ACL.
	//
	//    * PUT Bucket calls fail if the request includes a public ACL.
	//
	// Enabling this setting doesn't affect existing policies or ACLs.
	//
	// This is not supported for Amazon S3 on Outposts.
	BlockPublicAcls *bool `locationName:"BlockPublicAcls" type:"boolean"`

	// Specifies whether Amazon S3 should block public bucket policies for buckets
	// in this account. Setting this element to TRUE causes Amazon S3 to reject
	// calls to PUT Bucket policy if the specified bucket policy allows public access.
	//
	// Enabling this setting doesn't affect existing bucket policies.
	//
	// This is not supported for Amazon S3 on Outposts.
	BlockPublicPolicy *bool `locationName:"BlockPublicPolicy" type:"boolean"`

	// Specifies whether Amazon S3 should ignore public ACLs for buckets in this
	// account. Setting this element to TRUE causes Amazon S3 to ignore all public
	// ACLs on buckets in this account and any objects that they contain.
	//
	// Enabling this setting doesn't affect the persistence of any existing ACLs
	// and doesn't prevent new public ACLs from being set.
	//
	// This is not supported for Amazon S3 on Outposts.
	IgnorePublicAcls *bool `locationName:"IgnorePublicAcls" type:"boolean"`

	// Specifies whether Amazon S3 should restrict public bucket policies for buckets
	// in this account. Setting this element to TRUE restricts access to buckets
	// with public policies to only AWS service principals and authorized users
	// within this account.
	//
	// Enabling this setting doesn't affect previously stored bucket policies, except
	// that public and cross-account access within any public bucket policy, including
	// non-public delegation to specific accounts, is blocked.
	//
	// This is not supported for Amazon S3 on Outposts.
	RestrictPublicBuckets *bool `locationName:"RestrictPublicBuckets" type:"boolean"`
}

// String returns the string representation
func (s PublicAccessBlockConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PublicAccessBlockConfiguration) GoString() string {
	return s.String()
}

// SetBlockPublicAcls sets the BlockPublicAcls field's value.
func (s *PublicAccessBlockConfiguration) SetBlockPublicAcls(v bool) *PublicAccessBlockConfiguration {
	s.BlockPublicAcls = &v
	return s
}

// SetBlockPublicPolicy sets the BlockPublicPolicy field's value.
func (s *PublicAccessBlockConfiguration) SetBlockPublicPolicy(v bool) *PublicAccessBlockConfiguration {
	s.BlockPublicPolicy = &v
	return s
}

// SetIgnorePublicAcls sets the IgnorePublicAcls field's value.
func (s *PublicAccessBlockConfiguration) SetIgnorePublicAcls(v bool) *PublicAccessBlockConfiguration {
	s.IgnorePublicAcls = &v
	return s
}

// SetRestrictPublicBuckets sets the RestrictPublicBuckets field's value.
func (s *PublicAccessBlockConfiguration) SetRestrictPublicBuckets(v bool) *PublicAccessBlockConfiguration {
	s.RestrictPublicBuckets = &v
	return s
}

type PutAccessPointPolicyInput struct {
	_ struct{} `locationName:"PutAccessPointPolicyRequest" type:"structure" xmlURI:"http://awss3control.amazonaws.com/doc/2018-08-20/"`

	// The AWS account ID for owner of the bucket associated with the specified
	// access point.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// The name of the access point that you want to associate with the specified
	// policy.
	//
	// For using this parameter with Amazon S3 on Outposts with the REST API, you
	// must specify the name and the x-amz-outpost-id as well.
	//
	// For using this parameter with S3 on Outposts with the AWS SDK and CLI, you
	// must specify the ARN of the access point accessed in the format arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/accesspoint/<my-accesspoint-name>.
	// For example, to access the access point reports-ap through outpost my-outpost
	// owned by account 123456789012 in Region us-west-2, use the URL encoding of
	// arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/accesspoint/reports-ap.
	// The value must be URL encoded.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"3" type:"string" required:"true"`

	// The policy that you want to apply to the specified access point. For more
	// information about access point policies, see Managing data access with Amazon
	// S3 Access Points (https://docs.aws.amazon.com/AmazonS3/latest/dev/access-points.html)
	// in the Amazon Simple Storage Service Developer Guide.
	//
	// Policy is a required field
	Policy *string `type:"string" required:"true"`
}

// String returns the string representation
func (s PutAccessPointPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutAccessPointPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutAccessPointPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutAccessPointPolicyInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 3))
	}
	if s.Policy == nil {
		invalidParams.Add(request.NewErrParamRequired("Policy"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *PutAccessPointPolicyInput) SetAccountId(v string) *PutAccessPointPolicyInput {
	s.AccountId = &v
	return s
}

// SetName sets the Name field's value.
func (s *PutAccessPointPolicyInput) SetName(v string) *PutAccessPointPolicyInput {
	s.Name = &v
	return s
}

// SetPolicy sets the Policy field's value.
func (s *PutAccessPointPolicyInput) SetPolicy(v string) *PutAccessPointPolicyInput {
	s.Policy = &v
	return s
}

func (s *PutAccessPointPolicyInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

func (s *PutAccessPointPolicyInput) getEndpointARN() (arn.Resource, error) {
	if s.Name == nil {
		return nil, fmt.Errorf("member Name is nil")
	}
	return parseEndpointARN(*s.Name)
}

func (s *PutAccessPointPolicyInput) hasEndpointARN() bool {
	if s.Name == nil {
		return false
	}
	return arn.IsARN(*s.Name)
}

// updateArnableField updates the value of the input field that
// takes an ARN as an input. This method is useful to backfill
// the parsed resource name from ARN into the input member.
// It returns a pointer to a modified copy of input and an error.
// Note that original input is not modified.
func (s PutAccessPointPolicyInput) updateArnableField(v string) (interface{}, error) {
	if s.Name == nil {
		return nil, fmt.Errorf("member Name is nil")
	}
	s.Name = aws.String(v)
	return &s, nil
}

// updateAccountID returns a pointer to a modified copy of input,
// if account id is not provided, we update the account id in modified input
// if account id is provided, but doesn't match with the one in ARN, we throw an error
// if account id is not updated, we return nil. Note that original input is not modified.
func (s PutAccessPointPolicyInput) updateAccountID(accountId string) (interface{}, error) {
	if s.AccountId == nil {
		s.AccountId = aws.String(accountId)
		return &s, nil
	} else if *s.AccountId != accountId {
		return &s, fmt.Errorf("Account ID mismatch, the Account ID cannot be specified in an ARN and in the accountId field")
	}
	return nil, nil
}

type PutAccessPointPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutAccessPointPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutAccessPointPolicyOutput) GoString() string {
	return s.String()
}

type PutBucketLifecycleConfigurationInput struct {
	_ struct{} `locationName:"PutBucketLifecycleConfigurationRequest" type:"structure" payload:"LifecycleConfiguration"`

	// The AWS account ID of the Outposts bucket.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// The name of the bucket for which to set the configuration.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"name" min:"3" type:"string" required:"true"`

	// Container for lifecycle rules. You can add as many as 1,000 rules.
	LifecycleConfiguration *LifecycleConfiguration `locationName:"LifecycleConfiguration" type:"structure" xmlURI:"http://awss3control.amazonaws.com/doc/2018-08-20/"`
}

// String returns the string representation
func (s PutBucketLifecycleConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketLifecycleConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutBucketLifecycleConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutBucketLifecycleConfigurationInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 3))
	}
	if s.LifecycleConfiguration != nil {
		if err := s.LifecycleConfiguration.Validate(); err != nil {
			invalidParams.AddNested("LifecycleConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *PutBucketLifecycleConfigurationInput) SetAccountId(v string) *PutBucketLifecycleConfigurationInput {
	s.AccountId = &v
	return s
}

// SetBucket sets the Bucket field's value.
func (s *PutBucketLifecycleConfigurationInput) SetBucket(v string) *PutBucketLifecycleConfigurationInput {
	s.Bucket = &v
	return s
}

// SetLifecycleConfiguration sets the LifecycleConfiguration field's value.
func (s *PutBucketLifecycleConfigurationInput) SetLifecycleConfiguration(v *LifecycleConfiguration) *PutBucketLifecycleConfigurationInput {
	s.LifecycleConfiguration = v
	return s
}

func (s *PutBucketLifecycleConfigurationInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

func (s *PutBucketLifecycleConfigurationInput) getEndpointARN() (arn.Resource, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	return parseEndpointARN(*s.Bucket)
}

func (s *PutBucketLifecycleConfigurationInput) hasEndpointARN() bool {
	if s.Bucket == nil {
		return false
	}
	return arn.IsARN(*s.Bucket)
}

// updateArnableField updates the value of the input field that
// takes an ARN as an input. This method is useful to backfill
// the parsed resource name from ARN into the input member.
// It returns a pointer to a modified copy of input and an error.
// Note that original input is not modified.
func (s PutBucketLifecycleConfigurationInput) updateArnableField(v string) (interface{}, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	s.Bucket = aws.String(v)
	return &s, nil
}

// updateAccountID returns a pointer to a modified copy of input,
// if account id is not provided, we update the account id in modified input
// if account id is provided, but doesn't match with the one in ARN, we throw an error
// if account id is not updated, we return nil. Note that original input is not modified.
func (s PutBucketLifecycleConfigurationInput) updateAccountID(accountId string) (interface{}, error) {
	if s.AccountId == nil {
		s.AccountId = aws.String(accountId)
		return &s, nil
	} else if *s.AccountId != accountId {
		return &s, fmt.Errorf("Account ID mismatch, the Account ID cannot be specified in an ARN and in the accountId field")
	}
	return nil, nil
}

type PutBucketLifecycleConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutBucketLifecycleConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketLifecycleConfigurationOutput) GoString() string {
	return s.String()
}

type PutBucketPolicyInput struct {
	_ struct{} `locationName:"PutBucketPolicyRequest" type:"structure" xmlURI:"http://awss3control.amazonaws.com/doc/2018-08-20/"`

	// The AWS account ID of the Outposts bucket.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// Specifies the bucket.
	//
	// For using this parameter with Amazon S3 on Outposts with the REST API, you
	// must specify the name and the x-amz-outpost-id as well.
	//
	// For using this parameter with S3 on Outposts with the AWS SDK and CLI, you
	// must specify the ARN of the bucket accessed in the format arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/bucket/<my-bucket-name>.
	// For example, to access the bucket reports through outpost my-outpost owned
	// by account 123456789012 in Region us-west-2, use the URL encoding of arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports.
	// The value must be URL encoded.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"name" min:"3" type:"string" required:"true"`

	// Set this parameter to true to confirm that you want to remove your permissions
	// to change this bucket policy in the future.
	//
	// This is not supported by Amazon S3 on Outposts buckets.
	ConfirmRemoveSelfBucketAccess *bool `location:"header" locationName:"x-amz-confirm-remove-self-bucket-access" type:"boolean"`

	// The bucket policy as a JSON document.
	//
	// Policy is a required field
	Policy *string `type:"string" required:"true"`
}

// String returns the string representation
func (s PutBucketPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutBucketPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutBucketPolicyInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 3))
	}
	if s.Policy == nil {
		invalidParams.Add(request.NewErrParamRequired("Policy"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *PutBucketPolicyInput) SetAccountId(v string) *PutBucketPolicyInput {
	s.AccountId = &v
	return s
}

// SetBucket sets the Bucket field's value.
func (s *PutBucketPolicyInput) SetBucket(v string) *PutBucketPolicyInput {
	s.Bucket = &v
	return s
}

// SetConfirmRemoveSelfBucketAccess sets the ConfirmRemoveSelfBucketAccess field's value.
func (s *PutBucketPolicyInput) SetConfirmRemoveSelfBucketAccess(v bool) *PutBucketPolicyInput {
	s.ConfirmRemoveSelfBucketAccess = &v
	return s
}

// SetPolicy sets the Policy field's value.
func (s *PutBucketPolicyInput) SetPolicy(v string) *PutBucketPolicyInput {
	s.Policy = &v
	return s
}

func (s *PutBucketPolicyInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

func (s *PutBucketPolicyInput) getEndpointARN() (arn.Resource, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	return parseEndpointARN(*s.Bucket)
}

func (s *PutBucketPolicyInput) hasEndpointARN() bool {
	if s.Bucket == nil {
		return false
	}
	return arn.IsARN(*s.Bucket)
}

// updateArnableField updates the value of the input field that
// takes an ARN as an input. This method is useful to backfill
// the parsed resource name from ARN into the input member.
// It returns a pointer to a modified copy of input and an error.
// Note that original input is not modified.
func (s PutBucketPolicyInput) updateArnableField(v string) (interface{}, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	s.Bucket = aws.String(v)
	return &s, nil
}

// updateAccountID returns a pointer to a modified copy of input,
// if account id is not provided, we update the account id in modified input
// if account id is provided, but doesn't match with the one in ARN, we throw an error
// if account id is not updated, we return nil. Note that original input is not modified.
func (s PutBucketPolicyInput) updateAccountID(accountId string) (interface{}, error) {
	if s.AccountId == nil {
		s.AccountId = aws.String(accountId)
		return &s, nil
	} else if *s.AccountId != accountId {
		return &s, fmt.Errorf("Account ID mismatch, the Account ID cannot be specified in an ARN and in the accountId field")
	}
	return nil, nil
}

type PutBucketPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutBucketPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketPolicyOutput) GoString() string {
	return s.String()
}

type PutBucketTaggingInput struct {
	_ struct{} `locationName:"PutBucketTaggingRequest" type:"structure" payload:"Tagging"`

	// The AWS account ID of the Outposts bucket.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the bucket.
	//
	// For using this parameter with Amazon S3 on Outposts with the REST API, you
	// must specify the name and the x-amz-outpost-id as well.
	//
	// For using this parameter with S3 on Outposts with the AWS SDK and CLI, you
	// must specify the ARN of the bucket accessed in the format arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/bucket/<my-bucket-name>.
	// For example, to access the bucket reports through outpost my-outpost owned
	// by account 123456789012 in Region us-west-2, use the URL encoding of arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports.
	// The value must be URL encoded.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"name" min:"3" type:"string" required:"true"`

	// Tagging is a required field
	Tagging *Tagging `locationName:"Tagging" type:"structure" required:"true" xmlURI:"http://awss3control.amazonaws.com/doc/2018-08-20/"`
}

// String returns the string representation
func (s PutBucketTaggingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketTaggingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutBucketTaggingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutBucketTaggingInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 3))
	}
	if s.Tagging == nil {
		invalidParams.Add(request.NewErrParamRequired("Tagging"))
	}
	if s.Tagging != nil {
		if err := s.Tagging.Validate(); err != nil {
			invalidParams.AddNested("Tagging", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *PutBucketTaggingInput) SetAccountId(v string) *PutBucketTaggingInput {
	s.AccountId = &v
	return s
}

// SetBucket sets the Bucket field's value.
func (s *PutBucketTaggingInput) SetBucket(v string) *PutBucketTaggingInput {
	s.Bucket = &v
	return s
}

// SetTagging sets the Tagging field's value.
func (s *PutBucketTaggingInput) SetTagging(v *Tagging) *PutBucketTaggingInput {
	s.Tagging = v
	return s
}

func (s *PutBucketTaggingInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

func (s *PutBucketTaggingInput) getEndpointARN() (arn.Resource, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	return parseEndpointARN(*s.Bucket)
}

func (s *PutBucketTaggingInput) hasEndpointARN() bool {
	if s.Bucket == nil {
		return false
	}
	return arn.IsARN(*s.Bucket)
}

// updateArnableField updates the value of the input field that
// takes an ARN as an input. This method is useful to backfill
// the parsed resource name from ARN into the input member.
// It returns a pointer to a modified copy of input and an error.
// Note that original input is not modified.
func (s PutBucketTaggingInput) updateArnableField(v string) (interface{}, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	s.Bucket = aws.String(v)
	return &s, nil
}

// updateAccountID returns a pointer to a modified copy of input,
// if account id is not provided, we update the account id in modified input
// if account id is provided, but doesn't match with the one in ARN, we throw an error
// if account id is not updated, we return nil. Note that original input is not modified.
func (s PutBucketTaggingInput) updateAccountID(accountId string) (interface{}, error) {
	if s.AccountId == nil {
		s.AccountId = aws.String(accountId)
		return &s, nil
	} else if *s.AccountId != accountId {
		return &s, fmt.Errorf("Account ID mismatch, the Account ID cannot be specified in an ARN and in the accountId field")
	}
	return nil, nil
}

type PutBucketTaggingOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutBucketTaggingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketTaggingOutput) GoString() string {
	return s.String()
}

type PutJobTaggingInput struct {
	_ struct{} `locationName:"PutJobTaggingRequest" type:"structure" xmlURI:"http://awss3control.amazonaws.com/doc/2018-08-20/"`

	// The AWS account ID associated with the S3 Batch Operations job.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// The ID for the S3 Batch Operations job whose tags you want to replace.
	//
	// JobId is a required field
	JobId *string `location:"uri" locationName:"id" min:"5" type:"string" required:"true"`

	// The set of tags to associate with the S3 Batch Operations job.
	//
	// Tags is a required field
	Tags []*S3Tag `type:"list" required:"true"`
}

// String returns the string representation
func (s PutJobTaggingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutJobTaggingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutJobTaggingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutJobTaggingInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 5))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *PutJobTaggingInput) SetAccountId(v string) *PutJobTaggingInput {
	s.AccountId = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *PutJobTaggingInput) SetJobId(v string) *PutJobTaggingInput {
	s.JobId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *PutJobTaggingInput) SetTags(v []*S3Tag) *PutJobTaggingInput {
	s.Tags = v
	return s
}

func (s *PutJobTaggingInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

type PutJobTaggingOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutJobTaggingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutJobTaggingOutput) GoString() string {
	return s.String()
}

type PutPublicAccessBlockInput struct {
	_ struct{} `locationName:"PutPublicAccessBlockRequest" type:"structure" payload:"PublicAccessBlockConfiguration"`

	// The account ID for the AWS account whose PublicAccessBlock configuration
	// you want to set.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// The PublicAccessBlock configuration that you want to apply to the specified
	// AWS account.
	//
	// PublicAccessBlockConfiguration is a required field
	PublicAccessBlockConfiguration *PublicAccessBlockConfiguration `locationName:"PublicAccessBlockConfiguration" type:"structure" required:"true" xmlURI:"http://awss3control.amazonaws.com/doc/2018-08-20/"`
}

// String returns the string representation
func (s PutPublicAccessBlockInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutPublicAccessBlockInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutPublicAccessBlockInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutPublicAccessBlockInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.PublicAccessBlockConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("PublicAccessBlockConfiguration"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *PutPublicAccessBlockInput) SetAccountId(v string) *PutPublicAccessBlockInput {
	s.AccountId = &v
	return s
}

// SetPublicAccessBlockConfiguration sets the PublicAccessBlockConfiguration field's value.
func (s *PutPublicAccessBlockInput) SetPublicAccessBlockConfiguration(v *PublicAccessBlockConfiguration) *PutPublicAccessBlockInput {
	s.PublicAccessBlockConfiguration = v
	return s
}

func (s *PutPublicAccessBlockInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

type PutPublicAccessBlockOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutPublicAccessBlockOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutPublicAccessBlockOutput) GoString() string {
	return s.String()
}

type PutStorageLensConfigurationInput struct {
	_ struct{} `locationName:"PutStorageLensConfigurationRequest" type:"structure" xmlURI:"http://awss3control.amazonaws.com/doc/2018-08-20/"`

	// The account ID of the requester.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// The ID of the S3 Storage Lens configuration.
	//
	// ConfigId is a required field
	ConfigId *string `location:"uri" locationName:"storagelensid" min:"1" type:"string" required:"true"`

	// The S3 Storage Lens configuration.
	//
	// StorageLensConfiguration is a required field
	StorageLensConfiguration *StorageLensConfiguration `type:"structure" required:"true"`

	// The tag set of the S3 Storage Lens configuration.
	//
	// You can set up to a maximum of 50 tags.
	Tags []*StorageLensTag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s PutStorageLensConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutStorageLensConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutStorageLensConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutStorageLensConfigurationInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.ConfigId == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigId"))
	}
	if s.ConfigId != nil && len(*s.ConfigId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigId", 1))
	}
	if s.StorageLensConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("StorageLensConfiguration"))
	}
	if s.StorageLensConfiguration != nil {
		if err := s.StorageLensConfiguration.Validate(); err != nil {
			invalidParams.AddNested("StorageLensConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *PutStorageLensConfigurationInput) SetAccountId(v string) *PutStorageLensConfigurationInput {
	s.AccountId = &v
	return s
}

// SetConfigId sets the ConfigId field's value.
func (s *PutStorageLensConfigurationInput) SetConfigId(v string) *PutStorageLensConfigurationInput {
	s.ConfigId = &v
	return s
}

// SetStorageLensConfiguration sets the StorageLensConfiguration field's value.
func (s *PutStorageLensConfigurationInput) SetStorageLensConfiguration(v *StorageLensConfiguration) *PutStorageLensConfigurationInput {
	s.StorageLensConfiguration = v
	return s
}

// SetTags sets the Tags field's value.
func (s *PutStorageLensConfigurationInput) SetTags(v []*StorageLensTag) *PutStorageLensConfigurationInput {
	s.Tags = v
	return s
}

func (s *PutStorageLensConfigurationInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

type PutStorageLensConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutStorageLensConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutStorageLensConfigurationOutput) GoString() string {
	return s.String()
}

type PutStorageLensConfigurationTaggingInput struct {
	_ struct{} `locationName:"PutStorageLensConfigurationTaggingRequest" type:"structure" xmlURI:"http://awss3control.amazonaws.com/doc/2018-08-20/"`

	// The account ID of the requester.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// The ID of the S3 Storage Lens configuration.
	//
	// ConfigId is a required field
	ConfigId *string `location:"uri" locationName:"storagelensid" min:"1" type:"string" required:"true"`

	// The tag set of the S3 Storage Lens configuration.
	//
	// You can set up to a maximum of 50 tags.
	//
	// Tags is a required field
	Tags []*StorageLensTag `locationNameList:"Tag" type:"list" required:"true"`
}

// String returns the string representation
func (s PutStorageLensConfigurationTaggingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutStorageLensConfigurationTaggingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutStorageLensConfigurationTaggingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutStorageLensConfigurationTaggingInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.ConfigId == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigId"))
	}
	if s.ConfigId != nil && len(*s.ConfigId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigId", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *PutStorageLensConfigurationTaggingInput) SetAccountId(v string) *PutStorageLensConfigurationTaggingInput {
	s.AccountId = &v
	return s
}

// SetConfigId sets the ConfigId field's value.
func (s *PutStorageLensConfigurationTaggingInput) SetConfigId(v string) *PutStorageLensConfigurationTaggingInput {
	s.ConfigId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *PutStorageLensConfigurationTaggingInput) SetTags(v []*StorageLensTag) *PutStorageLensConfigurationTaggingInput {
	s.Tags = v
	return s
}

func (s *PutStorageLensConfigurationTaggingInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

type PutStorageLensConfigurationTaggingOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutStorageLensConfigurationTaggingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutStorageLensConfigurationTaggingOutput) GoString() string {
	return s.String()
}

// The container for the regional bucket.
type RegionalBucket struct {
	_ struct{} `type:"structure"`

	// Bucket is a required field
	Bucket *string `min:"3" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) for the regional bucket.
	BucketArn *string `min:"4" type:"string"`

	// The creation date of the regional bucket
	//
	// CreationDate is a required field
	CreationDate *time.Time `type:"timestamp" required:"true"`

	// The AWS Outposts ID of the regional bucket.
	OutpostId *string `min:"1" type:"string"`

	// PublicAccessBlockEnabled is a required field
	PublicAccessBlockEnabled *bool `type:"boolean" required:"true"`
}

// String returns the string representation
func (s RegionalBucket) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegionalBucket) GoString() string {
	return s.String()
}

// SetBucket sets the Bucket field's value.
func (s *RegionalBucket) SetBucket(v string) *RegionalBucket {
	s.Bucket = &v
	return s
}

// SetBucketArn sets the BucketArn field's value.
func (s *RegionalBucket) SetBucketArn(v string) *RegionalBucket {
	s.BucketArn = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *RegionalBucket) SetCreationDate(v time.Time) *RegionalBucket {
	s.CreationDate = &v
	return s
}

// SetOutpostId sets the OutpostId field's value.
func (s *RegionalBucket) SetOutpostId(v string) *RegionalBucket {
	s.OutpostId = &v
	return s
}

// SetPublicAccessBlockEnabled sets the PublicAccessBlockEnabled field's value.
func (s *RegionalBucket) SetPublicAccessBlockEnabled(v bool) *RegionalBucket {
	s.PublicAccessBlockEnabled = &v
	return s
}

type S3AccessControlList struct {
	_ struct{} `type:"structure"`

	Grants []*S3Grant `type:"list"`

	// Owner is a required field
	Owner *S3ObjectOwner `type:"structure" required:"true"`
}

// String returns the string representation
func (s S3AccessControlList) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3AccessControlList) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3AccessControlList) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3AccessControlList"}
	if s.Owner == nil {
		invalidParams.Add(request.NewErrParamRequired("Owner"))
	}
	if s.Grants != nil {
		for i, v := range s.Grants {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Grants", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Owner != nil {
		if err := s.Owner.Validate(); err != nil {
			invalidParams.AddNested("Owner", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGrants sets the Grants field's value.
func (s *S3AccessControlList) SetGrants(v []*S3Grant) *S3AccessControlList {
	s.Grants = v
	return s
}

// SetOwner sets the Owner field's value.
func (s *S3AccessControlList) SetOwner(v *S3ObjectOwner) *S3AccessControlList {
	s.Owner = v
	return s
}

type S3AccessControlPolicy struct {
	_ struct{} `type:"structure"`

	AccessControlList *S3AccessControlList `type:"structure"`

	CannedAccessControlList *string `type:"string" enum:"S3CannedAccessControlList"`
}

// String returns the string representation
func (s S3AccessControlPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3AccessControlPolicy) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3AccessControlPolicy) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3AccessControlPolicy"}
	if s.AccessControlList != nil {
		if err := s.AccessControlList.Validate(); err != nil {
			invalidParams.AddNested("AccessControlList", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessControlList sets the AccessControlList field's value.
func (s *S3AccessControlPolicy) SetAccessControlList(v *S3AccessControlList) *S3AccessControlPolicy {
	s.AccessControlList = v
	return s
}

// SetCannedAccessControlList sets the CannedAccessControlList field's value.
func (s *S3AccessControlPolicy) SetCannedAccessControlList(v string) *S3AccessControlPolicy {
	s.CannedAccessControlList = &v
	return s
}

// A container for the bucket where the Amazon S3 Storage Lens metrics export
// files are located.
type S3BucketDestination struct {
	_ struct{} `type:"structure"`

	// The account ID of the owner of the S3 Storage Lens metrics export bucket.
	//
	// AccountId is a required field
	AccountId *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the bucket. This property is read-only
	// and follows the following format: arn:aws:s3:us-east-1:example-account-id:bucket/your-destination-bucket-name
	//
	// Arn is a required field
	Arn *string `min:"1" type:"string" required:"true"`

	// The container for the type encryption of the metrics exports in this bucket.
	Encryption *StorageLensDataExportEncryption `type:"structure"`

	// Format is a required field
	Format *string `type:"string" required:"true" enum:"Format"`

	// The schema version of the export file.
	//
	// OutputSchemaVersion is a required field
	OutputSchemaVersion *string `type:"string" required:"true" enum:"OutputSchemaVersion"`

	// The prefix of the destination bucket where the metrics export will be delivered.
	Prefix *string `type:"string"`
}

// String returns the string representation
func (s S3BucketDestination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3BucketDestination) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3BucketDestination) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3BucketDestination"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 1))
	}
	if s.Format == nil {
		invalidParams.Add(request.NewErrParamRequired("Format"))
	}
	if s.OutputSchemaVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputSchemaVersion"))
	}
	if s.Encryption != nil {
		if err := s.Encryption.Validate(); err != nil {
			invalidParams.AddNested("Encryption", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *S3BucketDestination) SetAccountId(v string) *S3BucketDestination {
	s.AccountId = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *S3BucketDestination) SetArn(v string) *S3BucketDestination {
	s.Arn = &v
	return s
}

// SetEncryption sets the Encryption field's value.
func (s *S3BucketDestination) SetEncryption(v *StorageLensDataExportEncryption) *S3BucketDestination {
	s.Encryption = v
	return s
}

// SetFormat sets the Format field's value.
func (s *S3BucketDestination) SetFormat(v string) *S3BucketDestination {
	s.Format = &v
	return s
}

// SetOutputSchemaVersion sets the OutputSchemaVersion field's value.
func (s *S3BucketDestination) SetOutputSchemaVersion(v string) *S3BucketDestination {
	s.OutputSchemaVersion = &v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *S3BucketDestination) SetPrefix(v string) *S3BucketDestination {
	s.Prefix = &v
	return s
}

// Contains the configuration parameters for a PUT Copy object operation. S3
// Batch Operations passes every object to the underlying PUT Copy object API.
// For more information about the parameters for this operation, see PUT Object
// - Copy (https://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectCOPY.html).
type S3CopyObjectOperation struct {
	_ struct{} `type:"structure"`

	AccessControlGrants []*S3Grant `type:"list"`

	CannedAccessControlList *string `type:"string" enum:"S3CannedAccessControlList"`

	MetadataDirective *string `type:"string" enum:"S3MetadataDirective"`

	ModifiedSinceConstraint *time.Time `type:"timestamp"`

	NewObjectMetadata *S3ObjectMetadata `type:"structure"`

	NewObjectTagging []*S3Tag `type:"list"`

	// The legal hold status to be applied to all objects in the Batch Operations
	// job.
	ObjectLockLegalHoldStatus *string `type:"string" enum:"S3ObjectLockLegalHoldStatus"`

	// The retention mode to be applied to all objects in the Batch Operations job.
	ObjectLockMode *string `type:"string" enum:"S3ObjectLockMode"`

	// The date when the applied object retention configuration expires on all objects
	// in the Batch Operations job.
	ObjectLockRetainUntilDate *time.Time `type:"timestamp"`

	// Specifies an optional metadata property for website redirects, x-amz-website-redirect-location.
	// Allows webpage redirects if the object is accessed through a website endpoint.
	RedirectLocation *string `min:"1" type:"string"`

	RequesterPays *bool `type:"boolean"`

	SSEAwsKmsKeyId *string `min:"1" type:"string"`

	StorageClass *string `type:"string" enum:"S3StorageClass"`

	// Specifies the folder prefix into which you would like the objects to be copied.
	// For example, to copy objects into a folder named "Folder1" in the destination
	// bucket, set the TargetKeyPrefix to "Folder1/".
	TargetKeyPrefix *string `min:"1" type:"string"`

	// Specifies the destination bucket ARN for the batch copy operation. For example,
	// to copy objects to a bucket named "destinationBucket", set the TargetResource
	// to "arn:aws:s3:::destinationBucket".
	TargetResource *string `min:"1" type:"string"`

	UnModifiedSinceConstraint *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s S3CopyObjectOperation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3CopyObjectOperation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3CopyObjectOperation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3CopyObjectOperation"}
	if s.RedirectLocation != nil && len(*s.RedirectLocation) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RedirectLocation", 1))
	}
	if s.SSEAwsKmsKeyId != nil && len(*s.SSEAwsKmsKeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SSEAwsKmsKeyId", 1))
	}
	if s.TargetKeyPrefix != nil && len(*s.TargetKeyPrefix) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TargetKeyPrefix", 1))
	}
	if s.TargetResource != nil && len(*s.TargetResource) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TargetResource", 1))
	}
	if s.AccessControlGrants != nil {
		for i, v := range s.AccessControlGrants {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AccessControlGrants", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.NewObjectMetadata != nil {
		if err := s.NewObjectMetadata.Validate(); err != nil {
			invalidParams.AddNested("NewObjectMetadata", err.(request.ErrInvalidParams))
		}
	}
	if s.NewObjectTagging != nil {
		for i, v := range s.NewObjectTagging {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "NewObjectTagging", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessControlGrants sets the AccessControlGrants field's value.
func (s *S3CopyObjectOperation) SetAccessControlGrants(v []*S3Grant) *S3CopyObjectOperation {
	s.AccessControlGrants = v
	return s
}

// SetCannedAccessControlList sets the CannedAccessControlList field's value.
func (s *S3CopyObjectOperation) SetCannedAccessControlList(v string) *S3CopyObjectOperation {
	s.CannedAccessControlList = &v
	return s
}

// SetMetadataDirective sets the MetadataDirective field's value.
func (s *S3CopyObjectOperation) SetMetadataDirective(v string) *S3CopyObjectOperation {
	s.MetadataDirective = &v
	return s
}

// SetModifiedSinceConstraint sets the ModifiedSinceConstraint field's value.
func (s *S3CopyObjectOperation) SetModifiedSinceConstraint(v time.Time) *S3CopyObjectOperation {
	s.ModifiedSinceConstraint = &v
	return s
}

// SetNewObjectMetadata sets the NewObjectMetadata field's value.
func (s *S3CopyObjectOperation) SetNewObjectMetadata(v *S3ObjectMetadata) *S3CopyObjectOperation {
	s.NewObjectMetadata = v
	return s
}

// SetNewObjectTagging sets the NewObjectTagging field's value.
func (s *S3CopyObjectOperation) SetNewObjectTagging(v []*S3Tag) *S3CopyObjectOperation {
	s.NewObjectTagging = v
	return s
}

// SetObjectLockLegalHoldStatus sets the ObjectLockLegalHoldStatus field's value.
func (s *S3CopyObjectOperation) SetObjectLockLegalHoldStatus(v string) *S3CopyObjectOperation {
	s.ObjectLockLegalHoldStatus = &v
	return s
}

// SetObjectLockMode sets the ObjectLockMode field's value.
func (s *S3CopyObjectOperation) SetObjectLockMode(v string) *S3CopyObjectOperation {
	s.ObjectLockMode = &v
	return s
}

// SetObjectLockRetainUntilDate sets the ObjectLockRetainUntilDate field's value.
func (s *S3CopyObjectOperation) SetObjectLockRetainUntilDate(v time.Time) *S3CopyObjectOperation {
	s.ObjectLockRetainUntilDate = &v
	return s
}

// SetRedirectLocation sets the RedirectLocation field's value.
func (s *S3CopyObjectOperation) SetRedirectLocation(v string) *S3CopyObjectOperation {
	s.RedirectLocation = &v
	return s
}

// SetRequesterPays sets the RequesterPays field's value.
func (s *S3CopyObjectOperation) SetRequesterPays(v bool) *S3CopyObjectOperation {
	s.RequesterPays = &v
	return s
}

// SetSSEAwsKmsKeyId sets the SSEAwsKmsKeyId field's value.
func (s *S3CopyObjectOperation) SetSSEAwsKmsKeyId(v string) *S3CopyObjectOperation {
	s.SSEAwsKmsKeyId = &v
	return s
}

// SetStorageClass sets the StorageClass field's value.
func (s *S3CopyObjectOperation) SetStorageClass(v string) *S3CopyObjectOperation {
	s.StorageClass = &v
	return s
}

// SetTargetKeyPrefix sets the TargetKeyPrefix field's value.
func (s *S3CopyObjectOperation) SetTargetKeyPrefix(v string) *S3CopyObjectOperation {
	s.TargetKeyPrefix = &v
	return s
}

// SetTargetResource sets the TargetResource field's value.
func (s *S3CopyObjectOperation) SetTargetResource(v string) *S3CopyObjectOperation {
	s.TargetResource = &v
	return s
}

// SetUnModifiedSinceConstraint sets the UnModifiedSinceConstraint field's value.
func (s *S3CopyObjectOperation) SetUnModifiedSinceConstraint(v time.Time) *S3CopyObjectOperation {
	s.UnModifiedSinceConstraint = &v
	return s
}

type S3Grant struct {
	_ struct{} `type:"structure"`

	Grantee *S3Grantee `type:"structure"`

	Permission *string `type:"string" enum:"S3Permission"`
}

// String returns the string representation
func (s S3Grant) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3Grant) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3Grant) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3Grant"}
	if s.Grantee != nil {
		if err := s.Grantee.Validate(); err != nil {
			invalidParams.AddNested("Grantee", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGrantee sets the Grantee field's value.
func (s *S3Grant) SetGrantee(v *S3Grantee) *S3Grant {
	s.Grantee = v
	return s
}

// SetPermission sets the Permission field's value.
func (s *S3Grant) SetPermission(v string) *S3Grant {
	s.Permission = &v
	return s
}

type S3Grantee struct {
	_ struct{} `type:"structure"`

	DisplayName *string `min:"1" type:"string"`

	Identifier *string `min:"1" type:"string"`

	TypeIdentifier *string `type:"string" enum:"S3GranteeTypeIdentifier"`
}

// String returns the string representation
func (s S3Grantee) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3Grantee) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3Grantee) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3Grantee"}
	if s.DisplayName != nil && len(*s.DisplayName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DisplayName", 1))
	}
	if s.Identifier != nil && len(*s.Identifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Identifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDisplayName sets the DisplayName field's value.
func (s *S3Grantee) SetDisplayName(v string) *S3Grantee {
	s.DisplayName = &v
	return s
}

// SetIdentifier sets the Identifier field's value.
func (s *S3Grantee) SetIdentifier(v string) *S3Grantee {
	s.Identifier = &v
	return s
}

// SetTypeIdentifier sets the TypeIdentifier field's value.
func (s *S3Grantee) SetTypeIdentifier(v string) *S3Grantee {
	s.TypeIdentifier = &v
	return s
}

// Contains the configuration parameters for an S3 Initiate Restore Object job.
// S3 Batch Operations passes every object to the underlying POST Object restore
// API. For more information about the parameters for this operation, see RestoreObject
// (https://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectPOSTrestore.html#RESTObjectPOSTrestore-restore-request).
type S3InitiateRestoreObjectOperation struct {
	_ struct{} `type:"structure"`

	// This argument specifies how long the S3 Glacier or S3 Glacier Deep Archive
	// object remains available in Amazon S3. S3 Initiate Restore Object jobs that
	// target S3 Glacier and S3 Glacier Deep Archive objects require ExpirationInDays
	// set to 1 or greater.
	//
	// Conversely, do not set ExpirationInDays when creating S3 Initiate Restore
	// Object jobs that target S3 Intelligent-Tiering Archive Access and Deep Archive
	// Access tier objects. Objects in S3 Intelligent-Tiering archive access tiers
	// are not subject to restore expiry, so specifying ExpirationInDays results
	// in restore request failure.
	//
	// S3 Batch Operations jobs can operate either on S3 Glacier and S3 Glacier
	// Deep Archive storage class objects or on S3 Intelligent-Tiering Archive Access
	// and Deep Archive Access storage tier objects, but not both types in the same
	// job. If you need to restore objects of both types you must create separate
	// Batch Operations jobs.
	ExpirationInDays *int64 `type:"integer"`

	// S3 Batch Operations supports STANDARD and BULK retrieval tiers, but not the
	// EXPEDITED retrieval tier.
	GlacierJobTier *string `type:"string" enum:"S3GlacierJobTier"`
}

// String returns the string representation
func (s S3InitiateRestoreObjectOperation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3InitiateRestoreObjectOperation) GoString() string {
	return s.String()
}

// SetExpirationInDays sets the ExpirationInDays field's value.
func (s *S3InitiateRestoreObjectOperation) SetExpirationInDays(v int64) *S3InitiateRestoreObjectOperation {
	s.ExpirationInDays = &v
	return s
}

// SetGlacierJobTier sets the GlacierJobTier field's value.
func (s *S3InitiateRestoreObjectOperation) SetGlacierJobTier(v string) *S3InitiateRestoreObjectOperation {
	s.GlacierJobTier = &v
	return s
}

// Whether S3 Object Lock legal hold will be applied to objects in an S3 Batch
// Operations job.
type S3ObjectLockLegalHold struct {
	_ struct{} `type:"structure"`

	// The Object Lock legal hold status to be applied to all objects in the Batch
	// Operations job.
	//
	// Status is a required field
	Status *string `type:"string" required:"true" enum:"S3ObjectLockLegalHoldStatus"`
}

// String returns the string representation
func (s S3ObjectLockLegalHold) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3ObjectLockLegalHold) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3ObjectLockLegalHold) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3ObjectLockLegalHold"}
	if s.Status == nil {
		invalidParams.Add(request.NewErrParamRequired("Status"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStatus sets the Status field's value.
func (s *S3ObjectLockLegalHold) SetStatus(v string) *S3ObjectLockLegalHold {
	s.Status = &v
	return s
}

type S3ObjectMetadata struct {
	_ struct{} `type:"structure"`

	CacheControl *string `min:"1" type:"string"`

	ContentDisposition *string `min:"1" type:"string"`

	ContentEncoding *string `min:"1" type:"string"`

	ContentLanguage *string `min:"1" type:"string"`

	ContentLength *int64 `type:"long"`

	ContentMD5 *string `min:"1" type:"string"`

	ContentType *string `min:"1" type:"string"`

	HttpExpiresDate *time.Time `type:"timestamp"`

	RequesterCharged *bool `type:"boolean"`

	SSEAlgorithm *string `type:"string" enum:"S3SSEAlgorithm"`

	UserMetadata map[string]*string `type:"map"`
}

// String returns the string representation
func (s S3ObjectMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3ObjectMetadata) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3ObjectMetadata) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3ObjectMetadata"}
	if s.CacheControl != nil && len(*s.CacheControl) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CacheControl", 1))
	}
	if s.ContentDisposition != nil && len(*s.ContentDisposition) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContentDisposition", 1))
	}
	if s.ContentEncoding != nil && len(*s.ContentEncoding) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContentEncoding", 1))
	}
	if s.ContentLanguage != nil && len(*s.ContentLanguage) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContentLanguage", 1))
	}
	if s.ContentMD5 != nil && len(*s.ContentMD5) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContentMD5", 1))
	}
	if s.ContentType != nil && len(*s.ContentType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContentType", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCacheControl sets the CacheControl field's value.
func (s *S3ObjectMetadata) SetCacheControl(v string) *S3ObjectMetadata {
	s.CacheControl = &v
	return s
}

// SetContentDisposition sets the ContentDisposition field's value.
func (s *S3ObjectMetadata) SetContentDisposition(v string) *S3ObjectMetadata {
	s.ContentDisposition = &v
	return s
}

// SetContentEncoding sets the ContentEncoding field's value.
func (s *S3ObjectMetadata) SetContentEncoding(v string) *S3ObjectMetadata {
	s.ContentEncoding = &v
	return s
}

// SetContentLanguage sets the ContentLanguage field's value.
func (s *S3ObjectMetadata) SetContentLanguage(v string) *S3ObjectMetadata {
	s.ContentLanguage = &v
	return s
}

// SetContentLength sets the ContentLength field's value.
func (s *S3ObjectMetadata) SetContentLength(v int64) *S3ObjectMetadata {
	s.ContentLength = &v
	return s
}

// SetContentMD5 sets the ContentMD5 field's value.
func (s *S3ObjectMetadata) SetContentMD5(v string) *S3ObjectMetadata {
	s.ContentMD5 = &v
	return s
}

// SetContentType sets the ContentType field's value.
func (s *S3ObjectMetadata) SetContentType(v string) *S3ObjectMetadata {
	s.ContentType = &v
	return s
}

// SetHttpExpiresDate sets the HttpExpiresDate field's value.
func (s *S3ObjectMetadata) SetHttpExpiresDate(v time.Time) *S3ObjectMetadata {
	s.HttpExpiresDate = &v
	return s
}

// SetRequesterCharged sets the RequesterCharged field's value.
func (s *S3ObjectMetadata) SetRequesterCharged(v bool) *S3ObjectMetadata {
	s.RequesterCharged = &v
	return s
}

// SetSSEAlgorithm sets the SSEAlgorithm field's value.
func (s *S3ObjectMetadata) SetSSEAlgorithm(v string) *S3ObjectMetadata {
	s.SSEAlgorithm = &v
	return s
}

// SetUserMetadata sets the UserMetadata field's value.
func (s *S3ObjectMetadata) SetUserMetadata(v map[string]*string) *S3ObjectMetadata {
	s.UserMetadata = v
	return s
}

type S3ObjectOwner struct {
	_ struct{} `type:"structure"`

	DisplayName *string `min:"1" type:"string"`

	ID *string `min:"1" type:"string"`
}

// String returns the string representation
func (s S3ObjectOwner) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3ObjectOwner) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3ObjectOwner) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3ObjectOwner"}
	if s.DisplayName != nil && len(*s.DisplayName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DisplayName", 1))
	}
	if s.ID != nil && len(*s.ID) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ID", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDisplayName sets the DisplayName field's value.
func (s *S3ObjectOwner) SetDisplayName(v string) *S3ObjectOwner {
	s.DisplayName = &v
	return s
}

// SetID sets the ID field's value.
func (s *S3ObjectOwner) SetID(v string) *S3ObjectOwner {
	s.ID = &v
	return s
}

// Contains the S3 Object Lock retention mode to be applied to all objects in
// the S3 Batch Operations job. If you don't provide Mode and RetainUntilDate
// data types in your operation, you will remove the retention from your objects.
// For more information, see Using S3 Object Lock retention with S3 Batch Operations
// (https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-retention-date.html)
// in the Amazon Simple Storage Service Developer Guide.
type S3Retention struct {
	_ struct{} `type:"structure"`

	// The Object Lock retention mode to be applied to all objects in the Batch
	// Operations job.
	Mode *string `type:"string" enum:"S3ObjectLockRetentionMode"`

	// The date when the applied Object Lock retention will expire on all objects
	// set by the Batch Operations job.
	RetainUntilDate *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s S3Retention) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3Retention) GoString() string {
	return s.String()
}

// SetMode sets the Mode field's value.
func (s *S3Retention) SetMode(v string) *S3Retention {
	s.Mode = &v
	return s
}

// SetRetainUntilDate sets the RetainUntilDate field's value.
func (s *S3Retention) SetRetainUntilDate(v time.Time) *S3Retention {
	s.RetainUntilDate = &v
	return s
}

// Contains the configuration parameters for a Set Object ACL operation. S3
// Batch Operations passes every object to the underlying PUT Object acl API.
// For more information about the parameters for this operation, see PUT Object
// acl (https://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectPUTacl.html).
type S3SetObjectAclOperation struct {
	_ struct{} `type:"structure"`

	AccessControlPolicy *S3AccessControlPolicy `type:"structure"`
}

// String returns the string representation
func (s S3SetObjectAclOperation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3SetObjectAclOperation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3SetObjectAclOperation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3SetObjectAclOperation"}
	if s.AccessControlPolicy != nil {
		if err := s.AccessControlPolicy.Validate(); err != nil {
			invalidParams.AddNested("AccessControlPolicy", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessControlPolicy sets the AccessControlPolicy field's value.
func (s *S3SetObjectAclOperation) SetAccessControlPolicy(v *S3AccessControlPolicy) *S3SetObjectAclOperation {
	s.AccessControlPolicy = v
	return s
}

// Contains the configuration for an S3 Object Lock legal hold operation that
// an S3 Batch Operations job passes every object to the underlying PutObjectLegalHold
// API. For more information, see Using S3 Object Lock legal hold with S3 Batch
// Operations (https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-legal-hold.html)
// in the Amazon Simple Storage Service Developer Guide.
type S3SetObjectLegalHoldOperation struct {
	_ struct{} `type:"structure"`

	// Contains the Object Lock legal hold status to be applied to all objects in
	// the Batch Operations job.
	//
	// LegalHold is a required field
	LegalHold *S3ObjectLockLegalHold `type:"structure" required:"true"`
}

// String returns the string representation
func (s S3SetObjectLegalHoldOperation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3SetObjectLegalHoldOperation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3SetObjectLegalHoldOperation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3SetObjectLegalHoldOperation"}
	if s.LegalHold == nil {
		invalidParams.Add(request.NewErrParamRequired("LegalHold"))
	}
	if s.LegalHold != nil {
		if err := s.LegalHold.Validate(); err != nil {
			invalidParams.AddNested("LegalHold", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLegalHold sets the LegalHold field's value.
func (s *S3SetObjectLegalHoldOperation) SetLegalHold(v *S3ObjectLockLegalHold) *S3SetObjectLegalHoldOperation {
	s.LegalHold = v
	return s
}

// Contains the configuration parameters for the Object Lock retention action
// for an S3 Batch Operations job. Batch Operations passes every object to the
// underlying PutObjectRetention API. For more information, see Using S3 Object
// Lock retention with S3 Batch Operations (https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-retention-date.html)
// in the Amazon Simple Storage Service Developer Guide.
type S3SetObjectRetentionOperation struct {
	_ struct{} `type:"structure"`

	// Indicates if the action should be applied to objects in the Batch Operations
	// job even if they have Object Lock GOVERNANCE type in place.
	BypassGovernanceRetention *bool `type:"boolean"`

	// Contains the Object Lock retention mode to be applied to all objects in the
	// Batch Operations job. For more information, see Using S3 Object Lock retention
	// with S3 Batch Operations (https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-retention-date.html)
	// in the Amazon Simple Storage Service Developer Guide.
	//
	// Retention is a required field
	Retention *S3Retention `type:"structure" required:"true"`
}

// String returns the string representation
func (s S3SetObjectRetentionOperation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3SetObjectRetentionOperation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3SetObjectRetentionOperation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3SetObjectRetentionOperation"}
	if s.Retention == nil {
		invalidParams.Add(request.NewErrParamRequired("Retention"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBypassGovernanceRetention sets the BypassGovernanceRetention field's value.
func (s *S3SetObjectRetentionOperation) SetBypassGovernanceRetention(v bool) *S3SetObjectRetentionOperation {
	s.BypassGovernanceRetention = &v
	return s
}

// SetRetention sets the Retention field's value.
func (s *S3SetObjectRetentionOperation) SetRetention(v *S3Retention) *S3SetObjectRetentionOperation {
	s.Retention = v
	return s
}

// Contains the configuration parameters for a Set Object Tagging operation.
// S3 Batch Operations passes every object to the underlying PUT Object tagging
// API. For more information about the parameters for this operation, see PUT
// Object tagging (https://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectPUTtagging.html).
type S3SetObjectTaggingOperation struct {
	_ struct{} `type:"structure"`

	TagSet []*S3Tag `type:"list"`
}

// String returns the string representation
func (s S3SetObjectTaggingOperation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3SetObjectTaggingOperation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3SetObjectTaggingOperation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3SetObjectTaggingOperation"}
	if s.TagSet != nil {
		for i, v := range s.TagSet {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TagSet", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTagSet sets the TagSet field's value.
func (s *S3SetObjectTaggingOperation) SetTagSet(v []*S3Tag) *S3SetObjectTaggingOperation {
	s.TagSet = v
	return s
}

type S3Tag struct {
	_ struct{} `type:"structure"`

	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s S3Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *S3Tag) SetKey(v string) *S3Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *S3Tag) SetValue(v string) *S3Tag {
	s.Value = &v
	return s
}

type SSEKMS struct {
	_ struct{} `locationName:"SSE-KMS" type:"structure"`

	// A container for the ARN of the SSE-KMS encryption. This property is read-only
	// and follows the following format: arn:aws:kms:us-east-1:example-account-id:key/example-9a73-4afc-8d29-8f5900cef44e
	//
	// KeyId is a required field
	KeyId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s SSEKMS) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SSEKMS) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SSEKMS) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SSEKMS"}
	if s.KeyId == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKeyId sets the KeyId field's value.
func (s *SSEKMS) SetKeyId(v string) *SSEKMS {
	s.KeyId = &v
	return s
}

type SSES3 struct {
	_ struct{} `locationName:"SSE-S3" type:"structure"`
}

// String returns the string representation
func (s SSES3) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SSES3) GoString() string {
	return s.String()
}

type SelectionCriteria struct {
	_ struct{} `type:"structure"`

	// A container for the delimiter of the selection criteria being used.
	Delimiter *string `type:"string"`

	// The max depth of the selection criteria
	MaxDepth *int64 `min:"1" type:"integer"`

	// The minimum number of storage bytes percentage whose metrics will be selected.
	//
	// You must choose a value greater than or equal to 1.0.
	MinStorageBytesPercentage *float64 `min:"0.1" type:"double"`
}

// String returns the string representation
func (s SelectionCriteria) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SelectionCriteria) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SelectionCriteria) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SelectionCriteria"}
	if s.MaxDepth != nil && *s.MaxDepth < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxDepth", 1))
	}
	if s.MinStorageBytesPercentage != nil && *s.MinStorageBytesPercentage < 0.1 {
		invalidParams.Add(request.NewErrParamMinValue("MinStorageBytesPercentage", 0.1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDelimiter sets the Delimiter field's value.
func (s *SelectionCriteria) SetDelimiter(v string) *SelectionCriteria {
	s.Delimiter = &v
	return s
}

// SetMaxDepth sets the MaxDepth field's value.
func (s *SelectionCriteria) SetMaxDepth(v int64) *SelectionCriteria {
	s.MaxDepth = &v
	return s
}

// SetMinStorageBytesPercentage sets the MinStorageBytesPercentage field's value.
func (s *SelectionCriteria) SetMinStorageBytesPercentage(v float64) *SelectionCriteria {
	s.MinStorageBytesPercentage = &v
	return s
}

// The AWS organization for your S3 Storage Lens.
type StorageLensAwsOrg struct {
	_ struct{} `type:"structure"`

	// A container for the Amazon Resource Name (ARN) of the AWS organization. This
	// property is read-only and follows the following format: arn:aws:organizations:us-east-1:example-account-id:organization/o-ex2l495dck
	//
	// Arn is a required field
	Arn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StorageLensAwsOrg) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StorageLensAwsOrg) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StorageLensAwsOrg) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StorageLensAwsOrg"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *StorageLensAwsOrg) SetArn(v string) *StorageLensAwsOrg {
	s.Arn = &v
	return s
}

// A container for the Amazon S3 Storage Lens configuration.
type StorageLensConfiguration struct {
	_ struct{} `type:"structure"`

	// A container for all the account-level configurations of your S3 Storage Lens
	// configuration.
	//
	// AccountLevel is a required field
	AccountLevel *AccountLevel `type:"structure" required:"true"`

	// A container for the AWS organization for this S3 Storage Lens configuration.
	AwsOrg *StorageLensAwsOrg `type:"structure"`

	// A container to specify the properties of your S3 Storage Lens metrics export
	// including, the destination, schema and format.
	DataExport *StorageLensDataExport `type:"structure"`

	// A container for what is excluded in this configuration. This container can
	// only be valid if there is no Include container submitted, and it's not empty.
	Exclude *Exclude `type:"structure"`

	// A container for the Amazon S3 Storage Lens configuration ID.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`

	// A container for what is included in this configuration. This container can
	// only be valid if there is no Exclude container submitted, and it's not empty.
	Include *Include `type:"structure"`

	// A container for whether the S3 Storage Lens configuration is enabled.
	//
	// IsEnabled is a required field
	IsEnabled *bool `type:"boolean" required:"true"`

	// The Amazon Resource Name (ARN) of the S3 Storage Lens configuration. This
	// property is read-only and follows the following format: arn:aws:s3:us-east-1:example-account-id:storage-lens/your-dashboard-name
	StorageLensArn *string `min:"1" type:"string"`
}

// String returns the string representation
func (s StorageLensConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StorageLensConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StorageLensConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StorageLensConfiguration"}
	if s.AccountLevel == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountLevel"))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.IsEnabled == nil {
		invalidParams.Add(request.NewErrParamRequired("IsEnabled"))
	}
	if s.StorageLensArn != nil && len(*s.StorageLensArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StorageLensArn", 1))
	}
	if s.AccountLevel != nil {
		if err := s.AccountLevel.Validate(); err != nil {
			invalidParams.AddNested("AccountLevel", err.(request.ErrInvalidParams))
		}
	}
	if s.AwsOrg != nil {
		if err := s.AwsOrg.Validate(); err != nil {
			invalidParams.AddNested("AwsOrg", err.(request.ErrInvalidParams))
		}
	}
	if s.DataExport != nil {
		if err := s.DataExport.Validate(); err != nil {
			invalidParams.AddNested("DataExport", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountLevel sets the AccountLevel field's value.
func (s *StorageLensConfiguration) SetAccountLevel(v *AccountLevel) *StorageLensConfiguration {
	s.AccountLevel = v
	return s
}

// SetAwsOrg sets the AwsOrg field's value.
func (s *StorageLensConfiguration) SetAwsOrg(v *StorageLensAwsOrg) *StorageLensConfiguration {
	s.AwsOrg = v
	return s
}

// SetDataExport sets the DataExport field's value.
func (s *StorageLensConfiguration) SetDataExport(v *StorageLensDataExport) *StorageLensConfiguration {
	s.DataExport = v
	return s
}

// SetExclude sets the Exclude field's value.
func (s *StorageLensConfiguration) SetExclude(v *Exclude) *StorageLensConfiguration {
	s.Exclude = v
	return s
}

// SetId sets the Id field's value.
func (s *StorageLensConfiguration) SetId(v string) *StorageLensConfiguration {
	s.Id = &v
	return s
}

// SetInclude sets the Include field's value.
func (s *StorageLensConfiguration) SetInclude(v *Include) *StorageLensConfiguration {
	s.Include = v
	return s
}

// SetIsEnabled sets the IsEnabled field's value.
func (s *StorageLensConfiguration) SetIsEnabled(v bool) *StorageLensConfiguration {
	s.IsEnabled = &v
	return s
}

// SetStorageLensArn sets the StorageLensArn field's value.
func (s *StorageLensConfiguration) SetStorageLensArn(v string) *StorageLensConfiguration {
	s.StorageLensArn = &v
	return s
}

// A container to specify the properties of your S3 Storage Lens metrics export,
// including the destination, schema, and format.
type StorageLensDataExport struct {
	_ struct{} `type:"structure"`

	// A container for the bucket where the S3 Storage Lens metrics export will
	// be located.
	//
	// S3BucketDestination is a required field
	S3BucketDestination *S3BucketDestination `type:"structure" required:"true"`
}

// String returns the string representation
func (s StorageLensDataExport) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StorageLensDataExport) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StorageLensDataExport) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StorageLensDataExport"}
	if s.S3BucketDestination == nil {
		invalidParams.Add(request.NewErrParamRequired("S3BucketDestination"))
	}
	if s.S3BucketDestination != nil {
		if err := s.S3BucketDestination.Validate(); err != nil {
			invalidParams.AddNested("S3BucketDestination", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3BucketDestination sets the S3BucketDestination field's value.
func (s *StorageLensDataExport) SetS3BucketDestination(v *S3BucketDestination) *StorageLensDataExport {
	s.S3BucketDestination = v
	return s
}

// A container for the encryption of the S3 Storage Lens metrics exports.
type StorageLensDataExportEncryption struct {
	_ struct{} `type:"structure"`

	SSEKMS *SSEKMS `locationName:"SSE-KMS" type:"structure"`

	SSES3 *SSES3 `locationName:"SSE-S3" type:"structure"`
}

// String returns the string representation
func (s StorageLensDataExportEncryption) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StorageLensDataExportEncryption) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StorageLensDataExportEncryption) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StorageLensDataExportEncryption"}
	if s.SSEKMS != nil {
		if err := s.SSEKMS.Validate(); err != nil {
			invalidParams.AddNested("SSEKMS", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSSEKMS sets the SSEKMS field's value.
func (s *StorageLensDataExportEncryption) SetSSEKMS(v *SSEKMS) *StorageLensDataExportEncryption {
	s.SSEKMS = v
	return s
}

// SetSSES3 sets the SSES3 field's value.
func (s *StorageLensDataExportEncryption) SetSSES3(v *SSES3) *StorageLensDataExportEncryption {
	s.SSES3 = v
	return s
}

type StorageLensTag struct {
	_ struct{} `type:"structure"`

	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s StorageLensTag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StorageLensTag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StorageLensTag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StorageLensTag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *StorageLensTag) SetKey(v string) *StorageLensTag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *StorageLensTag) SetValue(v string) *StorageLensTag {
	s.Value = &v
	return s
}

type Tagging struct {
	_ struct{} `type:"structure"`

	// A collection for a set of tags.
	//
	// TagSet is a required field
	TagSet []*S3Tag `type:"list" required:"true"`
}

// String returns the string representation
func (s Tagging) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tagging) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tagging) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tagging"}
	if s.TagSet == nil {
		invalidParams.Add(request.NewErrParamRequired("TagSet"))
	}
	if s.TagSet != nil {
		for i, v := range s.TagSet {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TagSet", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTagSet sets the TagSet field's value.
func (s *Tagging) SetTagSet(v []*S3Tag) *Tagging {
	s.TagSet = v
	return s
}

// Specifies when an object transitions to a specified storage class. For more
// information about Amazon S3 Lifecycle configuration rules, see Transitioning
// objects using Amazon S3 Lifecycle (https://docs.aws.amazon.com/AmazonS3/latest/dev/lifecycle-transition-general-considerations.html)
// in the Amazon Simple Storage Service Developer Guide.
type Transition struct {
	_ struct{} `type:"structure"`

	// Indicates when objects are transitioned to the specified storage class. The
	// date value must be in ISO 8601 format. The time is always midnight UTC.
	Date *time.Time `type:"timestamp"`

	// Indicates the number of days after creation when objects are transitioned
	// to the specified storage class. The value must be a positive integer.
	Days *int64 `type:"integer"`

	// The storage class to which you want the object to transition.
	StorageClass *string `type:"string" enum:"TransitionStorageClass"`
}

// String returns the string representation
func (s Transition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Transition) GoString() string {
	return s.String()
}

// SetDate sets the Date field's value.
func (s *Transition) SetDate(v time.Time) *Transition {
	s.Date = &v
	return s
}

// SetDays sets the Days field's value.
func (s *Transition) SetDays(v int64) *Transition {
	s.Days = &v
	return s
}

// SetStorageClass sets the StorageClass field's value.
func (s *Transition) SetStorageClass(v string) *Transition {
	s.StorageClass = &v
	return s
}

type UpdateJobPriorityInput struct {
	_ struct{} `locationName:"UpdateJobPriorityRequest" type:"structure"`

	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// The ID for the job whose priority you want to update.
	//
	// JobId is a required field
	JobId *string `location:"uri" locationName:"id" min:"5" type:"string" required:"true"`

	// The priority you want to assign to this job.
	//
	// Priority is a required field
	Priority *int64 `location:"querystring" locationName:"priority" type:"integer" required:"true"`
}

// String returns the string representation
func (s UpdateJobPriorityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateJobPriorityInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateJobPriorityInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateJobPriorityInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 5))
	}
	if s.Priority == nil {
		invalidParams.Add(request.NewErrParamRequired("Priority"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *UpdateJobPriorityInput) SetAccountId(v string) *UpdateJobPriorityInput {
	s.AccountId = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *UpdateJobPriorityInput) SetJobId(v string) *UpdateJobPriorityInput {
	s.JobId = &v
	return s
}

// SetPriority sets the Priority field's value.
func (s *UpdateJobPriorityInput) SetPriority(v int64) *UpdateJobPriorityInput {
	s.Priority = &v
	return s
}

func (s *UpdateJobPriorityInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

type UpdateJobPriorityOutput struct {
	_ struct{} `type:"structure"`

	// The ID for the job whose priority Amazon S3 updated.
	//
	// JobId is a required field
	JobId *string `min:"5" type:"string" required:"true"`

	// The new priority assigned to the specified job.
	//
	// Priority is a required field
	Priority *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s UpdateJobPriorityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateJobPriorityOutput) GoString() string {
	return s.String()
}

// SetJobId sets the JobId field's value.
func (s *UpdateJobPriorityOutput) SetJobId(v string) *UpdateJobPriorityOutput {
	s.JobId = &v
	return s
}

// SetPriority sets the Priority field's value.
func (s *UpdateJobPriorityOutput) SetPriority(v int64) *UpdateJobPriorityOutput {
	s.Priority = &v
	return s
}

type UpdateJobStatusInput struct {
	_ struct{} `locationName:"UpdateJobStatusRequest" type:"structure"`

	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// The ID of the job whose status you want to update.
	//
	// JobId is a required field
	JobId *string `location:"uri" locationName:"id" min:"5" type:"string" required:"true"`

	// The status that you want to move the specified job to.
	//
	// RequestedJobStatus is a required field
	RequestedJobStatus *string `location:"querystring" locationName:"requestedJobStatus" type:"string" required:"true" enum:"RequestedJobStatus"`

	// A description of the reason why you want to change the specified job's status.
	// This field can be any string up to the maximum length.
	StatusUpdateReason *string `location:"querystring" locationName:"statusUpdateReason" min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateJobStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateJobStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateJobStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateJobStatusInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 5))
	}
	if s.RequestedJobStatus == nil {
		invalidParams.Add(request.NewErrParamRequired("RequestedJobStatus"))
	}
	if s.StatusUpdateReason != nil && len(*s.StatusUpdateReason) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StatusUpdateReason", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *UpdateJobStatusInput) SetAccountId(v string) *UpdateJobStatusInput {
	s.AccountId = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *UpdateJobStatusInput) SetJobId(v string) *UpdateJobStatusInput {
	s.JobId = &v
	return s
}

// SetRequestedJobStatus sets the RequestedJobStatus field's value.
func (s *UpdateJobStatusInput) SetRequestedJobStatus(v string) *UpdateJobStatusInput {
	s.RequestedJobStatus = &v
	return s
}

// SetStatusUpdateReason sets the StatusUpdateReason field's value.
func (s *UpdateJobStatusInput) SetStatusUpdateReason(v string) *UpdateJobStatusInput {
	s.StatusUpdateReason = &v
	return s
}

func (s *UpdateJobStatusInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

type UpdateJobStatusOutput struct {
	_ struct{} `type:"structure"`

	// The ID for the job whose status was updated.
	JobId *string `min:"5" type:"string"`

	// The current status for the specified job.
	Status *string `type:"string" enum:"JobStatus"`

	// The reason that the specified job's status was updated.
	StatusUpdateReason *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateJobStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateJobStatusOutput) GoString() string {
	return s.String()
}

// SetJobId sets the JobId field's value.
func (s *UpdateJobStatusOutput) SetJobId(v string) *UpdateJobStatusOutput {
	s.JobId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *UpdateJobStatusOutput) SetStatus(v string) *UpdateJobStatusOutput {
	s.Status = &v
	return s
}

// SetStatusUpdateReason sets the StatusUpdateReason field's value.
func (s *UpdateJobStatusOutput) SetStatusUpdateReason(v string) *UpdateJobStatusOutput {
	s.StatusUpdateReason = &v
	return s
}

// The virtual private cloud (VPC) configuration for an access point.
type VpcConfiguration struct {
	_ struct{} `type:"structure"`

	// If this field is specified, this access point will only allow connections
	// from the specified VPC ID.
	//
	// VpcId is a required field
	VpcId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s VpcConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VpcConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VpcConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VpcConfiguration"}
	if s.VpcId == nil {
		invalidParams.Add(request.NewErrParamRequired("VpcId"))
	}
	if s.VpcId != nil && len(*s.VpcId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VpcId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVpcId sets the VpcId field's value.
func (s *VpcConfiguration) SetVpcId(v string) *VpcConfiguration {
	s.VpcId = &v
	return s
}

const (
	// BucketCannedACLPrivate is a BucketCannedACL enum value
	BucketCannedACLPrivate = "private"

	// BucketCannedACLPublicRead is a BucketCannedACL enum value
	BucketCannedACLPublicRead = "public-read"

	// BucketCannedACLPublicReadWrite is a BucketCannedACL enum value
	BucketCannedACLPublicReadWrite = "public-read-write"

	// BucketCannedACLAuthenticatedRead is a BucketCannedACL enum value
	BucketCannedACLAuthenticatedRead = "authenticated-read"
)

// BucketCannedACL_Values returns all elements of the BucketCannedACL enum
func BucketCannedACL_Values() []string {
	return []string{
		BucketCannedACLPrivate,
		BucketCannedACLPublicRead,
		BucketCannedACLPublicReadWrite,
		BucketCannedACLAuthenticatedRead,
	}
}

const (
	// BucketLocationConstraintEu is a BucketLocationConstraint enum value
	BucketLocationConstraintEu = "EU"

	// BucketLocationConstraintEuWest1 is a BucketLocationConstraint enum value
	BucketLocationConstraintEuWest1 = "eu-west-1"

	// BucketLocationConstraintUsWest1 is a BucketLocationConstraint enum value
	BucketLocationConstraintUsWest1 = "us-west-1"

	// BucketLocationConstraintUsWest2 is a BucketLocationConstraint enum value
	BucketLocationConstraintUsWest2 = "us-west-2"

	// BucketLocationConstraintApSouth1 is a BucketLocationConstraint enum value
	BucketLocationConstraintApSouth1 = "ap-south-1"

	// BucketLocationConstraintApSoutheast1 is a BucketLocationConstraint enum value
	BucketLocationConstraintApSoutheast1 = "ap-southeast-1"

	// BucketLocationConstraintApSoutheast2 is a BucketLocationConstraint enum value
	BucketLocationConstraintApSoutheast2 = "ap-southeast-2"

	// BucketLocationConstraintApNortheast1 is a BucketLocationConstraint enum value
	BucketLocationConstraintApNortheast1 = "ap-northeast-1"

	// BucketLocationConstraintSaEast1 is a BucketLocationConstraint enum value
	BucketLocationConstraintSaEast1 = "sa-east-1"

	// BucketLocationConstraintCnNorth1 is a BucketLocationConstraint enum value
	BucketLocationConstraintCnNorth1 = "cn-north-1"

	// BucketLocationConstraintEuCentral1 is a BucketLocationConstraint enum value
	BucketLocationConstraintEuCentral1 = "eu-central-1"
)

// BucketLocationConstraint_Values returns all elements of the BucketLocationConstraint enum
func BucketLocationConstraint_Values() []string {
	return []string{
		BucketLocationConstraintEu,
		BucketLocationConstraintEuWest1,
		BucketLocationConstraintUsWest1,
		BucketLocationConstraintUsWest2,
		BucketLocationConstraintApSouth1,
		BucketLocationConstraintApSoutheast1,
		BucketLocationConstraintApSoutheast2,
		BucketLocationConstraintApNortheast1,
		BucketLocationConstraintSaEast1,
		BucketLocationConstraintCnNorth1,
		BucketLocationConstraintEuCentral1,
	}
}

const (
	// ExpirationStatusEnabled is a ExpirationStatus enum value
	ExpirationStatusEnabled = "Enabled"

	// ExpirationStatusDisabled is a ExpirationStatus enum value
	ExpirationStatusDisabled = "Disabled"
)

// ExpirationStatus_Values returns all elements of the ExpirationStatus enum
func ExpirationStatus_Values() []string {
	return []string{
		ExpirationStatusEnabled,
		ExpirationStatusDisabled,
	}
}

const (
	// FormatCsv is a Format enum value
	FormatCsv = "CSV"

	// FormatParquet is a Format enum value
	FormatParquet = "Parquet"
)

// Format_Values returns all elements of the Format enum
func Format_Values() []string {
	return []string{
		FormatCsv,
		FormatParquet,
	}
}

const (
	// JobManifestFieldNameIgnore is a JobManifestFieldName enum value
	JobManifestFieldNameIgnore = "Ignore"

	// JobManifestFieldNameBucket is a JobManifestFieldName enum value
	JobManifestFieldNameBucket = "Bucket"

	// JobManifestFieldNameKey is a JobManifestFieldName enum value
	JobManifestFieldNameKey = "Key"

	// JobManifestFieldNameVersionId is a JobManifestFieldName enum value
	JobManifestFieldNameVersionId = "VersionId"
)

// JobManifestFieldName_Values returns all elements of the JobManifestFieldName enum
func JobManifestFieldName_Values() []string {
	return []string{
		JobManifestFieldNameIgnore,
		JobManifestFieldNameBucket,
		JobManifestFieldNameKey,
		JobManifestFieldNameVersionId,
	}
}

const (
	// JobManifestFormatS3batchOperationsCsv20180820 is a JobManifestFormat enum value
	JobManifestFormatS3batchOperationsCsv20180820 = "S3BatchOperations_CSV_20180820"

	// JobManifestFormatS3inventoryReportCsv20161130 is a JobManifestFormat enum value
	JobManifestFormatS3inventoryReportCsv20161130 = "S3InventoryReport_CSV_20161130"
)

// JobManifestFormat_Values returns all elements of the JobManifestFormat enum
func JobManifestFormat_Values() []string {
	return []string{
		JobManifestFormatS3batchOperationsCsv20180820,
		JobManifestFormatS3inventoryReportCsv20161130,
	}
}

const (
	// JobReportFormatReportCsv20180820 is a JobReportFormat enum value
	JobReportFormatReportCsv20180820 = "Report_CSV_20180820"
)

// JobReportFormat_Values returns all elements of the JobReportFormat enum
func JobReportFormat_Values() []string {
	return []string{
		JobReportFormatReportCsv20180820,
	}
}

const (
	// JobReportScopeAllTasks is a JobReportScope enum value
	JobReportScopeAllTasks = "AllTasks"

	// JobReportScopeFailedTasksOnly is a JobReportScope enum value
	JobReportScopeFailedTasksOnly = "FailedTasksOnly"
)

// JobReportScope_Values returns all elements of the JobReportScope enum
func JobReportScope_Values() []string {
	return []string{
		JobReportScopeAllTasks,
		JobReportScopeFailedTasksOnly,
	}
}

const (
	// JobStatusActive is a JobStatus enum value
	JobStatusActive = "Active"

	// JobStatusCancelled is a JobStatus enum value
	JobStatusCancelled = "Cancelled"

	// JobStatusCancelling is a JobStatus enum value
	JobStatusCancelling = "Cancelling"

	// JobStatusComplete is a JobStatus enum value
	JobStatusComplete = "Complete"

	// JobStatusCompleting is a JobStatus enum value
	JobStatusCompleting = "Completing"

	// JobStatusFailed is a JobStatus enum value
	JobStatusFailed = "Failed"

	// JobStatusFailing is a JobStatus enum value
	JobStatusFailing = "Failing"

	// JobStatusNew is a JobStatus enum value
	JobStatusNew = "New"

	// JobStatusPaused is a JobStatus enum value
	JobStatusPaused = "Paused"

	// JobStatusPausing is a JobStatus enum value
	JobStatusPausing = "Pausing"

	// JobStatusPreparing is a JobStatus enum value
	JobStatusPreparing = "Preparing"

	// JobStatusReady is a JobStatus enum value
	JobStatusReady = "Ready"

	// JobStatusSuspended is a JobStatus enum value
	JobStatusSuspended = "Suspended"
)

// JobStatus_Values returns all elements of the JobStatus enum
func JobStatus_Values() []string {
	return []string{
		JobStatusActive,
		JobStatusCancelled,
		JobStatusCancelling,
		JobStatusComplete,
		JobStatusCompleting,
		JobStatusFailed,
		JobStatusFailing,
		JobStatusNew,
		JobStatusPaused,
		JobStatusPausing,
		JobStatusPreparing,
		JobStatusReady,
		JobStatusSuspended,
	}
}

const (
	// NetworkOriginInternet is a NetworkOrigin enum value
	NetworkOriginInternet = "Internet"

	// NetworkOriginVpc is a NetworkOrigin enum value
	NetworkOriginVpc = "VPC"
)

// NetworkOrigin_Values returns all elements of the NetworkOrigin enum
func NetworkOrigin_Values() []string {
	return []string{
		NetworkOriginInternet,
		NetworkOriginVpc,
	}
}

const (
	// OperationNameLambdaInvoke is a OperationName enum value
	OperationNameLambdaInvoke = "LambdaInvoke"

	// OperationNameS3putObjectCopy is a OperationName enum value
	OperationNameS3putObjectCopy = "S3PutObjectCopy"

	// OperationNameS3putObjectAcl is a OperationName enum value
	OperationNameS3putObjectAcl = "S3PutObjectAcl"

	// OperationNameS3putObjectTagging is a OperationName enum value
	OperationNameS3putObjectTagging = "S3PutObjectTagging"

	// OperationNameS3initiateRestoreObject is a OperationName enum value
	OperationNameS3initiateRestoreObject = "S3InitiateRestoreObject"

	// OperationNameS3putObjectLegalHold is a OperationName enum value
	OperationNameS3putObjectLegalHold = "S3PutObjectLegalHold"

	// OperationNameS3putObjectRetention is a OperationName enum value
	OperationNameS3putObjectRetention = "S3PutObjectRetention"
)

// OperationName_Values returns all elements of the OperationName enum
func OperationName_Values() []string {
	return []string{
		OperationNameLambdaInvoke,
		OperationNameS3putObjectCopy,
		OperationNameS3putObjectAcl,
		OperationNameS3putObjectTagging,
		OperationNameS3initiateRestoreObject,
		OperationNameS3putObjectLegalHold,
		OperationNameS3putObjectRetention,
	}
}

const (
	// OutputSchemaVersionV1 is a OutputSchemaVersion enum value
	OutputSchemaVersionV1 = "V_1"
)

// OutputSchemaVersion_Values returns all elements of the OutputSchemaVersion enum
func OutputSchemaVersion_Values() []string {
	return []string{
		OutputSchemaVersionV1,
	}
}

const (
	// RequestedJobStatusCancelled is a RequestedJobStatus enum value
	RequestedJobStatusCancelled = "Cancelled"

	// RequestedJobStatusReady is a RequestedJobStatus enum value
	RequestedJobStatusReady = "Ready"
)

// RequestedJobStatus_Values returns all elements of the RequestedJobStatus enum
func RequestedJobStatus_Values() []string {
	return []string{
		RequestedJobStatusCancelled,
		RequestedJobStatusReady,
	}
}

const (
	// S3CannedAccessControlListPrivate is a S3CannedAccessControlList enum value
	S3CannedAccessControlListPrivate = "private"

	// S3CannedAccessControlListPublicRead is a S3CannedAccessControlList enum value
	S3CannedAccessControlListPublicRead = "public-read"

	// S3CannedAccessControlListPublicReadWrite is a S3CannedAccessControlList enum value
	S3CannedAccessControlListPublicReadWrite = "public-read-write"

	// S3CannedAccessControlListAwsExecRead is a S3CannedAccessControlList enum value
	S3CannedAccessControlListAwsExecRead = "aws-exec-read"

	// S3CannedAccessControlListAuthenticatedRead is a S3CannedAccessControlList enum value
	S3CannedAccessControlListAuthenticatedRead = "authenticated-read"

	// S3CannedAccessControlListBucketOwnerRead is a S3CannedAccessControlList enum value
	S3CannedAccessControlListBucketOwnerRead = "bucket-owner-read"

	// S3CannedAccessControlListBucketOwnerFullControl is a S3CannedAccessControlList enum value
	S3CannedAccessControlListBucketOwnerFullControl = "bucket-owner-full-control"
)

// S3CannedAccessControlList_Values returns all elements of the S3CannedAccessControlList enum
func S3CannedAccessControlList_Values() []string {
	return []string{
		S3CannedAccessControlListPrivate,
		S3CannedAccessControlListPublicRead,
		S3CannedAccessControlListPublicReadWrite,
		S3CannedAccessControlListAwsExecRead,
		S3CannedAccessControlListAuthenticatedRead,
		S3CannedAccessControlListBucketOwnerRead,
		S3CannedAccessControlListBucketOwnerFullControl,
	}
}

const (
	// S3GlacierJobTierBulk is a S3GlacierJobTier enum value
	S3GlacierJobTierBulk = "BULK"

	// S3GlacierJobTierStandard is a S3GlacierJobTier enum value
	S3GlacierJobTierStandard = "STANDARD"
)

// S3GlacierJobTier_Values returns all elements of the S3GlacierJobTier enum
func S3GlacierJobTier_Values() []string {
	return []string{
		S3GlacierJobTierBulk,
		S3GlacierJobTierStandard,
	}
}

const (
	// S3GranteeTypeIdentifierId is a S3GranteeTypeIdentifier enum value
	S3GranteeTypeIdentifierId = "id"

	// S3GranteeTypeIdentifierEmailAddress is a S3GranteeTypeIdentifier enum value
	S3GranteeTypeIdentifierEmailAddress = "emailAddress"

	// S3GranteeTypeIdentifierUri is a S3GranteeTypeIdentifier enum value
	S3GranteeTypeIdentifierUri = "uri"
)

// S3GranteeTypeIdentifier_Values returns all elements of the S3GranteeTypeIdentifier enum
func S3GranteeTypeIdentifier_Values() []string {
	return []string{
		S3GranteeTypeIdentifierId,
		S3GranteeTypeIdentifierEmailAddress,
		S3GranteeTypeIdentifierUri,
	}
}

const (
	// S3MetadataDirectiveCopy is a S3MetadataDirective enum value
	S3MetadataDirectiveCopy = "COPY"

	// S3MetadataDirectiveReplace is a S3MetadataDirective enum value
	S3MetadataDirectiveReplace = "REPLACE"
)

// S3MetadataDirective_Values returns all elements of the S3MetadataDirective enum
func S3MetadataDirective_Values() []string {
	return []string{
		S3MetadataDirectiveCopy,
		S3MetadataDirectiveReplace,
	}
}

const (
	// S3ObjectLockLegalHoldStatusOff is a S3ObjectLockLegalHoldStatus enum value
	S3ObjectLockLegalHoldStatusOff = "OFF"

	// S3ObjectLockLegalHoldStatusOn is a S3ObjectLockLegalHoldStatus enum value
	S3ObjectLockLegalHoldStatusOn = "ON"
)

// S3ObjectLockLegalHoldStatus_Values returns all elements of the S3ObjectLockLegalHoldStatus enum
func S3ObjectLockLegalHoldStatus_Values() []string {
	return []string{
		S3ObjectLockLegalHoldStatusOff,
		S3ObjectLockLegalHoldStatusOn,
	}
}

const (
	// S3ObjectLockModeCompliance is a S3ObjectLockMode enum value
	S3ObjectLockModeCompliance = "COMPLIANCE"

	// S3ObjectLockModeGovernance is a S3ObjectLockMode enum value
	S3ObjectLockModeGovernance = "GOVERNANCE"
)

// S3ObjectLockMode_Values returns all elements of the S3ObjectLockMode enum
func S3ObjectLockMode_Values() []string {
	return []string{
		S3ObjectLockModeCompliance,
		S3ObjectLockModeGovernance,
	}
}

const (
	// S3ObjectLockRetentionModeCompliance is a S3ObjectLockRetentionMode enum value
	S3ObjectLockRetentionModeCompliance = "COMPLIANCE"

	// S3ObjectLockRetentionModeGovernance is a S3ObjectLockRetentionMode enum value
	S3ObjectLockRetentionModeGovernance = "GOVERNANCE"
)

// S3ObjectLockRetentionMode_Values returns all elements of the S3ObjectLockRetentionMode enum
func S3ObjectLockRetentionMode_Values() []string {
	return []string{
		S3ObjectLockRetentionModeCompliance,
		S3ObjectLockRetentionModeGovernance,
	}
}

const (
	// S3PermissionFullControl is a S3Permission enum value
	S3PermissionFullControl = "FULL_CONTROL"

	// S3PermissionRead is a S3Permission enum value
	S3PermissionRead = "READ"

	// S3PermissionWrite is a S3Permission enum value
	S3PermissionWrite = "WRITE"

	// S3PermissionReadAcp is a S3Permission enum value
	S3PermissionReadAcp = "READ_ACP"

	// S3PermissionWriteAcp is a S3Permission enum value
	S3PermissionWriteAcp = "WRITE_ACP"
)

// S3Permission_Values returns all elements of the S3Permission enum
func S3Permission_Values() []string {
	return []string{
		S3PermissionFullControl,
		S3PermissionRead,
		S3PermissionWrite,
		S3PermissionReadAcp,
		S3PermissionWriteAcp,
	}
}

const (
	// S3SSEAlgorithmAes256 is a S3SSEAlgorithm enum value
	S3SSEAlgorithmAes256 = "AES256"

	// S3SSEAlgorithmKms is a S3SSEAlgorithm enum value
	S3SSEAlgorithmKms = "KMS"
)

// S3SSEAlgorithm_Values returns all elements of the S3SSEAlgorithm enum
func S3SSEAlgorithm_Values() []string {
	return []string{
		S3SSEAlgorithmAes256,
		S3SSEAlgorithmKms,
	}
}

const (
	// S3StorageClassStandard is a S3StorageClass enum value
	S3StorageClassStandard = "STANDARD"

	// S3StorageClassStandardIa is a S3StorageClass enum value
	S3StorageClassStandardIa = "STANDARD_IA"

	// S3StorageClassOnezoneIa is a S3StorageClass enum value
	S3StorageClassOnezoneIa = "ONEZONE_IA"

	// S3StorageClassGlacier is a S3StorageClass enum value
	S3StorageClassGlacier = "GLACIER"

	// S3StorageClassIntelligentTiering is a S3StorageClass enum value
	S3StorageClassIntelligentTiering = "INTELLIGENT_TIERING"

	// S3StorageClassDeepArchive is a S3StorageClass enum value
	S3StorageClassDeepArchive = "DEEP_ARCHIVE"
)

// S3StorageClass_Values returns all elements of the S3StorageClass enum
func S3StorageClass_Values() []string {
	return []string{
		S3StorageClassStandard,
		S3StorageClassStandardIa,
		S3StorageClassOnezoneIa,
		S3StorageClassGlacier,
		S3StorageClassIntelligentTiering,
		S3StorageClassDeepArchive,
	}
}

const (
	// TransitionStorageClassGlacier is a TransitionStorageClass enum value
	TransitionStorageClassGlacier = "GLACIER"

	// TransitionStorageClassStandardIa is a TransitionStorageClass enum value
	TransitionStorageClassStandardIa = "STANDARD_IA"

	// TransitionStorageClassOnezoneIa is a TransitionStorageClass enum value
	TransitionStorageClassOnezoneIa = "ONEZONE_IA"

	// TransitionStorageClassIntelligentTiering is a TransitionStorageClass enum value
	TransitionStorageClassIntelligentTiering = "INTELLIGENT_TIERING"

	// TransitionStorageClassDeepArchive is a TransitionStorageClass enum value
	TransitionStorageClassDeepArchive = "DEEP_ARCHIVE"
)

// TransitionStorageClass_Values returns all elements of the TransitionStorageClass enum
func TransitionStorageClass_Values() []string {
	return []string{
		TransitionStorageClassGlacier,
		TransitionStorageClassStandardIa,
		TransitionStorageClassOnezoneIa,
		TransitionStorageClassIntelligentTiering,
		TransitionStorageClassDeepArchive,
	}
}
