// Code generated by smithy-go-codegen DO NOT EDIT.

package nimble

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/nimble/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyjson "github.com/aws/smithy-go/encoding/json"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

type awsRestjson1_serializeOpAcceptEulas struct {
}

func (*awsRestjson1_serializeOpAcceptEulas) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpAcceptEulas) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AcceptEulasInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-08-01/studios/{studioId}/eula-acceptances")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsAcceptEulasInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentAcceptEulasInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsAcceptEulasInput(v *AcceptEulasInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ClientToken != nil && len(*v.ClientToken) > 0 {
		locationName := "X-Amz-Client-Token"
		encoder.SetHeader(locationName).String(*v.ClientToken)
	}

	if v.StudioId == nil || len(*v.StudioId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member studioId must not be empty")}
	}
	if v.StudioId != nil {
		if err := encoder.SetURI("studioId").String(*v.StudioId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentAcceptEulasInput(v *AcceptEulasInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EulaIds != nil {
		ok := object.Key("eulaIds")
		if err := awsRestjson1_serializeDocumentEulaIdList(v.EulaIds, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateLaunchProfile struct {
}

func (*awsRestjson1_serializeOpCreateLaunchProfile) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateLaunchProfile) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateLaunchProfileInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-08-01/studios/{studioId}/launch-profiles")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateLaunchProfileInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateLaunchProfileInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateLaunchProfileInput(v *CreateLaunchProfileInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ClientToken != nil && len(*v.ClientToken) > 0 {
		locationName := "X-Amz-Client-Token"
		encoder.SetHeader(locationName).String(*v.ClientToken)
	}

	if v.StudioId == nil || len(*v.StudioId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member studioId must not be empty")}
	}
	if v.StudioId != nil {
		if err := encoder.SetURI("studioId").String(*v.StudioId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateLaunchProfileInput(v *CreateLaunchProfileInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.Ec2SubnetIds != nil {
		ok := object.Key("ec2SubnetIds")
		if err := awsRestjson1_serializeDocumentEC2SubnetIdList(v.Ec2SubnetIds, ok); err != nil {
			return err
		}
	}

	if v.LaunchProfileProtocolVersions != nil {
		ok := object.Key("launchProfileProtocolVersions")
		if err := awsRestjson1_serializeDocumentLaunchProfileProtocolVersionList(v.LaunchProfileProtocolVersions, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.StreamConfiguration != nil {
		ok := object.Key("streamConfiguration")
		if err := awsRestjson1_serializeDocumentStreamConfigurationCreate(v.StreamConfiguration, ok); err != nil {
			return err
		}
	}

	if v.StudioComponentIds != nil {
		ok := object.Key("studioComponentIds")
		if err := awsRestjson1_serializeDocumentLaunchProfileStudioComponentIdList(v.StudioComponentIds, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTags(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateStreamingImage struct {
}

func (*awsRestjson1_serializeOpCreateStreamingImage) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateStreamingImage) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateStreamingImageInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-08-01/studios/{studioId}/streaming-images")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateStreamingImageInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateStreamingImageInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateStreamingImageInput(v *CreateStreamingImageInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ClientToken != nil && len(*v.ClientToken) > 0 {
		locationName := "X-Amz-Client-Token"
		encoder.SetHeader(locationName).String(*v.ClientToken)
	}

	if v.StudioId == nil || len(*v.StudioId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member studioId must not be empty")}
	}
	if v.StudioId != nil {
		if err := encoder.SetURI("studioId").String(*v.StudioId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateStreamingImageInput(v *CreateStreamingImageInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.Ec2ImageId != nil {
		ok := object.Key("ec2ImageId")
		ok.String(*v.Ec2ImageId)
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTags(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateStreamingSession struct {
}

func (*awsRestjson1_serializeOpCreateStreamingSession) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateStreamingSession) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateStreamingSessionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-08-01/studios/{studioId}/streaming-sessions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateStreamingSessionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateStreamingSessionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateStreamingSessionInput(v *CreateStreamingSessionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ClientToken != nil && len(*v.ClientToken) > 0 {
		locationName := "X-Amz-Client-Token"
		encoder.SetHeader(locationName).String(*v.ClientToken)
	}

	if v.StudioId == nil || len(*v.StudioId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member studioId must not be empty")}
	}
	if v.StudioId != nil {
		if err := encoder.SetURI("studioId").String(*v.StudioId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateStreamingSessionInput(v *CreateStreamingSessionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Ec2InstanceType) > 0 {
		ok := object.Key("ec2InstanceType")
		ok.String(string(v.Ec2InstanceType))
	}

	if v.LaunchProfileId != nil {
		ok := object.Key("launchProfileId")
		ok.String(*v.LaunchProfileId)
	}

	if v.OwnedBy != nil {
		ok := object.Key("ownedBy")
		ok.String(*v.OwnedBy)
	}

	if v.StreamingImageId != nil {
		ok := object.Key("streamingImageId")
		ok.String(*v.StreamingImageId)
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTags(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateStreamingSessionStream struct {
}

func (*awsRestjson1_serializeOpCreateStreamingSessionStream) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateStreamingSessionStream) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateStreamingSessionStreamInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-08-01/studios/{studioId}/streaming-sessions/{sessionId}/streams")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateStreamingSessionStreamInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateStreamingSessionStreamInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateStreamingSessionStreamInput(v *CreateStreamingSessionStreamInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ClientToken != nil && len(*v.ClientToken) > 0 {
		locationName := "X-Amz-Client-Token"
		encoder.SetHeader(locationName).String(*v.ClientToken)
	}

	if v.SessionId == nil || len(*v.SessionId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member sessionId must not be empty")}
	}
	if v.SessionId != nil {
		if err := encoder.SetURI("sessionId").String(*v.SessionId); err != nil {
			return err
		}
	}

	if v.StudioId == nil || len(*v.StudioId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member studioId must not be empty")}
	}
	if v.StudioId != nil {
		if err := encoder.SetURI("studioId").String(*v.StudioId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateStreamingSessionStreamInput(v *CreateStreamingSessionStreamInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ExpirationInSeconds != 0 {
		ok := object.Key("expirationInSeconds")
		ok.Integer(v.ExpirationInSeconds)
	}

	return nil
}

type awsRestjson1_serializeOpCreateStudio struct {
}

func (*awsRestjson1_serializeOpCreateStudio) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateStudio) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateStudioInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-08-01/studios")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateStudioInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateStudioInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateStudioInput(v *CreateStudioInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ClientToken != nil && len(*v.ClientToken) > 0 {
		locationName := "X-Amz-Client-Token"
		encoder.SetHeader(locationName).String(*v.ClientToken)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateStudioInput(v *CreateStudioInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AdminRoleArn != nil {
		ok := object.Key("adminRoleArn")
		ok.String(*v.AdminRoleArn)
	}

	if v.DisplayName != nil {
		ok := object.Key("displayName")
		ok.String(*v.DisplayName)
	}

	if v.StudioEncryptionConfiguration != nil {
		ok := object.Key("studioEncryptionConfiguration")
		if err := awsRestjson1_serializeDocumentStudioEncryptionConfiguration(v.StudioEncryptionConfiguration, ok); err != nil {
			return err
		}
	}

	if v.StudioName != nil {
		ok := object.Key("studioName")
		ok.String(*v.StudioName)
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTags(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.UserRoleArn != nil {
		ok := object.Key("userRoleArn")
		ok.String(*v.UserRoleArn)
	}

	return nil
}

type awsRestjson1_serializeOpCreateStudioComponent struct {
}

func (*awsRestjson1_serializeOpCreateStudioComponent) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateStudioComponent) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateStudioComponentInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-08-01/studios/{studioId}/studio-components")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateStudioComponentInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateStudioComponentInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateStudioComponentInput(v *CreateStudioComponentInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ClientToken != nil && len(*v.ClientToken) > 0 {
		locationName := "X-Amz-Client-Token"
		encoder.SetHeader(locationName).String(*v.ClientToken)
	}

	if v.StudioId == nil || len(*v.StudioId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member studioId must not be empty")}
	}
	if v.StudioId != nil {
		if err := encoder.SetURI("studioId").String(*v.StudioId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateStudioComponentInput(v *CreateStudioComponentInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Configuration != nil {
		ok := object.Key("configuration")
		if err := awsRestjson1_serializeDocumentStudioComponentConfiguration(v.Configuration, ok); err != nil {
			return err
		}
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.Ec2SecurityGroupIds != nil {
		ok := object.Key("ec2SecurityGroupIds")
		if err := awsRestjson1_serializeDocumentStudioComponentSecurityGroupIdList(v.Ec2SecurityGroupIds, ok); err != nil {
			return err
		}
	}

	if v.InitializationScripts != nil {
		ok := object.Key("initializationScripts")
		if err := awsRestjson1_serializeDocumentStudioComponentInitializationScriptList(v.InitializationScripts, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.RuntimeRoleArn != nil {
		ok := object.Key("runtimeRoleArn")
		ok.String(*v.RuntimeRoleArn)
	}

	if v.ScriptParameters != nil {
		ok := object.Key("scriptParameters")
		if err := awsRestjson1_serializeDocumentStudioComponentScriptParameterKeyValueList(v.ScriptParameters, ok); err != nil {
			return err
		}
	}

	if v.SecureInitializationRoleArn != nil {
		ok := object.Key("secureInitializationRoleArn")
		ok.String(*v.SecureInitializationRoleArn)
	}

	if len(v.Subtype) > 0 {
		ok := object.Key("subtype")
		ok.String(string(v.Subtype))
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTags(v.Tags, ok); err != nil {
			return err
		}
	}

	if len(v.Type) > 0 {
		ok := object.Key("type")
		ok.String(string(v.Type))
	}

	return nil
}

type awsRestjson1_serializeOpDeleteLaunchProfile struct {
}

func (*awsRestjson1_serializeOpDeleteLaunchProfile) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteLaunchProfile) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteLaunchProfileInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-08-01/studios/{studioId}/launch-profiles/{launchProfileId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteLaunchProfileInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteLaunchProfileInput(v *DeleteLaunchProfileInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ClientToken != nil && len(*v.ClientToken) > 0 {
		locationName := "X-Amz-Client-Token"
		encoder.SetHeader(locationName).String(*v.ClientToken)
	}

	if v.LaunchProfileId == nil || len(*v.LaunchProfileId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member launchProfileId must not be empty")}
	}
	if v.LaunchProfileId != nil {
		if err := encoder.SetURI("launchProfileId").String(*v.LaunchProfileId); err != nil {
			return err
		}
	}

	if v.StudioId == nil || len(*v.StudioId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member studioId must not be empty")}
	}
	if v.StudioId != nil {
		if err := encoder.SetURI("studioId").String(*v.StudioId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteLaunchProfileMember struct {
}

func (*awsRestjson1_serializeOpDeleteLaunchProfileMember) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteLaunchProfileMember) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteLaunchProfileMemberInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-08-01/studios/{studioId}/launch-profiles/{launchProfileId}/membership/{principalId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteLaunchProfileMemberInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteLaunchProfileMemberInput(v *DeleteLaunchProfileMemberInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ClientToken != nil && len(*v.ClientToken) > 0 {
		locationName := "X-Amz-Client-Token"
		encoder.SetHeader(locationName).String(*v.ClientToken)
	}

	if v.LaunchProfileId == nil || len(*v.LaunchProfileId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member launchProfileId must not be empty")}
	}
	if v.LaunchProfileId != nil {
		if err := encoder.SetURI("launchProfileId").String(*v.LaunchProfileId); err != nil {
			return err
		}
	}

	if v.PrincipalId == nil || len(*v.PrincipalId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member principalId must not be empty")}
	}
	if v.PrincipalId != nil {
		if err := encoder.SetURI("principalId").String(*v.PrincipalId); err != nil {
			return err
		}
	}

	if v.StudioId == nil || len(*v.StudioId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member studioId must not be empty")}
	}
	if v.StudioId != nil {
		if err := encoder.SetURI("studioId").String(*v.StudioId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteStreamingImage struct {
}

func (*awsRestjson1_serializeOpDeleteStreamingImage) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteStreamingImage) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteStreamingImageInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-08-01/studios/{studioId}/streaming-images/{streamingImageId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteStreamingImageInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteStreamingImageInput(v *DeleteStreamingImageInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ClientToken != nil && len(*v.ClientToken) > 0 {
		locationName := "X-Amz-Client-Token"
		encoder.SetHeader(locationName).String(*v.ClientToken)
	}

	if v.StreamingImageId == nil || len(*v.StreamingImageId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member streamingImageId must not be empty")}
	}
	if v.StreamingImageId != nil {
		if err := encoder.SetURI("streamingImageId").String(*v.StreamingImageId); err != nil {
			return err
		}
	}

	if v.StudioId == nil || len(*v.StudioId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member studioId must not be empty")}
	}
	if v.StudioId != nil {
		if err := encoder.SetURI("studioId").String(*v.StudioId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteStreamingSession struct {
}

func (*awsRestjson1_serializeOpDeleteStreamingSession) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteStreamingSession) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteStreamingSessionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-08-01/studios/{studioId}/streaming-sessions/{sessionId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteStreamingSessionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteStreamingSessionInput(v *DeleteStreamingSessionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ClientToken != nil && len(*v.ClientToken) > 0 {
		locationName := "X-Amz-Client-Token"
		encoder.SetHeader(locationName).String(*v.ClientToken)
	}

	if v.SessionId == nil || len(*v.SessionId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member sessionId must not be empty")}
	}
	if v.SessionId != nil {
		if err := encoder.SetURI("sessionId").String(*v.SessionId); err != nil {
			return err
		}
	}

	if v.StudioId == nil || len(*v.StudioId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member studioId must not be empty")}
	}
	if v.StudioId != nil {
		if err := encoder.SetURI("studioId").String(*v.StudioId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteStudio struct {
}

func (*awsRestjson1_serializeOpDeleteStudio) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteStudio) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteStudioInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-08-01/studios/{studioId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteStudioInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteStudioInput(v *DeleteStudioInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ClientToken != nil && len(*v.ClientToken) > 0 {
		locationName := "X-Amz-Client-Token"
		encoder.SetHeader(locationName).String(*v.ClientToken)
	}

	if v.StudioId == nil || len(*v.StudioId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member studioId must not be empty")}
	}
	if v.StudioId != nil {
		if err := encoder.SetURI("studioId").String(*v.StudioId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteStudioComponent struct {
}

func (*awsRestjson1_serializeOpDeleteStudioComponent) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteStudioComponent) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteStudioComponentInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-08-01/studios/{studioId}/studio-components/{studioComponentId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteStudioComponentInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteStudioComponentInput(v *DeleteStudioComponentInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ClientToken != nil && len(*v.ClientToken) > 0 {
		locationName := "X-Amz-Client-Token"
		encoder.SetHeader(locationName).String(*v.ClientToken)
	}

	if v.StudioComponentId == nil || len(*v.StudioComponentId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member studioComponentId must not be empty")}
	}
	if v.StudioComponentId != nil {
		if err := encoder.SetURI("studioComponentId").String(*v.StudioComponentId); err != nil {
			return err
		}
	}

	if v.StudioId == nil || len(*v.StudioId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member studioId must not be empty")}
	}
	if v.StudioId != nil {
		if err := encoder.SetURI("studioId").String(*v.StudioId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteStudioMember struct {
}

func (*awsRestjson1_serializeOpDeleteStudioMember) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteStudioMember) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteStudioMemberInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-08-01/studios/{studioId}/membership/{principalId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteStudioMemberInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteStudioMemberInput(v *DeleteStudioMemberInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ClientToken != nil && len(*v.ClientToken) > 0 {
		locationName := "X-Amz-Client-Token"
		encoder.SetHeader(locationName).String(*v.ClientToken)
	}

	if v.PrincipalId == nil || len(*v.PrincipalId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member principalId must not be empty")}
	}
	if v.PrincipalId != nil {
		if err := encoder.SetURI("principalId").String(*v.PrincipalId); err != nil {
			return err
		}
	}

	if v.StudioId == nil || len(*v.StudioId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member studioId must not be empty")}
	}
	if v.StudioId != nil {
		if err := encoder.SetURI("studioId").String(*v.StudioId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetEula struct {
}

func (*awsRestjson1_serializeOpGetEula) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetEula) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetEulaInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-08-01/eulas/{eulaId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetEulaInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetEulaInput(v *GetEulaInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.EulaId == nil || len(*v.EulaId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member eulaId must not be empty")}
	}
	if v.EulaId != nil {
		if err := encoder.SetURI("eulaId").String(*v.EulaId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetLaunchProfile struct {
}

func (*awsRestjson1_serializeOpGetLaunchProfile) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetLaunchProfile) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetLaunchProfileInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-08-01/studios/{studioId}/launch-profiles/{launchProfileId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetLaunchProfileInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetLaunchProfileInput(v *GetLaunchProfileInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.LaunchProfileId == nil || len(*v.LaunchProfileId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member launchProfileId must not be empty")}
	}
	if v.LaunchProfileId != nil {
		if err := encoder.SetURI("launchProfileId").String(*v.LaunchProfileId); err != nil {
			return err
		}
	}

	if v.StudioId == nil || len(*v.StudioId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member studioId must not be empty")}
	}
	if v.StudioId != nil {
		if err := encoder.SetURI("studioId").String(*v.StudioId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetLaunchProfileDetails struct {
}

func (*awsRestjson1_serializeOpGetLaunchProfileDetails) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetLaunchProfileDetails) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetLaunchProfileDetailsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-08-01/studios/{studioId}/launch-profiles/{launchProfileId}/details")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetLaunchProfileDetailsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetLaunchProfileDetailsInput(v *GetLaunchProfileDetailsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.LaunchProfileId == nil || len(*v.LaunchProfileId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member launchProfileId must not be empty")}
	}
	if v.LaunchProfileId != nil {
		if err := encoder.SetURI("launchProfileId").String(*v.LaunchProfileId); err != nil {
			return err
		}
	}

	if v.StudioId == nil || len(*v.StudioId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member studioId must not be empty")}
	}
	if v.StudioId != nil {
		if err := encoder.SetURI("studioId").String(*v.StudioId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetLaunchProfileInitialization struct {
}

func (*awsRestjson1_serializeOpGetLaunchProfileInitialization) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetLaunchProfileInitialization) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetLaunchProfileInitializationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-08-01/studios/{studioId}/launch-profiles/{launchProfileId}/init")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetLaunchProfileInitializationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetLaunchProfileInitializationInput(v *GetLaunchProfileInitializationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.LaunchProfileId == nil || len(*v.LaunchProfileId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member launchProfileId must not be empty")}
	}
	if v.LaunchProfileId != nil {
		if err := encoder.SetURI("launchProfileId").String(*v.LaunchProfileId); err != nil {
			return err
		}
	}

	if v.LaunchProfileProtocolVersions != nil {
		for i := range v.LaunchProfileProtocolVersions {
			encoder.AddQuery("launchProfileProtocolVersions").String(v.LaunchProfileProtocolVersions[i])
		}
	}

	if v.LaunchPurpose != nil {
		encoder.SetQuery("launchPurpose").String(*v.LaunchPurpose)
	}

	if v.Platform != nil {
		encoder.SetQuery("platform").String(*v.Platform)
	}

	if v.StudioId == nil || len(*v.StudioId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member studioId must not be empty")}
	}
	if v.StudioId != nil {
		if err := encoder.SetURI("studioId").String(*v.StudioId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetLaunchProfileMember struct {
}

func (*awsRestjson1_serializeOpGetLaunchProfileMember) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetLaunchProfileMember) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetLaunchProfileMemberInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-08-01/studios/{studioId}/launch-profiles/{launchProfileId}/membership/{principalId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetLaunchProfileMemberInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetLaunchProfileMemberInput(v *GetLaunchProfileMemberInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.LaunchProfileId == nil || len(*v.LaunchProfileId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member launchProfileId must not be empty")}
	}
	if v.LaunchProfileId != nil {
		if err := encoder.SetURI("launchProfileId").String(*v.LaunchProfileId); err != nil {
			return err
		}
	}

	if v.PrincipalId == nil || len(*v.PrincipalId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member principalId must not be empty")}
	}
	if v.PrincipalId != nil {
		if err := encoder.SetURI("principalId").String(*v.PrincipalId); err != nil {
			return err
		}
	}

	if v.StudioId == nil || len(*v.StudioId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member studioId must not be empty")}
	}
	if v.StudioId != nil {
		if err := encoder.SetURI("studioId").String(*v.StudioId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetStreamingImage struct {
}

func (*awsRestjson1_serializeOpGetStreamingImage) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetStreamingImage) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetStreamingImageInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-08-01/studios/{studioId}/streaming-images/{streamingImageId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetStreamingImageInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetStreamingImageInput(v *GetStreamingImageInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.StreamingImageId == nil || len(*v.StreamingImageId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member streamingImageId must not be empty")}
	}
	if v.StreamingImageId != nil {
		if err := encoder.SetURI("streamingImageId").String(*v.StreamingImageId); err != nil {
			return err
		}
	}

	if v.StudioId == nil || len(*v.StudioId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member studioId must not be empty")}
	}
	if v.StudioId != nil {
		if err := encoder.SetURI("studioId").String(*v.StudioId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetStreamingSession struct {
}

func (*awsRestjson1_serializeOpGetStreamingSession) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetStreamingSession) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetStreamingSessionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-08-01/studios/{studioId}/streaming-sessions/{sessionId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetStreamingSessionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetStreamingSessionInput(v *GetStreamingSessionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.SessionId == nil || len(*v.SessionId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member sessionId must not be empty")}
	}
	if v.SessionId != nil {
		if err := encoder.SetURI("sessionId").String(*v.SessionId); err != nil {
			return err
		}
	}

	if v.StudioId == nil || len(*v.StudioId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member studioId must not be empty")}
	}
	if v.StudioId != nil {
		if err := encoder.SetURI("studioId").String(*v.StudioId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetStreamingSessionStream struct {
}

func (*awsRestjson1_serializeOpGetStreamingSessionStream) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetStreamingSessionStream) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetStreamingSessionStreamInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-08-01/studios/{studioId}/streaming-sessions/{sessionId}/streams/{streamId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetStreamingSessionStreamInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetStreamingSessionStreamInput(v *GetStreamingSessionStreamInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.SessionId == nil || len(*v.SessionId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member sessionId must not be empty")}
	}
	if v.SessionId != nil {
		if err := encoder.SetURI("sessionId").String(*v.SessionId); err != nil {
			return err
		}
	}

	if v.StreamId == nil || len(*v.StreamId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member streamId must not be empty")}
	}
	if v.StreamId != nil {
		if err := encoder.SetURI("streamId").String(*v.StreamId); err != nil {
			return err
		}
	}

	if v.StudioId == nil || len(*v.StudioId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member studioId must not be empty")}
	}
	if v.StudioId != nil {
		if err := encoder.SetURI("studioId").String(*v.StudioId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetStudio struct {
}

func (*awsRestjson1_serializeOpGetStudio) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetStudio) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetStudioInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-08-01/studios/{studioId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetStudioInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetStudioInput(v *GetStudioInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.StudioId == nil || len(*v.StudioId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member studioId must not be empty")}
	}
	if v.StudioId != nil {
		if err := encoder.SetURI("studioId").String(*v.StudioId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetStudioComponent struct {
}

func (*awsRestjson1_serializeOpGetStudioComponent) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetStudioComponent) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetStudioComponentInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-08-01/studios/{studioId}/studio-components/{studioComponentId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetStudioComponentInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetStudioComponentInput(v *GetStudioComponentInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.StudioComponentId == nil || len(*v.StudioComponentId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member studioComponentId must not be empty")}
	}
	if v.StudioComponentId != nil {
		if err := encoder.SetURI("studioComponentId").String(*v.StudioComponentId); err != nil {
			return err
		}
	}

	if v.StudioId == nil || len(*v.StudioId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member studioId must not be empty")}
	}
	if v.StudioId != nil {
		if err := encoder.SetURI("studioId").String(*v.StudioId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetStudioMember struct {
}

func (*awsRestjson1_serializeOpGetStudioMember) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetStudioMember) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetStudioMemberInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-08-01/studios/{studioId}/membership/{principalId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetStudioMemberInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetStudioMemberInput(v *GetStudioMemberInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.PrincipalId == nil || len(*v.PrincipalId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member principalId must not be empty")}
	}
	if v.PrincipalId != nil {
		if err := encoder.SetURI("principalId").String(*v.PrincipalId); err != nil {
			return err
		}
	}

	if v.StudioId == nil || len(*v.StudioId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member studioId must not be empty")}
	}
	if v.StudioId != nil {
		if err := encoder.SetURI("studioId").String(*v.StudioId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListEulaAcceptances struct {
}

func (*awsRestjson1_serializeOpListEulaAcceptances) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListEulaAcceptances) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListEulaAcceptancesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-08-01/studios/{studioId}/eula-acceptances")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListEulaAcceptancesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListEulaAcceptancesInput(v *ListEulaAcceptancesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.EulaIds != nil {
		for i := range v.EulaIds {
			encoder.AddQuery("eulaIds").String(v.EulaIds[i])
		}
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if v.StudioId == nil || len(*v.StudioId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member studioId must not be empty")}
	}
	if v.StudioId != nil {
		if err := encoder.SetURI("studioId").String(*v.StudioId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListEulas struct {
}

func (*awsRestjson1_serializeOpListEulas) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListEulas) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListEulasInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-08-01/eulas")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListEulasInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListEulasInput(v *ListEulasInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.EulaIds != nil {
		for i := range v.EulaIds {
			encoder.AddQuery("eulaIds").String(v.EulaIds[i])
		}
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListLaunchProfileMembers struct {
}

func (*awsRestjson1_serializeOpListLaunchProfileMembers) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListLaunchProfileMembers) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListLaunchProfileMembersInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-08-01/studios/{studioId}/launch-profiles/{launchProfileId}/membership")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListLaunchProfileMembersInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListLaunchProfileMembersInput(v *ListLaunchProfileMembersInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.LaunchProfileId == nil || len(*v.LaunchProfileId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member launchProfileId must not be empty")}
	}
	if v.LaunchProfileId != nil {
		if err := encoder.SetURI("launchProfileId").String(*v.LaunchProfileId); err != nil {
			return err
		}
	}

	if v.MaxResults != 0 {
		encoder.SetQuery("maxResults").Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if v.StudioId == nil || len(*v.StudioId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member studioId must not be empty")}
	}
	if v.StudioId != nil {
		if err := encoder.SetURI("studioId").String(*v.StudioId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListLaunchProfiles struct {
}

func (*awsRestjson1_serializeOpListLaunchProfiles) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListLaunchProfiles) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListLaunchProfilesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-08-01/studios/{studioId}/launch-profiles")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListLaunchProfilesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListLaunchProfilesInput(v *ListLaunchProfilesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != 0 {
		encoder.SetQuery("maxResults").Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if v.PrincipalId != nil {
		encoder.SetQuery("principalId").String(*v.PrincipalId)
	}

	if v.States != nil {
		for i := range v.States {
			encoder.AddQuery("states").String(string(v.States[i]))
		}
	}

	if v.StudioId == nil || len(*v.StudioId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member studioId must not be empty")}
	}
	if v.StudioId != nil {
		if err := encoder.SetURI("studioId").String(*v.StudioId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListStreamingImages struct {
}

func (*awsRestjson1_serializeOpListStreamingImages) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListStreamingImages) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListStreamingImagesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-08-01/studios/{studioId}/streaming-images")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListStreamingImagesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListStreamingImagesInput(v *ListStreamingImagesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if v.Owner != nil {
		encoder.SetQuery("owner").String(*v.Owner)
	}

	if v.StudioId == nil || len(*v.StudioId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member studioId must not be empty")}
	}
	if v.StudioId != nil {
		if err := encoder.SetURI("studioId").String(*v.StudioId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListStreamingSessions struct {
}

func (*awsRestjson1_serializeOpListStreamingSessions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListStreamingSessions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListStreamingSessionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-08-01/studios/{studioId}/streaming-sessions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListStreamingSessionsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListStreamingSessionsInput(v *ListStreamingSessionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.CreatedBy != nil {
		encoder.SetQuery("createdBy").String(*v.CreatedBy)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if v.OwnedBy != nil {
		encoder.SetQuery("ownedBy").String(*v.OwnedBy)
	}

	if v.SessionIds != nil {
		encoder.SetQuery("sessionIds").String(*v.SessionIds)
	}

	if v.StudioId == nil || len(*v.StudioId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member studioId must not be empty")}
	}
	if v.StudioId != nil {
		if err := encoder.SetURI("studioId").String(*v.StudioId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListStudioComponents struct {
}

func (*awsRestjson1_serializeOpListStudioComponents) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListStudioComponents) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListStudioComponentsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-08-01/studios/{studioId}/studio-components")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListStudioComponentsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListStudioComponentsInput(v *ListStudioComponentsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != 0 {
		encoder.SetQuery("maxResults").Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if v.States != nil {
		for i := range v.States {
			encoder.AddQuery("states").String(string(v.States[i]))
		}
	}

	if v.StudioId == nil || len(*v.StudioId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member studioId must not be empty")}
	}
	if v.StudioId != nil {
		if err := encoder.SetURI("studioId").String(*v.StudioId); err != nil {
			return err
		}
	}

	if v.Types != nil {
		for i := range v.Types {
			encoder.AddQuery("types").String(string(v.Types[i]))
		}
	}

	return nil
}

type awsRestjson1_serializeOpListStudioMembers struct {
}

func (*awsRestjson1_serializeOpListStudioMembers) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListStudioMembers) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListStudioMembersInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-08-01/studios/{studioId}/membership")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListStudioMembersInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListStudioMembersInput(v *ListStudioMembersInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != 0 {
		encoder.SetQuery("maxResults").Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if v.StudioId == nil || len(*v.StudioId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member studioId must not be empty")}
	}
	if v.StudioId != nil {
		if err := encoder.SetURI("studioId").String(*v.StudioId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListStudios struct {
}

func (*awsRestjson1_serializeOpListStudios) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListStudios) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListStudiosInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-08-01/studios")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListStudiosInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListStudiosInput(v *ListStudiosInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListTagsForResource struct {
}

func (*awsRestjson1_serializeOpListTagsForResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListTagsForResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTagsForResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-08-01/tags/{resourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListTagsForResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListTagsForResourceInput(v *ListTagsForResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member resourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("resourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpPutLaunchProfileMembers struct {
}

func (*awsRestjson1_serializeOpPutLaunchProfileMembers) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpPutLaunchProfileMembers) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutLaunchProfileMembersInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-08-01/studios/{studioId}/launch-profiles/{launchProfileId}/membership")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsPutLaunchProfileMembersInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentPutLaunchProfileMembersInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsPutLaunchProfileMembersInput(v *PutLaunchProfileMembersInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ClientToken != nil && len(*v.ClientToken) > 0 {
		locationName := "X-Amz-Client-Token"
		encoder.SetHeader(locationName).String(*v.ClientToken)
	}

	if v.LaunchProfileId == nil || len(*v.LaunchProfileId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member launchProfileId must not be empty")}
	}
	if v.LaunchProfileId != nil {
		if err := encoder.SetURI("launchProfileId").String(*v.LaunchProfileId); err != nil {
			return err
		}
	}

	if v.StudioId == nil || len(*v.StudioId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member studioId must not be empty")}
	}
	if v.StudioId != nil {
		if err := encoder.SetURI("studioId").String(*v.StudioId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentPutLaunchProfileMembersInput(v *PutLaunchProfileMembersInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.IdentityStoreId != nil {
		ok := object.Key("identityStoreId")
		ok.String(*v.IdentityStoreId)
	}

	if v.Members != nil {
		ok := object.Key("members")
		if err := awsRestjson1_serializeDocumentNewLaunchProfileMemberList(v.Members, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpPutStudioMembers struct {
}

func (*awsRestjson1_serializeOpPutStudioMembers) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpPutStudioMembers) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutStudioMembersInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-08-01/studios/{studioId}/membership")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsPutStudioMembersInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentPutStudioMembersInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsPutStudioMembersInput(v *PutStudioMembersInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ClientToken != nil && len(*v.ClientToken) > 0 {
		locationName := "X-Amz-Client-Token"
		encoder.SetHeader(locationName).String(*v.ClientToken)
	}

	if v.StudioId == nil || len(*v.StudioId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member studioId must not be empty")}
	}
	if v.StudioId != nil {
		if err := encoder.SetURI("studioId").String(*v.StudioId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentPutStudioMembersInput(v *PutStudioMembersInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.IdentityStoreId != nil {
		ok := object.Key("identityStoreId")
		ok.String(*v.IdentityStoreId)
	}

	if v.Members != nil {
		ok := object.Key("members")
		if err := awsRestjson1_serializeDocumentNewStudioMemberList(v.Members, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpStartStreamingSession struct {
}

func (*awsRestjson1_serializeOpStartStreamingSession) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpStartStreamingSession) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartStreamingSessionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-08-01/studios/{studioId}/streaming-sessions/{sessionId}/start")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsStartStreamingSessionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsStartStreamingSessionInput(v *StartStreamingSessionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ClientToken != nil && len(*v.ClientToken) > 0 {
		locationName := "X-Amz-Client-Token"
		encoder.SetHeader(locationName).String(*v.ClientToken)
	}

	if v.SessionId == nil || len(*v.SessionId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member sessionId must not be empty")}
	}
	if v.SessionId != nil {
		if err := encoder.SetURI("sessionId").String(*v.SessionId); err != nil {
			return err
		}
	}

	if v.StudioId == nil || len(*v.StudioId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member studioId must not be empty")}
	}
	if v.StudioId != nil {
		if err := encoder.SetURI("studioId").String(*v.StudioId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpStartStudioSSOConfigurationRepair struct {
}

func (*awsRestjson1_serializeOpStartStudioSSOConfigurationRepair) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpStartStudioSSOConfigurationRepair) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartStudioSSOConfigurationRepairInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-08-01/studios/{studioId}/sso-configuration")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsStartStudioSSOConfigurationRepairInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsStartStudioSSOConfigurationRepairInput(v *StartStudioSSOConfigurationRepairInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ClientToken != nil && len(*v.ClientToken) > 0 {
		locationName := "X-Amz-Client-Token"
		encoder.SetHeader(locationName).String(*v.ClientToken)
	}

	if v.StudioId == nil || len(*v.StudioId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member studioId must not be empty")}
	}
	if v.StudioId != nil {
		if err := encoder.SetURI("studioId").String(*v.StudioId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpStopStreamingSession struct {
}

func (*awsRestjson1_serializeOpStopStreamingSession) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpStopStreamingSession) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StopStreamingSessionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-08-01/studios/{studioId}/streaming-sessions/{sessionId}/stop")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsStopStreamingSessionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsStopStreamingSessionInput(v *StopStreamingSessionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ClientToken != nil && len(*v.ClientToken) > 0 {
		locationName := "X-Amz-Client-Token"
		encoder.SetHeader(locationName).String(*v.ClientToken)
	}

	if v.SessionId == nil || len(*v.SessionId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member sessionId must not be empty")}
	}
	if v.SessionId != nil {
		if err := encoder.SetURI("sessionId").String(*v.SessionId); err != nil {
			return err
		}
	}

	if v.StudioId == nil || len(*v.StudioId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member studioId must not be empty")}
	}
	if v.StudioId != nil {
		if err := encoder.SetURI("studioId").String(*v.StudioId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpTagResource struct {
}

func (*awsRestjson1_serializeOpTagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpTagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*TagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-08-01/tags/{resourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsTagResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentTagResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsTagResourceInput(v *TagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member resourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("resourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentTagResourceInput(v *TagResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTags(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUntagResource struct {
}

func (*awsRestjson1_serializeOpUntagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUntagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UntagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-08-01/tags/{resourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUntagResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUntagResourceInput(v *UntagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member resourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("resourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	if v.TagKeys != nil {
		for i := range v.TagKeys {
			encoder.AddQuery("tagKeys").String(v.TagKeys[i])
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateLaunchProfile struct {
}

func (*awsRestjson1_serializeOpUpdateLaunchProfile) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateLaunchProfile) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateLaunchProfileInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-08-01/studios/{studioId}/launch-profiles/{launchProfileId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PATCH"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateLaunchProfileInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateLaunchProfileInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateLaunchProfileInput(v *UpdateLaunchProfileInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ClientToken != nil && len(*v.ClientToken) > 0 {
		locationName := "X-Amz-Client-Token"
		encoder.SetHeader(locationName).String(*v.ClientToken)
	}

	if v.LaunchProfileId == nil || len(*v.LaunchProfileId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member launchProfileId must not be empty")}
	}
	if v.LaunchProfileId != nil {
		if err := encoder.SetURI("launchProfileId").String(*v.LaunchProfileId); err != nil {
			return err
		}
	}

	if v.StudioId == nil || len(*v.StudioId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member studioId must not be empty")}
	}
	if v.StudioId != nil {
		if err := encoder.SetURI("studioId").String(*v.StudioId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateLaunchProfileInput(v *UpdateLaunchProfileInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.LaunchProfileProtocolVersions != nil {
		ok := object.Key("launchProfileProtocolVersions")
		if err := awsRestjson1_serializeDocumentLaunchProfileProtocolVersionList(v.LaunchProfileProtocolVersions, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.StreamConfiguration != nil {
		ok := object.Key("streamConfiguration")
		if err := awsRestjson1_serializeDocumentStreamConfigurationCreate(v.StreamConfiguration, ok); err != nil {
			return err
		}
	}

	if v.StudioComponentIds != nil {
		ok := object.Key("studioComponentIds")
		if err := awsRestjson1_serializeDocumentLaunchProfileStudioComponentIdList(v.StudioComponentIds, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateLaunchProfileMember struct {
}

func (*awsRestjson1_serializeOpUpdateLaunchProfileMember) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateLaunchProfileMember) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateLaunchProfileMemberInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-08-01/studios/{studioId}/launch-profiles/{launchProfileId}/membership/{principalId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PATCH"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateLaunchProfileMemberInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateLaunchProfileMemberInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateLaunchProfileMemberInput(v *UpdateLaunchProfileMemberInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ClientToken != nil && len(*v.ClientToken) > 0 {
		locationName := "X-Amz-Client-Token"
		encoder.SetHeader(locationName).String(*v.ClientToken)
	}

	if v.LaunchProfileId == nil || len(*v.LaunchProfileId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member launchProfileId must not be empty")}
	}
	if v.LaunchProfileId != nil {
		if err := encoder.SetURI("launchProfileId").String(*v.LaunchProfileId); err != nil {
			return err
		}
	}

	if v.PrincipalId == nil || len(*v.PrincipalId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member principalId must not be empty")}
	}
	if v.PrincipalId != nil {
		if err := encoder.SetURI("principalId").String(*v.PrincipalId); err != nil {
			return err
		}
	}

	if v.StudioId == nil || len(*v.StudioId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member studioId must not be empty")}
	}
	if v.StudioId != nil {
		if err := encoder.SetURI("studioId").String(*v.StudioId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateLaunchProfileMemberInput(v *UpdateLaunchProfileMemberInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Persona) > 0 {
		ok := object.Key("persona")
		ok.String(string(v.Persona))
	}

	return nil
}

type awsRestjson1_serializeOpUpdateStreamingImage struct {
}

func (*awsRestjson1_serializeOpUpdateStreamingImage) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateStreamingImage) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateStreamingImageInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-08-01/studios/{studioId}/streaming-images/{streamingImageId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PATCH"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateStreamingImageInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateStreamingImageInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateStreamingImageInput(v *UpdateStreamingImageInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ClientToken != nil && len(*v.ClientToken) > 0 {
		locationName := "X-Amz-Client-Token"
		encoder.SetHeader(locationName).String(*v.ClientToken)
	}

	if v.StreamingImageId == nil || len(*v.StreamingImageId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member streamingImageId must not be empty")}
	}
	if v.StreamingImageId != nil {
		if err := encoder.SetURI("streamingImageId").String(*v.StreamingImageId); err != nil {
			return err
		}
	}

	if v.StudioId == nil || len(*v.StudioId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member studioId must not be empty")}
	}
	if v.StudioId != nil {
		if err := encoder.SetURI("studioId").String(*v.StudioId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateStreamingImageInput(v *UpdateStreamingImageInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateStudio struct {
}

func (*awsRestjson1_serializeOpUpdateStudio) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateStudio) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateStudioInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-08-01/studios/{studioId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PATCH"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateStudioInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateStudioInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateStudioInput(v *UpdateStudioInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ClientToken != nil && len(*v.ClientToken) > 0 {
		locationName := "X-Amz-Client-Token"
		encoder.SetHeader(locationName).String(*v.ClientToken)
	}

	if v.StudioId == nil || len(*v.StudioId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member studioId must not be empty")}
	}
	if v.StudioId != nil {
		if err := encoder.SetURI("studioId").String(*v.StudioId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateStudioInput(v *UpdateStudioInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AdminRoleArn != nil {
		ok := object.Key("adminRoleArn")
		ok.String(*v.AdminRoleArn)
	}

	if v.DisplayName != nil {
		ok := object.Key("displayName")
		ok.String(*v.DisplayName)
	}

	if v.UserRoleArn != nil {
		ok := object.Key("userRoleArn")
		ok.String(*v.UserRoleArn)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateStudioComponent struct {
}

func (*awsRestjson1_serializeOpUpdateStudioComponent) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateStudioComponent) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateStudioComponentInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2020-08-01/studios/{studioId}/studio-components/{studioComponentId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PATCH"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateStudioComponentInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateStudioComponentInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateStudioComponentInput(v *UpdateStudioComponentInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ClientToken != nil && len(*v.ClientToken) > 0 {
		locationName := "X-Amz-Client-Token"
		encoder.SetHeader(locationName).String(*v.ClientToken)
	}

	if v.StudioComponentId == nil || len(*v.StudioComponentId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member studioComponentId must not be empty")}
	}
	if v.StudioComponentId != nil {
		if err := encoder.SetURI("studioComponentId").String(*v.StudioComponentId); err != nil {
			return err
		}
	}

	if v.StudioId == nil || len(*v.StudioId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member studioId must not be empty")}
	}
	if v.StudioId != nil {
		if err := encoder.SetURI("studioId").String(*v.StudioId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateStudioComponentInput(v *UpdateStudioComponentInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Configuration != nil {
		ok := object.Key("configuration")
		if err := awsRestjson1_serializeDocumentStudioComponentConfiguration(v.Configuration, ok); err != nil {
			return err
		}
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.Ec2SecurityGroupIds != nil {
		ok := object.Key("ec2SecurityGroupIds")
		if err := awsRestjson1_serializeDocumentStudioComponentSecurityGroupIdList(v.Ec2SecurityGroupIds, ok); err != nil {
			return err
		}
	}

	if v.InitializationScripts != nil {
		ok := object.Key("initializationScripts")
		if err := awsRestjson1_serializeDocumentStudioComponentInitializationScriptList(v.InitializationScripts, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.RuntimeRoleArn != nil {
		ok := object.Key("runtimeRoleArn")
		ok.String(*v.RuntimeRoleArn)
	}

	if v.ScriptParameters != nil {
		ok := object.Key("scriptParameters")
		if err := awsRestjson1_serializeDocumentStudioComponentScriptParameterKeyValueList(v.ScriptParameters, ok); err != nil {
			return err
		}
	}

	if v.SecureInitializationRoleArn != nil {
		ok := object.Key("secureInitializationRoleArn")
		ok.String(*v.SecureInitializationRoleArn)
	}

	if len(v.Subtype) > 0 {
		ok := object.Key("subtype")
		ok.String(string(v.Subtype))
	}

	if len(v.Type) > 0 {
		ok := object.Key("type")
		ok.String(string(v.Type))
	}

	return nil
}

func awsRestjson1_serializeDocumentActiveDirectoryComputerAttribute(v *types.ActiveDirectoryComputerAttribute, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.Value != nil {
		ok := object.Key("value")
		ok.String(*v.Value)
	}

	return nil
}

func awsRestjson1_serializeDocumentActiveDirectoryComputerAttributeList(v []types.ActiveDirectoryComputerAttribute, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentActiveDirectoryComputerAttribute(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentActiveDirectoryConfiguration(v *types.ActiveDirectoryConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ComputerAttributes != nil {
		ok := object.Key("computerAttributes")
		if err := awsRestjson1_serializeDocumentActiveDirectoryComputerAttributeList(v.ComputerAttributes, ok); err != nil {
			return err
		}
	}

	if v.DirectoryId != nil {
		ok := object.Key("directoryId")
		ok.String(*v.DirectoryId)
	}

	if v.OrganizationalUnitDistinguishedName != nil {
		ok := object.Key("organizationalUnitDistinguishedName")
		ok.String(*v.OrganizationalUnitDistinguishedName)
	}

	return nil
}

func awsRestjson1_serializeDocumentComputeFarmConfiguration(v *types.ComputeFarmConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ActiveDirectoryUser != nil {
		ok := object.Key("activeDirectoryUser")
		ok.String(*v.ActiveDirectoryUser)
	}

	if v.Endpoint != nil {
		ok := object.Key("endpoint")
		ok.String(*v.Endpoint)
	}

	return nil
}

func awsRestjson1_serializeDocumentEC2SubnetIdList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentEulaIdList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentLaunchProfileProtocolVersionList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentLaunchProfileStudioComponentIdList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentLicenseServiceConfiguration(v *types.LicenseServiceConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Endpoint != nil {
		ok := object.Key("endpoint")
		ok.String(*v.Endpoint)
	}

	return nil
}

func awsRestjson1_serializeDocumentNewLaunchProfileMember(v *types.NewLaunchProfileMember, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Persona) > 0 {
		ok := object.Key("persona")
		ok.String(string(v.Persona))
	}

	if v.PrincipalId != nil {
		ok := object.Key("principalId")
		ok.String(*v.PrincipalId)
	}

	return nil
}

func awsRestjson1_serializeDocumentNewLaunchProfileMemberList(v []types.NewLaunchProfileMember, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentNewLaunchProfileMember(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentNewStudioMember(v *types.NewStudioMember, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Persona) > 0 {
		ok := object.Key("persona")
		ok.String(string(v.Persona))
	}

	if v.PrincipalId != nil {
		ok := object.Key("principalId")
		ok.String(*v.PrincipalId)
	}

	return nil
}

func awsRestjson1_serializeDocumentNewStudioMemberList(v []types.NewStudioMember, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentNewStudioMember(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentScriptParameterKeyValue(v *types.ScriptParameterKeyValue, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Key != nil {
		ok := object.Key("key")
		ok.String(*v.Key)
	}

	if v.Value != nil {
		ok := object.Key("value")
		ok.String(*v.Value)
	}

	return nil
}

func awsRestjson1_serializeDocumentSharedFileSystemConfiguration(v *types.SharedFileSystemConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Endpoint != nil {
		ok := object.Key("endpoint")
		ok.String(*v.Endpoint)
	}

	if v.FileSystemId != nil {
		ok := object.Key("fileSystemId")
		ok.String(*v.FileSystemId)
	}

	if v.LinuxMountPoint != nil {
		ok := object.Key("linuxMountPoint")
		ok.String(*v.LinuxMountPoint)
	}

	if v.ShareName != nil {
		ok := object.Key("shareName")
		ok.String(*v.ShareName)
	}

	if v.WindowsMountDrive != nil {
		ok := object.Key("windowsMountDrive")
		ok.String(*v.WindowsMountDrive)
	}

	return nil
}

func awsRestjson1_serializeDocumentStreamConfigurationCreate(v *types.StreamConfigurationCreate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.ClipboardMode) > 0 {
		ok := object.Key("clipboardMode")
		ok.String(string(v.ClipboardMode))
	}

	if v.Ec2InstanceTypes != nil {
		ok := object.Key("ec2InstanceTypes")
		if err := awsRestjson1_serializeDocumentStreamingInstanceTypeList(v.Ec2InstanceTypes, ok); err != nil {
			return err
		}
	}

	if v.MaxSessionLengthInMinutes != 0 {
		ok := object.Key("maxSessionLengthInMinutes")
		ok.Integer(v.MaxSessionLengthInMinutes)
	}

	if v.MaxStoppedSessionLengthInMinutes != 0 {
		ok := object.Key("maxStoppedSessionLengthInMinutes")
		ok.Integer(v.MaxStoppedSessionLengthInMinutes)
	}

	if v.SessionStorage != nil {
		ok := object.Key("sessionStorage")
		if err := awsRestjson1_serializeDocumentStreamConfigurationSessionStorage(v.SessionStorage, ok); err != nil {
			return err
		}
	}

	if v.StreamingImageIds != nil {
		ok := object.Key("streamingImageIds")
		if err := awsRestjson1_serializeDocumentStreamingImageIdList(v.StreamingImageIds, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentStreamConfigurationSessionStorage(v *types.StreamConfigurationSessionStorage, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Mode != nil {
		ok := object.Key("mode")
		if err := awsRestjson1_serializeDocumentStreamingSessionStorageModeList(v.Mode, ok); err != nil {
			return err
		}
	}

	if v.Root != nil {
		ok := object.Key("root")
		if err := awsRestjson1_serializeDocumentStreamingSessionStorageRoot(v.Root, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentStreamingImageIdList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentStreamingInstanceTypeList(v []types.StreamingInstanceType, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentStreamingSessionStorageModeList(v []types.StreamingSessionStorageMode, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentStreamingSessionStorageRoot(v *types.StreamingSessionStorageRoot, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Linux != nil {
		ok := object.Key("linux")
		ok.String(*v.Linux)
	}

	if v.Windows != nil {
		ok := object.Key("windows")
		ok.String(*v.Windows)
	}

	return nil
}

func awsRestjson1_serializeDocumentStudioComponentConfiguration(v *types.StudioComponentConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ActiveDirectoryConfiguration != nil {
		ok := object.Key("activeDirectoryConfiguration")
		if err := awsRestjson1_serializeDocumentActiveDirectoryConfiguration(v.ActiveDirectoryConfiguration, ok); err != nil {
			return err
		}
	}

	if v.ComputeFarmConfiguration != nil {
		ok := object.Key("computeFarmConfiguration")
		if err := awsRestjson1_serializeDocumentComputeFarmConfiguration(v.ComputeFarmConfiguration, ok); err != nil {
			return err
		}
	}

	if v.LicenseServiceConfiguration != nil {
		ok := object.Key("licenseServiceConfiguration")
		if err := awsRestjson1_serializeDocumentLicenseServiceConfiguration(v.LicenseServiceConfiguration, ok); err != nil {
			return err
		}
	}

	if v.SharedFileSystemConfiguration != nil {
		ok := object.Key("sharedFileSystemConfiguration")
		if err := awsRestjson1_serializeDocumentSharedFileSystemConfiguration(v.SharedFileSystemConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentStudioComponentInitializationScript(v *types.StudioComponentInitializationScript, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.LaunchProfileProtocolVersion != nil {
		ok := object.Key("launchProfileProtocolVersion")
		ok.String(*v.LaunchProfileProtocolVersion)
	}

	if len(v.Platform) > 0 {
		ok := object.Key("platform")
		ok.String(string(v.Platform))
	}

	if len(v.RunContext) > 0 {
		ok := object.Key("runContext")
		ok.String(string(v.RunContext))
	}

	if v.Script != nil {
		ok := object.Key("script")
		ok.String(*v.Script)
	}

	return nil
}

func awsRestjson1_serializeDocumentStudioComponentInitializationScriptList(v []types.StudioComponentInitializationScript, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentStudioComponentInitializationScript(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentStudioComponentScriptParameterKeyValueList(v []types.ScriptParameterKeyValue, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentScriptParameterKeyValue(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentStudioComponentSecurityGroupIdList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentStudioEncryptionConfiguration(v *types.StudioEncryptionConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.KeyArn != nil {
		ok := object.Key("keyArn")
		ok.String(*v.KeyArn)
	}

	if len(v.KeyType) > 0 {
		ok := object.Key("keyType")
		ok.String(string(v.KeyType))
	}

	return nil
}

func awsRestjson1_serializeDocumentTags(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}
