package incident

import (
	"bytes"
	"io"
	"os"
	"testing"

	"github.com/alecthomas/assert"
	"gitlab.com/gitlab-org/cli/commands/cmdutils"
)

func TestIncidentCmd(t *testing.T) {
	old := os.Stdout
	r, w, _ := os.Pipe()
	os.Stdout = w

	assert.Nil(t, NewCmdIncident(&cmdutils.Factory{}).Execute())

	outC := make(chan string)
	// copy the output in a separate goroutine so printing can't block indefinitely
	go func() {
		var buf bytes.Buffer
		_, _ = io.Copy(&buf, r)
		outC <- buf.String()
	}()

	// back to normal state
	w.Close()
	os.Stdout = old // restoring the real stdout
	out := <-outC

	assert.Contains(t, out, "Work with GitLab incidents\n")
}
