Gfsecret - Secret sharing tools
===============================

Gfsecret is a set of tools to facilitate secret sharing according to the
[Adi Shamir’s secret sharing
scheme](http://dl.acm.org/citation.cfm?id=359176).

Two tools are provided: _gfsec-split_ will split a file into several
shares, and _gfsec-use_ will reconstruct the original file from some of
the shares.


Share URIs
----------
Both tools use the concept of a _share URI_, which is a way of
describing a share with a URI-like syntax. The _gfsec-split_ program
uses them to know where to dispatch the generated shares, and
_gfsec-use_ uses them to know where to search for shares in order to
reconstruct the original file.

A share URI has the following form:

    scheme://authority/path?parameters

The _scheme_ part indicates the method to use to access the share, and
can be `file` (to access a share on the local filesystem), `label` (to
access a share on an external volume identified by its label), `uuid`
(to access a share on an external volume identified by its UUID), `mtp`
(to access a share on a MTP-compliant device identified by its serial
number), or `http` or `https` (to access a share on a remote web
server).

The _authority_ part identifies the storage device. It's the volume's
label when using the `label://` scheme, its UUID when using the
`uuid://` scheme, the device's serial number when using the `mtp://`
scheme, and the hostname when using the `http(s)://` scheme. In the
`file://` scheme, that part should be empty.

The _path_ part is the pathname to the share file on the device.

Finally, the _parameters_ part, which is optional, may specify options
as `key=value` pairs. Currently, valid options are `sha256`, which
specifies a SHA2-256 hash that the share should match, and `share=no`,
which indicates that the corresponding share is not actually a share but
contains the whole secret.


gfsec-split
-----------
The _gfsec-split_ program allows to split a file into _M_ shares,
dispatch them at distinct locations (including external storage
devices), then delete the original file.

The program takes the path to the file to split as its first positional
argument. The remaining positional arguments are URIs describing the
shares to create using the URI syntax described above.

Consider the following example:

    gfsec-split -n 2 \
      /home/alice/mysecret \
      file:///home/alice/.local/share/gfsecret/mysecret \
      label://USBSTICK/mysecret \
      mtp://RF2GB6X704P/Documents/mysecret

This will split the file `/home/alice/mysecret` into three shares: one
in Alice's home directory on the local filesystem, one on a USB storage
device with the label `USBSTICK`, and one on a MTP-compliant device with
the serial number `RF2GB6X704P`. Two shares will be needed to
reconstruct the original file, which means in this case that one of the
two removable devices will have to be present.

Note that the shares need not to have the same basename than the
original file.

Once the file is split, _gfsec-split_ will delete the original file
(unless you used the `-k` option), and will create a configuration file
in `$XDG_CONFIG_HOME/gfsecret/mysecret` (or at any location specified by
the `-c` option) which could later be used by _gfsec-use_.

If you move the shares around after they have been generated, you should
take care of updating that configuration file, otherwise _gfsec-use_
will be unable to fetch the shares.

As a convenience, before splitting you may call _gfsec-split_ with the
single `-l` option to list the available external volumes and their
identifiers. Alternatively, the `-i` option may be used to both list
the available volumes and select those to use in an interactive menu.


gfsec-use
---------
The _gfsec-use_ program allows to temporarily reconstruct a split
file from shares that have been dispersed on several external devices.

The program needs a configuration file (by default,
`$XDG_CONFIG_HOME/gfsecret/default.conf`) which describes the shared
secret. If the original file has been split using the _gfsec-split_
program, the configuration file will have been automatically generated.

For example, here is the configuration file that could have been
generated by the example above:

    OUTFILE=/home/alice/mysecret
    MINSHARES=2
    URI=file:///home/alice/.local/share/gfsecret/mysecret.024
    URI=label://MYSTICK/mysecret.070
    URI=mtp://RF2GB6X704P/Documents/mysecret.139

With such a configuration, _gfse-use_ will attempt to reconstruct the
file `/home/alice/mysecret`, using at least two of the three available
shares: one available on the local filesystem, one on a USB storage
device with the label `MYSTICK`, and one on a MTP-compliant device with
the serial number `RF2GB6X704P`. _Gfsec-use_ will automatically detect
which devices are currently connected and will fetch from them the
corresponding shares.

Once the secret file has been reconstructed (if enough shares are
available), _gfsec-use_ will spawn a new shell (or any other program
specified on its command line). When the shell (or the user-specified
command) terminates, the reconstructed secret file will be automatically
deleted.


Install
-------
Gfsecret depends on the following libraries at compile-time:

- [libgfshare](http://www.digital-scurf.org/software/libgfshare), which
  implements the secret sharing scheme proper (mandatory);
- [libgcrypt](http://www.gnupg.org/), for the SHA-256 implementation
  and random number generation (mandatory);
- [GIO](http://developer.gnome.org/gio/), to access shares stored on
  external volumes (typically USB storage) (optional);
- [libmtp](http://libmtp.sourceforge.net/), to access shares stored on
  MTP-compliant devices (optional).
- [libcurl](http://curl.se/), to access shares stored on remote web
  servers (optional).


Copying
-------
Gfsecret is distributed under the terms of the GNU General Public
License, version 3 or higher. The full license is included in the
[COPYING file](COPYING) of the source distribution.


Homepage and repository
-----------------------
The project is located at https://incenp.org/dvlpt/gfsecret.html.
The latest source code is available at https://git.incenp.org/damien/gfsecret.
