(* testtime.mod create processes which test the TimerHandler.

Copyright (C) 2001-2021 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius.mulley@southwales.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Modula-2; see the file COPYING3.  If not see
<http://www.gnu.org/licenses/>.  *)

MODULE testtime ;


FROM Debug IMPORT Halt ;
FROM StdIO IMPORT PushOutput ;
FROM StrIO IMPORT WriteString, WriteLn ;
FROM NumberIO IMPORT WriteCard ;
FROM TimerHandler IMPORT EVENT, TicksPerSecond, Sleep, ArmEvent,
                         Cancel, WaitOn, ReArmEvent ;
FROM SYSTEM IMPORT TurnInterrupts ;
FROM COROUTINES IMPORT PROTECTION ;
FROM Executive IMPORT DESCRIPTOR, InitProcess, Resume, Ps ;
FROM SYSTEM IMPORT ADR ;
FROM libc IMPORT write ;


(*
   LocalWrite -
*)

PROCEDURE LocalWrite (ch: CHAR) ;
VAR
   r: INTEGER ;
BEGIN
   r := write (1, ADR (ch), 1)
END LocalWrite ;


(*
   TwoSeconds -
*)

PROCEDURE TwoSeconds ;
VAR
   seconds: CARDINAL ;
BEGIN
   OldInts := TurnInterrupts (MIN (PROTECTION)) ;
   WriteString ('.') ;
   seconds := 0 ;
   LOOP
      Sleep (2*TicksPerSecond) ;
      INC (seconds, 2) ;
      WriteCard (seconds, 2) ;
      WriteString (', generated by 2 second alarm') ;
      WriteLn
   END
END TwoSeconds ;


(*
   FiveSeconds -
*)

PROCEDURE FiveSeconds ;
VAR
   seconds: CARDINAL ;
BEGIN
   OldInts := TurnInterrupts (MIN (PROTECTION)) ;
   WriteString ('.') ;
   seconds := 0 ;
   LOOP
      Sleep (5*TicksPerSecond) ;
      INC (seconds, 5) ;
      WriteCard (seconds, 2) ;
      WriteString (', generated by 5 second alarm') ;
      WriteLn ;
   END
END FiveSeconds ;


(*
   TwentySeconds -
*)

PROCEDURE TwentySeconds ;
BEGIN
   OldInts := TurnInterrupts (MAX(PROTECTION)) ;
   WriteString ('.') ;
   LOOP
      Timeout := ArmEvent (20*TicksPerSecond) ;
      IF WaitOn (Timeout)
      THEN
         WriteString ('...someone cancelled it...')
      ELSE
         WriteString ('20 second alarm')
      END ;
      WriteLn
   END
END TwentySeconds ;


CONST
   StackSize = 0100000H ;

VAR
   p2, p5,
   p20     : DESCRIPTOR ;
   OldInts : PROTECTION ;
   Timeout : EVENT ;
   ch      : CHAR ;
BEGIN
   OldInts := TurnInterrupts (MIN (PROTECTION)) ;
   PushOutput (LocalWrite) ;
   WriteString ('got to OS') ; WriteLn ;

   WriteString ('now to create three processes...') ;  WriteLn ;

   p2 := Resume (InitProcess (TwoSeconds , StackSize, '2')) ;
   p5 := Resume (InitProcess (FiveSeconds, StackSize, '5')) ;
   (* p20 := Resume (InitProcess (TwoSeconds, StackSize, '20')) ; *)

   Sleep (30*TicksPerSecond) ;
   WriteString ('successfully completed, bye') ; WriteLn
END testtime.
