# ![Boost.Geometry](doc/other/logo/logo_bkg.png)

Boost.Geometry, part of collection of the [Boost C++ Libraries](http://github.com/boostorg), defines concepts, primitives and algorithms for solving geometry problems. Boost.Geometry is a C++14 header-only library.

[![Licence](https://img.shields.io/badge/license-boost-4480cc.png)](http://www.boost.org/LICENSE_1_0.txt)
[![Documentation](https://img.shields.io/badge/-documentation-4480cc.png)](http://boost.org/libs/geometry)
[![Wiki](https://img.shields.io/badge/-wiki-4480cc.png)](https://github.com/boostorg/geometry/wiki)
[![Mailing List](https://img.shields.io/badge/-mailing%20list-4eb899.png)](http://lists.boost.org/geometry/)
[![Chat](https://badges.gitter.im/boostorg/geometry.png)](https://gitter.im/boostorg/geometry?utm_source=badge&utm_medium=badge&utm_campaign=pr-badge&utm_content=badge)

### Test results

 Branch     | Build         | Coverage       | Regression | Documentation
------------|---------------|----------------|------------|--------------
**develop** | [![circleci](https://circleci.com/gh/boostorg/geometry/tree/develop.svg?style=shield)](https://circleci.com/gh/boostorg/geometry/tree/develop) <br> [![minimal](https://github.com/boostorg/geometry/actions/workflows/minimal.yml/badge.svg?branch=develop)](https://github.com/boostorg/geometry/actions?query=branch:develop+workflow:minimal) | [![coveralls](https://coveralls.io/repos/github/boostorg/geometry/badge.svg?branch=develop)](https://coveralls.io/github/boostorg/geometry?branch=develop) <br> [![codecov](https://codecov.io/gh/boostorg/geometry/branch/develop/graph/badge.svg)](https://codecov.io/gh/boostorg/geometry/branch/develop) | [![geometry](https://img.shields.io/badge/-geometry-4480cc.png)](https://regression.boost.io/develop/developer/geometry.html) [![index](https://img.shields.io/badge/-index-4480cc.png)](https://regression.boost.io/develop/developer/geometry-index.html) [![extensions](https://img.shields.io/badge/-extensions-4480cc.png)](https://regression.boost.io/develop/developer/geometry-extensions.html) | [![documentation](https://github.com/boostorg/geometry/actions/workflows/documentation.yml/badge.svg?branch=develop)](https://github.com/boostorg/geometry/actions?query=branch:develop+workflow:documentation)
**master**  | [![circleci](https://circleci.com/gh/boostorg/geometry/tree/master.svg?style=shield)](https://circleci.com/gh/boostorg/geometry/tree/master)   <br> [![minimal](https://github.com/boostorg/geometry/actions/workflows/minimal.yml/badge.svg?branch=master)](https://github.com/boostorg/geometry/actions?query=branch:master+workflow:minimal)   | [![coveralls](https://coveralls.io/repos/github/boostorg/geometry/badge.svg?branch=master)](https://coveralls.io/github/boostorg/geometry?branch=master)   <br> [![codecov](https://codecov.io/gh/boostorg/geometry/branch/master/graph/badge.svg)](https://codecov.io/gh/boostorg/geometry/branch/master)   | [![geometry](https://img.shields.io/badge/-geometry-4480cc.png)](https://regression.boost.io/master/developer/geometry.html)  [![index](https://img.shields.io/badge/-index-4480cc.png)](https://regression.boost.io/master/developer/geometry-index.html)                                                                                                                                                          | [![documentation](https://github.com/boostorg/geometry/actions/workflows/documentation.yml/badge.svg?branch=master)](https://github.com/boostorg/geometry/actions?query=branch:master+workflow:documentation)

### Directories

* **doc** - QuickBook documentation sources
* **example** - Boost.Geometry examples
* **_extensions_** - examples and tests for the extensions - _develop branch_
* **include** - the sourcecode of Boost.Geometry
* **index** - examples and tests for the Spatial Index
* **meta** - library metadata
* **test** - Boost.Geometry unit tests
