# 2024-12-09 Triage Log

A pretty quiet week, with both few PRs landed and no significant changes in performance.

Triage done by **@simulacrum**.
Revision range: [490b2cc0..1b3fb316](https://perf.rust-lang.org/?start=490b2cc09860dd62a7595bb07364d71c12ce4e60&end=1b3fb316751227d30b1523ed0e3f00d83956d4d0&absolute=false&stat=instructions%3Au)

**Summary**:

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3%  | [0.1%, 1.4%]   | 84    |
| Regressions ❌ <br /> (secondary)  | 0.3%  | [0.1%, 0.7%]   | 45    |
| Improvements ✅ <br /> (primary)   | -0.4% | [-1.2%, -0.1%] | 42    |
| Improvements ✅ <br /> (secondary) | -0.8% | [-1.2%, -0.4%] | 19    |
| All ❌✅ (primary)                 | 0.1%  | [-1.2%, 1.4%]  | 126   |


0 Regressions, 1 Improvements, 6 Mixed; 4 of them in rollups
25 artifact comparisons made in total

#### Regressions

None this week.

#### Improvements

Remove polymorphization [#133883](https://github.com/rust-lang/rust/pull/133883) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=75716b45105e443199ce9800c7009ddfd6d2be53&end=ca13e9169fbbbb126190631b5a1e3e20053a52c1&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.5%  | [0.3%, 0.7%]   | 6     |
| Improvements ✅ <br /> (primary)   | -0.5% | [-1.3%, -0.1%] | 91    |
| Improvements ✅ <br /> (secondary) | -0.7% | [-1.7%, -0.3%] | 21    |
| All ❌✅ (primary)                 | -0.5% | [-1.3%, -0.1%] | 91    |

This is essentially a solid improvement. We still did the evaluation of
polymorphization even if it wasn't actually enabled, so this just saves that
time by dropping all of that computation.

#### Mixed

Rollup of 6 pull requests [#133841](https://github.com/rust-lang/rust/pull/133841) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=2633e019298f8d9f671c8f3d0d3348ce6fa1b8aa&end=733616f7236b4be140ce851a30b3bb06532b9364&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.7%  | [0.2%, 1.4%]   | 10    |
| Regressions ❌ <br /> (secondary)  | 0.6%  | [0.6%, 0.6%]   | 1     |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.5%, -0.1%] | 2     |
| Improvements ✅ <br /> (secondary) | -0.2% | [-0.4%, -0.1%] | 5     |
| All ❌✅ (primary)                 | 0.5%  | [-0.5%, 1.4%]  | 12    |

Mixed results, but seems like a real regression on a few larger benchmarks in
opt, non-incremental scenarios. Possibly due to
https://github.com/rust-lang/rust/pull/133798, trying an unrolled build to
verify.

Rollup of 8 pull requests [#133940](https://github.com/rust-lang/rust/pull/133940) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=c94848c046d29f9a80c09aae758e27e418a289f2&end=706141b8d9090228343340378b1d4a2b095fa1fb&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4%  | [0.1%, 0.9%]   | 87    |
| Regressions ❌ <br /> (secondary)  | 0.4%  | [0.1%, 1.4%]   | 31    |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -1.7% | [-1.9%, -1.6%] | 6     |
| All ❌✅ (primary)                 | 0.4%  | [0.1%, 0.9%]   | 87    |

Root-caused and discussed here:
https://github.com/rust-lang/rust/pull/133607#issuecomment-2524194699, some
optimizations expected to reduce the impact.

Implementation of `fmt::FormattingOptions` [#118159](https://github.com/rust-lang/rust/pull/118159) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=8dc83770f748c6cd16b342889ca2240397c19534&end=75716b45105e443199ce9800c7009ddfd6d2be53&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3%  | [0.2%, 0.4%]   | 2     |
| Regressions ❌ <br /> (secondary)  | 0.3%  | [0.3%, 0.3%]   | 1     |
| Improvements ✅ <br /> (primary)   | -0.4% | [-0.4%, -0.4%] | 1     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | 0.1%  | [-0.4%, 0.4%]  | 3     |

A few regressions in primary benchmarks, but not worth follow-up given the
small magnitude, small number of affected builds, lack of clear `cycles`
impact, etc.

Rollup of 7 pull requests [#133978](https://github.com/rust-lang/rust/pull/133978) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=cdb89d6b15056a5cfa8932231360ae358b08983f&end=9c707a8b769523bb6768bf58e74fa2c39cc24844&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3%  | [0.3%, 0.3%]   | 1     |
| Regressions ❌ <br /> (secondary)  | 0.3%  | [0.2%, 0.3%]   | 9     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.2% | [-0.3%, -0.1%] | 2     |
| All ❌✅ (primary)                 | 0.3%  | [0.3%, 0.3%]   | 1     |

Expected regression in doc builds due to additional trait implementations in the standard library.

Rollup of 7 pull requests [#134033](https://github.com/rust-lang/rust/pull/134033) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=f415c07494b98e4559e4b13a9c5f867b0e6b2444&end=f33a8c6426074b7ce8d08740e9805fdca96ee150&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3%  | [0.2%, 0.3%]   | 6     |
| Regressions ❌ <br /> (secondary)  | 0.3%  | [0.2%, 0.5%]   | 6     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -1.3% | [-2.2%, -0.3%] | 2     |
| All ❌✅ (primary)                 | 0.3%  | [0.2%, 0.3%]   | 6     |

Single benchmark regression, limited to incremental scenarios. Seems plausible
this is due to #133992, which obviously does more (necessary for correctness)
work.

Introduce `MixedBitSet` [#133891](https://github.com/rust-lang/rust/pull/133891) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=1b3fb316751227d30b1523ed0e3f00d83956d4d0&end=f6cb952dc115fd1311b02b694933e31d8dc8b002&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.6%  | [0.2%, 1.0%]   | 8     |
| Improvements ✅ <br /> (primary)   | -0.6% | [-1.3%, -0.2%] | 67    |
| Improvements ✅ <br /> (secondary) | -0.7% | [-2.0%, -0.2%] | 28    |
| All ❌✅ (primary)                 | -0.6% | [-1.3%, -0.2%] | 67    |

Expected changes, primarily an improvement rather than a regression. Overall a positive change.
