% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/by_splitBy.R
\name{by-split}
\alias{by-split}
\alias{split_by}
\alias{splitBy}
\alias{head.splitByData}
\alias{tail.splitByData}
\alias{split_by.legacy}
\alias{splitBy.legacy}
\title{Split a data frame into groups defined by variable(s)}
\usage{
split_by(data., ..., omit = TRUE)

splitBy(formula, data, omit = TRUE)

\method{head}{splitByData}(x, n = 6L, ...)

\method{tail}{splitByData}(x, n = 6L, ...)

split_by.legacy(data, formula, drop = TRUE)

splitBy.legacy(formula, data = parent.frame(), drop = TRUE)
}
\arguments{
\item{data.}{A data frame (or tibble) to split}

\item{...}{Variables defining the groups}

\item{omit}{If TRUE (default), group-defining variables are omitted in each split group}

\item{formula}{A right hand sided formula (for the old interface)}

\item{data}{A data frame  (for the old interface)}

\item{x}{A splitByData object.}

\item{n}{An integer vector.}

\item{drop}{Obsolete}
}
\value{
An object of class \"splitByData\" (a named list with group attributes)
}
\description{
Split a dataframe according to the levels of variables
in the dataframe. Uses vparse() to interpret flexible input.
}
\examples{

split_by(CO2, ~Treatment+Type)
split_by(CO2, Treatment, Type)
split_by(CO2, c("Treatment", "Type"))
split_by(CO2, "Treatment", "Type")

x <- split_by(CO2, "Treatment", "Type")
head(x, 3)
tail(x, 3)

## Via wrapper:
foo2 <- function(x) {
 x <- rlang::enquo(x)
 split_by(CO2, !!x)
}
foo2(~Treatment)

## The "Old" interface
splitBy(~Treatment + Type, CO2)
splitBy(~Treatment + Type, data=CO2)
splitBy(c("Treatment", "Type"), data=CO2)

}
\seealso{
\code{\link{orderBy}}, \code{\link{order_by}},
\code{\link{summaryBy}}, \code{\link{summary_by}},
\code{\link{transformBy}}, \code{\link{transform_by}}
}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk}
}
\concept{byfunction}
\keyword{utilities}
