#!/bin/bash

# Helper script to repack the sources of minijinja. The full source is
# available and taken from:
#
#    https://github.com/mitsuhiko/minijinja
#
# It's part of the Debian packaging for python-minijinja.

set -e -u

# Exit if not called by gbp.
if [[ ${GBP_TMP_DIR:-"unset"} == "unset" ]]; then
    echo
    echo "Environment \$GBP_TMP_DIR is not defined! This script is intended to be called by gbp (git-buildpackage)!"
    echo
    exit 1
fi

cd "$GBP_SOURCES_DIR"

# Removing all files in the top folder of the archive.
find -maxdepth 1 -type f -exec rm -rf {} \;

# Removing all folders except 'minijinja-py' and 'minijinja-contrib'.
find -mindepth 1 -maxdepth 1 \( ! -name 'minijinja-py' -a ! -name 'minijinja-contrib' \) -type d -exec rm -rf {} \;

# Moving the content of 'minijinja-py' into the top folder, remove the empty folder.
mv minijinja-py/* .
rm -rf minijinja-py

# Remove the symlinking of minijinja-contrib/doc-header.html -> ../doc-header.html.
rm -f minijinja-contrib/doc-header.html
