# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class Access(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The network traffic is allowed or denied."""

    ALLOW = "allow"
    """The network traffic is allowed."""
    DENY = "deny"
    """The network traffic is denied."""


class AutoGeneratedDomainNameLabelScope(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """This enum is the entrypoint to using a certificate from a public CA for your cluster. This
    property was introduced to solve the
    domain squatting problem with new domains. A domain name will be generated in the following
    format: {clustername}.{hash}.{regionname}.sfmcdomain.
    The hash portion comes from Azure DNS' Deterministic Name Library. The library creates a hash
    using the cluster's Tenant, Subscription, Resource Group
    and Resource Name using the AutoGeneratedDomainNameLabelScope/reuse policy chosen.
    """

    TENANT_REUSE = "TenantReuse"
    """TenantReuse allows for the same hash to be created if the resource is created in the same
    Tenant with the same resource name."""
    SUBSCRIPTION_REUSE = "SubscriptionReuse"
    """SubscriptionReuse allows for the same hash to be created if the resource is created in the same
    Subscription with the same resource name."""
    RESOURCE_GROUP_REUSE = "ResourceGroupReuse"
    """ResourceGroupReuse allows for the same hash to be created if the resource is created in the
    same Resource Group with the same resource name."""
    NO_REUSE = "NoReuse"
    """NoReuse will create a new hash regardless of the Subscription, Resource Group, Tenant and
    Resource name."""


class ClusterState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The current state of the cluster."""

    WAITING_FOR_NODES = "WaitingForNodes"
    """Indicates that the cluster resource is created and the resource provider is waiting for Service
    Fabric VM extension to boot up and report to it."""
    DEPLOYING = "Deploying"
    """Indicates that the Service Fabric runtime is being installed on the VMs. Cluster resource will
    be in this state until the cluster boots up and system services are up."""
    BASELINE_UPGRADE = "BaselineUpgrade"
    """Indicates that the cluster is upgrading to establishes the cluster version. This upgrade is
    automatically initiated when the cluster boots up for the first time."""
    UPGRADING = "Upgrading"
    """Indicates that the cluster is being upgraded with the user provided configuration."""
    UPGRADE_FAILED = "UpgradeFailed"
    """Indicates that the last upgrade for the cluster has failed."""
    READY = "Ready"
    """Indicates that the cluster is in a stable state."""


class ClusterUpgradeCadence(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Indicates when new cluster runtime version upgrades will be applied after they are released. By
    default is Wave0.
    """

    WAVE0 = "Wave0"
    """Cluster upgrade starts immediately after a new version is rolled out. Recommended for Test/Dev
    clusters."""
    WAVE1 = "Wave1"
    """Cluster upgrade starts 7 days after a new version is rolled out. Recommended for Pre-prod
    clusters."""
    WAVE2 = "Wave2"
    """Cluster upgrade starts 14 days after a new version is rolled out. Recommended for Production
    clusters."""


class ClusterUpgradeMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The upgrade mode of the cluster when new Service Fabric runtime version is available."""

    AUTOMATIC = "Automatic"
    """The cluster will be automatically upgraded to the latest Service Fabric runtime version,
    **clusterUpgradeCadence** will determine when the upgrade starts after the new version becomes
    available."""
    MANUAL = "Manual"
    """The cluster will not be automatically upgraded to the latest Service Fabric runtime version.
    The cluster is upgraded by setting the **clusterCodeVersion** property in the cluster resource."""


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The kind of entity that created the resource."""

    USER = "User"
    """The entity was created by a user."""
    APPLICATION = "Application"
    """The entity was created by an application."""
    MANAGED_IDENTITY = "ManagedIdentity"
    """The entity was created by a managed identity."""
    KEY = "Key"
    """The entity was created by a key."""


class Direction(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Network security rule direction."""

    INBOUND = "inbound"
    """Inbound direction."""
    OUTBOUND = "outbound"
    """Outbound direction."""


class DiskType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Managed data disk type. IOPS and throughput are given by the disk size, to see more information
    go to `https://docs.microsoft.com/en-us/azure/virtual-machines/disks-types
    <https://docs.microsoft.com/en-us/azure/virtual-machines/disks-types>`_.
    """

    STANDARD_LRS = "Standard_LRS"
    """Standard HDD locally redundant storage. Best for backup, non-critical, and infrequent access."""
    STANDARD_SSD_LRS = "StandardSSD_LRS"
    """Standard SSD locally redundant storage. Best for web servers, lightly used enterprise
    applications and dev/test."""
    PREMIUM_LRS = "Premium_LRS"
    """Premium SSD locally redundant storage. Best for production and performance sensitive workloads."""
    PREMIUM_V2_LRS = "PremiumV2_LRS"
    """Premium SSD V2 locally redundant storage. Best for production and performance sensitive
    workloads that consistently require low latency and high IOPS and throughput."""
    STANDARD_SSD_ZRS = "StandardSSD_ZRS"
    """Standard SSD zone redundant storage. Best for web servers, lightly used enterprise applications
    and dev/test that need storage resiliency against zone failures."""
    PREMIUM_ZRS = "Premium_ZRS"
    """Premium SSD zone redundant storage. Best for production workloads that need storage resiliency
    against zone failures."""


class EvictionPolicyType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the eviction policy for virtual machines in a SPOT node type."""

    DELETE = "Delete"
    """Eviction policy will be Delete for SPOT vms."""
    DEALLOCATE = "Deallocate"
    """Eviction policy will be Deallocate for SPOT vms."""


class FailureAction(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The compensating action to perform when a Monitored upgrade encounters monitoring policy or
    health policy violations. Invalid indicates the failure action is invalid. Rollback specifies
    that the upgrade will start rolling back automatically. Manual indicates that the upgrade will
    switch to UnmonitoredManual upgrade mode.
    """

    ROLLBACK = "Rollback"
    """Indicates that a rollback of the upgrade will be performed by Service Fabric if the upgrade
    fails."""
    MANUAL = "Manual"
    """Indicates that a manual repair will need to be performed by the administrator if the upgrade
    fails. Service Fabric will not proceed to the next upgrade domain automatically."""


class FaultKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The kind of fault simulation."""

    ZONE = "Zone"
    """Simulates an availability zone down."""


class FaultSimulationStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Fault simulation status."""

    STARTING = "Starting"
    """Indicates the fault simulation is starting. The simulation will have this status while the
    start operation is in progress."""
    ACTIVE = "Active"
    """Indicates the fault simulation is active. The simulation will have this status after the start
    operation has completed successfully."""
    STOPPING = "Stopping"
    """Indicates the fault simulation is stopping. The simulation will have this status while the stop
    operation is in progress."""
    DONE = "Done"
    """Indicates the fault simulation is done. The simulation will have this status after the stop
    operation has completed successfully."""
    START_FAILED = "StartFailed"
    """Indicates the fault simulation has failed on start. The simulation will have this status after
    the start operation fails."""
    STOP_FAILED = "StopFailed"
    """Indicates the fault simulation has failed on stop. The simulation will have this status after
    the stop operation fails."""


class HealthFilter(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum for filtering health events."""

    DEFAULT = "Default"
    """Default value. Matches any health state."""
    NONE = "None"
    """Filter that doesn't match any health state. Used to return no results on a given collection of
    health entities."""
    OK = "Ok"
    """Filter for health state Ok."""
    WARNING = "Warning"
    """Filter for health state Warning."""
    ERROR = "Error"
    """Filter for health state Error."""
    ALL = "All"
    """Filter that matches input with any health state."""


class IPAddressType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The IP address type."""

    I_PV4 = "IPv4"
    """IPv4 address type."""
    I_PV6 = "IPv6"
    """IPv6 address type."""


class ManagedClusterAddOnFeature(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Available cluster add-on features."""

    DNS_SERVICE = "DnsService"
    """Dns service"""
    BACKUP_RESTORE_SERVICE = "BackupRestoreService"
    """Backup and restore service"""
    RESOURCE_MONITOR_SERVICE = "ResourceMonitorService"
    """Resource monitor service"""


class ManagedClusterVersionEnvironment(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The operating system of the cluster. The default means all."""

    WINDOWS = "Windows"
    """Indicates os is Windows."""


class ManagedIdentityType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of managed identity for the resource."""

    NONE = "None"
    """Indicates that no identity is associated with the resource."""
    SYSTEM_ASSIGNED = "SystemAssigned"
    """Indicates that system assigned identity is associated with the resource."""
    USER_ASSIGNED = "UserAssigned"
    """Indicates that user assigned identity is associated with the resource."""
    SYSTEM_ASSIGNED_USER_ASSIGNED = "SystemAssigned, UserAssigned"
    """Indicates that both system assigned and user assigned identity are associated with the
    resource."""


class ManagedResourceProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The provisioning state of the managed resource."""

    NONE = "None"
    """The resource does not have a provisioning state."""
    CREATING = "Creating"
    """The resource is being created."""
    CREATED = "Created"
    """The resource is created."""
    UPDATING = "Updating"
    """The resource is being updated."""
    SUCCEEDED = "Succeeded"
    """The resource provisioning has succeeded."""
    FAILED = "Failed"
    """The resource provisioning has failed."""
    CANCELED = "Canceled"
    """The resource provisioning has been canceled."""
    DELETING = "Deleting"
    """The resource is being deleted."""
    DELETED = "Deleted"
    """The resource has been deleted."""
    OTHER = "Other"
    """The resource provisioning state is a state other than the previously specified states."""


class MoveCost(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the move cost for the service."""

    ZERO = "Zero"
    """Zero move cost. This value is zero."""
    LOW = "Low"
    """Specifies the move cost of the service as Low. The value is 1."""
    MEDIUM = "Medium"
    """Specifies the move cost of the service as Medium. The value is 2."""
    HIGH = "High"
    """Specifies the move cost of the service as High. The value is 3."""


class NodeTypeSkuScaleType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Node type capacity scale type."""

    NONE = "None"
    """Node count is not adjustable in any way (e.g. it is fixed)."""
    MANUAL = "Manual"
    """The user must manually scale out/in."""
    AUTOMATIC = "Automatic"
    """Automatic scale is allowed."""


class NsgProtocol(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Network protocol this rule applies to."""

    HTTP = "http"
    """Protocol applies to HTTP."""
    HTTPS = "https"
    """Protocol applies to HTTPS."""
    TCP = "tcp"
    """Protocol applies to TCP."""
    UDP = "udp"
    """Protocol applies to UDP."""
    ICMP = "icmp"
    """Protocol applies to ICMP."""
    AH = "ah"
    """Protocol applies to AH."""
    ESP = "esp"
    """Protocol applies to ESP."""


class OsType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Cluster operating system, the default will be Windows."""

    WINDOWS = "Windows"
    """Indicates os is Windows."""


class PartitionScheme(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enumerates the ways that a service can be partitioned."""

    SINGLETON = "Singleton"
    """Indicates that the partition is based on string names, and is a SingletonPartitionScheme
    object, The value is 0."""
    UNIFORM_INT64_RANGE = "UniformInt64Range"
    """Indicates that the partition is based on Int64 key ranges, and is a
    UniformInt64RangePartitionScheme object. The value is 1."""
    NAMED = "Named"
    """Indicates that the partition is based on string names, and is a NamedPartitionScheme object.
    The value is 2."""


class PrivateEndpointNetworkPolicies(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enable or Disable apply network policies on private end point in the subnet."""

    ENABLED = "enabled"
    """Enable apply network policies on private end point in the subnet."""
    DISABLED = "disabled"
    """Disable apply network policies on private end point in the subnet."""


class PrivateIPAddressVersion(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies whether the IP configuration's private IP is IPv4 or IPv6. Default is IPv4."""

    I_PV4 = "IPv4"
    """The IP configuration's private IP is IPv4."""
    I_PV6 = "IPv6"
    """The IP configuration's private IP is IPv6."""


class PrivateLinkServiceNetworkPolicies(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enable or Disable apply network policies on private link service in the subnet."""

    ENABLED = "enabled"
    """Enable apply network policies on private link service in the subnet."""
    DISABLED = "disabled"
    """Disable apply network policies on private link service in the subnet."""


class ProbeProtocol(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The reference to the load balancer probe used by the load balancing rule."""

    TCP = "tcp"
    """Probe protocol is TCP."""
    HTTP = "http"
    """Probe protocol is HTTP."""
    HTTPS = "https"
    """Probe protocol is HTTPS."""


class Protocol(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The reference to the transport protocol used by the load balancing rule."""

    TCP = "tcp"
    """Transport protocol is TCP."""
    UDP = "udp"
    """Transport protocol is UDP."""


class PublicIPAddressVersion(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies whether the IP configuration's public IP is IPv4 or IPv6. Default is IPv4."""

    I_PV4 = "IPv4"
    """The IP configuration's public IP is IPv4."""
    I_PV6 = "IPv6"
    """The IP configuration's public IP is IPv6."""


class RestartKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The kind of restart to perform."""

    SIMULTANEOUS = "Simultaneous"
    """Restart all listed replicas at the same time."""


class RollingUpgradeMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The mode used to monitor health during a rolling upgrade. The values are Monitored, and
    UnmonitoredAuto.
    """

    MONITORED = "Monitored"
    """The upgrade will stop after completing each upgrade domain and automatically monitor health
    before proceeding."""
    UNMONITORED_AUTO = "UnmonitoredAuto"
    """The upgrade will proceed automatically without performing any health monitoring."""


class RuntimeFailureAction(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Cluster level definition for the compensating action to perform when a Monitored upgrade
    encounters monitoring policy or health policy violations.
    """

    ROLLBACK = "Rollback"
    """Indicates that a rollback of the upgrade will be performed by Service Fabric if the upgrade
    fails."""
    MANUAL = "Manual"
    """Indicates that a manual repair will need to be performed by the administrator if the upgrade
    fails. Service Fabric will not proceed to the next upgrade domain automatically."""


class RuntimeRollingUpgradeMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Cluster level definition for the mode used to monitor health during a rolling upgrade."""

    UNMONITORED_AUTO = "UnmonitoredAuto"
    """The upgrade will proceed automatically without performing any health monitoring."""
    UNMONITORED_MANUAL = "UnmonitoredManual"
    """The upgrade will stop after completing each upgrade domain, giving the opportunity to manually
    monitor health before proceeding."""
    MONITORED = "Monitored"
    """The upgrade will stop after completing each upgrade domain and automatically monitor health
    before proceeding."""


class RuntimeUpgradeKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Cluster level definition for the kind of upgrade."""

    ROLLING = "Rolling"
    """The upgrade progresses one upgrade domain at a time."""


class SecurityEncryptionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the securityEncryptionType type of the nodeType. Only DiskWithVMGuestState and
    VMGuestStateOnly are currently supported.
    """

    DISK_WITH_VM_GUEST_STATE = "DiskWithVMGuestState"
    """For encryption of the managed disk along with VMGuestState blob."""
    VM_GUEST_STATE_ONLY = "VMGuestStateOnly"
    """For encryption of just the VMGuestState blob."""


class SecurityType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the security type of the nodeType. Only Standard and TrustedLaunch are currently
    supported.
    """

    TRUSTED_LAUNCH = "TrustedLaunch"
    """Trusted Launch is a security type that secures generation 2 virtual machines."""
    STANDARD = "Standard"
    """Standard is the default security type for all machines."""
    CONFIDENTIAL_VM = "ConfidentialVM"
    """ConfidentialVM provides hardware-based encryption, trusted execution environment (TEE) and
    isolation of the VM memory & CPU from host."""


class ServiceCorrelationScheme(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The service correlation scheme."""

    ALIGNED_AFFINITY = "AlignedAffinity"
    """Aligned affinity ensures that the primaries of the partitions of the affinitized services are
    collocated on the same nodes. This is the default and is the same as selecting the Affinity
    scheme. The value is 0."""
    NON_ALIGNED_AFFINITY = "NonAlignedAffinity"
    """Non-Aligned affinity guarantees that all replicas of each service will be placed on the same
    nodes. Unlike Aligned Affinity, this does not guarantee that replicas of particular role will
    be collocated. The value is 1."""


class ServiceKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The kind of service (Stateless or Stateful)."""

    STATELESS = "Stateless"
    """Does not use Service Fabric to make its state highly available or reliable. The value is 0."""
    STATEFUL = "Stateful"
    """Uses Service Fabric to make its state or part of its state highly available and reliable. The
    value is 1."""


class ServiceLoadMetricWeight(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Determines the metric weight relative to the other metrics that are configured for this
    service. During runtime, if two metrics end up in conflict, the Cluster Resource Manager
    prefers the metric with the higher weight.
    """

    ZERO = "Zero"
    """Disables resource balancing for this metric. This value is zero."""
    LOW = "Low"
    """Specifies the metric weight of the service load as Low. The value is 1."""
    MEDIUM = "Medium"
    """Specifies the metric weight of the service load as Medium. The value is 2."""
    HIGH = "High"
    """Specifies the metric weight of the service load as High. The value is 3."""


class ServicePackageActivationMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The activation Mode of the service package."""

    SHARED_PROCESS = "SharedProcess"
    """Indicates the application package activation mode will use shared process."""
    EXCLUSIVE_PROCESS = "ExclusiveProcess"
    """Indicates the application package activation mode will use exclusive process."""


class ServicePlacementPolicyType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of placement policy for a service fabric service. Following are the possible values."""

    INVALID_DOMAIN = "InvalidDomain"
    """Indicates that the ServicePlacementPolicyDescription is of type
    ServicePlacementInvalidDomainPolicyDescription, which indicates that a particular fault or
    upgrade domain cannot be used for placement of this service. The value is 0."""
    REQUIRED_DOMAIN = "RequiredDomain"
    """Indicates that the ServicePlacementPolicyDescription is of type
    ServicePlacementRequireDomainDistributionPolicyDescription indicating that the replicas of the
    service must be placed in a specific domain. The value is 1."""
    PREFERRED_PRIMARY_DOMAIN = "PreferredPrimaryDomain"
    """Indicates that the ServicePlacementPolicyDescription is of type
    ServicePlacementPreferPrimaryDomainPolicyDescription, which indicates that if possible the
    Primary replica for the partitions of the service should be located in a particular domain as
    an optimization. The value is 2."""
    REQUIRED_DOMAIN_DISTRIBUTION = "RequiredDomainDistribution"
    """Indicates that the ServicePlacementPolicyDescription is of type
    ServicePlacementRequireDomainDistributionPolicyDescription, indicating that the system will
    disallow placement of any two replicas from the same partition in the same domain at any time.
    The value is 3."""
    NON_PARTIALLY_PLACE_SERVICE = "NonPartiallyPlaceService"
    """Indicates that the ServicePlacementPolicyDescription is of type
    ServicePlacementNonPartiallyPlaceServicePolicyDescription, which indicates that if possible all
    replicas of a particular partition of the service should be placed atomically. The value is 4."""


class ServiceScalingMechanismKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enumerates the ways that a service can be partitioned."""

    SCALE_PARTITION_INSTANCE_COUNT = "ScalePartitionInstanceCount"
    """Represents a scaling mechanism for adding or removing instances of stateless service partition.
    The value is 0."""
    ADD_REMOVE_INCREMENTAL_NAMED_PARTITION = "AddRemoveIncrementalNamedPartition"
    """Represents a scaling mechanism for adding or removing named partitions of a stateless service.
    The value is 1."""


class ServiceScalingTriggerKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enumerates the ways that a service can be partitioned."""

    AVERAGE_PARTITION_LOAD_TRIGGER = "AveragePartitionLoadTrigger"
    """Represents a scaling trigger related to an average load of a metric/resource of a partition.
    The value is 0."""
    AVERAGE_SERVICE_LOAD_TRIGGER = "AverageServiceLoadTrigger"
    """Represents a scaling policy related to an average load of a metric/resource of a service. The
    value is 1."""


class SfmcOperationStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Sfmc operation status."""

    CREATED = "Created"
    """Operation created."""
    STARTED = "Started"
    """Operation started."""
    SUCCEEDED = "Succeeded"
    """Operation succeeded."""
    FAILED = "Failed"
    """Operation failed."""
    ABORTED = "Aborted"
    """Operation aborted."""
    CANCELED = "Canceled"
    """Operation canceled."""


class SkuName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Sku Name."""

    BASIC = "Basic"
    """Basic requires a minimum of 3 nodes and allows only 1 node type."""
    STANDARD = "Standard"
    """Requires a minimum of 5 nodes and allows 1 or more node type."""


class UpdateType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the way the operation will be performed."""

    DEFAULT = "Default"
    """The operation will proceed in all specified nodes at the same time."""
    BY_UPGRADE_DOMAIN = "ByUpgradeDomain"
    """The operation will proceed one upgrade domain at a time, checking the health in between each to
    continue."""


class VmSetupAction(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """action to be performed on the vms before bootstrapping the service fabric runtime."""

    ENABLE_CONTAINERS = "EnableContainers"
    """Enable windows containers feature."""
    ENABLE_HYPER_V = "EnableHyperV"
    """Enables windows HyperV feature."""


class VmssExtensionSetupOrder(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Vm extension setup order."""

    BEFORE_SF_RUNTIME = "BeforeSFRuntime"
    """Indicates that the vm extension should run before the service fabric runtime starts."""


class ZonalUpdateMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Indicates the update mode for Cross Az clusters."""

    STANDARD = "Standard"
    """The cluster will use 5 upgrade domains for Cross Az Node types."""
    FAST = "Fast"
    """The cluster will use a maximum of 3 upgrade domains per zone instead of 5 for Cross Az Node
    types for faster deployments."""
