# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.resourcegraph.aio import ResourceGraphClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestResourceGraphGraphQueryOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ResourceGraphClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_graph_query_list_by_subscription(self, resource_group):
        response = self.client.graph_query.list_by_subscription(
            subscription_id="str",
            api_version="2021-03-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_graph_query_list(self, resource_group):
        response = self.client.graph_query.list(
            subscription_id="str",
            resource_group_name=resource_group.name,
            api_version="2021-03-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_graph_query_get(self, resource_group):
        response = await self.client.graph_query.get(
            subscription_id="str",
            resource_group_name=resource_group.name,
            resource_name="str",
            api_version="2021-03-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_graph_query_delete(self, resource_group):
        response = await self.client.graph_query.delete(
            subscription_id="str",
            resource_group_name=resource_group.name,
            resource_name="str",
            api_version="2021-03-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_graph_query_create_or_update(self, resource_group):
        response = await self.client.graph_query.create_or_update(
            subscription_id="str",
            resource_group_name=resource_group.name,
            resource_name="str",
            properties={
                "description": "str",
                "etag": "str",
                "id": "str",
                "location": "str",
                "name": "str",
                "query": "str",
                "resultKind": "str",
                "tags": {"str": "str"},
                "timeModified": "2020-02-20 00:00:00",
                "type": "str",
            },
            api_version="2021-03-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_graph_query_update(self, resource_group):
        response = await self.client.graph_query.update(
            subscription_id="str",
            resource_group_name=resource_group.name,
            resource_name="str",
            body={"description": "str", "etag": "str", "query": "str", "tags": {"str": "str"}},
            api_version="2021-03-01",
        )

        # please add some check logic here by yourself
        # ...
