# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Mapping, Optional, TYPE_CHECKING, Union, overload

from .. import _model_base
from .._model_base import rest_field

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class Catalog(_model_base.Model):
    """A catalog.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar name: Name of the catalog. Required.
    :vartype name: str
    """

    name: str = rest_field(visibility=["read"])
    """Name of the catalog. Required."""


class DevBox(_model_base.Model):  # pylint: disable=too-many-instance-attributes
    """A Dev Box.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar name: Display name for the Dev Box. Required.
    :vartype name: str
    :ivar project_name: Name of the project this Dev Box belongs to.
    :vartype project_name: str
    :ivar pool_name: The name of the Dev Box pool this machine belongs to. Required.
    :vartype pool_name: str
    :ivar hibernate_support: Indicates whether hibernate is enabled/disabled or unknown. Known
     values are: "Enabled", "Disabled", and "OsUnsupported".
    :vartype hibernate_support: str or ~azure.developer.devcenter.models.HibernateSupport
    :ivar provisioning_state: The current provisioning state of the Dev Box. Known values are:
     "Succeeded", "Failed", "Canceled", "Creating", "Deleting", "Updating", "Starting", "Stopping",
     "Provisioning", "ProvisionedWithWarning", "InGracePeriod", and "NotProvisioned".
    :vartype provisioning_state: str or ~azure.developer.devcenter.models.DevBoxProvisioningState
    :ivar action_state: The current action state of the Dev Box. This is state is based on previous
     action performed by user.
    :vartype action_state: str
    :ivar power_state: The current power state of the Dev Box. Known values are: "Unknown",
     "Running", "Deallocated", "PoweredOff", and "Hibernated".
    :vartype power_state: str or ~azure.developer.devcenter.models.PowerState
    :ivar unique_id: A unique identifier for the Dev Box. This is a GUID-formatted string (e.g.
     00000000-0000-0000-0000-000000000000).
    :vartype unique_id: str
    :ivar error: Provisioning or action error details. Populated only for error states.
    :vartype error: ~azure.developer.devcenter.models.Error
    :ivar location: Azure region where this Dev Box is located. This will be the same region as the
     Virtual Network it is attached to.
    :vartype location: str
    :ivar os_type: The operating system type of this Dev Box. "Windows"
    :vartype os_type: str or ~azure.developer.devcenter.models.OSType
    :ivar user: The AAD object id of the user this Dev Box is assigned to.
    :vartype user: str
    :ivar hardware_profile: Information about the Dev Box's hardware resources.
    :vartype hardware_profile: ~azure.developer.devcenter.models.HardwareProfile
    :ivar storage_profile: Storage settings for this Dev Box.
    :vartype storage_profile: ~azure.developer.devcenter.models.StorageProfile
    :ivar image_reference: Information about the image used for this Dev Box.
    :vartype image_reference: ~azure.developer.devcenter.models.ImageReference
    :ivar created_time: Creation time of this Dev Box.
    :vartype created_time: ~datetime.datetime
    :ivar local_administrator: Indicates whether the owner of the Dev Box is a local administrator.
     Known values are: "Enabled" and "Disabled".
    :vartype local_administrator: str or ~azure.developer.devcenter.models.LocalAdministratorStatus
    """

    name: str = rest_field(visibility=["read"])
    """Display name for the Dev Box. Required."""
    project_name: Optional[str] = rest_field(name="projectName", visibility=["read"])
    """Name of the project this Dev Box belongs to."""
    pool_name: str = rest_field(name="poolName", visibility=["read", "create"])
    """The name of the Dev Box pool this machine belongs to. Required."""
    hibernate_support: Optional[Union[str, "_models.HibernateSupport"]] = rest_field(
        name="hibernateSupport", visibility=["read"]
    )
    """Indicates whether hibernate is enabled/disabled or unknown. Known values are: \"Enabled\",
     \"Disabled\", and \"OsUnsupported\"."""
    provisioning_state: Optional[Union[str, "_models.DevBoxProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The current provisioning state of the Dev Box. Known values are: \"Succeeded\", \"Failed\",
     \"Canceled\", \"Creating\", \"Deleting\", \"Updating\", \"Starting\", \"Stopping\",
     \"Provisioning\", \"ProvisionedWithWarning\", \"InGracePeriod\", and \"NotProvisioned\"."""
    action_state: Optional[str] = rest_field(name="actionState", visibility=["read"])
    """The current action state of the Dev Box. This is state is based on previous
     action performed by user."""
    power_state: Optional[Union[str, "_models.PowerState"]] = rest_field(name="powerState", visibility=["read"])
    """The current power state of the Dev Box. Known values are: \"Unknown\", \"Running\",
     \"Deallocated\", \"PoweredOff\", and \"Hibernated\"."""
    unique_id: Optional[str] = rest_field(name="uniqueId", visibility=["read"])
    """A unique identifier for the Dev Box. This is a GUID-formatted string (e.g.
     00000000-0000-0000-0000-000000000000)."""
    error: Optional["_models.Error"] = rest_field(visibility=["read"])
    """Provisioning or action error details. Populated only for error states."""
    location: Optional[str] = rest_field(visibility=["read"])
    """Azure region where this Dev Box is located. This will be the same region as the
     Virtual Network it is attached to."""
    os_type: Optional[Union[str, "_models.OSType"]] = rest_field(name="osType", visibility=["read"])
    """The operating system type of this Dev Box. \"Windows\""""
    user: Optional[str] = rest_field(visibility=["read"])
    """The AAD object id of the user this Dev Box is assigned to."""
    hardware_profile: Optional["_models.HardwareProfile"] = rest_field(name="hardwareProfile", visibility=["read"])
    """Information about the Dev Box's hardware resources."""
    storage_profile: Optional["_models.StorageProfile"] = rest_field(name="storageProfile", visibility=["read"])
    """Storage settings for this Dev Box."""
    image_reference: Optional["_models.ImageReference"] = rest_field(name="imageReference", visibility=["read"])
    """Information about the image used for this Dev Box."""
    created_time: Optional[datetime.datetime] = rest_field(name="createdTime", visibility=["read"], format="rfc3339")
    """Creation time of this Dev Box."""
    local_administrator: Optional[Union[str, "_models.LocalAdministratorStatus"]] = rest_field(
        name="localAdministrator", visibility=["read", "create"]
    )
    """Indicates whether the owner of the Dev Box is a local administrator. Known values are:
     \"Enabled\" and \"Disabled\"."""

    @overload
    def __init__(
        self,
        *,
        pool_name: str,
        local_administrator: Optional[Union[str, "_models.LocalAdministratorStatus"]] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class DevBoxAction(_model_base.Model):
    """An action which will take place on a Dev Box.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar name: The name of the action. Required.
    :vartype name: str
    :ivar action_type: The action that will be taken. Required. "Stop"
    :vartype action_type: str or ~azure.developer.devcenter.models.DevBoxActionType
    :ivar source_id: The id of the resource which triggered this action. Required.
    :vartype source_id: str
    :ivar suspended_until: The earliest time that the action could occur (UTC).
    :vartype suspended_until: ~datetime.datetime
    :ivar next: Details about the next run of this action.
    :vartype next: ~azure.developer.devcenter.models.DevBoxNextAction
    """

    name: str = rest_field(visibility=["read"])
    """The name of the action. Required."""
    action_type: Union[str, "_models.DevBoxActionType"] = rest_field(name="actionType")
    """The action that will be taken. Required. \"Stop\""""
    source_id: str = rest_field(name="sourceId")
    """The id of the resource which triggered this action. Required."""
    suspended_until: Optional[datetime.datetime] = rest_field(name="suspendedUntil", format="rfc3339")
    """The earliest time that the action could occur (UTC)."""
    next: Optional["_models.DevBoxNextAction"] = rest_field()
    """Details about the next run of this action."""

    @overload
    def __init__(
        self,
        *,
        action_type: Union[str, "_models.DevBoxActionType"],
        source_id: str,
        suspended_until: Optional[datetime.datetime] = None,
        next: Optional["_models.DevBoxNextAction"] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class DevBoxActionDelayResult(_model_base.Model):
    """The action delay result.

    All required parameters must be populated in order to send to server.

    :ivar name: The name of the action. Required.
    :vartype name: str
    :ivar result: The result of the delay operation on this action. Required. Known values are:
     "Succeeded" and "Failed".
    :vartype result: str or ~azure.developer.devcenter.models.DevBoxActionDelayStatus
    :ivar action: The delayed action.
    :vartype action: ~azure.developer.devcenter.models.DevBoxAction
    :ivar error: Information about the error that occurred. Only populated on error.
    :vartype error: ~azure.developer.devcenter.models.Error
    """

    name: str = rest_field()
    """The name of the action. Required."""
    result: Union[str, "_models.DevBoxActionDelayStatus"] = rest_field()
    """The result of the delay operation on this action. Required. Known values are: \"Succeeded\" and
     \"Failed\"."""
    action: Optional["_models.DevBoxAction"] = rest_field()
    """The delayed action."""
    error: Optional["_models.Error"] = rest_field()
    """Information about the error that occurred. Only populated on error."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        result: Union[str, "_models.DevBoxActionDelayStatus"],
        action: Optional["_models.DevBoxAction"] = None,
        error: Optional["_models.Error"] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class DevBoxNextAction(_model_base.Model):
    """Details about the next run of an action.

    All required parameters must be populated in order to send to server.

    :ivar scheduled_time: The time the action will be triggered (UTC). Required.
    :vartype scheduled_time: ~datetime.datetime
    """

    scheduled_time: datetime.datetime = rest_field(name="scheduledTime", format="rfc3339")
    """The time the action will be triggered (UTC). Required."""

    @overload
    def __init__(
        self,
        *,
        scheduled_time: datetime.datetime,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class Environment(_model_base.Model):
    """Properties of an environment.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar parameters: Parameters object for the environment.
    :vartype parameters: dict[str, any]
    :ivar name: Environment name. Required.
    :vartype name: str
    :ivar environment_type: Environment type. Required.
    :vartype environment_type: str
    :ivar user: The AAD object id of the owner of this Environment.
    :vartype user: str
    :ivar provisioning_state: The provisioning state of the environment. Known values are:
     "Succeeded", "Failed", "Canceled", "Creating", "Accepted", "Deleting", "Updating", "Preparing",
     "Running", "Syncing", "MovingResources", "TransientFailure", and "StorageProvisioningFailed".
    :vartype provisioning_state: str or
     ~azure.developer.devcenter.models.EnvironmentProvisioningState
    :ivar resource_group_id: The identifier of the resource group containing the environment's
     resources.
    :vartype resource_group_id: str
    :ivar catalog_name: Name of the catalog. Required.
    :vartype catalog_name: str
    :ivar environment_definition_name: Name of the environment definition. Required.
    :vartype environment_definition_name: str
    :ivar error: Provisioning error details. Populated only for error states.
    :vartype error: ~azure.developer.devcenter.models.Error
    """

    parameters: Optional[Dict[str, Any]] = rest_field()
    """Parameters object for the environment."""
    name: str = rest_field(visibility=["read"])
    """Environment name. Required."""
    environment_type: str = rest_field(name="environmentType", visibility=["read", "create"])
    """Environment type. Required."""
    user: Optional[str] = rest_field(visibility=["read"])
    """The AAD object id of the owner of this Environment."""
    provisioning_state: Optional[Union[str, "_models.EnvironmentProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The provisioning state of the environment. Known values are: \"Succeeded\", \"Failed\",
     \"Canceled\", \"Creating\", \"Accepted\", \"Deleting\", \"Updating\", \"Preparing\",
     \"Running\", \"Syncing\", \"MovingResources\", \"TransientFailure\", and
     \"StorageProvisioningFailed\"."""
    resource_group_id: Optional[str] = rest_field(name="resourceGroupId", visibility=["read"])
    """The identifier of the resource group containing the environment's resources."""
    catalog_name: str = rest_field(name="catalogName", visibility=["read", "create"])
    """Name of the catalog. Required."""
    environment_definition_name: str = rest_field(name="environmentDefinitionName", visibility=["read", "create"])
    """Name of the environment definition. Required."""
    error: Optional["_models.Error"] = rest_field(visibility=["read"])
    """Provisioning error details. Populated only for error states."""

    @overload
    def __init__(
        self,
        *,
        environment_type: str,
        catalog_name: str,
        environment_definition_name: str,
        parameters: Optional[Dict[str, Any]] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class EnvironmentDefinition(_model_base.Model):
    """An environment definition.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: The ID of the environment definition. Required.
    :vartype id: str
    :ivar name: Name of the environment definition. Required.
    :vartype name: str
    :ivar catalog_name: Name of the catalog. Required.
    :vartype catalog_name: str
    :ivar description: A short description of the environment definition.
    :vartype description: str
    :ivar parameters: Input parameters passed to an environment.
    :vartype parameters: list[~azure.developer.devcenter.models.EnvironmentDefinitionParameter]
    :ivar parameters_schema: JSON schema defining the parameters object passed to an environment.
    :vartype parameters_schema: str
    :ivar template_path: Path to the Environment Definition entrypoint file.
    :vartype template_path: str
    """

    id: str = rest_field()
    """The ID of the environment definition. Required."""
    name: str = rest_field(visibility=["read"])
    """Name of the environment definition. Required."""
    catalog_name: str = rest_field(name="catalogName")
    """Name of the catalog. Required."""
    description: Optional[str] = rest_field()
    """A short description of the environment definition."""
    parameters: Optional[List["_models.EnvironmentDefinitionParameter"]] = rest_field()
    """Input parameters passed to an environment."""
    parameters_schema: Optional[str] = rest_field(name="parametersSchema")
    """JSON schema defining the parameters object passed to an environment."""
    template_path: Optional[str] = rest_field(name="templatePath")
    """Path to the Environment Definition entrypoint file."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        catalog_name: str,
        description: Optional[str] = None,
        parameters: Optional[List["_models.EnvironmentDefinitionParameter"]] = None,
        parameters_schema: Optional[str] = None,
        template_path: Optional[str] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class EnvironmentDefinitionParameter(_model_base.Model):
    """Properties of an Environment Definition parameter.

    All required parameters must be populated in order to send to server.

    :ivar id: Unique ID of the parameter. Required.
    :vartype id: str
    :ivar name: Display name of the parameter.
    :vartype name: str
    :ivar description: Description of the parameter.
    :vartype description: str
    :ivar default: Default value of the parameter.
    :vartype default: str
    :ivar type: A string of one of the basic JSON types (number, integer, array, object,
     boolean, string). Required. Known values are: "array", "boolean", "integer", "number",
     "object", and "string".
    :vartype type: str or ~azure.developer.devcenter.models.ParameterType
    :ivar read_only: Whether or not this parameter is read-only.  If true, default should have a
     value.
    :vartype read_only: bool
    :ivar required: Whether or not this parameter is required. Required.
    :vartype required: bool
    :ivar allowed: An array of allowed values.
    :vartype allowed: list[str]
    """

    id: str = rest_field()
    """Unique ID of the parameter. Required."""
    name: Optional[str] = rest_field()
    """Display name of the parameter."""
    description: Optional[str] = rest_field()
    """Description of the parameter."""
    default: Optional[str] = rest_field()
    """Default value of the parameter."""
    type: Union[str, "_models.ParameterType"] = rest_field()
    """A string of one of the basic JSON types (number, integer, array, object,
     boolean, string). Required. Known values are: \"array\", \"boolean\", \"integer\", \"number\",
     \"object\", and \"string\"."""
    read_only: Optional[bool] = rest_field(name="readOnly")
    """Whether or not this parameter is read-only.  If true, default should have a
     value."""
    required: bool = rest_field()
    """Whether or not this parameter is required. Required."""
    allowed: Optional[List[str]] = rest_field()
    """An array of allowed values."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        type: Union[str, "_models.ParameterType"],
        required: bool,
        name: Optional[str] = None,
        description: Optional[str] = None,
        default: Optional[str] = None,
        read_only: Optional[bool] = None,
        allowed: Optional[List[str]] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class EnvironmentType(_model_base.Model):
    """Properties of an environment type.

    All required parameters must be populated in order to send to server.

    :ivar name: Name of the environment type. Required.
    :vartype name: str
    :ivar deployment_target_id: Id of a subscription or management group that the environment type
     will be
     mapped to. The environment's resources will be deployed into this subscription
     or management group. Required.
    :vartype deployment_target_id: str
    :ivar status: Indicates whether this environment type is enabled for use in this project.
     Required. Known values are: "Enabled" and "Disabled".
    :vartype status: str or ~azure.developer.devcenter.models.EnvironmentTypeStatus
    """

    name: str = rest_field()
    """Name of the environment type. Required."""
    deployment_target_id: str = rest_field(name="deploymentTargetId")
    """Id of a subscription or management group that the environment type will be
     mapped to. The environment's resources will be deployed into this subscription
     or management group. Required."""
    status: Union[str, "_models.EnvironmentTypeStatus"] = rest_field()
    """Indicates whether this environment type is enabled for use in this project. Required. Known
     values are: \"Enabled\" and \"Disabled\"."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        deployment_target_id: str,
        status: Union[str, "_models.EnvironmentTypeStatus"],
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class Error(_model_base.Model):
    """The error object.

    All required parameters must be populated in order to send to server.

    :ivar code: One of a server-defined set of error codes. Required.
    :vartype code: str
    :ivar message: A human-readable representation of the error. Required.
    :vartype message: str
    :ivar target: The target of the error.
    :vartype target: str
    :ivar details: An array of details about specific errors that led to this reported error.
    :vartype details: list[~azure.developer.devcenter.models.Error]
    :ivar innererror: An object containing more specific information than the current object about
     the error.
    :vartype innererror: ~azure.developer.devcenter.models.InnerError
    """

    code: str = rest_field()
    """One of a server-defined set of error codes. Required."""
    message: str = rest_field()
    """A human-readable representation of the error. Required."""
    target: Optional[str] = rest_field()
    """The target of the error."""
    details: Optional[List["_models.Error"]] = rest_field()
    """An array of details about specific errors that led to this reported error."""
    innererror: Optional["_models.InnerError"] = rest_field()
    """An object containing more specific information than the current object about the error."""

    @overload
    def __init__(
        self,
        *,
        code: str,
        message: str,
        target: Optional[str] = None,
        details: Optional[List["_models.Error"]] = None,
        innererror: Optional["_models.InnerError"] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class HardwareProfile(_model_base.Model):
    """Hardware specifications for the Dev Box.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar sku_name: The name of the SKU. Known values are: "general_i_8c32gb256ssd_v2",
     "general_i_8c32gb512ssd_v2", "general_i_8c32gb1024ssd_v2", "general_i_8c32gb2048ssd_v2",
     "general_i_16c64gb256ssd_v2", "general_i_16c64gb512ssd_v2", "general_i_16c64gb1024ssd_v2",
     "general_i_16c64gb2048ssd_v2", "general_i_32c128gb512ssd_v2", "general_i_32c128gb1024ssd_v2",
     "general_i_32c128gb2048ssd_v2", "general_a_8c32gb256ssd_v2", "general_a_8c32gb512ssd_v2",
     "general_a_8c32gb1024ssd_v2", "general_a_8c32gb2048ssd_v2", "general_a_16c64gb256ssd_v2",
     "general_a_16c64gb512ssd_v2", "general_a_16c64gb1024ssd_v2", "general_a_16c64gb2048ssd_v2",
     "general_a_32c128gb512ssd_v2", "general_a_32c128gb1024ssd_v2", and
     "general_a_32c128gb2048ssd_v2".
    :vartype sku_name: str or ~azure.developer.devcenter.models.SkuName
    :ivar vcpus: The number of vCPUs available for the Dev Box.
    :vartype vcpus: int
    :ivar memory_gb: The amount of memory available for the Dev Box.
    :vartype memory_gb: int
    """

    sku_name: Optional[Union[str, "_models.SkuName"]] = rest_field(name="skuName", visibility=["read"])
    """The name of the SKU. Known values are: \"general_i_8c32gb256ssd_v2\",
     \"general_i_8c32gb512ssd_v2\", \"general_i_8c32gb1024ssd_v2\", \"general_i_8c32gb2048ssd_v2\",
     \"general_i_16c64gb256ssd_v2\", \"general_i_16c64gb512ssd_v2\",
     \"general_i_16c64gb1024ssd_v2\", \"general_i_16c64gb2048ssd_v2\",
     \"general_i_32c128gb512ssd_v2\", \"general_i_32c128gb1024ssd_v2\",
     \"general_i_32c128gb2048ssd_v2\", \"general_a_8c32gb256ssd_v2\", \"general_a_8c32gb512ssd_v2\",
     \"general_a_8c32gb1024ssd_v2\", \"general_a_8c32gb2048ssd_v2\", \"general_a_16c64gb256ssd_v2\",
     \"general_a_16c64gb512ssd_v2\", \"general_a_16c64gb1024ssd_v2\",
     \"general_a_16c64gb2048ssd_v2\", \"general_a_32c128gb512ssd_v2\",
     \"general_a_32c128gb1024ssd_v2\", and \"general_a_32c128gb2048ssd_v2\"."""
    vcpus: Optional[int] = rest_field(name="vCPUs", visibility=["read"])
    """The number of vCPUs available for the Dev Box."""
    memory_gb: Optional[int] = rest_field(name="memoryGB", visibility=["read"])
    """The amount of memory available for the Dev Box."""


class ImageReference(_model_base.Model):
    """Specifies information about the image used.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the image used.
    :vartype name: str
    :ivar version: The version of the image.
    :vartype version: str
    :ivar operating_system: The operating system of the image.
    :vartype operating_system: str
    :ivar os_build_number: The operating system build number of the image.
    :vartype os_build_number: str
    :ivar published_date: The datetime that the backing image version was published.
    :vartype published_date: ~datetime.datetime
    """

    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the image used."""
    version: Optional[str] = rest_field(visibility=["read"])
    """The version of the image."""
    operating_system: Optional[str] = rest_field(name="operatingSystem", visibility=["read"])
    """The operating system of the image."""
    os_build_number: Optional[str] = rest_field(name="osBuildNumber", visibility=["read"])
    """The operating system build number of the image."""
    published_date: Optional[datetime.datetime] = rest_field(
        name="publishedDate", visibility=["read"], format="rfc3339"
    )
    """The datetime that the backing image version was published."""


class InnerError(_model_base.Model):
    """An object containing more specific information about the error. As per Microsoft One API
    guidelines -
    https://github.com/Microsoft/api-guidelines/blob/vNext/Guidelines.md#7102-error-condition-responses.

    :ivar code: One of a server-defined set of error codes.
    :vartype code: str
    :ivar innererror: Inner error.
    :vartype innererror: ~azure.developer.devcenter.models.InnerError
    """

    code: Optional[str] = rest_field()
    """One of a server-defined set of error codes."""
    innererror: Optional["_models.InnerError"] = rest_field()
    """Inner error."""

    @overload
    def __init__(
        self,
        *,
        code: Optional[str] = None,
        innererror: Optional["_models.InnerError"] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class OperationDetails(_model_base.Model):
    """The current status of an async operation.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified ID for the operation status. Required.
    :vartype id: str
    :ivar name: The operation id name. Required.
    :vartype name: str
    :ivar status: Provisioning state of the resource. Required. Known values are: "NotStarted",
     "Running", "Succeeded", "Failed", and "Canceled".
    :vartype status: str or ~azure.developer.devcenter.models.OperationStatus
    :ivar resource_id: The id of the resource.
    :vartype resource_id: str
    :ivar start_time: The start time of the operation.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The end time of the operation.
    :vartype end_time: ~datetime.datetime
    :ivar percent_complete: Percent of the operation that is complete.
    :vartype percent_complete: float
    :ivar properties: Custom operation properties, populated only for a successful operation.
    :vartype properties: any
    :ivar error: Operation Error message.
    :vartype error: ~azure.developer.devcenter.models.Error
    """

    id: str = rest_field(visibility=["read"])
    """Fully qualified ID for the operation status. Required."""
    name: str = rest_field(visibility=["read"])
    """The operation id name. Required."""
    status: Union[str, "_models.OperationStatus"] = rest_field()
    """Provisioning state of the resource. Required. Known values are: \"NotStarted\", \"Running\",
     \"Succeeded\", \"Failed\", and \"Canceled\"."""
    resource_id: Optional[str] = rest_field(name="resourceId")
    """The id of the resource."""
    start_time: Optional[datetime.datetime] = rest_field(name="startTime", format="rfc3339")
    """The start time of the operation."""
    end_time: Optional[datetime.datetime] = rest_field(name="endTime", format="rfc3339")
    """The end time of the operation."""
    percent_complete: Optional[float] = rest_field(name="percentComplete")
    """Percent of the operation that is complete."""
    properties: Optional[Any] = rest_field()
    """Custom operation properties, populated only for a successful operation."""
    error: Optional["_models.Error"] = rest_field()
    """Operation Error message."""

    @overload
    def __init__(
        self,
        *,
        status: Union[str, "_models.OperationStatus"],
        resource_id: Optional[str] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        percent_complete: Optional[float] = None,
        properties: Optional[Any] = None,
        error: Optional["_models.Error"] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class OSDisk(_model_base.Model):
    """Settings for the operating system disk.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar disk_size_gb: The size of the OS Disk in gigabytes.
    :vartype disk_size_gb: int
    """

    disk_size_gb: Optional[int] = rest_field(name="diskSizeGB", visibility=["read"])
    """The size of the OS Disk in gigabytes."""


class Pool(_model_base.Model):
    """A pool of Dev Boxes.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar name: Pool name. Required.
    :vartype name: str
    :ivar location: Azure region where Dev Boxes in the pool are located. Required.
    :vartype location: str
    :ivar os_type: The operating system type of Dev Boxes in this pool. "Windows"
    :vartype os_type: str or ~azure.developer.devcenter.models.OSType
    :ivar hardware_profile: Hardware settings for the Dev Boxes created in this pool.
    :vartype hardware_profile: ~azure.developer.devcenter.models.HardwareProfile
    :ivar hibernate_support: Indicates whether hibernate is enabled/disabled or unknown. Known
     values are: "Enabled", "Disabled", and "OsUnsupported".
    :vartype hibernate_support: str or ~azure.developer.devcenter.models.HibernateSupport
    :ivar storage_profile: Storage settings for Dev Box created in this pool.
    :vartype storage_profile: ~azure.developer.devcenter.models.StorageProfile
    :ivar image_reference: Image settings for Dev Boxes create in this pool.
    :vartype image_reference: ~azure.developer.devcenter.models.ImageReference
    :ivar local_administrator: Indicates whether owners of Dev Boxes in this pool are local
     administrators on
     the Dev Boxes. Known values are: "Enabled" and "Disabled".
    :vartype local_administrator: str or ~azure.developer.devcenter.models.LocalAdministratorStatus
    :ivar stop_on_disconnect: Stop on disconnect configuration settings for Dev Boxes created in
     this pool.
    :vartype stop_on_disconnect: ~azure.developer.devcenter.models.StopOnDisconnectConfiguration
    :ivar health_status: Overall health status of the Pool. Indicates whether or not the Pool is
     available to create Dev Boxes. Required. Known values are: "Unknown", "Pending", "Healthy",
     "Warning", and "Unhealthy".
    :vartype health_status: str or ~azure.developer.devcenter.models.PoolHealthStatus
    """

    name: str = rest_field(visibility=["read"])
    """Pool name. Required."""
    location: str = rest_field()
    """Azure region where Dev Boxes in the pool are located. Required."""
    os_type: Optional[Union[str, "_models.OSType"]] = rest_field(name="osType")
    """The operating system type of Dev Boxes in this pool. \"Windows\""""
    hardware_profile: Optional["_models.HardwareProfile"] = rest_field(name="hardwareProfile")
    """Hardware settings for the Dev Boxes created in this pool."""
    hibernate_support: Optional[Union[str, "_models.HibernateSupport"]] = rest_field(name="hibernateSupport")
    """Indicates whether hibernate is enabled/disabled or unknown. Known values are: \"Enabled\",
     \"Disabled\", and \"OsUnsupported\"."""
    storage_profile: Optional["_models.StorageProfile"] = rest_field(name="storageProfile")
    """Storage settings for Dev Box created in this pool."""
    image_reference: Optional["_models.ImageReference"] = rest_field(name="imageReference")
    """Image settings for Dev Boxes create in this pool."""
    local_administrator: Optional[Union[str, "_models.LocalAdministratorStatus"]] = rest_field(
        name="localAdministrator"
    )
    """Indicates whether owners of Dev Boxes in this pool are local administrators on
     the Dev Boxes. Known values are: \"Enabled\" and \"Disabled\"."""
    stop_on_disconnect: Optional["_models.StopOnDisconnectConfiguration"] = rest_field(name="stopOnDisconnect")
    """Stop on disconnect configuration settings for Dev Boxes created in this pool."""
    health_status: Union[str, "_models.PoolHealthStatus"] = rest_field(name="healthStatus")
    """Overall health status of the Pool. Indicates whether or not the Pool is
     available to create Dev Boxes. Required. Known values are: \"Unknown\", \"Pending\",
     \"Healthy\", \"Warning\", and \"Unhealthy\"."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        health_status: Union[str, "_models.PoolHealthStatus"],
        os_type: Optional[Union[str, "_models.OSType"]] = None,
        hardware_profile: Optional["_models.HardwareProfile"] = None,
        hibernate_support: Optional[Union[str, "_models.HibernateSupport"]] = None,
        storage_profile: Optional["_models.StorageProfile"] = None,
        image_reference: Optional["_models.ImageReference"] = None,
        local_administrator: Optional[Union[str, "_models.LocalAdministratorStatus"]] = None,
        stop_on_disconnect: Optional["_models.StopOnDisconnectConfiguration"] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class Project(_model_base.Model):
    """Project details.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar name: Name of the project. Required.
    :vartype name: str
    :ivar description: Description of the project.
    :vartype description: str
    :ivar max_dev_boxes_per_user: When specified, indicates the maximum number of Dev Boxes a
     single user can
     create across all pools in the project.
    :vartype max_dev_boxes_per_user: int
    """

    name: str = rest_field(visibility=["read"])
    """Name of the project. Required."""
    description: Optional[str] = rest_field()
    """Description of the project."""
    max_dev_boxes_per_user: Optional[int] = rest_field(name="maxDevBoxesPerUser")
    """When specified, indicates the maximum number of Dev Boxes a single user can
     create across all pools in the project."""

    @overload
    def __init__(
        self,
        *,
        description: Optional[str] = None,
        max_dev_boxes_per_user: Optional[int] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class RemoteConnection(_model_base.Model):
    """Provides remote connection information for a Dev Box.

    :ivar web_url: URL to open a browser based RDP session.
    :vartype web_url: str
    :ivar rdp_connection_url: Link to open a Remote Desktop session.
    :vartype rdp_connection_url: str
    """

    web_url: Optional[str] = rest_field(name="webUrl")
    """URL to open a browser based RDP session."""
    rdp_connection_url: Optional[str] = rest_field(name="rdpConnectionUrl")
    """Link to open a Remote Desktop session."""

    @overload
    def __init__(
        self,
        *,
        web_url: Optional[str] = None,
        rdp_connection_url: Optional[str] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class Schedule(_model_base.Model):
    """A Schedule to execute action.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar name: Display name for the Schedule. Required.
    :vartype name: str
    :ivar type: Supported type this scheduled task represents. Required. "StopDevBox"
    :vartype type: str or ~azure.developer.devcenter.models.ScheduledType
    :ivar frequency: The frequency of this scheduled task. Required. "Daily"
    :vartype frequency: str or ~azure.developer.devcenter.models.ScheduledFrequency
    :ivar time: The target time to trigger the action. The format is HH:MM. Required.
    :vartype time: str
    :ivar time_zone: The IANA timezone id at which the schedule should execute. Required.
    :vartype time_zone: str
    """

    name: str = rest_field(visibility=["read"])
    """Display name for the Schedule. Required."""
    type: Union[str, "_models.ScheduledType"] = rest_field()
    """Supported type this scheduled task represents. Required. \"StopDevBox\""""
    frequency: Union[str, "_models.ScheduledFrequency"] = rest_field()
    """The frequency of this scheduled task. Required. \"Daily\""""
    time: str = rest_field()
    """The target time to trigger the action. The format is HH:MM. Required."""
    time_zone: str = rest_field(name="timeZone")
    """The IANA timezone id at which the schedule should execute. Required."""

    @overload
    def __init__(
        self,
        *,
        type: Union[str, "_models.ScheduledType"],
        frequency: Union[str, "_models.ScheduledFrequency"],
        time: str,
        time_zone: str,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class StopOnDisconnectConfiguration(_model_base.Model):
    """Stop on disconnect configuration settings for Dev Boxes created in this pool.

    All required parameters must be populated in order to send to server.

    :ivar status: Indicates whether the feature to stop the devbox on disconnect once the grace
     period has lapsed is enabled. Required. Known values are: "Enabled" and "Disabled".
    :vartype status: str or ~azure.developer.devcenter.models.StopOnDisconnectStatus
    :ivar grace_period_minutes: The specified time in minutes to wait before stopping a Dev Box
     once disconnect
     is detected.
    :vartype grace_period_minutes: int
    """

    status: Union[str, "_models.StopOnDisconnectStatus"] = rest_field()
    """Indicates whether the feature to stop the devbox on disconnect once the grace
     period has lapsed is enabled. Required. Known values are: \"Enabled\" and \"Disabled\"."""
    grace_period_minutes: Optional[int] = rest_field(name="gracePeriodMinutes")
    """The specified time in minutes to wait before stopping a Dev Box once disconnect
     is detected."""

    @overload
    def __init__(
        self,
        *,
        status: Union[str, "_models.StopOnDisconnectStatus"],
        grace_period_minutes: Optional[int] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class StorageProfile(_model_base.Model):
    """Storage settings for the Dev Box's disks.

    :ivar os_disk: Settings for the operating system disk.
    :vartype os_disk: ~azure.developer.devcenter.models.OSDisk
    """

    os_disk: Optional["_models.OSDisk"] = rest_field(name="osDisk")
    """Settings for the operating system disk."""

    @overload
    def __init__(
        self,
        *,
        os_disk: Optional["_models.OSDisk"] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)
