<?php

/**
 * UTF-8 array of common special characters
 *
 * This array should contain all special characters (not a letter or digit)
 * defined in the various local charsets - it's not a complete list of non-alphanum
 * characters in UTF-8. It's not perfect but should match most cases of special
 * chars.
 *
 * The controlchars 0x00 to 0x19 are _not_ included in this array. The space 0x20 is!
 * These chars are _not_ in the array either:  _ (0x5f), : 0x3a, . 0x2e, - 0x2d, * 0x2a
 *
 * @author Andreas Gohr <andi@splitbrain.org>
 * @see    \dokuwiki\Utf8\Clean::stripspecials()
 */

return [
    0x1a, // 
    0x1b, // 
    0x1c, // 
    0x1d, // 
    0x1e, // 
    0x1f, // 
    0x20, // <space>
    0x21, // !
    0x22, // "
    0x23, // #
    0x24, // $
    0x25, // %
    0x26, // &
    0x27, // '
    0x28, // (
    0x29, // )
    0x2b, // +
    0x2c, // ,
    0x2f, // /
    0x3b, // ;
    0x3c, // <
    0x3d, // =
    0x3e, // >
    0x3f, // ?
    0x40, // @
    0x5b, // [
    0x5c, // \
    0x5d, // ]
    0x5e, // ^
    0x60, // `
    0x7b, // {
    0x7c, // |
    0x7d, // }
    0x7e, // ~
    0x7f, // 
    0x80, // 
    0x81, // 
    0x82, // 
    0x83, // 
    0x84, // 
    0x85, // 
    0x86, // 
    0x87, // 
    0x88, // 
    0x89, // 
    0x8a, // 
    0x8b, // 
    0x8c, // 
    0x8d, // 
    0x8e, // 
    0x8f, // 
    0x90, // 
    0x91, // 
    0x92, // 
    0x93, // 
    0x94, // 
    0x95, // 
    0x96, // 
    0x97, // 
    0x98, // 
    0x99, // 
    0x9a, // 
    0x9b, // 
    0x9c, // 
    0x9d, // 
    0x9e, // 
    0x9f, // 
    0xa0, //  
    0xa1, // ¡
    0xa2, // ¢
    0xa3, // £
    0xa4, // ¤
    0xa5, // ¥
    0xa6, // ¦
    0xa7, // §
    0xa8, // ¨
    0xa9, // ©
    0xaa, // ª
    0xab, // «
    0xac, // ¬
    0xad, // ­
    0xae, // ®
    0xaf, // ¯
    0xb0, // °
    0xb1, // ±
    0xb2, // ²
    0xb3, // ³
    0xb4, // ´
    0xb5, // µ
    0xb6, // ¶
    0xb7, // ·
    0xb8, // ¸
    0xb9, // ¹
    0xba, // º
    0xbb, // »
    0xbc, // ¼
    0xbd, // ½
    0xbe, // ¾
    0xbf, // ¿
    0xd7, // ×
    0xf7, // ÷
    0x2c7, // ˇ
    0x2d8, // ˘
    0x2d9, // ˙
    0x2da, // ˚
    0x2db, // ˛
    0x2dc, // ˜
    0x2dd, // ˝
    0x300, // ̀
    0x301, // ́
    0x303, // ̃
    0x309, // ̉
    0x323, // ̣
    0x384, // ΄
    0x385, // ΅
    0x387, // ·
    0x5b0, // ְ
    0x5b1, // ֱ
    0x5b2, // ֲ
    0x5b3, // ֳ
    0x5b4, // ִ
    0x5b5, // ֵ
    0x5b6, // ֶ
    0x5b7, // ַ
    0x5b8, // ָ
    0x5b9, // ֹ
    0x5bb, // ֻ
    0x5bc, // ּ
    0x5bd, // ֽ
    0x5be, // ־
    0x5bf, // ֿ
    0x5c0, // ׀
    0x5c1, // ׁ
    0x5c2, // ׂ
    0x5c3, // ׃
    0x5f3, // ׳
    0x5f4, // ״
    0x60c, // ،
    0x61b, // ؛
    0x61f, // ؟
    0x640, // ـ
    0x64b, // ً
    0x64c, // ٌ
    0x64d, // ٍ
    0x64e, // َ
    0x64f, // ُ
    0x650, // ِ
    0x651, // ّ
    0x652, // ْ
    0x66a, // ٪
    0xe3f, // ฿
    0x200c, // ‌
    0x200d, // ‍
    0x200e, // ‎
    0x200f, // ‏
    0x2013, // –
    0x2014, // —
    0x2015, // ―
    0x2017, // ‗
    0x2018, // ‘
    0x2019, // ’
    0x201a, // ‚
    0x201c, // “
    0x201d, // ”
    0x201e, // „
    0x2020, // †
    0x2021, // ‡
    0x2022, // •
    0x2026, // …
    0x2030, // ‰
    0x2032, // ′
    0x2033, // ″
    0x2039, // ‹
    0x203a, // ›
    0x2044, // ⁄
    0x20a7, // ₧
    0x20aa, // ₪
    0x20ab, // ₫
    0x20ac, // €
    0x2116, // №
    0x2118, // ℘
    0x2122, // ™
    0x2126, // Ω
    0x2135, // ℵ
    0x2190, // ←
    0x2191, // ↑
    0x2192, // →
    0x2193, // ↓
    0x2194, // ↔
    0x2195, // ↕
    0x21b5, // ↵
    0x21d0, // ⇐
    0x21d1, // ⇑
    0x21d2, // ⇒
    0x21d3, // ⇓
    0x21d4, // ⇔
    0x2200, // ∀
    0x2202, // ∂
    0x2203, // ∃
    0x2205, // ∅
    0x2206, // ∆
    0x2207, // ∇
    0x2208, // ∈
    0x2209, // ∉
    0x220b, // ∋
    0x220f, // ∏
    0x2211, // ∑
    0x2212, // −
    0x2215, // ∕
    0x2217, // ∗
    0x2219, // ∙
    0x221a, // √
    0x221d, // ∝
    0x221e, // ∞
    0x2220, // ∠
    0x2227, // ∧
    0x2228, // ∨
    0x2229, // ∩
    0x222a, // ∪
    0x222b, // ∫
    0x2234, // ∴
    0x223c, // ∼
    0x2245, // ≅
    0x2248, // ≈
    0x2260, // ≠
    0x2261, // ≡
    0x2264, // ≤
    0x2265, // ≥
    0x2282, // ⊂
    0x2283, // ⊃
    0x2284, // ⊄
    0x2286, // ⊆
    0x2287, // ⊇
    0x2295, // ⊕
    0x2297, // ⊗
    0x22a5, // ⊥
    0x22c5, // ⋅
    0x2310, // ⌐
    0x2320, // ⌠
    0x2321, // ⌡
    0x2329, // 〈
    0x232a, // 〉
    0x2469, // ⑩
    0x2500, // ─
    0x2502, // │
    0x250c, // ┌
    0x2510, // ┐
    0x2514, // └
    0x2518, // ┘
    0x251c, // ├
    0x2524, // ┤
    0x252c, // ┬
    0x2534, // ┴
    0x253c, // ┼
    0x2550, // ═
    0x2551, // ║
    0x2552, // ╒
    0x2553, // ╓
    0x2554, // ╔
    0x2555, // ╕
    0x2556, // ╖
    0x2557, // ╗
    0x2558, // ╘
    0x2559, // ╙
    0x255a, // ╚
    0x255b, // ╛
    0x255c, // ╜
    0x255d, // ╝
    0x255e, // ╞
    0x255f, // ╟
    0x2560, // ╠
    0x2561, // ╡
    0x2562, // ╢
    0x2563, // ╣
    0x2564, // ╤
    0x2565, // ╥
    0x2566, // ╦
    0x2567, // ╧
    0x2568, // ╨
    0x2569, // ╩
    0x256a, // ╪
    0x256b, // ╫
    0x256c, // ╬
    0x2580, // ▀
    0x2584, // ▄
    0x2588, // █
    0x258c, // ▌
    0x2590, // ▐
    0x2591, // ░
    0x2592, // ▒
    0x2593, // ▓
    0x25a0, // ■
    0x25b2, // ▲
    0x25bc, // ▼
    0x25c6, // ◆
    0x25ca, // ◊
    0x25cf, // ●
    0x25d7, // ◗
    0x2605, // ★
    0x260e, // ☎
    0x261b, // ☛
    0x261e, // ☞
    0x2660, // ♠
    0x2663, // ♣
    0x2665, // ♥
    0x2666, // ♦
    0x2701, // ✁
    0x2702, // ✂
    0x2703, // ✃
    0x2704, // ✄
    0x2706, // ✆
    0x2707, // ✇
    0x2708, // ✈
    0x2709, // ✉
    0x270c, // ✌
    0x270d, // ✍
    0x270e, // ✎
    0x270f, // ✏
    0x2710, // ✐
    0x2711, // ✑
    0x2712, // ✒
    0x2713, // ✓
    0x2714, // ✔
    0x2715, // ✕
    0x2716, // ✖
    0x2717, // ✗
    0x2718, // ✘
    0x2719, // ✙
    0x271a, // ✚
    0x271b, // ✛
    0x271c, // ✜
    0x271d, // ✝
    0x271e, // ✞
    0x271f, // ✟
    0x2720, // ✠
    0x2721, // ✡
    0x2722, // ✢
    0x2723, // ✣
    0x2724, // ✤
    0x2725, // ✥
    0x2726, // ✦
    0x2727, // ✧
    0x2729, // ✩
    0x272a, // ✪
    0x272b, // ✫
    0x272c, // ✬
    0x272d, // ✭
    0x272e, // ✮
    0x272f, // ✯
    0x2730, // ✰
    0x2731, // ✱
    0x2732, // ✲
    0x2733, // ✳
    0x2734, // ✴
    0x2735, // ✵
    0x2736, // ✶
    0x2737, // ✷
    0x2738, // ✸
    0x2739, // ✹
    0x273a, // ✺
    0x273b, // ✻
    0x273c, // ✼
    0x273d, // ✽
    0x273e, // ✾
    0x273f, // ✿
    0x2740, // ❀
    0x2741, // ❁
    0x2742, // ❂
    0x2743, // ❃
    0x2744, // ❄
    0x2745, // ❅
    0x2746, // ❆
    0x2747, // ❇
    0x2748, // ❈
    0x2749, // ❉
    0x274a, // ❊
    0x274b, // ❋
    0x274d, // ❍
    0x274f, // ❏
    0x2750, // ❐
    0x2751, // ❑
    0x2752, // ❒
    0x2756, // ❖
    0x2758, // ❘
    0x2759, // ❙
    0x275a, // ❚
    0x275b, // ❛
    0x275c, // ❜
    0x275d, // ❝
    0x275e, // ❞
    0x2761, // ❡
    0x2762, // ❢
    0x2763, // ❣
    0x2764, // ❤
    0x2765, // ❥
    0x2766, // ❦
    0x2767, // ❧
    0x277f, // ❿
    0x2789, // ➉
    0x2793, // ➓
    0x2794, // ➔
    0x2798, // ➘
    0x2799, // ➙
    0x279a, // ➚
    0x279b, // ➛
    0x279c, // ➜
    0x279d, // ➝
    0x279e, // ➞
    0x279f, // ➟
    0x27a0, // ➠
    0x27a1, // ➡
    0x27a2, // ➢
    0x27a3, // ➣
    0x27a4, // ➤
    0x27a5, // ➥
    0x27a6, // ➦
    0x27a7, // ➧
    0x27a8, // ➨
    0x27a9, // ➩
    0x27aa, // ➪
    0x27ab, // ➫
    0x27ac, // ➬
    0x27ad, // ➭
    0x27ae, // ➮
    0x27af, // ➯
    0x27b1, // ➱
    0x27b2, // ➲
    0x27b3, // ➳
    0x27b4, // ➴
    0x27b5, // ➵
    0x27b6, // ➶
    0x27b7, // ➷
    0x27b8, // ➸
    0x27b9, // ➹
    0x27ba, // ➺
    0x27bb, // ➻
    0x27bc, // ➼
    0x27bd, // ➽
    0x27be, // ➾
    0x3000, // 　
    0x3001, // 、
    0x3002, // 。
    0x3003, // 〃
    0x3008, // 〈
    0x3009, // 〉
    0x300a, // 《
    0x300b, // 》
    0x300c, // 「
    0x300d, // 」
    0x300e, // 『
    0x300f, // 』
    0x3010, // 【
    0x3011, // 】
    0x3012, // 〒
    0x3014, // 〔
    0x3015, // 〕
    0x3016, // 〖
    0x3017, // 〗
    0x3018, // 〘
    0x3019, // 〙
    0x301a, // 〚
    0x301b, // 〛
    0x3036, // 〶
    0xf6d9, // 
    0xf6da, // 
    0xf6db, // 
    0xf8d7, // 
    0xf8d8, // 
    0xf8d9, // 
    0xf8da, // 
    0xf8db, // 
    0xf8dc, // 
    0xf8dd, // 
    0xf8de, // 
    0xf8df, // 
    0xf8e0, // 
    0xf8e1, // 
    0xf8e2, // 
    0xf8e3, // 
    0xf8e4, // 
    0xf8e5, // 
    0xf8e6, // 
    0xf8e7, // 
    0xf8e8, // 
    0xf8e9, // 
    0xf8ea, // 
    0xf8eb, // 
    0xf8ec, // 
    0xf8ed, // 
    0xf8ee, // 
    0xf8ef, // 
    0xf8f0, // 
    0xf8f1, // 
    0xf8f2, // 
    0xf8f3, // 
    0xf8f4, // 
    0xf8f5, // 
    0xf8f6, // 
    0xf8f7, // 
    0xf8f8, // 
    0xf8f9, // 
    0xf8fa, // 
    0xf8fb, // 
    0xf8fc, // 
    0xf8fd, // 
    0xf8fe, // 
    0xfe7c, // ﹼ
    0xfe7d, // ﹽ
    0xff01, // ！
    0xff02, // ＂
    0xff03, // ＃
    0xff04, // ＄
    0xff05, // ％
    0xff06, // ＆
    0xff07, // ＇
    0xff08, // （
    0xff09, // ）
    0xff09, // ）
    0xff0a, // ＊
    0xff0b, // ＋
    0xff0c, // ，
    0xff0d, // －
    0xff0e, // ．
    0xff0f, // ／
    0xff1a, // ：
    0xff1b, // ；
    0xff1c, // ＜
    0xff1d, // ＝
    0xff1e, // ＞
    0xff1f, // ？
    0xff20, // ＠
    0xff3b, // ［
    0xff3c, // ＼
    0xff3d, // ］
    0xff3e, // ＾
    0xff40, // ｀
    0xff5b, // ｛
    0xff5c, // ｜
    0xff5d, // ｝
    0xff5e, // ～
    0xff5f, // ｟
    0xff60, // ｠
    0xff61, // ｡
    0xff62, // ｢
    0xff63, // ｣
    0xff64, // ､
    0xff65, // ･
    0xffe0, // ￠
    0xffe1, // ￡
    0xffe2, // ￢
    0xffe3, // ￣
    0xffe4, // ￤
    0xffe5, // ￥
    0xffe6, // ￦
    0xffe8, // ￨
    0xffe9, // ￩
    0xffea, // ￪
    0xffeb, // ￫
    0xffec, // ￬
    0xffed, // ￭
    0xffee, // ￮
    0x1d6fc, // 𝛼
    0x1d6fd, // 𝛽
    0x1d6fe, // 𝛾
    0x1d6ff, // 𝛿
    0x1d700, // 𝜀
    0x1d701, // 𝜁
    0x1d702, // 𝜂
    0x1d703, // 𝜃
    0x1d704, // 𝜄
    0x1d705, // 𝜅
    0x1d706, // 𝜆
    0x1d707, // 𝜇
    0x1d708, // 𝜈
    0x1d709, // 𝜉
    0x1d70a, // 𝜊
    0x1d70b, // 𝜋
    0x1d70c, // 𝜌
    0x1d70d, // 𝜍
    0x1d70e, // 𝜎
    0x1d70f, // 𝜏
    0x1d710, // 𝜐
    0x1d711, // 𝜑
    0x1d712, // 𝜒
    0x1d713, // 𝜓
    0x1d714, // 𝜔
    0x1d715, // 𝜕
    0x1d716, // 𝜖
    0x1d717, // 𝜗
    0x1d718, // 𝜘
    0x1d719, // 𝜙
    0x1d71a, // 𝜚
    0x1d71b, // 𝜛
    0xc2a0, // 슠
    0xe28087, //
    0xe280af, //
    0xe281a0, //
    0xefbbbf, //
];
