#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2020 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Freelancer
# send your bug reports to vv221@dotslashplay.it
###

script_version=20251109.1

PLAYIT_COMPATIBILITY_LEVEL='2.33'

GAME_ID='freelancer'
GAME_NAME='Freelancer'

GAME_ID_DEMO="${GAME_ID}-demo"
GAME_NAME_DEMO="$GAME_NAME (demo)"

ARCHIVE_BASE_DEMO_EN_0_NAME='freelancer_demo.exe'
ARCHIVE_BASE_DEMO_EN_0_MD5='1af0a4cc730a64de9f6a6ecde30edc11'
ARCHIVE_BASE_DEMO_EN_0_TYPE='cabinet'
ARCHIVE_BASE_DEMO_EN_0_VERSION='1.0-archiveorg1'
ARCHIVE_BASE_DEMO_EN_0_SIZE='450000'
ARCHIVE_BASE_DEMO_EN_0_URL='https://archive.org/details/freelancer_demo'

CONTENT_PATH_DEFAULT='.'
## freelancer.exe requirements
CONTENT_LIBS_BIN_PATH='cab1'
CONTENT_LIBS_BIN_FILES='
exe/Common.dll
exe/DALib.dll
exe/Movie.dll
exe/DACOM.dll
exe/ImeUI.dll'
## DALib.dll requirements
CONTENT_LIBS0_BIN_PATH='cab1'
CONTENT_LIBS0_BIN_FILES='
exe/zlib.dll'
## A critical error is triggered on launch if the following library is missing.
CONTENT_LIBS1_BIN_PATH='cab1'
CONTENT_LIBS1_BIN_FILES='
exe/ebueula.dll'
## The game crashes on launch if any of the following libraries is missing.
CONTENT_LIBS2_BIN_PATH='cab1'
CONTENT_LIBS2_BIN_FILES='
exe/engbase.dll
exe/readfile.dll
exe/rendcomp.dll
exe/soundstreamer.dll
exe/system.dll'
## The game freezes before rendering the introduction videos if any of the following libraries is missing.
CONTENT_LIBS3_BIN_PATH='cab1'
CONTENT_LIBS3_BIN_FILES='
exe/alchemy.dll
exe/rp8.dll
exe/shading.dll
exe/x86math.dll'
## The game crashes before reaching the menu if any of the following libraries is missing.
CONTENT_LIBS4_BIN_PATH='cab1'
CONTENT_LIBS4_BIN_FILES='
exe/rpclocal.dll
exe/server.dll'
## The game freezes before reaching the menu if any of the following libraries is missing.
CONTENT_LIBS5_BIN_PATH='cab1'
CONTENT_LIBS5_BIN_FILES='
dlls/bin/content.dll
exe/thorn.dll'
## The game freezes when trying to enter the options menu or quit the game if the following library is missing.
CONTENT_LIBS6_BIN_PATH='cab1'
CONTENT_LIBS6_BIN_FILES='
exe/flmaterials.dll'
## 2D pictures are not displayed if the following library is missing.
CONTENT_LIBS7_BIN_PATH='cab1'
CONTENT_LIBS7_BIN_FILES='
exe/ximage.dll'
## Sound effects (outside of music) do not play if the following library is missing.
CONTENT_LIBS8_BIN_PATH='cab1'
CONTENT_LIBS8_BIN_FILES='
exe/soundmanager.dll'
## The in-game introduction fails to play if the following library is missing.
CONTENT_LIBS9_BIN_PATH='cab1'
CONTENT_LIBS9_BIN_FILES='
exe/deformable2.dll'
## These libraries are required to display text strings in menus and in-game.
CONTENT_LIBS_L10N_LIBS_PATH='cab1'
CONTENT_LIBS_L10N_LIBS_FILES='
exe/equipresources.dll
exe/infocards.dll
exe/misctext.dll
exe/misctextinfo2.dll
exe/nameresources.dll
exe/offerbriberesources.dll
exe/resources.dll
exe/serverresources.dll'
CONTENT_GAME_BIN_RELATIVE_PATH='game'
CONTENT_GAME_BIN_FILES='
exe/freelancer.exe'
CONTENT_GAME0_BIN_PATH='cab1'
CONTENT_GAME0_BIN_FILES='
exe/*.bmp
exe/*.exe
exe/*.fl
exe/*.hta
exe/*.ini
exe/*.txt'
CONTENT_GAME_L10N_PATH='cab1'
CONTENT_GAME_L10N_FILES='
data/audio/dialogue
data/audio/mixes
data/audio/sounds/ui/news_vendor_open.wav
data/audio/*.ini
data/audio/*.utf'
CONTENT_GAME0_L10N_PATH='cab2'
CONTENT_GAME0_L10N_FILES='
data/audio/dialogue
data/audio/mixes
data/audio/sounds/ui/news_vendor_open.wav
data/audio/*.ini
data/audio/*.utf'
CONTENT_FONTS_DATA_PATH='fonts'
CONTENT_FONTS_DATA_FILES='
agencyb.ttf
agencyr.ttf
arialuni.ttf'
CONTENT_GAME_DATA_FILES='
fl.ico'
CONTENT_GAME0_DATA_PATH='cab1'
CONTENT_GAME0_DATA_FILES='
data'
CONTENT_GAME1_DATA_PATH='cab2'
CONTENT_GAME1_DATA_FILES='
data'
CONTENT_DOC_DATA_FILES='
eula.rtf
readme.rtf'

WINE_PERSISTENT_DIRECTORIES='
users/${USER}/Documents/My Games/Freelancer Trial'
## Without a virtual desktop, loss of focus due to workspace switch can lead to loss of keyboard input.
## Keyboard input can then be restored when the mouse cursor leaves then re-enter the game window,
## but the game tries to trap the mouse in the game window.
## (WINE 10.0)
WINE_VIRTUAL_DESKTOP='1280x960'

APP_MAIN_EXE='exe/freelancer.exe'
APP_MAIN_ICON='fl.ico'

PACKAGES_LIST='
PKG_BIN
PKG_L10N
PKG_L10N_LIBS
PKG_DATA'

PKG_BIN_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_L10N_BASE
PKG_DATA'
PKG_BIN_DEPENDENCIES_GSTREAMER_PLUGINS='
deinterlace
video/x-ms-asf'

PKG_L10N_BASE_ID_DEMO="${GAME_ID_DEMO}-l10n"
PKG_L10N_ID_DEMO_EN="${PKG_L10N_BASE_ID_DEMO}-en"
PKG_L10N_PROVIDES_DEMO="
$PKG_L10N_BASE_ID_DEMO"
PKG_L10N_DESCRIPTION_DEMO_EN='English localisation'
PKG_L10N_DEPENDENCIES_SIBLINGS='
PKG_L10N_LIBS'

PKG_L10N_LIBS_ID_DEMO_EN="${PKG_L10N_ID_DEMO_EN}-libs"
PKG_L10N_LIBS_PROVIDES_DEMO="
${PKG_L10N_BASE_ID_DEMO}-libs"
PKG_L10N_LIBS_ARCH='32'
PKG_L10N_LIBS_DESCRIPTION_DEMO_EN="$PKG_L10N_DESCRIPTION_DEMO_EN - libraries"
## Prevent a fallback on PKG_L10N_DEPENDENCIES_SIBLINGS.
PKG_L10N_LIBS_DEPENDENCIES_SIBLINGS=' '

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_ID_DEMO="${GAME_ID_DEMO}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions.

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run default initialisation actions.

initialization_default "$@"

# Extract game data.

archive_extraction_default
ARCHIVE_INNER1_PATH="${PLAYIT_WORKDIR}/gamedata/$(content_path_default)/cab1.cab"
archive_extraction 'ARCHIVE_INNER1'
rm "$ARCHIVE_INNER1_PATH"
ARCHIVE_INNER2_PATH="${PLAYIT_WORKDIR}/gamedata/$(content_path_default)/cab2.cab"
archive_extraction 'ARCHIVE_INNER2'
rm "$ARCHIVE_INNER2_PATH"
## Rename a file with a truncated name.
mv \
	"${PLAYIT_WORKDIR}/gamedata/$(content_path 'GAME_BIN')/exe/freela_1.exe" \
	"${PLAYIT_WORKDIR}/gamedata/$(content_path 'GAME_BIN')/exe/freelancer.exe"

# Include game data.

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers.

## Install shipped libraries.
wineprefix_init_custom() {
	cat <<- EOF
	# Install shipped libraries.
	PATH_LIBRARIES_SYSTEM='$(path_libraries)'
	EOF
	cat <<- 'EOF'
	find "$PATH_LIBRARIES_SYSTEM" -iname '*.dll' | while read -r dll_source; do
		dll_destination="${PATH_PREFIX}${dll_source#"${PATH_LIBRARIES_SYSTEM}"}"
	    mkdir --parents "$(dirname "$dll_destination")"
	    ln --symbolic "$dll_source" "$dll_destination"
	done
	EOF
}

launchers_generation

# Build packages.

packages_generation
print_instructions

# Clean up.

working_directory_cleanup

exit 0
